/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromxtf;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.converter.SqlColumnConverter;
import ch.ehi.ili2db.fromili.CustomMapping;
import ch.ehi.ili2db.fromili.TransferFromIli;
import ch.ehi.ili2db.fromxtf.AbstractStructWrapper;
import ch.ehi.ili2db.fromxtf.BasketStat;
import ch.ehi.ili2db.fromxtf.ClassStat;
import ch.ehi.ili2db.fromxtf.EmbeddedLinkWrapper;
import ch.ehi.ili2db.fromxtf.FixIomObjectExtRefs;
import ch.ehi.ili2db.fromxtf.FromXtfRecordConverter;
import ch.ehi.ili2db.fromxtf.StructWrapper;
import ch.ehi.ili2db.fromxtf.XtfidPool;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.ehi.ili2db.toxtf.TransferToXtf;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.IomObjectSerializer;
import ch.ehi.iox.objpool.impl.Serializer;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.xtf.XtfWriter;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxDataPool;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.filter.Rounder;
import ch.interlis.iox_j.filter.TranslateToOrigin;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.ValidationConfig;
import ch.interlis.iox_j.validator.Validator;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TransferFromXtf {
    private NameMapping ili2sqlName = null;
    private HashMap tag2class = null;
    private HashSet unknownTypev = null;
    private TransferDescription td = null;
    private Connection conn = null;
    private CustomMapping customMapping = null;
    private String schema = null;
    private Timestamp today = null;
    private String dbusr = null;
    private SqlColumnConverter geomConv = null;
    private boolean createStdCols = false;
    private boolean createGenericStructRef = false;
    private boolean readIliTid = false;
    private boolean readIliBid = false;
    private boolean createBasketCol = false;
    private boolean createDatasetCol = false;
    private String xtffilename = null;
    private String attachmentKey = null;
    private boolean doItfLineTables = false;
    private boolean createItfLineTables = false;
    private boolean isItfReader = false;
    private int functionCode = 0;
    private String colT_ID = null;
    private DbIdGen idGen = null;
    private XtfidPool oidPool = null;
    private ObjectPoolManager recman = null;
    private Map<String, IomObject> objPool = null;
    private HashMap<String, HashSet<Long>> existingObjectsOfCurrentBasket = null;
    private ArrayList<FixIomObjectExtRefs> delayedObjects = null;
    private TrafoConfig trafoConfig = null;
    private FromXtfRecordConverter recConv = null;
    private Viewable2TableMapping class2wrapper = null;
    private TranslateToOrigin languageFilter = null;
    private Rounder rounder = null;
    private ArrayList<AbstractStructWrapper> structQueue = null;
    private Integer defaultCrsCode = null;
    private String srsModelAssignment = null;
    private Map<Element, Element> crsFilter = null;
    private boolean createImportTabs = false;
    private HashMap<Object, String> insertStmts = new HashMap();
    private HashMap<Object, String> updateStmts = new HashMap();

    public TransferFromXtf(int function, NameMapping ili2sqlName1, TransferDescription td1, Connection conn1, String dbusr1, SqlColumnConverter geomConv, DbIdGen idGen, Config config, TrafoConfig trafoConfig1, Viewable2TableMapping class2wrapper1) {
        this.ili2sqlName = ili2sqlName1;
        this.td = td1;
        this.conn = conn1;
        this.trafoConfig = trafoConfig1;
        this.dbusr = dbusr1;
        this.class2wrapper = class2wrapper1;
        if (this.dbusr == null || this.dbusr.length() == 0) {
            this.dbusr = System.getProperty("user.name");
        }
        this.schema = config.getDbschema();
        this.geomConv = geomConv;
        this.idGen = idGen;
        this.oidPool = new XtfidPool(idGen);
        this.createStdCols = "all".equals(config.getCreateStdCols());
        this.colT_ID = config.getColT_ID();
        if (this.colT_ID == null) {
            this.colT_ID = "T_Id";
        }
        if (config.getDefaultSrsCode() != null) {
            this.defaultCrsCode = Integer.parseInt(config.getDefaultSrsCode());
        }
        this.srsModelAssignment = config.getSrsModelAssignment();
        this.createGenericStructRef = "genericRef".equals(config.getStructMapping());
        this.readIliTid = config.isImportTid();
        this.readIliBid = config.isImportBid();
        this.createBasketCol = "readWrite".equals(config.getBasketHandling());
        this.createDatasetCol = "addDatasetCol".equals(config.getCreateDatasetCols());
        this.doItfLineTables = config.isItfTransferfile();
        boolean bl = this.createItfLineTables = this.doItfLineTables && config.getDoItfLineTables();
        if (this.createItfLineTables) {
            config.setValue("ch.interlis.iox_j.validator.doItfLinetables", "doItfLinetables");
        }
        this.createImportTabs = config.isCreateImportTabs();
        this.xtffilename = config.getXtffile();
        this.functionCode = function;
        if (!config.isVer3_translation() || config.getIli1Translation() != null) {
            this.languageFilter = new TranslateToOrigin(td1, (Settings)config);
        }
        if (config.getSrsModelAssignment() != null) {
            this.crsFilter = TransferFromIli.getSrsMappingToOriginal(this.td, config.getSrsModelAssignment());
        }
        this.rounder = config.isDisableRounding() ? null : new Rounder(this.td, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doit(IoxReader reader, Config config, Map<String, BasketStat> stat, CustomMapping customMapping1) throws IoxException, Ili2dbException {
        if (!(this.functionCode != 4 && this.functionCode != 6 || this.createBasketCol)) {
            throw new Ili2dbException("update/replace requires a basket column");
        }
        if (this.functionCode != 5 && this.readIliTid && !"property".equals(config.getTidHandling())) {
            throw new Ili2dbException("TID import requires a T_Ili_Tid column");
        }
        this.customMapping = customMapping1;
        HashSet<String> limitedToBids = null;
        String baskets = config.getBaskets();
        if (baskets != null) {
            String[] basketidv = baskets.split(";");
            limitedToBids = new HashSet<String>();
            for (String basketid : basketidv) {
                limitedToBids.add(basketid);
            }
        }
        HashSet<String> limitedToTopics = null;
        String topics = config.getTopics();
        if (topics != null) {
            String[] topicv = topics.split(";");
            limitedToTopics = new HashSet<String>();
            for (String topic : topicv) {
                limitedToTopics.add(topic);
            }
        }
        String datasetName = config.getDatasetName();
        Long datasetSqlId = null;
        this.today = new Timestamp(System.currentTimeMillis());
        this.tag2class = this.doItfLineTables ? ModelUtilities.getTagMap((TransferDescription)this.td) : XSDGenerator.getTagMap((TransferDescription)this.td);
        this.isItfReader = reader instanceof ItfReader;
        this.unknownTypev = new HashSet();
        this.structQueue = new ArrayList();
        boolean surfaceAsPolyline = true;
        boolean ignoreUnresolvedReferences = config.isSkipReferenceErrors();
        this.recman = new ObjectPoolManager();
        try {
            this.objPool = this.recman.newObjectPool((Serializer)new IomObjectSerializer());
            long importSqlId = 0L;
            long basketSqlId = 0L;
            long startTid = 0L;
            long endTid = 0L;
            long objCount = 0L;
            boolean referrs = false;
            this.recConv = new FromXtfRecordConverter(this.td, this.ili2sqlName, this.tag2class, config, this.idGen, this.geomConv, this.conn, this.dbusr, this.isItfReader, this.oidPool, this.trafoConfig, this.class2wrapper, datasetName, this.schema);
            if (this.functionCode == 5 || this.functionCode == 6) {
                if (datasetName == null) {
                    throw new Ili2dbException("delete/replace requires a dataset name");
                }
                datasetSqlId = Ili2db.getDatasetId(datasetName, this.conn, config);
                if (datasetSqlId == null) {
                    if (this.functionCode != 5 && this.functionCode == 6) {
                        datasetSqlId = this.oidPool.newObjSqlId();
                        try {
                            this.writeDataset(datasetSqlId, datasetName);
                            if (config.isCreateImportTabs()) {
                                importSqlId = this.writeImportStat(datasetSqlId, this.xtffilename, this.today, this.dbusr);
                            }
                        }
                        catch (SQLException e) {
                            EhiLogger.logError((Throwable)e);
                        }
                        catch (ConverterException e) {
                            EhiLogger.logError((Throwable)e);
                        }
                    }
                } else {
                    this.deleteObjectsOfExistingDataset(datasetSqlId, config);
                    if (this.functionCode == 5) {
                        String sqlName = "T_ILI2DB_DATASET";
                        if (this.schema != null) {
                            sqlName = this.schema + "." + sqlName;
                        }
                        Object getstmt = null;
                        try {
                            String stmt = "DELETE FROM " + sqlName + " WHERE " + this.colT_ID + "= ?";
                            EhiLogger.traceBackendCmd((String)stmt);
                            getstmt = this.conn.prepareStatement(stmt);
                            getstmt.setLong(1, datasetSqlId);
                            getstmt.executeUpdate();
                        }
                        catch (SQLException ex) {
                            throw new Ili2dbException("failed to delete from " + sqlName, ex);
                        }
                        finally {
                            if (getstmt != null) {
                                try {
                                    getstmt.close();
                                    getstmt = null;
                                }
                                catch (SQLException ex) {
                                    EhiLogger.logError((Throwable)ex);
                                }
                            }
                        }
                    }
                    if (config.isCreateImportTabs()) {
                        try {
                            importSqlId = this.writeImportStat(datasetSqlId, this.xtffilename, this.today, this.dbusr);
                        }
                        catch (SQLException e) {
                            EhiLogger.logError((Throwable)e);
                        }
                        catch (ConverterException e) {
                            EhiLogger.logError((Throwable)e);
                        }
                    }
                }
            } else if (this.functionCode == 4) {
                if (datasetName == null) {
                    throw new Ili2dbException("update requires a dataset name");
                }
                try {
                    datasetSqlId = Ili2db.getDatasetId(datasetName, this.conn, config);
                    if (datasetSqlId == null) {
                        datasetSqlId = this.oidPool.newObjSqlId();
                        this.writeDataset(datasetSqlId, datasetName);
                    }
                    if (config.isCreateImportTabs()) {
                        importSqlId = this.writeImportStat(datasetSqlId, this.xtffilename, this.today, this.dbusr);
                    }
                }
                catch (SQLException e) {
                    EhiLogger.logError((Throwable)e);
                }
                catch (ConverterException e) {
                    EhiLogger.logError((Throwable)e);
                }
            } else if (this.functionCode == 1) {
                try {
                    if (datasetName == null) {
                        datasetSqlId = this.oidPool.newObjSqlId();
                        datasetName = this.xtffilename != null ? new File(this.xtffilename).getName() + "-" + Long.toString(datasetSqlId) : Long.toString(datasetSqlId);
                    } else {
                        datasetSqlId = Ili2db.getDatasetId(datasetName, this.conn, config);
                        if (datasetSqlId != null) {
                            throw new Ili2dbException("dataset " + datasetName + " already exists");
                        }
                        datasetSqlId = this.oidPool.newObjSqlId();
                    }
                    if ("data".equals(config.getDeleteMode())) {
                        EhiLogger.logState((String)"delete existing data...");
                        HashSet<DbTableName> tables = new HashSet<DbTableName>();
                        for (Viewable viewable : this.class2wrapper.getViewables()) {
                            ViewableWrapper wrapper = this.class2wrapper.get(viewable);
                            DbTableName sqltableName = wrapper.getSqlTable();
                            if (tables.contains(sqltableName)) continue;
                            tables.add(sqltableName);
                            if (!this.customMapping.tableExists(this.conn, sqltableName)) continue;
                            this.deleteExistingObjectsHelper(sqltableName, null);
                        }
                        DbTableName sqltableName = new DbTableName(this.schema, "T_ILI2DB_DATASET");
                        if (this.customMapping.tableExists(this.conn, sqltableName)) {
                            this.deleteExistingObjectsHelper(sqltableName, null);
                        }
                        if (this.customMapping.tableExists(this.conn, sqltableName = new DbTableName(this.schema, "T_ILI2DB_BASKET"))) {
                            this.deleteExistingObjectsHelper(sqltableName, null);
                        }
                    }
                    this.writeDataset(datasetSqlId, datasetName);
                    if (config.isCreateImportTabs()) {
                        importSqlId = this.writeImportStat(datasetSqlId, this.xtffilename, this.today, this.dbusr);
                    }
                }
                catch (SQLException e) {
                    EhiLogger.logError((Throwable)e);
                }
                catch (ConverterException e) {
                    EhiLogger.logError((Throwable)e);
                }
            } else {
                throw new IllegalArgumentException("unexpected function code " + this.functionCode);
            }
            if (this.functionCode == 5) {
                return;
            }
            if (reader instanceof ItfReader) {
                ((ItfReader)reader).setBidPrefix(datasetName);
            } else if (reader instanceof ItfReader2) {
                ((ItfReader2)reader).setBidPrefix(datasetName);
            }
            Validator validator = null;
            if (config.isValidation()) {
                ValidationConfig modelConfig = new ValidationConfig();
                modelConfig.mergeIliMetaAttrs(this.td);
                String configFilename = config.getValidConfigFile();
                if (configFilename != null) {
                    try {
                        modelConfig.mergeConfigFile(new File(configFilename));
                    }
                    catch (IOException e) {
                        EhiLogger.logError((String)("failed to read validator config file <" + configFilename + ">"));
                    }
                }
                modelConfig.setConfigValue("PARAMETER", "areaOverlapValidation", config.isDisableAreaValidation() ? "off" : null);
                modelConfig.setConfigValue("PARAMETER", "defaultGeometryTypeValidation", config.isSkipGeometryErrors() ? "off" : null);
                modelConfig.setConfigValue("PARAMETER", "allowOnlyMultiplicityReduction", config.isOnlyMultiplicityReduction() ? "on" : null);
                if (this.rounder == null) {
                    modelConfig.setConfigValue("PARAMETER", "disableRounding", "true");
                }
                Log2EhiLogger errHandler = new Log2EhiLogger();
                LogEventFactory errFactory = new LogEventFactory();
                errFactory.setDataSource(this.xtffilename);
                PipelinePool pipelinePool = new PipelinePool();
                validator = new Validator(this.td, (IoxValidationConfig)modelConfig, (IoxLogging)errHandler, errFactory, pipelinePool, (Settings)config);
                if (reader instanceof ItfReader2) {
                    ((ItfReader2)reader).setIoxDataPool((IoxDataPool)pipelinePool);
                }
            }
            this.delayedObjects = new ArrayList();
            HashMap<String, ClassStat> objStat = null;
            StartBasketEvent basket = null;
            IoxEvent event = reader.read();
            try {
                boolean skipBasket = false;
                while (event != null) {
                    if (event instanceof StartBasketEvent) {
                        basket = (StartBasketEvent)event;
                        if (limitedToBids != null && !limitedToBids.contains(basket.getBid()) || limitedToTopics != null && !limitedToTopics.contains(basket.getType())) {
                            skipBasket = true;
                            EhiLogger.logState((String)("Skip Basket " + basket.getType() + "(oid " + basket.getBid() + ")"));
                        } else {
                            EhiLogger.logState((String)("Basket " + basket.getType() + "(oid " + basket.getBid() + ")..."));
                            skipBasket = false;
                            try {
                                boolean hasBid;
                                Topic topic;
                                if (this.rounder != null) {
                                    event = this.rounder.filter(event);
                                }
                                if (validator != null) {
                                    validator.validate(event);
                                }
                                if (this.languageFilter != null) {
                                    event = this.languageFilter.filter(event);
                                }
                                Long existingBasketSqlId = null;
                                if (this.functionCode == 4) {
                                    this.existingObjectsOfCurrentBasket = new HashMap();
                                    topic = (Topic)this.td.getElement(basket.getType());
                                    boolean bl = hasBid = topic.getBasketOid() != null;
                                    if (this.readIliBid || hasBid) {
                                        existingBasketSqlId = this.readExistingSqlObjIds(reader instanceof ItfReader, basket.getBid());
                                        if (existingBasketSqlId == null) {
                                            basketSqlId = this.oidPool.getBasketSqlId(basket.getBid());
                                        } else {
                                            basketSqlId = existingBasketSqlId;
                                            this.dropExistingStructEles(basket.getType(), basketSqlId);
                                        }
                                    } else {
                                        long[] basketSqlIds;
                                        String[] topicv = new String[]{basket.getType()};
                                        Configuration dummy = new Configuration();
                                        for (long oldBasketSqlId : basketSqlIds = Ili2db.getBasketSqlIdsFromTopic(topicv, dummy, this.conn, config)) {
                                            this.readExistingSqlObjIds(reader instanceof ItfReader, topic, oldBasketSqlId);
                                            this.dropExistingStructEles(basket.getType(), oldBasketSqlId);
                                        }
                                        this.removeBasketsFromDataset(basketSqlIds);
                                        existingBasketSqlId = null;
                                        basketSqlId = this.oidPool.getBasketSqlId(basket.getBid());
                                    }
                                } else {
                                    basketSqlId = this.oidPool.getBasketSqlId(basket.getBid());
                                }
                                if (this.attachmentKey == null) {
                                    this.attachmentKey = this.xtffilename != null ? new File(this.xtffilename).getName() + "-" + Long.toString(basketSqlId) : Long.toString(basketSqlId);
                                    config.setAttachmentKey(this.attachmentKey);
                                }
                                if (existingBasketSqlId == null) {
                                    topic = (Topic)this.td.getElement(basket.getType());
                                    hasBid = topic.getBasketOid() != null;
                                    this.writeBasket(datasetSqlId, basket, basketSqlId, this.attachmentKey, hasBid ? hasBid : this.readIliBid, basket.getDomains());
                                }
                            }
                            catch (SQLException ex) {
                                EhiLogger.logError((String)("Basket " + basket.getType() + "(oid " + basket.getBid() + ")"), (Throwable)ex);
                            }
                            catch (ConverterException ex) {
                                EhiLogger.logError((String)("Basket " + basket.getType() + "(oid " + basket.getBid() + ")"), (Throwable)ex);
                            }
                            startTid = this.oidPool.getLastSqlId();
                            objStat = new HashMap();
                            objCount = 0L;
                            String filename = null;
                            if (this.xtffilename != null) {
                                filename = new File(this.xtffilename).getName();
                            }
                            stat.put(Long.toString(basketSqlId), new BasketStat(filename, basket.getType(), basket.getBid(), objStat));
                        }
                    } else if (event instanceof EndBasketEvent) {
                        ArrayList dataerrs;
                        if (reader instanceof ItfReader2 && (dataerrs = ((ItfReader2)reader).getDataErrs()).size() > 0) {
                            if (!skipBasket && !config.isSkipGeometryErrors()) {
                                for (IoxInvalidDataException dataerr : dataerrs) {
                                    EhiLogger.logError((Throwable)dataerr);
                                }
                            }
                            ((ItfReader2)reader).clearDataErrs();
                        }
                        if (!skipBasket) {
                            if (this.rounder != null) {
                                event = this.rounder.filter(event);
                            }
                            if (validator != null) {
                                validator.validate(event);
                            }
                            if (this.languageFilter != null) {
                                event = this.languageFilter.filter(event);
                            }
                            ArrayList<FixIomObjectExtRefs> fixedObjects = new ArrayList<FixIomObjectExtRefs>();
                            for (FixIomObjectExtRefs fixref : this.delayedObjects) {
                                boolean skipObj = false;
                                for (IomObject ref : fixref.getRefs()) {
                                    String xtfid = ref.getobjectrefoid();
                                    Viewable aclass = fixref.getTargetClass(ref);
                                    String rootClassName = Ili2cUtility.getRootViewable(aclass).getScopedName(null);
                                    if (this.oidPool.containsXtfid(rootClassName, xtfid)) continue;
                                    skipObj = true;
                                }
                                if (skipObj) continue;
                                HashMap<String, ClassStat> fixrefObjStat = stat.get(Long.toString(fixref.getBasketSqlId())).getObjStat();
                                this.doObject(datasetName, fixref.getBasketSqlId(), fixref.getGenericDomains(), this.objPool.get(fixref.getRootTid()), fixrefObjStat);
                                fixedObjects.add(fixref);
                            }
                            this.delayedObjects.removeAll(fixedObjects);
                            if (this.functionCode == 4) {
                                this.deleteExisitingObjects(this.existingObjectsOfCurrentBasket);
                            }
                            endTid = this.oidPool.getLastSqlId();
                            try {
                                if (config.isCreateImportTabs()) {
                                    long importId = this.writeImportBasketStat(importSqlId, basketSqlId, startTid, endTid, objCount);
                                    this.writeObjStat(importId, basketSqlId, objStat);
                                }
                            }
                            catch (SQLException ex) {
                                EhiLogger.logError((String)("Basket " + basket.getType() + "(oid " + basket.getBid() + ")"), (Throwable)ex);
                            }
                            catch (ConverterException ex) {
                                EhiLogger.logError((String)("Basket " + basket.getType() + "(oid " + basket.getBid() + ")"), (Throwable)ex);
                            }
                        }
                        skipBasket = false;
                    } else if (event instanceof ObjectEvent) {
                        if (!skipBasket) {
                            if (this.rounder != null) {
                                event = this.rounder.filter(event);
                            }
                            if (validator != null) {
                                validator.validate(event);
                            }
                            if (this.languageFilter != null) {
                                event = this.languageFilter.filter(event);
                            }
                            ++objCount;
                            IomObject iomObj = ((ObjectEvent)event).getIomObject();
                            if (this.allReferencesKnown(basketSqlId, basket.getDomains(), iomObj)) {
                                this.doObject(datasetName, basketSqlId, basket.getDomains(), iomObj, objStat);
                            }
                        }
                    } else {
                        if (event instanceof EndTransferEvent) {
                            if (this.rounder != null) {
                                event = this.rounder.filter(event);
                            }
                            if (validator != null) {
                                validator.validate(event);
                            }
                            if (this.languageFilter != null) {
                                event = this.languageFilter.filter(event);
                            }
                            for (FixIomObjectExtRefs fixref : this.delayedObjects) {
                                boolean skipObj = false;
                                for (IomObject ref : fixref.getRefs()) {
                                    String xtfid = ref.getobjectrefoid();
                                    Viewable aclass = fixref.getTargetClass(ref);
                                    String rootClassName = Ili2cUtility.getRootViewable(aclass).getScopedName(null);
                                    if (this.oidPool.containsXtfid(rootClassName, xtfid)) continue;
                                    if (fixref.isExternalTarget(ref) && (this.readIliTid || Ili2cUtility.isViewableWithOid(aclass))) {
                                        Long sqlid = this.readObjectSqlid(aclass, xtfid);
                                        if (sqlid != null || ignoreUnresolvedReferences) continue;
                                        EhiLogger.logError((String)("unknown referenced object " + aclass.getScopedName(null) + " TID " + xtfid + " referenced from " + fixref.getRootTag() + " TID " + fixref.getRootTid()));
                                        referrs = true;
                                        skipObj = true;
                                        continue;
                                    }
                                    if (ignoreUnresolvedReferences) continue;
                                    EhiLogger.logError((String)("unknown referenced object " + aclass.getScopedName(null) + " TID " + xtfid + " referenced from " + fixref.getRootTag() + " TID " + fixref.getRootTid()));
                                    referrs = true;
                                    skipObj = true;
                                }
                                if (skipObj) continue;
                                objStat = stat.get(Long.toString(fixref.getBasketSqlId())).getObjStat();
                                this.doObject(datasetName, fixref.getBasketSqlId(), fixref.getGenericDomains(), this.objPool.get(fixref.getRootTid()), objStat);
                            }
                            break;
                        }
                        if (event instanceof StartTransferEvent) {
                            if (this.rounder != null) {
                                event = this.rounder.filter(event);
                            }
                            if (validator != null) {
                                validator.validate(event);
                            }
                            if (this.languageFilter != null) {
                                event = this.languageFilter.filter(event);
                            }
                        }
                    }
                    event = reader.read();
                }
                if (referrs) {
                    throw new IoxException("dangling references");
                }
            }
            finally {
                if (this.rounder != null) {
                    this.rounder.close();
                    this.rounder = null;
                }
                if (validator != null) {
                    validator.close();
                    validator = null;
                }
                if (this.languageFilter != null) {
                    this.languageFilter.close();
                }
            }
        }
        finally {
            this.recman.close();
        }
    }

    private void dropExistingStructEles(String topic, long basketSqlId) {
        HashSet<AbstractClassDef> classv = this.getStructs(topic);
        HashSet<ViewableWrapper> visitedTables = new HashSet<ViewableWrapper>();
        for (AbstractClassDef aclass1 : classv) {
            for (ViewableWrapper wrapper = this.class2wrapper.get((Viewable)aclass1); wrapper != null; wrapper = wrapper.getExtending()) {
                if (visitedTables.contains(wrapper)) continue;
                visitedTables.add(wrapper);
                DbTableName sqlName = wrapper.getSqlTable();
                if (!this.customMapping.tableExists(this.conn, sqlName)) continue;
                this.dropRecords(sqlName, basketSqlId);
            }
        }
    }

    private HashSet<AbstractClassDef> getStructs(String topicQName) {
        HashSet<AbstractClassDef> visitedStructs = new HashSet<AbstractClassDef>();
        for (Topic def = TransferToXtf.getTopicDef(this.td, topicQName); def != null; def = (Topic)def.getExtending()) {
            for (Object classo : def) {
                if (!(classo instanceof Viewable)) continue;
                if (classo instanceof Table && ((Table)classo).isIdentifiable()) {
                    this.getStructs_Helper((AbstractClassDef)classo, visitedStructs);
                    continue;
                }
                if (!(classo instanceof AssociationDef) || ((AssociationDef)classo).isIdentifiable()) continue;
                visitedStructs.add((AbstractClassDef)((AssociationDef)classo));
            }
        }
        return visitedStructs;
    }

    private void getStructs_Helper(AbstractClassDef aclass, HashSet<AbstractClassDef> accu) {
        if (accu.contains(aclass)) {
            return;
        }
        Set seed = null;
        if (aclass instanceof Table && !((Table)aclass).isIdentifiable()) {
            seed = aclass.getExtensions();
        } else {
            seed = new HashSet<AbstractClassDef>();
            seed.add(aclass);
        }
        for (Object defo : seed) {
            AbstractClassDef def = (AbstractClassDef)defo;
            if (accu.contains(def)) continue;
            if (def instanceof Table && !((Table)def).isIdentifiable()) {
                accu.add(def);
            }
            while (def != null) {
                for (Object attro : def) {
                    AttributeDef attr;
                    Type type;
                    if (!(attro instanceof AttributeDef) || !((type = (attr = (AttributeDef)attro).getDomain()) instanceof CompositionType)) continue;
                    CompositionType compType = (CompositionType)type;
                    this.getStructs_Helper((AbstractClassDef)compType.getComponentType(), accu);
                    Iterator resti = compType.iteratorRestrictedTo();
                    while (resti.hasNext()) {
                        AbstractClassDef rest = (AbstractClassDef)resti.next();
                        this.getStructs_Helper(rest, accu);
                    }
                }
                if (!accu.contains(def = (AbstractClassDef)def.getExtending())) continue;
                def = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropRecords(DbTableName sqlTableName, long basketSqlId) {
        String stmt = "DELETE FROM " + sqlTableName.getQName() + " WHERE " + "T_basket" + "=" + basketSqlId;
        EhiLogger.traceBackendCmd((String)stmt);
        PreparedStatement dbstmt = null;
        try {
            dbstmt = this.conn.prepareStatement(stmt);
            dbstmt.clearParameters();
            dbstmt.executeUpdate();
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to delete from " + sqlTableName), (Throwable)ex);
        }
        finally {
            if (dbstmt != null) {
                try {
                    dbstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close delete stmt of " + sqlTableName), (Throwable)ex);
                }
            }
        }
    }

    private void deleteExisitingObjects(HashMap<String, HashSet<Long>> existingObjects) {
        for (String sqlType : existingObjects.keySet()) {
            HashSet<Long> objs = existingObjects.get(sqlType);
            StringBuilder ids = new StringBuilder();
            String sep = "";
            if (objs.size() <= 0) continue;
            for (Long sqlId : objs) {
                ids.append(sep);
                ids.append(sqlId);
                sep = ",";
            }
            Object classo = this.tag2class.get(this.ili2sqlName.mapSqlTableName(sqlType));
            if (classo instanceof Viewable) {
                for (Viewable aclass = (Viewable)classo; aclass != null; aclass = (Viewable)aclass.getExtending()) {
                    this.deleteExistingObjectsHelper(this.recConv.getSqlType(aclass), ids.toString());
                }
                continue;
            }
            if (classo instanceof AttributeDef) {
                int[] epsgCodes;
                AttributeDef geomAttr = (AttributeDef)classo;
                for (int epsgCode : epsgCodes = TransferFromIli.getEpsgCodes(geomAttr, this.srsModelAssignment, this.defaultCrsCode)) {
                    this.deleteExistingObjectsHelper(this.getSqlTableNameItfLineTable(geomAttr, epsgCode), ids.toString());
                }
                continue;
            }
            throw new IllegalStateException("unexpetced sqlType <" + sqlType + ">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExistingObjectsHelper(DbTableName sqlTableName, String ids) {
        String stmt = null;
        stmt = ids != null ? "DELETE FROM " + sqlTableName.getQName() + " WHERE " + this.colT_ID + " in (" + ids + ")" : "DELETE FROM " + sqlTableName.getQName();
        EhiLogger.traceBackendCmd((String)stmt);
        PreparedStatement dbstmt = null;
        try {
            dbstmt = this.conn.prepareStatement(stmt);
            dbstmt.clearParameters();
            dbstmt.executeUpdate();
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to delete from " + sqlTableName), (Throwable)ex);
        }
        finally {
            if (dbstmt != null) {
                try {
                    dbstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close delete stmt of " + sqlTableName), (Throwable)ex);
                }
            }
        }
    }

    private Long readExistingSqlObjIds(boolean isItf, String bid) throws Ili2dbException {
        StringBuilder topicQName = new StringBuilder();
        Long basketSqlId = Ili2db.getBasketSqlIdFromBID(bid, this.conn, this.schema, this.colT_ID, topicQName);
        if (basketSqlId == null) {
            return null;
        }
        Topic topic = TransferToXtf.getTopicDef(this.td, topicQName.toString());
        if (topic == null) {
            throw new Ili2dbException("unkown topic " + topicQName.toString());
        }
        this.readExistingSqlObjIds(isItf, topic, basketSqlId);
        return basketSqlId;
    }

    private void readExistingSqlObjIds(boolean isItf, Topic topic, long basketSqlId) throws Ili2dbException {
        Model model = (Model)topic.getContainer();
        Iterator<Object> iter = null;
        if (isItf) {
            ArrayList itftablev = ModelUtilities.getItfTables((TransferDescription)this.td, (String)model.getName(), (String)topic.getName());
            iter = itftablev.iterator();
        } else {
            iter = TransferFromXtf.getXtfTables(this.td, topic).iterator();
        }
        HashSet<String> visitedTables = new HashSet<String>();
        while (iter.hasNext()) {
            int[] epsgCodes;
            Object obj = iter.next();
            if (obj instanceof Viewable) {
                if (obj instanceof View && !TransferFromIli.isTransferableView(obj) || TransferToXtf.suppressViewable((Viewable)obj)) continue;
                Viewable aclass = (Viewable)obj;
                if (aclass.isAbstract()) {
                    throw new IllegalArgumentException("unexpected abstract viewable " + aclass.getScopedName(null));
                }
                if (aclass instanceof AssociationDef && !((AssociationDef)aclass).isIdentifiable()) continue;
                DbTableName sqlName = this.recConv.getSqlType(aclass);
                ViewableWrapper wrapper = this.recConv.getViewableWrapper(sqlName.getName());
                ViewableWrapper base = wrapper.getExtending();
                while (base != null) {
                    wrapper = base;
                    base = wrapper.getExtending();
                }
                sqlName = wrapper.getSqlTable();
                if (visitedTables.contains(sqlName.getQName())) continue;
                visitedTables.add(sqlName.getQName());
                if (this.customMapping.tableExists(this.conn, sqlName)) {
                    EhiLogger.logState((String)(aclass.getScopedName(null) + " read ids..."));
                    this.readObjectSqlIds(!wrapper.includesMultipleTypes(), sqlName, basketSqlId);
                    continue;
                }
                EhiLogger.traceUnusualState((String)(aclass.getScopedName(null) + "...skipped; no table " + sqlName + " in db"));
                continue;
            }
            if (!(obj instanceof AttributeDef) || !isItf) continue;
            AttributeDef attr = (AttributeDef)obj;
            for (int epsgCode : epsgCodes = TransferFromIli.getEpsgCodes(attr, this.srsModelAssignment, this.defaultCrsCode)) {
                DbTableName sqlName = this.getSqlTableNameItfLineTable(attr, epsgCode);
                if (this.customMapping.tableExists(this.conn, sqlName)) {
                    EhiLogger.logState((String)(attr.getContainer().getScopedName(null) + "_" + attr.getName() + " read ids..."));
                    this.readObjectSqlIds(isItf, sqlName, basketSqlId);
                    continue;
                }
                EhiLogger.traceUnusualState((String)(attr.getScopedName(null) + "...skipped; no table " + sqlName + " in db"));
            }
        }
    }

    private static ArrayList<Viewable> getXtfTables(TransferDescription td, Topic topic) {
        ArrayList<Viewable> ret = new ArrayList<Viewable>();
        for (Object obj : topic.getViewables()) {
            if (!(obj instanceof Viewable) || AbstractPatternDef.suppressViewableInTransfer((Viewable)((Viewable)obj))) continue;
            Viewable v = (Viewable)obj;
            ret.add(v);
        }
        return ret;
    }

    private void deleteObjectsOfExistingDataset(long datasetSqlId, Config config) throws Ili2dbException {
        String stmt;
        String schema = config.getDbschema();
        String colT_ID = config.getColT_ID();
        if (colT_ID == null) {
            colT_ID = "T_Id";
        }
        String sqlName = "T_ILI2DB_BASKET";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        Statement getstmt = null;
        try {
            stmt = "SELECT " + colT_ID + "," + "topic" + " FROM " + sqlName + " WHERE " + "dataset" + "= ?";
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = this.conn.prepareStatement(stmt);
            getstmt.setLong(1, datasetSqlId);
            ResultSet res = getstmt.executeQuery();
            while (res.next()) {
                long sqlId = res.getLong(1);
                String topicQName = res.getString(2);
                this.deleteObjectsOfBasket(sqlId, topicQName);
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to query " + sqlName, ex);
        }
        finally {
            if (getstmt != null) {
                try {
                    getstmt.close();
                    getstmt = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        try {
            stmt = "DELETE FROM " + sqlName + " WHERE " + "dataset" + "= ?";
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = this.conn.prepareStatement(stmt);
            getstmt.setLong(1, datasetSqlId);
            getstmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to delete from " + sqlName, ex);
        }
        finally {
            if (getstmt != null) {
                try {
                    getstmt.close();
                    getstmt = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
    }

    private void deleteObjectsOfBasket(long basketSqlId, String topicQName) throws Ili2dbException {
        boolean isItf = false;
        Topic topic = TransferToXtf.getTopicDef(this.td, topicQName);
        if (topic == null) {
            throw new Ili2dbException("unkown topic " + topicQName.toString());
        }
        Model model = (Model)topic.getContainer();
        Iterator iter = null;
        if (isItf) {
            ArrayList itftablev = ModelUtilities.getItfTables((TransferDescription)this.td, (String)model.getName(), (String)topic.getName());
            iter = itftablev.iterator();
        } else {
            iter = topic.getViewables().iterator();
        }
        HashSet<ViewableWrapper> visitedTables = new HashSet<ViewableWrapper>();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Viewable) {
                if (obj instanceof View && !TransferFromIli.isTransferableView(obj) || TransferToXtf.suppressViewable((Viewable)obj)) continue;
                Viewable aclass1 = (Viewable)obj;
                for (ViewableWrapper wrapper = this.class2wrapper.get(aclass1); wrapper != null; wrapper = wrapper.getExtending()) {
                    if (!visitedTables.contains(wrapper)) {
                        visitedTables.add(wrapper);
                        DbTableName sqlName = wrapper.getSqlTable();
                        if (this.customMapping.tableExists(this.conn, sqlName)) {
                            this.dropRecords(sqlName, basketSqlId);
                        }
                    }
                    Object object = wrapper.getSecondaryTables().iterator();
                    while (object.hasNext()) {
                        ViewableWrapper secondary = (ViewableWrapper)object.next();
                        if (visitedTables.contains(secondary)) continue;
                        visitedTables.add(secondary);
                        DbTableName sqlName = secondary.getSqlTable();
                        if (!this.customMapping.tableExists(this.conn, sqlName)) continue;
                        this.dropRecords(sqlName, basketSqlId);
                    }
                }
                continue;
            }
            if (!(obj instanceof AttributeDef) || !isItf) continue;
            AttributeDef attr = (AttributeDef)obj;
            int[] epsgCodes = TransferFromIli.getEpsgCodes(attr, this.srsModelAssignment, this.defaultCrsCode);
            for (int epsgCode : epsgCodes) {
                DbTableName sqlName = this.getSqlTableNameItfLineTable(attr, epsgCode);
                if (!this.customMapping.tableExists(this.conn, sqlName)) continue;
                this.dropRecords(sqlName, basketSqlId);
            }
        }
        this.dropExistingStructEles(topicQName, basketSqlId);
        if (this.createImportTabs) {
            String sqlName = "T_ILI2DB_IMPORT_BASKET";
            if (this.schema != null) {
                sqlName = this.schema + "." + sqlName;
            }
            Statement getstmt = null;
            try {
                String stmt = "DELETE FROM " + sqlName + " WHERE " + "basket" + "= ?";
                EhiLogger.traceBackendCmd((String)stmt);
                getstmt = this.conn.prepareStatement(stmt);
                getstmt.setLong(1, basketSqlId);
                getstmt.executeUpdate();
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to delete from " + sqlName, ex);
            }
            finally {
                if (getstmt != null) {
                    try {
                        getstmt.close();
                        getstmt = null;
                    }
                    catch (SQLException ex) {
                        EhiLogger.logError((Throwable)ex);
                    }
                }
            }
        }
    }

    private void doObject(String datasetName, long basketSqlId, Map<String, String> genericDomains, IomObject iomObj, Map<String, ClassStat> objStat) {
        try {
            this.writeObject(datasetName, basketSqlId, genericDomains, iomObj, null, objStat);
        }
        catch (ConverterException ex) {
            EhiLogger.debug((String)iomObj.toString());
            EhiLogger.logError((String)("Object " + iomObj.getobjectoid() + " at (line " + iomObj.getobjectline() + ",col " + iomObj.getobjectcol() + ")"), (Throwable)ex);
        }
        catch (SQLException ex) {
            EhiLogger.debug((String)iomObj.toString());
            EhiLogger.logError((String)("Object " + iomObj.getobjectoid() + " at (line " + iomObj.getobjectline() + ",col " + iomObj.getobjectcol() + ")"), (Throwable)ex);
        }
        catch (RuntimeException ex) {
            EhiLogger.traceState((String)iomObj.toString());
            throw ex;
        }
        while (!this.structQueue.isEmpty()) {
            AbstractStructWrapper struct = this.structQueue.remove(0);
            try {
                this.writeObject(datasetName, basketSqlId, genericDomains, struct.getStruct(), struct, objStat);
            }
            catch (ConverterException ex) {
                EhiLogger.logError((String)("Object " + iomObj.getobjectoid() + "; Struct at (line " + struct.getStruct().getobjectline() + ",col " + struct.getStruct().getobjectcol() + ")"), (Throwable)ex);
            }
            catch (SQLException ex) {
                EhiLogger.logError((String)("Object " + iomObj.getobjectoid() + "; Struct at (line " + struct.getStruct().getobjectline() + ",col " + struct.getStruct().getobjectcol() + ")"), (Throwable)ex);
            }
            catch (RuntimeException ex) {
                EhiLogger.traceState((String)iomObj.toString());
                throw ex;
            }
        }
    }

    private boolean allReferencesKnown(long basketSqlId, Map<String, String> genericDomains, IomObject iomObj) {
        String tag = iomObj.getobjecttag();
        Object modelele = this.tag2class.get(tag);
        if (modelele == null) {
            return true;
        }
        if (this.createItfLineTables && modelele instanceof AttributeDef) {
            return true;
        }
        String tid = iomObj.getobjectoid();
        if ((tid == null || tid.length() == 0) && modelele instanceof AssociationDef) {
            tid = this.getAssociationId(iomObj, (AssociationDef)modelele);
        }
        if (tid != null && tid.length() > 0) {
            this.oidPool.createObjSqlId(Ili2cUtility.getRootViewable(this.getCrsMappedOrSame((Viewable)modelele)).getScopedName(null), tag, tid);
        }
        FixIomObjectExtRefs extref = new FixIomObjectExtRefs(basketSqlId, genericDomains, tag, tid);
        this.allReferencesKnownHelper(iomObj, extref);
        if (!extref.needsFixing()) {
            return true;
        }
        this.delayedObjects.add(extref);
        this.objPool.put(tid, iomObj);
        return false;
    }

    private String getAssociationId(IomObject iomObj, AssociationDef modelele) {
        String tag = modelele.getScopedName(null);
        Iterator rolei = modelele.getAttributesAndRoles2();
        String sep = "";
        String tid = "";
        while (rolei.hasNext()) {
            ViewableTransferElement prop = (ViewableTransferElement)rolei.next();
            if (!(prop.obj instanceof RoleDef) || prop.embedded) continue;
            String roleName = ((RoleDef)prop.obj).getName();
            IomObject refObj = iomObj.getattrobj(roleName, 0);
            String ref = null;
            if (refObj != null) {
                ref = refObj.getobjectrefoid();
            }
            if (ref != null) {
                tid = tid + sep + ref;
                sep = ":";
                continue;
            }
            throw new IllegalStateException("REF required (" + tag + "/" + roleName + ")");
        }
        return tid;
    }

    private void allReferencesKnownHelper(IomObject iomObj, FixIomObjectExtRefs extref) {
        String tag = iomObj.getobjecttag();
        Object modelele = this.tag2class.get(tag);
        if (modelele == null) {
            return;
        }
        Viewable aclass = (Viewable)modelele;
        Iterator iter = aclass.getAttributesAndRoles2();
        while (iter.hasNext()) {
            Type proxyType;
            AttributeDef attr;
            ViewableTransferElement obj = (ViewableTransferElement)iter.next();
            if (!(!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                this.allReferencesKnownHelper(iomObj, attr, extref);
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            String roleName = role.getName();
            if (obj.embedded) {
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() != null) continue;
                IomObject structvalue = iomObj.getattrobj(roleName, 0);
                if (roleOwner.getAttributes().hasNext() || roleOwner.getLightweightAssociations().iterator().hasNext()) {
                    // empty if block
                }
                if (structvalue == null) continue;
                String refoid = structvalue.getobjectrefoid();
                AbstractClassDef targetClass = role.getDestination();
                if (this.oidPool.containsXtfid(Ili2cUtility.getRootViewable(this.getCrsMappedOrSame((Viewable)targetClass)).getScopedName(null), refoid)) continue;
                extref.addFix(structvalue, (Viewable)targetClass, role.isExternal());
                continue;
            }
            IomObject structvalue = iomObj.getattrobj(roleName, 0);
            String refoid = structvalue.getobjectrefoid();
            AbstractClassDef targetClass = role.getDestination();
            if (this.oidPool.containsXtfid(Ili2cUtility.getRootViewable(this.getCrsMappedOrSame((Viewable)targetClass)).getScopedName(null), refoid)) continue;
            extref.addFix(structvalue, (Viewable)targetClass, role.isExternal());
        }
    }

    private void allReferencesKnownHelper(IomObject iomObj, AttributeDef attr, FixIomObjectExtRefs extref) {
        String attrName = attr.getName();
        if (!(attr.isDomainBoolean() || attr.isDomainIli1Date() || attr.isDomainIli2Date() || attr.isDomainIli2Time() || attr.isDomainIli2DateTime())) {
            Type type = attr.getDomainResolvingAliases();
            if (type instanceof CompositionType) {
                int structc = iomObj.getattrvaluecount(attrName);
                for (int structi = 0; structi < structc; ++structi) {
                    IomObject struct = iomObj.getattrobj(attrName, structi);
                    this.allReferencesKnownHelper(struct, extref);
                }
            } else if (!(type instanceof PolylineType || type instanceof SurfaceOrAreaType || type instanceof CoordType || type instanceof NumericType || type instanceof EnumerationType || !(type instanceof ReferenceType))) {
                ReferenceType refType;
                AbstractClassDef targetClass;
                IomObject structvalue = iomObj.getattrobj(attrName, 0);
                String refoid = null;
                if (structvalue != null) {
                    refoid = structvalue.getobjectrefoid();
                }
                if (refoid != null && !this.oidPool.containsXtfid(Ili2cUtility.getRootViewable(this.getCrsMappedOrSame((Viewable)(targetClass = (refType = (ReferenceType)type).getReferred()))).getScopedName(null), refoid)) {
                    extref.addFix(structvalue, (Viewable)targetClass, refType.isExternal());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long readObjectSqlid(Viewable xclass, String xtfid) {
        String sqlType;
        long sqlid;
        block24: {
            Statement dbstmt = null;
            ResultSet rs = null;
            sqlid = 0L;
            sqlType = null;
            try {
                String stmt = this.createQueryStmt4sqlid(xclass);
                EhiLogger.traceBackendCmd((String)stmt);
                dbstmt = this.conn.prepareStatement(stmt);
                dbstmt.clearParameters();
                dbstmt.setString(1, xtfid);
                rs = dbstmt.executeQuery();
                if (rs.next()) {
                    sqlid = rs.getLong(1);
                    sqlType = rs.getString(3);
                    break block24;
                }
                Long l = null;
                return l;
            }
            catch (SQLException ex) {
                EhiLogger.logError((String)("failed to query " + xclass.getScopedName(null)), (Throwable)ex);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException ex) {
                        EhiLogger.logError((String)("failed to close query of " + xclass.getScopedName(null)), (Throwable)ex);
                    }
                }
                if (dbstmt != null) {
                    try {
                        dbstmt.close();
                    }
                    catch (SQLException ex) {
                        EhiLogger.logError((String)("failed to close query of " + xclass.getScopedName(null)), (Throwable)ex);
                    }
                }
            }
        }
        Viewable aclass = (Viewable)this.tag2class.get(this.ili2sqlName.mapSqlTableName(sqlType));
        this.oidPool.putXtfid2sqlid(Ili2cUtility.getRootViewable(aclass).getScopedName(null), aclass.getScopedName(null), xtfid, sqlid);
        return sqlid;
    }

    private String createQueryStmt4sqlid(Viewable aclass) throws SQLException {
        ArrayList<ViewableWrapper> wrappers = this.recConv.getTargetTables(aclass);
        StringBuffer ret = new StringBuffer();
        int i = 1;
        boolean isPg = TransferFromIli.isPostgresql(this.conn);
        ret.append("SELECT " + this.colT_ID + "," + "T_Ili_Tid" + "," + "T_Type" + " FROM (");
        String sep = "";
        HashSet<ViewableWrapper> visitedWrappers = new HashSet<ViewableWrapper>();
        for (ViewableWrapper wrapper : wrappers) {
            if (visitedWrappers.contains(wrapper = wrapper.getRoot())) continue;
            visitedWrappers.add(wrapper);
            ret.append(sep);
            ret.append("SELECT r" + i + "." + this.colT_ID);
            if (isPg) {
                ret.append(", CAST(r" + i + "." + "T_Ili_Tid" + " AS text)");
            } else {
                ret.append(", r" + i + "." + "T_Ili_Tid");
            }
            if (this.recConv.createTypeDiscriminator() || wrapper.includesMultipleTypes()) {
                ret.append(", r" + i + "." + "T_Type");
            } else {
                ret.append(", '" + wrapper.getSqlTable().getName() + "' " + "T_Type");
            }
            ret.append(" FROM ");
            ret.append(wrapper.getSqlTable().getQName());
            ret.append(" r" + i + "");
            ++i;
            sep = " UNION ";
        }
        ret.append(") r0");
        ret.append(" WHERE r0.T_Ili_Tid=?");
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObjectSqlIds(boolean noTypeCol, DbTableName sqltablename, long basketsqlid) {
        String stmt = this.createQueryStmt4sqlids(noTypeCol, sqltablename.getQName());
        EhiLogger.traceBackendCmd((String)stmt);
        PreparedStatement dbstmt = null;
        ResultSet rs = null;
        try {
            dbstmt = this.conn.prepareStatement(stmt);
            dbstmt.clearParameters();
            dbstmt.setLong(1, basketsqlid);
            rs = dbstmt.executeQuery();
            while (rs.next()) {
                long sqlid = rs.getLong(1);
                String xtfid = rs.getString(2);
                String sqlType = null;
                sqlType = !noTypeCol ? rs.getString(3) : sqltablename.getName();
                Viewable aclass = (Viewable)this.tag2class.get(this.ili2sqlName.mapSqlTableName(sqlType));
                this.oidPool.putXtfid2sqlid(Ili2cUtility.getRootViewable(aclass).getScopedName(null), aclass.getScopedName(null), xtfid, sqlid);
                this.addExistingObjects(sqlType, sqlid);
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to query " + sqltablename), (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close query of " + sqltablename), (Throwable)ex);
                }
            }
            if (dbstmt != null) {
                try {
                    dbstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((String)("failed to close query of " + sqltablename), (Throwable)ex);
                }
            }
        }
    }

    private void addExistingObjects(String sqlType, long sqlid) {
        HashSet<Object> objs = null;
        if (this.existingObjectsOfCurrentBasket.containsKey(sqlType)) {
            objs = this.existingObjectsOfCurrentBasket.get(sqlType);
        } else {
            objs = new HashSet();
            this.existingObjectsOfCurrentBasket.put(sqlType, objs);
        }
        objs.add(sqlid);
    }

    private boolean existingObjectsContains(String sqlType, long sqlid) {
        if (this.existingObjectsOfCurrentBasket.containsKey(sqlType)) {
            HashSet<Long> objs = this.existingObjectsOfCurrentBasket.get(sqlType);
            return objs.contains(sqlid);
        }
        return false;
    }

    private void existingObjectsRemove(String sqlType, long sqlid) {
        if (this.existingObjectsOfCurrentBasket.containsKey(sqlType)) {
            HashSet<Long> objs = this.existingObjectsOfCurrentBasket.get(sqlType);
            objs.remove(sqlid);
        }
    }

    private String createQueryStmt4sqlids(boolean noTypeCol, String sqltablename) {
        StringBuffer ret = new StringBuffer();
        ret.append("SELECT r0." + this.colT_ID);
        ret.append(", r0.T_Ili_Tid");
        if (!noTypeCol) {
            ret.append(", r0.T_Type");
        }
        ret.append(" FROM ");
        ret.append(sqltablename);
        ret.append(" r0");
        ret.append(" WHERE r0.T_basket=?");
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(String datasetName, long basketSqlId, Map<String, String> genericDomains, IomObject iomObj, AbstractStructWrapper structEle, Map<String, ClassStat> objStat) throws SQLException, ConverterException {
        ViewableWrapper aclass;
        long sqlId;
        String tag = iomObj.getobjecttag();
        Object modelele = this.tag2class.get(tag);
        if (modelele == null) {
            if (!this.unknownTypev.contains(tag)) {
                EhiLogger.logError((String)("unknown type <" + tag + ">, line " + Integer.toString(iomObj.getobjectline()) + ", col " + Integer.toString(iomObj.getobjectcol())));
            }
            return;
        }
        if (this.createItfLineTables && modelele instanceof AttributeDef) {
            AttributeDef geomAttr = (AttributeDef)modelele;
            this.writeItfLineTableObject(datasetName, basketSqlId, iomObj, geomAttr, TransferFromIli.getEpsgCode(geomAttr, genericDomains, this.defaultCrsCode));
            return;
        }
        Viewable aclass0 = (Viewable)modelele;
        Viewable aclass1 = this.getCrsMappedOrSame(aclass0);
        String sqlType = this.ili2sqlName.mapIliClassDef(aclass1);
        boolean updateObj = false;
        if (structEle == null) {
            String tid = iomObj.getobjectoid();
            if (tid != null && tid.length() > 0) {
                sqlId = this.oidPool.getObjSqlId(Ili2cUtility.getRootViewable(aclass1).getScopedName(null), tid);
                if (this.functionCode == 4 && this.existingObjectsContains(sqlType, sqlId)) {
                    updateObj = true;
                    this.existingObjectsRemove(sqlType, sqlId);
                }
            } else {
                sqlId = this.oidPool.newObjSqlId();
            }
        } else {
            sqlId = this.oidPool.newObjSqlId();
        }
        this.updateObjStat(objStat, tag, sqlId);
        if (aclass == null) {
            throw new IllegalStateException("no ViewableWrapper found for " + aclass1.getScopedName());
        }
        for (aclass = this.class2wrapper.get(aclass1); aclass != null; aclass = aclass.getExtending()) {
            String insert = this.getInsertStmt(updateObj, aclass1, aclass, structEle);
            EhiLogger.traceBackendCmd((String)insert);
            PreparedStatement ps = this.conn.prepareStatement(insert);
            try {
                this.recConv.writeRecord(basketSqlId, genericDomains, iomObj, aclass1, structEle, aclass, sqlType, sqlId, updateObj, ps, this.structQueue, aclass0);
                ps.executeUpdate();
            }
            finally {
                ps.close();
            }
            for (ViewableWrapper secondary : aclass.getSecondaryTables()) {
                if (!secondary.containsAttributes(this.recConv.getIomObjectAttrs(aclass1).keySet())) continue;
                String insert2 = this.getInsertStmt(updateObj, aclass1, secondary, structEle);
                EhiLogger.traceBackendCmd((String)insert2);
                PreparedStatement ps2 = this.conn.prepareStatement(insert2);
                try {
                    this.recConv.writeRecord(basketSqlId, genericDomains, iomObj, aclass1, structEle, secondary, sqlType, sqlId, updateObj, ps2, this.structQueue, aclass0);
                    ps2.executeUpdate();
                }
                finally {
                    ps2.close();
                }
            }
        }
        Iterator roleIt = aclass0.getAttributesAndRoles2();
        while (roleIt.hasNext()) {
            IomObject refObj;
            RoleDef role;
            AssociationDef roleOwner;
            ViewableTransferElement roleEle = (ViewableTransferElement)roleIt.next();
            if (!roleEle.embedded || !(roleEle.obj instanceof RoleDef) || (roleOwner = (AssociationDef)(role = (RoleDef)roleEle.obj).getContainer()).getDerivedFrom() != null || TransferFromIli.isLightweightAssociation(roleOwner) || (refObj = iomObj.getattrobj(role.getName(), 0)) == null || refObj.getobjectrefoid() == null) continue;
            if (refObj.getobjecttag().equals("REF")) {
                refObj.setobjecttag(roleOwner.getScopedName());
            }
            this.structQueue.add(new EmbeddedLinkWrapper(iomObj.getobjectoid(), sqlType, refObj, role));
        }
    }

    private Viewable getCrsMappedOrSame(Viewable aclass) {
        if (this.crsFilter == null) {
            return aclass;
        }
        Viewable aclass0 = (Viewable)this.crsFilter.get(aclass);
        if (aclass0 != null) {
            return aclass0;
        }
        return aclass;
    }

    private DbTableName getSqlTableNameItfLineTable(AttributeDef attrDef, Integer epsgCode) {
        String sqlTabName = this.ili2sqlName.mapItfGeometryAsTable((Viewable)attrDef.getContainer(), attrDef, epsgCode);
        return new DbTableName(this.schema, sqlTabName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeItfLineTableObject(String datasetName, long basketSqlId, IomObject iomObj, AttributeDef attrDef, Integer epsgCode) throws SQLException, ConverterException {
        SurfaceOrAreaType type = (SurfaceOrAreaType)attrDef.getDomainResolvingAliases();
        String geomAttrName = ModelUtilities.getHelperTableGeomAttrName((AttributeDef)attrDef);
        String refAttrName = null;
        if (type instanceof SurfaceType) {
            refAttrName = ModelUtilities.getHelperTableMainTableRef((AttributeDef)attrDef);
        }
        Table lineAttrTable = type.getLineAttributeStructure();
        String idTag = attrDef.getContainer().getScopedName(null) + "." + attrDef.getName();
        long sqlId = this.oidPool.createObjSqlId(idTag, idTag, iomObj.getobjectoid());
        String sqlTableName = this.getSqlTableNameItfLineTable(attrDef, epsgCode).getQName();
        String insert = this.createItfLineTableInsertStmt(attrDef, epsgCode);
        EhiLogger.traceBackendCmd((String)insert);
        PreparedStatement ps = this.conn.prepareStatement(insert);
        try {
            IomObject value;
            int valuei = 1;
            ps.setLong(valuei, sqlId);
            ++valuei;
            if (this.createBasketCol) {
                ps.setLong(valuei, basketSqlId);
                ++valuei;
            }
            if (this.createDatasetCol) {
                ps.setString(valuei, datasetName);
                ++valuei;
            }
            if (this.readIliTid) {
                ps.setString(valuei, iomObj.getobjectoid());
                ++valuei;
            }
            if ((value = iomObj.getattrobj(geomAttrName, 0)) != null) {
                boolean is3D = ((CoordType)type.getControlPointDomain().getType()).getDimensions().length == 3;
                ps.setObject(valuei, this.geomConv.fromIomPolyline(value, epsgCode, is3D, this.recConv.getP((LineType)type)));
            } else {
                this.geomConv.setPolylineNull(ps, valuei);
            }
            ++valuei;
            if (type instanceof SurfaceType) {
                IomObject structvalue = iomObj.getattrobj(refAttrName, 0);
                String refoid = structvalue.getobjectrefoid();
                long refsqlId = this.oidPool.getObjSqlId(attrDef.getContainer().getScopedName(null), refoid);
                ps.setLong(valuei, refsqlId);
                ++valuei;
            }
            if (lineAttrTable != null) {
                Iterator attri = lineAttrTable.getAttributes();
                while (attri.hasNext()) {
                    AttributeDef lineattr = (AttributeDef)attri.next();
                    valuei = this.recConv.addAttrValue(iomObj, this.ili2sqlName.mapItfGeometryAsTable((Viewable)attrDef.getContainer(), attrDef, null), sqlId, sqlTableName, ps, valuei, lineattr, lineattr, null, null, new HashMap<String, String>(), null);
                }
            }
            if (this.createStdCols) {
                ps.setTimestamp(valuei, this.today);
                ps.setTimestamp(++valuei, this.today);
                ps.setString(++valuei, this.dbusr);
                ++valuei;
            }
            ps.executeUpdate();
        }
        finally {
            ps.close();
        }
    }

    private void updateObjStat(Map<String, ClassStat> objStat, String tag, long sqlId) {
        if (objStat.containsKey(tag)) {
            ClassStat stat = objStat.get(tag);
            stat.addEndid(sqlId);
        } else {
            ClassStat stat = new ClassStat(tag, sqlId);
            objStat.put(tag, stat);
        }
    }

    private void writeObjStat(long sqlImportId, long basketSqlId, HashMap<String, ClassStat> objStat) throws SQLException {
        for (String className : objStat.keySet()) {
            ClassStat stat = objStat.get(className);
            this.writeImportStatDetail(sqlImportId, stat.getStartid(), stat.getEndid(), stat.getObjcount(), className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeImportStat(long datasetSqlId, String importFile, Timestamp importDate, String importUsr) throws SQLException, ConverterException {
        String sqlname = "T_ILI2DB_IMPORT";
        if (this.schema != null) {
            sqlname = this.schema + "." + sqlname;
        }
        String insert = "INSERT INTO " + sqlname + "(" + this.colT_ID + ", " + "dataset" + ", " + "importDate" + ", " + "importUser" + ", " + "importFile" + ") VALUES (?,?,?,?,?)";
        EhiLogger.traceBackendCmd((String)insert);
        PreparedStatement ps = this.conn.prepareStatement(insert);
        try {
            int valuei = 1;
            long key = this.oidPool.newObjSqlId();
            ps.setLong(valuei, key);
            ps.setLong(++valuei, datasetSqlId);
            ps.setTimestamp(++valuei, importDate);
            ps.setString(++valuei, importUsr);
            ps.setString(++valuei, importFile);
            ++valuei;
            ps.executeUpdate();
            long l = key;
            return l;
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeImportBasketStat(long importSqlId, long basketSqlId, long startTid, long endTid, long objCount) throws SQLException, ConverterException {
        String sqlname = "T_ILI2DB_IMPORT_BASKET";
        if (this.schema != null) {
            sqlname = this.schema + "." + sqlname;
        }
        String insert = "INSERT INTO " + sqlname + "(" + this.colT_ID + ", " + "importrun" + ", " + "basket" + ", " + "objectCount" + ") VALUES (?,?,?,?)";
        EhiLogger.traceBackendCmd((String)insert);
        PreparedStatement ps = this.conn.prepareStatement(insert);
        try {
            int valuei = 1;
            long key = this.oidPool.newObjSqlId();
            ps.setLong(valuei, key);
            ps.setLong(++valuei, importSqlId);
            ps.setLong(++valuei, basketSqlId);
            ps.setLong(++valuei, objCount);
            ++valuei;
            ps.executeUpdate();
            long l = key;
            return l;
        }
        finally {
            ps.close();
        }
    }

    private void writeImportStatDetail(long importSqlId, long startTid, long endTid, long objCount, String importClassName) throws SQLException {
    }

    private void removeBasketsFromDataset(long[] basketSqlIds) throws SQLException {
        if (basketSqlIds == null || basketSqlIds.length == 0) {
            return;
        }
        String sqlname = "T_ILI2DB_BASKET";
        if (this.schema != null) {
            sqlname = this.schema + "." + sqlname;
        }
        StringBuffer crit = new StringBuffer();
        String sep = "";
        for (long basketSqlId : basketSqlIds) {
            crit.append(sep);
            crit.append(Long.toString(basketSqlId));
            sep = ",";
        }
        String insert = "UPDATE " + sqlname + " SET " + "dataset" + "=NULL WHERE " + this.colT_ID + " IN (" + crit.toString() + ")";
        EhiLogger.traceBackendCmd((String)insert);
        this.conn.createStatement().execute(insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeBasket(long datasetSqlId, StartBasketEvent iomBasket, long basketSqlId, String attachmentKey, boolean importBid, Map<String, String> genericDomains) throws SQLException, ConverterException {
        String bid = iomBasket.getBid();
        String tag = iomBasket.getType();
        String domains = XtfWriter.domainsToString(genericDomains);
        String sqlname = "T_ILI2DB_BASKET";
        if (this.schema != null) {
            sqlname = this.schema + "." + sqlname;
        }
        String insert = "INSERT INTO " + sqlname + "(" + this.colT_ID + ", " + "topic" + ", " + "T_Ili_Tid" + ", " + "attachmentKey" + ", " + "dataset" + ", " + "domains" + ") VALUES (?,?,?,?,?,?)";
        EhiLogger.traceBackendCmd((String)insert);
        PreparedStatement ps = this.conn.prepareStatement(insert);
        try {
            int valuei = 1;
            ps.setLong(valuei, basketSqlId);
            ps.setString(++valuei, tag);
            ++valuei;
            if (importBid) {
                ps.setString(valuei, bid);
            } else {
                ps.setNull(valuei, 12);
            }
            ps.setString(++valuei, attachmentKey);
            ps.setLong(++valuei, datasetSqlId);
            ps.setString(++valuei, domains);
            ++valuei;
            ps.executeUpdate();
        }
        finally {
            ps.close();
        }
        return basketSqlId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeDataset(long datasetSqlId, String datasetName) throws SQLException {
        String sqlname = "T_ILI2DB_DATASET";
        if (this.schema != null) {
            sqlname = this.schema + "." + sqlname;
        }
        String insert = "INSERT INTO " + sqlname + "(" + this.colT_ID + "," + "datasetName" + ") VALUES (?,?)";
        EhiLogger.traceBackendCmd((String)insert);
        PreparedStatement ps = this.conn.prepareStatement(insert);
        try {
            int valuei = 1;
            ps.setLong(valuei, datasetSqlId);
            ps.setString(++valuei, datasetName);
            ++valuei;
            ps.executeUpdate();
        }
        finally {
            ps.close();
        }
        return datasetSqlId;
    }

    private String createItfLineTableInsertStmt(AttributeDef attrDef, Integer epsgCode) {
        Table lineAttrTable;
        SurfaceOrAreaType type = (SurfaceOrAreaType)attrDef.getDomainResolvingAliases();
        StringBuffer stmt = new StringBuffer();
        StringBuffer values = new StringBuffer();
        stmt.append("INSERT INTO ");
        DbTableName sqlTabName = this.getSqlTableNameItfLineTable(attrDef, epsgCode);
        stmt.append(sqlTabName.getQName());
        String sep = " (";
        stmt.append(sep);
        sep = ",";
        stmt.append(this.colT_ID);
        values.append("?");
        if (this.createBasketCol) {
            stmt.append(sep);
            sep = ",";
            stmt.append("T_basket");
            values.append(",?");
        }
        if (this.createDatasetCol) {
            stmt.append(sep);
            sep = ",";
            stmt.append("T_datasetname");
            values.append(",?");
        }
        if (this.readIliTid) {
            stmt.append(sep);
            sep = ",";
            stmt.append("T_Ili_Tid");
            values.append(",?");
        }
        stmt.append(sep);
        sep = ",";
        stmt.append(this.ili2sqlName.getSqlColNameItfLineTableGeomAttr(attrDef, sqlTabName.getName()));
        values.append("," + this.geomConv.getInsertValueWrapperPolyline("?", epsgCode));
        if (type instanceof SurfaceType) {
            stmt.append(sep);
            sep = ",";
            stmt.append(this.ili2sqlName.getSqlColNameItfLineTableRefAttr(attrDef, sqlTabName.getName()));
            values.append(",?");
        }
        if ((lineAttrTable = type.getLineAttributeStructure()) != null) {
            Iterator attri = lineAttrTable.getAttributes();
            while (attri.hasNext()) {
                AttributeDef lineattr = (AttributeDef)attri.next();
                sep = this.recConv.addAttrToInsertStmt(false, stmt, values, sep, lineattr, lineattr, null, sqlTabName.getName());
            }
        }
        if (this.createStdCols) {
            stmt.append(sep);
            sep = ",";
            stmt.append("T_LastChange");
            values.append(",?");
            stmt.append(sep);
            sep = ",";
            stmt.append("T_CreateDate");
            values.append(",?");
            stmt.append(sep);
            sep = ",";
            stmt.append("T_User");
            values.append(",?");
        }
        stmt.append(") VALUES (");
        stmt.append(values);
        stmt.append(")");
        return stmt.toString();
    }

    private String getInsertStmt(boolean isUpdate, Viewable iomClass, ViewableWrapper sqltable, AbstractStructWrapper structEle) {
        String key = null;
        if (!this.createGenericStructRef && structEle != null && structEle instanceof StructWrapper && sqltable.getExtending() == null) {
            ViewableWrapper parentTable = this.recConv.getViewableWrapper(((StructWrapper)structEle).getParentSqlType());
            key = sqltable.getSqlTablename() + ":" + iomClass.getScopedName(null) + ":" + parentTable.getSqlTablename() + ":" + ((StructWrapper)structEle).getParentAttr();
        } else {
            key = sqltable.getSqlTablename() + ":" + iomClass.getScopedName(null);
        }
        if (isUpdate) {
            if (this.updateStmts.containsKey(key)) {
                return this.updateStmts.get(key);
            }
        } else if (this.insertStmts.containsKey(key)) {
            return this.insertStmts.get(key);
        }
        String stmt = this.recConv.createInsertStmt(isUpdate, iomClass, new DbTableName(this.schema, sqltable.getSqlTablename()), sqltable, structEle);
        EhiLogger.traceBackendCmd((String)stmt);
        if (isUpdate) {
            this.updateStmts.put(key, stmt);
        } else {
            this.insertStmts.put(key, stmt);
        }
        return stmt;
    }
}

