/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromili;

import ch.ehi.basics.types.OutParam;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.base.DbNames;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.converter.AbstractRecordConverter;
import ch.ehi.ili2db.dbmetainfo.DbExtMetaInfo;
import ch.ehi.ili2db.fromili.CustomMapping;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.ArrayMapping;
import ch.ehi.ili2db.mapping.ColumnWrapper;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColJson;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColXml;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAssocRole;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.Viewable;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FromIliRecordConverter
extends AbstractRecordConverter {
    private DbSchema schema = null;
    private CustomMapping customMapping = null;
    private HashSet visitedEnumsAttrs = null;
    private String nl = System.getProperty("line.separator");
    private boolean coalesceCatalogueRef = true;
    private boolean coalesceMultiSurface = true;
    private boolean coalesceMultiLine = true;
    private boolean coalesceMultiPoint = true;
    private boolean coalesceArray = true;
    private boolean coalesceJson = true;
    private boolean expandMultilingual = true;
    private boolean expandLocalised = true;
    private boolean createUnique = true;
    private boolean createNumCheck = false;
    private boolean createTextCheck = false;
    private boolean createDateTimeCheck = false;
    private DbExtMetaInfo metaInfo = null;
    private boolean createTypeConstraint = false;
    private boolean createIliTidCol = false;

    public FromIliRecordConverter(TransferDescription td1, NameMapping ili2sqlName, Config config, DbSchema schema1, CustomMapping customMapping1, DbIdGen idGen1, HashSet visitedEnumsAttrs1, TrafoConfig trafoConfig, Viewable2TableMapping class2wrapper1, DbExtMetaInfo metaInfo) {
        super(td1, ili2sqlName, config, idGen1, trafoConfig, class2wrapper1);
        this.visitedEnumsAttrs = visitedEnumsAttrs1;
        this.customMapping = customMapping1;
        this.schema = schema1;
        this.coalesceCatalogueRef = "coalesce".equals(config.getCatalogueRefTrafo());
        this.coalesceMultiSurface = "coalesce".equals(config.getMultiSurfaceTrafo());
        this.coalesceMultiLine = "coalesce".equals(config.getMultiLineTrafo());
        this.coalesceMultiPoint = "coalesce".equals(config.getMultiPointTrafo());
        this.coalesceArray = "coalesce".equals(config.getArrayTrafo());
        this.coalesceJson = "coalesce".equals(config.getJsonTrafo());
        this.expandMultilingual = "expand".equals(config.getMultilingualTrafo());
        this.expandLocalised = "expand".equals(config.getLocalisedTrafo());
        this.createUnique = config.isCreateUniqueConstraints();
        this.createNumCheck = config.isCreateCreateNumChecks();
        this.createTextCheck = config.isCreateCreateTextChecks();
        this.createDateTimeCheck = config.isCreateCreateDateTimeChecks();
        this.metaInfo = metaInfo;
        this.createTypeConstraint = config.getCreateTypeConstraint();
        this.createIliTidCol = "property".equals(config.getTidHandling());
    }

    public void generateTable(ViewableWrapper def, int pass) throws Ili2dbException {
        DbIndex dbIndex;
        Object object;
        if (pass == 1) {
            DbTableName sqlName = new DbTableName(this.schema.getName(), def.getSqlTablename());
            DbTable dbTable = new DbTable();
            dbTable.setName(sqlName);
            this.schema.addTable(dbTable);
            return;
        }
        DbTableName sqlName = new DbTableName(this.schema.getName(), def.getSqlTablename());
        DbTable dbTable = this.schema.findTable(sqlName);
        ViewableWrapper base = def.getExtending();
        StringBuffer cmt = new StringBuffer();
        String cmtSep = "";
        if (!def.isSecondaryTable()) {
            dbTable.setIliName(def.getViewable().getScopedName(null));
            if (def.getViewable().getDocumentation() != null) {
                cmt.append(cmtSep + def.getViewable().getDocumentation());
                cmtSep = this.nl;
            }
        }
        if (cmt.length() > 0) {
            dbTable.setComment(cmt.toString());
        }
        if (base == null && !def.isSecondaryTable()) {
            dbTable.setRequiresSequence(true);
        }
        String baseRef = "";
        DbColId dbColId = this.addKeyCol(dbTable);
        if (base != null) {
            dbColId.setScriptComment("REFERENCES " + base.getViewable().getScopedName(null));
            if (this.createFk) {
                dbColId.setReferencedTable(this.getSqlType(base.getViewable()));
            }
            this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbColId.getName(), "ch.ehi.ili2db.foreignKey", this.getSqlType(base.getViewable()).getName());
        } else if (def.isSecondaryTable()) {
            if (this.createFk) {
                dbColId.setReferencedTable(new DbTableName(this.schema.getName(), def.getMainTable().getSqlTablename()));
            }
            this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbColId.getName(), "ch.ehi.ili2db.foreignKey", def.getMainTable().getSqlTablename());
        }
        if (this.createBasketCol) {
            DbColId t_basket = new DbColId();
            t_basket.setName("T_basket");
            t_basket.setNotNull(true);
            t_basket.setScriptComment("REFERENCES T_ILI2DB_BASKET");
            if (this.createFk) {
                t_basket.setReferencedTable(new DbTableName(this.schema.getName(), "T_ILI2DB_BASKET"));
            }
            if (this.createFkIdx) {
                t_basket.setIndex(true);
            }
            dbTable.addColumn((DbColumn)t_basket);
        }
        if (this.createDatasetCol) {
            DbColVarchar t_dsName = new DbColVarchar();
            t_dsName.setName("T_datasetname");
            t_dsName.setSize(200);
            t_dsName.setNotNull(true);
            t_dsName.setIndex(true);
            dbTable.addColumn((DbColumn)t_dsName);
        }
        if (base == null && !def.isSecondaryTable()) {
            DbColumn dbCol;
            if (this.createTypeDiscriminator || def.includesMultipleTypes()) {
                dbCol = this.createSqlTypeCol("T_Type");
                ArrayList<String> extensions = new ArrayList<String>();
                for (Object o : def.getViewable().getExtensions()) {
                    Viewable v = (Viewable)o;
                    if (v.isAbstract()) continue;
                    extensions.add(this.ili2sqlName.mapIliClassDef(v));
                }
                Collections.sort(extensions);
                String jsonExtensions = "";
                JsonFactory factory = new JsonFactory();
                StringWriter out = new StringWriter();
                try {
                    JsonGenerator generator = factory.createGenerator((Writer)out);
                    generator.writeStartArray();
                    for (String e : extensions) {
                        generator.writeString(e);
                    }
                    generator.writeEndArray();
                    generator.flush();
                    jsonExtensions = out.toString();
                    generator.close();
                }
                catch (IOException e) {
                    throw new Ili2dbException(e);
                }
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), "T_Type", "ch.ehi.ili2db.types", jsonExtensions);
                if (this.createTypeConstraint) {
                    String[] possibleValues = new String[extensions.size()];
                    ((DbColVarchar)dbCol).setValueRestriction(extensions.toArray(possibleValues));
                }
                dbTable.addColumn(dbCol);
            }
            if (!(def.getViewable() instanceof AssociationDef && ((AssociationDef)def.getViewable()).isLightweight() || (!this.createIliTidCol || def.getViewable() instanceof AssociationDef) && !def.hasOid())) {
                this.addIliTidCol(dbTable, def.getOid());
                if (def.getOid() != null) {
                    this.metaInfo.setColumnInfo(dbTable.getName().getName(), "T_Ili_Tid", "ch.ehi.ili2db.oidDomain", def.getOid().getScopedName());
                }
            }
            if (def.isStructure()) {
                if (this.createGenericStructRef) {
                    DbColId dbParentId = new DbColId();
                    dbParentId.setName("T_ParentId");
                    dbParentId.setNotNull(true);
                    dbParentId.setPrimaryKey(false);
                    dbTable.addColumn((DbColumn)dbParentId);
                    dbCol = this.createSqlTypeCol("T_ParentType");
                    dbTable.addColumn(dbCol);
                    dbCol = this.createSqlTypeCol("T_ParentAttr");
                    dbTable.addColumn(dbCol);
                }
                DbColId dbSeq = new DbColId();
                dbSeq.setName("T_Seq");
                dbSeq.setPrimaryKey(false);
                dbTable.addColumn((DbColumn)dbSeq);
            }
        }
        Iterator<ColumnWrapper> iter = def.getAttrIterator();
        while (iter.hasNext()) {
            RoleDef role;
            ColumnWrapper columnWrapper = iter.next();
            if (columnWrapper.getViewableTransferElement().obj instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)columnWrapper.getViewableTransferElement().obj;
                try {
                    Type proxyType;
                    if (!(attr.isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                        Integer epsgCode = columnWrapper.getEpsgCode();
                        this.generateAttr(dbTable, def.getViewable(), attr, epsgCode);
                    }
                }
                catch (Exception ex) {
                    throw new Ili2dbException(attr.getContainer().getScopedName(null) + "." + attr.getName(), ex);
                }
            }
            if (!(columnWrapper.getViewableTransferElement().obj instanceof RoleDef) || (role = (RoleDef)columnWrapper.getViewableTransferElement().obj).getExtending() != null) continue;
            if (columnWrapper.getViewableTransferElement().embedded) {
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() != null) continue;
                ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)role.getDestination());
                object = targetTables.iterator();
                while (object.hasNext()) {
                    String cmt2;
                    ViewableWrapper targetTable = (ViewableWrapper)object.next();
                    dbColId = new DbColId();
                    DbTableName targetSqlTableName = targetTable.getSqlTable();
                    String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, sqlName.getName(), targetSqlTableName.getName(), targetTables.size() > 1);
                    dbColId.setName(roleSqlName);
                    boolean notNull = false;
                    if (!this.sqlEnableNull) {
                        notNull = targetTables.size() > 1 ? false : (role.getOppEnd().getDestination() != def.getViewable() ? false : role.getCardinality().getMinimum() != 0L);
                    }
                    dbColId.setNotNull(notNull);
                    dbColId.setPrimaryKey(false);
                    if (this.createFk) {
                        dbColId.setReferencedTable(targetSqlTableName);
                    }
                    this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbColId.getName(), "ch.ehi.ili2db.foreignKey", targetSqlTableName.getName());
                    if (this.createFkIdx) {
                        dbColId.setIndex(true);
                    }
                    if ((cmt2 = role.getDocumentation()) != null && cmt2.length() > 0) {
                        dbColId.setComment(cmt2);
                    }
                    this.customMapping.fixupEmbeddedLink(dbTable, (DbColumn)dbColId, roleOwner, role, targetSqlTableName, this.colT_ID);
                    dbTable.addColumn((DbColumn)dbColId);
                    if (!role.getOppEnd().isOrdered()) continue;
                    DbColId dbSeq = new DbColId();
                    dbSeq.setName(roleSqlName + "_" + "T_Seq");
                    dbSeq.setNotNull(notNull);
                    dbSeq.setPrimaryKey(false);
                    dbTable.addColumn((DbColumn)dbSeq);
                }
                continue;
            }
            ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)role.getDestination());
            for (ViewableWrapper targetTable : targetTables) {
                String cmt3;
                dbColId = new DbColId();
                DbTableName targetSqlTableName = targetTable.getSqlTable();
                String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, sqlName.getName(), targetSqlTableName.getName(), targetTables.size() > 1);
                dbColId.setName(roleSqlName);
                boolean notNull = false;
                if (!this.sqlEnableNull) {
                    notNull = targetTables.size() <= 1;
                }
                dbColId.setNotNull(notNull);
                dbColId.setPrimaryKey(false);
                if (this.createFk) {
                    dbColId.setReferencedTable(targetSqlTableName);
                }
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbColId.getName(), "ch.ehi.ili2db.foreignKey", targetSqlTableName.getName());
                if (this.createFkIdx) {
                    dbColId.setIndex(true);
                }
                if ((cmt3 = role.getDocumentation()) != null && cmt3.length() > 0) {
                    dbColId.setComment(cmt3);
                }
                dbTable.addColumn((DbColumn)dbColId);
                if (this.createFk && def.getViewable() instanceof AssociationDef && ((AssociationDef)def.getViewable()).isLightweight() && role.getCardinality().getMaximum() > 1L) {
                    dbIndex = new DbIndex();
                    dbIndex.setPrimary(false);
                    dbIndex.setUnique(true);
                    dbIndex.addAttr((DbColumn)dbColId);
                    dbTable.addIndex(dbIndex);
                }
                if (!role.isOrdered()) continue;
                DbColId dbSeq = new DbColId();
                dbSeq.setName(roleSqlName + "_" + "T_Seq");
                dbSeq.setNotNull(notNull);
                dbSeq.setPrimaryKey(false);
                dbTable.addColumn((DbColumn)dbSeq);
            }
        }
        if (this.createStdCols) {
            FromIliRecordConverter.addStdCol(dbTable);
        }
        if (this.createUnique && !def.isStructure()) {
            Viewable aclass = def.getViewable();
            for (Object cnstro : aclass) {
                if (!(cnstro instanceof UniquenessConstraint)) continue;
                UniquenessConstraint cnstr = (UniquenessConstraint)cnstro;
                object = this.getEpsgCodes(def.getAttrv());
                int n = ((Integer[])object).length;
                for (int i = 0; i < n; ++i) {
                    int epsgCode = (Integer)object[i];
                    HashSet attrs = this.getUniqueAttrs(cnstr, def.getAttrv(), epsgCode);
                    if (attrs == null) continue;
                    dbIndex = new DbIndex();
                    dbIndex.setPrimary(false);
                    dbIndex.setUnique(true);
                    for (Object attro : attrs) {
                        String attrSqlName = null;
                        if (attro instanceof AttributeDef) {
                            Type attrType = ((AttributeDef)attro).getDomainResolvingAliases();
                            attrSqlName = attrType instanceof CoordType || attrType instanceof LineType ? this.ili2sqlName.mapIliAttributeDef((AttributeDef)attro, epsgCode, def.getSqlTablename(), null) : this.ili2sqlName.mapIliAttributeDef((AttributeDef)attro, null, def.getSqlTablename(), null);
                        } else if (attro instanceof RoleDef) {
                            RoleDef role = (RoleDef)attro;
                            DbTableName targetSqlTableName = this.getSqlType((Viewable)role.getDestination());
                            attrSqlName = this.ili2sqlName.mapIliRoleDef(role, def.getSqlTablename(), targetSqlTableName.getName());
                        } else {
                            throw new IllegalStateException("unexpected attr " + attro);
                        }
                        DbColumn idxCol = dbTable.getColumn(attrSqlName);
                        dbIndex.addAttr(idxCol);
                    }
                    dbTable.addIndex(dbIndex);
                }
            }
        }
        if (!def.isSecondaryTable()) {
            this.customMapping.fixupViewable(dbTable, def.getViewable());
        }
    }

    private List<Viewable> getPotentialClassTypes(Viewable def) {
        ArrayList<Viewable> extensions = new ArrayList<Viewable>();
        this.getExtensions_recursiveHelper(def, extensions);
        return extensions;
    }

    private final void getExtensions_recursiveHelper(Viewable def, List<Viewable> s) {
        if (!def.isAbstract()) {
            s.add(def);
        }
        for (Viewable ext : def.getDirectExtensions()) {
            String trafo;
            if (ext.isAbstract() || (trafo = this.trafoConfig.getViewableConfig(ext, "ch.ehi.ili2db.inheritance")) != null && trafo.equals("newAndSubClass")) continue;
            this.getExtensions_recursiveHelper(ext, s);
        }
    }

    private Integer[] getEpsgCodes(List<ColumnWrapper> attrv) {
        HashSet<Integer> epsgCodes = new HashSet<Integer>();
        for (ColumnWrapper col : attrv) {
            if (col.getEpsgCode() == null) continue;
            epsgCodes.add(col.getEpsgCode());
        }
        return epsgCodes.toArray(new Integer[epsgCodes.size()]);
    }

    private HashSet getUniqueAttrs(UniquenessConstraint cnstr, List<ColumnWrapper> colv, int epsgCode) {
        if (cnstr.getLocal()) {
            return null;
        }
        HashSet<Object> wrapperCols = new HashSet<Object>();
        for (ColumnWrapper col : colv) {
            if (col.getEpsgCode() != null) {
                if (col.getEpsgCode() != epsgCode) continue;
                wrapperCols.add(col.getViewableTransferElement().obj);
                continue;
            }
            wrapperCols.add(col.getViewableTransferElement().obj);
        }
        HashSet<Object> ret = new HashSet<Object>();
        UniqueEl attribs = cnstr.getElements();
        Iterator attri = attribs.iteratorAttribute();
        while (attri.hasNext()) {
            ObjectPath path = (ObjectPath)attri.next();
            PathEl[] pathEles = path.getPathElements();
            if (pathEles.length != 1) {
                return null;
            }
            PathEl pathEle = pathEles[0];
            if (pathEle instanceof AttributeRef) {
                AttributeDef attr = ((AttributeRef)pathEle).getAttr();
                while (attr.getExtending() != null) {
                    attr = (AttributeDef)attr.getExtending();
                }
                if (!wrapperCols.contains(attr)) {
                    return null;
                }
                ret.add(attr);
                continue;
            }
            if (pathEle instanceof PathElAssocRole) {
                RoleDef role = ((PathElAssocRole)pathEle).getRole();
                while (role.getExtending() != null) {
                    role = (RoleDef)role.getExtending();
                }
                if (!wrapperCols.contains(role)) {
                    return null;
                }
                ret.add(role);
                continue;
            }
            return null;
        }
        return ret;
    }

    public void generateAttr(DbTable dbTable, Viewable aclass, AttributeDef attr, Integer epsgCode) throws Ili2dbException {
        String sqlColName;
        DbColVarchar ret;
        OutParam dbCol = new OutParam();
        dbCol.value = null;
        OutParam unitDef = new OutParam();
        unitDef.value = null;
        OutParam mText = new OutParam();
        mText.value = false;
        ArrayList<DbColumn> dbColExts = new ArrayList<DbColumn>();
        Type type = attr.getDomainResolvingAll();
        if (!this.createSimpleDbCol(dbTable, aclass, attr, type, (OutParam<DbColumn>)dbCol, (OutParam<Unit>)unitDef, (OutParam<Boolean>)mText, dbColExts)) {
            DbColId ret2;
            ArrayList<ViewableWrapper> targetTables;
            if (type instanceof SurfaceOrAreaType) {
                CoordType coord;
                if (this.createItfLineTables) {
                    dbCol.value = null;
                } else {
                    ret = new DbColGeometry();
                    boolean curvePolygon = false;
                    if (!this.strokeArcs) {
                        curvePolygon = true;
                    }
                    ret.setType(curvePolygon ? 10 : 3);
                    this.setCrs((DbColGeometry)ret, epsgCode);
                    coord = (CoordType)((SurfaceOrAreaType)type).getControlPointDomain().getType();
                    ret.setDimension(coord.getDimensions().length);
                    this.setBB((DbColGeometry)ret, coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                    dbCol.value = ret;
                }
                if (this.createItfAreaRef && type instanceof AreaType) {
                    ret = new DbColGeometry();
                    String sqlName = this.getSqlAttrName(attr, epsgCode, dbTable.getName().getName(), null) + "_ref";
                    ret.setName(sqlName);
                    ret.setType(0);
                    this.setNullable(aclass, attr, (DbColumn)ret);
                    this.setCrs((DbColGeometry)ret, epsgCode);
                    ret.setDimension(2);
                    coord = (CoordType)((SurfaceOrAreaType)type).getControlPointDomain().getType();
                    this.setBB((DbColGeometry)ret, coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                    dbColExts.add((DbColumn)ret);
                }
            } else if (type instanceof PolylineType) {
                String attrName = attr.getContainer().getScopedName(null) + "." + attr.getName();
                DbColGeometry ret3 = this.generatePolylineType((LineType)((PolylineType)type), attrName);
                this.setCrs(ret3, epsgCode);
                dbCol.value = ret3;
            } else if (type instanceof CoordType) {
                ret = new DbColGeometry();
                ret.setType(0);
                this.setCrs((DbColGeometry)ret, epsgCode);
                CoordType coord = (CoordType)type;
                ret.setDimension(coord.getDimensions().length);
                this.setBB((DbColGeometry)ret, coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                dbCol.value = ret;
            } else if (type instanceof CompositionType) {
                if (!this.createGenericStructRef) {
                    CoordType coord;
                    if (this.isChbaseCatalogueRef(this.td, attr) && (this.coalesceCatalogueRef || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.catalogueRefTrafo")))) {
                        targetTables = this.getTargetTables((Viewable)FromIliRecordConverter.getCatalogueRefTarget(type));
                        for (ViewableWrapper targetTable : targetTables) {
                            ret2 = new DbColId();
                            ret2.setName(this.ili2sqlName.mapIliAttributeDef(attr, dbTable.getName().getName(), targetTable.getSqlTablename(), targetTables.size() > 1));
                            ret2.setNotNull(false);
                            ret2.setPrimaryKey(false);
                            if (this.createFk) {
                                ret2.setReferencedTable(targetTable.getSqlTable());
                            }
                            this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, ret2.getName(), "ch.ehi.ili2db.foreignKey", targetTable.getSqlTablename());
                            if (this.createFkIdx) {
                                ret2.setIndex(true);
                            }
                            dbColExts.add((DbColumn)ret2);
                        }
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.catalogueRefTrafo", "coalesce");
                    } else if (Ili2cUtility.isMultiSurfaceAttr(this.td, attr) && (this.coalesceMultiSurface || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiSurfaceTrafo")))) {
                        this.multiSurfaceAttrs.addMultiSurfaceAttr(attr);
                        ret = new DbColGeometry();
                        boolean curvePolygon = false;
                        if (!this.strokeArcs) {
                            curvePolygon = true;
                        }
                        ret.setType(curvePolygon ? 12 : 6);
                        AttributeDef surfaceAttr = this.multiSurfaceAttrs.getSurfaceAttr(attr);
                        this.setCrs((DbColGeometry)ret, epsgCode);
                        SurfaceType surface = (SurfaceType)surfaceAttr.getDomainResolvingAliases();
                        coord = (CoordType)surface.getControlPointDomain().getType();
                        ret.setDimension(coord.getDimensions().length);
                        this.setBB((DbColGeometry)ret, coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                        dbCol.value = ret;
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.multiSurfaceTrafo", "coalesce");
                    } else if (Ili2cUtility.isMultiLineAttr(this.td, attr) && (this.coalesceMultiLine || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiLineTrafo")))) {
                        this.multiLineAttrs.addMultiLineAttr(attr);
                        ret = new DbColGeometry();
                        boolean curvePolyline = false;
                        if (!this.strokeArcs) {
                            curvePolyline = true;
                        }
                        ret.setType(curvePolyline ? 11 : 5);
                        AttributeDef polylineAttr = this.multiLineAttrs.getPolylineAttr(attr);
                        this.setCrs((DbColGeometry)ret, epsgCode);
                        PolylineType polylineType = (PolylineType)polylineAttr.getDomainResolvingAliases();
                        coord = (CoordType)polylineType.getControlPointDomain().getType();
                        ret.setDimension(coord.getDimensions().length);
                        this.setBB((DbColGeometry)ret, coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                        dbCol.value = ret;
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.multiLineTrafo", "coalesce");
                    } else if (Ili2cUtility.isMultiPointAttr(this.td, attr) && (this.coalesceMultiPoint || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiPointTrafo")))) {
                        this.multiPointAttrs.addMultiPointAttr(attr);
                        ret = new DbColGeometry();
                        ret.setType(4);
                        AttributeDef coordAttr = this.multiPointAttrs.getCoordAttr(attr);
                        this.setCrs((DbColGeometry)ret, epsgCode);
                        CoordType coord2 = (CoordType)coordAttr.getDomainResolvingAliases();
                        ret.setDimension(coord2.getDimensions().length);
                        this.setBB((DbColGeometry)ret, coord2, attr.getContainer().getScopedName(null) + "." + attr.getName());
                        dbCol.value = ret;
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.multiPointTrafo", "coalesce");
                    } else if (Ili2cUtility.isArrayAttr(this.td, attr) && (this.coalesceArray || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.arrayTrafo")))) {
                        this.arrayAttrs.addArrayAttr(attr);
                        ArrayMapping attrMapping = this.arrayAttrs.getMapping(attr);
                        AttributeDef localAttr = attrMapping.getValueAttr();
                        Type localType = localAttr.getDomainResolvingAll();
                        if (!this.createSimpleDbCol(dbTable, aclass, localAttr, localType, (OutParam<DbColumn>)dbCol, (OutParam<Unit>)unitDef, (OutParam<Boolean>)mText, dbColExts)) {
                            throw new IllegalStateException("unexpected attr type " + localAttr.getScopedName());
                        }
                        ((DbColumn)dbCol.value).setArraySize(-1);
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.arrayTrafo", "coalesce");
                    } else if (Ili2cUtility.isJsonAttr(this.td, attr) && (this.coalesceJson || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.jsonTrafo")))) {
                        ret = new DbColJson();
                        dbCol.value = ret;
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.jsonTrafo", "coalesce");
                    } else if (this.isMultilingualTextAttr(this.td, attr) && (this.expandMultilingual || "expand".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multilingualTrafo")))) {
                        for (DbColVarchar sfx : DbNames.MULTILINGUAL_TXT_COL_SUFFIXS) {
                            DbColVarchar ret4 = new DbColVarchar();
                            ret4.setName(this.getSqlAttrName(attr, null, dbTable.getName().getName(), null) + (String)sfx);
                            ret4.setSize(-1);
                            if (this.createTextCheck) {
                                ret4.setMinLength(Integer.valueOf(1));
                            }
                            ret4.setNotNull(false);
                            ret4.setPrimaryKey(false);
                            dbColExts.add((DbColumn)ret4);
                        }
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.multilingualTrafo", "expand");
                    } else if (this.isLocalisedTextAttr(this.td, attr) && (this.expandLocalised || "expand".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.localisedTrafo")))) {
                        ret = new DbColVarchar();
                        ret.setName(this.getSqlAttrName(attr, null, dbTable.getName().getName(), null));
                        ret.setSize(-1);
                        ret.setNotNull(false);
                        ret.setPrimaryKey(false);
                        dbCol.value = ret;
                        ret = new DbColVarchar();
                        ret.setName(this.getSqlAttrName(attr, null, dbTable.getName().getName(), null) + "_lang");
                        ret.setSize(2);
                        ret.setNotNull(false);
                        ret.setPrimaryKey(false);
                        dbColExts.add((DbColumn)ret);
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.localisedTrafo", "expand");
                    } else {
                        this.addParentRef(aclass, attr);
                        dbCol.value = null;
                    }
                } else {
                    dbCol.value = null;
                }
            } else if (type instanceof ReferenceType) {
                targetTables = this.getTargetTables((Viewable)((ReferenceType)type).getReferred());
                for (ViewableWrapper targetTable : targetTables) {
                    ret2 = new DbColId();
                    ret2.setName(this.ili2sqlName.mapIliAttributeDef(attr, dbTable.getName().getName(), targetTable.getSqlTablename(), targetTables.size() > 1));
                    ret2.setNotNull(false);
                    ret2.setPrimaryKey(false);
                    if (this.createFk) {
                        ret2.setReferencedTable(targetTable.getSqlTable());
                    }
                    if (this.createFkIdx) {
                        ret2.setIndex(true);
                    }
                    dbColExts.add((DbColumn)ret2);
                }
            } else {
                ret = new DbColVarchar();
                ret.setSize(255);
                dbCol.value = ret;
            }
        }
        if (type instanceof EnumerationType) {
            if (this.createEnumTxtCol) {
                ret = new DbColVarchar();
                ret.setSize(255);
                ret.setName(this.getSqlAttrName(attr, null, dbTable.getName().getName(), null) + "_txt");
                this.setNullable(aclass, attr, (DbColumn)ret);
                dbColExts.add((DbColumn)ret);
            }
            sqlColName = this.getSqlAttrName(attr, epsgCode, dbTable.getName().getName(), null);
            String attrName = attr.getName();
            List<Viewable> exts = this.getPotentialClassTypes(aclass);
            for (Viewable extV : exts) {
                Type extType;
                AttributeDef extAttr = null;
                extAttr = (AttributeDef)extV.getElement(AttributeDef.class, attrName);
                if (extAttr == null || !((extType = extAttr.getDomain()) instanceof TypeAlias)) continue;
                Domain domain = ((TypeAlias)extType).getAliasing();
                String domainSqlName = domain.getScopedName();
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), this.getSqlType(extV).getName(), sqlColName, "ch.ehi.ili2db.enumDomain", domainSqlName);
            }
        }
        if (dbCol.value != null) {
            String dispName;
            sqlColName = this.getSqlAttrName(attr, epsgCode, dbTable.getName().getName(), null);
            this.setAttrDbColProps(aclass, attr, (DbColumn)dbCol.value, sqlColName);
            String subType = null;
            Viewable attrClass = (Viewable)attr.getContainer();
            if (attrClass != aclass && attrClass.isExtending((Element)aclass)) {
                subType = this.getSqlType(attrClass).getName();
            }
            if (unitDef.value != null) {
                String unitName = ((Unit)unitDef.value).getName();
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.unit", unitName);
            }
            if (((Boolean)mText.value).booleanValue()) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.textKind", "MTEXT");
            }
            if (((DbColumn)dbCol.value).getReferencedTable() != null) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, ((DbColumn)dbCol.value).getName(), "ch.ehi.ili2db.foreignKey", ((DbColumn)dbCol.value).getReferencedTable().getName());
            }
            if (dbCol.value instanceof DbColGeometry) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c1Min", ((DbColGeometry)dbCol.value).getMin1AsString());
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c1Max", ((DbColGeometry)dbCol.value).getMax1AsString());
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c2Min", ((DbColGeometry)dbCol.value).getMin2AsString());
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c2Max", ((DbColGeometry)dbCol.value).getMax2AsString());
                if (((DbColGeometry)dbCol.value).getDimension() == 3) {
                    this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c3Min", ((DbColGeometry)dbCol.value).getMin3AsString());
                    this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c3Max", ((DbColGeometry)dbCol.value).getMax3AsString());
                }
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.geomType", FromIliRecordConverter.getIli2DbGeomType(((DbColGeometry)dbCol.value).getType()));
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.srid", ((DbColGeometry)dbCol.value).getSrsId());
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.coordDimension", Integer.toString(((DbColGeometry)dbCol.value).getDimension()));
            }
            if ((dispName = attr.getMetaValues().getValue("ili2db.dispName")) != null) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.dispName", dispName);
            }
            this.customMapping.fixupAttribute(dbTable, (DbColumn)dbCol.value, attr);
            dbTable.addColumn((DbColumn)dbCol.value);
        }
        for (DbColumn dbColExt : dbColExts) {
            this.customMapping.fixupAttribute(dbTable, dbColExt, attr);
            dbTable.addColumn(dbColExt);
        }
        if (dbCol.value == null && dbColExts.size() == 0) {
            this.customMapping.fixupAttribute(dbTable, null, attr);
        }
    }

    private AttributeDef getDefinedAttribute(Viewable aclass, String attrName) {
        Iterator attri = aclass.getDefinedAttributes();
        while (attri.hasNext()) {
            AttributeDef attr = (AttributeDef)attri.next();
            if (!attr.getName().equals(attrName)) continue;
            return attr;
        }
        return null;
    }

    public static String getIli2DbGeomType(int type) {
        switch (type) {
            case 0: {
                return "POINT";
            }
            case 2: {
                return "LINESTRING";
            }
            case 3: {
                return "POLYGON";
            }
            case 4: {
                return "MULTIPOINT";
            }
            case 5: {
                return "MULTILINESTRING";
            }
            case 6: {
                return "MULTIPOLYGON";
            }
            case 7: {
                return "GEOMETRYCOLLECTION";
            }
            case 8: {
                return "CIRCULARSTRING";
            }
            case 9: {
                return "COMPOUNDCURVE";
            }
            case 10: {
                return "CURVEPOLYGON";
            }
            case 11: {
                return "MULTICURVE";
            }
            case 12: {
                return "MULTISURFACE";
            }
            case 15: {
                return "POLYHEDRALSURFACE";
            }
            case 16: {
                return "TIN";
            }
            case 17: {
                return "TRIANGLE";
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean createSimpleDbCol(DbTable dbTable, Viewable aclass, AttributeDef attr, Type type, OutParam<DbColumn> dbCol, OutParam<Unit> unitDef, OutParam<Boolean> mText, ArrayList<DbColumn> dbColExts) {
        if (attr.isDomainBoolean()) {
            dbCol.value = new DbColBoolean();
        } else if (attr.isDomainIli1Date()) {
            dbCol.value = new DbColDate();
        } else if (attr.isDomainIliUuid()) {
            dbCol.value = new DbColUuid();
        } else if (attr.isDomainIli2Date()) {
            DbColDate ret = new DbColDate();
            dbCol.value = ret;
            if (this.createDateTimeCheck) {
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd");
                FormattedType fmtType = (FormattedType)type;
                try {
                    ret.setMinValue(new Date(dateTimeFormatter.parse(fmtType.getMinimum()).getTime()));
                    ret.setMaxValue(new Date(dateTimeFormatter.parse(fmtType.getMaximum()).getTime()));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (attr.isDomainIli2DateTime()) {
            DbColDateTime ret = new DbColDateTime();
            dbCol.value = ret;
            if (this.createDateTimeCheck) {
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                FormattedType fmtType = (FormattedType)type;
                try {
                    ret.setMinValue(new Timestamp(dateTimeFormatter.parse(fmtType.getMinimum()).getTime()));
                    ret.setMaxValue(new Timestamp(dateTimeFormatter.parse(fmtType.getMaximum()).getTime()));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (attr.isDomainIli2Time()) {
            DbColTime ret = new DbColTime();
            dbCol.value = ret;
            if (this.createDateTimeCheck) {
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
                FormattedType fmtType = (FormattedType)type;
                try {
                    ret.setMinValue(new Time(dateTimeFormatter.parse(fmtType.getMinimum()).getTime()));
                    ret.setMaxValue(new Time(dateTimeFormatter.parse(fmtType.getMaximum()).getTime()));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (type instanceof BasketType) {
            dbCol.value = null;
        } else if (type instanceof EnumerationType) {
            this.visitedEnumsAttrs.add(attr);
            if (this.createEnumColAsItfCode) {
                DbColId ret = new DbColId();
                dbCol.value = ret;
            } else if ("multiTableWithId".equals(this.createEnumTable)) {
                DbColId ret = new DbColId();
                dbCol.value = ret;
                DbTableName targetTable = this.getEnumTargetTableName(attr, null, this.schema.getName());
                if (this.createFk) {
                    ret.setReferencedTable(targetTable);
                }
                if (this.createFkIdx) {
                    ret.setIndex(true);
                }
            } else {
                DbColVarchar ret = new DbColVarchar();
                ret.setSize(255);
                dbCol.value = ret;
            }
        } else if (type instanceof NumericType) {
            if (!type.isAbstract()) {
                PrecisionDecimal min = ((NumericType)type).getMinimum();
                PrecisionDecimal max = ((NumericType)type).getMaximum();
                int minLen = min.toString().length();
                int maxLen = max.toString().length();
                if (min.toString().startsWith("-")) {
                    --minLen;
                }
                if (max.toString().startsWith("-")) {
                    --maxLen;
                }
                if (min.getAccuracy() > 0) {
                    DbColDecimal ret = new DbColDecimal();
                    int size = Math.max(minLen, maxLen) - 1;
                    int precision = min.getAccuracy();
                    ret.setSize(size);
                    ret.setPrecision(precision);
                    if (this.createNumCheck) {
                        ret.setMinValue(Double.valueOf(min.doubleValue()));
                        ret.setMaxValue(Double.valueOf(max.doubleValue()));
                    }
                    dbCol.value = ret;
                } else {
                    DbColNumber ret = new DbColNumber();
                    int size = Math.max(minLen, maxLen);
                    ret.setSize(size);
                    if (this.createNumCheck) {
                        ret.setMinValue(Long.valueOf(min.getUnscaledValue().longValue()));
                        ret.setMaxValue(Long.valueOf(max.getUnscaledValue().longValue()));
                    }
                    dbCol.value = ret;
                }
                unitDef.value = ((NumericType)type).getUnit();
            }
        } else if (type instanceof TextType) {
            DbColVarchar ret = new DbColVarchar();
            if (((TextType)type).getMaxLength() > 0) {
                ret.setSize(((TextType)type).getMaxLength());
            } else {
                ret.setSize(-1);
            }
            if (this.createTextCheck) {
                if (((TextType)type).isNormalized()) {
                    ret.setKind("NORMALIZED");
                }
                ret.setMinLength(Integer.valueOf(1));
            }
            if (!((TextType)type).isNormalized()) {
                mText.value = true;
            }
            dbCol.value = ret;
        } else if (type instanceof BlackboxType) {
            if (((BlackboxType)type).getKind() == 1) {
                DbColXml ret = new DbColXml();
                dbCol.value = ret;
            } else {
                DbColBlob ret = new DbColBlob();
                dbCol.value = ret;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isMultilingualTextAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        return (Ili2cUtility.isMultilingualTextAttr(td, attr) || Ili2cUtility.isMultilingualMTextAttr(td, attr)) && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L;
    }

    private boolean isLocalisedTextAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        return (Ili2cUtility.isLocalisedTextAttr(td, attr) || Ili2cUtility.isLocalisedMTextAttr(td, attr)) && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L;
    }

    private boolean isChbaseCatalogueRef(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        return Ili2cUtility.isPureChbaseCatalogueRef(td, attr) && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L;
    }

    private void addParentRef(Viewable parentTable, AttributeDef attr) {
        CompositionType type = (CompositionType)attr.getDomainResolvingAll();
        Table structClass = type.getComponentType();
        for (ViewableWrapper structWrapper : this.getStructWrappers((Viewable)structClass)) {
            DbTableName structClassSqlName = structWrapper.getSqlTable();
            DbTable dbTable = this.schema.findTable(structClassSqlName);
            String refAttrSqlName = this.ili2sqlName.mapIliAttributeDefReverse(attr, structClassSqlName.getName(), this.class2wrapper.get(parentTable).getSqlTablename());
            DbColId dbParentId = new DbColId();
            dbParentId.setName(refAttrSqlName);
            dbParentId.setNotNull(false);
            dbParentId.setPrimaryKey(false);
            StringBuffer cmt = new StringBuffer();
            String cmtSep = "";
            if (attr.getDocumentation() != null) {
                cmt.append(cmtSep + attr.getDocumentation());
                cmtSep = this.nl;
            }
            if (cmt.length() > 0) {
                dbParentId.setComment(cmt.toString());
            }
            if (this.createFk) {
                dbParentId.setReferencedTable(this.class2wrapper.get(parentTable).getSqlTable());
            }
            this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbParentId.getName(), "ch.ehi.ili2db.foreignKey", this.class2wrapper.get(parentTable).getSqlTablename());
            if (this.createFkIdx) {
                dbParentId.setIndex(true);
            }
            dbTable.addColumn((DbColumn)dbParentId);
        }
    }

    protected void setAttrDbColProps(Viewable aclass, AttributeDef attr, DbColumn dbCol, String sqlName) {
        dbCol.setName(sqlName);
        StringBuffer cmt = new StringBuffer();
        String cmtSep = "";
        if (attr.getDocumentation() != null) {
            cmt.append(cmtSep + attr.getDocumentation());
            cmtSep = this.nl;
        }
        if (cmt.length() > 0) {
            dbCol.setComment(cmt.toString());
        }
        this.setNullable(aclass, attr, dbCol);
    }

    public void setNullable(Viewable aclass, AttributeDef attr, DbColumn dbCol) {
        if (this.sqlEnableNull) {
            dbCol.setNotNull(false);
        } else {
            Type type = attr.getDomain();
            if (type == null) {
                Evaluable[] ev = ((LocalAttribute)attr).getBasePaths();
                type = ((ObjectPath)ev[0]).getType();
            }
            if (type.isMandatoryConsideringAliases() && (attr.getContainer() == aclass || aclass.isExtending((Element)attr.getContainer()))) {
                dbCol.setNotNull(true);
            }
        }
    }

    private DbColumn createSqlTypeCol(String name) {
        DbColVarchar dbCol = new DbColVarchar();
        dbCol.setName(name);
        dbCol.setNotNull(true);
        dbCol.setSize(this.ili2sqlName.getMaxSqlNameLength());
        return dbCol;
    }
}

