/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.types.OutParam;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AssociationPath;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExistenceConstraint;
import ch.interlis.ili2c.metamodel.Expression;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.MandatoryConstraint;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.Objects;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAbstractClassRole;
import ch.interlis.ili2c.metamodel.PathElAssocRole;
import ch.interlis.ili2c.metamodel.PathElRefAttr;
import ch.interlis.ili2c.metamodel.PathElThis;
import ch.interlis.ili2c.metamodel.PlausibilityConstraint;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SetConstraint;
import ch.interlis.ili2c.metamodel.StructAttributeRef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextOIDType;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.ili2c.parser.Ili23Parser;
import ch.interlis.ilirepository.Dataset;
import ch.interlis.ilirepository.ReposManager;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.ItfAreaPolygon2Linetable;
import ch.interlis.iom_j.itf.impl.ItfSurfaceLinetable2Polygon;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CompoundCurveNoder;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iom_j.xtf.XtfWriter;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox.IoxValidationDataPool;
import ch.interlis.iox.IoxValidator;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.IoxIntersectionException;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.ReaderFactory;
import ch.interlis.iox_j.validator.AttributeArray;
import ch.interlis.iox_j.validator.ExternalObjectResolver;
import ch.interlis.iox_j.validator.Ili23KeyWords;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.LinkPool;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.PlausibilityPoolValue;
import ch.interlis.iox_j.validator.Value;
import ch.interlis.iox_j.validator.functions.Interlis;
import ch.interlis.iox_j.validator.functions.Interlis_ext;
import ch.interlis.iox_j.validator.functions.Math;
import ch.interlis.iox_j.validator.functions.Text;
import com.vividsolutions.jts.geom.Coordinate;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator
implements IoxValidator {
    private static final String ENUM_TREE_VALUES = "ENUM_TREE_VALUES";
    public static final String ALL_OBJECTS_ACCESSIBLE = "allObjectsAccessible";
    public static final String REGEX_FOR_ID_VALIDATION = "^[0-9a-zA-Z_][0-9a-zA-Z\\_\\.\\-]*";
    public static final String REGEX_FOR_TEXTOID_VALIDATION = "^[a-zA-Z_][0-9a-zA-Z\\_\\.\\-]*";
    public static final String REGEX_FOR_STANDARTOID_VALIDATION = "^[a-zA-Z][0-9a-zA-Z]*";
    public static final String REGEX_FOR_BASE64_VALIDATION = "[a-zA-Z0-9+/= \\t\\n\\r]+";
    public static final String CONFIG_DO_ITF_LINETABLES = "ch.interlis.iox_j.validator.doItfLinetables";
    public static final String CONFIG_DO_ITF_LINETABLES_DO = "doItfLinetables";
    public static final String CONFIG_DO_ITF_OIDPERTABLE = "ch.interlis.iox_j.validator.doItfOidPerTable";
    public static final String CONFIG_DO_ITF_OIDPERTABLE_DO = "doItfOidPerTable";
    public static final String CONFIG_DO_XTF_VERIFYMODEL = "ch.interlis.iox_j.validator.doXtfVersionControl";
    public static final String CONFIG_DO_XTF_VERIFYMODEL_DO = "doXtfVersionControl";
    public static final String CONFIG_CUSTOM_FUNCTIONS = "ch.interlis.iox_j.validator.customFunctions";
    public static final String CONFIG_OBJECT_RESOLVERS = "ch.interlis.iox_j.validator.objectResolvers";
    public static final String CONFIG_DEBUG_XTFOUT = "ch.interlis.iox_j.validator.debugXtfOutput";
    private Map<Function, Value> functions = new HashMap<Function, Value>();
    private ObjectPoolManager objPoolManager = null;
    private ObjectPool objectPool = null;
    private LinkPool linkPool;
    private IoxValidationConfig validationConfig = null;
    private PipelinePool pipelinePool = null;
    private IoxLogging errs = null;
    private LogEventFactory errFact = null;
    private TransferDescription td = null;
    private boolean doItfLineTables = false;
    private boolean doItfOidPerTable = false;
    private Settings settings = null;
    private boolean validationOff = false;
    private String areaOverlapValidation = null;
    private String constraintValidation = null;
    private String defaultGeometryTypeValidation = null;
    Pattern patternForIdValidation = null;
    Pattern patternForTextOIdValidation = null;
    Pattern patternForStandartOidValidation = null;
    Pattern patternForBase64Validation = null;
    private boolean enforceTypeValidation = false;
    private boolean enforceConstraintValidation = false;
    private boolean enforceTargetValidation = false;
    private String currentBasketId = null;
    private String currentMainOid = null;
    private boolean autoSecondPass = true;
    private boolean allObjectsAccessible = false;
    private Map<AttributeDef, ItfAreaPolygon2Linetable> areaAttrs = new HashMap<AttributeDef, ItfAreaPolygon2Linetable>();
    private Map<String, Class> customFunctions = new HashMap<String, Class>();
    private List<ExternalObjectResolver> extObjResolvers = null;
    private HashMap<Constraint, Viewable> additionalConstraints = new HashMap();
    private Map<PlausibilityConstraint, PlausibilityPoolValue> plausibilityConstraints = new LinkedHashMap<PlausibilityConstraint, PlausibilityPoolValue>();
    private HashSet<String> configOffOufputReduction = new HashSet();
    private HashSet<String> setConstraintOufputReduction = new HashSet();
    private HashSet<String> constraintOutputReduction = new HashSet();
    private HashSet<String> seenModels = new HashSet();
    private HashSet<String> datatypesOutputReduction = new HashSet();
    private Map<String, String> uniquenessOfBid = new HashMap<String, String>();
    private String globalMultiplicity = null;
    private ReposManager repositoryManager = null;
    private ResourceBundle rsrc = ResourceBundle.getBundle("ch.interlis.iox_j.validator.ValidatorMessages");
    private IoxWriter writer = null;
    private HashMap<String, Object> tag2class = null;
    private HashSet<String> unknownTypev = null;
    private HashMap<SetConstraint, Collection<String>> setConstraints = new HashMap();
    private Iterator<String> allObjIterator = null;
    private Map<RoleDef, Map<String, List<IomObject>>> targetObjects = new HashMap<RoleDef, Map<String, List<IomObject>>>();
    private Map<RoleDef, Map<String, List<IomObject>>> linkObjects = new HashMap<RoleDef, Map<String, List<IomObject>>>();
    String uniquenessOfOid = null;
    HashMap<UniquenessConstraint, HashMap<AttributeArray, String>> seenUniqueConstraintValues = new HashMap();
    Map<String, String> uniqueObjectIDs = new HashMap<String, String>();
    HashSet<Object> loggedObjects = new HashSet();
    private boolean disableRounding = false;
    private boolean disableAreAreasMessages = false;
    private Interlis interlisFunction;
    private Interlis_ext interlis_ext;
    private Math mathFunction;
    private Text textFunction;

    @Deprecated
    public Validator(TransferDescription td, IoxValidationConfig validationConfig, IoxLogging errs, LogEventFactory errFact, Settings config) {
        this(td, validationConfig, errs, errFact, new PipelinePool(), config);
    }

    public Validator() {
    }

    public Validator(TransferDescription td, IoxValidationConfig validationConfig, IoxLogging errs, LogEventFactory errFact, PipelinePool pipelinePool, Settings settings) {
        String filename;
        boolean allowOnlyRelaxedMultiplicity;
        this.td = td;
        this.validationConfig = validationConfig;
        this.errs = errs;
        this.errFact = errFact;
        if (errFact.getLogger() == null) {
            errFact.setLogger(errs);
        }
        if (errFact.getValidationConfig() == null) {
            errFact.setValidationConfig(validationConfig);
        }
        this.settings = settings;
        this.patternForIdValidation = Pattern.compile(REGEX_FOR_ID_VALIDATION);
        this.patternForTextOIdValidation = Pattern.compile(REGEX_FOR_TEXTOID_VALIDATION);
        this.patternForStandartOidValidation = Pattern.compile(REGEX_FOR_STANDARTOID_VALIDATION);
        this.patternForBase64Validation = Pattern.compile(REGEX_FOR_BASE64_VALIDATION);
        this.settings.setTransientObject("ch.interlis.iox_j.validator.IoxDataPool", (Object)pipelinePool);
        this.pipelinePool = pipelinePool;
        this.objPoolManager = new ObjectPoolManager();
        Map cf = (Map)settings.getTransientObject(CONFIG_CUSTOM_FUNCTIONS);
        if (cf != null) {
            this.customFunctions = cf;
        }
        List resolverClasses = (List)settings.getTransientObject(CONFIG_OBJECT_RESOLVERS);
        this.repositoryManager = (ReposManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
        this.doItfLineTables = CONFIG_DO_ITF_LINETABLES_DO.equals(settings.getValue(CONFIG_DO_ITF_LINETABLES));
        this.doItfOidPerTable = CONFIG_DO_ITF_OIDPERTABLE_DO.equals(settings.getValue(CONFIG_DO_ITF_OIDPERTABLE));
        this.allObjectsAccessible = "true".equals(validationConfig.getConfigValue("PARAMETER", ALL_OBJECTS_ACCESSIBLE));
        if (!this.allObjectsAccessible) {
            errs.addEvent(errFact.logInfoMsg("assume unknown external objects", new String[0]));
        }
        this.disableRounding = "true".equals(validationConfig.getConfigValue("PARAMETER", "disableRounding"));
        if (this.disableRounding) {
            errs.addEvent(errFact.logInfoMsg("disable rounding", new String[0]));
        }
        this.disableAreAreasMessages = "true".equals(validationConfig.getConfigValue("PARAMETER", "disableAreAreasMessages"));
        if (this.disableAreAreasMessages) {
            errs.addEvent(errFact.logInfoMsg("disable areAreas() messages", new String[0]));
        }
        if (allowOnlyRelaxedMultiplicity = "on".equals(validationConfig.getConfigValue("PARAMETER", "allowOnlyMultiplicityReduction"))) {
            errs.addEvent(errFact.logInfoMsg("only multiplicity validation relaxable", new String[0]));
        }
        this.enforceConstraintValidation = allowOnlyRelaxedMultiplicity;
        this.enforceTypeValidation = allowOnlyRelaxedMultiplicity;
        this.enforceTargetValidation = allowOnlyRelaxedMultiplicity;
        this.tag2class = this.doItfLineTables ? ModelUtilities.getTagMap(td) : XSDGenerator.getTagMap((TransferDescription)td);
        this.unknownTypev = new HashSet();
        this.validationOff = "off".equals(this.validationConfig.getConfigValue("PARAMETER", "validation"));
        this.globalMultiplicity = validationConfig.getConfigValue("PARAMETER", "multiplicity");
        if (this.globalMultiplicity != null && "on".equals(this.globalMultiplicity)) {
            this.globalMultiplicity = null;
        }
        this.areaOverlapValidation = this.validationConfig.getConfigValue("PARAMETER", "areaOverlapValidation");
        this.constraintValidation = this.validationConfig.getConfigValue("PARAMETER", "constraintValidation");
        this.defaultGeometryTypeValidation = this.validationConfig.getConfigValue("PARAMETER", "defaultGeometryTypeValidation");
        this.objectPool = new ObjectPool(this.doItfOidPerTable, errs, errFact, this.tag2class, this.objPoolManager);
        this.linkPool = new LinkPool(this.objPoolManager);
        if (resolverClasses != null) {
            this.extObjResolvers = new ArrayList<ExternalObjectResolver>();
            for (Class resolverClass : resolverClasses) {
                ExternalObjectResolver resolver = null;
                try {
                    resolver = (ExternalObjectResolver)resolverClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                resolver.init(td, settings, validationConfig, this.objectPool, errFact);
                this.extObjResolvers.add(resolver);
            }
        }
        if ((filename = settings.getValue(CONFIG_DEBUG_XTFOUT)) != null) {
            try {
                this.writer = new XtfWriter(new File(filename), td);
            }
            catch (IoxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void close() {
        if (this.objPoolManager != null) {
            this.objPoolManager.close();
            this.objPoolManager = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IoxException e) {
                throw new IllegalArgumentException(e);
            }
            this.writer = null;
        }
    }

    public IoxValidationDataPool getDataPool() {
        return null;
    }

    public IoxLogging getLoggingHandler() {
        return this.errs;
    }

    public void setLoggingHandler(IoxLogging handler) {
        this.errs = handler;
    }

    public void validate(IoxEvent event) {
        if (this.validationOff) {
            return;
        }
        if (event instanceof StartTransferEvent) {
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validate.firstValidationPass"), new String[0]));
            this.validateInconsistentIliAndXMLVersion(event);
            this.uniquenessOfBid.clear();
        } else if (event instanceof StartBasketEvent) {
            StartBasketEvent startBasketEvent = (StartBasketEvent)event;
            this.currentBasketId = ((StartBasketEvent)event).getBid();
            this.validateBasketEvent(startBasketEvent);
        } else if (event instanceof ObjectEvent) {
            Iom_jObject iomObj = new Iom_jObject(((ObjectEvent)event).getIomObject());
            try {
                this.validateObject(iomObj, null, null);
            }
            catch (IoxException e) {
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validate.failedToValidateObject"), ((Object)iomObj).toString()));
            }
            catch (RuntimeException e) {
                EhiLogger.traceState((String)(this.rsrc.getString("validate.failingObject") + ((Object)iomObj).toString()));
                throw e;
            }
        } else if (event instanceof EndBasketEvent) {
            this.clearCurrentBid();
        } else if (event instanceof EndTransferEvent) {
            String additionalModels = this.validationConfig.getConfigValue("PARAMETER", "additionalModels");
            if (additionalModels != null) {
                String[] additionalModelv = additionalModels.split(";");
                this.iterateThroughAdditionalModels(additionalModelv);
            }
            if (this.autoSecondPass) {
                this.doSecondPass();
            }
        }
        if (this.writer != null) {
            try {
                this.writer.write(event);
            }
            catch (IoxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void validateInconsistentIliAndXMLVersion(IoxEvent event) {
        String versionControl = this.settings.getValue(CONFIG_DO_XTF_VERIFYMODEL);
        if (versionControl != null && versionControl.equals(CONFIG_DO_XTF_VERIFYMODEL_DO) && event instanceof XtfStartTransferEvent) {
            XtfStartTransferEvent startTransferEvent = (XtfStartTransferEvent)event;
            Collection<IomObject> headerObjValues = startTransferEvent.getHeaderObjects().values();
            ArrayList<IomObject> headerObjects = new ArrayList<IomObject>(headerObjValues);
            for (IomObject currentObj : headerObjects) {
                String currentModelName;
                Model model;
                String iliVersion;
                String currentVersion;
                if (!currentObj.getobjecttag().equals("iom04.metamodel.ModelEntry") || currentObj.getattrvaluecount("version") <= 0 || (currentVersion = currentObj.getattrvalue("version")).equals(iliVersion = (model = this.getModelFromTransferDesc(currentModelName = currentObj.getattrvalue("model"))).getModelVersion())) continue;
                String versionInfoMessage = "The VERSION in model (" + currentModelName + ") and transferfile do not match (" + iliVersion + "!=" + currentVersion + ")";
                this.errs.addEvent(this.errFact.logInfoMsg(versionInfoMessage, new String[0]));
            }
        }
    }

    private Model getModelFromTransferDesc(String modelName) {
        Iterator modeli = this.td.iterator();
        ArrayList list = new ArrayList();
        while (modeli.hasNext()) {
            list.add(0, modeli.next());
        }
        for (Model model : list) {
            if (!model.getName().equals(modelName)) continue;
            return model;
        }
        return null;
    }

    private void clearCurrentBid() {
        this.currentMainOid = null;
        this.errFact.setDataObj(null);
    }

    private void validateBasketEvent(StartBasketEvent event) {
        boolean isValid = true;
        this.errFact.setTid(event.getBid());
        this.errFact.setIliqname(event.getType());
        if (!this.isValidTopicName(event.getType())) {
            isValid = false;
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.invalidBasketElementName"), event.getType()));
        }
        if (!this.isValidId(event.getBid())) {
            isValid = false;
            LogEventFactory factory = new LogEventFactory();
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.valueIsNotAValidBID"), event.getBid() == null ? "" : event.getBid()));
        }
        if (isValid) {
            Topic topic = (Topic)this.td.getElement(event.getType());
            Model model = (Model)topic.getContainer();
            this.seenModels.add(model.getName());
            Domain bidDomain = topic.getBasketOid();
            if (bidDomain != null && !this.isAValidBasketOID(bidDomain, event.getBid())) {
                isValid = false;
                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.valueIsNotAValidBID"), event.getBid() == null ? "" : event.getBid()));
            }
        }
        if (isValid) {
            this.validateUniqueBasketId(event);
        }
    }

    private boolean isAValidBasketOID(Domain domain, String bid) {
        Type type = domain.getType();
        return !(domain == this.td.INTERLIS.UUIDOID ? !this.isValidUuid(bid) : (domain == this.td.INTERLIS.STANDARDOID ? !this.isValidStandartOId(bid) : type instanceof TextOIDType && !this.isValidTextOId(bid)));
    }

    private boolean isValidTopicName(String topicName) {
        Element element = this.td.getElement(topicName);
        return element != null && element instanceof Topic;
    }

    private boolean isValidId(String valueStr) {
        if (valueStr == null) {
            return false;
        }
        Matcher matcher = this.patternForIdValidation.matcher(valueStr);
        return matcher.matches();
    }

    private boolean isValidStandartOId(String valueStr) {
        if (valueStr == null) {
            return false;
        }
        if (valueStr.length() != 16) {
            return false;
        }
        Matcher matcher = this.patternForStandartOidValidation.matcher(valueStr);
        return matcher.matches();
    }

    private boolean isValidTextOId(String valueStr) {
        if (valueStr == null) {
            return false;
        }
        Matcher matcher = this.patternForTextOIdValidation.matcher(valueStr);
        return matcher.matches();
    }

    public void doSecondPass() {
        this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("doSecondPass.secondValidationPass"), new String[0]));
        this.iterateThroughAllObjects();
        this.validateAllAreas();
        this.validatePlausibilityConstraints();
    }

    private void validateUniqueBasketId(StartBasketEvent startBasketEvent) {
        String bid = startBasketEvent.getBid();
        if (bid != null) {
            if (this.uniquenessOfBid.containsKey(bid)) {
                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateUniqueBasketId.bidOfAlreadyExistIn"), bid, startBasketEvent.getType(), this.uniquenessOfBid.get(bid)));
            } else {
                this.uniquenessOfBid.put(bid, startBasketEvent.getType());
            }
        }
    }

    private void iterateThroughAdditionalModels(String[] additionalModels) {
        if (additionalModels == null) {
            return;
        }
        for (int modelIndex = 0; modelIndex < additionalModels.length; ++modelIndex) {
            String additionalModel = additionalModels[modelIndex];
            if (additionalModel == null || this.seenModels.contains(additionalModel)) continue;
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("iterateThroughAdditionalModels.additionalModel"), additionalModel));
            this.seenModels.add(additionalModel);
            Iterator tdIterator = this.td.iterator();
            boolean modelExists = false;
            while (tdIterator.hasNext()) {
                DataModel model;
                Object modelObj = tdIterator.next();
                if (!(modelObj instanceof DataModel) || !(model = (DataModel)modelObj).getName().equals(additionalModel)) continue;
                modelExists = true;
                this.collectAdditionalConstraints(model);
            }
            if (modelExists) continue;
            this.logMsg(additionalModel, this.rsrc.getString("iterateThroughAdditionalModels.requiredAdditionalModelNotFound"), additionalModel);
        }
    }

    private void collectAdditionalConstraints(DataModel model) {
        for (Object modelObj : model) {
            Topic topic;
            if (!(modelObj instanceof Topic) || !(topic = (Topic)modelObj).isViewTopic()) continue;
            for (Object topicObj : topic) {
                if (!(topicObj instanceof Projection)) continue;
                Projection view = (Projection)topicObj;
                Viewable classValue = null;
                if (view.getSelected().getAliasing() == null) continue;
                classValue = view.getSelected().getAliasing();
                for (Object constraintObj : view) {
                    if (!(constraintObj instanceof Constraint)) continue;
                    Constraint constraint = (Constraint)constraintObj;
                    String constraintName = this.getScopedName(constraint);
                    String checkConstraint = null;
                    if (!this.enforceConstraintValidation) {
                        checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                    }
                    if ("off".equals(checkConstraint)) {
                        if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                        this.configOffOufputReduction.add("check:" + constraintName);
                        this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("collectAdditionalConstraints.validationConfigurationCheckOff"), constraintName));
                        continue;
                    }
                    this.additionalConstraints.put(constraint, classValue);
                }
            }
        }
    }

    private void validateAllAreas() {
        this.setCurrentMainObj(null);
        for (AttributeDef attr : this.areaAttrs.keySet()) {
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAllAreas.validateAREA"), this.getScopedName(attr)));
            ItfAreaPolygon2Linetable allLines = this.areaAttrs.get(attr);
            List<IoxInvalidDataException> intersections = allLines.validate();
            if (intersections == null || intersections.size() <= 0) continue;
            for (IoxInvalidDataException ex : intersections) {
                String tid1 = ex.getTid();
                String iliqname = ex.getIliqname();
                this.errFact.setTid(tid1);
                this.errFact.setIliqname(iliqname);
                if (ex instanceof IoxIntersectionException) {
                    this.logMsg(this.areaOverlapValidation, ((IoxIntersectionException)ex).getIntersection().toShortString(), new String[0]);
                    EhiLogger.traceState((String)ex.toString());
                    continue;
                }
                this.logMsg(this.areaOverlapValidation, ex.getMessage(), new String[0]);
            }
            this.setCurrentMainObj(null);
            this.logMsg(this.areaOverlapValidation, this.rsrc.getString("validateAllAreas.failedToValidateAREA"), this.getScopedName(attr));
        }
    }

    private String getScopedName(AttributeDef attr) {
        return attr.getContainer().getScopedName(null) + "." + attr.getName();
    }

    private String getScopedName(RoleDef roleDef) {
        return roleDef.getContainer().getScopedName(null) + "." + roleDef.getName();
    }

    private String getScopedName(Constraint cnstr) {
        return cnstr.getContainer().getScopedName(null) + "." + cnstr.getName();
    }

    private String getScopedName(Viewable viewable) {
        return viewable.getContainer().getScopedName(null) + "." + viewable.getName();
    }

    private boolean isBasketSame(String bidOfTargetObject, IomObject iomObj) {
        String objectBid;
        if (iomObj == null) {
            return false;
        }
        Object modelElement = this.tag2class.get(iomObj.getobjecttag());
        Viewable classOfCurrentObj = (Viewable)modelElement;
        String oid = iomObj.getobjectoid();
        if (oid == null) {
            oid = ObjectPool.getAssociationId(iomObj, (AssociationDef)modelElement);
        }
        if ((objectBid = this.objectPool.getBidOfObject(oid, classOfCurrentObj)) == null) {
            return false;
        }
        return objectBid.equals(bidOfTargetObject);
    }

    private void iterateThroughAllObjects() {
        HashSet types = new HashSet();
        for (String basketId : this.objectPool.getBasketIds()) {
            Iterator objectIterator = this.objectPool.getObjectsOfBasketId(basketId).valueIterator();
            while (objectIterator.hasNext()) {
                RoleDef role;
                IomObject iomObj = (IomObject)objectIterator.next();
                if (iomObj == null) continue;
                this.setCurrentMainObj(iomObj);
                this.errFact.setDefaultCoord(this.getDefaultCoord(iomObj));
                Object modelElement = this.tag2class.get(iomObj.getobjecttag());
                Viewable classOfCurrentObj = (Viewable)modelElement;
                if (!"off".equals(this.constraintValidation)) {
                    for (Map.Entry<Constraint, Viewable> additionalConstraintsEntry : this.additionalConstraints.entrySet()) {
                        String constraintName;
                        Constraint additionalConstraint = additionalConstraintsEntry.getKey();
                        Viewable classOfAdditionalConstraint = additionalConstraintsEntry.getValue();
                        if (!classOfCurrentObj.isExtending((Element)classOfAdditionalConstraint)) continue;
                        if (additionalConstraint instanceof ExistenceConstraint) {
                            ExistenceConstraint existenceConstraint = (ExistenceConstraint)additionalConstraint;
                            this.validateExistenceConstraint(iomObj, existenceConstraint);
                            continue;
                        }
                        if (additionalConstraint instanceof MandatoryConstraint) {
                            MandatoryConstraint mandatoryConstraint = (MandatoryConstraint)additionalConstraint;
                            this.validateMandatoryConstraint(null, iomObj, mandatoryConstraint, null);
                            continue;
                        }
                        if (additionalConstraint instanceof SetConstraint) {
                            SetConstraint setConstraint = (SetConstraint)additionalConstraint;
                            constraintName = this.getScopedName((Constraint)setConstraint);
                            String checkAdditionalConstraint = null;
                            if (!this.enforceConstraintValidation) {
                                checkAdditionalConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                            }
                            if ("off".equals(checkAdditionalConstraint)) {
                                if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                                this.configOffOufputReduction.add("check:" + constraintName);
                                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("iterateThroughAllObjects.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                                continue;
                            }
                            this.collectSetConstraintObjs(checkAdditionalConstraint, constraintName, iomObj, setConstraint);
                            continue;
                        }
                        if (additionalConstraint instanceof UniquenessConstraint) {
                            UniquenessConstraint uniquenessConstraint = (UniquenessConstraint)additionalConstraint;
                            String iomObjOid = iomObj.getobjectoid();
                            if (iomObjOid == null && classOfCurrentObj instanceof AssociationDef) {
                                iomObjOid = ObjectPool.getAssociationId(iomObj, (AssociationDef)classOfCurrentObj);
                            }
                            this.validateUniquenessConstraint(null, iomObj, iomObjOid, uniquenessConstraint, null);
                            continue;
                        }
                        if (!(additionalConstraint instanceof PlausibilityConstraint)) continue;
                        PlausibilityConstraint plausibilityConstraint = (PlausibilityConstraint)additionalConstraint;
                        constraintName = this.getScopedName((Constraint)plausibilityConstraint);
                        String checkPlausibilityConstraint = null;
                        if (!this.enforceConstraintValidation) {
                            checkPlausibilityConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                        }
                        if ("off".equals(checkPlausibilityConstraint)) {
                            if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                            this.configOffOufputReduction.add("check:" + constraintName);
                            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("iterateThroughAllObjects.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                            continue;
                        }
                        this.fillOfPlausibilityConstraintMap(checkPlausibilityConstraint, constraintName, plausibilityConstraint, iomObj);
                    }
                }
                this.validateConstraints(iomObj, classOfCurrentObj);
                Iterator attrIterator = classOfCurrentObj.getAttributesAndRoles2();
                while (attrIterator.hasNext()) {
                    ViewableTransferElement objA = (ViewableTransferElement)attrIterator.next();
                    if (objA.obj instanceof LocalAttribute) {
                        LocalAttribute attr = (LocalAttribute)objA.obj;
                        String attrName = attr.getName();
                        Type type = attr.getDomain();
                        if (!(type instanceof CompositionType)) continue;
                        CompositionType compositionType = (CompositionType)type;
                        Table structure = compositionType.getComponentType();
                        String objectBid = this.objectPool.getBidOfObject(iomObj.getobjectoid(), classOfCurrentObj);
                        int structc = iomObj.getattrvaluecount(attrName);
                        for (int structi = 0; structi < structc; ++structi) {
                            IomObject structValue = iomObj.getattrobj(attrName, structi);
                            if (structValue == null) continue;
                            this.validateReferenceAttrs(attr.getScopedName(), structValue, structure, objectBid);
                        }
                        continue;
                    }
                    if (!(objA.obj instanceof RoleDef)) continue;
                    RoleDef roleDef = (RoleDef)objA.obj;
                    this.validateRoleReference(basketId, roleDef, iomObj);
                }
                if (!(classOfCurrentObj instanceof AbstractClassDef)) continue;
                AbstractClassDef abstractClassDef = (AbstractClassDef)classOfCurrentObj;
                Iterator targetRoleIterator = abstractClassDef.getOpposideRoles();
                while (targetRoleIterator.hasNext()) {
                    role = (RoleDef)targetRoleIterator.next();
                    this.validateRoleCardinality(role, iomObj);
                }
                targetRoleIterator = abstractClassDef.getOpposideForNonNavigableRoles();
                while (targetRoleIterator.hasNext()) {
                    role = (RoleDef)targetRoleIterator.next();
                    this.validateRoleCardinality(role, iomObj);
                }
            }
        }
        for (SetConstraint setConstraint : this.setConstraints.keySet()) {
            this.validateSetConstraint(setConstraint);
        }
    }

    private void validateConstraints(IomObject iomObj, Viewable classOfIomObj) {
        if (!"off".equals(this.constraintValidation)) {
            for (Viewable classOfCurrentObj = classOfIomObj; classOfCurrentObj != null; classOfCurrentObj = (Viewable)classOfCurrentObj.getExtending()) {
                for (Object constraintObj : classOfCurrentObj) {
                    String constraintName;
                    if (constraintObj instanceof ExistenceConstraint) {
                        ExistenceConstraint existenceConstraint = (ExistenceConstraint)constraintObj;
                        this.validateExistenceConstraint(iomObj, existenceConstraint);
                    }
                    if (constraintObj instanceof MandatoryConstraint) {
                        MandatoryConstraint mandatoryConstraint = (MandatoryConstraint)constraintObj;
                        this.validateMandatoryConstraint(null, iomObj, mandatoryConstraint, null);
                    }
                    if (constraintObj instanceof UniquenessConstraint) {
                        String iomObjOid = iomObj.getobjectoid();
                        if (iomObjOid == null && classOfIomObj instanceof AssociationDef) {
                            iomObjOid = ObjectPool.getAssociationId(iomObj, (AssociationDef)classOfIomObj);
                        }
                        UniquenessConstraint uniquenessConstraint = (UniquenessConstraint)constraintObj;
                        this.validateUniquenessConstraint(null, iomObj, iomObjOid, uniquenessConstraint, null);
                    }
                    if (constraintObj instanceof SetConstraint) {
                        SetConstraint setConstraint = (SetConstraint)constraintObj;
                        constraintName = this.getScopedName((Constraint)setConstraint);
                        String checkSetConstraint = null;
                        if (!this.enforceConstraintValidation) {
                            checkSetConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                        }
                        if ("off".equals(checkSetConstraint)) {
                            if (!this.configOffOufputReduction.contains("check:" + constraintName)) {
                                this.configOffOufputReduction.add("check:" + constraintName);
                                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateConstraints.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                            }
                        } else {
                            this.collectSetConstraintObjs(checkSetConstraint, constraintName, iomObj, setConstraint);
                        }
                    }
                    if (!(constraintObj instanceof PlausibilityConstraint)) continue;
                    PlausibilityConstraint plausibilityConstraint = (PlausibilityConstraint)constraintObj;
                    constraintName = this.getScopedName((Constraint)plausibilityConstraint);
                    String checkPlausibilityConstraint = null;
                    if (!this.enforceConstraintValidation) {
                        checkPlausibilityConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                    }
                    if ("off".equals(checkPlausibilityConstraint)) {
                        if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                        this.configOffOufputReduction.add("check:" + constraintName);
                        this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateConstraints.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                        continue;
                    }
                    this.fillOfPlausibilityConstraintMap(checkPlausibilityConstraint, constraintName, plausibilityConstraint, iomObj);
                }
            }
            Iterator iter = classOfIomObj.getAttributesAndRoles2();
            while (iter.hasNext()) {
                ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                if (obj.obj instanceof AttributeDef) {
                    Type proxyType;
                    AttributeDef attr = (AttributeDef)obj.obj;
                    if (attr.isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
                    Type type = attr.getDomainResolvingAliases();
                    String attrName = attr.getName();
                    if (!(type instanceof CompositionType)) continue;
                    Table structType = ((CompositionType)type).getComponentType();
                    int structc = iomObj.getattrvaluecount(attrName);
                    for (int structi = 0; structi < structc; ++structi) {
                        IomObject structEle = iomObj.getattrobj(attrName, structi);
                        if (structEle == null) continue;
                        this.validateConstraints(structEle, (Viewable)structType);
                    }
                    continue;
                }
                if (!(obj.obj instanceof RoleDef) || !obj.embedded) continue;
                this.validateConstraintsOfEmbeddedAssociation((RoleDef)obj.obj, iomObj);
            }
        }
    }

    private void validateConstraintsOfEmbeddedAssociation(RoleDef role, IomObject iomObj) {
        int propc = iomObj.getattrvaluecount(role.getName());
        if (propc >= 1) {
            IomObject embeddedLinkObj = iomObj.getattrobj(role.getName(), 0);
            AssociationDef roleOwner = (AssociationDef)role.getContainer();
            AssociationDef classOfCurrentObj = roleOwner;
            if (classOfCurrentObj != null) {
                String iomObjOid = iomObj.getobjectoid();
                for (Object constraintObj : classOfCurrentObj) {
                    if (constraintObj instanceof UniquenessConstraint) {
                        UniquenessConstraint uniquenessConstraint = (UniquenessConstraint)constraintObj;
                        this.validateUniquenessConstraint(iomObj, embeddedLinkObj, iomObjOid, uniquenessConstraint, role);
                        continue;
                    }
                    if (!(constraintObj instanceof MandatoryConstraint)) continue;
                    MandatoryConstraint mandatoryConstraint = (MandatoryConstraint)constraintObj;
                    this.validateMandatoryConstraint(iomObj, embeddedLinkObj, mandatoryConstraint, role);
                }
            }
        }
    }

    private void fillOfPlausibilityConstraintMap(String validationKind, String usageScope, PlausibilityConstraint constraint, IomObject iomObj) {
        Evaluable condition = constraint.getCondition();
        Value conditionValue = this.evaluateExpression(null, validationKind, usageScope, iomObj, condition, null);
        if (this.plausibilityConstraints.containsKey(constraint)) {
            PlausibilityPoolValue poolConstraintValues = this.plausibilityConstraints.get(constraint);
            double successfulResults = poolConstraintValues.getSuccessfulResults();
            double totalSumOfConstraints = poolConstraintValues.getTotalSumOfConstraints();
            if (conditionValue.isTrue()) {
                this.plausibilityConstraints.remove(constraint);
                this.plausibilityConstraints.put(constraint, new PlausibilityPoolValue(successfulResults + 1.0, totalSumOfConstraints + 1.0));
            } else {
                this.plausibilityConstraints.remove(constraint);
                this.plausibilityConstraints.put(constraint, new PlausibilityPoolValue(successfulResults, totalSumOfConstraints + 1.0));
            }
        } else if (conditionValue.isTrue()) {
            this.plausibilityConstraints.put(constraint, new PlausibilityPoolValue(1.0, 1.0));
        } else {
            this.plausibilityConstraints.put(constraint, new PlausibilityPoolValue(0.0, 1.0));
        }
    }

    private void validatePlausibilityConstraints() {
        if (!"off".equals(this.constraintValidation)) {
            for (Map.Entry<PlausibilityConstraint, PlausibilityPoolValue> constraintEntry : this.plausibilityConstraints.entrySet()) {
                PlausibilityConstraint constraint = constraintEntry.getKey();
                String constraintName = this.getScopedName((Constraint)constraintEntry.getKey());
                String checkConstraint = null;
                if (!this.enforceConstraintValidation) {
                    checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                }
                if ("off".equals(checkConstraint)) {
                    if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                    this.configOffOufputReduction.add("check:" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validatePlausibilityConstraints.validationConfigurationCheckOff"), constraintName));
                    continue;
                }
                if (!this.constraintOutputReduction.contains(constraint + ":" + constraintName)) {
                    this.constraintOutputReduction.add(constraint + ":" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validatePlausibilityConstraints.validatePlausibilityConstraint"), this.getScopedName((Constraint)constraintEntry.getKey())));
                }
                String actualLanguage = Locale.getDefault().getLanguage();
                String msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)constraintEntry.getKey()), "msg_" + actualLanguage);
                if (msg == null) {
                    msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)constraintEntry.getKey()), "msg");
                }
                if (constraintEntry.getKey().getDirection() == 0) {
                    if (constraintEntry.getValue().getSuccessfulResults() / constraintEntry.getValue().getTotalSumOfConstraints() * 100.0 >= constraintEntry.getKey().getPercentage()) continue;
                    if (msg != null && msg.length() > 0) {
                        this.logMsg(checkConstraint, msg, new String[0]);
                        continue;
                    }
                    this.logMsg(checkConstraint, this.rsrc.getString("validatePlausibilityConstraints.plausibilityConstraintIsNotTrue"), this.getScopedName((Constraint)constraintEntry.getKey()));
                    continue;
                }
                if (constraintEntry.getKey().getDirection() != 1 || constraintEntry.getValue().getSuccessfulResults() / constraintEntry.getValue().getTotalSumOfConstraints() * 100.0 <= constraintEntry.getKey().getPercentage()) continue;
                if (msg != null && msg.length() > 0) {
                    this.logMsg(checkConstraint, msg, new String[0]);
                    continue;
                }
                this.logMsg(checkConstraint, this.rsrc.getString("validatePlausibilityConstraints.plausibilityConstraintIsNotTrue"), this.getScopedName((Constraint)constraintEntry.getKey()));
            }
        }
    }

    private void validateUniquenessConstraint(IomObject parentObject, IomObject iomObj, String iomObjOid, UniquenessConstraint uniquenessConstraint, RoleDef role) {
        if (!"off".equals(this.constraintValidation)) {
            String constraintName = this.getScopedName((Constraint)uniquenessConstraint);
            String checkUniqueConstraint = null;
            if (!this.enforceConstraintValidation) {
                checkUniqueConstraint = this.validationConfig.getConfigValue(constraintName, "check");
            }
            if ("off".equals(checkUniqueConstraint)) {
                if (!this.configOffOufputReduction.contains("check:" + constraintName)) {
                    this.configOffOufputReduction.add("check:" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateUniquenessConstraint.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                }
            } else {
                if (uniquenessConstraint.getPreCondition() != null) {
                    Value preConditionValue = this.evaluateExpression(parentObject, checkUniqueConstraint, constraintName, iomObj, uniquenessConstraint.getPreCondition(), role);
                    if (preConditionValue.isNotYetImplemented()) {
                        this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("validateUniquenessConstraint.functionInUniquenessConstraintIsNotYetImplemented"), constraintName));
                        return;
                    }
                    if (preConditionValue.skipEvaluation()) {
                        return;
                    }
                    if (!preConditionValue.isTrue()) {
                        return;
                    }
                }
                Object modelElement = this.tag2class.get(iomObj.getobjecttag());
                Viewable aClass1 = (Viewable)modelElement;
                if (!this.loggedObjects.contains(uniquenessConstraint)) {
                    this.loggedObjects.add(uniquenessConstraint);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateUniquenessConstraint.validateUniqeConstraint"), this.getScopedName((Constraint)uniquenessConstraint)));
                }
                HashMap<Object, HashMap<AttributeArray, String>> seenValues = null;
                seenValues = uniquenessConstraint.getLocal() ? new HashMap() : this.seenUniqueConstraintValues;
                if (uniquenessConstraint.getPrefix() != null) {
                    PathEl[] attrPath = uniquenessConstraint.getPrefix().getPathElements();
                    this.visitStructEle(checkUniqueConstraint, uniquenessConstraint, seenValues, iomObjOid, aClass1, attrPath, 0, parentObject, iomObj, role);
                } else {
                    this.visitStructEle(checkUniqueConstraint, uniquenessConstraint, seenValues, iomObjOid, aClass1, null, 0, parentObject, iomObj, role);
                }
            }
        }
    }

    private void visitStructEle(String checkUniqueConstraint, UniquenessConstraint uniquenessConstraint, HashMap<UniquenessConstraint, HashMap<AttributeArray, String>> seenValues, String iomObjOid, Viewable iomObjClass, PathEl[] attrPath, int i, IomObject parentObject, IomObject iomObj, RoleDef role) {
        if (attrPath == null || i >= attrPath.length) {
            OutParam values = new OutParam();
            String oidOfObjectWithDuplicateValue = this.validateUnique(seenValues, iomObjOid, parentObject, iomObj, uniquenessConstraint, (OutParam<AttributeArray>)values, role);
            if (oidOfObjectWithDuplicateValue != null) {
                String actualLanguage = Locale.getDefault().getLanguage();
                String msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)uniquenessConstraint), "msg_" + actualLanguage);
                if (msg == null) {
                    msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)uniquenessConstraint), "msg");
                }
                if (msg != null && msg.length() > 0) {
                    this.logMsg(checkUniqueConstraint, msg, new String[0]);
                } else {
                    this.logMsg(checkUniqueConstraint, this.rsrc.getString("visitStructEle.uniqueIsViolatedValuesAlreadyExistInObject"), ((AttributeArray)values.value).valuesAsString(), this.formatObjectId(oidOfObjectWithDuplicateValue, iomObjClass));
                }
            }
            return;
        }
        String attrName = attrPath[i].getName();
        int structElec = iomObj.getattrvaluecount(attrName);
        for (int structElei = 0; structElei < structElec; ++structElei) {
            IomObject structEle = iomObj.getattrobj(attrName, structElei);
            this.visitStructEle(checkUniqueConstraint, uniquenessConstraint, seenValues, iomObjOid, iomObjClass, attrPath, i + 1, parentObject, structEle, role);
        }
    }

    private String formatObjectId(String oid, Viewable classOfOid) {
        String actualLanguage = Locale.getDefault().getLanguage();
        ArrayList<Viewable> classes = new ArrayList<Viewable>();
        classes.add(classOfOid);
        IomObject iomObj = this.objectPool.getObject(oid, classes, null);
        String keymsg = this.validationConfig.getConfigValue(iomObj.getobjecttag(), "keymsg_" + actualLanguage);
        if (keymsg != null) {
            return LogEventFactory.formatMessage(keymsg, iomObj, new String[0]);
        }
        keymsg = this.validationConfig.getConfigValue(iomObj.getobjecttag(), "keymsg");
        return keymsg != null ? LogEventFactory.formatMessage(keymsg, iomObj, new String[0]) : oid;
    }

    private void collectSetConstraintObjs(String validationKind, String constraintName, IomObject iomObj, SetConstraint setConstraintObj) {
        String oid;
        Collection<String> objs;
        Evaluable preCondition = setConstraintObj.getPreCondition();
        if (preCondition != null) {
            Value preConditionValue = this.evaluateExpression(null, validationKind, constraintName, iomObj, preCondition, null);
            if (preConditionValue.isNotYetImplemented()) {
                this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("collectSetConstraintObjs.functionInSetConstraintIsNotYetImplemented"), this.getScopedName((Constraint)setConstraintObj)));
                return;
            }
            if (preConditionValue.skipEvaluation()) {
                return;
            }
            if (!preConditionValue.isTrue()) {
                return;
            }
        }
        if ((objs = this.setConstraints.get(setConstraintObj)) == null) {
            objs = new HashSet<String>();
            this.setConstraints.put(setConstraintObj, objs);
        }
        if ((oid = iomObj.getobjectoid()) == null) {
            oid = ObjectPool.getAssociationId(iomObj, (AssociationDef)this.td.getElement(iomObj.getobjecttag()));
        }
        objs.add(oid);
    }

    private void validateSetConstraint(SetConstraint setConstraintObj) {
        if (!"off".equals(this.constraintValidation)) {
            Collection<String> objs = this.setConstraints.get(setConstraintObj);
            String constraintName = this.getScopedName((Constraint)setConstraintObj);
            String checkConstraint = null;
            if (!this.enforceConstraintValidation) {
                checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
            }
            if ("off".equals(checkConstraint)) {
                if (!this.configOffOufputReduction.contains("check:" + this.getScopedName((Constraint)setConstraintObj))) {
                    this.configOffOufputReduction.add("check:" + this.getScopedName((Constraint)setConstraintObj));
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateSetConstraint.validationConfigurationCheckOff"), this.getScopedName((Constraint)setConstraintObj)));
                }
            } else {
                if (!this.constraintOutputReduction.contains(setConstraintObj + ":" + constraintName)) {
                    this.constraintOutputReduction.add(setConstraintObj + ":" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateSetConstraint.validateSetConstraint"), this.getScopedName((Constraint)setConstraintObj)));
                }
                if (objs != null && objs.size() > 0) {
                    for (String oid : objs) {
                        this.allObjIterator = objs.iterator();
                        IomObject iomObj = this.objectPool.getObject(oid, null, null);
                        this.setCurrentMainObj(iomObj);
                        this.errFact.setDefaultCoord(this.getDefaultCoord(iomObj));
                        Evaluable condition = setConstraintObj.getCondition();
                        Value constraintValue = this.evaluateExpression(null, checkConstraint, constraintName, iomObj, condition, null);
                        if (constraintValue.isNotYetImplemented()) {
                            this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("validateSetConstraint.functionInSetConstraintIsNotYetImplemented"), this.getScopedName((Constraint)setConstraintObj)));
                            return;
                        }
                        if (constraintValue.skipEvaluation()) {
                            return;
                        }
                        if (constraintValue.isTrue()) continue;
                        String actualLanguage = Locale.getDefault().getLanguage();
                        String msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)setConstraintObj), "msg_" + actualLanguage);
                        if (msg == null) {
                            msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)setConstraintObj), "msg");
                        }
                        if (msg != null && msg.length() > 0) {
                            this.logMsg(checkConstraint, msg, new String[0]);
                            continue;
                        }
                        if (this.setConstraintOufputReduction.contains(setConstraintObj + ":" + constraintName)) continue;
                        this.setConstraintOufputReduction.add(setConstraintObj + ":" + constraintName);
                        this.logMsg(checkConstraint, this.rsrc.getString("validateSetConstraint.setConstraintIsNotTrue"), constraintName);
                    }
                }
            }
        }
    }

    private void validateMandatoryConstraint(IomObject parentObject, IomObject iomObj, MandatoryConstraint mandatoryConstraintObj, RoleDef firstRole) {
        if (!"off".equals(this.constraintValidation)) {
            String constraintName = this.getScopedName((Constraint)mandatoryConstraintObj);
            String checkConstraint = null;
            if (!this.enforceConstraintValidation) {
                checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
            }
            if ("off".equals(checkConstraint)) {
                if (!this.configOffOufputReduction.contains("check:" + constraintName)) {
                    this.configOffOufputReduction.add("check:" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateMandatoryConstraint.validationConfigurationCheckOff"), constraintName));
                }
            } else {
                Evaluable condition;
                Value conditionValue;
                if (!this.constraintOutputReduction.contains(mandatoryConstraintObj + ":" + constraintName)) {
                    this.constraintOutputReduction.add(mandatoryConstraintObj + ":" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateMandatoryConstraint.validateMandatoryConstraint"), this.getScopedName((Constraint)mandatoryConstraintObj)));
                }
                if (!(conditionValue = this.evaluateExpression(parentObject, checkConstraint, constraintName, iomObj, condition = mandatoryConstraintObj.getCondition(), firstRole)).isNotYetImplemented()) {
                    if (!conditionValue.skipEvaluation() && !conditionValue.isTrue()) {
                        String actualLanguage = Locale.getDefault().getLanguage();
                        String msg = this.validationConfig.getConfigValue(constraintName, "msg_" + actualLanguage);
                        if (msg == null) {
                            msg = this.validationConfig.getConfigValue(constraintName, "msg");
                        }
                        if (msg != null && msg.length() > 0) {
                            this.logMsg(checkConstraint, msg, new String[0]);
                        } else {
                            this.logMsg(checkConstraint, this.rsrc.getString("validateMandatoryConstraint.mandatoryConstraintIsNotTrue"), constraintName);
                        }
                    }
                } else if (condition instanceof FunctionCall) {
                    FunctionCall functionCallObj = (FunctionCall)condition;
                    Function function = functionCallObj.getFunction();
                    this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("validateMandatoryConstraint.functionIsNotYetImplemented"), function.getScopedName(null)));
                    Value.createNotYetImplemented();
                } else {
                    this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("validateMandatoryConstraint.mandatoryConstraintIsNotYetImplemented"), mandatoryConstraintObj.getScopedName(null), iomObj.getobjecttag()));
                    Value.createNotYetImplemented();
                }
            }
        }
    }

    private Value evaluateExpressionToSingleValue(IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, Evaluable expression, RoleDef firstRole) {
        Value value = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, expression, firstRole);
        if (!value.skipEvaluation() && value.getValues() != null && value.getValues().length > 1) {
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("evaluateExpressionToSingleValue.expressionMustEvaluateToASingleValue"), expression.toString()));
            return Value.createSkipEvaluation();
        }
        return value;
    }

    public Value evaluateExpression(IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, Evaluable expression, RoleDef firstRole) {
        TextType texttype = new TextType();
        if (expression instanceof Expression.Equality) {
            Expression.Equality equality = (Expression.Equality)expression;
            Evaluable leftExpression = equality.getLeft();
            Evaluable rightExpression = equality.getRight();
            Value leftValue = this.evaluateExpressionToSingleValue(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpressionToSingleValue(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) == 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.GreaterThan) {
            Expression.GreaterThan greaterThan = (Expression.GreaterThan)expression;
            Evaluable leftExpression = greaterThan.getLeft();
            Evaluable rightExpression = greaterThan.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) > 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.GreaterThanOrEqual) {
            Expression.GreaterThanOrEqual greaterThanOrEqual = (Expression.GreaterThanOrEqual)expression;
            Evaluable leftExpression = greaterThanOrEqual.getLeft();
            Evaluable rightExpression = greaterThanOrEqual.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) >= 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.Inequality) {
            Expression.Inequality inEquality = (Expression.Inequality)expression;
            Evaluable leftExpression = inEquality.getLeft();
            Evaluable rightExpression = inEquality.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) != 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.LessThan) {
            Expression.LessThan lessThan = (Expression.LessThan)expression;
            Evaluable leftExpression = lessThan.getLeft();
            Evaluable rightExpression = lessThan.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) < 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.LessThanOrEqual) {
            Expression.LessThanOrEqual lessThanOrEqual = (Expression.LessThanOrEqual)expression;
            Evaluable leftExpression = lessThanOrEqual.getLeft();
            Evaluable rightExpression = lessThanOrEqual.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) <= 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.Negation) {
            Expression.Negation negation = (Expression.Negation)expression;
            Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, negation.getNegated(), firstRole);
            if (arg.skipEvaluation()) {
                return arg;
            }
            if (arg.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (arg.isTrue()) {
                return new Value(false);
            }
            return new Value(true);
        }
        if (expression instanceof Expression.Conjunction) {
            Expression.Conjunction conjunction = (Expression.Conjunction)expression;
            Evaluable[] conjunctionArray = conjunction.getConjoined();
            for (int i = 0; i < conjunctionArray.length; ++i) {
                Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, conjunctionArray[i], firstRole);
                if (arg.skipEvaluation()) {
                    return arg;
                }
                if (arg.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                if (arg.isTrue()) continue;
                return new Value(false);
            }
            return new Value(true);
        }
        if (expression instanceof Expression.DefinedCheck) {
            Expression.DefinedCheck defined = (Expression.DefinedCheck)expression;
            Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, defined.getArgument(), firstRole);
            if (arg.skipEvaluation()) {
                return arg;
            }
            if (arg.isUndefined()) {
                return new Value(false);
            }
            return new Value(true);
        }
        if (expression instanceof Expression.Disjunction) {
            Expression.Disjunction disjunction = (Expression.Disjunction)expression;
            Evaluable[] disjunctionArray = disjunction.getDisjoined();
            for (int i = 0; i < disjunctionArray.length; ++i) {
                Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, disjunctionArray[i], firstRole);
                if (arg.skipEvaluation()) {
                    return arg;
                }
                if (arg.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                if (!arg.isTrue()) continue;
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Constant) {
            Constant constantObj = (Constant)expression;
            if (constantObj instanceof Constant.EnumConstOrRange) {
                Constant.EnumConstOrRange enumConstOrRange = (Constant.EnumConstOrRange)constantObj;
                if (enumConstOrRange instanceof Constant.Enumeration) {
                    Constant.Enumeration enumObj = (Constant.Enumeration)enumConstOrRange;
                    String value = this.getEnumerationConstantXtfValue(enumObj);
                    if (value.equals("true")) {
                        return new Value(true);
                    }
                    if (value.equals("false")) {
                        return new Value(false);
                    }
                    return new Value((Type)texttype, value);
                }
            } else if (constantObj instanceof Constant.Text) {
                Constant.Text textConstant = (Constant.Text)constantObj;
                if (textConstant != null) {
                    return new Value((Type)texttype, textConstant.getValue());
                }
            } else if (constantObj instanceof Constant.Numeric) {
                Constant.Numeric numericConstant = (Constant.Numeric)constantObj;
                if (numericConstant != null) {
                    return new Value((Type)texttype, numericConstant.getValue().toString());
                }
            } else if (constantObj instanceof Constant.Class) {
                Constant.Class classConstant = (Constant.Class)constantObj;
                if (classConstant != null && classConstant.getValue() instanceof Viewable) {
                    Viewable classValue = classConstant.getValue();
                    return new Value(classValue);
                }
            } else {
                Constant.AttributePath attrPath;
                if (constantObj instanceof Constant.Undefined) {
                    return Value.createUndefined();
                }
                if (constantObj instanceof Constant.AttributePath && (attrPath = (Constant.AttributePath)constantObj).getValue() instanceof LocalAttribute) {
                    LocalAttribute attrLocal = (LocalAttribute)attrPath.getValue();
                    String attrName = attrLocal.getName();
                    return new Value((Type)texttype, attrName);
                }
            }
        } else {
            if (expression instanceof FunctionCall) {
                FunctionCall functionCallObj = (FunctionCall)expression;
                Function currentFunction = functionCallObj.getFunction();
                if (currentFunction.getScopedName(null).startsWith("Text.")) {
                    if (this.textFunction == null) {
                        this.textFunction = new Text(this, this.td, this.validationConfig);
                    }
                    return this.textFunction.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, firstRole);
                }
                if (currentFunction.getScopedName(null).startsWith("Math.")) {
                    if (this.mathFunction == null) {
                        this.mathFunction = new Math(this, this.td, this.validationConfig);
                    }
                    return this.mathFunction.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, firstRole);
                }
                if (!currentFunction.getScopedName(null).equals("INTERLIS.convertUnit") && currentFunction.getScopedName(null).startsWith("INTERLIS.")) {
                    if (this.interlisFunction == null) {
                        this.interlisFunction = new Interlis(this, this.td, this.validationConfig, this.allObjIterator);
                    }
                    return this.interlisFunction.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, expression, this.functions, this.td, firstRole);
                }
                if (currentFunction.getScopedName(null).startsWith("INTERLIS_ext.")) {
                    if (this.interlis_ext == null) {
                        this.interlis_ext = new Interlis_ext(this, this.td, this.validationConfig, this.allObjIterator);
                    }
                    return this.interlis_ext.evaluateFunction(currentFunction, parentObject, validationKind, usageScope, iomObj, expression, this.functions, this.td, firstRole);
                }
                String functionQname = currentFunction.getScopedName(null);
                Class functionTargetClass = this.customFunctions.get(functionQname);
                if (functionTargetClass == null) {
                    return Value.createNotYetImplemented();
                }
                FunctionCall functionCall = (FunctionCall)expression;
                Evaluable[] arguments = functionCall.getArguments();
                int argumentCount = functionCall.getArguments().length;
                Value[] actualArguments = new Value[argumentCount];
                for (int i = 0; i < argumentCount; ++i) {
                    Value anObject = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
                    if (anObject.skipEvaluation()) {
                        return anObject;
                    }
                    actualArguments[i] = anObject;
                }
                InterlisFunction functionTarget = null;
                try {
                    functionTarget = (InterlisFunction)functionTargetClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                functionTarget.init(this.td, this.settings, this.validationConfig, this.objectPool, this.errFact);
                return functionTarget.evaluate(validationKind, usageScope, iomObj, actualArguments);
            }
            if (expression instanceof ObjectPath) {
                ObjectPath objectPathObj = (ObjectPath)expression;
                PathEl[] pathElements = objectPathObj.getPathElements();
                return this.getValueFromObjectPath(parentObject, iomObj, pathElements, firstRole);
            }
            if (expression instanceof Objects) {
                Iterator<String> objectIterator = this.allObjIterator;
                ArrayList<IomObject> listOfIomObjects = new ArrayList<IomObject>();
                if (this.allObjIterator == null) {
                    throw new IllegalStateException(this.rsrc.getString("evaluateExpression.argumentAllRequiresASetConstraint"));
                }
                while (objectIterator.hasNext()) {
                    String oid = objectIterator.next();
                    IomObject aIomObj = this.objectPool.getObject(oid, null, null);
                    if (aIomObj == null) continue;
                    listOfIomObjects.add(aIomObj);
                }
                return new Value(listOfIomObjects);
            }
            this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("evaluateExpression.ExpressionIsNotYetImplemented"), expression.toString()));
        }
        return Value.createSkipEvaluation();
    }

    public ObjectPath parseObjectOrAttributePath(Viewable viewable, String objectPath) throws Ili2cException {
        return Ili23Parser.parseObjectOrAttributePath((TransferDescription)this.td, (Viewable)viewable, (String)objectPath);
    }

    public Value getValueFromObjectPath(IomObject parentObject, IomObject iomObjStart, PathEl[] pathElements, RoleDef firstRole) {
        ArrayList<IomObject> currentObjects = new ArrayList<IomObject>();
        ArrayList<Object> nextCurrentObjects = new ArrayList<IomObject>();
        RoleDef role = null;
        int lastPathIndex = pathElements.length - 1;
        currentObjects.add(iomObjStart);
        for (int k = 0; k < pathElements.length; ++k) {
            for (IomObject iomObj : currentObjects) {
                LocalAttribute localAttributeValue;
                PathEl currentPathEl = pathElements[k];
                if (currentPathEl instanceof PathElAbstractClassRole || currentPathEl instanceof PathElAssocRole || currentPathEl instanceof AssociationPath) {
                    Viewable srcObjClass;
                    if (currentPathEl instanceof PathElAbstractClassRole) {
                        PathElAbstractClassRole abstractClassRole = (PathElAbstractClassRole)currentPathEl;
                        role = abstractClassRole.getRole();
                    } else if (currentPathEl instanceof PathElAssocRole) {
                        role = ((PathElAssocRole)currentPathEl).getRole();
                    } else if (currentPathEl instanceof AssociationPath) {
                        role = ((AssociationPath)currentPathEl).getTargetRole();
                    }
                    if (role == null) {
                        throw new IllegalStateException(this.rsrc.getString("getValueFromObjectPath.roleIsNotBeEmpty"));
                    }
                    if (parentObject != null && k == 0) {
                        if (k == lastPathIndex) {
                            if (role == firstRole) {
                                nextCurrentObjects.add(iomObj);
                                continue;
                            }
                            Iom_jObject ref = new Iom_jObject("REF", null);
                            ref.setobjectrefoid(parentObject.getobjectoid());
                            nextCurrentObjects.add(ref);
                            continue;
                        }
                        if (role == firstRole) {
                            IomObject targetObj = this.getReferencedObject(role, iomObj.getobjectrefoid());
                            nextCurrentObjects.add(targetObj);
                            continue;
                        }
                        nextCurrentObjects.add(parentObject);
                        continue;
                    }
                    String targetOid = null;
                    IomObject roleDefValue = iomObj.getattrobj(role.getName(), 0);
                    if (roleDefValue != null) {
                        targetOid = roleDefValue.getobjectrefoid();
                    }
                    if (this.isBackward(srcObjClass = (Viewable)this.tag2class.get(iomObj.getobjecttag()), role)) {
                        List<IomObject> objects = null;
                        if (((AssociationDef)role.getContainer()).isLightweight()) {
                            objects = this.getTargetObjectsOfReverseRole(role, iomObj.getobjectoid());
                            if (objects == null) continue;
                            nextCurrentObjects.addAll(objects);
                            continue;
                        }
                        objects = this.getLinkObjects(role, iomObj.getobjectoid());
                        if (objects == null) continue;
                        if (currentPathEl instanceof PathElAssocRole || currentPathEl instanceof PathElAbstractClassRole) {
                            for (IomObject obj : objects) {
                                IomObject attrobj = obj.getattrobj(role.getName(), 0);
                                IomObject targetObj = this.getReferencedObject(role, attrobj.getobjectrefoid());
                                if (targetObj == null) continue;
                                ArrayList<IomObject> objct = new ArrayList<IomObject>();
                                objct.add(targetObj);
                                if (k != lastPathIndex) {
                                    nextCurrentObjects.add(targetObj);
                                    continue;
                                }
                                nextCurrentObjects.addAll(objct);
                            }
                            continue;
                        }
                        if (!(currentPathEl instanceof AssociationPath)) continue;
                        nextCurrentObjects.addAll(objects);
                        continue;
                    }
                    if (k != lastPathIndex) {
                        IomObject targetObj = this.getReferencedObject(role, targetOid);
                        if (targetObj == null) continue;
                        nextCurrentObjects.add(targetObj);
                        continue;
                    }
                    ArrayList<IomObject> objects = new ArrayList<IomObject>();
                    IomObject targetRefObj = this.getReferencedObject(role, targetOid);
                    if (targetRefObj != null) {
                        if (role instanceof RoleDef) {
                            return Value.createOidValue(targetRefObj.getobjectoid());
                        }
                        objects.add(targetRefObj);
                        nextCurrentObjects.addAll(objects);
                        continue;
                    }
                    if (roleDefValue == null) continue;
                    objects.add(roleDefValue);
                    nextCurrentObjects.addAll(objects);
                    continue;
                }
                if (currentPathEl instanceof StructAttributeRef) {
                    StructAttributeRef structAttributeRefValue = (StructAttributeRef)currentPathEl;
                    if (!(structAttributeRefValue.getAttr() instanceof LocalAttribute)) continue;
                    localAttributeValue = (LocalAttribute)structAttributeRefValue.getAttr();
                    if (!(localAttributeValue.getDomain() instanceof CompositionType)) {
                        throw new IllegalStateException();
                    }
                    CompositionType type = (CompositionType)localAttributeValue.getDomain();
                    String currentAttrName = localAttributeValue.getName();
                    if (iomObj.getattrvaluecount(currentAttrName) == 0) continue;
                    IomObject targetObj = iomObj = this.getIomObjWithIndex(iomObj, structAttributeRefValue, currentAttrName);
                    if (k != lastPathIndex) {
                        nextCurrentObjects.add(targetObj);
                        continue;
                    }
                    String attrValue = iomObj.getattrvalue(currentAttrName);
                    if (attrValue != null) {
                        if (attrValue.equals("true")) {
                            return new Value(true);
                        }
                        if (attrValue.equals("false")) {
                            return new Value(false);
                        }
                        return new Value((Type)type, attrValue);
                    }
                    ArrayList<IomObject> objects = new ArrayList<IomObject>();
                    objects.add(targetObj);
                    nextCurrentObjects.addAll(objects);
                    continue;
                }
                if (currentPathEl instanceof AttributeRef) {
                    AttributeRef attrRef = (AttributeRef)currentPathEl;
                    Type type = attrRef.getAttr().getDomain();
                    String currentAttrName = currentPathEl.getName();
                    if (iomObj == null) {
                        return Value.createUndefined();
                    }
                    int attrCount = iomObj.getattrvaluecount(currentAttrName);
                    if (attrCount == 0) {
                        return Value.createUndefined();
                    }
                    if (k != lastPathIndex) {
                        for (int i = 0; i < attrCount; ++i) {
                            IomObject iomObjTmp = iomObj.getattrobj(currentAttrName, i);
                            nextCurrentObjects.add(iomObjTmp);
                        }
                        continue;
                    }
                    String attrValue = iomObj.getattrvalue(currentAttrName);
                    if (attrValue != null) {
                        if (attrValue.equals("true")) {
                            return new Value(true);
                        }
                        if (attrValue.equals("false")) {
                            return new Value(false);
                        }
                        if (type instanceof TypeAlias) {
                            Type aliasedType = ((TypeAlias)type).getAliasing().getType();
                            if (aliasedType instanceof EnumerationType) {
                                String refTypeName = ((TypeAlias)type).getAliasing().getName();
                                return new Value(aliasedType, attrValue, refTypeName);
                            }
                            return new Value(aliasedType, attrValue);
                        }
                        if (type instanceof EnumerationType) {
                            return new Value(type, attrValue);
                        }
                        if (currentObjects.size() == 1) {
                            return new Value(type, attrValue);
                        }
                        String[] attrValues = new String[currentObjects.size()];
                        int counter = 0;
                        for (IomObject value : currentObjects) {
                            attrValue = value.getattrvalue(currentAttrName);
                            if (attrValue == null) continue;
                            attrValues[counter] = attrValue;
                            ++counter;
                        }
                        if (attrValues == null) continue;
                        return new Value(type, attrValues);
                    }
                    ArrayList<IomObject> objects = new ArrayList<IomObject>();
                    int attrValueCount = iomObj.getattrvaluecount(currentAttrName);
                    for (int i = 0; i < attrValueCount; ++i) {
                        objects.add(iomObj.getattrobj(currentAttrName, i));
                    }
                    nextCurrentObjects.addAll(objects);
                    continue;
                }
                if (currentPathEl instanceof PathElRefAttr) {
                    IomObject targetObj;
                    PathElRefAttr pathElRefAttr = (PathElRefAttr)currentPathEl;
                    if (!(pathElRefAttr.getAttr() instanceof LocalAttribute)) {
                        throw new IllegalStateException();
                    }
                    localAttributeValue = (LocalAttribute)pathElRefAttr.getAttr();
                    if (!(localAttributeValue.getDomain() instanceof ReferenceType)) {
                        throw new IllegalStateException();
                    }
                    ReferenceType referenceType = (ReferenceType)localAttributeValue.getDomain();
                    String targetOid = null;
                    IomObject tmpIomObject = iomObj.getattrobj(currentPathEl.getName(), 0);
                    if (tmpIomObject != null) {
                        targetOid = tmpIomObject.getobjectrefoid();
                    }
                    if (targetOid == null || (targetObj = this.getIomObjectFromObjectPool(referenceType, targetOid)) == null) continue;
                    if (k != lastPathIndex) {
                        nextCurrentObjects.add(targetObj);
                        continue;
                    }
                    ArrayList<IomObject> objects = new ArrayList<IomObject>();
                    objects.add(targetObj);
                    nextCurrentObjects.addAll(objects);
                    continue;
                }
                if (!(currentPathEl instanceof PathElThis)) continue;
                nextCurrentObjects.addAll(currentObjects);
            }
            if (nextCurrentObjects.isEmpty()) {
                return Value.createUndefined();
            }
            if (k == lastPathIndex) {
                return new Value(nextCurrentObjects);
            }
            currentObjects = nextCurrentObjects;
            nextCurrentObjects = new ArrayList();
        }
        return Value.createUndefined();
    }

    private boolean isBackward(Viewable srcObjClass, RoleDef role) {
        AssociationDef assoc = (AssociationDef)role.getContainer();
        if (assoc.isLightweight()) {
            return this.isRoleEmbedded(role) && role.getOppEnd().getDestination() == srcObjClass;
        }
        return srcObjClass != assoc;
    }

    private boolean isRoleEmbedded(RoleDef role) {
        AbstractClassDef destination = role.getDestination();
        Iterator iterator = destination.getAttributesAndRoles2();
        while (iterator.hasNext()) {
            ViewableTransferElement obj = (ViewableTransferElement)iterator.next();
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef objRole = ((RoleDef)obj.obj).getOppEnd();
            return objRole.equals(role);
        }
        return false;
    }

    private List<IomObject> getTargetObjectsOfReverseRole(RoleDef role, String srcObjOid) {
        if (!this.targetObjects.containsKey(role)) {
            this.buildTargetObjectsMap(role);
        }
        return this.targetObjects.get(role).get(srcObjOid);
    }

    private void buildTargetObjectsMap(RoleDef role) {
        HashMap<String, ArrayList<IomObject>> values = new HashMap<String, ArrayList<IomObject>>();
        this.targetObjects.put(role, values);
        for (String basketId : this.objectPool.getBasketIds()) {
            Iterator objectIterator = this.objectPool.getObjectsOfBasketId(basketId).valueIterator();
            while (objectIterator.hasNext()) {
                IomObject refStruct;
                IomObject targetObj = (IomObject)objectIterator.next();
                if (!((Viewable)this.tag2class.get(targetObj.getobjecttag())).isExtending((Element)role.getDestination()) || (refStruct = targetObj.getattrobj(role.getOppEnd().getName(), 0)) == null) continue;
                ArrayList<IomObject> objects = (ArrayList<IomObject>)values.get(refStruct.getobjectrefoid());
                if (objects == null) {
                    objects = new ArrayList<IomObject>();
                    values.put(refStruct.getobjectrefoid(), objects);
                }
                objects.add(targetObj);
            }
        }
    }

    private IomObject getReferencedObject(RoleDef role, String oid) {
        Iterator targetClassIterator = role.iteratorDestination();
        ArrayList<Viewable> destinationClasses = new ArrayList<Viewable>();
        while (targetClassIterator.hasNext()) {
            Viewable roleDestinationClass = (Viewable)targetClassIterator.next();
            destinationClasses.add(roleDestinationClass);
        }
        OutParam bidOfTargetObj = new OutParam();
        IomObject targetObj = this.objectPool.getObject(oid, destinationClasses, (OutParam<String>)bidOfTargetObj);
        return targetObj;
    }

    private List<IomObject> getLinkObjects(RoleDef role, String srcObjOid) {
        if (!this.linkObjects.containsKey(role)) {
            this.buildLinkObjMap(role);
        }
        return this.linkObjects.get(role).get(srcObjOid);
    }

    private void buildLinkObjMap(RoleDef role) {
        HashMap<String, ArrayList<IomObject>> values = new HashMap<String, ArrayList<IomObject>>();
        this.linkObjects.put(role, values);
        for (String basketId : this.objectPool.getBasketIds()) {
            Iterator objectIterator = this.objectPool.getObjectsOfBasketId(basketId).valueIterator();
            while (objectIterator.hasNext()) {
                IomObject refStruct;
                IomObject linkObj = (IomObject)objectIterator.next();
                if (!((Viewable)this.tag2class.get(linkObj.getobjecttag())).isExtending((Element)role.getContainer()) || (refStruct = linkObj.getattrobj(role.getOppEnd().getName(), 0)) == null) continue;
                ArrayList<IomObject> objects = (ArrayList<IomObject>)values.get(refStruct.getobjectrefoid());
                if (objects == null) {
                    objects = new ArrayList<IomObject>();
                    values.put(refStruct.getobjectrefoid(), objects);
                }
                objects.add(linkObj);
            }
        }
    }

    private IomObject getIomObjWithIndex(IomObject iomObj, StructAttributeRef structAttributeRefValue, String currentAttrName) {
        int expectedIndex = (int)structAttributeRefValue.getIndex();
        int attrValueCount = iomObj.getattrvaluecount(currentAttrName);
        if (structAttributeRefValue.getIndex() == -1L) {
            iomObj = iomObj.getattrobj(currentAttrName, 0);
        } else if (structAttributeRefValue.getIndex() == -2L) {
            iomObj = iomObj.getattrobj(currentAttrName, attrValueCount - 1);
        } else if (expectedIndex <= attrValueCount && expectedIndex > 0) {
            if ((iomObj = iomObj.getattrobj(currentAttrName, expectedIndex - 1)) == null) {
                throw new IllegalStateException(this.rsrc.getString("getIomObjWithIndex.thereIsNoRecordFoundForThisIndex"));
            }
        } else {
            throw new IllegalStateException(this.rsrc.getString("getIomObjWithIndex.thereIsNoRecordFoundForThisIndex"));
        }
        return iomObj;
    }

    private IomObject getIomObjectFromObjectPool(ReferenceType referenceType, String targetOid) {
        OutParam bidOfTargetObj = new OutParam();
        ArrayList<Viewable> destinationClasses = new ArrayList<Viewable>();
        destinationClasses.add((Viewable)referenceType.getReferred());
        return this.objectPool.getObject(targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
    }

    public Value evaluateObjectCount(Value value) {
        Iterator objectIterator = this.objectPool.getObjectsOfBasketId(this.currentBasketId).valueIterator();
        int counter = 0;
        while (objectIterator.hasNext()) {
            IomObject anObj = (IomObject)objectIterator.next();
            if (anObj == null) continue;
            Object modelElement = this.tag2class.get(anObj.getobjecttag());
            Viewable viewable = (Viewable)modelElement;
            if (!value.getViewable().equals(viewable)) continue;
            ++counter;
        }
        return new Value(counter);
    }

    public Value evaluateAreArea(IomObject iomObj, Value value, PathEl[] pathToStructEle, PathEl[] pathToSurfaceAttr, Function currentFunction) {
        String objTag = null;
        if (iomObj != null) {
            objTag = iomObj.getobjecttag();
        }
        Object aModelele = this.tag2class.get(objTag);
        Viewable eleClass = (Viewable)aModelele;
        String iliClassQName = this.getScopedName(eleClass);
        if (pathToStructEle == null) {
            List<IoxInvalidDataException> intersections;
            ItfAreaPolygon2Linetable polygonPool = new ItfAreaPolygon2Linetable(iliClassQName, this.objPoolManager);
            if (value.getViewable() != null) {
                Iterator objectIterator = this.objectPool.getObjectsOfBasketId(this.currentBasketId).valueIterator();
                ArrayList<IomObject> listOfPolygons = new ArrayList<IomObject>();
                while (objectIterator.hasNext()) {
                    IomObject aIomObj = (IomObject)objectIterator.next();
                    if (aIomObj == null) continue;
                    Object modelElement = this.tag2class.get(aIomObj.getobjecttag());
                    Viewable anObjectClass = (Viewable)modelElement;
                    if (!value.getViewable().equals(anObjectClass)) continue;
                    this.findPolygonIomObject(pathToSurfaceAttr, listOfPolygons, aIomObj, 0);
                }
                for (IomObject polygon : listOfPolygons) {
                    try {
                        polygonPool.addLines(null, null, ItfAreaPolygon2Linetable.getLinesFromPolygon(polygon));
                    }
                    catch (IoxException e) {
                        EhiLogger.logError((Throwable)e);
                    }
                }
            } else {
                ArrayList<IomObject> listOfPolygons = new ArrayList<IomObject>();
                for (IomObject structEle : value.getComplexObjects()) {
                    this.findPolygonIomObject(pathToSurfaceAttr, listOfPolygons, structEle, 0);
                }
                for (IomObject polygon : listOfPolygons) {
                    try {
                        polygonPool.addLines(null, null, ItfAreaPolygon2Linetable.getLinesFromPolygon(polygon));
                    }
                    catch (IoxException e) {
                        EhiLogger.logError((Throwable)e);
                    }
                }
            }
            if ((intersections = polygonPool.validate()) != null) {
                if (!this.disableAreAreasMessages && intersections.size() > 0) {
                    for (IoxInvalidDataException ex : intersections) {
                        String tid1 = ex.getTid();
                        String iliqname = ex.getIliqname();
                        this.errFact.setTid(tid1);
                        this.errFact.setIliqname(iliqname);
                        if (ex instanceof IoxIntersectionException) {
                            this.logMsg(this.areaOverlapValidation, ((IoxIntersectionException)ex).getIntersection().toShortString(), new String[0]);
                            EhiLogger.traceState((String)ex.toString());
                            continue;
                        }
                        this.logMsg(this.areaOverlapValidation, ex.getMessage(), new String[0]);
                    }
                    this.setCurrentMainObj(null);
                }
                EhiLogger.traceState((String)(iliClassQName + ":" + currentFunction.getScopedName(null) + " returned false"));
                return new Value(false);
            }
            return new Value(true);
        }
        for (PathEl surface : pathToStructEle) {
            List<IoxInvalidDataException> intersections;
            ArrayList<IomObject> listOfPolygons;
            ItfAreaPolygon2Linetable polygonPool = new ItfAreaPolygon2Linetable(iliClassQName, this.objPoolManager);
            if (value.getViewable() != null) {
                Iterator objectIterator = this.objectPool.getObjectsOfBasketId(this.currentBasketId).valueIterator();
                listOfPolygons = new ArrayList();
                while (objectIterator.hasNext()) {
                    IomObject aIomObj = (IomObject)objectIterator.next();
                    if (aIomObj == null) continue;
                    Object modelElement = this.tag2class.get(aIomObj.getobjecttag());
                    Viewable anObjectClass = (Viewable)modelElement;
                    if (!value.getViewable().equals(anObjectClass)) continue;
                    this.findPolygonIomObject(pathToStructEle, listOfPolygons, aIomObj, 0);
                }
                for (IomObject polygon : listOfPolygons) {
                    try {
                        polygonPool.addLines(null, null, ItfAreaPolygon2Linetable.getLinesFromPolygon(polygon));
                    }
                    catch (IoxException e) {
                        EhiLogger.logError((Throwable)e);
                    }
                }
            } else {
                Iterator<IomObject> iterIomObjects = value.getComplexObjects().iterator();
                listOfPolygons = new ArrayList<IomObject>();
                Value currentValue = null;
                while (iterIomObjects.hasNext()) {
                    IomObject anObject = iterIomObjects.next();
                    currentValue = this.getValueFromObjectPath(null, anObject, pathToStructEle, null);
                    if (currentValue.isUndefined()) {
                        currentValue = this.getValueFromObjectPath(null, anObject, pathToSurfaceAttr, null);
                        continue;
                    }
                    Collection<IomObject> complexObjects = currentValue.getComplexObjects();
                    Iterator<IomObject> iterator = complexObjects.iterator();
                    while (iterator.hasNext()) {
                        this.findPolygonIomObject(pathToSurfaceAttr, listOfPolygons, iterator.next(), 0);
                    }
                }
                for (IomObject polygon : listOfPolygons) {
                    try {
                        polygonPool.addLines(null, null, ItfAreaPolygon2Linetable.getLinesFromPolygon(polygon));
                    }
                    catch (IoxException e) {
                        EhiLogger.logError((Throwable)e);
                    }
                }
            }
            if ((intersections = polygonPool.validate()) == null) continue;
            if (!this.disableAreAreasMessages && intersections.size() > 0) {
                for (IoxInvalidDataException ex : intersections) {
                    String tid1 = ex.getTid();
                    String iliqname = ex.getIliqname();
                    this.errFact.setTid(tid1);
                    this.errFact.setIliqname(iliqname);
                    if (ex instanceof IoxIntersectionException) {
                        this.logMsg(this.areaOverlapValidation, ((IoxIntersectionException)ex).getIntersection().toShortString(), new String[0]);
                        EhiLogger.traceState((String)ex.toString());
                        continue;
                    }
                    this.logMsg(this.areaOverlapValidation, ex.getMessage(), new String[0]);
                }
                this.setCurrentMainObj(null);
            }
            EhiLogger.traceState((String)(iliClassQName + ":" + currentFunction.getScopedName(null) + " returned false"));
            return new Value(false);
        }
        return new Value(true);
    }

    private void findPolygonIomObject(PathEl[] pathEl, ArrayList<IomObject> listOfPolygons, IomObject structEle, int startIndex) {
        if (pathEl != null) {
            int lengthOfSurfaceAttr = pathEl.length - 1;
            while (startIndex < pathEl.length) {
                PathEl pathElLine = pathEl[startIndex];
                int attrCount = structEle.getattrvaluecount(pathElLine.getName());
                for (int i = 0; i < attrCount; ++i) {
                    IomObject polygon;
                    if (startIndex == lengthOfSurfaceAttr) {
                        polygon = structEle.getattrobj(pathElLine.getName(), 0);
                        listOfPolygons.add(polygon);
                        continue;
                    }
                    polygon = structEle.getattrobj(pathElLine.getName(), i);
                    this.findPolygonIomObject(pathEl, listOfPolygons, polygon, startIndex);
                }
                ++startIndex;
            }
        }
    }

    private String getEnumerationConstantXtfValue(Constant.Enumeration enumValue) {
        String[] value = enumValue.getValue();
        StringBuilder buf = new StringBuilder(100);
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                buf.append('.');
            }
            buf.append(value[i]);
        }
        return buf.toString();
    }

    private void validateRoleCardinality(RoleDef role, IomObject iomObj) {
        String roleQName = null;
        roleQName = this.getScopedName(role);
        String multiplicity = this.validationConfig.getConfigValue(roleQName, "multiplicity");
        if (multiplicity == null) {
            multiplicity = this.globalMultiplicity;
        }
        if (multiplicity != null && "off".equals(multiplicity)) {
            if (!this.configOffOufputReduction.contains("multiplicity:" + roleQName)) {
                this.configOffOufputReduction.add("multiplicity:" + roleQName);
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateRoleCardinality.validationConfigurationMultiplicityOff"), roleQName));
            }
        } else {
            if (!this.configOffOufputReduction.contains("multiplicity:" + roleQName)) {
                this.configOffOufputReduction.add("multiplicity:" + roleQName);
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateRoleCardinality.validateMultiplicityOfRole"), roleQName));
            }
            long nrOfTargetObjs = this.linkPool.getTargetObjectCount(iomObj, role, this.doItfOidPerTable);
            long cardMin = role.getCardinality().getMinimum();
            long cardMax = role.getCardinality().getMaximum();
            if (nrOfTargetObjs < cardMin || nrOfTargetObjs > cardMax) {
                if (role.getCardinality().getMaximum() == Long.MAX_VALUE) {
                    String cardMaxStr = "*";
                    this.logMsg(multiplicity, this.rsrc.getString("validateRoleCardinality.shouldAssociateToTargetObject"), role.getName(), String.valueOf(cardMin), cardMaxStr, String.valueOf(nrOfTargetObjs));
                } else {
                    this.logMsg(multiplicity, this.rsrc.getString("validateRoleCardinality.shouldAssociateToTargetObject"), role.getName(), String.valueOf(cardMin), String.valueOf(cardMax), String.valueOf(nrOfTargetObjs));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateRoleReference(String bidOfObj, RoleDef role, IomObject iomObj) {
        Viewable destinationClass;
        String oid;
        String bid;
        Object modelElement = this.tag2class.get(iomObj.getobjecttag());
        Viewable classObj = (Viewable)modelElement;
        String roleQName = this.getScopedName(role);
        String validateTarget = null;
        if (!this.enforceTargetValidation) {
            validateTarget = this.validationConfig.getConfigValue(roleQName, "target");
        }
        if ("off".equals(validateTarget)) {
            if (this.configOffOufputReduction.contains("target:" + roleQName)) return;
            this.configOffOufputReduction.add("target:" + roleQName);
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateRoleReference.validationConfigurationTargetOff"), roleQName));
            return;
        }
        if (!this.datatypesOutputReduction.contains(roleQName)) {
            this.datatypesOutputReduction.add(roleQName);
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateRoleReference.validateTargetOfRole"), roleQName));
        }
        String targetOid = null;
        IomObject roleDefValue = iomObj.getattrobj(role.getName(), 0);
        if (roleDefValue != null) {
            targetOid = roleDefValue.getobjectrefoid();
        }
        if (targetOid == null) {
            return;
        }
        Iterator targetClassIterator = role.iteratorDestination();
        ArrayList<Viewable> destinationClasses = new ArrayList<Viewable>();
        StringBuffer possibleTargetClasses = new StringBuffer();
        String sep = "";
        while (targetClassIterator.hasNext()) {
            Viewable roleDestinationClass = (Viewable)targetClassIterator.next();
            destinationClasses.add(roleDestinationClass);
            possibleTargetClasses.append(sep);
            sep = ",";
            possibleTargetClasses.append(roleDestinationClass.getScopedName(null));
        }
        OutParam bidOfTargetObj = new OutParam();
        IomObject targetObj = this.objectPool.getObject(targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
        if (targetObj == null && (bid = this.validationConfig.getConfigValue(roleQName, "requiredIn")) != null) {
            targetObj = this.findExternalObject(bid, targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
        }
        if ((oid = iomObj.getobjectoid()) == null) {
            oid = ObjectPool.getAssociationId(iomObj, (AssociationDef)modelElement);
        }
        if (!role.isExternal()) {
            if (targetOid != null) {
                if (!this.isBasketSame(bidOfObj, targetObj)) {
                    this.logMsg(validateTarget, this.rsrc.getString("validateRoleReference.noObjectFoundWithOidInBasket"), targetOid, bidOfObj);
                    return;
                }
                if (targetObj == null) {
                    this.logMsg(validateTarget, this.rsrc.getString("validateRoleReference.noObjectFoundWithOid"), targetOid);
                    return;
                }
            }
        } else if (targetObj == null) {
            boolean extObjFound = false;
            if (this.extObjResolvers != null) {
                for (ExternalObjectResolver extObjResolver : this.extObjResolvers) {
                    if (!extObjResolver.objectExists(targetOid, destinationClasses)) continue;
                    extObjFound = true;
                    break;
                }
            }
            if (this.allObjectsAccessible && !extObjFound) {
                this.logMsg(validateTarget, this.rsrc.getString("validateRoleReference.noObjectFoundWithOid"), targetOid);
            }
        }
        if (targetObj == null) return;
        Object modelEle = this.tag2class.get(targetObj.getobjecttag());
        Viewable targetObjClass = (Viewable)modelEle;
        Iterator<Viewable> iterator = destinationClasses.iterator();
        do {
            if (!iterator.hasNext()) {
                this.logMsg(validateTarget, this.rsrc.getString("validateRoleReference.wrongClassOfTargetObjectForRole"), this.getScopedName(targetObjClass), targetOid, this.getScopedName(role));
                return;
            }
            destinationClass = iterator.next();
            if (!targetObjClass.equals(destinationClass)) continue;
            return;
        } while (targetObjClass.getExtending() == null || !targetObjClass.isExtending((Element)destinationClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IomObject findExternalObject(String targetBid, String targetOid, ArrayList<Viewable> destinationClasses, OutParam<String> bidOfTargetObj) {
        if (!this.objectPool.getBasketIds().contains(targetBid)) {
            List<Dataset> dataset = null;
            File[] datasetFiles = null;
            IoxReader reader = null;
            try {
                dataset = this.repositoryManager.getDatasetIndex(targetBid, null);
                if (dataset != null && !dataset.isEmpty()) {
                    datasetFiles = this.repositoryManager.getLocalFileOfRemoteDataset(dataset.get(0), "application/interlis+xml;version=2.3");
                }
                if (datasetFiles != null) {
                    File[] files;
                    for (File file : files = (File[])datasetFiles.clone()) {
                        reader = new ReaderFactory().createReader(file, this.errFact);
                        String currentBid = null;
                        while (true) {
                            IoxEvent currentIoxEvent;
                            if ((currentIoxEvent = reader.read()) instanceof ObjectEvent) {
                                IomObject iomObject = this.objectPool.addObject(((ObjectEvent)currentIoxEvent).getIomObject(), currentBid);
                                continue;
                            }
                            if (currentIoxEvent instanceof StartBasketEvent) {
                                currentBid = ((StartBasketEvent)currentIoxEvent).getBid();
                                continue;
                            }
                            if (currentIoxEvent instanceof EndTransferEvent) break;
                        }
                    }
                }
            }
            catch (RepositoryAccessException e) {
                EhiLogger.logError((Throwable)e);
            }
            catch (Ili2cException e) {
                EhiLogger.logError((Throwable)e);
            }
            catch (IoxException e) {
                EhiLogger.logError((Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IoxException e) {
                        EhiLogger.logError((Throwable)e);
                    }
                }
            }
        }
        return this.objectPool.getObject(targetOid, destinationClasses, bidOfTargetObj);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateReferenceAttrs(String structAttrQName, IomObject iomStruct, Table structure, String bidOfObj) {
        Iterator attrIter = structure.getAttributesAndRoles();
        while (attrIter.hasNext()) {
            LocalAttribute refAttr;
            Type type;
            Object refAttrO = attrIter.next();
            if (!(refAttrO instanceof LocalAttribute) || !((type = (refAttr = (LocalAttribute)refAttrO).getDomain()) instanceof ReferenceType)) continue;
            ReferenceType refAttrType = (ReferenceType)type;
            String validateTarget = null;
            String attrQName = this.getScopedName((AttributeDef)refAttr);
            if (!this.enforceTargetValidation) {
                validateTarget = this.validationConfig.getConfigValue(attrQName, "target");
            }
            if ("off".equals(validateTarget)) {
                if (this.configOffOufputReduction.contains("target:" + attrQName)) continue;
                this.configOffOufputReduction.add("target:" + attrQName);
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateReferenceAttrs.validationConfigurationTargetOff"), attrQName));
                continue;
            }
            if (!this.datatypesOutputReduction.contains(attrQName)) {
                this.datatypesOutputReduction.add(attrQName);
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateReferenceAttrs.validateReferenceAttr"), attrQName));
            }
            IomObject refAttrStruct = iomStruct.getattrobj(refAttr.getName(), 0);
            String targetOid = null;
            if (refAttrStruct != null) {
                targetOid = refAttrStruct.getobjectrefoid();
            }
            AbstractClassDef targetClass = refAttrType.getReferred();
            ArrayList<Viewable> destinationClasses = new ArrayList<Viewable>();
            destinationClasses.add((Viewable)targetClass);
            String targetObjClassStr = null;
            OutParam bidOfTargetObj = new OutParam();
            IomObject targetObject = null;
            if (targetOid != null) {
                targetObject = this.objectPool.getObject(targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
            }
            if (targetObject == null) {
                String bid = this.validationConfig.getConfigValue(attrQName, "requiredIn");
                if (bid == null) {
                    bid = this.validationConfig.getConfigValue(structAttrQName, "requiredIn");
                }
                if (bid != null) {
                    targetObject = this.findExternalObject(bid, targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
                }
            }
            if (!refAttrType.isExternal()) {
                if (targetOid != null) {
                    if (targetObject == null) {
                        this.logMsg(validateTarget, this.rsrc.getString("validateReferenceAttrs.noObjectFoundWithOid"), targetOid);
                        return;
                    }
                    if (!this.isBasketSame(bidOfObj, targetObject)) {
                        this.logMsg(validateTarget, this.rsrc.getString("validateReferenceAttrs.noObjectFoundWithOidInBasket"), targetOid, bidOfObj);
                        return;
                    }
                }
            } else if (targetObject == null && targetOid != null) {
                boolean extObjFound = false;
                if (this.extObjResolvers != null) {
                    for (ExternalObjectResolver extObjResolver : this.extObjResolvers) {
                        if (!extObjResolver.objectExists(targetOid, destinationClasses)) continue;
                        extObjFound = true;
                        break;
                    }
                }
                if (this.allObjectsAccessible && !extObjFound) {
                    this.logMsg(validateTarget, this.rsrc.getString("validateReferenceAttrs.noObjectFoundWithOid"), targetOid);
                }
            }
            if (targetObject == null) continue;
            Object modelEle = this.tag2class.get(targetObject.getobjecttag());
            Table targetObjClass = (Table)modelEle;
            targetObjClassStr = targetObject.getobjecttag();
            StringBuffer classNames = new StringBuffer();
            String sep = "";
            Iterator refAttrRestrictionIter = refAttrType.iteratorRestrictedTo();
            while (refAttrRestrictionIter.hasNext()) {
                Object refAttrRestriction = refAttrRestrictionIter.next();
                targetClass = (Table)refAttrRestriction;
                if (targetObjClass.isExtending((Element)targetClass)) {
                    return;
                }
                classNames.append(sep);
                classNames.append(targetClass.getScopedName(null));
                sep = ", ";
            }
            if (targetObjClass.isExtending((Element)targetClass) || targetObjClass.equals(targetClass)) continue;
            this.logMsg(validateTarget, this.rsrc.getString("validateReferenceAttrs.wrongClassOfTargetObjectForReferenceAttr"), this.getScopedName((Viewable)targetObjClass), targetOid, this.getScopedName((AttributeDef)refAttr));
        }
        return;
    }

    private void validateExistenceConstraint(IomObject iomObj, ExistenceConstraint existenceConstraint) {
        if (!"off".equals(this.constraintValidation)) {
            String constraintName = this.getScopedName((Constraint)existenceConstraint);
            String checkConstraint = null;
            if (!this.enforceConstraintValidation) {
                checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
            }
            if ("off".equals(checkConstraint)) {
                if (!this.configOffOufputReduction.contains("check:" + constraintName)) {
                    this.configOffOufputReduction.add("check:" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateExistenceConstraint.validationConfigurationCheckOff"), constraintName));
                }
            } else {
                String restrictedAttrName;
                if (iomObj.getattrcount() == 0) {
                    return;
                }
                if (!this.constraintOutputReduction.contains(existenceConstraint + ":" + constraintName)) {
                    this.constraintOutputReduction.add(existenceConstraint + ":" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateExistenceConstraint.validateExistenceConstraint"), this.getScopedName((Constraint)existenceConstraint)));
                }
                if (iomObj.getattrvaluecount(restrictedAttrName = existenceConstraint.getRestrictedAttribute().getLastPathEl().getName()) == 0) {
                    return;
                }
                Type type = existenceConstraint.getRestrictedAttribute().getType();
                if (type instanceof TypeAlias) {
                    TypeAlias aliasType = (TypeAlias)type;
                    Domain domainAliasing = aliasType.getAliasing();
                    type = domainAliasing.getType();
                }
                Iterator requiredInIterator = existenceConstraint.iteratorRequiredIn();
                boolean valueExists = false;
                Table classA = null;
                Table otherClass = null;
                while (!valueExists && requiredInIterator.hasNext()) {
                    classA = null;
                    ObjectPath otherAttrPath = (ObjectPath)requiredInIterator.next();
                    String otherAttrName = otherAttrPath.toString();
                    otherClass = (Table)otherAttrPath.getRoot();
                    String attrValueThisObj = iomObj.getattrvalue(restrictedAttrName);
                    Iterator<String> basketIdIterator = this.objectPool.getBasketIds().iterator();
                    while (!valueExists && basketIdIterator.hasNext()) {
                        String basketId = basketIdIterator.next();
                        Iterator objectIterator = this.objectPool.getObjectsOfBasketId(basketId).valueIterator();
                        block2: while (!valueExists && objectIterator.hasNext()) {
                            IomObject otherIomObj = (IomObject)objectIterator.next();
                            if (otherIomObj.getattrcount() == 0) continue;
                            Object modelElement = this.tag2class.get(otherIomObj.getobjecttag());
                            classA = (Table)modelElement;
                            if (otherIomObj.getattrvaluecount(otherAttrName) <= 0 || !classA.isExtending((Element)otherClass)) continue;
                            if (type instanceof ReferenceType) {
                                ReferenceType referenceType = (ReferenceType)type;
                                valueExists = this.equalsReferenceValue(iomObj, referenceType, otherIomObj, otherAttrName, restrictedAttrName);
                                continue;
                            }
                            if (type instanceof CoordType) {
                                CoordType coordType = (CoordType)type;
                                valueExists = this.equalsCoordValue(iomObj, coordType, otherIomObj, otherAttrName, restrictedAttrName);
                                continue;
                            }
                            if (type instanceof PolylineType) {
                                PolylineType polylineType = (PolylineType)type;
                                valueExists = this.equalsPolylineValue(iomObj, polylineType, otherIomObj, otherAttrName, restrictedAttrName);
                                continue;
                            }
                            if (type instanceof SurfaceOrAreaType) {
                                SurfaceOrAreaType surfaceOrAreaType = (SurfaceOrAreaType)type;
                                valueExists = this.equalsSurfaceOrAreaValue(iomObj, surfaceOrAreaType, otherIomObj, otherAttrName, restrictedAttrName);
                                continue;
                            }
                            if (type instanceof CompositionType) {
                                if (iomObj.getattrvaluecount(restrictedAttrName) != otherIomObj.getattrvaluecount(restrictedAttrName)) continue;
                                for (int structi = 0; structi < iomObj.getattrvaluecount(restrictedAttrName); ++structi) {
                                    IomObject structEle = iomObj.getattrobj(restrictedAttrName, structi);
                                    IomObject otherStructEle = otherIomObj.getattrobj(restrictedAttrName, structi);
                                    if (structEle == null || otherStructEle == null || !(valueExists = this.equalsStructEle((Viewable)((CompositionType)type).getComponentType(), structEle, otherStructEle))) continue block2;
                                }
                                continue;
                            }
                            if (!otherIomObj.getattrvalue(otherAttrName).equals(iomObj.getattrvalue(restrictedAttrName))) continue;
                            valueExists = true;
                        }
                    }
                }
                if (!valueExists) {
                    String actualLanguage = Locale.getDefault().getLanguage();
                    String msg = this.validationConfig.getConfigValue(constraintName, "msg_" + actualLanguage);
                    if (msg == null) {
                        msg = this.validationConfig.getConfigValue(constraintName, "msg");
                    }
                    if (msg != null && msg.length() > 0) {
                        this.logMsg(checkConstraint, msg, new String[0]);
                    } else {
                        this.logMsg(checkConstraint, this.rsrc.getString("validateExistenceConstraint.valueOfTheAttributeWasNotFoundInTheConditionClass"), restrictedAttrName.toString(), iomObj.getobjecttag().toString());
                    }
                }
            }
        }
    }

    private boolean equalsStructEle(Viewable aclass, IomObject iomObj, IomObject otherIomObj) {
        Iterator iter = aclass.getAttributesAndRoles2();
        while (iter.hasNext()) {
            Type proxyType;
            AttributeDef attr;
            ViewableTransferElement obj = (ViewableTransferElement)iter.next();
            if (!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
            String targetAttrName = attr.getName();
            Type type = attr.getDomainResolvingAliases();
            if (iomObj.getattrvaluecount(targetAttrName) != otherIomObj.getattrvaluecount(targetAttrName)) {
                return false;
            }
            if (iomObj.getattrvaluecount(targetAttrName) <= 0) continue;
            if (type instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)type;
                if (this.equalsReferenceValue(iomObj, referenceType, otherIomObj, targetAttrName, targetAttrName)) continue;
                return false;
            }
            if (type instanceof CoordType) {
                CoordType coordType = (CoordType)type;
                if (this.equalsCoordValue(iomObj, coordType, otherIomObj, targetAttrName, targetAttrName)) continue;
                return false;
            }
            if (type instanceof PolylineType) {
                PolylineType polylineType = (PolylineType)type;
                if (this.equalsPolylineValue(iomObj, polylineType, otherIomObj, targetAttrName, targetAttrName)) continue;
                return false;
            }
            if (type instanceof SurfaceOrAreaType) {
                SurfaceOrAreaType surfaceOrAreaType = (SurfaceOrAreaType)type;
                if (this.equalsSurfaceOrAreaValue(iomObj, surfaceOrAreaType, otherIomObj, targetAttrName, targetAttrName)) continue;
                return false;
            }
            if (type instanceof CompositionType) {
                for (int structi = 0; structi < iomObj.getattrvaluecount(targetAttrName); ++structi) {
                    IomObject structEle = iomObj.getattrobj(targetAttrName, structi);
                    IomObject otherStructEle = otherIomObj.getattrobj(targetAttrName, structi);
                    if (structEle != null && otherStructEle != null) {
                        if (this.equalsStructEle((Viewable)((CompositionType)type).getComponentType(), structEle, otherStructEle)) continue;
                        return false;
                    }
                    return false;
                }
                continue;
            }
            if (otherIomObj.getattrvalue(targetAttrName).equals(iomObj.getattrvalue(targetAttrName))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsSurfaceOrAreaValue(IomObject iomObj, SurfaceOrAreaType surfaceType, IomObject otherIomObj, String otherAttrName, String restrictedAttrName) {
        IomObject objA = iomObj.getattrobj(restrictedAttrName, 0);
        IomObject objB = otherIomObj.getattrobj(otherAttrName, 0);
        if (objA != null && objB != null) {
            for (int i = 0; i < objA.getattrvaluecount("surface"); ++i) {
                IomObject surfaceA = objA.getattrobj("surface", i);
                IomObject surfaceB = objB.getattrobj("surface", i);
                if (objA.getattrvaluecount("surface") != objB.getattrvaluecount("surface")) {
                    return false;
                }
                for (int j = 0; j < surfaceA.getattrvaluecount("boundary"); ++j) {
                    IomObject boundaryA = surfaceA.getattrobj("boundary", j);
                    IomObject boundaryB = surfaceB.getattrobj("boundary", j);
                    if (boundaryA.getattrvaluecount("boundary") != boundaryB.getattrvaluecount("boundary")) {
                        return false;
                    }
                    for (int k = 0; k < boundaryA.getattrvaluecount("polyline"); ++k) {
                        IomObject polylineA = boundaryA.getattrobj("polyline", k);
                        IomObject polylineB = boundaryB.getattrobj("polyline", k);
                        if (polylineA.getattrvaluecount("polyline") != polylineB.getattrvaluecount("polyline")) {
                            return false;
                        }
                        for (int l = 0; l < polylineA.getattrvaluecount("sequence"); ++l) {
                            IomObject sequenceA = polylineA.getattrobj("sequence", l);
                            IomObject sequenceB = polylineB.getattrobj("sequence", l);
                            if (objA.getattrvaluecount("sequence") != objB.getattrvaluecount("sequence")) {
                                return false;
                            }
                            for (int m = 0; m < sequenceA.getattrvaluecount("segment"); ++m) {
                                IomObject segmentA = sequenceA.getattrobj("segment", m);
                                IomObject segmentB = sequenceB.getattrobj("segment", m);
                                if (segmentA.getattrvaluecount("segment") != segmentB.getattrvaluecount("segment")) {
                                    return false;
                                }
                                for (int n = 0; n < segmentA.getattrcount(); ++n) {
                                    if (segmentA.getobjecttag().equals("COORD")) {
                                        if (segmentA.getattrvalue("C1") != null && segmentB.getattrvalue("C1") != null) {
                                            if (!segmentA.getattrvalue("C1").equals(segmentB.getattrvalue("C1"))) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                        if (segmentA.getattrvalue("C2") != null && segmentB.getattrvalue("C2") != null && !segmentA.getattrvalue("C2").equals(segmentB.getattrvalue("C2"))) {
                                            return false;
                                        }
                                        if (segmentA.getattrvalue("C3") == null || segmentB.getattrvalue("C3") == null || segmentA.getattrvalue("C3").equals(segmentB.getattrvalue("C3"))) continue;
                                        return false;
                                    }
                                    if (!segmentA.getobjecttag().equals("ARC")) continue;
                                    if (segmentA.getattrvalue("A1") != null && segmentB.getattrvalue("A1") != null) {
                                        if (!segmentA.getattrvalue("A1").equals(segmentB.getattrvalue("A1"))) {
                                            return false;
                                        }
                                    } else {
                                        return false;
                                    }
                                    if (segmentA.getattrvalue("A2") != null && segmentB.getattrvalue("A2") != null) {
                                        if (!segmentA.getattrvalue("A2").equals(segmentB.getattrvalue("A2"))) {
                                            return false;
                                        }
                                    } else {
                                        return false;
                                    }
                                    if (segmentA.getattrvalue("C1") != null && segmentB.getattrvalue("C1") != null) {
                                        if (!segmentA.getattrvalue("C1").equals(segmentB.getattrvalue("C1"))) {
                                            return false;
                                        }
                                    } else {
                                        return false;
                                    }
                                    if (segmentA.getattrvalue("C2") != null && segmentB.getattrvalue("C2") != null && !segmentA.getattrvalue("C2").equals(segmentB.getattrvalue("C2"))) {
                                        return false;
                                    }
                                    if (segmentA.getattrvalue("C3") == null || segmentB.getattrvalue("C3") == null || segmentA.getattrvalue("C3").equals(segmentB.getattrvalue("C3"))) continue;
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private boolean equalsPolylineValue(IomObject iomObj, PolylineType polylineType, IomObject otherIomObj, String otherAttrName, String restrictedAttrName) {
        IomObject objA = iomObj.getattrobj(restrictedAttrName, 0);
        IomObject objB = otherIomObj.getattrobj(otherAttrName, 0);
        if (objA != null && objB != null) {
            for (int i = 0; i < objA.getattrvaluecount("sequence"); ++i) {
                IomObject sequenceA = objA.getattrobj("sequence", i);
                IomObject sequenceB = objB.getattrobj("sequence", i);
                if (objA.getattrvaluecount("sequence") != objB.getattrvaluecount("sequence")) {
                    return false;
                }
                for (int j = 0; j < sequenceA.getattrvaluecount("segment"); ++j) {
                    IomObject segmentA = sequenceA.getattrobj("segment", j);
                    IomObject segmentB = sequenceB.getattrobj("segment", j);
                    if (segmentA.getattrvaluecount("segment") != segmentB.getattrvaluecount("segment")) {
                        return false;
                    }
                    for (int k = 0; k < segmentA.getattrcount(); ++k) {
                        if (segmentA.getobjecttag().equals("COORD")) {
                            if (segmentA.getattrvalue("C1") != null && segmentB.getattrvalue("C1") != null) {
                                if (!segmentA.getattrvalue("C1").equals(segmentB.getattrvalue("C1"))) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                            if (segmentA.getattrvalue("C2") != null && segmentB.getattrvalue("C2") != null && !segmentA.getattrvalue("C2").equals(segmentB.getattrvalue("C2"))) {
                                return false;
                            }
                            if (segmentA.getattrvalue("C3") == null || segmentB.getattrvalue("C3") == null || segmentA.getattrvalue("C3").equals(segmentB.getattrvalue("C3"))) continue;
                            return false;
                        }
                        if (!segmentA.getobjecttag().equals("ARC")) continue;
                        if (segmentA.getattrvalue("A1") != null && segmentB.getattrvalue("A1") != null) {
                            if (!segmentA.getattrvalue("A1").equals(segmentB.getattrvalue("A1"))) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        if (segmentA.getattrvalue("A2") != null && segmentB.getattrvalue("A2") != null) {
                            if (!segmentA.getattrvalue("A2").equals(segmentB.getattrvalue("A2"))) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        if (segmentA.getattrvalue("C1") != null && segmentB.getattrvalue("C1") != null) {
                            if (!segmentA.getattrvalue("C1").equals(segmentB.getattrvalue("C1"))) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        if (segmentA.getattrvalue("C2") != null && segmentB.getattrvalue("C2") != null && !segmentA.getattrvalue("C2").equals(segmentB.getattrvalue("C2"))) {
                            return false;
                        }
                        if (segmentA.getattrvalue("C3") == null || segmentB.getattrvalue("C3") == null || segmentA.getattrvalue("C3").equals(segmentB.getattrvalue("C3"))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean equalsReferenceValue(IomObject iomObj, ReferenceType referenceType, IomObject otherIomObj, String otherAttrName, String restrictedAttrName) {
        IomObject referenceValueRestricted = iomObj.getattrobj(restrictedAttrName, 0);
        IomObject referenceValueOther = otherIomObj.getattrobj(otherAttrName, 0);
        return true;
    }

    private boolean equalsCoordValue(IomObject iomObj, CoordType coordType, IomObject otherIomObj, String otherAttrName, String restrictedAttrName) {
        IomObject coordValueRestricted = iomObj.getattrobj(restrictedAttrName, 0);
        IomObject coordValueOther = otherIomObj.getattrobj(otherAttrName, 0);
        if (coordType.getDimensions().length >= 1 && (coordValueRestricted.getattrvalue("C1") != null ? !coordValueRestricted.getattrvalue("C1").equals(coordValueOther.getattrvalue("C1")) : coordValueOther.getattrvalue("C1") != null)) {
            return false;
        }
        if (coordType.getDimensions().length >= 2 && (coordValueRestricted.getattrvalue("C2") != null ? !coordValueRestricted.getattrvalue("C2").equals(coordValueOther.getattrvalue("C2")) : coordValueOther.getattrvalue("C2") != null)) {
            return false;
        }
        return coordType.getDimensions().length < 3 || !(coordValueRestricted.getattrvalue("C3") != null ? !coordValueRestricted.getattrvalue("C3").equals(coordValueOther.getattrvalue("C3")) : coordValueOther.getattrvalue("C3") != null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateObject(IomObject iomObj, String attrPath, Viewable assocClass) throws IoxException {
        IomObject objectValue;
        boolean addToPool;
        Viewable aclass1;
        boolean isObject;
        block47: {
            String tag;
            block48: {
                String oid;
                Domain oidType;
                block45: {
                    AssociationDef modelAssociationDef;
                    block46: {
                        String objectoid;
                        boolean bl = isObject = attrPath == null;
                        if (isObject) {
                            this.setCurrentMainObj(iomObj);
                        }
                        if (isObject && (objectoid = iomObj.getobjectoid()) != null && !objectoid.equals("") && this.uniquenessOfBid.containsKey(objectoid)) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.oidIsEqualToABid"), objectoid));
                        }
                        tag = iomObj.getobjecttag();
                        Object modelele = null;
                        modelele = assocClass != null && "REF".equals(tag) ? assocClass : this.tag2class.get(tag);
                        if (modelele == null) {
                            if (!this.unknownTypev.contains(tag)) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.unknownClass"), tag));
                            }
                            return;
                        }
                        if (isObject && this.doItfLineTables && modelele instanceof AttributeDef) {
                            this.validateItfLineTableObject(iomObj, (AttributeDef)modelele);
                            return;
                        }
                        aclass1 = (Viewable)modelele;
                        addToPool = true;
                        if (isObject) {
                            this.errFact.setDefaultCoord(this.getDefaultCoord(iomObj));
                        }
                        if (aclass1.isAbstract()) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.objectMustBeANonAbstractClass"), new String[0]));
                        }
                        if (!(aclass1 instanceof AssociationDef)) break block45;
                        modelAssociationDef = (AssociationDef)aclass1;
                        oidType = modelAssociationDef.getOid();
                        oid = iomObj.getobjectoid();
                        if (!modelAssociationDef.isIdentifiable() && oidType == null) break block46;
                        if (oid == null) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.AssociationHasToHaveAnOid"), iomObj.getobjecttag()));
                            addToPool = false;
                            break block47;
                        } else if (!this.isValidId(oid)) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.valueIsNotAValidOid"), oid));
                        }
                        break block47;
                    }
                    if (oid != null) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.associationHasNotToHaveAnOid"), iomObj.getobjecttag(), oid));
                        break block47;
                    } else if (isObject) {
                        this.currentMainOid = ObjectPool.getAssociationId(iomObj, modelAssociationDef);
                    }
                    break block47;
                }
                if (!(aclass1 instanceof Table)) break block47;
                Table classValueTable = (Table)aclass1;
                if (!classValueTable.isIdentifiable()) break block48;
                oidType = ((AbstractClassDef)aclass1).getOid();
                oid = iomObj.getobjectoid();
                if (oid == null) {
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.classHasToHaveAnOid"), iomObj.getobjecttag()));
                    addToPool = false;
                    break block47;
                } else if (!this.isValidId(oid) && oidType == null) {
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.valueIsNotAValidOid"), oid));
                }
                break block47;
            }
            addToPool = false;
            String structId = iomObj.getobjectoid();
            if (structId != null) {
                if (isObject) {
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.structureHasNotToHaveAnOid"), iomObj.getobjecttag()));
                } else {
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.structAttrMustNotHaveAnOid"), attrPath, tag, structId));
                }
            }
        }
        if (isObject && aclass1 instanceof AbstractClassDef) {
            Domain oidType = ((AbstractClassDef)aclass1).getOid();
            String oid = iomObj.getobjectoid();
            if (oidType != null && oidType == this.td.INTERLIS.UUIDOID) {
                if (oid != null && !this.isValidUuid(oid)) {
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.tidIsNotAValidUuid"), oid));
                }
            } else if (oidType == null || oidType != this.td.INTERLIS.I32OID) {
                if (oidType != null && oidType == this.td.INTERLIS.STANDARDOID) {
                    if (!this.isValidStandartOId(oid)) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.valueIsNotAValidOid"), oid));
                    }
                } else if (oidType != null && oidType.getType() instanceof TextOIDType && !this.isValidTextOId(oid)) {
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.valueIsNotAValidOid"), oid));
                }
            }
        }
        HashSet<String> propNames = new HashSet<String>();
        Iterator iter = aclass1.getAttributesAndRoles2();
        while (iter.hasNext()) {
            String refoid;
            RoleDef role;
            block50: {
                int propc;
                String roleName;
                block49: {
                    Type proxyType;
                    AttributeDef attr;
                    ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                    if (!(!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                        propNames.add(attr.getName());
                        this.validateAttrValue(aclass1, iomObj, attr, attrPath);
                    }
                    if (!isObject || !(obj.obj instanceof RoleDef)) continue;
                    role = (RoleDef)obj.obj;
                    refoid = null;
                    roleName = role.getName();
                    if (!obj.embedded) break block49;
                    propc = iomObj.getattrvaluecount(roleName);
                    if (propc >= 1) {
                        IomObject embeddedLinkObj = iomObj.getattrobj(roleName, 0);
                        AssociationDef roleOwner = (AssociationDef)role.getContainer();
                        if (roleOwner.getDerivedFrom() == null) {
                            propNames.add(roleName);
                            if (propc > 0) {
                                this.validateObject(embeddedLinkObj, roleName, (Viewable)roleOwner);
                            }
                            if (embeddedLinkObj != null) {
                                refoid = embeddedLinkObj.getobjectrefoid();
                                long orderPos = embeddedLinkObj.getobjectreforderpos();
                                if (orderPos == 0L) {
                                    // empty if block
                                }
                            } else {
                                refoid = null;
                            }
                        }
                        if (propc > 1) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.roleRequiresOnlyOneReferenceProperty"), role.getScopedName()));
                        }
                        if (refoid == null) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.roleRequiresAReferenceToAnotherObject"), role.getScopedName()));
                        }
                    }
                    break block50;
                }
                propc = iomObj.getattrvaluecount(roleName);
                if (propc == 1) {
                    IomObject structvalue = iomObj.getattrobj(roleName, 0);
                    propNames.add(roleName);
                    refoid = structvalue.getobjectrefoid();
                    long orderPos = structvalue.getobjectreforderpos();
                    if (orderPos != 0L) {
                        // empty if block
                    }
                }
                if (refoid == null) {
                    addToPool = false;
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.roleRequiresAReferenceToAnotherObject"), role.getScopedName()));
                }
            }
            if (refoid == null) continue;
            this.linkPool.addLink(iomObj, role, refoid, this.doItfOidPerTable);
        }
        if (isObject && addToPool && (objectValue = this.objectPool.addObject(iomObj, this.currentBasketId)) != null) {
            Object modelElement = this.tag2class.get(objectValue.getobjecttag());
            Viewable classValueOfKey = (Viewable)modelElement;
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.oidXOfObjectYAlreadyExistsInZ"), this.currentMainOid, iomObj.getobjecttag(), classValueOfKey.toString()));
        }
        int propc = iomObj.getattrcount();
        int propi = 0;
        while (propi < propc) {
            String propName = iomObj.getattrname(propi);
            if (!propName.startsWith("_") && !propNames.contains(propName)) {
                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.unknownPropertyX"), propName));
            }
            ++propi;
        }
        return;
    }

    private void setCurrentMainObj(IomObject iomObj) {
        this.errFact.setDataObj(iomObj);
        this.currentMainOid = iomObj != null ? iomObj.getobjectoid() : null;
    }

    private IomObject getDefaultCoord(IomObject iomObj) {
        String tag = iomObj.getobjecttag();
        Object modelele = this.tag2class.get(tag);
        if (modelele == null) {
            return null;
        }
        Viewable aclass1 = (Viewable)modelele;
        Iterator iter = aclass1.getAttributesAndRoles2();
        while (iter.hasNext()) {
            Type proxyType;
            AttributeDef attr;
            ViewableTransferElement obj = (ViewableTransferElement)iter.next();
            if (!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
            Type type = attr.getDomainResolvingAliases();
            String attrName = attr.getName();
            if (type instanceof CompositionType) {
                int structc = iomObj.getattrvaluecount(attrName);
                for (int structi = 0; structi < structc; ++structi) {
                    IomObject coord;
                    IomObject structEle = iomObj.getattrobj(attrName, structi);
                    if (structEle == null || (coord = this.getDefaultCoord(structEle)) == null) continue;
                    return coord;
                }
                continue;
            }
            if (type instanceof PolylineType) {
                IomObject coord;
                PolylineType polylineType = (PolylineType)type;
                IomObject polylineValue = iomObj.getattrobj(attrName, 0);
                if (polylineValue == null || (coord = this.getFirstCoordFromPolyline(polylineValue)) == null) continue;
                return coord;
            }
            if (type instanceof SurfaceOrAreaType) {
                if (this.doItfLineTables) {
                    if (type instanceof SurfaceType) {
                        SurfaceType polylineType = (SurfaceType)type;
                        continue;
                    }
                    AreaType areaType = (AreaType)type;
                    IomObject coord = iomObj.getattrobj(attrName, 0);
                    if (coord == null) continue;
                    return coord;
                }
                SurfaceOrAreaType surfaceOrAreaType = (SurfaceOrAreaType)type;
                IomObject surfaceValue = iomObj.getattrobj(attrName, 0);
                if (surfaceValue == null) continue;
                for (int surfacei = 0; surfacei < surfaceValue.getattrvaluecount("surface"); ++surfacei) {
                    IomObject surface = surfaceValue.getattrobj("surface", surfacei);
                    int boundaryc = surface.getattrvaluecount("boundary");
                    for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                        IomObject boundary = surface.getattrobj("boundary", boundaryi);
                        for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                            IomObject polyline = boundary.getattrobj("polyline", polylinei);
                            IomObject coord = this.getFirstCoordFromPolyline(polyline);
                            if (coord == null) continue;
                            return coord;
                        }
                    }
                }
                continue;
            }
            if (!(type instanceof CoordType)) continue;
            CoordType coordType = (CoordType)type;
            IomObject coord = iomObj.getattrobj(attrName, 0);
            if (coord == null) continue;
            return coord;
        }
        return null;
    }

    private IomObject getFirstCoordFromPolyline(IomObject polylineValue) {
        for (int sequencei = 0; sequencei < polylineValue.getattrvaluecount("sequence"); ++sequencei) {
            int segmenti = 0;
            IomObject sequence = polylineValue.getattrobj("sequence", sequencei);
            if (segmenti >= sequence.getattrvaluecount("segment")) continue;
            IomObject segment = sequence.getattrobj("segment", segmenti);
            return segment;
        }
        return null;
    }

    private String validateUnique(HashMap<UniquenessConstraint, HashMap<AttributeArray, String>> seenValues, String originObjOid, IomObject parentObject, IomObject currentObject, UniquenessConstraint constraint, OutParam<AttributeArray> valuesRet, RoleDef role) {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator constraintIter = constraint.getElements().iteratorAttribute();
        while (constraintIter.hasNext()) {
            Object next = constraintIter.next();
            ObjectPath objectPathObj = (ObjectPath)next;
            PathEl[] pathElements = objectPathObj.getPathElements();
            Value value = this.getValueFromObjectPath(parentObject, currentObject, pathElements, role);
            if (value.isUndefined()) {
                return null;
            }
            if (value.skipEvaluation()) {
                return null;
            }
            if (value.getValue() != null) {
                values.add(value.getValue());
                continue;
            }
            if (value.getOid() != null) {
                values.add(value.getOid());
                continue;
            }
            if (value.getComplexObjects() != null) {
                IomObject complexValue = value.getComplexObjects().iterator().next();
                if (complexValue.getobjectrefoid() != null) {
                    values.add(complexValue.getobjectrefoid());
                    continue;
                }
                values.add(complexValue);
                continue;
            }
            throw new IllegalStateException(this.rsrc.getString("validateUnique.unexpectedValueInUnique"));
        }
        valuesRet.value = new AttributeArray(values);
        HashMap<Object, Object> alreadySeenValues = null;
        if (seenValues.containsKey(constraint)) {
            alreadySeenValues = seenValues.get(constraint);
            String oidOfNonUniqueObj = (String)alreadySeenValues.get(valuesRet.value);
            if (oidOfNonUniqueObj != null) {
                return oidOfNonUniqueObj;
            }
            alreadySeenValues.put(valuesRet.value, originObjOid);
        } else {
            alreadySeenValues = new HashMap();
            alreadySeenValues.put(valuesRet.value, originObjOid);
            seenValues.put(constraint, alreadySeenValues);
        }
        return null;
    }

    private void validateAttrValue(Viewable eleClass, IomObject iomObj, AttributeDef attr, String attrPath) throws IoxException {
        String attrName = attr.getName();
        String attrQName = this.getScopedName(attr);
        String iliClassQName = this.getScopedName(eleClass);
        attrPath = attrPath == null ? attrName : attrPath + "/" + attrName;
        String validateMultiplicity = this.validationConfig.getConfigValue(attrQName, "multiplicity");
        if (validateMultiplicity == null) {
            validateMultiplicity = this.globalMultiplicity;
        }
        String validateType = null;
        Object validateTarget = null;
        String validateGeometryType = null;
        if (!this.enforceTypeValidation && (validateType = this.validationConfig.getConfigValue(attrQName, "type")) == null) {
            validateGeometryType = this.defaultGeometryTypeValidation;
        }
        Type type0 = attr.getDomain();
        Type type = attr.getDomainResolvingAll();
        if (type instanceof CompositionType) {
            int structc = iomObj.getattrvaluecount(attrName);
            if ("off".equals(validateMultiplicity)) {
                if (!this.configOffOufputReduction.contains("multiplicity:" + attrQName)) {
                    this.configOffOufputReduction.add("multiplicity:" + attrQName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.XNotValidatedValidationConfigurationMultiplicityOffInAttributeY"), attrQName, attrPath, iomObj.getobjecttag(), iomObj.getobjectoid()));
                }
            } else {
                Cardinality card = ((CompositionType)type).getCardinality();
                if ((long)structc < card.getMinimum() || (long)structc > card.getMaximum()) {
                    this.logMsg(validateMultiplicity, this.rsrc.getString("validateAttrValue.attributeXHasWrongNumberOfValues"), attrPath);
                }
            }
            for (int structi = 0; structi < structc; ++structi) {
                IomObject structEle = iomObj.getattrobj(attrName, structi);
                if ("off".equals(validateType)) {
                    if (this.configOffOufputReduction.contains("type:" + attrQName)) continue;
                    this.configOffOufputReduction.add("type:" + attrQName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.XNotValidatedValidationConfigurationTypeOffInAttributeY"), attrQName, attrPath, iomObj.getobjecttag(), iomObj.getobjectoid()));
                    continue;
                }
                if (structEle == null) {
                    this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXRequiresAStructureY"), attrPath, ((CompositionType)type).getComponentType().getScopedName(null));
                    continue;
                }
                String tag = structEle.getobjecttag();
                Object modelele = this.tag2class.get(tag);
                if (modelele == null) {
                    if (!this.unknownTypev.contains(tag)) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.unknownClassXInAttributeY"), tag, attrPath));
                    }
                } else {
                    Viewable structEleClass = (Viewable)modelele;
                    Table requiredClass = ((CompositionType)type).getComponentType();
                    if (!structEleClass.isExtending((Element)requiredClass)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXRequiresAStructureY"), attrPath, requiredClass.getScopedName(null));
                    }
                    if (structEleClass.isAbstract()) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXRequiresANonAbstractStructure"), attrPath);
                    }
                }
                this.validateObject(structEle, attrPath + "[" + structi + "]", null);
            }
        } else {
            String actualValue;
            String valueStr;
            if ("off".equals(validateMultiplicity)) {
                if (!this.configOffOufputReduction.contains("multiplicity:" + attrQName)) {
                    this.configOffOufputReduction.add("multiplicity:" + attrQName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.XNotValidatedValidationConfigurationMultiplicityOffInAttributeY"), attrQName, attrPath, iomObj.getobjecttag(), iomObj.getobjectoid()));
                }
            } else {
                Object topologyDone = this.pipelinePool.getIntermediateValue(attr, "topology");
                if (type0 == null) {
                    type0 = attr.getDomainResolvingAll();
                }
                if (topologyDone == null) {
                    IomObject refObj;
                    int structc = iomObj.getattrvaluecount(attrName);
                    if (structc == 1 && type instanceof ReferenceType && ((refObj = iomObj.getattrobj(attrName, 0)) == null || refObj.getobjectrefoid() == null)) {
                        structc = 0;
                    }
                    if (!(structc != 0 || !Validator.isAttributeMandatory(attr) || this.doItfLineTables && type instanceof SurfaceType)) {
                        this.logMsg(validateMultiplicity, this.rsrc.getString("validateAttrValue.attributeXRequiresAValue"), attrPath);
                    }
                } else {
                    int structc;
                    Boolean topologyValidationOk = (Boolean)this.pipelinePool.getIntermediateValue(attr, "topologyValidationOk");
                    if ((topologyValidationOk == null || topologyValidationOk.booleanValue()) && (structc = iomObj.getattrvaluecount(attrName)) == 0 && Validator.isAttributeMandatory(attr)) {
                        this.logMsg(validateMultiplicity, this.rsrc.getString("validateAttrValue.attributeXRequiresAValue"), attrPath);
                    }
                }
            }
            if ("off".equals(validateType)) {
                if (!this.configOffOufputReduction.contains("type:" + attrQName)) {
                    this.configOffOufputReduction.add("type:" + attrQName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.XNotValidatedValidationConfigurationTypeOffInAttributeY"), attrQName, attrPath, iomObj.getobjecttag(), iomObj.getobjectoid()));
                }
            } else if (attr.isDomainIli1Date()) {
                valueStr = iomObj.getattrvalue(attrName);
                if (valueStr != null) {
                    if (valueStr.length() == 8) {
                        try {
                            int year = Integer.parseInt(valueStr.substring(0, 4));
                            int month = Integer.parseInt(valueStr.substring(4, 6));
                            int day = Integer.parseInt(valueStr.substring(6, 8));
                            if (year < 1582 || year > 2999 || month < 1 || month > 12 || day < 1 || day > 31) {
                                this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotInRangeInAttributeY"), valueStr, attrPath);
                            }
                        }
                        catch (NumberFormatException numberformatexception) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAValidDateInAttributeY"), valueStr, attrPath);
                        }
                    } else {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAValidDateInAttributeY"), valueStr, attrPath);
                    }
                }
            } else if (attr.isDomainBoolean()) {
                valueStr = iomObj.getattrvalue(attrName);
                if (valueStr != null && !valueStr.equals("true") && !valueStr.equals("false")) {
                    this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotABooleanInAttributeY"), valueStr, attrPath);
                }
            } else if (attr.isDomainIliUuid()) {
                valueStr = iomObj.getattrvalue(attrName);
                if (valueStr != null && !this.isValidUuid(valueStr)) {
                    this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAValidUUIDInAttributeY"), valueStr, attrPath);
                }
            } else if (attr.isDomainIli2Date()) {
                valueStr = iomObj.getattrvalue(attrName);
                FormattedType subType = (FormattedType)type;
                if (valueStr != null) {
                    if (!valueStr.matches(subType.getRegExp())) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfDateValueXInAttributeY"), valueStr, attrPath);
                    } else if (!subType.isValueInRange(valueStr)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.dateValueXIsNotInRangeInAttributeY"), valueStr, attrPath);
                    }
                }
            } else if (attr.isDomainIli2Time()) {
                valueStr = iomObj.getattrvalue(attrName);
                FormattedType subType = (FormattedType)type;
                if (valueStr != null) {
                    if (!valueStr.matches(subType.getRegExp()) || valueStr.length() < 9 || valueStr.length() > 12) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfTimeValueXInAttributeY"), valueStr, attrPath);
                    } else if (!subType.isValueInRange(valueStr)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.timeValueXIsNotInRangeInAttributeY"), valueStr, attrPath);
                    }
                }
            } else if (attr.isDomainIli2DateTime()) {
                valueStr = iomObj.getattrvalue(attrName);
                FormattedType subType = (FormattedType)type;
                if (valueStr != null) {
                    if (!valueStr.matches(subType.getRegExp()) || valueStr.length() < 18 || valueStr.length() > 23) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfDatetimeValueXInAttributeY"), valueStr, attrPath);
                    } else if (!subType.isValueInRange(valueStr)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.datetimeValueXIsNotInRangeInAttributeY"), valueStr, attrPath);
                    }
                }
            } else if (Validator.isDomainName(attr)) {
                valueStr = iomObj.getattrvalue(attrName);
                if (valueStr != null) {
                    Pattern pattern;
                    Matcher matcher;
                    this.validateTextType(iomObj, attrPath, attrName, validateType, type, valueStr);
                    if (this.isAKeyword(valueStr)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsAKeywordInAttributeY"), valueStr, attrPath);
                    }
                    if ((matcher = (pattern = Pattern.compile("[a-zA-Z]{1}([a-zA-Z0-9\\_]{1,})")).matcher(valueStr)) == null || !matcher.matches()) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfInterlisNameValueXInAttributeY"), valueStr, attrPath);
                    }
                }
            } else if (Validator.isDomainUri(attr)) {
                valueStr = iomObj.getattrvalue(attrName);
                if (valueStr != null) {
                    this.validateTextType(iomObj, attrPath, attrName, validateType, type, valueStr);
                    Pattern pattern = Pattern.compile("((?<=\\()[A-Za-z][A-Za-z0-9\\+\\.\\-]*:([A-Za-z0-9\\.\\-_~:/\\?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=]|%[A-Fa-f0-9]{2})+(?=\\)))|([A-Za-z][A-Za-z0-9\\+\\.\\-]*:([A-Za-z0-9\\.\\-_~:/\\?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=]|%[A-Fa-f0-9]{2})+)");
                    Matcher matcher = pattern.matcher(valueStr);
                    if (matcher == null || !matcher.matches()) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfInterlisUriValueXInAttributeY"), valueStr, attrPath);
                    }
                }
            } else if (type instanceof PolylineType) {
                PolylineType polylineType = (PolylineType)type;
                IomObject polylineValue = iomObj.getattrobj(attrName, 0);
                if (polylineValue != null) {
                    boolean isValid = this.validatePolyline(validateGeometryType, (LineType)polylineType, polylineValue, attrName);
                    if (isValid) {
                        this.validatePolylineTopology(attrPath, validateGeometryType, polylineType, polylineValue);
                    }
                } else {
                    String attrValue = iomObj.getattrvalue(attrName);
                    if (attrValue != null) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotAPolylineInAttributeY"), attrValue, attrPath);
                    }
                }
            } else if (type instanceof SurfaceOrAreaType) {
                if (this.doItfLineTables) {
                    if (type instanceof SurfaceType) {
                        // empty if block
                    }
                } else {
                    SurfaceOrAreaType surfaceOrAreaType = (SurfaceOrAreaType)type;
                    IomObject surfaceValue = iomObj.getattrobj(attrName, 0);
                    if (surfaceValue != null) {
                        boolean isValid = this.validatePolygon(validateGeometryType, surfaceOrAreaType, surfaceValue, iomObj, attrName);
                        if (isValid) {
                            Object attrValidator = this.pipelinePool.getIntermediateValue(attr, "topology");
                            if (attrValidator == null) {
                                attrValidator = this;
                                this.pipelinePool.setIntermediateValue(attr, "topology", this);
                            }
                            if (attrValidator == this) {
                                if (surfaceOrAreaType instanceof SurfaceType) {
                                    boolean modelele = this.validateSurfaceTopology(validateGeometryType, attr, (SurfaceOrAreaType)((SurfaceType)surfaceOrAreaType), this.currentMainOid, surfaceValue);
                                } else {
                                    boolean surfaceTopologyValid = this.validateSurfaceTopology(validateGeometryType, attr, (SurfaceOrAreaType)((AreaType)surfaceOrAreaType), this.currentMainOid, surfaceValue);
                                    if (!"off".equals(this.areaOverlapValidation)) {
                                        if (surfaceTopologyValid) {
                                            ItfAreaPolygon2Linetable allLines = this.areaAttrs.get(attr);
                                            if (allLines == null) {
                                                allLines = new ItfAreaPolygon2Linetable(iliClassQName, this.objPoolManager);
                                                this.areaAttrs.put(attr, allLines);
                                            }
                                            this.validateAreaTopology(validateGeometryType, allLines, (AreaType)surfaceOrAreaType, this.currentMainOid, null, surfaceValue);
                                        } else {
                                            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.areaTopologyNoValidatedValidationOfSurfaceTopologyFailedInAttributeY"), attrPath));
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        String attrValue = iomObj.getattrvalue(attrName);
                        if (attrValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotAPolygonInAttributeY"), attrValue, attrPath);
                        }
                    }
                }
            } else if (type instanceof CoordType) {
                IomObject coord = iomObj.getattrobj(attrName, 0);
                if (coord != null) {
                    this.validateCoordType(validateGeometryType, (CoordType)type, coord, attrName);
                } else {
                    String attrValue = iomObj.getattrvalue(attrName);
                    if (attrValue != null) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotCoordInAttributeY"), attrValue, attrPath);
                    }
                }
            } else if (type instanceof NumericType) {
                valueStr = iomObj.getattrvalue(attrName);
                if (valueStr != null) {
                    String newValueStr = this.validateNumericType(validateType, (NumericType)type, valueStr, attrName);
                    if (newValueStr != null) {
                        iomObj.setattrvalue(attrName, newValueStr);
                    }
                } else {
                    IomObject structValue = iomObj.getattrobj(attrName, 0);
                    if (structValue != null) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXHasAnUnexpectedTypeY"), attrPath, structValue.getobjecttag());
                    }
                }
            } else if (type instanceof EnumerationType) {
                EnumerationType enumType = (EnumerationType)type;
                String value = iomObj.getattrvalue(attrName);
                if (value != null) {
                    if (!((EnumerationType)type).getValues().contains(value)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAMemberOfTheEnumerationInAttributeY"), value, attrPath);
                    }
                } else {
                    IomObject structValue = iomObj.getattrobj(attrName, 0);
                    if (structValue != null) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXHasAnUnexpectedTypeY"), attrPath, structValue.getobjecttag());
                    }
                }
            } else if (type instanceof EnumTreeValueType) {
                actualValue = iomObj.getattrvalue(attrName);
                if (this.isValidEnumTreeValue(actualValue, attrPath, type)) {
                    this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAMemberOfTheEnumerationInAttributeY"), actualValue, attrPath);
                }
            } else if (!(type instanceof ReferenceType)) {
                Matcher matcher;
                String value;
                if (type instanceof TextType) {
                    value = iomObj.getattrvalue(attrName);
                    this.validateTextType(iomObj, attrPath, attrName, validateType, type, value);
                } else if (type instanceof TextOIDType) {
                    value = iomObj.getattrvalue(attrName);
                    if (value != null && Validator.isDomainStandardOid(attr)) {
                        if (!this.isValidStandartOId(value)) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.valueXIsNotAValidOidInAttributeY"), value, attrPath));
                        }
                    } else if (value != null && Validator.isDomainTextOid(attr) && !this.isValidTextOId(value)) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.valueXIsNotAValidOidInAttributeY"), value, attrPath));
                    }
                } else if (type instanceof FormattedType) {
                    String regExp = ((FormattedType)type).getRegExp();
                    String actualValue2 = iomObj.getattrvalue(attrName);
                    if (actualValue2 != null) {
                        if (!actualValue2.matches(regExp)) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.attributeXHasAInvalidValueY"), attrPath, actualValue2));
                        } else {
                            boolean hasAValidValue = ((FormattedType)type).isValueInRange(actualValue2);
                            if (!hasAValidValue) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.valueXIsAOutOfRangeInAttributeY"), actualValue2, attrPath));
                            }
                        }
                    }
                } else if (type instanceof BlackboxType && ((BlackboxType)type).getKind() == 2 && (actualValue = iomObj.getattrvalue(attrName)) != null && !(matcher = this.patternForBase64Validation.matcher(actualValue)).matches()) {
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.attributeXHasAInvalidValueY"), attrPath, Validator.shortcutValue(actualValue)));
                }
            }
        }
    }

    private static String shortcutValue(String value) {
        int MAX_LEN = 20;
        if (value == null || value.length() <= MAX_LEN) {
            return value;
        }
        return value.substring(0, MAX_LEN) + "...";
    }

    private boolean isValidEnumTreeValue(String actualValue, String attrPath, Type type) {
        EnumTreeValueType enumTreeValueType = (EnumTreeValueType)type;
        if (actualValue != null) {
            HashMap<String, String> trueValueFormat = (HashMap<String, String>)enumTreeValueType.getTransientMetaValue(ENUM_TREE_VALUES);
            if (trueValueFormat == null) {
                trueValueFormat = new HashMap<String, String>();
                Domain enumType = enumTreeValueType.getEnumType();
                EnumerationType enumerationType = (EnumerationType)enumType.getType();
                List values = enumerationType.getValues();
                for (String value : values) {
                    String[] tmpValues = value.split("\\.");
                    String tmpValue = "";
                    for (int i = 0; i < tmpValues.length; ++i) {
                        if (i == 0) {
                            trueValueFormat.put(tmpValues[i], tmpValues[i]);
                            tmpValue = tmpValues[i];
                            continue;
                        }
                        tmpValue = tmpValue + "." + tmpValues[i];
                        trueValueFormat.put(tmpValue, tmpValue);
                    }
                }
                enumTreeValueType.setTransientMetaValue(ENUM_TREE_VALUES, trueValueFormat);
            }
            if (trueValueFormat != null && !trueValueFormat.containsKey(actualValue)) {
                return true;
            }
        }
        return false;
    }

    private void validateTextType(IomObject iomObj, String attrPath, String attrName, String validateType, Type type, String value) {
        if (value != null) {
            int maxLength = ((TextType)type).getMaxLength();
            TextType textType = (TextType)type;
            if (maxLength != -1 && value.length() > maxLength) {
                this.logMsg(validateType, this.rsrc.getString("validateTextType.attributeXIsLengthRestrictedToY"), attrPath, Integer.toString(maxLength));
            }
            if (((TextType)type).isNormalized() && (value.indexOf(10) >= 0 || value.indexOf(13) >= 0 || value.indexOf(9) >= 0)) {
                this.logMsg(validateType, this.rsrc.getString("validateTextType.attributeXMustNotContainControlCharacters"), attrPath);
            }
        } else {
            IomObject structValue = iomObj.getattrobj(attrName, 0);
            if (structValue != null) {
                this.logMsg(validateType, this.rsrc.getString("validateTextType.attributeXHasAnUnexpectedTypeY"), attrPath, structValue.getobjecttag());
            }
        }
    }

    private static boolean isAttributeMandatory(AttributeDef attr) {
        Type attrType = attr.getDomain();
        if (attrType == null) {
            if (attr instanceof LocalAttribute) {
                Evaluable[] ev = ((LocalAttribute)attr).getBasePaths();
                attrType = ((ObjectPath)ev[0]).getType();
            } else {
                throw new IllegalArgumentException("unexpected attribute type " + attr.getScopedName());
            }
        }
        return attrType.isMandatoryConsideringAliases();
    }

    private void validateAreaTopology(String validateType, ItfAreaPolygon2Linetable allLines, AreaType type, String mainObjTid, String internalTid, IomObject iomPolygon) throws IoxException {
        allLines.addPolygon(mainObjTid, internalTid, iomPolygon, validateType, this.errFact);
    }

    private boolean validateSurfaceTopology(String validateType, AttributeDef attr, SurfaceOrAreaType type, String mainObjTid, IomObject iomValue) {
        boolean surfaceTopologyValid = true;
        try {
            surfaceTopologyValid = ItfSurfaceLinetable2Polygon.validatePolygon(mainObjTid, attr, iomValue, this.errFact, validateType);
        }
        catch (IoxException e) {
            surfaceTopologyValid = false;
            this.errs.addEvent(this.errFact.logErrorMsg(e, this.rsrc.getString("validateSurfaceTopology.failedToValidatePolygon"), new String[0]));
        }
        return surfaceTopologyValid;
    }

    private void validatePolylineTopology(String attrPath, String validateType, PolylineType type, IomObject iomValue) {
        CompoundCurve seg = null;
        try {
            OutParam foundErrs = new OutParam();
            seg = Iox2jtsext.polyline2JTS(iomValue, false, 0.0, (OutParam<Boolean>)foundErrs, this.errFact, 0.0, validateType, "warning");
            if (seg == null || ((Boolean)foundErrs.value).booleanValue()) {
                return;
            }
        }
        catch (IoxException e) {
            throw new IllegalStateException(e);
        }
        PrecisionDecimal overlapDef = type.getMaxOverlap();
        if (overlapDef != null) {
            NumericalType[] dimensions;
            double size;
            double newVertexOffset = 0.0;
            double maxOverlaps = overlapDef.doubleValue();
            if (maxOverlaps > 0.0 && (size = (double)((NumericType)(dimensions = ((CoordType)type.getControlPointDomain().getType()).getDimensions())[0]).getMinimum().getAccuracy()) > 0.0) {
                newVertexOffset = 2.0 * java.lang.Math.pow(10.0, -size);
            }
            ItfSurfaceLinetable2Polygon.removeValidSelfIntersections(seg, maxOverlaps, newVertexOffset);
            ArrayList<CompoundCurve> segv = new ArrayList<CompoundCurve>();
            segv.add(seg);
            CompoundCurveNoder validator = new CompoundCurveNoder(segv, false);
            if (!validator.isValid()) {
                boolean hasIntersections = false;
                for (Intersection is : validator.getIntersections()) {
                    Coordinate[] pt = is.getPt();
                    this.logMsg(validateType, "Attribute {0} has an invalid self-intersection at {1}", attrPath, "" + this.coordToString(pt[0]) + (pt.length == 2 ? ", coord2 " + this.coordToString(pt[1]) : ""));
                }
            }
        }
    }

    private String coordToString(Coordinate coord) {
        return "(" + coord.x + ", " + coord.y + ")";
    }

    private boolean validatePolygon(String validateType, SurfaceOrAreaType surfaceOrAreaType, IomObject surfaceValue, IomObject currentIomObj, String attrName) {
        if (surfaceValue.getobjecttag().equals("MULTISURFACE")) {
            boolean clipped = surfaceValue.getobjectconsistency() == 1;
            for (int surfacei = 0; surfacei < surfaceValue.getattrvaluecount("surface"); ++surfacei) {
                if (!clipped && surfacei > 0) {
                    this.logMsg(validateType, this.rsrc.getString("validatePolygon.invalidNumberOfSurfaceInCompleteBasket"), new String[0]);
                    return false;
                }
                IomObject surface = surfaceValue.getattrobj("surface", surfacei);
                int boundaryc = surface.getattrvaluecount("boundary");
                if (boundaryc == 0) {
                    String objectIdentification = currentIomObj.getobjectoid();
                    if (objectIdentification == null) {
                        objectIdentification = currentIomObj.getobjecttag();
                    }
                    this.logMsg(validateType, this.rsrc.getString("validatePolygon.missingOuterboundaryInXOfObjectY"), attrName, objectIdentification);
                    return false;
                }
                for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                    IomObject boundary = surface.getattrobj("boundary", boundaryi);
                    if (boundaryi == 0) {
                        // empty if block
                    }
                    for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                        IomObject polyline = boundary.getattrobj("polyline", polylinei);
                        this.validatePolyline(validateType, (LineType)surfaceOrAreaType, polyline, attrName);
                    }
                }
            }
        } else {
            this.logMsg(validateType, "unexpected Type " + surfaceValue.getobjecttag() + "; MULTISURFACE expected", new String[0]);
            return false;
        }
        return true;
    }

    private boolean validatePolyline(String validateType, LineType polylineType, IomObject polylineValue, String attrName) {
        boolean foundErrs = false;
        if (polylineValue.getobjecttag().equals("POLYLINE")) {
            boolean clipped = polylineValue.getobjectconsistency() == 1;
            for (int sequencei = 0; sequencei < polylineValue.getattrvaluecount("sequence"); ++sequencei) {
                if (!clipped && sequencei > 0) {
                    this.logMsg(validateType, this.rsrc.getString("validatePolyline.invalidNumberOfSequenceInCompleteBasket"), new String[0]);
                    if (!foundErrs) {
                        // empty if block
                    }
                    foundErrs = true;
                }
                IomObject sequence = polylineValue.getattrobj("sequence", sequencei);
                LineForm[] lineforms = polylineType.getLineForms();
                HashSet<String> lineformNames = new HashSet<String>();
                for (LineForm lf : lineforms) {
                    lineformNames.add(lf.getName());
                }
                if (sequence.getobjecttag().equals("SEGMENTS")) {
                    for (int segmenti = 0; segmenti < sequence.getattrvaluecount("segment"); ++segmenti) {
                        IomObject segment = sequence.getattrobj("segment", segmenti);
                        if (segment.getobjecttag().equals("COORD")) {
                            if (lineformNames.contains("STRAIGHTS") || segmenti == 0) {
                                this.validateCoordType(validateType, (CoordType)polylineType.getControlPointDomain().getType(), segment, attrName);
                                continue;
                            }
                            this.logMsg(validateType, "unexpected COORD", new String[0]);
                            if (!foundErrs) {
                                // empty if block
                            }
                            foundErrs = true;
                            continue;
                        }
                        if (segment.getobjecttag().equals("ARC")) {
                            if (lineformNames.contains("ARCS") && segmenti > 0) {
                                this.validateARCSType(validateType, (CoordType)polylineType.getControlPointDomain().getType(), segment, attrName);
                                continue;
                            }
                            this.logMsg(validateType, "unexpected ARC", new String[0]);
                            if (!foundErrs) {
                                // empty if block
                            }
                            foundErrs = true;
                            continue;
                        }
                        this.logMsg(validateType, "unexpected Type " + segment.getobjecttag(), new String[0]);
                        if (!foundErrs) {
                            // empty if block
                        }
                        foundErrs = true;
                    }
                    continue;
                }
                this.logMsg(validateType, "unexpected Type " + sequence.getobjecttag(), new String[0]);
                if (!foundErrs) {
                    // empty if block
                }
                foundErrs = true;
            }
        } else {
            this.logMsg(validateType, "unexpected Type " + polylineValue.getobjecttag() + "; POLYLINE expected", new String[0]);
            if (!foundErrs) {
                // empty if block
            }
            foundErrs = true;
        }
        return !foundErrs;
    }

    private void validateCoordType(String validateType, CoordType coordType, IomObject coordValue, String attrName) {
        if (coordType.getDimensions().length >= 1) {
            if (coordValue.getattrvalue("C1") != null) {
                coordValue.setattrvalue("C1", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[0], coordValue.getattrvalue("C1"), attrName));
            } else if (coordValue.getattrvalue("A1") != null) {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.notATypeOfCoord"), new String[0]);
            } else {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.wrongCoordStructureC1Expected"), new String[0]);
            }
        }
        if (coordType.getDimensions().length == 2 && coordValue.getattrvalue("C3") != null) {
            this.logMsg(validateType, this.rsrc.getString("validateCoordType.wrongCoordStructureC3NotExpected"), new String[0]);
        }
        if (coordType.getDimensions().length >= 2) {
            if (coordValue.getattrvalue("C2") != null) {
                coordValue.setattrvalue("C2", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[1], coordValue.getattrvalue("C2"), attrName));
            } else if (coordValue.getattrvalue("A2") != null) {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.notATypeOfCoord"), new String[0]);
            } else {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.wrongCoordStructureC2Expected"), new String[0]);
            }
        }
        if (coordType.getDimensions().length == 3) {
            if (coordValue.getattrvalue("C3") != null) {
                coordValue.setattrvalue("C3", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[2], coordValue.getattrvalue("C3"), attrName));
            } else {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.wrongCoordStructureC3Expected"), new String[0]);
            }
        }
        int propc = coordValue.getattrcount();
        for (int propi = 0; propi < propc; ++propi) {
            String propName = coordValue.getattrname(propi);
            if (propName.startsWith("_") || propName.equals("C1") || propName.equals("C2") || propName.equals("C3")) continue;
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateCoordType.wrongCoordStructureUnknownPropertyX"), propName));
        }
    }

    private void validateARCSType(String validateType, CoordType coordType, IomObject coordValue, String attrName) {
        int dimLength = coordType.getDimensions().length;
        String c1 = coordValue.getattrvalue("C1");
        String c2 = coordValue.getattrvalue("C2");
        String c3 = coordValue.getattrvalue("C3");
        String a1 = coordValue.getattrvalue("A1");
        String a2 = coordValue.getattrvalue("A2");
        boolean wrongArcStructure = false;
        int c1Count = coordValue.getattrvaluecount("C1");
        if (dimLength >= 2 && dimLength <= 3) {
            if (a1 != null && a2 != null && c1 != null && c2 != null) {
                coordValue.setattrvalue("A1", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[0], a1, attrName));
                coordValue.setattrvalue("A2", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[1], a2, attrName));
                coordValue.setattrvalue("C1", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[0], c1, attrName));
                coordValue.setattrvalue("C2", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[1], c2, attrName));
                if (dimLength == 2) {
                    if (c3 != null) {
                        this.logMsg(validateType, this.rsrc.getString("validateARCSType.wrongArcStructureC3NotExpected"), new String[0]);
                    }
                } else if (dimLength == 3) {
                    if (c3 != null) {
                        coordValue.setattrvalue("C3", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[2], c3, attrName));
                    } else {
                        this.logMsg(validateType, this.rsrc.getString("validateARCSType.wrongArcStructureC3Expected"), new String[0]);
                    }
                }
            } else {
                wrongArcStructure = true;
            }
        } else {
            wrongArcStructure = true;
        }
        if (wrongArcStructure) {
            this.logMsg(validateType, this.rsrc.getString("validateARCSType.wrongArcStructure"), new String[0]);
        }
        int propc = coordValue.getattrcount();
        for (int propi = 0; propi < propc; ++propi) {
            String propName = coordValue.getattrname(propi);
            if (propName.startsWith("_") || !propName.equals("A1") || !propName.equals("A2") || !propName.equals("C1") || !propName.equals("C2") || !propName.equals("C3")) continue;
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateARCSType.wrongArcStructureUnknownPropertyX"), propName));
        }
    }

    private String validateNumericType(String validateType, NumericType type, String valueStr, String attrName) {
        PrecisionDecimal value = null;
        try {
            value = new PrecisionDecimal(valueStr);
        }
        catch (NumberFormatException e) {
            this.logMsg(validateType, this.rsrc.getString("validateNumericType.valueXIsNotANumber"), valueStr);
        }
        BigDecimal rounded = null;
        if (value != null) {
            PrecisionDecimal minimum = type.getMinimum();
            PrecisionDecimal maximum = type.getMaximum();
            BigDecimal min_general = new BigDecimal(minimum.toString());
            BigDecimal max_general = new BigDecimal(maximum.toString());
            BigDecimal valueBigDec = new BigDecimal(value.toString());
            int precision = minimum.getAccuracy();
            rounded = this.disableRounding ? valueBigDec : Validator.roundNumeric(precision, valueBigDec);
            if (rounded != null && (rounded.compareTo(min_general) == -1 || rounded.compareTo(max_general) == 1)) {
                this.logMsg(validateType, this.rsrc.getString("validateNumericType.valueXIsOutOfRangeInAttributeY"), rounded.toString(), attrName);
            }
        }
        if (rounded == null) {
            return null;
        }
        return rounded.toPlainString();
    }

    private boolean isAKeyword(String valueStr) {
        HashSet<String> keyWords = Ili23KeyWords.getAllKeyWords();
        return keyWords.contains(valueStr);
    }

    public static BigDecimal roundNumeric(int precision, String valueStr) {
        if (valueStr == null) {
            return null;
        }
        return Validator.roundNumeric(precision, new BigDecimal(valueStr));
    }

    public static BigDecimal roundNumeric(int precision, BigDecimal value) {
        if (value == null) {
            return null;
        }
        boolean isNegative = value.signum() == -1;
        BigDecimal rounded = null;
        if (value != null) {
            rounded = isNegative ? value.setScale(precision, 5) : value.setScale(precision, 4);
        }
        return rounded;
    }

    public boolean isValidUuid(String valueStr) {
        return valueStr.length() == 36 && valueStr.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}?");
    }

    private static boolean isDomainName(AttributeDef attr) {
        TransferDescription td = (TransferDescription)attr.getContainer(TransferDescription.class);
        Type type = attr.getDomain();
        while (type instanceof TypeAlias) {
            if (((TypeAlias)type).getAliasing() == td.INTERLIS.NAME) {
                return true;
            }
            type = ((TypeAlias)type).getAliasing().getType();
        }
        return false;
    }

    private static boolean isDomainUri(AttributeDef attr) {
        TransferDescription td = (TransferDescription)attr.getContainer(TransferDescription.class);
        Type type = attr.getDomain();
        while (type instanceof TypeAlias) {
            if (((TypeAlias)type).getAliasing() == td.INTERLIS.URI) {
                return true;
            }
            type = ((TypeAlias)type).getAliasing().getType();
        }
        return false;
    }

    private static boolean isDomainStandardOid(AttributeDef attr) {
        TransferDescription td = (TransferDescription)attr.getContainer(TransferDescription.class);
        Type type = attr.getDomain();
        while (type instanceof TypeAlias) {
            if (((TypeAlias)type).getAliasing() == td.INTERLIS.STANDARDOID) {
                return true;
            }
            type = ((TypeAlias)type).getAliasing().getType();
        }
        return false;
    }

    private static boolean isDomainTextOid(AttributeDef attr) {
        TransferDescription td = (TransferDescription)attr.getContainer(TransferDescription.class);
        Type type = attr.getDomain();
        return type instanceof TextOIDType;
    }

    private void logMsg(String validateKind, String msg, String ... args) {
        if (!"off".equals(validateKind)) {
            if ("warning".equals(validateKind)) {
                this.errs.addEvent(this.errFact.logWarningMsg(msg, args));
            } else {
                this.errs.addEvent(this.errFact.logErrorMsg(msg, args));
            }
        }
    }

    private void validateItfLineTableObject(IomObject iomObj, AttributeDef modelele) {
    }

    public boolean isAutoSecondPass() {
        return this.autoSecondPass;
    }

    public void setAutoSecondPass(boolean autoSecondPass) {
        this.autoSecondPass = autoSecondPass;
    }

    public static void initItfValidation(Settings settings) {
        settings.setValue(CONFIG_DO_ITF_OIDPERTABLE, CONFIG_DO_ITF_OIDPERTABLE_DO);
    }
}

