/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize;

import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize.EdgeRing;
import ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Node;

class PolygonizeDirectedEdge
extends DirectedEdge {
    private EdgeRing edgeRing = null;
    private PolygonizeDirectedEdge next = null;
    private long label = -1L;

    public PolygonizeDirectedEdge(Node from, Node to, Coordinate directionPt, boolean edgeDirection) {
        super(from, to, directionPt, edgeDirection);
    }

    public double getAngle() {
        double ret = super.getAngle();
        if (Double.isNaN(ret)) {
            throw new IllegalStateException("angle is NaN");
        }
        return ret;
    }

    protected void adjustDirectionPt(double dist) {
        Coordinate directionPt = null;
        PolygonizeEdge edge = (PolygonizeEdge)this.getEdge();
        CompoundCurve line = (CompoundCurve)edge.getLine();
        directionPt = CompoundCurve.getDirectionPt(line, this.getEdgeDirection(), dist);
        this.p1 = new Coordinate(directionPt);
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        this.quadrant = Quadrant.quadrant((double)dx, (double)dy);
        this.angle = Math.atan2(dy, dx);
    }

    protected void adjustDirectionPt() {
        Coordinate directionPt = null;
        PolygonizeEdge edge = (PolygonizeEdge)this.getEdge();
        CompoundCurve line = (CompoundCurve)edge.getLine();
        directionPt = CompoundCurve.getDirectionPt(line, this.getEdgeDirection(), 0.0);
        this.p1 = new Coordinate(directionPt);
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        this.quadrant = Quadrant.quadrant((double)dx, (double)dy);
        this.angle = Math.atan2(dy, dx);
    }

    public boolean isArc() {
        PolygonizeEdge edge = (PolygonizeEdge)this.getEdge();
        CompoundCurve line = (CompoundCurve)edge.getLine();
        return CompoundCurve.isArc(line, this.getEdgeDirection());
    }

    public long getLabel() {
        return this.label;
    }

    public void setLabel(long label) {
        this.label = label;
    }

    public PolygonizeDirectedEdge getNext() {
        return this.next;
    }

    public void setNext(PolygonizeDirectedEdge next) {
        this.next = next;
    }

    public boolean isInRing() {
        return this.edgeRing != null;
    }

    public void setRing(EdgeRing edgeRing) {
        this.edgeRing = edgeRing;
    }
}

