/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.jts.Iox2jtsext;
import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LineSet {
    private boolean isSurface = true;
    private String helperTableGeomAttrName = null;
    private Table linattrTab = null;

    public LineSet(boolean isSurface, Table lineattrTab, String geomAttr) {
        this.isSurface = isSurface;
        this.helperTableGeomAttrName = geomAttr;
        this.linattrTab = lineattrTab;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<CompoundCurve> buildBoundaries(Map<String, IomObject> lines, JtsextGeometryFactory jtsFact) throws IoxException {
        ArrayList boundaries = new ArrayList();
        ArrayList<String> boundaryTids = new ArrayList<String>();
        ArrayList<CurveSegment> currentBoundary = null;
        String currentBoundaryTid = null;
        for (String line_tid : lines.keySet()) {
            void var12_15;
            boolean clipped;
            IomObject polyline = lines.get(line_tid).getattrobj(this.helperTableGeomAttrName, 0);
            if (polyline == null) {
                throw new IoxException("undefined polyline");
            }
            Coordinate currentSegmentStartpoint = null;
            IomObject sequence = polyline.getattrobj("sequence", 0);
            IomObject iomObject = sequence.getattrobj("segment", 0);
            currentSegmentStartpoint = Iox2jtsext.coord2JTS(iomObject);
            if (currentBoundary != null && currentBoundary.size() > 0) {
                boundaries.add(currentBoundary);
                boundaryTids.add(currentBoundaryTid);
            }
            currentBoundaryTid = line_tid;
            currentBoundary = new ArrayList<CurveSegment>();
            if (this.linattrTab != null) {
                // empty if block
            }
            boolean bl = clipped = polyline.getobjectconsistency() == 1;
            if (clipped) {
                throw new IoxException("clipped polyline not supported");
            }
            boolean bl2 = false;
            while (var12_15 < polyline.getattrvaluecount("sequence")) {
                if (!clipped && var12_15 > 0) {
                    throw new IoxException("unclipped polyline with multi 'sequence' elements");
                }
                Coordinate lastSegmentEndpoint = null;
                IomObject sequence2 = polyline.getattrobj("sequence", (int)var12_15);
                for (int segmenti = 0; segmenti < sequence2.getattrvaluecount("segment"); ++segmenti) {
                    IomObject segment2 = sequence2.getattrobj("segment", segmenti);
                    CurveSegment curve = null;
                    if (segment2.getobjecttag().equals("COORD")) {
                        if (lastSegmentEndpoint == null) {
                            curve = null;
                            lastSegmentEndpoint = Iox2jtsext.coord2JTS(segment2);
                        } else {
                            Coordinate newSegEndPt = Iox2jtsext.coord2JTS(segment2);
                            curve = new StraightSegment(lastSegmentEndpoint, newSegEndPt);
                        }
                    } else if (segment2.getobjecttag().equals("ARC")) {
                        Coordinate newSegEndPt;
                        Coordinate newSegMidPt = Iox2jtsext.getArcMidPt(segment2);
                        curve = new ArcSegment(lastSegmentEndpoint, newSegMidPt, newSegEndPt = Iox2jtsext.getArcEndPt(segment2));
                        if (((ArcSegment)curve).isStraight()) {
                            EhiLogger.logAdaption((String)("arc converted to straight at tid " + currentBoundaryTid + ", " + ((ArcSegment)curve).getMidPoint()));
                            curve = new StraightSegment(curve.getStartPoint(), curve.getEndPoint());
                        }
                    } else {
                        throw new IoxException("custom line form not supported");
                    }
                    if (curve == null) continue;
                    int endPointIdx = this.findEndpointOnBoundary(currentBoundary, curve);
                    if (endPointIdx == 0) {
                        currentBoundary.add(curve);
                        boundaries.add(currentBoundary);
                        boundaryTids.add(currentBoundaryTid);
                        currentBoundary = new ArrayList();
                    } else if (endPointIdx > 0) {
                        currentBoundary.add(curve);
                        List<CurveSegment> sub = currentBoundary.subList(endPointIdx, currentBoundary.size());
                        ArrayList<CurveSegment> boundary = new ArrayList<CurveSegment>();
                        boundary.addAll(sub);
                        boundaries.add(boundary);
                        boundaryTids.add(currentBoundaryTid);
                        sub.clear();
                        boundaries.add(currentBoundary);
                        boundaryTids.add(currentBoundaryTid);
                        currentBoundary = new ArrayList();
                    } else {
                        currentBoundary.add(curve);
                    }
                    lastSegmentEndpoint = curve.getEndPoint();
                }
                if (clipped) {
                    // empty if block
                }
                ++var12_15;
            }
        }
        if (currentBoundary != null && currentBoundary.size() > 0) {
            boundaries.add(currentBoundary);
            boundaryTids.add(currentBoundaryTid);
        }
        HashMap<String, Integer> tidCount = new HashMap<String, Integer>();
        HashMap<String, Integer> tidIdxs = new HashMap<String, Integer>();
        for (String tid : boundaryTids) {
            Integer count = (Integer)tidCount.get(tid);
            if (count == null) {
                tidCount.put(tid, 1);
                tidIdxs.put(tid, 1);
                continue;
            }
            count = count + 1;
            tidCount.put(tid, count);
        }
        ArrayList<CompoundCurve> segv = new ArrayList<CompoundCurve>();
        Iterator tids = boundaryTids.iterator();
        for (ArrayList arrayList : boundaries) {
            String tid = (String)tids.next();
            int tidIdx = (Integer)tidIdxs.get(tid);
            tidIdxs.put(tid, tidIdx + 1);
            if ((Integer)tidCount.get(tid) > 1) {
                tid = tid + ":" + tidIdx;
            }
            CompoundCurve boundary = null;
            try {
                boundary = jtsFact.createCompoundCurve(arrayList);
            }
            catch (RuntimeException ex) {
                throw new IoxInvalidDataException("failed to create line " + tid, (Throwable)ex);
            }
            boundary.setUserData(tid);
            boundary.setSegmentsUserData(tid);
            segv.add(boundary);
        }
        return segv;
    }

    private int findEndpointOnBoundary(ArrayList<CurveSegment> currentBoundary, CurveSegment curve) throws IoxException {
        for (int i = 0; i < currentBoundary.size(); ++i) {
            if (!curve.getEndPoint().equals2D(currentBoundary.get(i).getStartPoint())) continue;
            return i;
        }
        return -1;
    }
}

