/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractAttributeRef;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;

public class ObjectPath
extends Evaluable {
    private Viewable root;
    private PathEl[] path;

    public ObjectPath(Viewable start, PathEl[] explicit) {
        this.root = start;
        this.path = explicit;
    }

    @Override
    public boolean isLogical() {
        return this.isAttributePath() && this.getType().isBoolean();
    }

    public Viewable getRoot() {
        return this.root;
    }

    public Viewable getViewable() {
        return this.path[this.path.length - 1].getViewable();
    }

    @Override
    public Type getType() {
        PathEl last = this.getLastPathEl();
        if (last instanceof AbstractAttributeRef) {
            return ((AbstractAttributeRef)last).getDomain();
        }
        return new ObjectType(last.getViewable());
    }

    public boolean isAttributePath() {
        PathEl last = this.getLastPathEl();
        return last instanceof AbstractAttributeRef;
    }

    public String toString() {
        if (this.path == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        String sep = "";
        for (int i = 0; i < this.path.length; ++i) {
            str.append(sep);
            sep = "->";
            str.append(this.path[i].getName());
        }
        return str.toString();
    }

    public PathEl[] getPathElements() {
        return this.path;
    }

    public PathEl getLastPathEl() {
        return this.path[this.path.length - 1];
    }

    @Override
    public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
        Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
        if (ret != null) {
            return ret;
        }
        ObjectPath other = (ObjectPath)otherEv;
        if (!Element.equalElementRef(this.getRoot(), other.getRoot())) {
            return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_objectPathMismatch"));
        }
        if (this.path.length != other.path.length) {
            return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_objectPathMismatch"));
        }
        for (int pathi = 0; pathi < this.path.length; ++pathi) {
            if (this.path[pathi].getClass() != other.path[pathi].getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_objectPathMismatch"));
            }
            ret = this.path[pathi].checkTranslation(other.path[pathi], sourceLine);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

