/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.ExtendedView;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractPatternDef<E extends Element>
extends ExtendableContainer<E> {
    protected List<E> contents = new ArrayList();

    public void addBefore(E o, Object next) {
        if (((ElementDelegate)this.elements).check(o)) {
            try {
                ((Element)o).setBeanContext(this);
            }
            catch (PropertyVetoException pve) {
                throw new IllegalArgumentException(pve.getLocalizedMessage());
            }
            int idx = this.contents.indexOf(next);
            if (idx > -1) {
                this.contents.add(idx, o);
            } else {
                this.contents.add(o);
            }
        }
    }

    public static void checkTopicDepOfAttr(AbstractPatternDef<?> thisTopic, AttributeDef attr, String attrPath) {
        Type type = attr.getDomain();
        if (type instanceof CompositionType) {
            CompositionType bagType = (CompositionType)type;
            Iterator<Table> structi = bagType.iteratorRestrictedTo();
            if (structi.hasNext()) {
                while (structi.hasNext()) {
                    Table struct = structi.next();
                    Iterator<Extendable> attri = struct.getAttributes();
                    while (attri.hasNext()) {
                        AttributeDef subAttr = (AttributeDef)attri.next();
                        AbstractPatternDef.checkTopicDepOfAttr(thisTopic, subAttr, attrPath + "/" + subAttr.getName());
                    }
                }
            } else {
                Table struct = bagType.getComponentType();
                Iterator<Extendable> attri = struct.getAttributes();
                while (attri.hasNext()) {
                    AttributeDef subAttr = (AttributeDef)attri.next();
                    AbstractPatternDef.checkTopicDepOfAttr(thisTopic, subAttr, attrPath + "/" + subAttr.getName());
                }
            }
        } else if (type instanceof ReferenceType) {
            ReferenceType ref = (ReferenceType)type;
            boolean external = ref.isExternal();
            Iterator<AbstractClassDef> targeti = ref.iteratorRestrictedTo();
            if (targeti.hasNext()) {
                while (targeti.hasNext()) {
                    AbstractClassDef target = targeti.next();
                    AbstractPatternDef.checkRefTypeTarget(thisTopic, attrPath, (AbstractClassDef)attr.getContainer(), target, external);
                }
            } else {
                AbstractClassDef target = ref.getReferred();
                AbstractPatternDef.checkRefTypeTarget(thisTopic, attrPath, (AbstractClassDef)attr.getContainer(), target, external);
            }
        }
    }

    public static void checkRefTypeTarget(AbstractPatternDef<?> thisTopic, String attrPath, AbstractClassDef<?> struct, AbstractClassDef<?> target, boolean external) {
        Container targetTopic = target.getContainer();
        if (targetTopic != null && thisTopic != null && !thisTopic.isExtending(targetTopic)) {
            if (!external) {
                if (attrPath == null) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_refattr_externalreq"));
                }
                throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_refattr_externalreq2", attrPath, struct.getScopedName((Container)null)));
            }
            if (targetTopic != thisTopic && !thisTopic.isDependentOn(targetTopic)) {
                if (attrPath == null) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_refattr_topicdepreq", thisTopic.getName(), targetTopic.getScopedName(null)));
                }
                throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_refattr_topicdepreq2", thisTopic.getName(), targetTopic.getScopedName(null), attrPath, struct.getScopedName((Container)null)));
            }
        }
    }

    public void addAfter(E o, Object previous) {
        if (((ElementDelegate)this.elements).check(o)) {
            try {
                ((Element)o).setBeanContext(this);
            }
            catch (PropertyVetoException pve) {
                throw new IllegalArgumentException(pve.getLocalizedMessage());
            }
            int idx = this.contents.indexOf(previous);
            if (idx > -1 && idx + 1 < this.contents.size()) {
                this.contents.add(idx + 1, o);
            } else {
                this.contents.add(o);
            }
        }
    }

    @Override
    protected Collection<E> createElements() {
        return new ElementDelegate();
    }

    public List<Viewable<?>> getViewables() {
        ArrayList<Viewable<?>> result = new ArrayList();
        HashSet<Viewable> hiddenViewables = new HashSet<Viewable>();
        for (AbstractPatternDef t = this; t != null; t = (AbstractPatternDef)t.getRealExtending()) {
            Iterator iter = t.iterator();
            ArrayList tresult = new ArrayList();
            while (iter.hasNext()) {
                Element obj = (Element)iter.next();
                if (!(obj instanceof Viewable)) continue;
                if (obj instanceof Table && ((Table)obj).isExtended()) {
                    hiddenViewables.add((Viewable)((Table)obj).getExtending());
                } else if (obj instanceof AssociationDef && ((AssociationDef)obj).isExtended()) {
                    hiddenViewables.add((Viewable)((AssociationDef)obj).getExtending());
                }
                if (hiddenViewables.contains(obj)) continue;
                tresult.add((Viewable)obj);
            }
            tresult.addAll(result);
            result = tresult;
        }
        return result;
    }

    public List<Viewable<?>> getTransferViewables() {
        List<Viewable<?>> viewables = this.getViewables();
        ArrayList result = new ArrayList(viewables.size());
        for (Viewable<?> v : viewables) {
            if (AbstractPatternDef.suppressViewableInTransfer(v)) continue;
            result.add(v);
        }
        return result;
    }

    public static boolean suppressViewableInTransfer(Viewable<?> v) {
        Topic topic;
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        if (v instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)v;
            if (assoc.isLightweight()) {
                return true;
            }
            if (assoc.getDerivedFrom() != null) {
                return true;
            }
        }
        if (v instanceof View && (topic = (Topic)v.getContainer(Topic.class)) != null && !topic.isViewTopic()) {
            return true;
        }
        return v instanceof Table && !((Table)v).isIdentifiable();
    }

    private Element getElement(String name) {
        if (name != null) {
            for (Element e : this.contents) {
                if (!name.equals(e.getName())) continue;
                return e;
            }
            if (this.extending != null) {
                return ((AbstractPatternDef)this.extending).getElement(name);
            }
        }
        return null;
    }

    protected class ElementDelegate
    extends AbstractCollection<E> {
        protected ElementDelegate() {
        }

        @Override
        public Iterator<E> iterator() {
            return AbstractPatternDef.this.contents.iterator();
        }

        @Override
        public int size() {
            return AbstractPatternDef.this.contents.size();
        }

        @Override
        public boolean add(E o) {
            if (this.check(o)) {
                return AbstractPatternDef.this.contents.add(o);
            }
            return false;
        }

        private boolean check(E e) {
            if (e instanceof MetaDataUseDef) {
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_nonuniqueMetaDataUseDefName", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (e instanceof Unit) {
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_duplicateUnitName", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (e instanceof Domain) {
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_duplicateDomainName", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (e instanceof AssociationDef) {
                AssociationDef toInsert = (AssociationDef)e;
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e && !toInsert.isExtended() && !toInsert.isExtending(conflicting)) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_association_nonunique", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (e instanceof Table) {
                Table toInsert = (Table)e;
                Element.checkNameSanity(toInsert.getName(), false);
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e && !toInsert.isExtended() && !toInsert.isExtending(conflicting)) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_table_nonunique", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                if (!toInsert.isAbstract() && toInsert.isIdentifiable() && AbstractPatternDef.this instanceof Topic && ((Topic)AbstractPatternDef.this).isViewTopic()) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_topic_addNormalTableInViewTopic", toInsert.toString(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (e instanceof ExtendedView) {
                ExtendedView toInsert = (ExtendedView)e;
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e && !toInsert.isExtended() && !toInsert.isExtending(conflicting)) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_view_nonunique", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (e instanceof View) {
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_view_nonunique", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (e instanceof Function) {
                Model enclosingModel = (Model)AbstractPatternDef.this.getContainer(Model.class);
                if (enclosingModel.isIli23() && !enclosingModel.isContracted() && !(enclosingModel instanceof PredefinedModel)) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_model_functionButNoContract", e.toString(), enclosingModel.toString()));
                }
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_function_duplicateName", ((Element)e).getName(), AbstractPatternDef.this.toString(), conflicting.toString()));
                }
                return true;
            }
            if (e instanceof Projection) {
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_projection_nonunique", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (e instanceof Graphic) {
                Element conflicting = AbstractPatternDef.this.getElement(((Element)e).getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(Element.formatMessage("err_graphic_nonunique", ((Element)e).getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            throw new Ili2cSemanticException(Element.formatMessage("err_container_cannotContain", AbstractPatternDef.this.toString(), e.toString()));
        }
    }
}

