/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.wkb;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;

public class Wkb2iox {
    public static final String ATTR_POLYLINE = "polyline";
    public static final String ATTR_COORD = "coord";
    public static final String OBJ_MULTIPOLYLINE = "MULTIPOLYLINE";
    public static final String OBJ_MULTIPOINT = "MULTIPOINT";
    public static final String OBJ_MULTICOORD = "MULTICOORD";
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private int inputDimension = 2;
    private boolean hasSRID = false;
    private int SRID = 0;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private double[] ordValues;

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < hex.length() / 2; ++i) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = Wkb2iox.hexToInt(hex.charAt(i2));
            int nib0 = Wkb2iox.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit");
        }
        return nib;
    }

    public IomObject read(byte[] bytes) throws ParseException {
        try {
            return this.read((InStream)new ByteArrayInStream(bytes));
        }
        catch (IOException ex) {
            throw new ParseException((Exception)ex);
        }
    }

    public IomObject read(InStream is) throws IOException, ParseException {
        this.dis.setInStream(is);
        IomObject g = this.readGeometry();
        this.setSRID(g);
        return g;
    }

    private IomObject readGeometry() throws IOException, ParseException {
        byte byteOrder = this.dis.readByte();
        if (byteOrder == 1) {
            this.dis.setOrder(2);
        }
        int typeInt = this.dis.readInt();
        int geometryType = this.extractGeometryType(typeInt);
        boolean hasZ = (typeInt & Integer.MIN_VALUE) == Integer.MIN_VALUE || (typeInt & 0x3E8) == 1000;
        boolean hasM = (typeInt & 0x40000000) == 0x40000000 || (typeInt & 0x7D0) == 2000;
        int n = this.inputDimension = hasZ ? 3 : 2;
        if (hasM) {
            ++this.inputDimension;
        }
        boolean bl = this.hasSRID = (typeInt & 0x20000000) == 0x20000000;
        if (this.hasSRID) {
            this.SRID = this.dis.readInt();
        }
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        switch (geometryType) {
            case 1: {
                return this.readPoint(true);
            }
            case 4: {
                return this.readMultiPoint();
            }
            case 2: {
                return this.readLineString();
            }
            case 9: {
                return this.readCompoundCurve();
            }
            case 5: {
                return this.readMultiCurve(false);
            }
            case 11: {
                return this.readMultiCurve(true);
            }
            case 3: {
                return this.readPolygon();
            }
            case 10: {
                return this.readCurvePolygon();
            }
            case 6: {
                return this.readMultiPolygon();
            }
            case 12: {
                return this.readMultiSurface();
            }
            case 8: {
                return this.readCircularString();
            }
        }
        throw new ParseException("Unknown WKB type " + geometryType);
    }

    private int extractGeometryType(int typeInt) {
        return (typeInt & 0xFFFF) % 1000;
    }

    private IomObject setSRID(IomObject g) {
        if (this.SRID != 0) {
            // empty if block
        }
        return g;
    }

    private IomObject readPoint() throws IOException {
        return this.readPoint(false);
    }

    private IomObject readPoint(boolean enableEmpty) throws IOException {
        this.readCoordinate();
        if (Double.isNaN(this.ordValues[0]) && Double.isNaN(this.ordValues[1])) {
            if (enableEmpty) {
                return null;
            }
            throw new IOException("unexpected NaN in WKB");
        }
        Iom_jObject ret = new Iom_jObject("COORD", null);
        ret.setattrvalue("C1", Double.toString(this.ordValues[0]));
        ret.setattrvalue("C2", Double.toString(this.ordValues[1]));
        if (this.inputDimension == 3) {
            ret.setattrvalue("C3", Double.toString(this.ordValues[2]));
        }
        return ret;
    }

    private IomObject readMultiPoint() throws IOException {
        int coordc = this.dis.readInt();
        if (coordc == 0) {
            return null;
        }
        Iom_jObject ret = new Iom_jObject(OBJ_MULTICOORD, null);
        for (int coordi = 0; coordi < coordc; ++coordi) {
            byte byteOrder = this.dis.readByte();
            int typeInt = this.dis.readInt();
            int geometryType = this.extractGeometryType(typeInt);
            if (geometryType != 1) {
                throw new IllegalStateException("Unexpected WKB type " + geometryType);
            }
            IomObject coord = null;
            coord = this.readPoint();
            ret.addattrobj(ATTR_COORD, coord);
        }
        return ret;
    }

    private IomObject readLineString() throws IOException {
        int coordc = this.dis.readInt();
        if (coordc == 0) {
            return null;
        }
        Iom_jObject ret = new Iom_jObject("POLYLINE", null);
        Iom_jObject sequence = new Iom_jObject("SEGMENTS", null);
        ret.addattrobj("sequence", sequence);
        for (int coordi = 0; coordi < coordc; ++coordi) {
            sequence.addattrobj("segment", this.readPoint());
        }
        return ret;
    }

    private IomObject readCompoundCurve() throws IOException {
        int compc = this.dis.readInt();
        if (compc == 0) {
            return null;
        }
        Iom_jObject ret = new Iom_jObject("POLYLINE", null);
        Iom_jObject sequence = new Iom_jObject("SEGMENTS", null);
        ret.addattrobj("sequence", sequence);
        block4: for (int compi = 0; compi < compc; ++compi) {
            byte byteOrder = this.dis.readByte();
            int typeInt = this.dis.readInt();
            int geometryType = this.extractGeometryType(typeInt);
            switch (geometryType) {
                case 2: {
                    int coordi;
                    int coordc = this.dis.readInt();
                    for (coordi = 0; coordi < coordc; ++coordi) {
                        if (compi > 0 && coordi == 0) {
                            this.readPoint();
                            continue;
                        }
                        sequence.addattrobj("segment", this.readPoint());
                    }
                    continue block4;
                }
                case 8: {
                    int coordi;
                    int coordc = this.dis.readInt();
                    for (coordi = 0; coordi < coordc; ++coordi) {
                        if (compi == 0 && coordi == 0) {
                            sequence.addattrobj("segment", this.readPoint());
                            continue;
                        }
                        if (compi > 0 && coordi == 0) {
                            this.readPoint();
                            continue;
                        }
                        IomObject arcPt = this.readPoint();
                        if (++coordi >= coordc) {
                            throw new IllegalStateException("missing coord");
                        }
                        IomObject endPt = this.readPoint();
                        endPt.setobjecttag("ARC");
                        endPt.setattrvalue("A1", arcPt.getattrvalue("C1"));
                        endPt.setattrvalue("A2", arcPt.getattrvalue("C2"));
                        sequence.addattrobj("segment", endPt);
                    }
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unexpected WKB type " + geometryType);
                }
            }
        }
        return ret;
    }

    private IomObject readPolygon() throws IOException {
        int holec = this.dis.readInt();
        if (holec == 0) {
            return null;
        }
        Iom_jObject ret = new Iom_jObject("MULTISURFACE", null);
        Iom_jObject surface = new Iom_jObject("SURFACE", null);
        ret.addattrobj("surface", surface);
        for (int holei = 0; holei < holec; ++holei) {
            Iom_jObject boundary = new Iom_jObject("BOUNDARY", null);
            surface.addattrobj("boundary", boundary);
            boundary.addattrobj(ATTR_POLYLINE, this.readLineString());
        }
        return ret;
    }

    private IomObject readCurvePolygon() throws IOException, ParseException {
        int ringc = this.dis.readInt();
        if (ringc == 0) {
            return null;
        }
        Iom_jObject ret = new Iom_jObject("MULTISURFACE", null);
        Iom_jObject surface = new Iom_jObject("SURFACE", null);
        ret.addattrobj("surface", surface);
        for (int holei = 0; holei < ringc; ++holei) {
            Iom_jObject boundary = new Iom_jObject("BOUNDARY", null);
            surface.addattrobj("boundary", boundary);
            boundary.addattrobj(ATTR_POLYLINE, this.readGeometry());
        }
        return ret;
    }

    private IomObject readMultiPolygon() throws IOException, ParseException {
        int polygonc = this.dis.readInt();
        if (polygonc == 0) {
            return null;
        }
        IomObject ret = null;
        for (int polygoni = 0; polygoni < polygonc; ++polygoni) {
            byte byteOrder = this.dis.readByte();
            int typeInt = this.dis.readInt();
            int geometryType = this.extractGeometryType(typeInt);
            if (geometryType != 3) {
                throw new IllegalStateException("Unexpected WKB type " + geometryType);
            }
            if (ret == null) {
                ret = this.readPolygon();
                continue;
            }
            IomObject poly = this.readPolygon();
            IomObject surface = poly.getattrobj("surface", 0);
            ret.addattrobj("surface", surface);
        }
        return ret;
    }

    private IomObject readMultiSurface() throws IOException, ParseException {
        int surfacec = this.dis.readInt();
        if (surfacec == 0) {
            return null;
        }
        IomObject ret = null;
        for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
            byte byteOrder = this.dis.readByte();
            int typeInt = this.dis.readInt();
            int geometryType = this.extractGeometryType(typeInt);
            if (geometryType != 10 && geometryType != 3) {
                throw new IllegalStateException("Unexpected WKB type " + geometryType);
            }
            if (ret == null) {
                if (geometryType == 3) {
                    ret = this.readPolygon();
                    continue;
                }
                ret = this.readCurvePolygon();
                continue;
            }
            IomObject poly = null;
            poly = geometryType == 3 ? this.readPolygon() : this.readCurvePolygon();
            IomObject surface = poly.getattrobj("surface", 0);
            ret.addattrobj("surface", surface);
        }
        return ret;
    }

    private IomObject readMultiCurve(boolean allowCurve) throws IOException, ParseException {
        int curvec = this.dis.readInt();
        if (curvec == 0) {
            return null;
        }
        Iom_jObject ret = new Iom_jObject(OBJ_MULTIPOLYLINE, null);
        for (int curvei = 0; curvei < curvec; ++curvei) {
            byte byteOrder = this.dis.readByte();
            int typeInt = this.dis.readInt();
            int geometryType = this.extractGeometryType(typeInt);
            if (!(geometryType == 2 || allowCurve && geometryType == 9)) {
                throw new IllegalStateException("Unexpected WKB type " + geometryType);
            }
            IomObject polyline = null;
            polyline = geometryType == 2 ? this.readLineString() : this.readCompoundCurve();
            ret.addattrobj(ATTR_POLYLINE, polyline);
        }
        return ret;
    }

    private IomObject readCircularString() throws IOException {
        int coordc = this.dis.readInt();
        if (coordc == 0) {
            return null;
        }
        Iom_jObject ret = new Iom_jObject("POLYLINE", null);
        Iom_jObject sequence = new Iom_jObject("SEGMENTS", null);
        ret.addattrobj("sequence", sequence);
        for (int coordi = 0; coordi < coordc; ++coordi) {
            if (coordi == 0) {
                sequence.addattrobj("segment", this.readPoint());
                continue;
            }
            IomObject arcPt = this.readPoint();
            if (++coordi >= coordc) {
                throw new IllegalStateException("missing coord");
            }
            IomObject endPt = this.readPoint();
            endPt.setobjecttag("ARC");
            endPt.setattrvalue("A1", arcPt.getattrvalue("C1"));
            endPt.setattrvalue("A2", arcPt.getattrvalue("C2"));
            sequence.addattrobj("segment", endPt);
        }
        return ret;
    }

    private void readCoordinate() throws IOException {
        for (int i = 0; i < this.inputDimension; ++i) {
            this.ordValues[i] = this.dis.readDouble();
        }
    }
}

