/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox.utils;

import ch.interlis.iom.IomObject;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox.IoxReaderAlt;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;

public class IoxReaderAltAdapter
implements IoxReaderAlt {
    private IoxReader is = null;
    private int state = 0;

    public IoxReaderAltAdapter(IoxReader ioxReader) {
        this.is = ioxReader;
        this.state = 0;
    }

    @Override
    public StartTransferEvent readHeader() throws IoxException {
        if (this.state == 0) {
            IoxEvent ioxEvent = null;
            ioxEvent = this.is.read();
            if (ioxEvent == null) {
                return null;
            }
            if (ioxEvent instanceof StartTransferEvent) {
                this.state = 20;
                return (StartTransferEvent)ioxEvent;
            }
            throw new IoxException("unexpected event type " + ioxEvent.getClass().getName());
        }
        throw new IllegalStateException();
    }

    @Override
    public StartBasketEvent readBasket() throws IoxException {
        if (this.state == 20) {
            IoxEvent ioxEvent = null;
            ioxEvent = this.is.read();
            if (ioxEvent instanceof EndTransferEvent) {
                this.state = 0;
                return null;
            }
            if (ioxEvent instanceof StartBasketEvent) {
                this.state = 30;
                return (StartBasketEvent)ioxEvent;
            }
            throw new IoxException("unexpected event type " + ioxEvent.getClass().getName());
        }
        throw new IllegalStateException();
    }

    @Override
    public IomObject readObject() throws IoxException {
        if (this.state == 30) {
            IoxEvent ioxEvent = null;
            ioxEvent = this.is.read();
            if (ioxEvent instanceof ObjectEvent) {
                this.state = 30;
                return ((ObjectEvent)ioxEvent).getIomObject();
            }
            if (ioxEvent instanceof EndBasketEvent) {
                this.state = 20;
                return null;
            }
            throw new IoxException("unexpected event type " + ioxEvent.getClass().getName());
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() throws IoxException {
        if (this.is != null) {
            this.is = null;
        }
        this.state = 0;
    }
}

