/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.gui;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import java.io.File;
import java.io.IOException;

public class UserSettings
extends Settings {
    public static final String SETTINGS_FILE = System.getProperty("user.home") + "/.ili2c";
    public static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    public static final String ILI_LANGUAGE_VERSION = "ch.interlis.ili2c.iliLangVersion";
    public static final String ILIDIRS = "ch.interlis.ili2c.ilidirs";
    public static final String HTTP_PROXY_HOST = "ch.interlis.ili2c.http_proxy_host";
    public static final String HTTP_PROXY_PORT = "ch.interlis.ili2c.http_proxy_port";
    public static final String TEMP_REPOS_URI = "ch.interlis.ili2c.tempReposUri";
    public static final String TEMP_REPOS_ILIFILES = "ch.interlis.ili2c.tempReposIliFiles";
    public static final String CUSTOM_ILI_RESOLVER = "ch.interlis.ili2c.customIliResolver";
    public static final String ILIDIRS_PATHMAP = "ch.interlis.ili2c.pathMap";
    public static final String CUSTOM_ILI_MANAGER = "ch.interlis.ili2c.customIliManager";
    public static final String ILI_DIR = "%ILI_DIR";
    public static final String JAR_DIR = "%JAR_DIR";
    public static final String JAR_MODELS = "standard";
    public static final String ILI_REPOSITORY = "http://models.interlis.ch/";
    public static final String ILIDIR_SEPARATOR = ";";
    public static final String MODELS_SEPARATOR = ";";
    public static final String DEFAULT_ILIDIRS = "%ILI_DIR;http://models.interlis.ch/;%JAR_DIR";

    public static UserSettings load() {
        UserSettings userSettings = new UserSettings();
        try {
            String wd;
            String ilidirs;
            File f = new File(SETTINGS_FILE);
            if (f.exists()) {
                userSettings.load(f);
            }
            if ((ilidirs = userSettings.getIlidirs()) == null) {
                userSettings.setIlidirs(DEFAULT_ILIDIRS);
            }
            if ((wd = userSettings.getWorkingDirectory()) == null) {
                userSettings.setWorkingDirectory(System.getProperty("user.home"));
            }
        }
        catch (IOException e) {
            EhiLogger.logError((String)"failed to load settings", (Throwable)e);
        }
        return userSettings;
    }

    public void save(String appName) {
        try {
            this.store(new File(SETTINGS_FILE), appName);
        }
        catch (IOException e) {
            EhiLogger.logError((String)"failed to save settings", (Throwable)e);
        }
    }

    public String getWorkingDirectory() {
        return this.getValue(WORKING_DIRECTORY);
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.setValue(WORKING_DIRECTORY, workingDirectory);
    }

    public String getIlidirs() {
        return this.getValue(ILIDIRS);
    }

    public void setIlidirs(String workingDirectory) {
        this.setValue(ILIDIRS, workingDirectory);
    }

    public String getHttpProxyHost() {
        return this.getValue(HTTP_PROXY_HOST);
    }

    public void setHttpProxyHost(String workingDirectory) {
        this.setValue(HTTP_PROXY_HOST, workingDirectory);
    }

    public String getHttpProxyPort() {
        return this.getValue(HTTP_PROXY_PORT);
    }

    public void setHttpProxyPort(String workingDirectory) {
        this.setValue(HTTP_PROXY_PORT, workingDirectory);
    }
}

