/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.TypeAlias;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Type
extends AbstractLeafElement
implements Cloneable {
    protected Type extending = null;
    protected Set<Type> extendedBy = new HashSet<Type>(2);
    protected Cardinality cardinality = new Cardinality(0L, 1L);
    private boolean ordered = false;

    protected Type() {
    }

    public boolean isBoolean() {
        Type type = this;
        while (type instanceof TypeAlias) {
            Domain domain = ((TypeAlias)type).getAliasing();
            TransferDescription td = (TransferDescription)domain.getContainer(TransferDescription.class);
            if (domain == td.INTERLIS.BOOLEAN) {
                return true;
            }
            type = domain.getType();
        }
        return false;
    }

    public Type clone() {
        Type cloned = null;
        try {
            cloned = (Type)super.clone();
            cloned.extendedBy = new HashSet<Type>(2);
            if (cloned.extending != null) {
                cloned.extending.extendedBy.add(cloned);
            }
            cloned.cardinality = this.cardinality.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }

    public boolean isAbstract(StringBuilder err) {
        return false;
    }

    public boolean isAbstract() {
        return this.isAbstract(new StringBuilder());
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) throws PropertyVetoException {
        boolean oldValue = this.ordered;
        boolean newValue = ordered;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("ordered", oldValue, newValue);
        this.ordered = newValue;
        this.firePropertyChange("ordered", oldValue, newValue);
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(Cardinality cardinality) throws PropertyVetoException {
        Cardinality oldValue = this.cardinality;
        Cardinality newValue = cardinality;
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        if (newValue.equals(oldValue)) {
            return;
        }
        this.fireVetoableChange("cardinality", oldValue, newValue);
        this.cardinality = newValue;
        this.firePropertyChange("cardinality", oldValue, newValue);
    }

    public boolean isMandatory() {
        return this.cardinality.getMinimum() != 0L;
    }

    public boolean isMandatoryConsideringAliases() {
        return this.isMandatory();
    }

    public void setMandatory(boolean mand) throws PropertyVetoException {
        boolean oldValue = this.isMandatory();
        boolean newValue = mand;
        this.fireVetoableChange("mandatory", oldValue, newValue);
        if (mand) {
            if (this.cardinality.getMinimum() == 0L) {
                this.cardinality.setMinimum(1L);
            }
        } else if (this.cardinality.getMinimum() > 0L) {
            this.cardinality.setMinimum(0L);
        }
        this.firePropertyChange("mandatory", oldValue, newValue);
    }

    public Element getExtending() {
        return this.extending;
    }

    public void setExtending(Type extending) throws PropertyVetoException {
        Type oldValue = this.extending;
        Type newValue = extending;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && newValue.isExtendingIndirectly(this)) {
            throw new IllegalArgumentException(Type.formatMessage("err_cyclicExtension", this.toString(), newValue.toString()));
        }
        this.checkTypeExtension(newValue);
        this.fireVetoableChange("extending", oldValue, newValue);
        if (oldValue != null) {
            oldValue.extendedBy.remove(this);
        }
        this.extending = newValue;
        if (newValue != null) {
            newValue.extendedBy.add(this);
        }
        this.firePropertyChange("extending", oldValue, newValue);
    }

    boolean isExtendingIndirectly(Type typ) {
        Type parent = this;
        while (parent != null) {
            if (parent == typ) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    abstract void checkTypeExtension(Type var1);

    void checkCardinalityExtension(Type general) {
        if (this.cardinality.getMaximum() > 1L && !this.isOrdered() && general.isOrdered()) {
            throw new IllegalArgumentException(rsrc.getString("err_compositionType_UnorderedExtOrdered"));
        }
        if (!general.cardinality.isGeneralizing(this.cardinality)) {
            throw new IllegalArgumentException(Type.formatMessage("err_compositionType_cardExtMismatch", this.cardinality.toString(), general.cardinality.toString()));
        }
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        Type origin = (Type)this.getTranslationOf();
        if (origin == null) {
            return;
        }
        if (this.isAbstract() != origin.isAbstract()) {
            throw new Ili2cSemanticException();
        }
        if (!this.getCardinality().equals(origin.getCardinality())) {
            throw new Ili2cSemanticException();
        }
        if (this.isOrdered() != origin.isOrdered()) {
            throw new Ili2cSemanticException();
        }
    }

    public Type resolveAliases() {
        return this;
    }

    public static final Type findReal(Type potentialAlias) {
        if (potentialAlias instanceof TypeAlias) {
            return Type.findReal(potentialAlias.resolveAliases());
        }
        return potentialAlias;
    }
}

