/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.utility;

import ch.interlis.iom_j.csv.CsvReader;
import ch.interlis.iom_j.iligml.Iligml20Reader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.xtf.Xtf24Reader;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.IoxUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ReaderFactory {
    public IoxReader createReader(File inputFile, LogEventFactory errFact) throws IoxException {
        IoxIliReader reader = null;
        reader = new ItfReader2(inputFile, null, false);
        IoxEvent event = null;
        try {
            event = reader.read();
            if (event != null) {
                reader = new ItfReader2(inputFile, null, false);
                return reader;
            }
        }
        catch (IoxException ioxException) {
            // empty catch block
        }
        String ns = this.getXMLNamespace(inputFile);
        if (ns != null) {
            if (ns.equals("http://www.interlis.ch/INTERLIS2.2") || ns.equals("http://www.interlis.ch/INTERLIS2.3")) {
                reader = new XtfReader(inputFile);
                return reader;
            }
            if (ns.equals("http://www.interlis.ch/xtf/2.4/INTERLIS")) {
                reader = new Xtf24Reader(inputFile);
                return reader;
            }
            if (ns.equals("http://www.interlis.ch/ILIGML-2.0/INTERLIS")) {
                reader = new Iligml20Reader(inputFile);
                return reader;
            }
            throw new IoxException("unknown xml file");
        }
        if (IoxUtility.isCsvFilename(inputFile.getName())) {
            reader = new CsvReader(inputFile);
            IoxEvent event5 = null;
            try {
                event5 = reader.read();
                if (event5 != null) {
                    reader = new CsvReader(inputFile);
                    return reader;
                }
            }
            catch (IoxException ioxException) {
                // empty catch block
            }
        }
        throw new IoxException("no reader found");
    }

    public String getXMLNamespace(File inputFile) {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = null;
        FileInputStream in = null;
        XMLEvent event = null;
        try {
            in = new FileInputStream(inputFile);
            reader = inputFactory.createXMLEventReader(in);
            event = reader.nextEvent();
            while (event != null && !event.isStartElement()) {
                event = reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            String string = null;
            return string;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
                reader = null;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
        }
        if (event != null) {
            String ns = event.asStartElement().getName().getNamespaceURI();
            return ns;
        }
        return null;
    }
}

