/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Viewable;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class Container<E extends Element>
extends Element
implements BeanContext {
    protected final BeanContextSupport bcs = new BeanContextSupport(this);
    protected Collection<E> elements;

    protected Container() {
        this.bccs = this.bcs;
        this.elements = this.createElements();
    }

    protected abstract Collection<E> createElements();

    @Override
    public int size() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).size();
        }
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).isEmpty();
        }
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).contains(o);
        }
        return this.elements.contains(o);
    }

    @Override
    public final Iterator<E> iterator() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).iterator();
        }
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).toArray();
        }
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] a) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).toArray(a);
        }
        return this.elements.toArray(a);
    }

    public boolean add(Object o) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).add(o);
        }
        Element e = (Element)o;
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (o instanceof Element) {
            try {
                e.setBeanContext(this);
            }
            catch (PropertyVetoException pve) {
                throw new IllegalArgumentException(pve.getLocalizedMessage());
            }
            boolean wasAdded = this.elements.add(e);
            return wasAdded;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean remove(Object o) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).remove(o);
        }
        return this.elements.remove(o);
    }

    public boolean containsAll(Collection c) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).containsAll(c);
        }
        return this.elements.containsAll(c);
    }

    public boolean addAll(Collection c) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).addAll(c);
        }
        return this.elements.addAll(c);
    }

    public boolean removeAll(Collection c) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).removeAll(c);
        }
        return this.elements.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).retainAll(c);
        }
        return this.elements.retainAll(c);
    }

    @Override
    public void clear() {
        if (this.isAlias()) {
            ((Container)this.getReal()).clear();
            return;
        }
        this.elements.clear();
    }

    @Override
    public void addBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        if (this.isAlias()) {
            ((Container)this.getReal()).addBeanContextMembershipListener(bcml);
            return;
        }
        this.bcs.addBeanContextMembershipListener(bcml);
    }

    @Override
    public URL getResource(String name, BeanContextChild bcc) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getResource(name, bcc);
        }
        return this.bcs.getResource(name, bcc);
    }

    @Override
    public InputStream getResourceAsStream(String name, BeanContextChild bcc) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getResourceAsStream(name, bcc);
        }
        return this.bcs.getResourceAsStream(name, bcc);
    }

    @Override
    public Object instantiateChild(String beanName) throws ClassNotFoundException, IOException {
        if (this.isAlias()) {
            return ((Container)this.getReal()).instantiateChild(beanName);
        }
        return this.bcs.instantiateChild(beanName);
    }

    @Override
    public void removeBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        if (this.isAlias()) {
            ((Container)this.getReal()).removeBeanContextMembershipListener(bcml);
            return;
        }
        this.bcs.removeBeanContextMembershipListener(bcml);
    }

    @Override
    public void setDesignTime(boolean designTime) {
        if (this.isAlias()) {
            ((Container)this.getReal()).setDesignTime(designTime);
            return;
        }
        this.bcs.setDesignTime(designTime);
    }

    @Override
    public boolean isDesignTime() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).isDesignTime();
        }
        return this.bcs.isDesignTime();
    }

    @Override
    public boolean needsGui() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).needsGui();
        }
        return this.bcs.needsGui();
    }

    @Override
    public void dontUseGui() {
        if (this.isAlias()) {
            ((Container)this.getReal()).dontUseGui();
            return;
        }
        this.bcs.dontUseGui();
    }

    @Override
    public void okToUseGui() {
        if (this.isAlias()) {
            ((Container)this.getReal()).okToUseGui();
            return;
        }
        this.bcs.okToUseGui();
    }

    @Override
    public boolean avoidingGui() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).avoidingGui();
        }
        return this.bcs.avoidingGui();
    }

    protected Model resolveModelName(String name) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).resolveModelName(name);
        }
        BeanContext bc = this.getBeanContext();
        if (bc instanceof Container) {
            return ((Container)bc).resolveModelName(name);
        }
        return null;
    }

    public Element getElement(Class klass, String name) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getElement(klass, name);
        }
        if (name == null) {
            return null;
        }
        for (Element e : this) {
            if (!klass.isAssignableFrom(e.getClass()) || !name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public Element getRealElement(Class klass, String name) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getRealElement(klass, name);
        }
        Element ele = this.getElement(klass, name);
        if (ele != null) {
            ele = ele.getReal();
        }
        return ele;
    }

    public final Container getContainerOrSame(Class klass) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getContainerOrSame(klass);
        }
        if (klass.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.getContainer(klass);
    }

    public final boolean containsIndirectly(Element elt) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).containsIndirectly(elt);
        }
        for (Container<?> curContainer = elt.getContainer(Container.class); curContainer != null; curContainer = curContainer.getContainer(Container.class)) {
            if (curContainer != this) continue;
            return true;
        }
        return false;
    }

    public Set getIndirectElements() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getIndirectElements();
        }
        HashSet result = new HashSet();
        this.getIndirectElements_helper(result);
        return result;
    }

    private final void getIndirectElements_helper(Set s) {
        for (E obj : this) {
            if (!(obj instanceof Element)) continue;
            s.add(obj);
            if (!(obj instanceof Container)) continue;
            ((Container)obj).getIndirectElements_helper(s);
        }
    }

    public Viewable getRHSNameSpace() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getRHSNameSpace();
        }
        Container c = this.getContainer();
        if (c == null) {
            return null;
        }
        return c.getRHSNameSpace();
    }

    @Override
    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
        if (this.isAlias()) {
            ((Container)this.getReal()).checkIntegrity(errs);
            return;
        }
        super.checkIntegrity(errs);
        for (E obj : this) {
            if (!(obj instanceof Element)) continue;
            ((Element)obj).checkIntegrity(errs);
        }
    }

    @Override
    protected void linkTranslationOf(Element baseElement) {
        super.linkTranslationOf(baseElement);
        Iterator<E> baseIter = ((Container)baseElement).iterator();
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            if (!baseIter.hasNext()) {
                throw new Ili2cSemanticException(this.getSourceLine(), Container.formatMessage("err_diff_unequalNumberOfElts", this.getScopedName(), baseElement.getScopedName()));
            }
            E baseChild = baseIter.next();
            E child = iter.next();
            if (!(child instanceof Element) || ((Element)child).isDirty() || ((Element)baseChild).isDirty()) continue;
            if (child.getClass() != baseChild.getClass()) {
                throw new Ili2cSemanticException(this.getSourceLine(), Container.formatMessage("err_diff_mismatchInClass", ((Element)child).getScopedName(), ((Element)baseChild).getScopedName()));
            }
            ((Element)child).linkTranslationOf((Element)baseChild);
        }
        if (baseIter.hasNext()) {
            throw new Ili2cSemanticException(this.getSourceLine(), Container.formatMessage("err_diff_unequalNumberOfElts", this.getScopedName(), baseElement.getScopedName()));
        }
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        Container baseElement = (Container)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isAlias()) {
            ((Container)this.getReal()).checkTranslationOf(errs, name, baseName);
            return;
        }
        super.checkTranslationOf(errs, name, baseName);
        for (E obj : this) {
            if (!(obj instanceof Element)) continue;
            ((Element)obj).checkTranslationOf(errs, name, baseName);
        }
    }

    @Override
    public boolean checkStructuralEquivalence(Element with) {
        int withSize;
        if (this.isAlias()) {
            return ((Container)this.getReal()).checkStructuralEquivalence(with);
        }
        if (!super.checkStructuralEquivalence(with)) {
            return false;
        }
        int mySize = this.size();
        if (mySize != (withSize = ((Container)with).size())) {
            EhiLogger.logError((String)Container.formatMessage("err_diff_unequalNumberOfElts", this.toString(), Integer.toString(mySize), with.toString(), Integer.toString(withSize)));
            return false;
        }
        Iterator<E> myIter = this.iterator();
        Iterator<E> otherIter = ((Container)with).iterator();
        boolean allFine = true;
        while (myIter.hasNext() && otherIter.hasNext()) {
            Element curMy = (Element)myIter.next();
            Element curOther = (Element)otherIter.next();
            if (curMy == null || curMy.checkStructuralEquivalence(curOther)) continue;
            allFine = false;
        }
        return allFine;
    }
}

