/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator.nls;

import ch.interlis.ili2c.generator.nls.ModelElements;
import ch.interlis.ili2c.generator.nls.TranslationElement;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Parameter;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SignAttribute;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class Ili2TranslationXml {
    private ModelElements elements = new ModelElements();
    public static final String METAOBJECT = ".METAOBJECT.";
    public static final String FR = "fr";
    public static final String IT = "it";
    public static final String EN = "en";
    public static final String DE = "de";

    public ModelElements convertTransferDescription2ModelElements(TransferDescription td) {
        this.readAllModelsFromTransferDesc(td);
        return this.elements;
    }

    public static void writeModelElementsAsXML(ModelElements eles, File fileName) throws Exception {
        Class[] jaxbContextPath = new Class[]{ModelElements.class};
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])jaxbContextPath);
        Marshaller ms = jaxbContext.createMarshaller();
        ms.marshal((Object)eles, fileName);
    }

    private void readAllModelsFromTransferDesc(TransferDescription td) {
        Model[] models = td.getModelsFromLastFile();
        HashSet<Model> visitedModels = new HashSet<Model>();
        ArrayList<Model> mostSpecificModels = new ArrayList<Model>();
        for (int modeli = models.length - 1; modeli >= 0; --modeli) {
            Model model = models[modeli];
            if (visitedModels.contains(model)) continue;
            visitedModels.add(model);
            mostSpecificModels.add(0, model);
            for (Model translatedModel = (Model)model.getTranslationOf(); translatedModel != null; translatedModel = (Model)translatedModel.getTranslationOf()) {
                visitedModels.add(translatedModel);
            }
        }
        for (Model model : mostSpecificModels) {
            TranslationElement text = new TranslationElement();
            this.allFieldsWithSetTOEmpty(text);
            text.setScopedName(Ili2TranslationXml.getElementInRootLanguage(model).getScopedName());
            text.setElementType(this.getElementType(model));
            this.setModelElementAllLanguages(text, model);
            this.printModelElement(text);
            this.visitAllElements(model);
        }
    }

    private String hasATranslation(Model model) {
        if (model.getTranslationOf() != null) {
            return model.getTranslationOf().getName();
        }
        return "";
    }

    private boolean controlOfTheFileName(Model model, String file) {
        if (model.getFileName() == null) {
            return true;
        }
        File fileNameFromModel = new File(model.getFileName());
        File fileNameFromIli = new File(file);
        return !fileNameFromModel.getName().equals(fileNameFromIli.getName());
    }

    private void allFieldsWithSetTOEmpty(TranslationElement text) {
        text.setDocumentation_de("");
        text.setDocumentation_en("");
        text.setDocumentation_fr("");
        text.setDocumentation_it("");
        text.setName_de("");
        text.setName_en("");
        text.setName_fr("");
        text.setName_it("");
        text.setScopedName("");
    }

    private String getElementType(Object model) {
        if (model instanceof Model) {
            return "MODEL";
        }
        if (model instanceof AttributeDef) {
            return "ATTRIBUTE";
        }
        if (model instanceof RoleDef) {
            return "ROLE";
        }
        if (model instanceof Function) {
            return "FUNCTION";
        }
        if (model instanceof Parameter) {
            return "PARAMETER";
        }
        if (model instanceof Domain) {
            return "DOMAIN";
        }
        if (model instanceof LineForm) {
            return "LINE FORM";
        }
        if (model instanceof Unit) {
            return "UNIT";
        }
        if (model instanceof Topic) {
            return "TOPIC";
        }
        if (model instanceof MetaDataUseDef) {
            return "META DATA BASKET";
        }
        if (model instanceof AbstractClassDef) {
            return this.findElementType(model);
        }
        if (model instanceof AssociationDef) {
            return "ASSOCIATION";
        }
        if (model instanceof View) {
            return "VIEW";
        }
        if (model instanceof Graphic) {
            return "GRAPHIC";
        }
        if (model instanceof Constraint) {
            return "CONSTRAINT";
        }
        if (model instanceof ExpressionSelection) {
            return "EXPRESSION SELECTION";
        }
        if (model instanceof SignAttribute) {
            return "SIGN ATTRIBUTE";
        }
        if (model instanceof Enumeration.Element) {
            return "ENUMERATION ELEMENT";
        }
        return "";
    }

    private String findElementType(Object model) {
        AbstractClassDef abstractClassDefiniton = (AbstractClassDef)model;
        if (abstractClassDefiniton instanceof Table) {
            Table table = (Table)abstractClassDefiniton;
            if (table.isIdentifiable()) {
                return "CLASS";
            }
            return "STRUCTURE";
        }
        if (abstractClassDefiniton instanceof AssociationDef) {
            return "ASSOCIATION";
        }
        throw new IllegalArgumentException("Unexpected AbstractClassDef");
    }

    public static Element getElementInRootLanguage(Element ele) {
        Element baseLanguageElement = ele.getTranslationOf();
        if (baseLanguageElement != null) {
            ele = baseLanguageElement;
            baseLanguageElement = ele.getTranslationOf();
        }
        return ele;
    }

    private void printModelElement(TranslationElement text) {
        this.elements.add(text);
    }

    private void setModelElementAllLanguages(TranslationElement text, Element model) {
        String language = Ili2TranslationXml.getLanguage(model);
        this.convertModelElement(text, model, language);
        Element baseLanguageElement = model.getTranslationOf();
        while (baseLanguageElement != null) {
            language = Ili2TranslationXml.getLanguage(baseLanguageElement);
            this.convertModelElement(text, baseLanguageElement, language);
            Element translatedElement = baseLanguageElement;
            baseLanguageElement = translatedElement.getTranslationOf();
        }
    }

    public static String getLanguage(Element ele) {
        if (ele instanceof Model) {
            return ((Model)ele).getLanguage();
        }
        return ((Model)ele.getContainer(Model.class)).getLanguage();
    }

    private void convertModelElement(TranslationElement text, Element model, String language) {
        if (language == null) {
            if (model.getName() != null) {
                text.setName_de(model.getName());
            }
            if (model.getDocumentation() != null) {
                text.setDocumentation_de(model.getDocumentation());
            }
        } else if (language.equals(DE)) {
            if (model.getName() != null) {
                text.setName_de(model.getName());
            }
            if (model.getDocumentation() != null) {
                text.setDocumentation_de(model.getDocumentation());
            }
        } else if (language.equals(FR)) {
            if (model.getName() != null) {
                text.setName_fr(model.getName());
            }
            if (model.getDocumentation() != null) {
                text.setDocumentation_fr(model.getDocumentation());
            }
        } else if (language.equals(IT)) {
            if (model.getName() != null) {
                text.setName_it(model.getName());
            }
            if (model.getDocumentation() != null) {
                text.setDocumentation_it(model.getDocumentation());
            }
        } else if (language.equals(EN)) {
            if (model.getName() != null) {
                text.setName_en(model.getName());
            }
            if (model.getDocumentation() != null) {
                text.setDocumentation_en(model.getDocumentation());
            }
        }
    }

    private void setTranslationElementName(TranslationElement text, String name, String language) {
        if (language == null) {
            text.setName_de(name);
        } else if (language.equals(DE)) {
            text.setName_de(name);
        } else if (language.equals(FR)) {
            text.setName_fr(name);
        } else if (language.equals(IT)) {
            text.setName_it(name);
        } else if (language.equals(EN)) {
            text.setName_en(name);
        }
    }

    private void convertEnumerationElement(TranslationElement text, Enumeration.Element element, String language) {
        if (language == null) {
            text.setName_de(element.getName());
            text.setDocumentation_de(element.getDocumentation());
        } else if (language.equals(DE)) {
            text.setName_de(element.getName());
            text.setDocumentation_de(element.getDocumentation());
        } else if (language.equals(FR)) {
            text.setName_fr(element.getName());
            text.setDocumentation_fr(element.getDocumentation());
        } else if (language.equals(IT)) {
            text.setName_it(element.getName());
            text.setDocumentation_de(element.getDocumentation());
        } else if (language.equals(EN)) {
            text.setName_en(element.getName());
            text.setDocumentation_en(element.getDocumentation());
        }
    }

    private void visitAllElements(Container model) {
        for (Element ele : model) {
            String text;
            TranslationElement dto = new TranslationElement();
            dto.setScopedName(Ili2TranslationXml.getElementInRootLanguage(ele).getScopedName());
            this.setModelElementAllLanguages(dto, ele);
            dto.setElementType(this.getElementType(ele));
            this.addTranslationElementForMetaValues(ele);
            this.printModelElement(dto);
            if (ele instanceof Container) {
                this.visitAllElements((Container)ele);
                continue;
            }
            if (ele instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)ele;
                if (!(attr.getDomain() instanceof EnumerationType)) continue;
                text = Ili2TranslationXml.getElementInRootLanguage(ele).getScopedName();
                this.prepareAllEnumaration((EnumerationType)attr.getDomain(), text, attr);
                continue;
            }
            if (ele instanceof Domain) {
                Domain domain = (Domain)ele;
                if (!(domain.getType() instanceof EnumerationType)) continue;
                text = Ili2TranslationXml.getElementInRootLanguage(ele).getScopedName();
                this.prepareAllEnumaration((EnumerationType)domain.getType(), text, domain);
                continue;
            }
            if (!(ele instanceof Function)) continue;
            TranslationElement traslationElement = new TranslationElement();
            Function function = (Function)ele;
            FormalArgument[] arguments = function.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                this.convertModelElement(traslationElement, arguments[i], Ili2TranslationXml.getLanguage(function));
                Function function2 = arguments[i].getFunction();
                Element baseLanguageElement = function2.getTranslationOf();
                while (baseLanguageElement != null) {
                    if (!(baseLanguageElement instanceof Function)) continue;
                    Function fnc = (Function)baseLanguageElement;
                    FormalArgument[] argumentsSubElement = fnc.getArguments();
                    for (int j = 0; j < argumentsSubElement.length; ++j) {
                        this.convertModelElement(traslationElement, argumentsSubElement[j], Ili2TranslationXml.getLanguage(baseLanguageElement));
                        traslationElement.setScopedName(Ili2TranslationXml.getElementInRootLanguage(function).getScopedName() + "." + argumentsSubElement[j].getName());
                        function2 = argumentsSubElement[i].getFunction();
                        baseLanguageElement = function2.getTranslationOf();
                    }
                }
                this.printModelElement(traslationElement);
            }
        }
    }

    private void addTranslationElementForMetaValues(Element ele) {
        String eleScopedName = Ili2TranslationXml.getElementInRootLanguage(ele).getScopedName();
        for (String metaAttrName : ele.getMetaValues().getValues()) {
            String metaAttrScopedName = this.getMetaAttributeScopedName(eleScopedName, metaAttrName);
            TranslationElement translationElement = new TranslationElement();
            translationElement.setElementType("METAATTRIBUTE");
            translationElement.setScopedName(metaAttrScopedName);
            while (ele != null) {
                String language = Ili2TranslationXml.getLanguage(ele);
                String metaAttrValue = ele.getMetaValue(metaAttrName);
                this.setTranslationElementName(translationElement, metaAttrValue, language);
                ele = ele.getTranslationOf();
            }
            this.elements.add(translationElement);
        }
    }

    private String getMetaAttributeScopedName(String eleScopedName, String metaAttrName) {
        return eleScopedName + METAOBJECT + metaAttrName;
    }

    private void prepareAllEnumaration(EnumerationType et, String scopedNamePrefix, Element modelElement) {
        Enumeration enumeration = et.getEnumeration();
        this.printAllEnumaration(enumeration, scopedNamePrefix, modelElement);
    }

    private void printAllEnumaration(Enumeration enumeration, String scopedNamePrefix, Element modelEle) {
        Iterator<Enumeration.Element> enumarationIterator = enumeration.getElements();
        while (enumarationIterator.hasNext()) {
            Enumeration.Element enumEle = enumarationIterator.next();
            TranslationElement text = new TranslationElement();
            String scopedName = scopedNamePrefix + "." + Ili2TranslationXml.getEnumerationElementInRootLanguage(enumEle).getName();
            text.setScopedName(scopedName);
            String language = Ili2TranslationXml.getLanguage(modelEle);
            this.convertEnumerationElement(text, enumEle, language);
            Enumeration.Element baseLanguageElement = enumEle.getTranslationOf();
            Element baseLanguageModelElement = modelEle.getTranslationOf();
            while (baseLanguageElement != null) {
                String baseLanguage = Ili2TranslationXml.getLanguage(baseLanguageModelElement);
                this.convertEnumerationElement(text, baseLanguageElement, baseLanguage);
                baseLanguageElement = baseLanguageElement.getTranslationOf();
                baseLanguageModelElement = baseLanguageModelElement.getTranslationOf();
            }
            text.setElementType(this.getElementType(enumEle));
            this.addMetaValues(enumEle, scopedName, modelEle);
            this.printModelElement(text);
            if (enumEle.getSubEnumeration() == null) continue;
            this.printAllEnumaration(enumEle.getSubEnumeration(), scopedName, modelEle);
        }
    }

    private void addMetaValues(Enumeration.Element ele, String scopedName, Element modelEle) {
        for (String metaAttrName : ele.getMetaValues().getValues()) {
            String metaAttrScopedName = this.getMetaAttributeScopedName(scopedName, metaAttrName);
            TranslationElement translationElement = new TranslationElement();
            translationElement.setElementType("METAATTRIBUTE");
            translationElement.setScopedName(metaAttrScopedName);
            String metaAttrValue = ele.getMetaValues().getValue(metaAttrName);
            String language = Ili2TranslationXml.getLanguage(modelEle);
            this.setTranslationElementName(translationElement, metaAttrValue, language);
            Element baseLanguageModelElement = modelEle.getTranslationOf();
            Enumeration.Element baseLanguageElement = ele.getTranslationOf();
            while (baseLanguageElement != null) {
                String langu = Ili2TranslationXml.getLanguage(baseLanguageModelElement);
                String metaValue = baseLanguageElement.getMetaValues().getValue(metaAttrName);
                this.setTranslationElementName(translationElement, metaValue, langu);
                baseLanguageElement = baseLanguageElement.getTranslationOf();
                baseLanguageModelElement = baseLanguageModelElement.getTranslationOf();
            }
            this.elements.add(translationElement);
        }
    }

    private static Enumeration.Element getEnumerationElementInRootLanguage(Enumeration.Element ele) {
        Enumeration.Element baseLanguageElement = ele.getTranslationOf();
        if (baseLanguageElement != null) {
            ele = baseLanguageElement;
            baseLanguageElement = ele.getTranslationOf();
        }
        return ele;
    }

    public static ModelElements readModelElementsXml(File file) throws Exception {
        Unmarshaller um = Ili2TranslationXml.createUnmarshaller();
        ModelElements modelElements = (ModelElements)um.unmarshal(file);
        return modelElements;
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException {
        Class[] jaxbContextPath = new Class[]{ModelElements.class};
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])jaxbContextPath);
        Unmarshaller um = jaxbContext.createUnmarshaller();
        return um;
    }
}

