/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.ehi.basics.io.IndentPrintWriter;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.generator.TransformationParameter;
import ch.interlis.ili2c.generator.nls.Ili2TranslationXml;
import ch.interlis.ili2c.generator.nls.ModelElements;
import ch.interlis.ili2c.generator.nls.TranslationElement;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributePathType;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.ComposedUnit;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.ConditionalExpression;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.DecompositionView;
import ch.interlis.ili2c.metamodel.DerivedUnit;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumValType;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExistenceConstraint;
import ch.interlis.ili2c.metamodel.Expression;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.FormattedTypeBaseAttrRef;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.FunctionallyDerivedUnit;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.JoinView;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.MandatoryConstraint;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.MetaObject;
import ch.interlis.ili2c.metamodel.MetaobjectType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.MultiAreaType;
import ch.interlis.ili2c.metamodel.MultiCoordType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.MultiSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.MultiSurfaceType;
import ch.interlis.ili2c.metamodel.NoOid;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.NumericallyDerivedUnit;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.Parameter;
import ch.interlis.ili2c.metamodel.ParameterAssignment;
import ch.interlis.ili2c.metamodel.ParameterValue;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAssocRole;
import ch.interlis.ili2c.metamodel.PlausibilityConstraint;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.RefSystemRef;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SetConstraint;
import ch.interlis.ili2c.metamodel.SignAttribute;
import ch.interlis.ili2c.metamodel.SignInstruction;
import ch.interlis.ili2c.metamodel.StructuredUnit;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UnionView;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

public class Interlis2Generator {
    IndentPrintWriter ipw;
    TransferDescription td;
    PredefinedModel modelInterlis;
    Unit anyUnit;
    boolean withPredefined;
    private boolean onlyLastFile;
    int numErrors = 0;
    private static final String FR = "fr";
    private static final String IT = "it";
    private static final String EN = "en";
    private static final String DE = "de";
    private ArrayList selfStandingConstraints = null;
    private ModelElements translationConfig;
    private TransformationParameter params = null;

    public static Interlis2Generator generateElements(Writer out, TransferDescription td) {
        return Interlis2Generator.generateElements(out, td, null);
    }

    public static Interlis2Generator generateElements(Writer out, TransferDescription td, ModelElements modelElements) {
        Interlis2Generator i = new Interlis2Generator();
        i.setup(out, td, false, false, modelElements, null);
        return i;
    }

    public static String debugToString(TransferDescription td, Element ele) {
        StringWriter syntaxBuffer = new StringWriter();
        Interlis2Generator makeSyntax = Interlis2Generator.generateElements(syntaxBuffer, td, null);
        makeSyntax.printElement(ele.getContainer(), null, ele, null);
        makeSyntax.ipw.flush();
        return syntaxBuffer.toString();
    }

    private void finish() {
        this.ipw.close();
    }

    protected void printError() {
        this.ipw.print(Element.makeErrorName(null));
        ++this.numErrors;
    }

    public int generate(Writer out, TransferDescription rd, boolean withPredefined) {
        this.setup(out, rd, withPredefined, false, null, null);
        this.printTransferDescription(rd, null);
        this.finish();
        return this.numErrors;
    }

    public int generateWithNewCrs(Writer out, TransferDescription rd, TransformationParameter params) {
        this.setup(out, rd, false, true, null, params);
        this.printTransferDescription(rd, null);
        this.finish();
        return this.numErrors;
    }

    public int generateWithNewLanguage(Writer out, TransferDescription td, ModelElements modelEles, String language) {
        this.setup(out, td, false, true, modelEles, null);
        this.printTransferDescription(td, language);
        this.finish();
        return this.numErrors;
    }

    private void setup(Writer out, TransferDescription td, boolean withPredefined, boolean onlyLastFile, ModelElements modelEles, TransformationParameter params) {
        this.ipw = new IndentPrintWriter(out);
        this.td = td;
        this.modelInterlis = td.INTERLIS;
        this.anyUnit = td.INTERLIS.ANYUNIT;
        this.withPredefined = withPredefined;
        this.translationConfig = modelEles;
        this.params = params;
        this.onlyLastFile = onlyLastFile;
    }

    private boolean printModifierHelper(boolean first, boolean flag, String what) {
        if (flag) {
            if (!first) {
                this.ipw.print(", ");
            }
            this.ipw.print(what);
            return false;
        }
        return first;
    }

    protected void printModifiers(boolean _abstract, boolean _final, boolean _extended, boolean _ordered, boolean _external, boolean _transient) {
        if (!(_abstract || _final || _extended || _ordered || _external || _transient)) {
            return;
        }
        boolean first = true;
        this.ipw.print(" (");
        first = this.printModifierHelper(first, _abstract, "ABSTRACT");
        first = this.printModifierHelper(first, _final, "FINAL");
        first = this.printModifierHelper(first, _extended, "EXTENDED");
        first = this.printModifierHelper(first, _ordered, "ORDERED");
        first = this.printModifierHelper(first, _external, "EXTERNAL");
        first = this.printModifierHelper(first, _transient, "TRANSIENT");
        this.ipw.print(')');
    }

    protected void printTopic(Topic topic, String language) {
        Iterator<Topic> it;
        Domain classOid;
        if (topic == null) {
            return;
        }
        this.selfStandingConstraints = new ArrayList();
        Topic extending = (Topic)topic.getExtending();
        this.printMetaValues(topic.getMetaValues(), language, topic.getScopedName());
        this.ipw.print("TOPIC ");
        if (language == null) {
            this.printDocumentation(topic.getDocumentation());
            this.ipw.print(topic.getName());
        } else {
            String name = this.getNameInLanguage(topic, language);
            if (name == "" || name == null) {
                this.ipw.print(topic.getName());
            } else {
                this.ipw.print(name);
            }
            String documentation = this.getDocumentationInLanguage(topic, language);
            if (documentation == "") {
                this.printDocumentation(topic.getDocumentation());
            } else {
                this.printDocumentation(documentation);
            }
        }
        this.printModifiers(topic.isAbstract(), topic.isFinal(), false, false, false, false);
        if (extending != null) {
            this.ipw.print(" EXTENDS ");
            this.ipw.print(extending.getScopedName(topic));
            if (language == null) {
                this.ipw.print(extending.getScopedName(topic));
            } else {
                String text = this.getNameInLanguage(topic, language);
                if (text == null) {
                    this.ipw.print(extending.getScopedName(topic));
                } else {
                    this.ipw.print(text);
                }
            }
        }
        this.ipw.println(" =");
        this.ipw.indent();
        Domain basketOid = topic.getBasketOid();
        if (basketOid != null) {
            this.ipw.print("BASKET OID AS ");
            this.ipw.print(basketOid.getScopedName(topic));
            this.ipw.println(';');
        }
        if ((classOid = topic.getOid()) != null) {
            this.ipw.print("OID AS ");
            this.ipw.print(classOid.getScopedName(topic));
            this.ipw.println(';');
        }
        if ((it = topic.getDependentOn()).hasNext()) {
            this.ipw.print("DEPENDS ON ");
            Topic firstTopic = it.next();
            if (language == null) {
                this.ipw.print(firstTopic.getScopedName(topic));
            } else {
                String dependentTopic = this.getNameInLanguage(firstTopic, language);
                if (dependentTopic == "" || dependentTopic == null) {
                    this.ipw.print(firstTopic.getScopedName(topic));
                } else {
                    String[] scopedName = firstTopic.getScopedName().split("\\.");
                    String concatenatedTopicName = this.getEnumerationElementNameInLanguage(scopedName[0], language) + "." + dependentTopic;
                    this.ipw.print(concatenatedTopicName);
                }
            }
            while (it.hasNext()) {
                this.ipw.print(", ");
                Topic secondTopic = it.next();
                if (language == null || language == "") {
                    this.ipw.print(secondTopic.getScopedName(topic));
                    continue;
                }
                String dependentTopic = this.getNameInLanguage(secondTopic, language);
                if (dependentTopic == "") {
                    this.ipw.print(secondTopic.getScopedName(topic));
                    continue;
                }
                String[] scopedName = secondTopic.getScopedName().split("\\.");
                String concatenatedTopicName = this.getEnumerationElementNameInLanguage(scopedName[0], language) + "." + dependentTopic;
                this.ipw.print(concatenatedTopicName);
            }
            this.ipw.println(';');
            this.ipw.println();
        }
        this.printElements(topic, language);
        Iterator csi = this.selfStandingConstraints.iterator();
        Viewable view = null;
        Viewable lastView = null;
        while (csi.hasNext()) {
            Constraint cs = (Constraint)csi.next();
            view = (Viewable)cs.getContainer();
            if (view != lastView) {
                if (lastView != null) {
                    this.ipw.unindent();
                    this.ipw.println("END;");
                } else {
                    this.ipw.println();
                }
                lastView = view;
                this.ipw.print("CONSTRAINTS OF ");
                if (language == null) {
                    this.ipw.print(view.getName());
                } else {
                    String name = this.getNameInLanguage(view, language);
                    if (name == null || name == "") {
                        this.ipw.print(view.getName());
                    } else {
                        this.ipw.print(name);
                    }
                }
                this.ipw.println('=');
                this.ipw.indent();
            }
            this.printConstraint(cs, language);
        }
        if (lastView != null) {
            this.ipw.unindent();
            this.ipw.println("END;");
        }
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print("END ");
        if (language == null) {
            this.ipw.print(topic.getName());
        } else {
            String name = this.getNameInLanguage(topic, language);
            if (name == null || name == "") {
                this.ipw.print(topic.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.ipw.println(';');
    }

    protected void printAbstractClassDef(AbstractClassDef def, String language) {
        String keyword;
        if (language == null) {
            this.printDocumentation(def.getDocumentation());
        } else {
            String documentation = this.getDocumentationInLanguage(def, language);
            if (documentation == "" || documentation == null) {
                this.printDocumentation(def.getDocumentation());
            } else {
                this.printDocumentation(documentation);
            }
        }
        this.printMetaValues(def.getMetaValues(), language, def.getScopedName());
        if (def instanceof Table) {
            Table tdef = (Table)def;
            keyword = tdef.isIdentifiable() ? "CLASS" : "STRUCTURE";
        } else if (def instanceof AssociationDef) {
            keyword = "ASSOCIATION";
        } else {
            throw new IllegalArgumentException();
        }
        this.printStart(keyword, def, null, language);
        this.ipw.println(" =");
        this.ipw.indent();
        Domain oid = def.getDefinedOid();
        if (oid != null) {
            if (oid instanceof NoOid) {
                this.ipw.println("NO OID;");
            } else {
                this.ipw.print("OID AS ");
                this.ipw.print(oid.getScopedName(def.getContainer()));
                this.ipw.println(";");
            }
        }
        this.printElements(def, language);
        this.printEnd(def, language);
    }

    private void printRenamedViewableRef(Container scope, ViewableAlias ref, String language) {
        if (ref == null) {
            this.printError();
            return;
        }
        String name = ref.getName();
        Viewable v = ref.getAliasing();
        if (name == null || v == null) {
            this.printError();
            return;
        }
        if (!name.equals(v.getName())) {
            this.ipw.print(name);
            this.ipw.print('~');
        }
        this.ipw.print(v.getScopedName(scope));
    }

    protected void printRenamedViewableRefs(Container scope, ViewableAlias[] refs, String language) {
        if (refs == null || refs.length == 0) {
            return;
        }
        this.printRenamedViewableRef(scope, refs[0], language);
        for (int i = 1; i < refs.length; ++i) {
            this.ipw.print(", ");
            this.printRenamedViewableRef(scope, refs[i], language);
        }
    }

    protected void printStart(String keyword, ExtendableContainer ec, Viewable basedOn, String language) {
        if (ec == null) {
            return;
        }
        ExtendableContainer extending = (ExtendableContainer)ec.getExtending();
        boolean extendingSameName = false;
        if (extending != null) {
            Topic myTopic = (Topic)ec.getContainer(Topic.class);
            Topic extendedTopic = (Topic)extending.getContainer(Topic.class);
            if (myTopic != null && extendedTopic != null && myTopic.isExtending(extendedTopic) && ec.getName().equals(extending.getName())) {
                extendingSameName = true;
            }
        }
        this.ipw.print(keyword);
        this.ipw.print(' ');
        if (language == null) {
            this.ipw.print(ec.getName());
        } else {
            String name = this.getNameInLanguage(ec, language);
            if (name == "" || name == null) {
                this.ipw.print(ec.getName());
            } else {
                this.ipw.print(name);
            }
        }
        boolean _transient = false;
        if (ec instanceof View) {
            _transient = ((View)ec).isTransient();
        }
        this.printModifiers(ec.isAbstract(), ec.isFinal(), extendingSameName, false, false, _transient);
        if (extending != null && !extendingSameName) {
            this.ipw.print(" EXTENDS ");
            if (language == null) {
                this.ipw.print(extending.getScopedName(ec.getContainer(Element.class)));
            } else {
                String text = this.getEnumerationElementNameInLanguage(extending.getScopedName(), language);
                if (text == null || text == "") {
                    this.ipw.print(extending.getScopedName(ec.getContainer(Element.class)));
                } else {
                    this.ipw.print(text);
                }
            }
        }
        if (basedOn != null) {
            this.ipw.print(" BASED ON ");
            this.ipw.print(basedOn.getScopedName((Container)ec.getContainer(Element.class)));
        }
    }

    protected void printEnd(ExtendableContainer ec, String language) {
        if (ec == null) {
            return;
        }
        this.ipw.unindent();
        this.ipw.print("END ");
        if (language == null) {
            this.ipw.print(ec.getName());
        } else {
            String name = this.getNameInLanguage(ec, language);
            if (name == null || name == "") {
                this.ipw.print(ec.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.ipw.println(';');
    }

    public void printView(View view) {
        this.printView(view, null);
    }

    public void printView(View view, String language) {
        this.printView(view, false, language);
    }

    public void printView(View view, boolean suppressDoc) {
        this.printView(view, suppressDoc, null);
    }

    public void printView(View view, boolean suppressDoc, String language) {
        if (!suppressDoc) {
            if (language == null) {
                this.printDocumentation(view.getDocumentation());
            } else {
                String docu = this.getDocumentationInLanguage(view, language);
                if (docu == null || docu == "") {
                    this.printDocumentation(view.getDocumentation());
                } else {
                    this.printDocumentation(docu);
                }
            }
            this.printMetaValues(view.getMetaValues(), language, view.getScopedName());
        }
        this.printStart("VIEW", view, null, language);
        this.ipw.println("");
        this.ipw.indent();
        if (view instanceof Projection) {
            this.ipw.print("PROJECTION OF ");
            if (language == null) {
                this.ipw.print(((Projection)view).getSelected().getAliasing().getScopedName((Container)view));
            } else {
                String name = this.getNameInLanguage(((Projection)view).getSelected().getAliasing(), language);
                if (name == null || name == "") {
                    this.ipw.print(((Projection)view).getSelected().getAliasing().getScopedName((Container)view));
                } else {
                    ViewableAlias selected = ((Projection)view).getSelected();
                    String scopedName = view.getScopedName() + "." + selected.getName();
                    String selectedElement = this.getEnumerationElementNameInLanguage(scopedName, language);
                    if (selectedElement == null || selectedElement == "") {
                        this.ipw.print(name);
                    } else {
                        this.ipw.print(selectedElement + "~" + name);
                    }
                }
            }
        } else if (view instanceof JoinView) {
            this.ipw.print("JOIN OF ");
            this.printRenamedViewableRefs(view, ((JoinView)view).getJoining(), language);
        } else if (view instanceof UnionView) {
            this.ipw.print("UNION OF ");
            this.printRenamedViewableRefs(view, ((UnionView)view).getUnited(), language);
        } else if (view instanceof DecompositionView) {
            Object decomposedViewable = null;
            ObjectPath decomposedAttribute = ((DecompositionView)view).getDecomposedAttribute();
            if (((DecompositionView)view).isAreaDecomposition()) {
                this.ipw.print("AREA ");
            }
            this.ipw.print("DECOMPOSITION OF ");
            if (decomposedAttribute == null) {
                this.printError();
            }
        } else {
            this.printError();
            this.ipw.println("<unknown view type>");
        }
        this.ipw.println("; =");
        this.printElements(view, language);
        this.printEnd(view, language);
    }

    public void printGraphic(Graphic graph) {
        this.printGraphic(graph, null);
    }

    public void printGraphic(Graphic graph, String language) {
        this.printGraphic(graph, false, language);
    }

    public void printGraphic(Graphic graph, boolean suppressDoc) {
        this.printGraphic(graph, suppressDoc, null);
    }

    public void printGraphic(Graphic graph, boolean suppressDoc, String language) {
        if (graph == null) {
            return;
        }
        if (!suppressDoc) {
            this.printDocumentation(graph.getDocumentation());
            this.printMetaValues(graph.getMetaValues(), language, graph.getScopedName());
        }
        this.printStart("GRAPHIC", graph, graph.getBasedOn(), language);
        this.ipw.println(" =");
        this.ipw.indent();
        this.printElements(graph, language);
        this.printEnd(graph, language);
    }

    protected int getExpressionPrecedence(Evaluable ev) {
        if (ev instanceof Expression.Disjunction) {
            return 1;
        }
        if (ev instanceof Expression.Conjunction) {
            return 2;
        }
        if (ev instanceof Expression.Negation) {
            return 4;
        }
        if (ev instanceof Expression.Equality || ev instanceof Expression.Inequality || ev instanceof Expression.LessThanOrEqual || ev instanceof Expression.LessThan || ev instanceof Expression.GreaterThanOrEqual || ev instanceof Expression.GreaterThan) {
            return 5;
        }
        if (ev instanceof Expression.DefinedCheck) {
            return 7;
        }
        return 8;
    }

    protected void printExpression(Container scope, Evaluable expr, String language) {
        this.printExpression(scope, expr, 1, language);
    }

    protected void printExpression(Container scope, Evaluable expr, int precedence, String language) {
        int exprPrec = this.getExpressionPrecedence(expr);
        if (exprPrec < precedence) {
            this.ipw.print('(');
            this.printExpression(scope, expr, 1, language);
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ObjectPath) {
            this.printAttributePath(scope, (ObjectPath)expr, language);
            return;
        }
        if (expr instanceof Constant.Undefined) {
            this.ipw.print("UNDEFINED");
            return;
        }
        if (expr instanceof Constant.Numeric) {
            Constant.Numeric cnum = (Constant.Numeric)expr;
            this.ipw.print((Object)cnum.getValue());
            if (cnum.getUnit() != null) {
                this.ipw.print('[');
                this.printRef(scope, cnum.getUnit(), language);
                this.ipw.print(']');
            }
            return;
        }
        if (expr instanceof Constant.Text) {
            this.ipw.print('\"');
            this.ipw.print(((Constant.Text)expr).getValue());
            this.ipw.print('\"');
            return;
        }
        if (expr instanceof Constant.AttributePath) {
            this.ipw.print(">>");
            if (language == null) {
                this.ipw.print(((Constant.AttributePath)expr).getValue().getName());
            } else {
                String name = this.getNameInLanguage(((Constant.AttributePath)expr).getValue(), language);
                if (name != null && name != "") {
                    this.ipw.print(name);
                }
            }
            return;
        }
        if (expr instanceof Constant.Enumeration) {
            this.ipw.print('#');
            String[] val = ((Constant.Enumeration)expr).getValue();
            if (val == null) {
                this.printError();
            } else {
                for (int i = 0; i < val.length; ++i) {
                    if (i > 0) {
                        this.ipw.print('.');
                    }
                    if (val[i] == null) {
                        this.printError();
                        continue;
                    }
                    this.ipw.print(val[i]);
                }
            }
            return;
        }
        if (expr instanceof Constant.ReferenceToMetaObject) {
            MetaObject refMO = ((Constant.ReferenceToMetaObject)expr).getReferred();
            this.ipw.print('\"');
            if (refMO != null) {
                if (language == null) {
                    this.ipw.print(refMO.getName());
                } else {
                    String name = this.getNameInLanguage(refMO, language);
                    if (name == null || name == "") {
                        this.ipw.print(refMO.getName());
                    } else {
                        this.ipw.print(name);
                    }
                }
            } else {
                this.printError();
            }
            this.ipw.print('\"');
            return;
        }
        if (expr instanceof Constant.Structured) {
            String val = ((Constant.Structured)expr).toString();
            if (val == null) {
                this.printError();
            } else {
                this.ipw.print(val);
            }
            return;
        }
        if (expr instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)expr;
            this.printRef(scope, f.getFunction(), language);
            this.ipw.print(" (");
            Evaluable[] args = f.getArguments();
            if (args == null) {
                this.printError();
            } else {
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    this.printExpression(scope, args[i], language);
                }
            }
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ParameterValue) {
            this.ipw.print("PARAMETER ");
            this.printRef(scope, ((ParameterValue)expr).getParameter(), language);
            return;
        }
        if (expr instanceof Expression.Disjunction) {
            Evaluable[] disjoined = ((Expression.Disjunction)expr).getDisjoined();
            for (int i = 0; i < disjoined.length; ++i) {
                if (i > 0) {
                    this.ipw.print(" OR ");
                }
                this.printExpression(scope, disjoined[i], 2, language);
            }
            return;
        }
        if (expr instanceof Expression.Conjunction) {
            Evaluable[] conjoined = ((Expression.Conjunction)expr).getConjoined();
            for (int i = 0; i < conjoined.length; ++i) {
                if (i > 0) {
                    this.ipw.print(" AND ");
                }
                this.printExpression(scope, conjoined[i], 3, language);
            }
            return;
        }
        if (expr instanceof Expression.Negation) {
            this.ipw.print("NOT (");
            this.printExpression(scope, ((Expression.Negation)expr).getNegated(), 5, language);
            this.ipw.print(")");
            return;
        }
        if (expr instanceof Expression.Equality) {
            this.printExpression(scope, ((Expression.Equality)expr).getLeft(), 6, language);
            this.ipw.print(" == ");
            this.printExpression(scope, ((Expression.Equality)expr).getRight(), 6, language);
            return;
        }
        if (expr instanceof Expression.Inequality) {
            this.printExpression(scope, ((Expression.Inequality)expr).getLeft(), 6, language);
            this.ipw.print(" <> ");
            this.printExpression(scope, ((Expression.Inequality)expr).getRight(), 6, language);
            return;
        }
        if (expr instanceof Expression.LessThanOrEqual) {
            this.printExpression(scope, ((Expression.LessThanOrEqual)expr).getLeft(), 6, language);
            this.ipw.print(" <= ");
            this.printExpression(scope, ((Expression.LessThanOrEqual)expr).getRight(), 6, language);
            return;
        }
        if (expr instanceof Expression.GreaterThanOrEqual) {
            this.printExpression(scope, ((Expression.GreaterThanOrEqual)expr).getLeft(), 6, language);
            this.ipw.print(" >= ");
            this.printExpression(scope, ((Expression.GreaterThanOrEqual)expr).getRight(), 6, language);
            return;
        }
        if (expr instanceof Expression.LessThan) {
            this.printExpression(scope, ((Expression.LessThan)expr).getLeft(), 6, language);
            this.ipw.print(" < ");
            this.printExpression(scope, ((Expression.LessThan)expr).getRight(), 6, language);
            return;
        }
        if (expr instanceof Expression.GreaterThan) {
            this.printExpression(scope, ((Expression.GreaterThan)expr).getLeft(), 6, language);
            this.ipw.print(" > ");
            this.printExpression(scope, ((Expression.GreaterThan)expr).getRight(), 6, language);
            return;
        }
        if (expr instanceof Expression.DefinedCheck) {
            this.ipw.print("DEFINED (");
            this.printExpression(scope, ((Expression.DefinedCheck)expr).getArgument(), 7, language);
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ConditionalExpression) {
            ConditionalExpression.Condition[] conds = ((ConditionalExpression)expr).getConditions();
            this.ipw.print("WITH ");
            this.printAttributePath(scope, ((ConditionalExpression)expr).getAttribute(), language);
            this.ipw.println(" (");
            this.ipw.indent();
            if (conds == null) {
                this.printError();
            } else {
                for (int i = 0; i < conds.length; ++i) {
                    if (i != 0) {
                        this.ipw.println(",");
                    }
                    if (conds[i] == null) {
                        this.printError();
                        continue;
                    }
                    this.printExpression(scope, conds[i].getValue(), language);
                    this.ipw.print(" WHEN IN ");
                    this.printExpression(scope, conds[i].getCondition(), language);
                }
            }
            this.ipw.unindent();
            this.ipw.print(')');
            return;
        }
        this.printError();
    }

    protected void printExistenceConstraint(Viewable forTable, ExistenceConstraint ec, String language) {
        this.ipw.print("EXISTENCE CONSTRAINT ");
        ObjectPath attr = ec.getRestrictedAttribute();
        this.printAttributePath(forTable, attr, language);
        this.ipw.print(" REQUIRED IN ");
        Iterator<ObjectPath> reqi = ec.iteratorRequiredIn();
        String next = "";
        while (reqi.hasNext()) {
            ObjectPath req = reqi.next();
            this.ipw.print(next);
            next = " OR ";
            this.printRef(forTable, req.getRoot(), language);
            this.ipw.print(":");
            this.printAttributePath(forTable, req, language);
        }
        this.ipw.println(';');
    }

    protected void printSetConstraint(Viewable forTable, SetConstraint ec, String language) {
        this.ipw.print("SET CONSTRAINT");
        if (ec.getPreCondition() != null) {
            this.ipw.print(" WHERE ");
            this.printExpression(forTable, ec.getPreCondition(), language);
            this.ipw.println(": ");
        } else {
            this.ipw.println("");
        }
        this.ipw.indent();
        this.printExpression(forTable, ec.getCondition(), language);
        this.ipw.println(';');
        this.ipw.unindent();
    }

    protected void printUniquenessConstraint(Viewable forTable, UniquenessConstraint uc, String language) {
        UniqueEl uel = uc.getElements();
        Iterator<ObjectPath> pathi = uel.iteratorAttribute();
        if (uc.getLocal()) {
            this.ipw.print("UNIQUE (LOCAL) ");
            ObjectPath prefix = uc.getPrefix();
            this.printAttributePath(forTable, prefix, language);
            String next = ": ";
            while (pathi.hasNext()) {
                ObjectPath path = pathi.next();
                this.ipw.print(next);
                next = ", ";
                this.printAttributePath(forTable, path, language);
            }
        } else {
            this.printMetaValues(uc.getMetaValues(), language, uc.getScopedName());
            this.ipw.print("UNIQUE");
            String next = " ";
            while (pathi.hasNext()) {
                ObjectPath path = pathi.next();
                this.ipw.print(next);
                next = ", ";
                this.printAttributePath(forTable, path, language);
            }
        }
        this.ipw.println(';');
    }

    public void printConstraint(Constraint elt) {
        this.printConstraint(elt, null);
    }

    public void printConstraint(Constraint elt, String language) {
        this.printConstraint(elt, false, language);
    }

    public void printConstraint(Constraint elt, boolean suppressDoc) {
        this.printConstraint(elt, suppressDoc, null);
    }

    public void printConstraint(Constraint elt, boolean suppressDoc, String language) {
        if (suppressDoc) {
            this.printDocumentation(elt.getDocumentation());
            this.printMetaValues(elt.getMetaValues(), language, elt.getScopedName());
        }
        Container container = elt.getContainer();
        if (elt instanceof MandatoryConstraint) {
            this.ipw.println("MANDATORY CONSTRAINT");
            this.ipw.indent();
            this.printExpression(container, ((MandatoryConstraint)elt).getCondition(), language);
            this.ipw.println(';');
            this.ipw.unindent();
        } else if (elt instanceof PlausibilityConstraint) {
            PlausibilityConstraint pc = (PlausibilityConstraint)elt;
            this.ipw.print("CONSTRAINT ");
            if (pc.getDirection() == 0) {
                this.ipw.print(" >= ");
            } else {
                this.ipw.print(" <= ");
            }
            this.ipw.print(pc.getPercentage());
            this.ipw.println('%');
            this.ipw.indent();
            this.printExpression(container, pc.getCondition(), language);
            this.ipw.println(';');
            this.ipw.unindent();
        } else if (elt instanceof UniquenessConstraint) {
            UniquenessConstraint uc = (UniquenessConstraint)elt;
            this.printUniquenessConstraint((Viewable)container, uc, language);
        } else if (elt instanceof ExistenceConstraint) {
            this.printExistenceConstraint((Viewable)container, (ExistenceConstraint)elt, language);
        } else if (elt instanceof SetConstraint) {
            this.printSetConstraint((Viewable)container, (SetConstraint)elt, language);
        }
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp) {
        this.printGraphicParameterDef(gfxp, null);
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp, String language) {
        this.printGraphicParameterDef(gfxp, false, language);
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp, boolean suppressDoc) {
        this.printGraphicParameterDef(gfxp, suppressDoc, null);
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp, boolean suppressDoc, String language) {
        if (!suppressDoc) {
            if (language == null) {
                this.printDocumentation(gfxp.getDocumentation());
            } else {
                String docu = this.getDocumentationInLanguage(gfxp, language);
                if (docu == null || docu == "") {
                    this.printDocumentation(gfxp.getDocumentation());
                } else {
                    this.printDocumentation(docu);
                }
            }
            this.printMetaValues(gfxp.getMetaValues(), language, gfxp.getScopedName());
        }
        String scopedNamePrefix = gfxp.getScopedName();
        if (language == null) {
            this.ipw.print(gfxp.getName());
        } else {
            String name = this.getNameInLanguage(gfxp, language);
            if (name == null || name == "") {
                this.ipw.print(gfxp.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.ipw.print(" : ");
        this.printType(gfxp.getContainer(), gfxp.getDomain(), language, scopedNamePrefix);
        this.ipw.println(";");
    }

    public void printMetaDataUseDef(MetaDataUseDef mu) {
        this.printMetaDataUseDef(mu, null);
    }

    public void printMetaDataUseDef(MetaDataUseDef mu, String language) {
        this.printMetaDataUseDef(mu, false, language);
    }

    public void printMetaDataUseDef(MetaDataUseDef mu, boolean suppressDoc) {
        this.printMetaDataUseDef(mu, suppressDoc, null);
    }

    public void printMetaDataUseDef(MetaDataUseDef mu, boolean suppressDoc, String language) {
        String name;
        if (!suppressDoc) {
            if (language == null) {
                this.printDocumentation(mu.getDocumentation());
            } else {
                String docu = this.getDocumentationInLanguage(mu, language);
                if (docu == null || docu == "") {
                    this.printDocumentation(mu.getDocumentation());
                } else {
                    this.printDocumentation(docu);
                }
            }
            this.printMetaValues(mu.getMetaValues(), language, mu.getScopedName());
        }
        if (mu.isSignData()) {
            this.ipw.print("SIGN BASKET ");
        } else {
            this.ipw.print("REFSYSTEM BASKET ");
        }
        if (language == null) {
            this.ipw.print(mu.getName());
        } else {
            String name2 = this.getNameInLanguage(mu, language);
            if (name2 == null || name2 == "") {
                this.ipw.print(mu.getName());
            } else {
                this.ipw.print(name2);
            }
        }
        this.printModifiers(false, mu.isFinal(), false, false, false, false);
        Topic topic = mu.getTopic();
        this.ipw.print("~");
        if (language == null) {
            this.ipw.print(topic.getContainer().getName());
        } else {
            name = this.getEnumerationElementNameInLanguage(topic.getContainer().getScopedName(), language);
            if (name == null || name == "") {
                this.ipw.print(topic.getContainer().getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.ipw.print(".");
        if (language == null) {
            this.ipw.print(topic.getName());
        } else {
            name = this.getNameInLanguage(topic, language);
            if (name == null || name == "") {
                this.ipw.print(topic.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.ipw.indent();
        this.ipw.indent();
        Table lastTable = null;
        String sep = "";
        for (Object moo : mu) {
            String name3;
            if (!(moo instanceof MetaObject)) continue;
            MetaObject mo = (MetaObject)moo;
            Table table = mo.getTable();
            if (table != lastTable) {
                this.ipw.println();
                this.ipw.unindent();
                this.ipw.print("OBJECTS OF ");
                if (language == null) {
                    this.ipw.print(table.getName());
                } else {
                    name3 = this.getNameInLanguage(table, language);
                    if (name3 == null || name3 == "") {
                        this.ipw.print(table.getName());
                    } else {
                        this.ipw.print(name3);
                    }
                }
                this.ipw.println(":");
                this.ipw.indent();
                lastTable = table;
            } else {
                this.ipw.println(",");
            }
            if (language == null) {
                this.printDocumentation(mo.getDocumentation());
            } else {
                String docu = this.getDocumentationInLanguage(mo, language);
                if (docu == null || docu == "") {
                    this.printDocumentation(mo.getDocumentation());
                } else {
                    this.printDocumentation(docu);
                }
            }
            this.printMetaValues(mo.getMetaValues(), language, mo.getScopedName());
            if (language == null) {
                this.ipw.print(mo.getName());
                continue;
            }
            name3 = this.getNameInLanguage(mo, language);
            if (name3 == null || name3 == "") {
                this.ipw.print(mo.getName());
                continue;
            }
            this.ipw.print(name3);
        }
        this.ipw.println(";");
        this.ipw.unindent();
        this.ipw.unindent();
    }

    public void printUnit(Container scope, Unit u) {
        this.printUnit(scope, u, null);
    }

    public void printUnit(Container scope, Unit u, String language) {
        this.printUnit(scope, u, false, language);
    }

    public void printUnit(Container scope, Unit u, boolean suppressDoc) {
        this.printUnit(scope, u, suppressDoc, null);
    }

    public void printUnit(Container scope, Unit u, boolean suppressDoc, String language) {
        if (u == null) {
            this.printError();
            return;
        }
        Unit extending = (Unit)u.getExtending();
        if (!suppressDoc) {
            if (language == null) {
                this.printDocumentation(u.getDocumentation());
            } else {
                String docu = this.getDocumentationInLanguage(u, language);
                if (docu == null || docu == "") {
                    this.printDocumentation(u.getDocumentation());
                } else {
                    this.printDocumentation(docu);
                }
            }
            this.printMetaValues(u.getMetaValues(), language, u.getScopedName());
        }
        this.ipw.print(u.getDocName());
        if (!u.getDocName().equals(u.getName())) {
            this.ipw.print(" [");
            if (language == null) {
                this.ipw.print(u.getName());
            } else {
                String value = this.getNameInLanguage(u, language);
                if (value == null || value == "") {
                    this.ipw.print(u.getName());
                } else {
                    this.ipw.print(value);
                }
            }
            this.ipw.print(']');
        }
        this.printModifiers(u.isAbstract(), false, false, false, false, false);
        if (extending != null && extending != this.anyUnit && !(u instanceof DerivedUnit)) {
            this.ipw.print(" EXTENDS ");
            if (language == null) {
                this.ipw.print(extending.getScopedName(scope));
            } else {
                String text = this.getEnumerationElementNameInLanguage(extending.getScopedName(), language);
                if (text == null) {
                    this.ipw.print(extending.getScopedName(scope));
                } else {
                    this.ipw.print(text);
                }
            }
        }
        if (u instanceof NumericallyDerivedUnit) {
            NumericallyDerivedUnit.Factor[] factors = ((NumericallyDerivedUnit)u).getConversionFactors();
            this.ipw.print(" =");
            if (factors.length >= 1) {
                for (int i = 0; i < factors.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(' ');
                        this.ipw.print(factors[i].getConversionOperator());
                    }
                    this.ipw.print(' ');
                    this.printNumericConst(factors[i].getConversionFactor());
                }
            }
            this.ipw.print(" [");
            this.printRef(scope, ((NumericallyDerivedUnit)u).getExtending(), language);
            this.ipw.print(']');
        } else if (u instanceof FunctionallyDerivedUnit) {
            this.ipw.print(" = FUNCTION ");
            this.printExplanation(((FunctionallyDerivedUnit)u).getExplanation());
            this.ipw.print(" [");
            this.printRef(scope, ((FunctionallyDerivedUnit)u).getExtending(), language);
            this.ipw.print(']');
        } else if (u instanceof ComposedUnit) {
            ComposedUnit.Composed[] composed = ((ComposedUnit)u).getComposedUnits();
            this.ipw.print(" = (");
            for (int i = 0; i < composed.length; ++i) {
                if (i > 0) {
                    this.ipw.print(' ');
                    this.ipw.print(composed[i].getCompositionOperator());
                    this.ipw.print(' ');
                }
                this.printRef(scope, composed[i].getUnit(), language);
            }
            this.ipw.print(')');
        } else if (u instanceof StructuredUnit) {
            StructuredUnit.Part[] parts = ((StructuredUnit)u).getParts();
            this.ipw.print(" = {");
            this.printRef(scope, ((StructuredUnit)u).getFirstUnit(), language);
            for (int i = 0; i < parts.length; ++i) {
                this.ipw.print(':');
                this.printRef(scope, parts[i].getUnit(), language);
                this.ipw.print('[');
                this.ipw.print((Object)parts[i].getMinimum());
                this.ipw.print("..");
                this.ipw.print((Object)parts[i].getMaximum());
                this.ipw.print(']');
            }
            this.ipw.print('}');
            if (((StructuredUnit)u).isContinuous()) {
                this.ipw.print(" CONTINUOUS");
            }
        }
        if (u instanceof StructuredUnit) {
            EhiLogger.logError((String)("UNIT " + u.getName() + ": StructuredUnit not supported by INTERLIS 2.3"));
            this.ipw.println("; !! Hint: comment out/remove");
        } else {
            this.ipw.println(';');
        }
    }

    protected void printRef(Container scope, Element elt, String language) {
        if (elt == null) {
            this.printError();
        } else if (elt == this.modelInterlis.ANYCLASS) {
            this.ipw.print("ANYCLASS");
        } else if (elt == this.modelInterlis.ANYSTRUCTURE) {
            this.ipw.print("ANYSTRUCTURE");
        } else if (language == null) {
            if (this.params != null && this.params.getImportModels() != null) {
                TransformationParameter.ModelTransformation[] importModels;
                for (TransformationParameter.ModelTransformation importModel : importModels = this.params.getImportModels()) {
                    if (elt.getScopedName(scope).contains(importModel.getFromModel())) {
                        String[] scopeName;
                        String newScopeName = "";
                        for (String scopeN : scopeName = elt.getScopedName(scope).split("\\.")) {
                            newScopeName = scopeN.equals(importModel.getFromModel()) ? importModel.getToModel() : newScopeName + "." + scopeN;
                        }
                        this.ipw.print(newScopeName);
                        continue;
                    }
                    this.ipw.print(elt.getScopedName(scope));
                }
            } else {
                this.ipw.print(elt.getScopedName(scope));
            }
        } else {
            String text = this.getNameInLanguage(elt, language);
            if (text == "" || text == null) {
                this.ipw.print(elt.getScopedName(scope));
            } else {
                this.ipw.print(text);
            }
        }
    }

    public void printParameter(Container scope, Parameter par) {
        this.printParameter(scope, par, null);
    }

    public void printParameter(Container scope, Parameter par, String language) {
        this.printParameter(scope, par, false, language);
    }

    public void printParameter(Container scope, Parameter par, boolean suppressDoc) {
        this.printParameter(scope, par, suppressDoc, null);
    }

    public void printParameter(Container scope, Parameter par, boolean suppressDoc, String language) {
        String scopedNamePrefix = "";
        if (par == null) {
            this.printError();
            return;
        }
        if (!suppressDoc) {
            if (language == null) {
                this.printDocumentation(par.getDocumentation());
                this.printMetaValues(par.getMetaValues(), language, par.getScopedName());
            } else {
                String docu = this.getDocumentationInLanguage(scope, language);
                if (docu == "" || docu == null) {
                    this.printDocumentation(par.getDocumentation());
                } else {
                    this.printDocumentation(docu);
                }
                this.printMetaValues(par.getMetaValues(), language, par.getScopedName());
            }
        }
        if (language == null) {
            this.ipw.print(par.getName());
        } else {
            String name = this.getNameInLanguage(par, language);
            if (name == "" || name == null) {
                this.ipw.print(par.getName());
            } else {
                this.ipw.print(name);
            }
        }
        Parameter ext = par.getExtending();
        if (ext != null) {
            if (par.getName().equals(ext.getName())) {
                this.ipw.print(" (EXTENDED)");
            } else {
                this.ipw.print(" EXTENDS ");
                this.printRef(scope, ext, language);
            }
        }
        this.ipw.print(": ");
        Type typ = par.getType();
        if (typ instanceof ReferenceType) {
            this.ipw.print("-> ");
            this.printRef(scope, ((ReferenceType)typ).getReferred(), language);
        } else {
            scopedNamePrefix = typ.getScopedName();
        }
        this.printType(scope, typ, language, scopedNamePrefix);
        this.ipw.println(';');
    }

    private void printNumericConst(PrecisionDecimal num) {
        if (num == PrecisionDecimal.PI) {
            this.ipw.print("PI");
            return;
        }
        if (num == PrecisionDecimal.LNBASE) {
            this.ipw.print("LNBASE");
            return;
        }
        this.ipw.print(num.toString());
    }

    protected void printRoleDef(Container scope, RoleDef role, String language) {
        if (language == null) {
            this.printDocumentation(role.getDocumentation());
            this.printMetaValues(role.getMetaValues(), language, role.getScopedName());
            this.ipw.print(role.getName());
        } else {
            String docu = this.getDocumentationInLanguage(scope, language);
            if (docu == null || docu == "") {
                this.printDocumentation(role.getDocumentation());
            } else {
                this.printDocumentation(docu);
            }
            this.printMetaValues(role.getMetaValues(), language, role.getScopedName());
            String name = this.getNameInLanguage(role, language);
            if (name == null || name == "") {
                this.ipw.print(role.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.printModifiers(role.isAbstract(), role.isFinal(), role.isExtended(), role.isOrdered(), role.isExternal(), false);
        String kind = "";
        switch (role.getKind()) {
            case 1: {
                kind = " -- ";
                break;
            }
            case 2: {
                kind = " -<> ";
                break;
            }
            case 3: {
                kind = " -<#> ";
            }
        }
        this.ipw.print(kind);
        if (role.getDefinedCardinality() != null) {
            this.ipw.print(role.getDefinedCardinality() + " ");
        }
        this.printRef(scope, role.getDestination(), language);
        Iterator<AbstractClassDef> resti = role.getReference().iteratorRestrictedTo();
        String sep = " RESTRICTION (";
        boolean hasRestriction = false;
        while (resti.hasNext()) {
            AbstractClassDef rest = resti.next();
            this.ipw.print(sep);
            sep = ";";
            this.printRef(scope, rest, language);
            hasRestriction = true;
        }
        if (hasRestriction) {
            this.ipw.print(")");
        }
        this.ipw.println(';');
    }

    protected void printAttribute(Container scope, AttributeDef attrib, String language) {
        LocalAttribute la;
        String value;
        LocalAttribute la2;
        if (attrib == null) {
            this.printError();
            return;
        }
        if (attrib instanceof LocalAttribute && (la2 = (LocalAttribute)attrib).isGeneratedByAllOf()) {
            return;
        }
        Type proxyType = attrib.getDomain();
        if (proxyType != null && proxyType instanceof ObjectType) {
            if (((ObjectType)proxyType).isAllOf()) {
                if (language == null) {
                    this.ipw.println("ALL OF " + attrib.getName() + ";");
                } else {
                    String name = this.getNameInLanguage(attrib, language);
                    if (name == null || name == "") {
                        this.ipw.println("ALL OF " + attrib.getName() + ";");
                    } else {
                        this.ipw.println("ALL OF " + name + ";");
                    }
                }
            }
            return;
        }
        if (language == null) {
            this.printDocumentation(attrib.getDocumentation());
        } else {
            value = this.getDocumentationInLanguage(attrib, language);
            if (value == "" || value == null) {
                this.printDocumentation(attrib.getDocumentation());
            } else {
                this.printDocumentation(value);
            }
        }
        this.printMetaValues(attrib.getMetaValues(), language, attrib.getScopedName());
        if (attrib instanceof LocalAttribute && (la = (LocalAttribute)attrib).isSubdivision()) {
            if (la.isContinuous()) {
                this.ipw.print("CONTINUOUS ");
            }
            this.ipw.print("SUBDIVISION ");
        }
        if (language == null) {
            this.ipw.print(attrib.getName());
        } else {
            value = this.getNameInLanguage(attrib, language);
            if (value == "" || value == null) {
                this.ipw.print(attrib.getName());
            } else {
                this.ipw.print(value);
            }
        }
        this.printModifiers(attrib.isAbstract(), attrib.isFinal(), attrib.getExtending() != null, false, false, attrib.isTransient());
        if (attrib instanceof LocalAttribute) {
            if (attrib.getDomain() != null || !(scope instanceof View)) {
                this.ipw.print(" : ");
                String scopedNamePrefix = attrib.getScopedName();
                this.printType(scope, attrib.getDomain(), language, scopedNamePrefix);
            }
            this.printAttributeBasePath(scope, attrib, language);
        }
        if (attrib instanceof LocalAttribute && attrib.getDomain() instanceof StructuredUnitType) {
            EhiLogger.logError((String)("ATTRIBUTE " + attrib.getScopedName(null) + ": StructuredUnitType not supported by INTERLIS 2.3; replace by TextType or FormattedType/XMLDate"));
            this.ipw.println("; !! Hint: replace by TextType or FormattedType/XMLDate");
        } else {
            this.ipw.println(';');
        }
    }

    public void printAttributeBasePath(Container scope, AttributeDef attrib) {
        this.printAttributeBasePath(scope, attrib, null);
    }

    public void printAttributeBasePath(Container scope, AttributeDef attrib, String language) {
        Evaluable[] paths = ((LocalAttribute)attrib).getBasePaths();
        if (paths != null && paths.length != 0) {
            this.ipw.print(" := ");
            for (int i = 0; i < paths.length; ++i) {
                if (i > 0) {
                    this.ipw.print(", ");
                }
                this.printExpression(scope, paths[i], language);
            }
        }
    }

    protected void printSignAttribute(Graphic scope, SignAttribute attrib, String language) {
        SignAttribute extending = (SignAttribute)attrib.getExtending();
        if (language == null) {
            this.printDocumentation(attrib.getDocumentation());
            this.ipw.print(attrib.getName());
        } else {
            String docu = this.getDocumentationInLanguage(attrib, language);
            if (docu == null || docu == "") {
                this.printDocumentation(attrib.getDocumentation());
            } else {
                this.printDocumentation(docu);
            }
            String name = this.getNameInLanguage(attrib, language);
            if (name == null || name == "") {
                this.ipw.print(attrib.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.printModifiers(false, false, extending != null, false, false, false);
        if (extending == null || attrib.getGenerating() != extending.getGenerating()) {
            this.ipw.print(" OF ");
            this.printRef(scope, attrib.getGenerating(), language);
        }
        this.ipw.println(":");
        this.ipw.indent();
        SignInstruction[] instructions = attrib.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            if (i > 0) {
                this.ipw.println(',');
            }
            this.printSignInstruction(scope.getBasedOn(), instructions[i], language);
        }
        this.ipw.unindent();
        this.ipw.println(';');
    }

    protected void printSignInstruction(Viewable basedOn, SignInstruction instr, String language) {
        if (instr == null) {
            this.printError();
            return;
        }
        Evaluable restrictor = instr.getRestrictor();
        if (restrictor != null) {
            this.ipw.print("WHERE ");
            this.printExpression(basedOn, restrictor, language);
            this.ipw.println();
        }
        this.ipw.println('(');
        this.ipw.indent();
        ParameterAssignment[] assignments = instr.getAssignments();
        for (int i = 0; i < assignments.length; ++i) {
            if (i > 0) {
                this.ipw.println(';');
            }
            this.printParameterAssignment(basedOn, assignments[i], language);
        }
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print(')');
    }

    protected void printParameterAssignment(Viewable basedOn, ParameterAssignment parass, String language) {
        if (parass == null) {
            this.printError();
            return;
        }
        Parameter assigned = parass.getAssigned();
        if (assigned == null) {
            this.printError();
        } else if (language == null) {
            this.ipw.print(assigned.getName());
        } else {
            String name = this.getNameInLanguage(assigned, language);
            if (name == null || name == "") {
                this.ipw.print(assigned.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.ipw.print(" := ");
        this.printExpression(basedOn, parass.getValue(), language);
    }

    public void printMetaValues(Settings values) {
        this.printMetaValues(values, null, null);
    }

    public void printMetaValues(Settings values, String language, String scopedNamePrefix) {
        if (values != null) {
            for (String name : values.getValues()) {
                String metaValue;
                String value = "";
                value = name.equals("CRS") ? String.valueOf(this.params.getEpsgCode()) : values.getValue(name);
                this.ipw.print("!!@ ");
                this.ipw.print(name);
                this.ipw.print("=");
                String scopedName = scopedNamePrefix + ".METAOBJECT." + name;
                if (value.indexOf(32) != -1 || value.indexOf(61) != -1 || value.indexOf(59) != -1 || value.indexOf(44) != -1 || value.indexOf(34) != -1 || value.indexOf(92) != -1) {
                    if (language == null) {
                        this.ipw.println("\"" + value + "\"");
                        continue;
                    }
                    metaValue = this.getEnumerationElementNameInLanguage(scopedName, language);
                    if (metaValue == null || metaValue == "") {
                        this.ipw.println("\"" + value + "\"");
                        continue;
                    }
                    this.ipw.println("\"" + metaValue + "\"");
                    continue;
                }
                if (language == null) {
                    this.ipw.println(value);
                    continue;
                }
                metaValue = this.getEnumerationElementNameInLanguage(scopedName, language);
                if (metaValue == "" || metaValue == null) {
                    this.ipw.println(value);
                    continue;
                }
                this.ipw.println(metaValue);
            }
        }
    }

    public void printDocumentation(String doc) {
        String line;
        if (doc == null) {
            return;
        }
        if (doc.length() == 0) {
            return;
        }
        String beg = "/** ";
        int last = 0;
        int next = doc.indexOf("\n", last);
        while (next > -1) {
            line = doc.substring(last, next);
            this.ipw.println(beg + line);
            beg = " * ";
            last = next + 1;
            next = doc.indexOf("\n", last);
        }
        line = doc.substring(last);
        this.ipw.println(beg + line);
        this.ipw.println(" */");
    }

    protected void printModel(Model mdef, String language) {
        String value;
        this.ipw.println();
        if (language == null) {
            this.printDocumentation(mdef.getDocumentation());
        } else {
            value = this.getDocumentationInLanguage(mdef, language);
            if (value == null || value == "") {
                this.printDocumentation(mdef.getDocumentation());
            } else {
                this.printDocumentation(value);
            }
        }
        this.printMetaValues(mdef.getMetaValues(), language, mdef.getScopedName());
        if (mdef.isContracted()) {
            this.ipw.print("CONTRACTED ");
        }
        if (language == null) {
            if (this.params.getNewModelName() != null) {
                this.ipw.print("MODEL " + this.params.getNewModelName());
            } else {
                this.ipw.print("MODEL " + mdef.getName());
            }
        } else {
            value = this.getNameInLanguage(mdef, language);
            if (value == null || value == "") {
                this.ipw.print("MODEL " + mdef.getName());
            } else {
                this.ipw.print("MODEL " + value);
            }
        }
        if (language == null) {
            if (mdef.getLanguage() != null) {
                this.ipw.print("(" + mdef.getLanguage() + ")");
            }
        } else {
            this.ipw.print("(" + language + ")");
        }
        this.ipw.println();
        this.ipw.indent();
        String issuer = mdef.getIssuer();
        if (issuer == null) {
            issuer = "mailto:" + System.getProperty("user.name") + "@localhost";
        }
        this.ipw.println("AT \"" + issuer + "\"");
        String version = mdef.getModelVersion();
        if (version == null) {
            Calendar current = Calendar.getInstance();
            DecimalFormat digit4 = new DecimalFormat("0000");
            DecimalFormat digit2 = new DecimalFormat("00");
            version = digit4.format(current.get(1)) + "-" + digit2.format(current.get(2) + 1) + "-" + digit2.format(current.get(5));
        }
        this.ipw.print("VERSION \"" + version + "\"");
        String expl = mdef.getModelVersionExpl();
        if (expl != null && expl.length() > 0) {
            this.ipw.print(' ');
            this.printExplanation(expl);
        }
        if (this.translationConfig != null) {
            String translationText = "TRANSLATION OF " + mdef.getName() + "[\"" + mdef.getModelVersion() + "\"]";
            this.ipw.println(translationText);
        }
        this.ipw.println(" =");
        Model[] imported = mdef.getImporting();
        String sep = "";
        boolean modelsImported = false;
        for (int i = 0; i < imported.length; ++i) {
            Model curImport = imported[i];
            if (curImport instanceof Model) {
                if (curImport == this.modelInterlis) continue;
                if (!modelsImported) {
                    this.ipw.println("IMPORTS");
                    this.ipw.indent();
                    modelsImported = true;
                }
                if (this.params != null) {
                    TransformationParameter.ModelTransformation[] importModels;
                    for (TransformationParameter.ModelTransformation importModel : importModels = this.params.getImportModels()) {
                        if (importModel.getFromModel().equals(curImport.getName())) {
                            this.ipw.print(sep + importModel.getToModel());
                            continue;
                        }
                        this.ipw.print(sep + curImport.getName());
                    }
                } else {
                    this.ipw.print(sep + curImport.getName());
                }
                sep = ", ";
                continue;
            }
            this.printError();
        }
        if (modelsImported) {
            this.ipw.println(';');
            this.ipw.unindent();
            this.ipw.println();
        }
        this.printElements(mdef, language);
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print("END ");
        if (language == null) {
            if (this.params.getNewModelName() != null) {
                this.ipw.print(this.params.getNewModelName());
            } else {
                this.ipw.print(mdef.getName());
            }
        } else {
            String name = this.getNameInLanguage(mdef, language);
            if (name == null || name == "") {
                this.ipw.print(mdef.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.ipw.println('.');
        this.ipw.println();
    }

    private String getDocumentationInLanguage(Element ele, String language) {
        String modelName = "";
        for (TranslationElement element : this.translationConfig) {
            if (!Ili2TranslationXml.getElementInRootLanguage(ele).getScopedName().equals(element.getScopedName())) continue;
            if (language.equals(FR)) {
                modelName = element.getDocumentation_fr();
                return modelName;
            }
            if (language.equals(EN)) {
                modelName = element.getDocumentation_en();
                return modelName;
            }
            if (language.equals(IT)) {
                modelName = element.getDocumentation_it();
                return modelName;
            }
            if (!language.equals(DE)) continue;
            modelName = element.getDocumentation_de();
            return modelName;
        }
        return "";
    }

    private String getNameInLanguage(Element ele, String language) {
        String modelName = "";
        for (TranslationElement element : this.translationConfig) {
            if (!Ili2TranslationXml.getElementInRootLanguage(ele).getScopedName().equals(element.getScopedName())) continue;
            if (language.equals(FR)) {
                modelName = element.getName_fr();
                return modelName;
            }
            if (language.equals(EN)) {
                modelName = element.getName_en();
                return modelName;
            }
            if (language.equals(IT)) {
                modelName = element.getName_it();
                return modelName;
            }
            if (!language.equals(DE)) continue;
            modelName = element.getName_de();
            return modelName;
        }
        return "";
    }

    protected void printExplanation(String explanationText) {
        this.ipw.print("//");
        this.ipw.print(explanationText);
        this.ipw.print("//");
    }

    protected void printDomainDef(Container scope, Domain dd, String language) {
        Domain extending = dd.getExtending();
        String scopedNamePrefix = dd.getScopedName();
        if (language == null) {
            this.printDocumentation(dd.getDocumentation());
        } else {
            String docu = this.getDocumentationInLanguage(dd, language);
            if (docu == null || docu == "") {
                this.printDocumentation(dd.getDocumentation());
            } else {
                this.printDocumentation(docu);
            }
        }
        this.printMetaValues(dd.getMetaValues(), language, dd.getScopedName());
        if (language != null) {
            String name = this.getEnumerationElementNameInLanguage(scopedNamePrefix, language);
            if (name == null || name == "") {
                this.ipw.print(dd.getName());
            } else {
                this.ipw.print(name);
            }
        } else {
            this.ipw.print(dd.getName());
        }
        if (dd.getType() instanceof TypeAlias && ((TypeAlias)dd.getType()).getAliasing() == this.td.INTERLIS.INTERLIS_1_DATE) {
            Domain dd2 = ((TypeAlias)dd.getType()).getAliasing();
            this.printModifiers(dd2.isAbstract(), dd2.isFinal(), false, false, false, false);
            this.ipw.print(" = ");
            this.printType(scope, dd2.getType(), language, scopedNamePrefix);
            this.ipw.println(';');
        } else {
            this.printModifiers(dd.isAbstract(), dd.isFinal(), false, false, false, false);
            if (extending != null) {
                this.ipw.print(" EXTENDS ");
                this.printRef(scope, extending, language);
            }
            this.ipw.print(" = ");
            this.printType(scope, dd.getType(), language, scopedNamePrefix);
            if (dd.getType() instanceof StructuredUnitType) {
                EhiLogger.logError((String)("DOMAIN " + dd.getName() + ": StructuredUnitType not supported by INTERLIS 2.3; replace by TextType or FormattedType/XMLDate"));
                this.ipw.println("; !! Hint: replace by TextType or FormattedType/XMLDate");
            } else {
                this.ipw.println(';');
            }
        }
    }

    public void printReferenceSysRef(Container scope, RefSystemRef rsr) {
        this.printReferenceSysRef(scope, rsr, null);
    }

    public void printReferenceSysRef(Container scope, RefSystemRef rsr, String language) {
        if (rsr == null) {
            this.printError();
            return;
        }
        if (rsr instanceof RefSystemRef.CoordSystem) {
            RefSystemRef.CoordSystem cs = (RefSystemRef.CoordSystem)rsr;
            this.ipw.print('{');
            this.printRef(scope, cs.getSystem(), language);
            this.ipw.print('}');
        } else if (rsr instanceof RefSystemRef.CoordSystemAxis) {
            RefSystemRef.CoordSystemAxis csa = (RefSystemRef.CoordSystemAxis)rsr;
            this.ipw.print('{');
            this.printRef(scope, csa.getSystem(), language);
            this.ipw.print('[');
            this.ipw.print(csa.getAxisNumber());
            this.ipw.print(']');
            this.ipw.print('}');
        } else if (rsr instanceof RefSystemRef.CoordDomain) {
            RefSystemRef.CoordDomain cda = (RefSystemRef.CoordDomain)rsr;
            this.ipw.print('<');
            this.printRef(scope, cda.getReferredDomain(), language);
            this.ipw.print('>');
        } else if (rsr instanceof RefSystemRef.CoordDomainAxis) {
            RefSystemRef.CoordDomainAxis cda = (RefSystemRef.CoordDomainAxis)rsr;
            this.ipw.print('<');
            this.printRef(scope, cda.getReferredDomain(), language);
            this.ipw.print('[');
            this.ipw.print(cda.getAxisNumber());
            this.ipw.print(']');
            this.ipw.print('>');
        } else {
            this.printError();
        }
    }

    public void printType(Container scope, Type dd) {
        this.printType(scope, dd, null, null);
    }

    public void printType(Container scope, Type dd, String language, String scopedNamePrefix) {
        if (dd == null) {
            this.printError();
            return;
        }
        if (dd.isMandatory() && !(dd instanceof CompositionType)) {
            this.ipw.print("MANDATORY ");
        }
        if (dd instanceof NumericalType) {
            this.printNumericalType(scope, (NumericalType)dd, language, 0);
        } else if (dd instanceof TextType) {
            int len = ((TextType)dd).getMaxLength();
            if (((TextType)dd).isNormalized()) {
                this.ipw.print("TEXT");
            } else {
                this.ipw.print("MTEXT");
            }
            if (len != -1) {
                this.ipw.print('*');
                this.ipw.print(len);
            }
        } else if (dd instanceof FormattedType) {
            FormattedType ft = (FormattedType)dd;
            if (ft.getDefinedBaseStruct() != null) {
                this.ipw.print("FORMAT BASED ON ");
                this.printRef(scope, ft.getDefinedBaseStruct(), language);
                Iterator<FormattedTypeBaseAttrRef> baseAttri = ft.iteratorDefinedBaseAttrRef();
                if (baseAttri.hasNext()) {
                    this.ipw.print(" (");
                    String sep = "";
                    if (ft.getExtending() != null) {
                        this.ipw.print("INHERITANCE");
                        sep = " ";
                    }
                    if (ft.getDefinedPrefix() != null) {
                        this.ipw.print("\"" + ft.getDefinedPrefix() + "\"");
                        sep = " ";
                    }
                    while (baseAttri.hasNext()) {
                        String name;
                        this.ipw.print(sep);
                        FormattedTypeBaseAttrRef baseAttr = baseAttri.next();
                        if (baseAttr.getFormatted() != null) {
                            if (language == null) {
                                this.ipw.print(baseAttr.getAttr().getName());
                            } else {
                                name = this.getNameInLanguage(baseAttr.getAttr(), language);
                                if (name == null || name == "") {
                                    this.ipw.print(baseAttr.getAttr().getName());
                                } else {
                                    this.ipw.print(name);
                                }
                            }
                            this.ipw.print("/");
                            this.printRef(scope, baseAttr.getFormatted(), language);
                        } else {
                            if (language == null) {
                                this.ipw.print(baseAttr.getAttr().getName());
                            } else {
                                name = this.getNameInLanguage(baseAttr.getAttr(), language);
                                if (name == null || name == "") {
                                    this.ipw.print(baseAttr.getAttr().getName());
                                } else {
                                    this.ipw.print(name);
                                }
                            }
                            if (baseAttr.getIntPos() != 0) {
                                this.ipw.print("/");
                                this.ipw.print(baseAttr.getIntPos());
                            }
                        }
                        if (baseAttr.getPostfix() != null) {
                            this.ipw.print(" \"" + baseAttr.getPostfix() + "\"");
                        }
                        sep = " ";
                    }
                    this.ipw.print(")");
                }
                if (ft.getDefinedMinimum() != null) {
                    this.ipw.print(" ");
                    this.printFormatedTypeMinMax(ft);
                }
            } else if (ft.getDefinedBaseDomain() != null) {
                this.ipw.print("FORMAT ");
                this.printRef(scope, ft.getDefinedBaseDomain(), language);
                this.ipw.print(" ");
                this.printFormatedTypeMinMax(ft);
            } else {
                this.printFormatedTypeMinMax(ft);
            }
        } else if (dd instanceof EnumerationType) {
            EnumerationType et = (EnumerationType)dd;
            this.printEnumeration(et.getEnumeration(), language, scopedNamePrefix);
            if (et.isCircular()) {
                this.ipw.print(" CIRCULAR");
            } else if (et.isOrdered()) {
                this.ipw.print(" ORDERED");
            }
        } else if (dd instanceof EnumTreeValueType) {
            EnumTreeValueType et = (EnumTreeValueType)dd;
            this.ipw.print("ALL OF ");
            this.printRef(scope, et.getEnumType(), language);
        } else if (dd instanceof EnumValType) {
            if (((EnumValType)dd).isOnlyLeafs()) {
                this.ipw.print("ENUMVAL");
            } else {
                this.ipw.print("ENUMTREEVAL");
            }
        } else if (dd instanceof TypeAlias) {
            Domain def = ((TypeAlias)dd).getAliasing();
            if (def == this.modelInterlis.BOOLEAN) {
                this.ipw.print("BOOLEAN");
            } else if (def == this.modelInterlis.VALIGNMENT) {
                this.ipw.print("VALIGNMENT");
            } else if (def == this.modelInterlis.HALIGNMENT) {
                this.ipw.print("HALIGNMENT");
            } else {
                this.printRef(scope, ((TypeAlias)dd).getAliasing(), language);
            }
        } else if (dd instanceof CompositionType) {
            CompositionType comp = (CompositionType)dd;
            Cardinality card = comp.getCardinality();
            if (card.getMaximum() == 1L) {
                if (card.getMinimum() == 1L) {
                    this.ipw.print("MANDATORY ");
                }
            } else {
                this.ipw.print(comp.isOrdered() ? "LIST " : "BAG ");
                this.ipw.print((Object)card);
                this.ipw.print(' ');
                this.ipw.print("OF ");
            }
            this.printRef(scope, comp.getComponentType(), language);
        } else if (dd instanceof ReferenceType) {
            ReferenceType ref = (ReferenceType)dd;
            this.ipw.print("REFERENCE TO ");
            if (ref.isExternal()) {
                this.ipw.print("(EXTERNAL) ");
            }
            this.printRef(scope, ref.getReferred(), language);
            Iterator<AbstractClassDef> resti = ref.iteratorRestrictedTo();
            String sep = " RESTRICTION (";
            boolean hasRestriction = false;
            while (resti.hasNext()) {
                AbstractClassDef rest = resti.next();
                this.ipw.print(sep);
                sep = ";";
                this.printRef(scope, rest, language);
                hasRestriction = true;
            }
            if (hasRestriction) {
                this.ipw.print(")");
            }
        } else if (dd instanceof AbstractCoordType) {
            NumericalType[] nts = ((AbstractCoordType)dd).getDimensions();
            int nullAxis = ((AbstractCoordType)dd).getNullAxis();
            int piHalfAxis = ((AbstractCoordType)dd).getPiHalfAxis();
            if (dd instanceof MultiCoordType) {
                this.ipw.print("MULTICOORD ");
            } else {
                this.ipw.print("COORD ");
            }
            this.ipw.indent();
            for (int i = 0; i < nts.length; ++i) {
                if (i > 0) {
                    this.ipw.print(", ");
                }
                this.printNumericalType(scope, nts[i], language, i);
            }
            if (nullAxis != 0) {
                this.ipw.println(',');
                this.ipw.print("ROTATION ");
                this.ipw.print(nullAxis);
                this.ipw.print(" -> ");
                if (piHalfAxis > 0) {
                    this.ipw.print(piHalfAxis);
                } else {
                    this.printError();
                }
            }
            this.ipw.unindent();
        } else if (dd instanceof LineType) {
            LineType lt = (LineType)dd;
            if (lt instanceof PolylineType) {
                this.ipw.print(((PolylineType)lt).isDirected() ? "DIRECTED POLYLINE" : "POLYLINE");
            } else if (lt instanceof MultiPolylineType) {
                this.ipw.print(((PolylineType)lt).isDirected() ? "DIRECTED MULTIPOLYLINE" : "MULTIPOLYLINE");
            } else if (lt instanceof SurfaceType) {
                this.ipw.print("SURFACE");
            } else if (lt instanceof MultiSurfaceType) {
                this.ipw.print("MULTISURFACE");
            } else if (lt instanceof AreaType) {
                this.ipw.print("AREA");
            } else if (lt instanceof MultiAreaType) {
                this.ipw.print("MULTIAREA");
            } else {
                this.printError();
            }
            LineForm[] lineForms = lt.getDefinedLineForms();
            PrecisionDecimal maxOverlap = lt.getDefinedMaxOverlap();
            Domain controlPointDomain = lt.getDefinedControlPointDomain();
            Table lineAttributeStructure = null;
            if (lt instanceof SurfaceOrAreaType) {
                lineAttributeStructure = ((SurfaceOrAreaType)lt).getLineAttributeStructure();
            } else if (lt instanceof MultiSurfaceOrAreaType) {
                lineAttributeStructure = ((MultiSurfaceOrAreaType)lt).getLineAttributeStructure();
            }
            this.ipw.indent();
            boolean needNewLine = false;
            if (lineForms.length > 0) {
                if (needNewLine) {
                    this.ipw.println();
                }
                this.ipw.print(" WITH (");
                for (int i = 0; i < lineForms.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    if (language == null) {
                        this.ipw.print(lineForms[i].getName());
                        continue;
                    }
                    String name = this.getNameInLanguage(lineForms[i], language);
                    if (name == "" || name == null) {
                        this.ipw.print(lineForms[i].getName());
                        continue;
                    }
                    this.ipw.print(name);
                }
                this.ipw.print(')');
                needNewLine = true;
            }
            if (controlPointDomain != null) {
                this.ipw.print(" VERTEX ");
                this.printRef(scope, controlPointDomain, language);
                needNewLine = true;
            }
            if (maxOverlap != null) {
                if (needNewLine) {
                    this.ipw.println();
                }
                this.ipw.print(" WITHOUT OVERLAPS > ");
                this.ipw.print(maxOverlap.toString());
            }
            if (lineAttributeStructure != null) {
                this.ipw.println();
                this.ipw.print("LINE ATTRIBUTES ");
                this.printRef(scope, lineAttributeStructure, language);
            }
            this.ipw.unindent();
        } else if (dd instanceof OIDType) {
            Type type = ((OIDType)dd).getOIDType();
            if (type == null) {
                this.ipw.print("OID ANY");
            } else {
                this.ipw.print("OID ");
                scopedNamePrefix = dd.getScopedName();
                this.printType(scope, type, language, scopedNamePrefix);
            }
        } else if (dd instanceof BlackboxType) {
            BlackboxType bt = (BlackboxType)dd;
            this.ipw.print("BLACKBOX");
            int kind = bt.getKind();
            if (kind == 1) {
                this.ipw.print(" XML");
            } else if (kind == 2) {
                this.ipw.print(" BINARY");
            }
        } else if (dd instanceof BasketType) {
            BasketType bt = (BasketType)dd;
            this.ipw.print("BASKET");
            int kind = bt.getKind();
            if (kind == 16) {
                this.ipw.print(" (DATA)");
            } else if (kind == 32) {
                this.ipw.print(" (VIEW)");
            } else if (kind == 64) {
                this.ipw.print(" (BASE)");
            } else if (kind == 128) {
                this.ipw.print(" (GRAPHIC)");
            }
            Topic spec = bt.getTopic();
            if (spec != null) {
                this.ipw.print(" OF ");
                this.printRef(scope, spec, language);
            }
        } else if (dd instanceof ClassType) {
            ClassType ct = (ClassType)dd;
            if (ct.isStructure()) {
                this.ipw.print("STRUCTURE");
            } else {
                this.ipw.print("CLASS");
            }
            String next = " RESTRICTED TO ";
            Iterator<Viewable<?>> resti = ct.iteratorRestrictedTo();
            while (resti.hasNext()) {
                Table rest = (Table)resti.next();
                this.ipw.print(next);
                this.printRef(scope, rest, language);
                next = " ,";
            }
        } else if (dd instanceof AttributePathType) {
            AttributePathType ct = (AttributePathType)dd;
            this.ipw.print("ATTRIBUTE");
            FormalArgument argRestr = ct.getArgRestriction();
            ObjectPath attrRestr = ct.getAttrRestriction();
            if (argRestr != null) {
                this.ipw.print(" OF @ ");
                if (language == null) {
                    this.ipw.print(argRestr.getName());
                } else {
                    String name = this.getNameInLanguage(argRestr, language);
                    if (name == null || name == "") {
                        this.ipw.print(argRestr.getName());
                    } else {
                        this.ipw.print(name);
                    }
                }
            } else if (attrRestr != null) {
                this.ipw.print(" OF ");
                this.printAttributePath(scope, attrRestr, language);
            }
            Type[] typeRestr = ct.getTypeRestriction();
            if (typeRestr != null) {
                this.ipw.print(" RESTRICTION ( ");
                String sep = "";
                for (int typei = 0; typei < typeRestr.length; ++typei) {
                    this.ipw.print(sep);
                    this.printType(scope, typeRestr[typei], language, scopedNamePrefix);
                    sep = ";";
                }
                this.ipw.print(" )");
            }
        } else if (dd instanceof ObjectType) {
            ObjectType ot = (ObjectType)dd;
            if (ot.isObjects()) {
                this.ipw.print("OBJECTS OF ");
            } else {
                this.ipw.print("OBJECT OF ");
            }
            Viewable ref = ot.getRef();
            this.printRef(scope, ref, language);
        } else if (dd instanceof MetaobjectType) {
            MetaobjectType ot = (MetaobjectType)dd;
            this.ipw.print("METAOBJECT");
            Table ref = ot.getReferred();
            if (ref != scope) {
                this.ipw.print(" OF ");
                this.printRef(scope, ref, language);
            }
        }
    }

    private void printFormatedTypeMinMax(FormattedType ft) {
        this.ipw.print("\"");
        this.ipw.print(ft.getDefinedMinimum());
        this.ipw.print("\" .. \"");
        this.ipw.print(ft.getDefinedMaximum());
        this.ipw.print("\"");
    }

    protected void printNumericalType(Container scope, NumericalType type, String language, int i) {
        if (type == null) {
            this.printError();
            return;
        }
        if (type instanceof NumericType) {
            NumericType ntyp = (NumericType)type;
            PrecisionDecimal min = ntyp.getMinimum();
            PrecisionDecimal max = ntyp.getMaximum();
            if (min == null) {
                this.ipw.print("NUMERIC");
            } else if (this.params != null) {
                if (i % 2 == 0) {
                    int j;
                    int value = (int)((double)((int)(this.params.getFactor_x() * min.doubleValue())) + this.params.getDiff_x());
                    String newValue = String.valueOf(value);
                    for (j = 0; j < min.getAccuracy(); ++j) {
                        newValue = j == 0 ? newValue + ".0" : newValue + "0";
                    }
                    this.ipw.print(newValue);
                    this.ipw.print(" .. ");
                    value = (int)((double)((int)(this.params.getFactor_x() * max.doubleValue())) + this.params.getDiff_x());
                    newValue = String.valueOf(value);
                    for (j = 0; j < min.getAccuracy(); ++j) {
                        newValue = j == 0 ? newValue + ".0" : newValue + "0";
                    }
                    this.ipw.print(newValue);
                } else {
                    int j;
                    int value = (int)((double)((int)(this.params.getFactor_y() * min.doubleValue())) + this.params.getDiff_y());
                    String newValue = String.valueOf(value);
                    for (j = 0; j < min.getAccuracy(); ++j) {
                        newValue = j == 0 ? newValue + ".0" : newValue + "0";
                    }
                    this.ipw.print(newValue);
                    this.ipw.print(" .. ");
                    value = (int)((double)((int)(this.params.getFactor_y() * max.doubleValue())) + this.params.getDiff_y());
                    newValue = String.valueOf(value);
                    for (j = 0; j < min.getAccuracy(); ++j) {
                        newValue = j == 0 ? newValue + ".0" : newValue + "0";
                    }
                    this.ipw.print(newValue);
                }
            } else {
                this.ipw.print(min.toString());
                this.ipw.print(" .. ");
                this.ipw.print(max.toString());
            }
        } else if (type instanceof StructuredUnitType) {
            this.ipw.print(((StructuredUnitType)type).getMinimum().toString());
            this.ipw.print(" .. ");
            this.ipw.print(((StructuredUnitType)type).getMaximum().toString());
        }
        if (type.isCircular()) {
            this.ipw.print(" CIRCULAR");
        }
        if (type.getUnit() != null) {
            this.ipw.print(" [");
            this.ipw.print(type.getUnit().getScopedName(scope));
            this.ipw.print(']');
        }
        switch (type.getRotation()) {
            case 2: {
                this.ipw.print(" COUNTERCLOCKWISE");
                break;
            }
            case 1: {
                this.ipw.print(" CLOCKWISE");
            }
        }
        if (type.getReferenceSystem() != null) {
            this.ipw.print(' ');
            this.printReferenceSysRef(scope, type.getReferenceSystem(), language);
        }
    }

    protected void printEnumeration(Enumeration enumer, String language, String scopedNamePrefix) {
        this.ipw.println('(');
        this.ipw.indent();
        if (enumer == null) {
            this.printError();
        } else {
            Iterator<Enumeration.Element> iter = enumer.getElements();
            while (iter.hasNext()) {
                this.printEnumerationElement(iter.next(), language, scopedNamePrefix);
                if (!iter.hasNext()) continue;
                this.ipw.println(',');
            }
        }
        this.ipw.unindent();
        this.ipw.print(')');
    }

    protected void printEnumerationElement(Enumeration.Element ee, String language, String scopedNamePrefix) {
        String scopedName = scopedNamePrefix + "." + ee.getName();
        if (language == null) {
            this.printDocumentation(ee.getDocumentation());
            this.printMetaValues(ee.getMetaValues(), language, scopedName);
            this.ipw.print(ee.getName());
        } else {
            String docu = this.getEnumerationElementDocumentationInLanguage(scopedName, language);
            if (docu == null || docu == "") {
                this.printDocumentation(ee.getDocumentation());
            } else {
                this.printDocumentation(docu);
            }
            this.printMetaValues(ee.getMetaValues(), language, scopedName);
            String name = this.getEnumerationElementNameInLanguage(scopedName, language);
            if (name == null || name == "") {
                this.ipw.print(ee.getName());
            } else {
                this.ipw.print(name);
            }
        }
        Enumeration subEnum = ee.getSubEnumeration();
        if (subEnum != null) {
            this.ipw.print(' ');
            this.printEnumeration(subEnum, language, scopedName);
        }
    }

    private String getEnumerationElementNameInLanguage(String scopedNamePrefix, String language) {
        String modelName = "";
        for (TranslationElement element : this.translationConfig) {
            if (!scopedNamePrefix.equals(element.getScopedName())) continue;
            if (language.equals(FR)) {
                modelName = element.getName_fr();
                return modelName;
            }
            if (language.equals(EN)) {
                modelName = element.getName_en();
                return modelName;
            }
            if (language.equals(IT)) {
                modelName = element.getName_it();
                return modelName;
            }
            if (!language.equals(DE)) continue;
            modelName = element.getName_de();
            return modelName;
        }
        return "";
    }

    private String getEnumerationElementDocumentationInLanguage(String scopedNamePrefix, String language) {
        String modelName = "";
        for (TranslationElement element : this.translationConfig) {
            if (!scopedNamePrefix.equals(element.getScopedName())) continue;
            if (language.equals(FR)) {
                modelName = element.getDocumentation_fr();
                return modelName;
            }
            if (language.equals(EN)) {
                modelName = element.getDocumentation_en();
                return modelName;
            }
            if (language.equals(IT)) {
                modelName = element.getDocumentation_it();
                return modelName;
            }
            if (!language.equals(DE)) continue;
            modelName = element.getDocumentation_de();
            return modelName;
        }
        return "";
    }

    public void printLineFormTypeDef(Container scope, LineForm lf) {
        this.printLineFormTypeDef(scope, lf, null);
    }

    public void printLineFormTypeDef(Container scope, LineForm lf, String language) {
        Table segmentStructure;
        if (lf == null) {
            this.printError();
            return;
        }
        if (language == null) {
            this.printDocumentation(lf.getDocumentation());
        } else {
            String docu = this.getDocumentationInLanguage(lf, language);
            if (docu == null || docu == "") {
                this.printDocumentation(lf.getDocumentation());
            } else {
                this.printDocumentation(docu);
            }
        }
        this.printMetaValues(lf.getMetaValues(), language, lf.getScopedName());
        if (language == null) {
            this.ipw.print(lf.getName());
        } else {
            String name = this.getNameInLanguage(lf, language);
            if (name == null || name == "") {
                this.ipw.print(lf.getName());
            } else {
                this.ipw.print(name);
            }
        }
        String explanation = lf.getExplanation();
        if (explanation != null) {
            this.ipw.print(' ');
            this.printExplanation(explanation);
        }
        if (!(segmentStructure = lf.getSegmentStructure()).isEmpty()) {
            this.ipw.print(" : ");
            if (language == null) {
                this.ipw.print(segmentStructure.getName());
            } else {
                String name = this.getNameInLanguage(segmentStructure, language);
                if (name == null || name == "") {
                    this.ipw.print(segmentStructure.getName());
                } else {
                    this.ipw.print(name);
                }
            }
        }
        this.ipw.println(';');
    }

    public void printFunctionDeclaration(Container scope, Function f) {
        this.printFunctionDeclaration(scope, f, null);
    }

    public void printFunctionDeclaration(Container scope, Function f, String language) {
        this.printFunctionDeclaration(scope, f, false, language);
    }

    public void printFunctionDeclaration(Container scope, Function f, boolean suppressDoc) {
        this.printFunctionDeclaration(scope, f, suppressDoc, null);
    }

    public void printFunctionDeclaration(Container scope, Function f, boolean suppressDoc, String language) {
        if (f == null) {
            this.printError();
            return;
        }
        if (!suppressDoc) {
            if (language == null) {
                this.printDocumentation(f.getDocumentation());
            } else {
                String docu = this.getDocumentationInLanguage(f, language);
                if (docu == null || docu == "") {
                    this.printDocumentation(f.getDocumentation());
                } else {
                    this.printDocumentation(docu);
                }
            }
            this.printMetaValues(f.getMetaValues(), language, f.getScopedName());
        }
        this.ipw.print("FUNCTION ");
        if (language == null) {
            this.ipw.print(f.getName());
        } else {
            String name = this.getNameInLanguage(f, language);
            if (name == null || name == "") {
                this.ipw.print(f.getName());
            } else {
                this.ipw.print(name);
            }
        }
        this.ipw.print("(");
        FormalArgument[] args = f.getArguments();
        if (args == null) {
            this.printError();
        } else {
            String sep = " ";
            for (int i = 0; i < args.length; ++i) {
                if (language == null) {
                    this.ipw.print(sep + args[i].getName() + " : ");
                } else {
                    String scopedName = f.getScopedName() + "." + args[i].getScopedName();
                    String name = this.getEnumerationElementNameInLanguage(scopedName, language);
                    if (name == null || name == "") {
                        this.ipw.print(sep + args[i].getName() + " : ");
                    } else {
                        this.ipw.print(sep + name + " : ");
                    }
                }
                this.printType(scope, args[i].getType(), language, scope.getScopedName());
                sep = "; ";
            }
        }
        this.ipw.print(") : ");
        this.printType(scope, f.getDomain(), language, scope.getScopedName());
        String explanation = f.getExplanation();
        if (explanation != null) {
            this.printExplanation(explanation);
        }
        this.ipw.println(';');
    }

    protected void printAttributeRefs(AttributeRef[] refs) {
        if (refs == null) {
            this.printError();
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            if (i > 0) {
                this.ipw.print('.');
            }
            if (refs[i] == null) {
                this.printError();
                continue;
            }
            this.ipw.print(refs[i].getName());
        }
    }

    protected void printAttributePath(Container scope, ObjectPath path, String language) {
        if (path == null) {
            this.printError();
            return;
        }
        PathEl[] elv = path.getPathElements();
        String sep = "";
        for (int i = 0; i < elv.length; ++i) {
            PathElAssocRole assocRole;
            String name;
            this.ipw.print(sep);
            sep = "->";
            if (language == null) {
                this.ipw.print(elv[i].getName());
                continue;
            }
            if (elv[i] instanceof AttributeRef) {
                AttributeRef attr = (AttributeRef)elv[i];
                if (!(attr.getAttr() instanceof LocalAttribute)) continue;
                name = this.getEnumerationElementNameInLanguage(attr.getAttr().getScopedName(), language);
                if (name == null || name == "") {
                    this.ipw.print(elv[i].getName());
                    continue;
                }
                this.ipw.print(name);
                continue;
            }
            if (!(elv[i] instanceof PathElAssocRole) || !((assocRole = (PathElAssocRole)elv[i]).getRole() instanceof RoleDef)) continue;
            name = this.getEnumerationElementNameInLanguage(assocRole.getRole().getScopedName(), language);
            if (name == null || name == "") {
                this.ipw.print(elv[i].getName());
                continue;
            }
            this.ipw.print(name);
        }
    }

    protected void printElements(Container container, String language) {
        Class lastClass = null;
        if (this.onlyLastFile && container instanceof TransferDescription) {
            for (Model model : ((TransferDescription)container).getModelsFromLastFile()) {
                lastClass = this.printElement(container, lastClass, model, language);
            }
        } else {
            for (Element elt : container) {
                lastClass = this.printElement(container, lastClass, elt, language);
            }
        }
    }

    protected Class printElement(Container container, Class lastClass, Element elt, String language) {
        if (elt instanceof AttributeDef) {
            this.printAttribute(container, (AttributeDef)elt, language);
            lastClass = AttributeDef.class;
        } else if (elt instanceof RoleDef) {
            this.printRoleDef(container, (RoleDef)elt, language);
            lastClass = RoleDef.class;
        } else if (elt instanceof Function) {
            if (lastClass != null && lastClass != Function.class) {
                this.ipw.println();
            }
            this.printFunctionDeclaration(container, (Function)elt, language);
            lastClass = Function.class;
        } else if (elt instanceof Parameter) {
            if (lastClass != Parameter.class) {
                this.ipw.println("PARAMETER");
            }
            this.printParameter(container, (Parameter)elt, language);
            lastClass = Parameter.class;
        } else if (elt instanceof Domain) {
            if (lastClass != Domain.class) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.ipw.println("DOMAIN");
            }
            this.ipw.indent();
            this.printDomainDef(container, (Domain)elt, language);
            this.ipw.unindent();
            lastClass = Domain.class;
        } else if (elt instanceof LineForm) {
            if (lastClass != LineForm.class) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.ipw.println("LINE FORM");
            }
            this.ipw.indent();
            this.printLineFormTypeDef(container, (LineForm)elt, language);
            this.ipw.unindent();
            lastClass = LineForm.class;
        } else if (elt instanceof Unit) {
            if (lastClass != Unit.class) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.ipw.println("UNIT");
            }
            this.ipw.indent();
            this.printUnit(container, (Unit)elt, language);
            this.ipw.unindent();
            lastClass = Unit.class;
        } else if (elt instanceof Model) {
            if (this.withPredefined || !(elt instanceof PredefinedModel)) {
                this.printModel((Model)elt, language);
                lastClass = Model.class;
            }
        } else if (elt instanceof Topic) {
            this.ipw.println();
            this.ipw.println();
            this.printTopic((Topic)elt, language);
            lastClass = Topic.class;
        } else if (elt instanceof MetaDataUseDef) {
            this.ipw.println();
            this.printMetaDataUseDef((MetaDataUseDef)elt, language);
            lastClass = MetaDataUseDef.class;
        } else if (elt instanceof Table) {
            if (!((Table)elt).isImplicit()) {
                this.ipw.println();
                this.printAbstractClassDef((Table)elt, language);
                lastClass = AbstractClassDef.class;
            }
        } else if (elt instanceof AssociationDef) {
            this.ipw.println();
            this.printAbstractClassDef((AssociationDef)elt, language);
            lastClass = AbstractClassDef.class;
        } else if (elt instanceof View) {
            if (lastClass != null) {
                this.ipw.println();
            }
            this.printView((View)elt, language);
            lastClass = View.class;
        } else if (elt instanceof Graphic) {
            if (lastClass != null) {
                this.ipw.println();
            }
            this.printGraphic((Graphic)elt, language);
            lastClass = Graphic.class;
        } else if (elt instanceof Constraint) {
            if (((Constraint)elt).isSelfStanding()) {
                this.selfStandingConstraints.add(elt);
            } else {
                this.printConstraint((Constraint)elt, language);
                lastClass = Constraint.class;
            }
        } else if (elt instanceof ExpressionSelection) {
            if (lastClass != null) {
                this.ipw.println();
            }
            this.ipw.println("WHERE");
            this.ipw.indent();
            this.printExpression(((ExpressionSelection)elt).getSelected(), ((ExpressionSelection)elt).getCondition(), language);
            this.ipw.println(';');
            this.ipw.unindent();
            lastClass = ExpressionSelection.class;
        } else if (elt instanceof SignAttribute) {
            if (lastClass != SignAttribute.class && lastClass != null) {
                this.ipw.println();
            }
            this.printSignAttribute((Graphic)container, (SignAttribute)elt, language);
            lastClass = SignAttribute.class;
        }
        return lastClass;
    }

    protected void printTransferDescription(TransferDescription td, String language) {
        this.ipw.println("INTERLIS 2.3;");
        this.ipw.unindent();
        this.ipw.println();
        this.printElements(td, language);
    }
}

