/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf;

import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.impl.MyHandler;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactory;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.IoxIliReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XtfReader
implements IoxReader,
IoxIliReader {
    public static final String XMLNS_XTF22 = "http://www.interlis.ch/INTERLIS2.2";
    public static final String XMLNS_XTF23 = "http://www.interlis.ch/INTERLIS2.3";
    private MyHandler handler = null;
    private InputStream inputFile = null;
    private XMLEventReader reader = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();

    public XtfReader(InputStream in) throws IoxException {
        this.init(in);
    }

    private void init(InputStream in) throws IoxException {
        this.handler = new MyHandler();
        this.handler.setFactory((IoxFactory)this.factory);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            this.reader = inputFactory.createXMLEventReader(in);
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    public XtfReader(InputStreamReader in) throws IoxException {
    }

    public XtfReader(File xtffile) throws IoxException {
        try {
            this.inputFile = new FileInputStream(xtffile);
            this.init(this.inputFile);
        }
        catch (IOException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    public void close() throws IoxException {
        this.reader = null;
        this.handler = null;
        if (this.inputFile != null) {
            try {
                this.inputFile.close();
            }
            catch (IOException ex) {
                throw new IoxException((Throwable)ex);
            }
            this.inputFile = null;
        }
    }

    public IoxEvent read() throws IoxException {
        while (this.reader.hasNext()) {
            XMLEvent event = null;
            try {
                event = this.reader.nextEvent();
            }
            catch (XMLStreamException ex) {
                throw new IoxException((Throwable)ex);
            }
            this.handler.stopParser = false;
            if (event instanceof StartElement) {
                this.handler.startElement((StartElement)event);
            } else if (event instanceof EndElement) {
                this.handler.endElement((EndElement)event);
            } else if (event instanceof Characters) {
                this.handler.characters((Characters)event);
            } else {
                this.handler.otherEvents(event);
            }
            if (!this.handler.stopParser) continue;
            return this.handler.returnObject;
        }
        return null;
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
        this.handler.setFactory((IoxFactory)factory);
    }

    @Override
    public void setTopicFilter(String[] topicNames) {
        this.handler.setTopicFilter(topicNames);
    }

    @Override
    public void setModel(TransferDescription td) {
    }

    @Override
    public String getMimeType() {
        if (this.handler != null && this.handler.isIli22()) {
            return "application/interlis+xml;version=2.2";
        }
        return "application/interlis+xml;version=2.3";
    }
}

