/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ilirepository.impl.ModelMetadata;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.ilirepository.impl.VisitorAction;
import java.util.ArrayList;
import java.util.List;

public class ModelLister
implements VisitorAction {
    private List<ModelMetadata> result = new ArrayList<ModelMetadata>();
    private boolean ignoreDuplicates = true;

    @Override
    public boolean processRepository(String uri, RepositoryAccess rep) throws RepositoryAccessException {
        List<ModelMetadata> iliModels = null;
        try {
            EhiLogger.traceState((String)("read ilimodels.xml from <" + uri + ">..."));
            iliModels = rep.readIlimodelsXml2(uri);
        }
        catch (RepositoryAccessException ex) {
            EhiLogger.logAdaption((String)("repository <" + uri + "> ignored; " + RepositoryAccess.toString(ex)));
        }
        if (iliModels != null) {
            ModelLister.fixFiles(iliModels, uri);
            boolean stopVisiting = this.mergeModelMetadata(iliModels);
            if (stopVisiting) {
                return true;
            }
        }
        return false;
    }

    private static void fixFiles(List<ModelMetadata> models, String uri) {
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        for (ModelMetadata md : models) {
            md.setFile(uri + md.getFile());
        }
    }

    private boolean mergeModelMetadata(List<ModelMetadata> iliModels) {
        if (this.ignoreDuplicates) {
            for (ModelMetadata md : iliModels) {
                if (RepositoryAccess.findModelMetadata2(this.result, md.getName(), md.getSchemaLanguage(), md.getVersion()) != null) continue;
                this.result.add(md);
            }
        } else {
            this.result.addAll(iliModels);
        }
        return false;
    }

    public void logRepositoryScan(String uri) {
    }

    @Deprecated
    public List<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> getResult() {
        ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata> ret = new ArrayList<ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata>();
        for (ModelMetadata m : this.result) {
            ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata m09 = RepositoryAccess.mapToIom09(m);
            if (m09 == null) continue;
            ret.add(m09);
        }
        return ret;
    }

    public List<ModelMetadata> getResult2() {
        return this.result;
    }

    public void setResult(List<ModelMetadata> result) {
        throw new NoSuchMethodError();
    }

    public boolean ignoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public void setIgnoreDuplicates(boolean ignoreDuplicates) {
        this.ignoreDuplicates = ignoreDuplicates;
    }
}

