
from .project import *

"""
https://www.linz.govt.nz/guidance/geodetic-system/understanding-coordinate-conversions/geodetic-datum-conversions/transformations-nzgd1949-nzgd2000/geodetic-datum-transformation-examples-nzgd1949-nzgd2000?utm_source=chatgpt.com
"""
datasets_nz = {
1: {
    'input': ("""175° 00' 00.00000" E""", """36° 30' 00.00000" S """, """NZGD1949 """, """EPSG:4272"""),
    'output': ("""175° 00' 00.66696" E """, """36° 29' 53.49360" S""", """NZGD2000""", """EPSG:4167"""),
    'method': '7-parameter'
},
    2: {
        'input': ("""175° 00' 00.00000" E""", """36° 30' 00.00000" S """, """NZGD1949 """, """EPSG:4272""" ),
        'output': ("""175° 00' 00.69469" E """, """36° 29' 53.48482" S """, """NZGD2000""", """EPSG:4167"""),
        'method': 'Distortion grid'
    }
}




'''
http://www.geoin.it/coordinate_converter/
'''
florence_rifredi = {
3003: (1680146.94, 4851840.10),
23032: (680201.14, 4852021.26),
4230: (11.239928, 43.798510),
4326: (11.2389438, 43.797553)
}


if __name__ == '__main__':

    src_epsg_code = 3003
    dest_epsg_code = 4326

    x, y = florence_rifredi[src_epsg_code]

    projected_pt = project(
        Point(x, y),
        CRS.from_epsg(src_epsg_code),
        CRS.from_epsg(dest_epsg_code),
    )

    #print(projected_pt)
    #print(projected_pt.x)
    #print(projected_pt.y)

    # Test line

    src_epsg_code = 4326
    dest_epsg_code = 3003

    test_line = Ln.from_points(
        Point(11.2389438, 43.797553),
        Point(11.5, 44.0),
    )

    projected_line = project(
        test_line,
        CRS.from_epsg(src_epsg_code),
        CRS.from_epsg(dest_epsg_code),
    )

    print(f"Projected line: {projected_line}")




