import matplotlib.pyplot as plt
import numpy as np

# Dati di esempio
t = np.linspace(0, 10, 100)
y1 = np.sin(t)
y2 = np.cos(t)
y3 = np.sin(2*t)

# Creazione figura
fig = plt.figure(figsize=(8, 6))

# Approccio 1: Usando subplots con sharex
# fig, axs = plt.subplots(3, 1, sharex=True, figsize=(8, 6))
# fig.subplots_adjust(hspace=0)

# Approccio 2: Usando GridSpec (commenta sopra e sblocca qui sotto)
gs = plt.GridSpec(3, 1, height_ratios=[1, 1, 1])
ax1 = fig.add_subplot(gs[0])
ax2 = fig.add_subplot(gs[1], sharex=ax1)
ax3 = fig.add_subplot(gs[2], sharex=ax1)

# Impostazioni dello spazio
plt.subplots_adjust(hspace=0)

# Plot dei dati
ax1.plot(t, y1)
ax2.plot(t, y2)
ax3.plot(t, y3)

# Pulizia delle etichette dell'asse x
ax1.set_xticklabels([])
ax2.set_xticklabels([])

plt.show()
'''
# Mostra il grafico
plt.savefig('grafici_verticali.png')
plt.close()
'''