
from typing import Tuple, Any

import sys
fo = sys.stdout

import numbers

from PyQt5.QtGui import QColor


from geogst.core.inspections.functions import *



def qcolor2rgbmpl(
        qcolor: QColor,
) -> Tuple[numbers.Real, numbers.Real, numbers.Real]:

    red = qcolor.red() / 255.0
    green = qcolor.green() / 255.0
    blue = qcolor.blue() / 255.0
    return red, green, blue


def qcolor_from_rgbmpl(
    red: numbers.Real,
    green: numbers.Real,
    blue: numbers.Real,
    ) -> QColor:
    
    return QColor.fromRgbF(red, green, blue)


def qcolor_from_mpl(
    red: numbers.Real,
    green: numbers.Real,
    blue: numbers.Real,
) -> QColor:
    return QColor.fromRgbF(red*255, green*255, blue*255)


def create_qcolor(val: Any) -> QColor:
    
    try:
        
        if isinstance(val, tuple):
            if len(val) == 3:
                for el in val:
                    if not 0 <= el <= 1:
                        return QColor(*val)
                else:
                    return qcolor_from_rgbmpl(*val)
        else:        
            return QColor(val)

    except Exception as e:
        
        #fo.write(f"\nGot value {val} as input to function {caller_name()}: {e!r}")
        return QColor.red()
    
    
def fract_rgb_from_qcolor_name(
        color_name: str
        ) -> Tuple[numbers.Real, numbers.Real, numbers.Real]:
    """
    return tuple of three float values [0,1]
    """

    color = QColor(color_name)

    red = color.red() / 255.0
    green = color.green() / 255.0
    blue = color.blue() / 255.0

    return red, green, blue
