from collections import OrderedDict, namedtuple

from geogst.plots.parameters import *


PointsProjectionParameters = namedtuple(
    'PointsProjectionParameters',
    [
        "point_layer",
        "label_field_name",
        "z_attribute_choice",
        "z_field_name",
        "points_are_3d",
        "max_profile_distance",
    ]
)



AttitudesProjectionParameters = namedtuple(
'AttitudesProjectionParameters',
    [
      "point_layer",
      "label_field_name",
      "use_dipdir",
      "use_rhr_strike",
      "orient_fld_name",
      "dipangle_fld_name",
      "dem_choice",
      "dem_layer",
      "z_attribute_choice",
      "z_field_name",
      "points_are_3d",
      "max_profile_distance",
    ]
)

LinesIntersectionParameters = namedtuple(
    'LinesIntersectionParameters',
    [
        "line_layer",
        "id_field_ndx",
    ]
)

PolygonsIntersectionParameters = namedtuple(
    'PolygonsIntersectionParameters',
    [
        "polygon_layer",
    ]
)

ltMarkerStyles = OrderedDict(
    [
        ("circle", "o"),
        ("square", "s"),
        ("diamond", "D"),
        ("triangle", "^"),
        ("star", "*"),
        ("plus", "+")
    ]
)

class GraphicalParameters:

    def __init__(self):

        self.figure = FigureParams()
        self.axis = AxisPlotParams()
        self.elevations = ElevationPlotParams()
        self.point_projections = PointPlotParams()
        self.attitude_projections = AttitudePlotParams()
        self.line_intersections = PointPlotParams()
        self.polygon_intersections = None
