from pyproj.transformer import TransformerGroup, CRS

# Definisci le coordinate del punto e il CRS
x, y = 500000, 4500000  # Esempio di coordinate in CRS planare
source_crs = CRS.from_epsg(32632)  # UTM zona 32N

# Definisci un buffer attorno al punto
buffer_size = 1000  # Metri
min_x = x - buffer_size
max_x = x + buffer_size
min_y = y - buffer_size
max_y = y + buffer_size

# Crea l'area di interesse (AOI)
area_of_interest = {
    "west": min_x,
    "south": min_y,
    "east": max_x,
    "north": max_y,
}

area_of_interest = (
    min_x,
    min_y,
    max_x,
    max_y,
)
# Trova il trasformatore adatto
target_crs = CRS.from_epsg(4326)  # WGS84
transformers = TransformerGroup(source_crs, target_crs, area_of_interest=area_of_interest)

# Elenco dei trasformatori disponibili
for transformer in transformers.transformers:
    print(transformer.description)