
from PyQt5.QtCore import QSettings, QFileInfo
from PyQt5.QtWidgets import QFileDialog


def lastUsedDir(module_nm):
    """
    Gets the last used directory for the given module.
    Modified from module RASTERCALC by Barry Rowlingson.

    :param module_nm: the current module name
    :type module_nm: string
    :return: the name of the last used directory
    :rtype: string
    """

    settings = QSettings()
    return settings.value(
        "/{}/lastDir".format(module_nm),
        "",
        type=str)


def setLastUsedDir(module_nm, lastDir):
    """
    Stores in the module QSettings the path of the last used directory.
    Modified from module RASTERCALC by Barry Rowlingson.

    :param module_nm: the current module name
    :type module_nm: string
    :param lastDir: the last used directory
    :type lastDir: string

    :return: None
    """

    path = QFileInfo(lastDir).absolutePath()
    settings = QSettings()
    settings.setValue(
        "/{}/lastDir".format(module_nm),
        str(path))


def update_directory_key(settings: QSettings, settings_dir_key, fileName):
    """
    Updates the value of a QSetting key with the path of a file.
    Modified from module RASTERCALC by Barry Rowlingson.

    :param settings:
    :param settings_dir_key:
    :param fileName:
    :return:
    """

    path = QFileInfo(fileName).absolutePath()
    settings.setValue(settings_dir_key,
                      str(path))


def define_path_new_file(
        parent,
        show_msg,
        path,
        filter_text
):
    """
    Defines the path of a new file.

    :param parent:
    :param show_msg:
    :param path:
    :param filter_text:
    :return:
    """

    output_filepath, _ = QFileDialog.getSaveFileName(parent,
                                                  show_msg,
                                                  path,
                                                  filter_text)
    if not output_filepath:
        return ''
    else:
        return output_filepath


def old_file_path(
        parent,
        show_msg,
        path,
        filter_text
):
    """
    Defines the path of a pre-existing file.

    :param parent:
    :param show_msg:
    :param path:
    :param filter_text:
    :return:
    """

    input_filename, _ = QFileDialog.getOpenFileName(
        parent,
        parent.tr(show_msg),
        path,
        filter_text
    )

    if not input_filename:
        return ''
    else:
        return input_filename


def new_file_path(parent, show_msg, path, filter_text):

    output_filename, __ = QFileDialog.getSaveFileName(
        parent,
        show_msg,
        path,
        filter_text
    )
    if not output_filename:
        return ''
    else:
        return output_filename



