@echo off
chcp 65001>nul
setlocal enabledelayedexpansion

rem ============================================================
rem Montage des lecteurs pour la gestion de crise
rem Conserve la logique d'origine, mais utilise le disque passé
rem en argument (ex: E:) au lieu du label PERMANENCE_DDT04
rem ============================================================

if "%~1"=="" (
    echo [ERREUR] Aucun disque spécifié.
    echo Utilisation : Gestion_crise_disque_externe.bat E:
    exit /b 1
)

set "DISK=%~1"
rem Supprime le "\" si présent
if "%DISK:~-1%"=="\" set "DISK=%DISK:~0,-1%"

echo [INFO] Montage à partir du disque %DISK%

rem --- Suppression des lecteurs réseau existants ---
set Letter=K:
net use | find "%Letter%" >nul
if %errorlevel%==1 goto suiteK
net use "%Letter%" /delete /yes >nul 2>&1
:suiteK
if exist "%Letter%\" (subst "%Letter%" /D)>nul

set Letter=R:
net use | find "%Letter%" >nul
if %errorlevel%==1 goto suiteR
net use "%Letter%" /delete /yes >nul 2>&1
:suiteR
if exist "%Letter%\" (subst "%Letter%" /D)>nul

set Letter=S:
net use | find "%Letter%" >nul
if %errorlevel%==1 goto suiteS
net use "%Letter%" /delete /yes >nul 2>&1
:suiteS
if exist "%Letter%\" (subst "%Letter%" /D)>nul

set Letter=T:
net use | find "%Letter%" >nul
if %errorlevel%==1 goto suiteT
net use "%Letter%" /delete /yes >nul 2>&1
:suiteT
if exist "%Letter%\" (subst "%Letter%" /D)>nul

set Letter=W:
net use | find "%Letter%" >nul
if %errorlevel%==1 goto suiteT
net use "%Letter%" /delete /yes >nul 2>&1
:suiteT
if exist "%Letter%\" (subst "%Letter%" /D)>nul

rem --- Génère la liste des disques et labels ---
wmic logicaldisk get volumename,name > "%USERPROFILE%\Documents\nom_lettrevolume.txt"
set "nom_lettre=%USERPROFILE%\Documents\nom_lettrevolume.txt"

rem --- Boucle sur les volumes détectés ---
for /f "skip=1 tokens=1,2" %%a in ('type "%nom_lettre%"') do (
    rem On cherche le disque choisi par le plugin (ex: E:)
    if /I "%%a"=="%DISK%" (
        echo [INFO] Disque sélectionné : %%a %%b
        rem Création des substitutions
        subst K: "%%a\dossiers" >nul 2>&1
        subst R: "%%a\gb_ref" >nul 2>&1
        subst S: "%%a\gb_prod" >nul 2>&1
        subst T: "%%a\gb_cons" >nul 2>&1
        subst W: "%%a\gb_cons" >nul 2>&1
        set "lp=%%b"
    )
)

echo [SUCCES] Montage terminé depuis %DISK%
exit /b 0
