# -*- coding: utf-8 -*-
"""
/***************************************************************************
 gestion_crise
                                 A QGIS plugin
 Projet utilisable en exercice de gestion de crise, en formation ou entrainement à l'utilisation, ainsi qu'en crise réelle (COD) 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-04-24
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Francois THEVAND
        email                : francois.thevand@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import time
import datetime
import os
import os.path

from pathlib import Path
import unicodedata

# Initialize Qt resources from file resources.py
from . import resources
# Import the code for the dialog
from .Gestion_crise_dialog import Gestion_criseDialog

import unicodedata
import subprocess

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt, pyqtSignal, QVariant

from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QInputDialog, QLineEdit, QDialog, QProgressDialog
from qgis.core import *
from qgis.gui import *
import string
from ctypes import windll
import win32api, win32file, win32con, pywintypes  # optional
import sys

# Gestion des versions PyQt
from qgis.PyQt.QtCore import PYQT_VERSION_STR as pyqt_version  # Importer la version de PyQt
if pyqt_version.startswith("5"):
    qmessagebox_question = QMessageBox.Question
    qmessagebox_critical = QMessageBox.Critical
    qmessagebox_warning = QMessageBox.Warning
    qmessagebox_information = QMessageBox.Information
    qmessagebox_yes = QMessageBox.Yes
    qmessagebox_no = QMessageBox.No
    qmessageBox_ok = QMessageBox.Ok
    qmessagebox_cancel = QMessageBox.Cancel
    qmessagebox_discard = QMessageBox.Discard
    qmessagebox_close = QMessageBox.Close
    qmessagebox_acceptrole = QMessageBox.AcceptRole
    qmessagebox_rejectrole = QMessageBox.RejectRole
    qmessagebox_destructiverole = QMessageBox.DestructiveRole
    qmessagebox_actionrole = QMessageBox.ActionRole
    qt_windowsmodal = Qt.WindowModal
    qt_applicationmodal = Qt.ApplicationModal
    qt_windowstaysontophint = Qt.WindowStaysOnTopHint
    # A compléter au fur et à mesure des découvertes !
elif pyqt_version.startswith("6"):
    qmessagebox_question = QMessageBox.Icon.Question
    qmessagebox_critical = QMessageBox.Icon.Critical
    qmessagebox_warning = QMessageBox.Icon.Warning
    qmessagebox_information = QMessageBox.Icon.Information
    qmessagebox_yes = QMessageBox.StandardButton.Yes
    qmessagebox_no = QMessageBox.StandardButton.No
    qmessageBox_ok = QMessageBox.StandardButton.Ok
    qmessagebox_cancel = QMessageBox.StandardButton.Cancel
    qmessagebox_discard = QMessageBox.StandardButton.Discard
    qmessagebox_close = QMessageBox.StandardButton.Close
    qmessagebox_acceptrole = QMessageBox.ButtonRole.AcceptRole
    qmessagebox_rejectrole = QMessageBox.ButtonRole.RejectRole
    qmessagebox_destructiverole = QMessageBox.ButtonRole.DestructiveRole
    qmessagebox_actionrole = QMessageBox.ButtonRole.ActionRole
    qt_windowsmodal = Qt.WindowModality.WindowModal
    qt_applicationmodal = Qt.WindowModality.ApplicationModal
    qt_windowstaysontophint = Qt.WindowType.WindowStaysOnTopHint
    # A compléter au fur et à mesure des découvertes !


class Gestion_crise:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Gestion_crise_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Gestion de crise')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        # Définition des variables
        # Fichier batch de montage du disque externe en réseau
        # version WEB
        # self.montage_HDD = 'Montage_disque_reseau.bat'
        # version DDT04
        self.montage_HDD = 'Gestion_crise_disque_externe.bat'
        # Fichier batch de démontage du disque externe
        self.demontage_HDD = 'Demontage_disque_reseau.bat'
        # Lecteurs géobase et permanence
        self.liste_lecteurs = ['K:\\', 'R:\\', 'S:\\', 'T:\\', 'W:\\']
        # Nom disque externe
        # version WEB
        # self.disque_ext = 'CRISE_HDD'
        # version DDT04
        self.disque_ext = 'PERMANENCE_DDT04'
        # Chemin du projet de base
        # version WEB
        # self.projetBASE = "K:/permanence/PCastreinte/4- Cartographie/Projet_QGIS_gestion_crise/Profil_exemple_gestion_de_crise.qgz"
        # version DDT04
        self.projetBASE = "K:/permanence/PCastreinte/4- Cartographie/Projet_QGIS_gestion_crise/2_Gestion_crise.qgz"
        # Utilisateur en cours
        self.utilisateur = os.environ.get("USERNAME")
        # Date du jour jour/mois/an
        self.datejma = datetime.datetime.today().strftime('%d%m%y')
        # Date et heure du jour
        self.dateh = datetime.datetime.today().strftime('%d%m%y-%Hh%M')
        # cheminbase = le ? remplace tout chemin trouvé en parent de "Projet_QGIS_gestion_crise"
        self.cheminbase = '?/Projet_QGIS_gestion_crise'
        # Définition du chemin du bureau courant
        self.cheminburo = os.path.expanduser('~') + '/Desktop'
        # Définition du chemin du dossier formation sur le bureau de l'utilisateur en cours
        self.cheminform = self.cheminburo + '/Formation_gestion_Crise'
        # Définition du chemin du dossier des exercices
        self.cheminexo = 'K:/permanence/Exercices'
        # Définition du chemin du dossier des crises
        self.chemincrise = 'K:/permanence/Evenements'
        # Valeurs par défaut de l'état de la connexion
        self.connexion_reseau = False
        self.connexion_disque = False

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Gestion_crise', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        """Ajouter une icône de barre d'outils à la barre d'outils.

         :param icon_path : chemin vers l'icône pour cette action. Peut être une ressource
             chemin (par exemple ':/plugins/foo/bar.png') ou un chemin de système de fichiers normal.
         :type icon_path: str

         :param text : texte qui doit être affiché dans les éléments de menu pour cette action.
         :type text : str

         :param callback : fonction à appeler lorsque l'action est déclenchée.
         :rappel de type : fonction

         :param enabled_flag : un indicateur indiquant si l'action doit être activée
             par défaut. La valeur par défaut est Vrai.
         :type enabled_flag : booléen

         :param add_to_menu : Drapeau indiquant si l'action doit également
             être ajouté au menu. La valeur par défaut est Vrai.
         :type add_to_menu: booléen

         :param add_to_toolbar : indicateur indiquant si l'action doit également
             être ajouté à la barre d'outils. La valeur par défaut est Vrai.
         :type add_to_toolbar: booléen

         :param status_tip : texte facultatif à afficher dans une fenêtre contextuelle lorsque le pointeur de la souris
             survole l'action.
         :type status_tip: str

         :param parent : Widget parent pour la nouvelle action. Valeurs par défaut Aucune.
         :type parent : QWidget

         :param whats_this : texte facultatif à afficher dans la barre d'état lorsque le
             le pointeur de la souris survole l'action.

         :retourne : L'action qui a été créée. Notez que l'action est également
             ajouté à la liste self.actions.
         :rtype: QAction
         """

        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(':/plugins/gestion_crise/icon.png')
        # Chemin défini dans resources.py
        #icon = QIcon(':/icon.png')
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Lancement projet gestion de crise'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Gestion de crise'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Créer le dialogue avec des éléments (après traduction) et conserver la référence
        # Ne créez qu'une seule fois l'interface graphique dans le rappel, afin qu'elle ne se charge que lorsque le plugin est démarré
        if self.first_start == True:
            self.first_start = False

        # Valeurs par défaut de l'état de la connexion
        self.connexion_reseau = False
        self.connexion_disque = False
        # Mise en forme de la boite de dialogue
        self.dialog = QDialog(self.iface.mainWindow())
        self.dialogui = Gestion_criseDialog()
        self.dialogui.setupUi(self.dialog)
        self.dialogui.buttonE.setStyleSheet('font: 75 12pt "Arial";')
        self.dialogui.buttonF.setStyleSheet('font: 75 12pt "Arial";')
        self.dialogui.buttonC.setStyleSheet('font: 75 12pt "Arial";')
        self.dialogui.label_operation.setStyleSheet('font: 75 18pt "Arial";')
        self.dialogui.label_connexion.setStyleSheet('font: 75 12pt "Arial";\nbackground-color: rgb(0, 255, 0);')
        # Affichage type connexion en rouge par défaut
        self.dialogui.label_connexion.setText('Connexion non disponible')
        self.dialogui.label_operation.setText('Appuyez sur "Echap" ou fermez cette fenêtre')
        self.dialogui.label_connexion.setStyleSheet('font: 75 12pt "Arial";\nbackground-color: rgb(255, 0, 0);')

        # Initialisation de l'action sur click des boutons
        self.dialogui.buttonE.clicked.connect(self.exercice)
        self.dialogui.buttonF.clicked.connect(self.formation)
        self.dialogui.buttonC.clicked.connect(self.crise)

        # Correspondance win32file.GetDriveType - win32con.DRIVE_??? :
        #     0 = > 'DRIVE_UNKNOWN',
        #     1 = > 'DRIVE_NO_ROOT_DIR',
        #     2 = > 'DRIVE_REMOVABLE',
        #     3 = > 'DRIVE_FIXED',
        #     4 = > 'DRIVE_REMOTE',
        #     5 = > 'DRIVE_CDROM',
        #     6 = > 'DRIVE_RAMDISK'

        for drive in win32api.GetLogicalDriveStrings().split("\x00"):
            type = win32file.GetDriveType(drive)
            if type == win32con.DRIVE_REMOTE:
                # try: rendu obligatoire en raison d'une erreur en fin de boucle
                # sur l'exécution de l'instruction "fs = win32api.GetVolumeInformation(drive)[0]"
                # (Uniquement sur les postes MI...)
                try:
                    fs = win32api.GetVolumeInformation(drive)[0]
                    if str(drive) in self.liste_lecteurs:
                        self.connexion_reseau = True
                        self.connexion_disque = False
                        self.dialogui.label_operation.setText('Quelle opération voulez-vous faire ?')
                        self.dialogui.label_connexion.setText('Connexion réseau')
                        self.dialogui.label_connexion.setStyleSheet('font: 75 12pt "Arial";\nbackground-color: rgb(0, 255, 0);')
                        self.dialogui.buttonE.setEnabled(True)
                        self.dialogui.buttonC.setEnabled(True)
                        self.dialogui.buttonF.setEnabled(True)
                except:
                    pass
            if type == win32con.DRIVE_FIXED:
                try:
                    fs = win32api.GetVolumeInformation(drive)[0]
                    if str(drive) not in self.liste_lecteurs:
                        if fs != self.disque_ext:
                            # Disque non géobase, on désactive les boutons
                            self.dialogui.buttonE.setEnabled(False)
                            self.dialogui.buttonC.setEnabled(False)
                            self.dialogui.buttonF.setEnabled(False)
                            self.connexion_reseau = False
                            self.connexion_disque = False
                            continue
                        elif fs == self.disque_ext:
                            subprocess.Popen('start /MIN cmd.exe /K' + str(drive) + self.montage_HDD, shell=True)
                            # pause pour laisser aux lecteurs le temps de se monter
                            CustomMessageBox.showWithTimeout(3, "Montage du disque externe, veuillez patienter...", "Connexion", icon=QMessageBox.Information)
                            time.sleep(2)
                            break
                except:
                    pass
        for drive in win32api.GetLogicalDriveStrings().split("\x00"):
            # type = win32file.GetDriveType(drive)
            try:
                fs = win32api.GetVolumeInformation(drive)[0]
                if str(drive) in self.liste_lecteurs and fs == self.disque_ext:
                    # print("Connexion virtuelle montée")
                    self.dialogui.buttonE.setEnabled(True)
                    self.dialogui.buttonC.setEnabled(True)
                    self.dialogui.buttonF.setEnabled(True)
                    self.connexion_reseau = False
                    self.connexion_disque = True
                    self.dialogui.label_operation.setText('Quelle opération voulez-vous faire ?')
                    self.dialogui.label_connexion.setText('Connexion disque externe')
                    self.dialogui.label_connexion.setStyleSheet('font: 75 12pt "Arial";\nbackground-color: rgb(0, 255, 0);')
                    break
            except:
                pass
        # Contrôle :
        # print('Connexion disque : ' + str(self.connexion_disque))
        # print('Connexion réseau : ' + str(self.connexion_reseau))

        if self.connexion_disque or self.connexion_reseau:
            # Pour que la fenêtre reste au premier plan de toutes les applications en cours
            self.dialogui.setWindowModality(qt_windowsmodal)
            self.dialogui.setWindowFlags(qt_windowstaysontophint)
            self.dialog.exec()
        else:
            QMessageBox.warning(None, u"ATTENTION !",u"La connexion n'est pas disponible. Veuillez verifier la connexion au réseau interne et le raccordement du disque externe.")
            return

        # Continuer la modification ici

    def ouvrir_projet(self, chemproj, nomproj, pathToFile):
        # Obtenir l'instance du projet en cours
        self.project = QgsProject.instance()
        self.project.read(self.projetBASE)
        # Lecture du chemin du projet courant
        cheminprojet = self.project.homePath()
        # Vérification utilisée en cours de débogae:
        #print(chemproj + '/' + nomproj)

        # A VERIFIER : Ecriture du projet à son nouvel emplacement
        # project.write(chemproj + '/' + nomproj)

        if self.project.isDirty():
            self.project.read(chemproj + '/' + nomproj)
        # Lecture du nouveau chemin du projet courant
        cheminbase = os.path.dirname(self.project.fileName())
        # Si le projet ouvert n'est pas celui de base
        if not pathToFile:
            pathToFile = cheminbase
        # Ecriture du projet à son nouvel emplacement
        self.project.write(chemproj + '/' + nomproj)
        # Redéfinition du root pour l'adapter au projet en cours

        # Ecriture des couches évènement
        self.handler_createLayers(chemproj, nomproj, pathToFile)

        # Ancien code avec nécessité d'une macro dans l'openProject du projet (lenteur)
        # root = project.layerTreeRoot()
        # for group in root.children():
        #     test = ''.join(
        #     x for x in unicodedata.normalize('NFKD', group.name()) if unicodedata.category(x)[0] == 'L').upper()
        #     if test == 'EVENEMENTS':
        #         groupevt = root.findGroup(group.name())
        #         # Définition de la liste des couches du groupe Evènements quelle que soit la casse et l'accentuation du nom du groupe
        #         layer_list = [layer.name() for layer in group.children()]
        # # Boucle d'enregistrement des couches évènements dans le nouveau dossier
        # for vLayer in project.mapLayers().values():
        #     couchasuppr = None
        #
        #     if vLayer.name() in layer_list:
        #         # Enregistrement du style dans le nouveau dossier
        #         vLayer.saveNamedStyle(pathToFile + vLayer.name() + ".qml")
        #         # Enregistrement de l'identifiant de la couche à supprimer du projet
        #         couchasuppr = project.mapLayersByName(vLayer.name())[0]
        #         # Enregistrement de chaque couche évènement dans le nouveau dossier
        #         QgsVectorFileWriter.writeAsVectorFormat(vLayer, pathToFile + vLayer.name() + ".shp", "utf-8",
        #                                                 vLayer.crs(),
        #                                                 driverName="ESRI Shapefile")
        #         # Redéfinition de la nouvelle couche évènement
        #         vLayer = QgsVectorLayer(pathToFile + vLayer.name() + ".shp", vLayer.name(), "ogr")
        #         # Ajout de la couche dans le gestionnaire de couches
        #         project.addMapLayer(vLayer, False)
        #         # Affichage de la couche dans le gestionnaire de couches
        #         groupevt.addLayer(vLayer)
        #         # Suppression de la couche évènement de base du gestionnaire de couches
        #         project.removeMapLayer(couchasuppr.id())
        # Ecriture du projet à son nouvel emplacement
        # self.project.write(chemproj + '/' + nomproj)

    def exercice(self):
        ok = False
        nomexo = ''
        boxexo = QInputDialog()
        while not nomexo.strip():
            nomexo, ok = QInputDialog.getText(boxexo, 'Exercice gestion de crise - DDT04',
                                              "Nom de l'exercice (SAISIE OBLIGATOIRE) :",
                                              QLineEdit.Normal, "", Qt.CustomizeWindowHint | Qt.WindowTitleHint)
        self.dialog.close()
        try:
            os.makedirs(self.cheminexo + '/' + self.datejma + ' - ' + nomexo, exist_ok=True)
        except:
            self.msg_inf(self.cheminexo + " n'est pas disponible. Veuillez connecter le disque externe")
        chemproj = self.cheminexo + '/' + self.datejma + ' - ' + nomexo
        nomproj = self.datejma + ' - ' + nomexo + ' - ' + self.utilisateur + '.qgz'
        if os.path.isfile(chemproj + '/' + nomproj):
            os.remove(chemproj + '/' + nomproj)
        # project.write(chemproj + '/' + nomproj)
        pathToFile = self.cheminexo + '/' + self.datejma + ' - ' + nomexo + '/'
        self.ouvrir_projet(chemproj, nomproj, pathToFile)

    def formation(self):
        # print("Bouton formation pressé")
        self.dialog.close()
        os.makedirs(self.cheminform, exist_ok=True)
        os.makedirs(self.cheminform + '/Formation_Qgis_Gestion_crise_' + self.datejma, exist_ok=True)
        # os.chdir(cheminform+'/Formation_Qgis_gestion_crise_'+datejma)
        chemproj = self.cheminform + '/Formation_Qgis_gestion_crise_' + self.datejma
        nomproj = 'Formation_Qgis_gestion_crise_' + self.datejma + ' - ' + self.utilisateur + '.qgz'
        if os.path.isfile(chemproj + '/' + nomproj):
            os.remove(chemproj + '/' + nomproj)
        # project.write(chemproj + '/' + nomproj)
        pathToFile = self.cheminform + '/Formation_Qgis_gestion_crise_' + self.datejma + '/'
        self.ouvrir_projet(chemproj, nomproj, pathToFile)

    def crise(self):
        # print("Bouton crise pressé")
        self.dialog.close()
        ok = False
        nomcrise = ''
        boxcrise = QInputDialog()
        while not nomcrise.strip():
            nomcrise, ok = QInputDialog.getText(boxcrise, 'Gestion de crise - DDT04',
                                                "Nom de la crise (SAISIE OBLIGATOIRE) :",
                                                QLineEdit.Normal, "", Qt.CustomizeWindowHint | Qt.WindowTitleHint)
        os.makedirs(self.chemincrise + '/' + self.datejma + ' - ' + nomcrise, exist_ok=True)
        chemproj = self.chemincrise + '/' + self.datejma + ' - ' + nomcrise
        nomproj = self.datejma + ' - ' + nomcrise + ' - ' + self.utilisateur + '.qgz'
        if os.path.isfile(chemproj + '/' + nomproj):
            os.remove(chemproj + '/' + nomproj)
        # project.write(chemproj + '/' + nomproj)
        pathToFile = self.chemincrise + '/' + self.datejma + ' - ' + nomcrise + '/'
        self.ouvrir_projet(chemproj, nomproj, pathToFile)

    def annuler(self):
        QMessageBox.warning(None, u"ATTENTION !", u'Le projet va s''arrêter')
        return

    def barre_prog(self, tps):
        prog = QProgressDialog('Lecteurs en cours de montage...', 'Stopper', 0, 100)
        prog.setWindowModality(qt_applicationmodal)
        prog.setWindowFlags(qt_windowstaysontophint)
        prog.setCancelButton(None)
        prog.show()
        for i in range(1, 101):
            time.sleep(tps)
            prog.setValue(i)

    # Création du groupe et des couches évènement (Ancienne syntaxe)
    def handler_createLayers(self, chemproj, nomproj, pathToFile):
        # self.iface = iface
        self.project = QgsProject.instance()
        root = self.project.layerTreeRoot()
        # nameproj = self.project.fileName()
        evt = None
        groupevt = None
        for group in root.children():
            test = ''.join(
                x for x in unicodedata.normalize('NFKD', group.name()) if unicodedata.category(x)[0] == 'L').upper()
            if test == 'EVENEMENTS':
                evt = True
                groupevt = group
                if os.path.isfile("Evenements/POLYGONE_EVENEMENT.shp") or os.path.isfile("Evenements/LIGNE_EVENEMENT.shp") or os.path.isfile("Evenements/POINT_EVENEMENT.shp"):
                    print('Couches déjà créées')
                    QMessageBox.warning(
                        self.iface.mainWindow(),
                        self.tr("Commande inutile : "), self.tr("Les couches sont déja présentes."))
                    self.btn_createLayers.setEnabled(False)
                    # self.close()
                    return
        if not evt:
            if nomproj != '':
                groupevt = root.insertGroup(0, 'Evenements')
            else:
                print('Projet non enregistré')
                self.btn_createLayers.setEnabled(False)
                QMessageBox.warning(
                    self.iface.mainWindow(),
                    self.tr("Creation of event shapefile: "), self.tr("Possible only in a saved project. The layers will thus be created in an events sub-folder of the folder containing the project."))
                self.close()
                return

        # Création des couches et affichage dans l'arborescence, groupe évènements
        crs = QgsProject.instance().crs()
        transform_context = QgsProject.instance().transformContext()
        save_options = QgsVectorFileWriter.SaveVectorOptions()
        save_options.driverName = "ESRI Shapefile"
        save_options.fileEncoding = "UTF-8"

        polylayer_fields = QgsFields()
        polylayer_fields.append(QgsField('libelle', QVariant.String))
        polylayer_fields.append(QgsField('date', QVariant.String))
        polylayer_fields.append(QgsField('h_creation', QVariant.String))
        polylayer_fields.append(QgsField('source', QVariant.String))
        polylayer_fields.append(QgsField('h_constat', QVariant.String))
        polylayer_fields.append(QgsField('remarques', QVariant.String))
        polylayer_fields.append(QgsField('surface', QVariant.Double, 'double', 10, 0))
        polylayer_fields.append(QgsField('utilisatr', QVariant.String))

        lnglayer_fields = QgsFields()
        lnglayer_fields.append(QgsField('libelle', QVariant.String))
        lnglayer_fields.append(QgsField('date', QVariant.String))
        lnglayer_fields.append(QgsField('h_creation', QVariant.String))
        lnglayer_fields.append(QgsField('source', QVariant.String))
        lnglayer_fields.append(QgsField('h_constat', QVariant.String))
        lnglayer_fields.append(QgsField('remarques', QVariant.String))
        lnglayer_fields.append(QgsField('longueur', QVariant.Double, 'double', 10, 0))
        lnglayer_fields.append(QgsField('utilisatr', QVariant.String))

        ptlayer_fields = QgsFields()
        ptlayer_fields.append(QgsField('libelle', QVariant.String)),
        ptlayer_fields.append(QgsField('date', QVariant.String)),
        ptlayer_fields.append(QgsField('h_creation', QVariant.String)),
        ptlayer_fields.append(QgsField('source', QVariant.String)),
        ptlayer_fields.append(QgsField('h_constat', QVariant.String)),
        ptlayer_fields.append(QgsField('remarques', QVariant.String)),
        ptlayer_fields.append(QgsField('x_gps', QVariant.Double, 'double', 10, 6)),
        ptlayer_fields.append(QgsField('y_gps', QVariant.Double, 'double', 10, 6)),
        ptlayer_fields.append(QgsField('utilisatr', QVariant.String))

        qmlpath = ':/plugins/gestion_crise/resources/'
        # EVTpath = self.project.homePath()
        EVTpath = chemproj
        os.makedirs(EVTpath + "/Evenements", exist_ok=True)
        lstlayerEVT = [(EVTpath + "/Evenements/POLYGONE_EVENEMENT.shp", polylayer_fields, QgsWkbTypes.MultiPolygon, qmlpath + 'POLYGONE_EVENEMENT.qml'), (EVTpath + "/Evenements/LIGNE_EVENEMENT.shp", lnglayer_fields, QgsWkbTypes.MultiLineString,  qmlpath + 'LIGNE_EVENEMENT.qml'), (EVTpath + "/Evenements/POINT_EVENEMENT.shp", ptlayer_fields, QgsWkbTypes.MultiPoint,  qmlpath + 'POINT_EVENEMENT.qml')]
        # print(self.project.homePath())
        # print(chemproj)
        for layer in lstlayerEVT:
            writer = QgsVectorFileWriter.create(
                layer[0],
                layer[1],
                layer[2],
                crs,
                transform_context,
                save_options
            )
            lyr = self.iface.addVectorLayer(layer[0], '', 'ogr')
            pr = lyr.dataProvider()
            lyr.updateFields()
            lyr.loadNamedStyle(layer[3])
            myptlayer = root.findLayer(lyr.id())
            myptlayerclone = myptlayer.clone()
            parent = myptlayer.parent()
            groupevt.insertChildNode(0, myptlayerclone)
            parent.removeChildNode(myptlayer)
            lyr.setReadOnly(True)
            lyr.triggerRepaint()
            lyr.commitChanges()

            if writer.hasError() != QgsVectorFileWriter.NoError:
                print(self.tr("Error when creating shapefile: "), writer.errorMessage())
                QMessageBox.critical(
                    self.iface.mainWindow(),
                    self.tr("Error when creating shapefile ") + lyr.name() + " : ", writer.errorMessage())
                return
            del writer
        root = self.project.layerTreeRoot()
        group = root.children()
        for n in group:
            test = ''.join(
                x for x in unicodedata.normalize('NFKD', n.name()) if
                unicodedata.category(x)[0] == 'L').upper()
            if test == 'EVENEMENTS':
                n.setExpanded(True)
            else:
                n.setExpanded(False)
        # self.close()

    # # Création du groupe et des couches évènement (Correction copilot)
    # def handler_createLayers(self, chemproj: str, nomproj: str, pathToFile: str):
    #     project = self.project
    #     root = project.layerTreeRoot()
    #
    #     # 1) Cherche le groupe "Evenements"
    #     evt_found = False
    #     groupevt = None
    #     shp_folder = Path(chemproj) / "Evenements"
    #     for group in root.children():
    #         name_norm = "".join(
    #             ch for ch in unicodedata.normalize("NFKD", group.name())
    #             if unicodedata.category(ch)[0] == "L"
    #         ).upper()
    #         if name_norm == "EVENEMENTS":
    #             evt_found = True
    #             groupevt = group
    #             # si les shapefiles existent déjà, on arrête tout
    #             if any((shp_folder / fn).exists() for fn in [
    #                     "POLYGONE_EVENEMENT.shp",
    #                     "LIGNE_EVENEMENT.shp",
    #                     "POINT_EVENEMENT.shp"]):
    #                 QMessageBox.warning(
    #                     self.iface.mainWindow(),
    #                     "Commande inutile",
    #                     "Les couches sont déjà présentes."
    #                 )
    #                 self.btn_createLayers.setEnabled(False)
    #                 return
    #
    #     # 2) Création du groupe si besoin
    #     if not evt_found:
    #         if nomproj:
    #             groupevt = root.insertGroup(0, "Evenements")
    #         else:
    #             QMessageBox.warning(
    #                 self.iface.mainWindow(),
    #                 "Projet non enregistré",
    #                 "Enregistrez d’abord votre projet pour créer les shapefiles."
    #             )
    #             self.btn_createLayers.setEnabled(False)
    #             return
    #
    #     # 3) Préparation de la création
    #     crs = project.crs()
    #     tc = project.transformContext()
    #     save_opts = QgsVectorFileWriter.SaveVectorOptions()
    #     save_opts.driverName = "ESRI Shapefile"
    #     save_opts.fileEncoding = "UTF-8"
    #
    #     # 4) Schémas de champs
    #     def make_fields(defs):
    #         f = QgsFields()
    #         for name, typ, *rest in defs:
    #             f.append(QgsField(name, typ, *rest))
    #         return f
    #
    #     poly_def = [
    #         ("libelle", QVariant.String),
    #         ("date", QVariant.String),
    #         ("h_creation", QVariant.String),
    #         ("source", QVariant.String),
    #         ("h_constat", QVariant.String),
    #         ("remarques", QVariant.String),
    #         ("surface", QVariant.Double, "double", 10, 0),
    #         ("utilisatr", QVariant.String),
    #     ]
    #     line_def = [
    #         ("libelle", QVariant.String),
    #         ("date", QVariant.String),
    #         ("h_creation", QVariant.String),
    #         ("source", QVariant.String),
    #         ("h_constat", QVariant.String),
    #         ("remarques", QVariant.String),
    #         ("longueur", QVariant.Double, "double", 10, 0),
    #         ("utilisatr", QVariant.String),
    #     ]
    #     point_def = [
    #         ("libelle", QVariant.String),
    #         ("date", QVariant.String),
    #         ("h_creation", QVariant.String),
    #         ("source", QVariant.String),
    #         ("h_constat", QVariant.String),
    #         ("remarques", QVariant.String),
    #         ("x_gps", QVariant.Double, "double", 10, 6),
    #         ("y_gps", QVariant.Double, "double", 10, 6),
    #         ("utilisatr", QVariant.String),
    #     ]
    #
    #     # 5) Prépare la liste des couches à générer
    #     shp_folder.mkdir(parents=True, exist_ok=True)
    #     layers_to_create = [
    #         (shp_folder / "POLYGONE_EVENEMENT.shp", make_fields(poly_def), QgsWkbTypes.MultiPolygon, "POLYGONE_EVENEMENT.qml"),
    #         (shp_folder / "LIGNE_EVENEMENT.shp",    make_fields(line_def), QgsWkbTypes.MultiLineString, "LIGNE_EVENEMENT.qml"),
    #         (shp_folder / "POINT_EVENEMENT.shp",    make_fields(point_def), QgsWkbTypes.MultiPoint,      "POINT_EVENEMENT.qml"),
    #     ]
    #
    #     # dossier resources (à côté de ce script)
    #     qml_dir = Path(__file__).parent / "resources"
    #
    #     # 6) Création, chargement, stylisation et insertion
    #     for shp_path, fields, geom, qml_name in layers_to_create:
    #         # 6.1) Création physique
    #         writer = QgsVectorFileWriter.create(
    #             str(shp_path), fields, geom, crs, tc, save_opts
    #         )
    #         if writer.hasError() != QgsVectorFileWriter.NoError:
    #             QMessageBox.critical(
    #                 self.iface.mainWindow(),
    #                 "Erreur création shapefile",
    #                 writer.errorMessage()
    #             )
    #             del writer
    #             continue
    #         del writer
    #
    #         # 6.2) Chargement
    #         layer = QgsVectorLayer(str(shp_path), shp_path.stem, "ogr")
    #         if not layer.isValid():
    #             QMessageBox.critical(
    #                 self.iface.mainWindow(),
    #                 "Erreur chargement couche",
    #                 f"Impossible de charger {shp_path.name}"
    #             )
    #             continue
    #
    #         # 6.3) Style QML
    #         qml_path = qml_dir / qml_name
    #         if qml_path.exists():
    #             code, msg = layer.loadNamedStyle(str(qml_path))
    #             # code == 0 ↔ succès
    #             if code != 0:
    #                 print(f"⚠️ Erreur style {qml_name} :", msg)
    #             layer.triggerRepaint()
    #         else:
    #             print(f"⚠️ Style introuvable : {qml_path}")
    #
    #         # 6.4) Insertion dans le groupe
    #         QgsProject.instance().addMapLayer(layer, False)
    #         node = QgsLayerTreeLayer(layer)
    #         groupevt.insertChildNode(0, node)
    #
    #     # 7) Déplique uniquement le groupe Evenements
    #     for grp in root.children():
    #         keep_open = "".join(
    #             ch for ch in unicodedata.normalize("NFKD", grp.name())
    #             if unicodedata.category(ch)[0] == "L"
    #         ).upper() == "EVENEMENTS"
    #         grp.setExpanded(keep_open)
    #

class CustomMessageBox(QMessageBox):
    def __init__(self, *__args):
        QMessageBox.__init__(self)
        self.timeout = 0
        self.autoclose = False
        self.currentTime = 0



    def showEvent(self, QShowEvent):
        self.currentTime = 0
        if self.autoclose:
            self.startTimer(1000)

    def timerEvent(self, *args, **kwargs):
        self.currentTime += 1
        if self.currentTime >= self.timeout:
            self.done(0)

    @staticmethod
    def showWithTimeout(timeoutSeconds, message, title, icon=qmessagebox_information):
        w = CustomMessageBox()
        w.autoclose = True
        w.timeout = timeoutSeconds
        w.setText(message)
        w.setWindowTitle(title)
        w.setIcon(icon)
        w.exec()
