# -*- coding: utf-8 -*-
"""
/***************************************************************************
 qbeachball
                                 A QGIS plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-09-08
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Lymperis Efstathios
        email                : geo.elymperis@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os

from qgis.core import (
    Qgis,
    QgsApplication,
    QgsMarkerSymbol,
    QgsProject,
    QgsProperty,
    QgsSingleSymbolRenderer,
    QgsSvgMarkerSymbolLayer,
    QgsSymbol,
    QgsSymbolLayer,
)
from qgis.PyQt.QtCore import QCoreApplication, QSettings, Qt, QTranslator
from qgis.PyQt.QtGui import QColor, QIcon
from qgis.PyQt.QtWidgets import QAction

# Import the code for the DockWidget
from .qbeachball_dockwidget import QBeachballDockWidget

# Initialize Qt resources from file resources.py
from .resources import *

basePath = os.path.dirname(os.path.abspath(__file__))
settings_path = os.path.join(basePath, "assets/settings")
loader_icon = os.path.join(basePath, "assets/icons/spinner.gif")

from qbeachball.core.main import handler as CreateBeachballs
from qbeachball.core.utils.files import get_plugin_output_dir


class QBeachball:
    qbeachball = QAction()

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value("locale/userLocale")[0:2]
        locale_path = os.path.join(
            self.plugin_dir, "i18n", "qbeachball_{}.qm".format(locale)
        )

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = list()
        self.menu = self.tr("&Beachball Plotter")
        self.toolbar = self.iface.addToolBar("qbeachball")
        self.toolbar.setObjectName("qbeachball")

        # print "** INITIALIZING qbeachball"
        self.tm = QgsApplication.taskManager()
        self.pluginIsActive = False
        self.dockwidget = None

        self.plugin_params = None

    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate("qbeachball", message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
    ):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(self.menu, action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = os.path.join(os.path.dirname(__file__), "assets", "img", "icon.png")
        icon = QIcon(icon_path)
        self.qbeachball = QAction(icon, "Beachball Plotter", self.iface.mainWindow())
        self.qbeachball.triggered.connect(self.run)
        self.qbeachball.setCheckable(False)
        self.iface.addToolBarIcon(self.qbeachball)

        self.add_action(
            icon_path,
            text=self.tr("Beachball Plotter"),
            callback=self.run,
            parent=self.iface.mainWindow(),
        )

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""
        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)
        self.pluginIsActive = False

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        # print "** UNLOAD qbeachball"
        self.first_start = True
        for action in self.actions:
            self.iface.removePluginWebMenu(self.tr("&Beachball Plotter"), action)
            self.iface.removeToolBarIcon(action)
            self.iface.removeToolBarIcon(self.qbeachball)
        # remove the toolbar
        del self.toolbar

        self.plugin_params = None

    # --------------------------------------------------------------------------

    def make_svgs(self):
        INPUT_LAYER = self.plugin_params["input_layer"]
        if not INPUT_LAYER:
            self.iface.messageBar().pushMessage(
                "Error",
                "Please provide a QGIS layer",
                level=Qgis.Critical,
            )
            return

        # Order MATTERS:
        # https://docs.obspy.org/packages/autogen/obspy.imaging.beachball.beach.html
        tensor_components = [
            self.plugin_params["tensor_components"]["Mrr"],
            self.plugin_params["tensor_components"]["Mtt"],
            self.plugin_params["tensor_components"]["Mpp"],
            self.plugin_params["tensor_components"]["Mrt"],
            self.plugin_params["tensor_components"]["Mrp"],
            self.plugin_params["tensor_components"]["Mtp"],
        ]

        # Order matters here too
        sdp_components = [
            self.plugin_params["sdp_components"]["strike"],
            self.plugin_params["sdp_components"]["dip"],
            self.plugin_params["sdp_components"]["rake"],
        ]

        # Check which tab is checked: tensor or sdp
        method = self.dockwidget.focal_mechanism_tabs.currentIndex()

        successes = CreateBeachballs(
            csv_file=None,
            qgs_layer=INPUT_LAYER,
            max_rows=20,
            directory=self.plugin_params["output_directory"],
            fig_format="svg",
            bb_size=20,
            bb_width=10,
            event_id=self.plugin_params["id_field"],
            depth_based_color=self.plugin_params["depth_based_color"],
            depth_field=self.plugin_params["depth_field"],
            regime_based_color=self.plugin_params["regime_based_color"],
            regime_field=self.plugin_params["regime_field"],
            tensor_components=tensor_components if method == 1 else None,
            sdp_components=sdp_components if method == 0 else None,
        )
        self.iface.messageBar().pushMessage(
            "Success",
            f"Successfully created {successes} beachballs",
            level=Qgis.Info,
        )

    def plot_beachballs(self):
        """
        Using the selected layer, plot beachballs on the map, using the Event column as the key, and the SVG files
        as the beachball images.
        """

        selected_layer = self.plugin_params["input_layer"]
        if not selected_layer:
            self.iface.messageBar().pushMessage(
                "Error",
                "Please provide a QGIS layer",
                level=Qgis.Critical,
            )
            return

        # Get the Event column index
        event_column = self.plugin_params["id_field"]

        # Get the SVGs directory
        svgs_directory = self.plugin_params["output_directory"].replace("\\", "/")

        # base_symbol = QgsSymbol.defaultSymbol(selected_layer.geometryType())
        symbol_size = 9

        renderer = selected_layer.renderer()
        marker_symbol = renderer.symbol()

        # Create an SVG marker layer
        svg_layer: QgsSymbolLayer = QgsSvgMarkerSymbolLayer(
            None,  # Placeholder path for initialization
            size=symbol_size,
        )

        # Set data-defined property for SVG file path
        # see: https://qgis-developer.osgeo.narkive.com/BFbOJ9b8/set-data-defined-override-expression-with-python#post4
        svg_expression = f"""concat('{svgs_directory}/', "{event_column}", '.svg')"""
        svg_layer.setDataDefinedProperty(
            QgsSvgMarkerSymbolLayer.PropertyName,
            QgsProperty.fromExpression(svg_expression),
        )

        # Replace the default marker layer with the SVG marker layer
        marker_symbol.changeSymbolLayer(0, svg_layer)

        # Refresh the layer to apply changes
        selected_layer.triggerRepaint()

    def update_tensor_components_inputs(self):
        """
        Update the tensor components comboboxes, based on the currently selected layer.
        """
        selected_layer = self.dockwidget.events_layer_input.currentLayer()

        if selected_layer:
            # Enable tensor components inputs, and set the layer for each
            tensor_components = [
                ("Mrr", self.dockwidget.mrr_input_field),
                ("Mtt", self.dockwidget.mtt_input_field),
                ("Mpp", self.dockwidget.mpp_input_field),
                ("Mrt", self.dockwidget.mrt_input_field),
                ("Mrp", self.dockwidget.mrp_input_field),
                ("Mtp", self.dockwidget.mtp_input_field),
            ]
            for component, control in tensor_components:
                control.setLayer(selected_layer)
                control.setField(
                    component
                )  # Set the field to the corresponding tensor component, if it exists
        else:
            self.dockwidget.tensor_components_group.setEnabled(False)

    def update_sdp_components_inputs(self):
        """
        Update the sdp components comboboxes, based on the currently selected layer.
        """
        selected_layer = self.dockwidget.events_layer_input.currentLayer()

        if selected_layer:
            # Enable sdp components inputs, and set the layer for each
            sdp_components = [
                ("strike", self.dockwidget.strike_input_field),
                ("dip", self.dockwidget.dip_input_field),
                ("rake", self.dockwidget.rake_input_field),
            ]
            for component, control in sdp_components:
                control.setLayer(selected_layer)
                control.setField(
                    component
                )  # Set the field to the corresponding sdp component, if it exists

    def handle_layer_changed(self):
        """
        Update the fields comboboxes, based on the currently selected layer,
        and update the plugin parameters.
        """
        selected_layer = self.dockwidget.events_layer_input.currentLayer()

        self.update_tensor_components_inputs()
        self.update_sdp_components_inputs()

        if selected_layer:
            # Enable focal mechanism fields selection group
            self.dockwidget.focal_mechanism_group.setEnabled(True)

            self.dockwidget.id_field_select.setLayer(selected_layer)
            self.dockwidget.depth_color_field.setLayer(selected_layer)
            self.dockwidget.depth_color_field.setField("Depth")
            self.dockwidget.regime_color_field.setLayer(selected_layer)
            self.dockwidget.regime_color_field.setField("Regime")
            self.plugin_params["input_layer"] = selected_layer
        else:
            self.plugin_params["input_layer"] = None

    def handle_depth_based_color_changed(self):
        """
        Update the plugin parameters when the depth-based color checkbox is changed.
        """

        if self.dockwidget.depth_color_checkbox.isChecked():
            self.dockwidget.depth_color_group.setEnabled(True)
            self.dockwidget.depth_color_field.setField("Depth")

            self.plugin_params["depth_based_color"] = True

            # disable regime-based color if depth-based color is enabled
            self.dockwidget.regime_color_checkbox.setChecked(False)
            self.dockwidget.regime_color_group.setEnabled(False)
        else:
            self.dockwidget.depth_color_group.setEnabled(False)
            self.plugin_params["depth_based_color"] = False

    def handle_regime_based_color_changed(self):
        """
        Update the plugin parameters when the regime-based color checkbox is changed.
        """

        if self.dockwidget.regime_color_checkbox.isChecked():
            self.dockwidget.regime_color_group.setEnabled(True)
            self.dockwidget.regime_color_field.setField("Regime")

            self.plugin_params["regime_based_color"] = True

            # disable depth-based color if regime-based color is enabled
            self.dockwidget.depth_color_checkbox.setChecked(False)
            self.dockwidget.depth_color_group.setEnabled(False)
        else:
            self.dockwidget.regime_color_group.setEnabled(False)
            self.plugin_params["regime_based_color"] = False

    def initialize_params(self):
        """Initialize the parameters for the plugin"""
        params = {
            "input_layer": None,
            "id_field": None,
            "output_directory": get_plugin_output_dir(),
            "depth_based_color": True,
            "depth_field": None,
            "regime_based_color": False,
            "regime_field": None,
            # Option 1: use moment tensor components
            "tensor_components": {
                "Mrr": None,
                "Mtt": None,
                "Mpp": None,
                "Mrt": None,
                "Mrp": None,
                "Mtp": None,
            },
            # Option 2: use strike, dip, rake
            "sdp_components": {
                "strike": None,
                "dip": None,
                "rake": None,
            },
        }

        return params

    def update_params(self):
        """Update the parameters for the plugin, based on the current state of the dockwidget"""

        self.plugin_params["input_layer"] = (
            self.dockwidget.events_layer_input.currentLayer()
        )
        self.plugin_params["id_field"] = self.dockwidget.id_field_select.currentField()
        self.plugin_params["output_directory"] = (
            self.dockwidget.svgs_output_widget.filePath()
        )

        self.plugin_params["depth_based_color"] = (
            self.dockwidget.depth_color_checkbox.isChecked()
        )

        self.plugin_params["depth_field"] = (
            self.dockwidget.depth_color_field.currentField()
        )

        self.plugin_params["regime_based_color"] = (
            self.dockwidget.regime_color_checkbox.isChecked()
        )
        self.plugin_params["regime_field"] = (
            self.dockwidget.regime_color_field.currentField()
        )

        # Tensor components
        self.plugin_params["tensor_components"][
            "Mrr"
        ] = self.dockwidget.mrr_input_field.currentField()
        self.plugin_params["tensor_components"][
            "Mtt"
        ] = self.dockwidget.mtt_input_field.currentField()
        self.plugin_params["tensor_components"][
            "Mpp"
        ] = self.dockwidget.mpp_input_field.currentField()
        self.plugin_params["tensor_components"][
            "Mrt"
        ] = self.dockwidget.mrt_input_field.currentField()
        self.plugin_params["tensor_components"][
            "Mrp"
        ] = self.dockwidget.mrp_input_field.currentField()
        self.plugin_params["tensor_components"][
            "Mtp"
        ] = self.dockwidget.mtp_input_field.currentField()

        # SDP components
        self.plugin_params["sdp_components"][
            "strike"
        ] = self.dockwidget.strike_input_field.currentField()
        self.plugin_params["sdp_components"][
            "dip"
        ] = self.dockwidget.dip_input_field.currentField()
        self.plugin_params["sdp_components"][
            "rake"
        ] = self.dockwidget.rake_input_field.currentField()

    def run(self):
        """Run method that loads and starts the plugin"""
        self.plugin_params = self.initialize_params()

        if not self.pluginIsActive:
            self.pluginIsActive = True

            if self.dockwidget is None:
                self.dockwidget = QBeachballDockWidget()

            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()

            tensor_components = [
                ("Mrr", self.dockwidget.mrr_input_field),
                ("Mtt", self.dockwidget.mtt_input_field),
                ("Mpp", self.dockwidget.mpp_input_field),
                ("Mrt", self.dockwidget.mrt_input_field),
                ("Mrp", self.dockwidget.mrp_input_field),
                ("Mtp", self.dockwidget.mtp_input_field),
            ]

            sdp_components = [
                ("strike", self.dockwidget.strike_input_field),
                ("dip", self.dockwidget.dip_input_field),
                ("rake", self.dockwidget.rake_input_field),
            ]

            # Connect signals
            self.dockwidget.svgs_output_widget.setFilePath(get_plugin_output_dir())
            self.dockwidget.btn_make_svgs.clicked.connect(self.make_svgs)
            self.dockwidget.btn_plot.clicked.connect(self.plot_beachballs)

            self.dockwidget.depth_color_checkbox.stateChanged.connect(
                self.handle_depth_based_color_changed
            )

            self.dockwidget.regime_color_checkbox.stateChanged.connect(
                self.handle_regime_based_color_changed
            )

            self.dockwidget.depth_color_field.fieldChanged.connect(self.update_params)
            self.dockwidget.regime_color_field.fieldChanged.connect(self.update_params)

            # Connect signals for tensor component inputs
            self.dockwidget.id_field_select.fieldChanged.connect(self.update_params)
            for _, control in tensor_components:
                control.fieldChanged.connect(self.update_params)

            # Connect signals for sdp component inputs
            for _, control in sdp_components:
                control.fieldChanged.connect(self.update_params)

            self.dockwidget.events_layer_input.layerChanged.connect(
                self.handle_layer_changed
            )

            # Setup fields for the first time
            self.handle_layer_changed()
            self.update_params()
