# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EphemeralGullyDialog
                                 A QGIS plugin
 This plugin models the behaviour of the Ephemeral Gullies in terms of soil erosion
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-02-09
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Iñigo Barberena
        email                : inigo.barberena@unavarra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import pyqtSignal, Qt
from qgis.core import QgsWkbTypes, QgsPointXY, QgsApplication
from qgis.gui import QgsMapToolEmitPoint, QgsRubberBand

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'coordinate.ui'))


class Coordinate(QgsMapToolEmitPoint):
    mouseMoved = pyqtSignal(QgsPointXY)
    mouseClicked = pyqtSignal(QgsPointXY)

    def __init__(self, canvas):
        super(Coordinate, self).__init__(canvas)

        self.mapCanvas = canvas
        self.rubberBand = QgsRubberBand(self.mapCanvas, QgsWkbTypes.PolygonGeometry)
        self.rubberBand.setColor(Qt.red)
        self.rubberBand.setWidth(1)
        self.setCursor(QgsApplication.getThemeCursor(QgsApplication.Cursor.CrossHair))

    def canvasMoveEvent(self, e):
        originalPoint = QgsPointXY(self.mapCanvas.getCoordinateTransform().toMapCoordinates(e.x(), e.y()))
        self.mouseMoved.emit(originalPoint)

    def canvasPressEvent(self, e):
        if e.button() == Qt.LeftButton:
            originalPoint = QgsPointXY(self.mapCanvas.getCoordinateTransform().toMapCoordinates(e.x(), e.y()))
            self.mouseClicked.emit(originalPoint)

            point1 = QgsPointXY(self.mapCanvas.getCoordinateTransform().toMapCoordinates(e.x() - 1, e.y() - 1))
            point2 = QgsPointXY(self.mapCanvas.getCoordinateTransform().toMapCoordinates(e.x() + 1, e.y() - 1))
            point3 = QgsPointXY(self.mapCanvas.getCoordinateTransform().toMapCoordinates(e.x() + 1, e.y() + 1))
            point4 = QgsPointXY(self.mapCanvas.getCoordinateTransform().toMapCoordinates(e.x() - 1, e.y() + 1))

            self.rubberBand.reset(QgsWkbTypes.PolygonGeometry )

            self.rubberBand.addPoint(point1, False)
            self.rubberBand.addPoint(point2, False)
            self.rubberBand.addPoint(point3, False)
            self.rubberBand.addPoint(point4, True)
            self.rubberBand.show()

        elif e.button() == Qt.RightButton:
            self.deactivate()

    def deactivate(self):
        self.rubberBand.reset(QgsWkbTypes.LineGeometry)
        super(Coordinate, self).deactivate()