# -*- coding: utf-8 -*-
"""
/***************************************************************************
 qScs
                                 A QGIS plugin
 A QGIS Plugin to Determine Basin Properties for NRCS Peak Flow
Estimation in HEC-HMS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-08
        git sha              : $Format:%H$
        copyright            : (C) 2022 by sidar
        email                : sidar_qscs@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *

from qgis.core import *
from qgis.gui import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .q_scs_dialog import qScsDialog
import os.path
import processing
import sys
import datetime
import shutil
import time
import traceback
import threading
import math


class qScs:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'qScs_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&QSCS')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('qScs', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/q_scs/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Qscs'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&QSCS'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        print("run")
        """Run method that performs all the real work"""
        if self.first_start == True:
            self.first_start = False
            self.dlg = qScsDialog()
        # show the dialog
        self.dlg.show()
        self.init()
        self.taskManager = QgsApplication.taskManager()
        self.axa = self.dlg
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
    def exit_app(self):
        print("here")
        self.first_start = True
        self.dlg.exec_()
        self.dlg.close()       
    def init(self):
        self.instance = QgsProject.instance()
        self.cbox_dems = self.dlg.cbox_dems
        self.btn_next0 = self.dlg.btn_next0
        self.btn_next1 = self.dlg.btn_next1
        self.btn_next2 = self.dlg.btn_next2
        self.btn_next3 = self.dlg.btn_next3
        self.btn_next4 = self.dlg.btn_next4
        self.btn_next5 = self.dlg.btn_next5
        self.btn_next6 = self.dlg.btn_next6
        self.btn_next7 = self.dlg.btn_next7
        self.btn_cancel0 = self.dlg.btn_cancel0
        self.btn_cancel1 = self.dlg.btn_cancel1
        self.btn_cancel2 = self.dlg.btn_cancel2
        self.btn_cancel3 = self.dlg.btn_cancel3
        self.btn_cancel4 = self.dlg.btn_cancel4
        self.btn_cancel5 = self.dlg.btn_cancel5
        self.btn_cancel6 = self.dlg.btn_cancel6
        self.btn_cancel7 = self.dlg.btn_cancel7
        self.btn_run1 = self.dlg.btn_run1
        self.btn_run2 = self.dlg.btn_run2
        self.btn_run3 = self.dlg.btn_run3
        self.btn_run4 = self.dlg.btn_run4
        self.btn_run5 = self.dlg.btn_run5
        self.btn_run6 = self.dlg.btn_run6
        self.btn_run7 = self.dlg.btn_run7
        self.spinBox3 = self.dlg.spinBox3_0
        self.stackedWidget = self.dlg.stackedWidget
        self.stackedWidget.setCurrentIndex(0)
        self.allOutputs = dict()
        self.page0()

    def nextPage(self):
        currentId = self.stackedWidget.currentIndex() + 1
        self.stackedWidget.setCurrentIndex(currentId)
        return currentId

    def previousPage(self):
        currentId = self.stackedWidget.currentIndex() - 1
        self.stackedWidget.setCurrentIndex(currentId)
        return currentId

    def page0(self):
        self.stackedWidget.setCurrentIndex(0)
        self.btn_next0.clicked.connect(self.compilePage0)
        values = self.instance.mapLayers().values()
        self.dlg.btn_cancel0.clicked.connect(self.exit_app)
        dems = list()
        for l in values:
            dems.append(l.name())
        self.cbox_dems.addItems(dems)

    def page1(self):
        """Fill And Sinks"""
        self.btn_next1.setEnabled(False)
        self.dlg.btn_cancel1.clicked.connect(self.exit_app)
        self.btn_run1.clicked.connect(self.taskpage1)
        self.btn_next1.clicked.connect(self.page2)
    def taskpage1(self):
        self.dlg.lbl1_0.setText('Please Wait.')
        thread = self.thread1 = QThread()
        worker = self.worker1 = self.Worker1(self.allOutputs, self.layer, self.root, self.dlg.progressBar_1)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.progress_changed)
        worker.finished.connect(self.worker1Finished)
        thread.start()
    def worker1Finished(self, ls):
        self.worker1.deleteLater()
        self.thread1.quit()
        self.thread1.wait()
        self.thread1.deleteLater()
        
        if ls[0] == 1:
            self.dlg.lbl1_0.setText('Successful, please continue.')
            self.dlg.textBrowser_1.setText(
                'Fill And Sinks algorithm has been successfully completed.\nPlease continue.')
            self.dlg.progressBar_1.setValue(100)
            self.dlg.btn_next1.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl1_0.setText('Something went wrong.')
            self.dlg.textBrowser_1.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page2(self):
        self.nextPage()
        self.dlg.repaint()
        """Strahler Order"""
        self.btn_next2.setEnabled(False)
        self.dlg.btn_cancel2.clicked.connect(self.exit_app)
        self.btn_next2.clicked.connect(self.page3)
        self.btn_run2.clicked.connect(self.taskpage2)
    def taskpage2(self):
        self.dlg.lbl2_0.setText('Please Wait.')
        thread = self.thread2 = QThread()
        worker = self.worker2 = self.Worker2(self.allOutputs, self.root, self.dlg.progressBar_1)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.progress_changed)
        worker.finished.connect(self.worker2Finished)
        thread.start()
    def worker2Finished(self, ls):
        self.worker2.deleteLater()
        self.thread2.quit()
        self.thread2.wait()
        self.thread2.deleteLater()
        if ls[0] == 1:
            self.dlg.lbl2_0.setText('Successful, please continue.')
            self.dlg.textBrowser_2.setText(
                'Strahler Order algorithm has been successfully completed.\nPlease continue.')
            self.dlg.progressBar_2.setValue(100)
            self.dlg.btn_next2.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl2_0.setText('Something went wrong.')
            self.dlg.textBrowser_2.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page3(self):
        self.nextPage()
        self.dlg.repaint()
        """Channels network and drainage basins processing"""
        self.btn_next3.setEnabled(False)
        self.dlg.btn_cancel3.clicked.connect(self.exit_app)
        self.btn_next3.clicked.connect(self.page4)
        self.btn_run3.clicked.connect(self.taskpage3)
    def taskpage3(self):
        self.dlg.lbl3_0.setText('Please Wait.')
        thread = self.thread3 = QThread()
        worker = self.worker3 = self.Worker3(self.allOutputs, self.spinBox3, self.root, self.dlg.progressBar_1)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.progress_changed)
        worker.finished.connect(self.worker3Finished)
        thread.start()
    def worker3Finished(self, ls):
        self.worker3.deleteLater()
        self.thread3.quit()
        self.thread3.wait()
        self.thread3.deleteLater()
        if ls[0] == 1:
            self.dlg.lbl3_0.setText('Successful, please continue.')
            self.dlg.textBrowser_3.setText(
                'Channels Network and Drainage Basins algorithm has been successfully completed.\nPlease continue.')
            self.dlg.progressBar_3.setValue(100)
            self.dlg.btn_next3.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl3_0.setText('Something went wrong.')
            self.dlg.textBrowser_3.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page4(self):
        self.nextPage()
        self.dlg.repaint()
        """Catchment Delination"""
        self.index = 0
        self.canvas = self.dlg.canvas
        layers = list()
        layers.append(self.allOutputs['nodes'])
        layers.append(self.allOutputs['segments'])
        self.updateCanvas(layers)
        self.tool = QgsMapToolEmitPoint(self.canvas)
        self.canvas.setMapTool(self.tool)
        self.tool.canvasClicked.connect(self.cc)
        self.btn_next4.setEnabled(False)
        self.dlg.btn_cancel4.clicked.connect(self.exit_app)
        self.btn_next4.clicked.connect(self.page5)
        self.btn_run4.clicked.connect(self.taskpage4)
    def taskpage4(self):
        self.dlg.lbl4_0.setText('Please Wait.')
        thread = self.thread4 = QThread()
        worker = self.worker4 = self.Worker4(self.allOutputs, self.root, self.dlg.progressBar_1,self.xCoord,self.yCoord,self.index)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.progress_changed)
        worker.finished.connect(self.worker4Finished)
        thread.start()
    def worker4Finished(self, ls):
        self.worker4.deleteLater()
        self.thread4.quit()
        self.thread4.wait()
        self.thread4.deleteLater()
        if ls[0] == 1:
            self.dlg.lbl4_0.setText('Successful, please continue.')
            self.dlg.textBrowser_4.setText(
                'Look at the calculated boundary. If it seems logical click to continue.\nPlease continue.')
            self.updateCanvas(ls[1])
            self.dlg.progressBar_4.setValue(100)
            self.dlg.btn_next4.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl4_0.setText('Something went wrong.')
            self.dlg.textBrowser_4.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page5(self):
        self.nextPage()
        self.dlg.repaint()
        """Some algorithms"""
        self.dlg.btn_cancel5.clicked.connect(self.exit_app)
        self.btn_next5.clicked.connect(self.page6)
        self.btn_run5.clicked.connect(self.taskpage5)
    def taskpage5(self):
        self.dlg.lbl5_0.setText('Please Wait.')
        thread = self.thread5 = QThread()
        worker = self.worker5 = self.Worker5(self.allOutputs, self.layer,self.spinBox3, self.root,
        [self.dlg.progressBar5_0,self.dlg.progressBar5_1,self.dlg.progressBar5_2])
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.progress_changed)
        worker.finished.connect(self.worker5Finished)
        thread.start()
    def worker5Finished(self, ls):
        self.worker5.deleteLater()
        self.thread5.quit()
        self.thread5.wait()
        self.thread5.deleteLater()
        if ls[0] == 1:
            self.pointList = ls[1]
            self.dlg.lbl5_0.setText('Successful, please continue.')
            self.dlg.textBrowser_5.setText(
                'Successful.\nPlease continue.')
            self.dlg.progressBar5_0.setValue(100)
            self.dlg.progressBar5_1.setValue(100)
            self.dlg.progressBar5_2.setValue(100)
            self.dlg.btn_next5.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl5_0.setText('Something went wrong.')
            self.dlg.textBrowser_5.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page6(self):
        self.nextPage()
        self.dlg.repaint()
        """Fake delination of all subbasins"""
        self.dlg.btn_cancel6.clicked.connect(self.exit_app)
        self.btn_next6.clicked.connect(self.page7)
        self.btn_next6.setEnabled(False)
        self.btn_run6.clicked.connect(self.taskpage6)
        self.dlg.lbl6_0.setText('There are ' + str(len(
            self.pointList)) + ' nodes in total in the basin. The higher the number of nodes , the longer the processing time.' + 'Click to run.')
        self.dlg.lbl6_1.setText('0/' + str(len(self.pointList)))
    def taskpage6(self):
        self.dlg.lbl6_0.setText('Please Wait.')
        thread = self.thread6 = QThread()
        worker = self.worker6 = self.Worker6(self.allOutputs, self.root,self.pointList)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.task6Progress)
        worker.finished.connect(self.worker6Finished)
        thread.start()
    def task6Progress(self,ls):
        self.dlg.lbl6_1.setText(ls[0])
        self.dlg.progressBar6.setValue(ls[1])
    def worker6Finished(self, ls):
        self.worker6.deleteLater()
        self.thread6.quit()
        self.thread6.wait()
        self.thread6.deleteLater()
        if ls[0] == 1:
            self.subbasinsFake = ls[1]
            self.dlg.lbl6_0.setText('Successful, please continue.')
            self.dlg.textBrowser6.setText(
                'Successful.\nPlease continue.')
            self.dlg.progressBar6.setValue(100)
            self.dlg.btn_next6.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl6_0.setText('Something went wrong.')
            self.dlg.textBrowser6.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def updatePage(self, exp):
        self.dlg.repaint()

    def page7(self):
        self.nextPage()
        self.dlg.repaint()
        """Correction fake subbasins"""
        self.index = 0
        self.canvas2 = self.dlg.canvas_2
        self.dlg.btn_cancel7.clicked.connect(self.exit_app)
        self.btn_next7.clicked.connect(self.page8)
        self.btn_run7.clicked.connect(self.taskpage7)
    def taskpage7(self):
        self.dlg.lbl7_0.setText('Please Wait.')
        thread = self.thread7 = QThread()
        worker = self.worker7 = self.Worker7(self.allOutputs, self.subbasinsFake,self.pointList, self.root,
        self.dlg.progressBar7,self.index,self.instance)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.progress_changed)
        worker.finished.connect(self.worker7Finished)
        thread.start()
    def worker7Finished(self, ls):
        self.worker7.deleteLater()
        self.thread7.quit()
        self.thread7.wait()
        self.thread7.deleteLater()
        if ls[0] == 1:
            self.canvas2.setLayers(v for v in ls[1])
            self.canvas2.setExtent(ls[1][0].extent())
            self.canvas2.refresh()
            self.dlg.lbl7_0.setText('Successful, please continue.')
            self.dlg.textBrowser7.setText(
                'Successful.\nPlease continue.')
            self.dlg.progressBar7.setValue(100)
            self.dlg.btn_next7.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl7_0.setText('Something went wrong.')
            self.dlg.textBrowser7.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page8(self):
        self.nextPage()
        self.dlg.repaint()
        """All in one for hms"""
        self.dlg.btn_cancel8.clicked.connect(self.exit_app)
        self.dlg.btn_next8.clicked.connect(self.page9)
        self.dlg.btn_run8.clicked.connect(self.taskpage8)
    def taskpage8(self):
        self.dlg.lbl8_0.setText('Please Wait.')
        thread = self.thread8 = QThread()
        worker = self.worker8 = self.Worker8(self.allOutputs, self.root,self.instance,self.dlg)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.finished.connect(self.worker8Finished)
        thread.start()
    def worker8Finished(self, ls):
        self.worker8.deleteLater()
        self.thread8.quit()
        self.thread8.wait()
        self.thread8.deleteLater()
        if ls[0] == 1:
            self.instance.addMapLayer(ls[1])
            self.dlg.lbl8_0.setText('Successful, please continue.')
            self.dlg.textBrowser8.setText('Successful.\nPlease continue.')
            self.dlg.btn_next8.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl8_0.setText('Something went wrong.')
            self.dlg.textBrowser8.setText('ERROR:' + '\n' + ls[1])
        elif ls[0] == 444:
            self.instance.addMapLayer(ls[1])
            self.dlg.lbl8_0.setText('Successful.\nPlease continue.')
            self.dlg.textBrowser8.setText('Succesfull but layer has not been saved. Please do it manually.\nPlease continue.')
            self.dlg.btn_next8.setEnabled(True)
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page9(self):
        self.nextPage()
        self.dlg.repaint()
        """Calc Tcs"""
        self.dlg.btn_cancel9.clicked.connect(self.exit_app)
        self.dlg.btn_next9.clicked.connect(self.page10)
        self.dlg.btn_run9.clicked.connect(self.taskpage9)
    def taskpage9(self):
        self.dlg.lbl9_0.setText('Please Wait.')
        thread = self.thread9 = QThread()
        worker = self.worker9 = self.Worker9(self.allOutputs, self.root,
        [self.dlg.progressBar9_0,self.dlg.progressBar9_1,self.dlg.progressBar9_2,self.dlg.progressBar9_3])
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.progress_changed)
        worker.progress2.connect(self.task9Progress)
        worker.finished.connect(self.worker9Finished)
        thread.start()
    def task9Progress(self,ls):
        self.dlg.lbl9_0.setText(ls[0])
        self.dlg.progressBar9_3.setValue(ls[1])
    def worker9Finished(self, ls):
        self.worker9.deleteLater()
        self.thread9.quit()
        self.thread9.wait()
        self.thread9.deleteLater()
        if ls[0] == 1:
            self.dlg.lbl9_0.setText('Successful, please continue.')
            self.dlg.progressBar9_3.setValue(100)
            self.dlg.textBrowser9.setText('Successful.\nPlease continue.')
            self.dlg.btn_next9.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl9_0.setText('Something went wrong.')
            self.dlg.textBrowser9.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page10(self):
        self.nextPage()
        self.dlg.repaint()
        """Determination of CN values"""
        self.dlg.btn_cancel10.clicked.connect(self.exit_app)
        self.dlg.btn_next10.clicked.connect(self.page11)
        self.dlg.btn_run10.clicked.connect(self.taskpage10)
        values = self.instance.mapLayers().values()
        dems = list()
        for l in values:
            dems.append(l.name())
        self.dlg.comboBox10.addItems(dems)
    def taskpage10(self):
        self.dlg.lbl10_0.setText('Please Wait.')
        thread = self.thread10 = QThread()
        worker = self.worker10 = self.Worker10(self.allOutputs, self.root,
                                               self.dlg,self.instance,self.layer)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.finished.connect(self.worker10Finished)
        thread.start()
    def worker10Finished(self, ls):
        self.worker10.deleteLater()
        self.thread10.quit()
        self.thread10.wait()
        self.thread10.deleteLater()
        if ls[0] == 1:
            self.dlg.lbl10_0.setText('Successful, please continue.')
            self.dlg.textBrowser10.setText('Successful.\nPlease continue.')
            self.dlg.btn_next10.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl10_0.setText('Something went wrong.')
            self.dlg.textBrowser10.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def page11(self):
        self.nextPage()
        self.dlg.repaint()
        """Write hms file"""
        self.dlg.btn_cancel11.clicked.connect(self.exit_app)
        self.dlg.btn_finish11.clicked.connect(self.exit_app)
        self.dlg.btn_run11.clicked.connect(self.taskpage11)
    def taskpage11(self):
        self.dlg.lbl11_0.setText('Please Wait.')
        thread = self.thread11 = QThread()
        worker = self.worker11 = self.Worker11(self.allOutputs, self.root,
                                               self.dlg.progressBar11)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.progress.connect(self.progress_changed)
        worker.finished.connect(self.worker11Finished)
        thread.start()
    def worker11Finished(self, ls):
        self.worker11.deleteLater()
        self.thread11.quit()
        self.thread11.wait()
        self.thread11.deleteLater()
        #Type here
        catchment = self.allOutputs['allinone_saved']
        table = self.dlg.tableWidget
        x1 = float(table.item(0, 0).text())*5/60
        x2 = float(table.item(1, 0).text())*15/60
        x3 = float(table.item(2, 0).text())
        x4 = float(table.item(3, 0).text())*2
        x5 = float(table.item(4, 0).text())*3
        x6 = float(table.item(5, 0).text())*6
        x7 = float(table.item(6, 0).text())*12
        x8 = float(table.item(7, 0).text())*24
        cn = 0
        Area = 0
        tC = 0
        P = x8
        Fp = 1
        for f in catchment.getFeatures():
            tc = f[12]/60
            Area = f[3]
            cn = f[8]
        S = 25400/cn - 254
        Q = (P-0.2*S)**2/(P+0.8*S)
        x = 0.2*S/P
        C0 = -1.9641*x**3 - 0.3874*x**2 - 0.0322*x + 2.5621
        C1 =  5.5306*x**3 - 3.5681*x**2 + 0.6723*x - 0.6521
        C2 = -40.457*x**4 + 46.876*x**3 - 18.018*x**2 + 2.9681*x - 0.3235
        
        qu = 10**(C0 + C1 * math.log10(tc) + C2*(math.log10(tc))**2 - 3.3552)
        qp = qu * Area * Q * Fp
        #
        if ls[0] == 1:
            self.dlg.progressBar11.setValue(100)
            self.dlg.lbl11_0.setText('Successful, please continue.')
            self.dlg.textBrowserResult.setText('Peak Discharge:' + '\n' + str(qp) + ' m3/s')
            self.dlg.textBrowser11.setText('Successful.' + '\n' + 'Directory of the project:\n' + self.root + "/HecHms")
            self.dlg.btn_finish11.setEnabled(True)
        elif ls[0] == -1:
            self.dlg.lbl11_0.setText('Something went wrong.')
            self.dlg.textBrowser11.setText('ERROR:' + '\n' + ls[1])
        else:
            print('User canceled.')
        self.dlg.repaint()

    def updateCanvas(self, layers):
        self.canvas.clearCache()
        for i in self.instance.mapLayers().values():
            if i.name() == 'OpenStreetMap':
                i = i
                break
        layers.append(i)
        self.canvas.setLayers(v for v in layers)
        self.canvas.setExtent(layers[0].extent())
        self.canvas.refresh()
        self.dlg.repaint()

    def cc(self, pnt):
        print(pnt)
        self.xCoord = pnt.x()
        self.yCoord = pnt.y()
        self.dlg.lbl4_1.setText('Coordinates:' + str(pnt.x()) + ',' + str(pnt.y()))

    def compilePage0(self):
        self.root = self.dlg.file_1.filePath()
        layname = self.cbox_dems.currentText()
        values = self.instance.mapLayers().values()
        for v in values:
            if layname == v.name():
                self.layer = v
                self.allOutputs['main_dem'] = v
                break
        if self.layer.type() != 1:
            msg = QMessageBox()
            msg.setText('Please select a raster map!')
            msg.setStandardButtons(QMessageBox.Ok)
            return_value = msg.exec()
            return
        if self.root == "":
            msg = QMessageBox()
            msg.setText('Please select a folder!')
            msg.setStandardButtons(QMessageBox.Ok)
            return_value = msg.exec()
            return
        self.nextPage()
        self.dlg.repaint()
        self.page1()

    def progress_changed(self, bar, progress):
        try:
            bar.setValue(progress)
        except:
            print("Unexpected error:", sys.exc_info()[0])
            bar.setValue(100)

    class Worker1(QObject):
        def __init__(self, dict, layer, root, bar, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.layer = layer
            self.root = root
            self.bar = bar
        def changed(self, bar, val):
            self.progress.emit(bar, val)
        def run(self):
            f = QgsProcessingFeedback()
            f.progressChanged.connect(lambda: self.changed(self.bar, f.progress()))
            try:
                out = processing.run('saga:fillsinkswangliu',
                                     {'ELEV': self.layer.clone(), 'MINSLOPE': 0.01,
                                      'FILLED': self.root + '/filled.sdat',
                                      'FDIR': self.root + '/directions.sdat',
                                      'WSHED': self.root + '/basins.sdat'}, feedback=f)
                self.allOutputs['filled_dem'] = QgsRasterLayer(out['FILLED'], 'filled_dem', 'gdal')
                self.finished.emit([1])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1,traceback.format_exc()])
        progress = QtCore.pyqtSignal(QProgressBar, int)
        finished = QtCore.pyqtSignal(list)
    class Worker2(QObject):
        def __init__(self, dict, root, bar, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.root = root
            self.bar = bar
        def changed(self, bar, val):
            self.progress.emit(bar, val)
        def run(self):
            f = QgsProcessingFeedback()
            f.progressChanged.connect(lambda: self.changed(self.bar, f.progress()))
            try:
                out = processing.run('saga:strahlerorder',
                                     {'DEM': self.allOutputs['filled_dem'], 'STRAHLER': self.root + '/strahler.sdat'},
                                     feedback=f)
                self.allOutputs['strahler_order'] = QgsRasterLayer(out['STRAHLER'], 'strahler_order', 'gdal')
                self.finished.emit([1])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])
        progress = QtCore.pyqtSignal(QProgressBar, int)
        finished = QtCore.pyqtSignal(list)

    class Worker3(QObject):
        def __init__(self, dict, spinbox, root, bar, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.spinBox3 = spinbox
            self.root = root
            self.bar = bar
        def changed(self, bar, val):
            self.progress.emit(bar, val)
        def run(self):
            f = QgsProcessingFeedback()
            f.progressChanged.connect(lambda: self.changed(self.bar, f.progress()))
            try:
                out = processing.run('saga:channelnetworkanddrainagebasins',
                                     {'DEM': self.allOutputs['filled_dem'],
                                      'THRESHOLD': self.spinBox3.value(),
                                      'DIRECTION': self.root + '/direction.sdat',
                                      'CONNECTION': self.root + '/connection.sdat',
                                      'ORDER': self.root + '/order.sdat',
                                      'BASIN': self.root + '/basin.sdat',
                                      'SEGMENTS': self.root + '/segments.shp',
                                      'BASINS': self.root + '/basins.shp',
                                      'NODES': self.root + '/nodes.shp'
                                      }, feedback=f)
                self.allOutputs['directions'] = QgsRasterLayer(out['DIRECTION'], 'directions', 'gdal')
                self.allOutputs['connections'] = QgsRasterLayer(out['CONNECTION'], 'connections', 'gdal')
                self.allOutputs['segments'] = QgsVectorLayer(out['SEGMENTS'], 'segments', 'ogr')
                self.allOutputs['nodes'] = QgsVectorLayer(out['NODES'], 'nodes', 'ogr')
                self.finished.emit([1])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])
        progress = QtCore.pyqtSignal(QProgressBar, int)
        finished = QtCore.pyqtSignal(list)

    class Worker4(QObject):
        def __init__(self, dict, root, bar,xcoord,ycoord,index, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.root = root
            self.bar = bar
            self.xCoord = xcoord
            self.yCoord = ycoord
            self.index = index
        def changed(self, bar, val):
            self.progress.emit(bar, val)
        def run(self):
            f = QgsProcessingFeedback()
            f.progressChanged.connect(lambda: self.changed(self.bar, f.progress()))
            try:
                print('started')
                output_1 = processing.run("saga:upslopearea", {'TARGET_PT_X': self.xCoord, 'TARGET_PT_Y': self.yCoord,
                'ELEVATION': self.allOutputs['filled_dem'], 'METHOD': 0,
                'AREA': self.root + '/upslope' + str(self.index) + '.sdat'})
                print(output_1['AREA'])
                output_2 = processing.run("gdal:polygonize",
                                          {'INPUT': output_1['AREA'], 'BAND': '1', 'EIGHT_CONNECTEDNESS': '8',
                                           'OUTPUT': self.root + '/polygonize' + str(self.index) + '.shp'})
                output_3 = processing.run("qgis:extractbyattribute",
                                          {'INPUT': output_2['OUTPUT'], 'FIELD': 'DN', 'OPERATOR': '0', 'VALUE': '100',
                                           'OUTPUT': self.root + '/boundary' + str(self.index) + '.shp'}, feedback=f)
                l = QgsVectorLayer(output_3['OUTPUT'], 'boundary', "ogr")
                self.allOutputs['boundary'] = QgsVectorLayer(output_3['OUTPUT'], 'boundary', "ogr")
                for ft in l.getFeatures():
                    if ft.geometry().isGeosValid() == False:
                        self.index = self.index + 1
                        out_4 = processing.run("native:fixgeometries", {'INPUT': output_3['OUTPUT'],
                                                                        'OUTPUT': self.root + '/boundary' + str(
                                                                            self.index) + '.shp'})
                        self.allOutputs['boundary'] = QgsVectorLayer(out_4['OUTPUT'], 'boundary', "ogr")
                        break
                layers = list()
                layers.append(self.allOutputs['nodes'])
                layers.append(self.allOutputs['segments'])
                layers.append(self.allOutputs['boundary'])
                self.index = self.index + 1
                self.finished.emit([1,layers])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])
        progress = QtCore.pyqtSignal(QProgressBar, int)
        finished = QtCore.pyqtSignal(list)

    class Worker5(QObject):
        def __init__(self, dict,layer,spinbox, root, bars, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.layer = layer
            self.spinBox3 = spinbox
            self.root = root
            self.bar0 = bars[0]
            self.bar1 = bars[1]
            self.bar2 = bars[2]
        def changed(self, bar, val):
            self.progress.emit(bar, val)
        def run(self):
            f = QgsProcessingFeedback()
            f.progressChanged.connect(
            lambda: self.changed(self.bar0, f.progress()))
            try:
                ext = self.allOutputs['boundary'].extent()
                ext.scale(1.1)
                xmin = ext.xMinimum()
                xmax = ext.xMaximum()
                ymin = ext.yMinimum()
                ymax = ext.yMaximum()
                coords = "%f,%f,%f,%f" % (xmin, xmax, ymin, ymax)
                output_0 = processing.run("gdal:cliprasterbyextent", {'INPUT': self.layer,
                                                                      'PROJWIN': coords,
                                                                      'OUTPUT': self.root + '/second_filled_dem.tif'},
                                          feedback=f)
                self.allOutputs['second_dem'] = QgsRasterLayer(output_0['OUTPUT'], 'second_dem', 'gdal')
                output_1 = processing.run('saga:fillsinkswangliu',
                                          {'ELEV': self.allOutputs['second_dem'], 'MINSLOPE': 0.01,
                                           'FILLED': self.root + '/second_filled.sdat',
                                           'FDIR': self.root + '/second_directions.sdat',
                                           'WSHED': self.root + '/second_basins.sdat'}, feedback=f)
                self.allOutputs['filled_dem'] = QgsRasterLayer(output_1['FILLED'], 'second_filled_dem', 'gdal')
                out_strahler = processing.run('saga:strahlerorder',
                                              {'DEM': self.allOutputs['filled_dem'],
                                               'STRAHLER': self.root + '/second_strahler.sdat'},
                                              feedback=f)
                self.allOutputs['strahler_order'] = QgsRasterLayer(out_strahler['STRAHLER'], 'strahler_order', 'gdal')
                print("value:")
                print(self.spinBox3.value())
                print(type(self.spinBox3.value()))
                out = processing.run('saga:channelnetworkanddrainagebasins',
                                     {'DEM': self.allOutputs['filled_dem'],
                                      'THRESHOLD': self.spinBox3.value(),
                                      'DIRECTION': self.root + '/direction_sc.sdat',
                                      'CONNECTION': self.root + '/connection_sc.sdat',
                                      'ORDER': self.root + '/order_sc.sdat',
                                      'BASIN': self.root + '/basin_sc.sdat',
                                      'SEGMENTS': self.root + '/segments_sc.shp',
                                      'BASINS': self.root + '/basins_sc.shp',
                                      'NODES': self.root + '/nodes_sc.shp'
                                      }, feedback=f)
                self.allOutputs['directions'] = QgsRasterLayer(out['DIRECTION'], 'directions_sc', 'gdal')
                self.allOutputs['connections'] = QgsRasterLayer(out['CONNECTION'], 'connections_sc', 'gdal')
                self.allOutputs['segments'] = QgsVectorLayer(out['SEGMENTS'], 'segments_sc', 'ogr')
                self.allOutputs['nodes'] = QgsVectorLayer(out['NODES'], 'nodes_sc', 'ogr')
                out1 = processing.run('native:intersection',{'INPUT': self.allOutputs['nodes'],
                'OVERLAY': self.allOutputs['boundary'],'OUTPUT': self.root + '/sub_junctions.shp'})
                out2 = processing.run('native:intersection',{'INPUT': self.allOutputs['segments'],
                'OVERLAY': self.allOutputs['boundary'],'OUTPUT': self.root + '/sub_channels.shp'}, feedback=f)

                self.allOutputs['sub_junctions'] = QgsVectorLayer(out1['OUTPUT'], 'sub_junctions', 'ogr')
                self.allOutputs['sub_channels'] = QgsVectorLayer(out2['OUTPUT'], 'sub_channels', 'ogr')
                layer = self.allOutputs['sub_junctions']
                for c in self.allOutputs['sub_channels'].getFeatures():
                    for j in self.allOutputs['sub_junctions'].getFeatures():
                        if c[2] == j[0]:
                            bool = False
                            break
                        bool = True
                    if bool:
                        seg = c
                        break
                caps = self.allOutputs['sub_junctions'].dataProvider().capabilities()
                vertices = list()
                for v in seg.geometry().vertices():
                    vertices.append(v)
                if caps & QgsVectorDataProvider.AddFeatures:
                    feat = QgsFeature(layer.fields())
                    feat.setAttributes([seg[2], 'Outlet', 100])
                    feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(vertices[-2].x(), vertices[-2].y())))
                    (res, outFeats) = layer.dataProvider().addFeatures([feat])
                # length calculation based on Cartesian coord system
                # expression = QgsExpression('LENGTH($geometry)')
                # length calculation based on Ellipsoidal coord system
                expression = QgsExpression('$length')
                context = QgsExpressionContext()
                context.appendScopes(
                    QgsExpressionContextUtils.globalProjectLayerScopes(self.allOutputs['sub_channels']))
                with edit(self.allOutputs['sub_channels']):
                    for f in self.allOutputs['sub_channels'].getFeatures():
                        context.setFeature(f)
                        f['LENGTH'] = expression.evaluate(context)
                        self.allOutputs['sub_channels'].updateFeature(f)
                self.allOutputs['sub_junctions'].dataProvider().addAttributes(
                    [QgsField("coordX", QVariant.Double),
                     QgsField("coordY", QVariant.Double)])
                expressionX = QgsExpression('X($geometry)')
                expressionY = QgsExpression('Y($geometry)')
                context = QgsExpressionContext()
                context.appendScopes(QgsExpressionContextUtils.globalProjectLayerScopes(layer))
                with edit(layer):
                    for f in layer.getFeatures():
                        context.setFeature(f)
                        f['coordX'] = expressionX.evaluate(context)
                        f['coordY'] = expressionY.evaluate(context)
                        layer.updateFeature(f)
                self.def_str = self.spinBox3.value()
                raster = self.allOutputs['filled_dem']
                self.directionRaster = self.allOutputs['directions']
                self.xunit = raster.rasterUnitsPerPixelX()
                self.yunit = raster.rasterUnitsPerPixelY()
                pointLy = self.allOutputs['sub_junctions']
                juncList = list()
                for feat in pointLy.getFeatures():
                    if feat[1] == "Junction":
                        juncList.append(QgsPointXY(feat[3], feat[4]))
                    elif feat[1] == "Outlet":  # or feat[1]=="Outlet"
                        juncList.append(QgsPointXY(feat[3], feat[4]))
                self.strahlerList = dict()
                self.strahlerValues = dict()
                self.pointList = list()
                for j in juncList:
                    self.getNeighbourCoords(j)
                    self.getStrahlerValues(self.allOutputs['strahler_order'])
                    self.createPoints(self.allOutputs['filled_dem'])
                self.finished.emit([1,self.pointList])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])

        def getNeighbourCoords(self, p):
            i = 0
            self.strahlerList[i] = QgsPointXY(p.x() - self.xunit, p.y() + self.yunit)
            self.strahlerList[i + 1] = QgsPointXY(p.x(), p.y() + self.yunit)
            self.strahlerList[i + 2] = QgsPointXY(p.x() + self.xunit, p.y() + self.yunit)
            self.strahlerList[i + 3] = QgsPointXY(p.x() - self.xunit, p.y())
            self.strahlerList[i + 4] = QgsPointXY(p.x(), p.y())
            self.strahlerList[i + 5] = QgsPointXY(p.x() + self.xunit, p.y())
            self.strahlerList[i + 6] = QgsPointXY(p.x() - self.xunit, p.y() - self.yunit)
            self.strahlerList[i + 7] = QgsPointXY(p.x(), p.y() - self.yunit)
            self.strahlerList[i + 8] = QgsPointXY(p.x() + self.xunit, p.y() - self.yunit)
        def getStrahlerValues(self, rst):
            i = 0
            for p in self.strahlerList:
                val, res = rst.dataProvider().sample(self.strahlerList.get(p), 1)
                if res is False:
                    print("Something went wrong")
                    print(p)
                    break
                else:
                    self.strahlerValues[i] = val
                    i = i + 1
        def createPoints(self, rst):
            v = self.strahlerValues.get(4)
            e, x = rst.dataProvider().sample(self.strahlerList.get(4), 1)
            if x == False:
                print("Error: 0x01")
                return
            for i in self.strahlerValues:
                print("i:" + str(i))
                n = self.strahlerValues.get(i)
                l, x = rst.dataProvider().sample(self.strahlerList.get(i), 1)
                if i == 4:
                    print("i==4")
                    continue
                if x == False:
                    print("Error: 0x02")
                    break
                if v >= n and n >= self.def_str and e <= l and self.direction(i):
                    self.addPoints(self.strahlerList.get(i))
                    print(self.strahlerList.get(i))
        def addPoints(self, pnt):
            self.pointList.append(pnt)
        def direction(self, i):
            res, val = self.directionRaster.dataProvider().sample(self.strahlerList.get(i), 1)
            if i == 0:
                return res == 3
            elif i == 1:
                return res == 4
            elif i == 2:
                return res == 5
            elif i == 3:
                return res == 2
            elif i == 4:
                return False
            elif i == 5:
                return res == 6
            elif i == 6:
                return res == 1
            elif i == 7:
                return res == 0
            elif i == 8:
                return res == 7
            else:
                print('ERROR 0x10')
        progress = QtCore.pyqtSignal(QProgressBar, int)
        finished = QtCore.pyqtSignal(list)

    class Worker6(QObject):
        def __init__(self, dict, root, pointlist, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.pointList = pointlist
            self.root = root
        def changed(self, ls):
            self.progress.emit(ls)
        def run(self):
            try:
                self.subbasinsFake = list()
                self.ind = 0
                extent = self.allOutputs['boundary'].extent()
                extent.scale(1.2)
                output = processing.run("gdal:cliprasterbyextent",
                {'INPUT': self.allOutputs['filled_dem'],'PROJWIN': extent,
                        'OUTPUT': self.root + '/minidem.sdat'})
                os.mkdir(self.root + '/junks')
                for i in self.pointList:
                    x_c = i.x()
                    y_c = i.y()
                    self.changed(
                        [str(self.ind + 1) + '/' + str(len(self.pointList)),
                         int(100*(self.ind + 1)/len(self.pointList))])
                    output_1 = processing.run("saga:upslopearea", {'TARGET_PT_X': x_c, 'TARGET_PT_Y': y_c,
                                                                   'ELEVATION': output['OUTPUT'], 'METHOD': 0,
                                                                   'AREA': self.root + '/junks/subupslope' + str(
                                                                       self.ind) + '.sdat'})
                    output_2 = processing.run("gdal:polygonize",
                                              {'INPUT': output_1['AREA'], 'BAND': '1', 'EIGHT_CONNECTEDNESS': '8',
                                               'OUTPUT': self.root + '/subpolygonize' + str(
                                                   self.ind) + '.shp'})
                    output_3 = processing.run("qgis:extractbyattribute",
                                              {'INPUT': output_2['OUTPUT'], 'FIELD': 'DN', 'OPERATOR': '0',
                                               'VALUE': '100',
                                               'OUTPUT': self.root + '/subbyatt' + str(self.ind) + '.shp'})
                    l = QgsVectorLayer(output_3['OUTPUT'], "basin{}".format(str(self.ind)), "ogr")
                    for ft in l.getFeatures():
                        self.allOutputs['basin{}'.format(str(self.ind))] = QgsVectorLayer(
                            output_3['OUTPUT'],"basin{}".format(str(self.ind)),"ogr")
                        if ft.geometry().isGeosValid() == False:
                            out_4 = processing.run("native:fixgeometries",
                            {'INPUT': output_3['OUTPUT'],'OUTPUT': self.root + '/subbyattfixed' + str(self.ind) + '.shp'})
                            self.allOutputs['basin{}'.format(str(self.ind))] = QgsVectorLayer(
                                out_4['OUTPUT'],"basin{}".format(str(self.ind)), "ogr")
                            break
                    self.subbasinsFake.append(self.allOutputs['basin{}'.format(str(self.ind))])
                    self.ind = self.ind + 1
                output_4 = processing.run('qgis:mergevectorlayers',
                                          {'LAYERS': self.subbasinsFake, 'OUTPUT': self.root + '/allinone.shp'})
                self.allOutputs['allinone'] = QgsVectorLayer(output_4['OUTPUT'], 'allinone', 'ogr')

                shutil.rmtree(self.root + '/junks')

                for l in self.subbasinsFake:
                    geoms = list()
                    feats = list()
                    for f in l.getFeatures():
                        feats.append(f)
                        geoms.append(f.geometry())
                    for f in feats:
                        feat = f
                        ind = 0
                        for f in feats:
                            if ind == 0:
                                ind = ind + 1
                            else:
                                g1 = feat.geometry()
                                g1 = g1.combine(f.geometry())
                                feat.setGeometry(g1)
                        break
                    ids = list()
                    for f in l.getFeatures():
                        ids.append(f.id())
                    res = l.dataProvider().deleteFeatures(ids)
                    l.dataProvider().addFeatures([feat])
                    l.updateExtents()
                    l.commitChanges()
                self.finished.emit([1,self.subbasinsFake])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])
        progress = QtCore.pyqtSignal(list)
        finished = QtCore.pyqtSignal(list)

    class Worker7(QObject):
        def __init__(self, dict,subbasinsfake,pointlist, root, bar,index,instance, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.subbasinsFake = subbasinsfake
            self.pointList = pointlist
            self.root = root
            self.bar = bar
            self.index = index
            self.instance = instance
        def changed(self, bar, val):
            self.progress.emit(bar, val)
        def run(self):
            f = QgsProcessingFeedback()
            f.progressChanged.connect(lambda: self.changed(self.bar, f.progress()))
            try:
                control = dict()
                updatedLayers = dict()
                for i in range(0, len(self.pointList)):
                    control['basin' + str(i)] = list()
                for i in self.subbasinsFake:
                    for f1 in i.getFeatures():
                        g1 = f1.geometry()
                        break
                    for f1 in i.getFeatures():
                        g1 = g1.combine(f1.geometry())
                    for j in self.subbasinsFake:
                        for f2 in j.getFeatures():
                            g2 = f2.geometry()
                        if i.name() == j.name():
                            print('same name')
                        elif g1.contains(g2):
                            print(i.name())
                            control[i.name()].append(j.name())
                for i in control:
                    lrs = list()
                    for j in control[i]:
                        lrs.append(self.allOutputs[j])
                    if len(lrs) is not 0:
                        out = processing.run('qgis:mergevectorlayers', {'LAYERS': lrs, 'OUTPUT': "memory:del_" + i},
                                             feedback=f)
                        out2 = processing.run('native:difference',
                                              {'INPUT': self.allOutputs[i], 'OVERLAY': out['OUTPUT'],
                                               'OUTPUT': "memory:difBas_" + i}, feedback=f)
                        updatedLayers[i] = out2['OUTPUT']
                    else:
                        print('Check here later.')
                for i in updatedLayers:
                    updatedLayers[i].setName(i)
                    self.allOutputs[i] = updatedLayers[i]
                layers = list()
                for lay in self.allOutputs:
                    if lay.startswith('basin'):
                        layers.append(self.allOutputs[lay])
                for i in self.instance.mapLayers().values():
                    if i.name() == 'OpenStreetMap':
                        i = i
                        break
                layers.append(i)
                self.finished.emit([1, layers])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])
        progress = QtCore.pyqtSignal(QProgressBar, int)
        finished = QtCore.pyqtSignal(list)

    class Worker8(QObject):
        def __init__(self, dict, root,instance,dlg, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.root = root
            self.instance = instance
            self.dlg = dlg
        def createTable(self):
            self.tableWidget = self.dlg.table8
            j = 0
            for i in self.allOutputs['allinone_new'].getFeatures():
                j = j + 1
            self.tableWidget.setRowCount(j + 1)
            self.tableWidget.setColumnCount(2)
            self.tableWidget.setItem(0, 0, QTableWidgetItem("Name"))
            self.tableWidget.setItem(0, 1, QTableWidgetItem("Area_sqkm"))
            j = 1
            for f in self.allOutputs['allinone_new'].getFeatures():
                self.tableWidget.setItem(j, 0, QTableWidgetItem(str(f[0])))
                self.tableWidget.setItem(j, 1, QTableWidgetItem(str(f[3])))
                j = j + 1
            self.tableWidget.horizontalHeader().setStretchLastSection(True)
            self.tableWidget.horizontalHeader().setSectionResizeMode(QHeaderView.Stretch)
        def run(self):
            try:
                vl = QgsVectorLayer("Polygon", "Allinone_new", 'memory')
                self.instance.addMapLayer(vl)
                self.allOutputs['allinone_new'] = vl
                crs = vl.crs()
                crs.createFromId(3857)
                vl.setCrs(crs)
                pr = vl.dataProvider()
                pr.addAttributes([QgsField("name", QVariant.String),
                                  QgsField("centroid_x", QVariant.Double),
                                  QgsField("centroid_y", QVariant.Double),
                                  QgsField("area_sqkm", QVariant.Double),
                                  QgsField("latitude", QVariant.Double),
                                  QgsField("longitude", QVariant.Double),
                                  QgsField("basinid", QVariant.Int),
                                  QgsField("Flow_length", QVariant.Double)
                                  ])
                vl.updateFields()
                layers = list()
                features = list()
                for i in self.allOutputs:
                    if i.startswith('basin'):
                        layers.append(self.allOutputs[i])
                for l in layers:
                    for f in l.getFeatures():
                        fet = QgsFeature(vl.fields())
                        fet.setGeometry(f.geometry())
                        features.append(fet)
                pr.addFeatures(features)
                vl.updateExtents()
                vl.commitChanges()
                crsSrc = QgsCoordinateReferenceSystem("EPSG:3857")  # WGS 84
                crsDest = QgsCoordinateReferenceSystem("EPSG:4326")  # WGS 84 / UTM zone 33N
                transformContext = self.instance.transformContext()
                xform = QgsCoordinateTransform(crsSrc, crsDest, transformContext)
                lay = self.allOutputs['allinone_new']
                expression1 = QgsExpression('x(centroid($geometry))')
                expression2 = QgsExpression('y(centroid($geometry))')
                # area calculation based on cartesian coord system
                # expression3 = QgsExpression('area($geometry)/1000/1000')
                # area calculation based on ellipsoidal coord system
                expression3 = QgsExpression('$area/1000/1000')
                context = QgsExpressionContext()
                context.appendScopes(QgsExpressionContextUtils.globalProjectLayerScopes(vl))
                lay.startEditing()
                i = 0
                for f in lay.getFeatures():
                    context = QgsExpressionContext()
                    context.appendScopes(QgsExpressionContextUtils.globalProjectLayerScopes(vl))
                    context.setFeature(f)
                    f['name'] = 'basin' + str(i)
                    f['basinid'] = i + 1
                    cx = expression1.evaluate(context)
                    cy = expression2.evaluate(context)
                    f['centroid_x'] = cx
                    f['centroid_y'] = cy
                    f['area_sqkm'] = expression3.evaluate(context)
                    pt = xform.transform(QgsPointXY(cx, cy))
                    f['longitude'] = pt.x()
                    f['latitude'] = pt.y()
                    i = i + 1
                    lay.updateFeature(f)
                    lay.updateExtents()
                lay.commitChanges()
                save_options = QgsVectorFileWriter.SaveVectorOptions()
                save_options.driverName = "ESRI Shapefile"
                save_options.fileEncoding = "UTF-8"
                crs = QgsCoordinateReferenceSystem().createFromString("EPSG:<3857>")
                transform_context = self.instance.transformContext()
                error = QgsVectorFileWriter.writeAsVectorFormatV2(vl, self.root + '/Allinone_new.shp',
                                                                  transform_context,
                                                                  save_options)
                self.allOutputs['allinone_saved'] = QgsVectorLayer(self.root + '/Allinone_new.shp', 'Catchment', 'ogr')
                self.createTable()
                if error[0] == QgsVectorFileWriter.NoError:
                    self.finished.emit([1, self.allOutputs['allinone_saved']])
                else:
                    self.finished.emit([444, self.allOutputs['allinone_saved']])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])
        finished = QtCore.pyqtSignal(list)

    class Worker9(QObject):
        def __init__(self, dict, root, bars, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.root = root
            self.bar0 = bars[0]
            self.bar1 = bars[1]
            self.bar2 = bars[2]
            self.bar3 = bars[3]
        def changed(self, bar, val):
            self.progress.emit(bar, val)
        def run(self):
            f1 = QgsProcessingFeedback()
            f2 = QgsProcessingFeedback()
            f3 = QgsProcessingFeedback()
            f4 = QgsProcessingFeedback()
            f1.progressChanged.connect(lambda: self.changed(self.bar0, f1.progress()))
            f2.progressChanged.connect(lambda: self.changed(self.bar1, f2.progress()))
            f3.progressChanged.connect(lambda: self.changed(self.bar2, f3.progress()))
            f4.progressChanged.connect(lambda: self.changed(self.bar3, f4.progress()))
            try:
                out = processing.run('saga:channelnetworkanddrainagebasins',
                                     {'DEM': self.allOutputs['filled_dem'],
                                      'THRESHOLD': 1,
                                      'DIRECTION': self.root + '/directionFull.sdat',
                                      'CONNECTION': self.root + '/connectionFull.sdat',
                                      'ORDER': self.root + '/orderFull.sdat',
                                      'BASIN': self.root + '/basinFull.sdat',
                                      'SEGMENTS': self.root + '/segmentsFull.shp',
                                      'BASINS': self.root + '/basinsFull.shp',
                                      'NODES': self.root + '/nodesFull.shp'
                                      }, feedback=f1)
                self.allOutputs['channelsFull'] = QgsVectorLayer(out['SEGMENTS'], 'channelsFull', 'ogr')
                self.allOutputs['junctionsFull'] = QgsVectorLayer(out['NODES'], 'junctionsFull', 'ogr')
                fixChannels = QgsVectorLayer(out['SEGMENTS'], 'channelsFull', 'ogr')
                for ft in fixChannels.getFeatures():
                    if ft.geometry().isGeosValid() == False:
                        out_4 = processing.run("native:fixgeometries", {'INPUT': out['SEGMENTS'],
                                                                        'OUTPUT': self.root + '/segmentsFullCorrect.shp'})
                        self.allOutputs['channelsFull'] = QgsVectorLayer(out_4['OUTPUT'], 'channelsFull', "ogr")
                        break
                fixJunctions = QgsVectorLayer(out['NODES'], 'junctionsFull', 'ogr')
                for ft in fixJunctions.getFeatures():
                    if ft.geometry().isGeosValid() == False:
                        out_4 = processing.run("native:fixgeometries", {'INPUT': out['NODES'],
                                                                        'OUTPUT': self.root + '/nodesFullCorrect.shp'})
                        self.allOutputs['junctionsFull'] = QgsVectorLayer(out_4['OUTPUT'], 'junctionsFull', "ogr")
                        break
                self.changed(self.bar0, 100)
                out1 = processing.run('native:clip',{'INPUT': self.allOutputs['channelsFull'],
                'OVERLAY': self.allOutputs['allinone_new'],'OUTPUT': self.root + '/clippedchannels.shp'
                }, feedback=f2)
                self.allOutputs['clippedchannels'] = QgsVectorLayer(out1['OUTPUT'], 'clippedchannels', 'ogr')
                fixChannels2 = QgsVectorLayer(out1['OUTPUT'], 'clippedchannels', 'ogr')
                for ft in fixChannels2.getFeatures():
                    if ft.geometry().isGeosValid() == False:
                        out_4 = processing.run("native:fixgeometries", {'INPUT': fixChannels2,
                                                                        'OUTPUT': self.root + '/clippedchannelsCorrect.shp'})
                        self.allOutputs['clippedchannels'] = QgsVectorLayer(out_4['OUTPUT'], 'clippedchannels', "ogr")
                        break
                out2 = processing.run('native:clip',
                                      {'INPUT': self.allOutputs['junctionsFull'],
                                       'OVERLAY': self.allOutputs['allinone_new'],
                                       'OUTPUT': self.root + '/clippedjunctions.shp'
                                       }, feedback=f2)
                self.allOutputs['clippedjunctions'] = QgsVectorLayer(out2['OUTPUT'], 'clippedjunctions', 'ogr')
                fixJunctions2 = QgsVectorLayer(out2['OUTPUT'], 'clippedjunctions', 'ogr')
                for ft in fixJunctions2.getFeatures():
                    if ft.geometry().isGeosValid() == False:
                        out_4 = processing.run("native:fixgeometries", {'INPUT': fixJunctions2,
                                                                        'OUTPUT': self.root + '/clippedjunctionsCorrect.shp'})
                        self.allOutputs['clippedjunctions'] = QgsVectorLayer(out_4['OUTPUT'], 'clippedjunctions', "ogr")
                        break
                self.changed(self.bar1, 100)
                out3 = processing.run('native:intersection',
                                      {'INPUT': self.allOutputs['clippedchannels'],
                                       'OVERLAY': self.allOutputs['allinone_new'],
                                       'OUTPUT': self.root + '/intersectsegments.shp'
                                       }, feedback=f3)
                out4 = processing.run('native:intersection',
                                      {'INPUT': self.allOutputs['clippedjunctions'],
                                       'OVERLAY': self.allOutputs['allinone_new'],
                                       'OUTPUT': self.root + '/intersectnodes.shp'
                                       }, feedback=f3)
                self.allOutputs['intersectsegments'] = QgsVectorLayer(out3['OUTPUT'], 'intersectsegments', 'ogr')
                self.allOutputs['intersectnodes'] = QgsVectorLayer(out4['OUTPUT'], 'intersectnodes', 'ogr')
                self.changed(self.bar2, 100)
                segments = self.allOutputs['intersectsegments']
                nodes = self.allOutputs['intersectnodes']
                allinone = self.allOutputs['allinone_new']
                segmentsDict = dict()
                springsDict = dict()
                allpathsDict = dict()
                for b in allinone.getFeatures():
                    segmentsDict[b[0]] = list()
                    springsDict[b[0]] = list()
                    allpathsDict[b[0]] = list()
                dc = dict()
                for f in allinone.getFeatures():
                    dc[f[0]] = f.geometry()
                for f in nodes.getFeatures():
                    if f[1] == 'Spring':
                        g = f.geometry()
                        scale = 1.5
                        ux = self.allOutputs['main_dem'].rasterUnitsPerPixelX() * scale
                        uy = self.allOutputs['main_dem'].rasterUnitsPerPixelY() * scale
                        r = QgsRectangle().fromCenterAndSize(g.centroid().asPoint(), ux, uy)
                        if dc[f[2]].contains(QgsGeometry().fromRect(r)) == False:
                            springsDict[f[2]].append([f[0]])
                # correct_lengths
                expression = QgsExpression('$length')
                context = QgsExpressionContext()
                context.appendScopes(QgsExpressionContextUtils.globalProjectLayerScopes(segments))
                #     springsDict[n[2]].append([n[0]])
                for s in segments.getFeatures():
                    context.setFeature(s)
                    l = expression.evaluate(context)
                    segmentsDict[s[7]].append([s[0], s[1], s[2], s.id(), s, l])
                dummy = 0
                for springs in springsDict:
                    subnodes_list = springsDict[springs]
                    dummy = dummy + 1
                    node_index = 0
                    for spring in subnodes_list:
                        node_index = node_index + 1
                        self.progress2.emit(
                        ['{}/{}'.format(dummy, len(springsDict)),100 * node_index / len(subnodes_list)])
                        id = spring[0]
                        bool = True
                        path = list()
                        while bool:
                            bool = False
                            for segment in segmentsDict[springs]:
                                if id == segment[1]:
                                    bool = True
                                    id = segment[2]
                                    path.append([segment[4], segment[5]])
                                    break
                        allpathsDict[springs].append(path)
                maxPaths = dict()
                maxLengths = dict()
                for basin in allpathsDict:
                    maxPath = list()
                    maxLength = 0
                    print(basin)
                    for sg in allpathsDict[basin]:
                        length = 0
                        path = list()
                        for s in sg:
                            path.append(s[0])
                            length = length + s[1]
                        if length > maxLength:
                            maxLength = length
                            maxPath = path
                    maxPaths[basin] = maxPath
                    maxLengths[basin] = maxLength
                # for p in maxPaths:
                #     for f in maxPaths[p]:
                #         segments.select(f.id())
                for f in self.allOutputs['allinone_saved'].getFeatures():
                    attrs = {7: maxLengths[f[0]]}
                    self.allOutputs['allinone_saved'].dataProvider().changeAttributeValues({f.id(): attrs})
                self.finished.emit([1])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])
        progress2 = QtCore.pyqtSignal(list)
        progress = QtCore.pyqtSignal(QProgressBar, int)
        finished = QtCore.pyqtSignal(list)

    class Worker10(QObject):
        def __init__(self, dict, root, dlg, instance,layer, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.root = root
            self.dlg = dlg
            self.instance = instance
            self.layer = layer
        def run(self):
            try:
                layname = self.dlg.comboBox10.currentText()
                values = self.instance.mapLayers().values()
                for v in values:
                    if layname == v.name():
                        self.raster = v
                        break
                if self.raster.type() != 1:
                    msg = QMessageBox()
                    msg.setText('Please select a raster map!')
                    msg.setStandardButtons(QMessageBox.Ok)
                    return_value = msg.exec()
                    return
                layer = self.allOutputs['allinone_saved']
                crs = self.instance.crs().toWkt()
                params = {'TYPE': 2, 'EXTENT': layer.extent(),
                          'HSPACING': 100, 'VSPACING': 100, 'HOVERLAY': 0, 'VOVERLAY': 0,
                          'CRS': crs, 'OUTPUT': self.root + '/grid.shp'}
                out1 = processing.run('native:creategrid', params)
                grid = QgsVectorLayer(out1['OUTPUT'], 'grid', 'ogr')
                params2 = {'INPUT': grid, 'OVERLAY': layer, 'OUTPUT': self.root + '/clip.shp'}
                out2 = processing.run('native:clip', params2)
                clip = QgsVectorLayer(out2['OUTPUT'], 'clip', 'ogr')
                params3 = {'INPUT': clip, 'OVERLAY': layer, 'OUTPUT': self.root + '/intersection.shp'}
                out3 = processing.run('native:intersection', params3)
                intersection = QgsVectorLayer(out3['OUTPUT'], 'intersection', 'ogr')
                dc = dict()
                areacn = dict()
                areas = dict()
                aveCn = dict()
                for f in layer.getFeatures():
                    dc[f[0]] = list()
                    aveCn[f[0]] = list()
                    areacn[f[0]] = list()
                    areas[f[0]] = list()
                for f in intersection.getFeatures():
                    a = f.geometry().area()
                    x = f.geometry().centroid().asPoint().x()
                    y = f.geometry().centroid().asPoint().y()
                    ident = self.raster.dataProvider().identify(QgsPointXY(x, y), QgsRaster.IdentifyFormatValue)
                    if ident.results()[1] == None:
                        dc[f[5]].append(75)
                        areacn[f[5]].append(75 * a)
                        areas[f[5]].append(a)
                    else:
                        dc[f[5]].append(list(ident.results().values())[0])
                        areacn[f[5]].append(list(ident.results().values())[0] * a)
                        areas[f[5]].append(a)
                for f in dc:
                    aveCn[f] = sum(areacn[f]) / sum(areas[f])
                res = self.allOutputs['allinone_saved'].dataProvider().addAttributes(
                    [QgsField("ave_cn", QVariant.Double), QgsField("cont_len", QVariant.Double),
                     QgsField("slope(%)", QVariant.Double), QgsField("lag(hr)", QVariant.Double),
                     QgsField("TOC(min)", QVariant.Double)])
                self.allOutputs['allinone_saved'].updateFields()
                for f in self.allOutputs['allinone_saved'].getFeatures():
                    attrs = {8: aveCn[f[0]]}
                    self.allOutputs['allinone_saved'].dataProvider().changeAttributeValues({f.id(): attrs})
                """Calculation of chow's slope"""
                params4 = {'INPUT': self.layer, 'BAND': 1, 'INTERVAL': 10, 'OUTPUT': self.root + '/contours.shp'}
                out4 = processing.run('gdal:contour', params4)
                contours = QgsVectorLayer(out4['OUTPUT'], 'contours', 'ogr')
                params5 = {'INPUT': contours, 'OVERLAY': self.allOutputs['allinone_saved'],
                           'OUTPUT': self.root + '/intersectionContours.shp'}
                out5 = processing.run('native:intersection', params5)
                intersectionContours = QgsVectorLayer(out5['OUTPUT'], 'intersectionContours', 'ogr')
                # lenth calculation based on Cartesian coord system
                # expression = QgsExpression('LENGTH($geometry)')
                # lenth calculation based on Ellipsoidal coord system
                expression = QgsExpression('$length')
                context = QgsExpressionContext()
                context.appendScopes(QgsExpressionContextUtils.globalProjectLayerScopes(intersectionContours))
                with edit(intersectionContours):
                    for f in intersectionContours.getFeatures():
                        context.setFeature(f)
                        f['cont_len'] = expression.evaluate(context)
                        intersectionContours.updateFeature(f)
                lay = intersectionContours
                layer = self.allOutputs['allinone_saved']
                basins = dict()
                areas = dict()
                slopes = dict()
                for f in layer.getFeatures():
                    basins[f[0]] = list()
                    slopes[f[0]] = 0
                    areas[f[0]] = f['area_sqkm'] * 1000 * 1000
                for f in lay.getFeatures():
                    basins[f[2]].append(f[11])
                # fix : y==0 slope problem. change counters interval or assume a slope value
                for b in basins:
                    y = 100 * sum(basins[b]) * 10 / areas[b]
                    if y == 0 or y<0.002:
                        slopes[b] = 0.0005
                    else:
                        slopes[b] = y
                for f in self.allOutputs['allinone_saved'].getFeatures():
                    attrs = {10: slopes[f[0]]}
                    self.allOutputs['allinone_saved'].dataProvider().changeAttributeValues({f.id(): attrs})
                """Calculation of time of concentration"""
                lay = self.allOutputs['allinone_saved']
                tcs = dict()
                lags = dict()
                for f in lay.getFeatures():
                    tcs[f[0]] = 0
                    lags[f[0]] = 0
                for f in lay.getFeatures():
                    l = f[7]
                    S = 1000 / f[8] - 10
                    Y = f[10]
                    lag = ((l * 3.28084) ** 0.8 * (S + 1) ** 0.7) / (1900 * Y ** 0.5)
                    lags[f[0]] = lag
                    tcs[f[0]] = lag * 60 / 0.6
                for f in self.allOutputs['allinone_saved'].getFeatures():
                    attrs = {11: lags[f[0]]}
                    self.allOutputs['allinone_saved'].dataProvider().changeAttributeValues({f.id(): attrs})
                for f in self.allOutputs['allinone_saved'].getFeatures():
                    attrs = {12: tcs[f[0]]}
                    self.allOutputs['allinone_saved'].dataProvider().changeAttributeValues({f.id(): attrs})
                self.finished.emit([1])
            except:
                e = sys.exc_info()[0]
                if traceback.format_exc().find('aveCn[f] = sum(areacn[f]) / sum(areas[f])') != -1:
                    self.finished.emit([-1, traceback.format_exc()+'---Check your project CRS. Maybe it is different than EPSG:3857'])
                else:
                    self.finished.emit([-1, traceback.format_exc()])
        finished = QtCore.pyqtSignal(list)

    class Worker11(QObject):
        def __init__(self, dict, root, bar, *args, **kwargs):
            QObject.__init__(self, *args, **kwargs)
            self.allOutputs = dict
            self.root = root
            self.bar = bar
        def changed(self, bar, val):
            self.progress.emit(bar, val)
        def run(self):
            f = QgsProcessingFeedback()
            f.progressChanged.connect(lambda: self.changed(self.bar, f1.progress()))
            try:
                basin = "Basin: Basin 1\n     Last Modified Date: {}\n     Last Modified Time: {}\nEnd:\n"
                subbasin = "Subbasin: Subbasin-{}\n     Last Modified Date: {}\n     Last Modified Time: {}\n     Canvas X: {}\n" \
                           "     Canvas Y: {}\n     From Canvas X: {}\n     From Canvas Y: {}\n     Area: {}\n     Downstream: {}\n" \
                           "     Canopy: None\n     Allow Simultaneous Precip Et: No\n     Plant Uptake Method: None\n\n     Surface: None\n\n     LossRate: SCS\n" \
                           "     Percent Impervious Area: {}\n     Curve Number: {}\n     Initial Abstraction: {}\n\n     Transform: SCS\n     Lag: {}\n" \
                           "     Unitgraph Type: STANDARD\n\n     Baseflow: None\nEnd:\n"
                junction = "Junction: Junction-{}\n     Last Modified Date: {}\n     Last Modified Time: {}\n" \
                           "     Canvas X: {}\n     Canvas Y: {}\n     From Canvas X: {}\n     From Canvas Y: {}\n     Downstream: {}\nEnd:\n"
                reach = "Reach: {}\n     Last Modified Date: {}\n     Last Modified Time: {}\n     Canvas X: {}\n     Canvas Y: {}\n" \
                        "     From Canvas X: {}\n     From Canvas Y: {}\n     Downstream: {}\n\n     Route: Muskingum Cunge\n     Channel: Trapezoid\n" \
                        "     Length: {}\n     Energy Slope: {}\n     Mannings n: {}\n     Bottom Width: {}\n     Side Slope: {}\n     Initial Variable: Combined Inflow\n" \
                        "     Space-Time Method: Automatic DX and DT\n     Index Parameter Type: Index Flow\n     Index Flow: {}\n     Maximum Depth Iterations: 20\n     Maximum Route Step Iterations: 30\n     Channel Loss: None\nEnd:\n"
                sink = "Sink: Sink-{}\n     Last Modified Date: {}\n     Last Modified Time: {}\n     Canvas X: {}\n     Canvas Y: {}\n     From Canvas X: {}\n     From Canvas Y: {}\nEnd:"

                catchment = self.allOutputs['allinone_saved']
                sub_junctions = self.allOutputs['sub_junctions']
                sub_channels = self.allOutputs['sub_channels']

                params = {'INPUT': sub_junctions, 'OVERLAY': catchment, 'OUTPUT': self.root + '/juncs.shp'}
                out = processing.run('native:intersection', params, feedback=f)
                juncs = QgsVectorLayer(out['OUTPUT'], 'juncs', 'ogr')

                basindownstreams = dict()
                Subbasins = list()
                Junctions = list()
                Reaches = list()
                Sinks = list()
                Basin = list()
                junctiondownstreams = dict()
                reaches = list()
                junclist = list()

                for f in catchment.getFeatures():
                    basindownstreams[f[0]] = -1
                for f in juncs.getFeatures():
                    if f[1] == "Junction":
                        id = f[0]
                        ls = list()
                        for c in sub_channels.getFeatures():
                            if c[2] == id:
                                ls.append(c[1])
                        for i in ls:
                            for j in juncs.getFeatures():
                                if i == j[0]:
                                    basindownstreams[j[5]] = id
                                    break
                for b in basindownstreams:
                    if basindownstreams[b] == -1:
                        basindownstreams[b] = 'sink-1'
                for f in catchment.getFeatures():
                    text = subbasin
                    dt = datetime.datetime.now()
                    id = f[0][5:]
                    date = dt.strftime("%d") + " " + dt.strftime("%B") + " " + dt.strftime("%Y")
                    time = dt.strftime("%X")
                    cx = f[1]
                    cy = f[2]
                    fx = f[1]
                    fy = f[2]
                    area = f[3]
                    if basindownstreams[f[0]] == 'sink-1':
                        downst = 'Sink-1'
                    else:
                        downst = 'Junction-' + str(basindownstreams[f[0]])
                    imparea = 0
                    cn = f[8]
                    initabst = (1000 / f[8] - 10) * 0.2 * 25.4
                    lag = f[11] * 60
                    text = text.format(id, date, time, cx, cy, fx, fy, area, downst, imparea, cn, initabst, lag)
                    Subbasins.append(text)
                for j in sub_junctions.getFeatures():
                    if j[1] == 'Junction' or j[1] == 'Outlet':
                        junclist.append(j)
                for j in junclist:
                    for c in sub_channels.getFeatures():
                        if j[0] == c[1]:
                            for t in junclist:
                                if t[0] == c[2]:
                                    if t[1] == 'Junction':
                                        reaches.append(
                                            ['Junction-' + str(j[0]), 'Junction-' + str(t[0]), 'Reach-' + str(j[0]), c,
                                             j,
                                             t])
                                        junctiondownstreams[j[0]] = ["Reach-" + str(j[0]), j]
                                    elif t[1] == 'Outlet':
                                        reaches.append(
                                            ['Junction-' + str(j[0]), 'Sink-1', 'Reach-' + str(j[0]), c, j, t])
                                        junctiondownstreams[j[0]] = ["Reach-" + str(j[0]), j]
                for j in junctiondownstreams:
                    text = junction
                    dt = datetime.datetime.now()
                    id = j
                    date = dt.strftime("%d") + " " + dt.strftime("%B") + " " + dt.strftime("%Y")
                    time = dt.strftime("%X")
                    cx = junctiondownstreams[j][1][3]
                    cy = junctiondownstreams[j][1][4]
                    fx = junctiondownstreams[j][1][3]
                    fy = junctiondownstreams[j][1][4]
                    downst = junctiondownstreams[j][0]
                    text = text.format(id, date, time, cx, cy, fx, fy, downst)
                    Junctions.append(text)
                raster = self.allOutputs['filled_dem']
                for r in reaches:
                    x1 = r[4].geometry().centroid().asPoint().x()
                    y1 = r[4].geometry().centroid().asPoint().y()
                    ident1 = raster.dataProvider().identify(QgsPointXY(x1, y1), QgsRaster.IdentifyFormatValue)
                    res1 = list(ident1.results().values())[0]
                    x2 = r[5].geometry().centroid().asPoint().x()
                    y2 = r[5].geometry().centroid().asPoint().y()
                    ident2 = raster.dataProvider().identify(QgsPointXY(x2, y2), QgsRaster.IdentifyFormatValue)
                    res2 = list(ident2.results().values())[0]
                    text = reach
                    dt = datetime.datetime.now()
                    id = r[2]
                    date = dt.strftime("%d") + " " + dt.strftime("%B") + " " + dt.strftime("%Y")
                    time = dt.strftime("%X")
                    cx = 0
                    cy = 0
                    fx = 0
                    fy = 0
                    downst = r[1]
                    leng = r[3][6]
                    slope = (res1 - res2) / leng
                    if slope < 0.0004:
                        slope = 0.0004
                    if slope > 2:
                        print("check me:segmentId" + r[3][0])
                    n = 0.035
                    nos = 2
                    wid = 3
                    sidslope = 0.5
                    indflow = 10
                    text = text.format(id, date, time, cx, cy, fx, fy, downst, leng, slope, n, wid, sidslope,
                                       indflow)
                    Reaches.append(text)
                for f in sub_junctions.getFeatures():
                    if f[1] == "Outlet":
                        out = f
                        break
                        #text = reach
                dt = datetime.datetime.now()
                id = 1
                text = sink
                date = dt.strftime("%d") + " " + dt.strftime("%B") + " " + dt.strftime("%Y")
                time = dt.strftime("%X")
                cx = out[3]
                cy = out[4]
                fx = out[3]
                fy = out[4]
                text = text.format(id, date, time, cx, cy, fx, fy)
                Sinks.append(text)
                dt = datetime.datetime.now()
                text = basin
                date = dt.strftime("%d") + " " + dt.strftime("%B") + " " + dt.strftime("%Y")
                time = dt.strftime("%X")
                text = text.format(date, time)
                Basin.append(text)
                text = ''
                for b in Basin:
                    text = text + b
                for s in Subbasins:
                    text = text + s
                for j in Junctions:
                    text = text + j
                for r in Reaches:
                    text = text + r
                for sk in Sinks:
                    text = text + sk
                path = self.root + '/HecHms'
                os.mkdir(path)
                f = open(self.root + "/HecHms/Basin_1.basin", "x")
                f.write(text)
                f.close()
                project = "Project: myproject\n     Description: \n     Version: 4.5\n     Filepath Separator: \\" + "\n     DSS File Name: myproject.dss\n     Time Zone ID: Europe/Berlin\nEnd:\n\n" \
                                                                                                                     "Basin: Basin 1\n     Filename: Basin_1.basin\n     Description: \n     Last Modified Date: {}\n     Last Modified Time: {}\nEnd:"
                project = project.format(date, time)
                f2 = open(self.root + "/HecHms/myproject.hms", "x")
                f2.write(project)
                f2.close()
                self.finished.emit([1])
            except:
                e = sys.exc_info()[0]
                self.finished.emit([-1, traceback.format_exc()])
        progress = QtCore.pyqtSignal(QProgressBar, int)
        finished = QtCore.pyqtSignal(list)