# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Q_LIP
                                 A QGIS plugin
 QGIS-Landsat Indices plugin (Q-LIP)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-03-26
        git sha              : $Format:%H$
        copyright            : (C) 2021 by YAZIDI ALAOUI Otmane & SEBBAH Boutaina /FSTT
        email                : yazidiotmane@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Q_LIP_dialog import Q_LIPDialog
import os.path

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon,QPixmap,QImage
from qgis.PyQt.QtWidgets import QAction,QFileDialog,QDialog,QListView
from PyQt5 import QtWidgets
import urllib
from os import listdir
from os.path import isfile, join
from qgis.core import QgsRasterLayer,QgsProject
from math import sin,radians,pi,cos,pow,log,sqrt
from qgis.core import QgsMessageLog
import gdal
import landsatxplore.api
from landsatxplore.earthexplorer import EarthExplorer
import processing
import datetime
from qgis.core import QgsRasterBandStats
from qgis.gui import QgsMessageBar
V_executedBefore=False



class Q_LIP:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Q_LIP_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Q-LIP')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Q_LIP', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Q_LIP/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Q-LIP'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Q-LIP'),
                action)
            self.iface.removeToolBarIcon(action)
    def CloudCouverageDisplay(self):
        var=self.dlg.cloudslider.value()
        self.dlg.label_value.setText(str(var)+'%')

    def display_image(self,url):
        
        #url = 'https://ims.cr.usgs.gov/browse/landsat_8_c1/2020/195/034/LC08_L1TP_195034_20200116_20200127_01_T1.jpg'
        data = urllib.request.urlopen(url).read()

        image = QImage()
        image.loadFromData(data)
        image.scaled(100, 100)
        
        #self.dlg.label_image.setPixmap(QPixmap(image))
        
        pixmap = QPixmap(image)
        pixmap4 = pixmap.scaled(200, 200, QtCore.Qt.KeepAspectRatio)
        self.dlg.label_image.setPixmap(pixmap4)

    def DownloadingLandsat(self):
        '''
        # Initialize a new API instance and get an access key
        api = landsatxplore.api.API('Boutaina', 'boutaina123456789')
        type_image=self.dlg.combo_sat.currentText()
        stratDate=self.dlg.dateEditStart.date().toString('yyyy-MM-dd')
        endDate=self.dlg.dateEditEnd.date().toString('yyyy-MM-dd')
        cloudpoucentage=self.dlg.cloudslider.value()
        varLat=36.04305
        varLong=-5.08955

        
        # Request
        scenes = api.search(
            dataset=type_image,
            latitude=varLat,
            longitude=-varLong,
            start_date=stratDate,
            end_date=endDate,
            max_cloud_cover=cloudpoucentage)
        '''
        # Initialize a new API instance and get an access key
        v_login=self.dlg.lineEdit_login.text()
        v_pass= self.dlg.lineEdit_pass.text()
        
        try: 
            #api = landsatxplore.api.API('Boutaina', 'boutaina123456789')
            api = landsatxplore.api.API(v_login, v_pass)
            # Request
            var_latitude=36.04941
            var_longitude=-5.18683
            var_datedebut=self.dlg.dateEditStart.date().toString('yyyy-MM-dd')
            var_datefin=self.dlg.dateEditEnd.date().toString('yyyy-MM-dd')
            var_cloud=self.dlg.cloudslider.value()
            var_typeSat=self.dlg.combo_sat.currentText()
            print(var_cloud)
            scenes = api.search(
                dataset=var_typeSat,
                latitude=var_latitude,
                longitude=var_longitude,
                start_date=var_datedebut,
                end_date=var_datefin,
                max_cloud_cover=int(var_cloud))
            print('{} Results found/النتائج المتوفرة:'.format(len(scenes)))
            self.dlg.lbl_number_found.setText('{} Results found/النتائج المتوفرة:'.format(len(scenes)))
            for scene in scenes:
                print(scene['acquisitionDate'])
                print('&&&&&&&'+str(scene['cloudCover'])+'&&&&&&&&&')
            i=0
            self.dlg.tableResult.clear()
            for scene in scenes:
                    item = QtWidgets.QTableWidgetItem(scene['acquisitionDate'])
                    self.dlg.tableResult.setItem(i, 1, item)
                    item1 = QtWidgets.QTableWidgetItem(scene['displayId'])
                    self.dlg.tableResult.setItem(i, 0, item1)
                    item2 = QtWidgets.QTableWidgetItem(scene['browseUrl'])
                    self.dlg.tableResult.setItem(i, 2, item2)
                    item3 = QtWidgets.QTableWidgetItem(str(scene['cloudCover']))
                    self.dlg.tableResult.setItem(i, 3, item3)
                    i=i+1
            api.logout()
        except:
            self.iface.messageBar().pushMessage("Error", "Your Login Or/and Pass are wrong",1)
            self.dlg.lineEdit_login.setStyleSheet("background-color: rgb(255, 255, 224);")
            self.dlg.lineEdit_pass.setStyleSheet("background-color: rgb(255, 255, 224);")

        
    def getWholeInformations(self):
        print(self.dlg.combo_sat.currentText())
        print(self.dlg.dateEditStart.date().toString('yyyy-MM-dd'))
        print(self.dlg.dateEditEnd.date().toString('yyyy-MM-dd'))
        print(self.dlg.cloudslider.value())
        print('$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$')
        self.DownloadingLandsat()
        print('$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$')
    
        
    def downloading(self):
        print('youpiiiii')
        print(self.dlg.tableResult.item(self.dlg.tableResult.currentRow(),0).text())
        var_id_product=self.dlg.tableResult.item(self.dlg.tableResult.currentRow(),0).text()
        ee = EarthExplorer('Boutaina', 'boutaina123456789')
        ee.download(scene_id=var_id_product, output_dir='/Users/profotmane/Sat/')
        ee.logout()
        
    def openDirectory(self):
        '''
        dialog = QFileDialog()
        dialog.getOpenFileName()
        foo_dir = dialog.getExistingDirectory(self, '/SatDownloaded')
        print(foo_dir)
        '''
        mypath=QFileDialog.getExistingDirectory()
        self.dlg.lineEdit_url.setText(mypath)
        #dialog.setSidebarUrls([QtCore.QUrl.fromLocalFile('/SatDownloaded')])

        onlyfiles = [f for f in listdir(mypath) if isfile(join(mypath, f))]     
        self.dlg.listWidget_files.clear()    
        onlytif=[]
        self.dlg.tableWidget_MetaData.clear()
        for i in range(0,len(onlyfiles)):
            if  onlyfiles[i][0:4]=='LE07':
                 if onlyfiles[i][-1:-5:-1]=='FIT.':
                     onlytif.append(onlyfiles[i])
                 elif onlyfiles[i][-1:-8:-1]=='txt.LTM':
                     print(mypath+'/'+onlyfiles[i])
                     self.LoadMetaData7(mypath+'/'+onlyfiles[i])
            elif onlyfiles[i][0:4]=='LC08':
                 if onlyfiles[i][-1:-5:-1]=='FIT.':
                        onlytif.append(onlyfiles[i])
                 elif onlyfiles[i][-1:-8:-1]=='txt.LTM':
                        print(mypath+'/'+onlyfiles[i])
                        self.LoadMetaData8(mypath+'/'+onlyfiles[i])
            elif onlyfiles[i][0:4]=='LT05':
                 if onlyfiles[i][-1:-5:-1]=='FIT.':
                        onlytif.append(onlyfiles[i])
                 elif onlyfiles[i][-1:-8:-1]=='txt.LTM':
                        print(mypath+'/'+onlyfiles[i])
                        self.LoadMetaData5(mypath+'/'+onlyfiles[i])
        self.dlg.listWidget_files.addItems(onlytif)
    def Display(self):
        picToDownload=self.dlg.tableResult.item(self.dlg.tableResult.currentRow(),2).text()
        print(picToDownload)
        self.display_image(picToDownload)
    def DisplayRaster(self):
        print(self.dlg.listWidget_files.currentItem().text())
        layer1 = QgsRasterLayer('/SatDownloaded/image1/'+self.dlg.listWidget_files.currentItem().text(), 'layer1')
        #QgsProject.instance().addMapLayer(layer1)
        
    def runProcessing33_55(self):
        liste=[1,2,3,4,5,7]
        URl_liste={'Band0':'Non'}

        for i in liste:
            inputRad=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(i-1,0).text()

            outputRad=inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_RAD_'+str(i)+'.TIF'
            self.calculradiance5(int(i-1),inputRad,outputRad)
        
            outputRef=inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_REF_'+str(i)+'.TIF'
            self.CalculTOA5(int(i-1),outputRad,outputRef)
            URl_liste['Band'+str(i)]=outputRef


        #Calcul Radiance of Band 6
        inputRadBand6=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(5,0).text()
        outputRadBand6=inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_RAD_'+str(6)+'.TIF'
        self.calculradiance5(6,inputRadBand6,outputRadBand6)
        URl_liste['RadianceBand6']=outputRadBand6

        #Calcul Brighteness Index of Band 6
        outputBrighteness= inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BRIGHTENESS_'+str(6)+'.TIF'
        URl_liste['BriBand6']=outputBrighteness
        self.CalculBrightness5(URl_liste['RadianceBand6'],outputBrighteness)
        print('-------------------')
        print(URl_liste)
        print('-------------------')
        
        
        outputNDVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDVI_'+str(i)+'.TIF'
        self.NDVI_5(URl_liste['Band4'],URl_liste['Band3'],outputNDVI)
        URl_liste['NDVI']=outputNDVI
        outputMSAVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_MSAVI_'+str(i)+'.TIF'
        self.MSAVI_5(URl_liste['Band4'],URl_liste['Band3'],outputMSAVI)
        outputNDWI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDWI_'+str(i)+'.TIF'
        self.NDWI_5(URl_liste['Band2'],URl_liste['Band4'],outputNDWI)
        outputMNDWI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_MNDWI_'+str(i)+'.TIF'
        self.MNDWI_5(URl_liste['Band2'],URl_liste['Band5'],outputMNDWI)
        outputNBR=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NBR_'+str(i)+'.TIF'
        self.NBR_5(URl_liste['Band4'],URl_liste['Band7'],outputNBR)
        outputBI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BI_'+str(i)+'.TIF'
        self.BI_5(URl_liste['Band3'],URl_liste['Band4'],outputBI)

        outputPV=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_PV_'+'.TIF'
        self.Proportion_Vegetation578(URl_liste['NDVI'],outputPV)
        URl_liste['PV']=outputPV

        
        outputEmmiss=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_EMMISS_'+'.TIF'
        self.Emmissivity57(URl_liste['Band3'],URl_liste['PV'],URl_liste['NDVI'],outputEmmiss)
        URl_liste['EMMISS']=outputEmmiss


        outputLST=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_LST_'+'.TIF'
        self.LST_5(URl_liste['BriBand6'],URl_liste['EMMISS'],outputLST)
        URl_liste['LST']=outputLST
        
        outputUTFVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_UTFVI_'+'.TIF'
        self.UTFVI_578(URl_liste['LST'],outputUTFVI)
        URl_liste['UTFVI']=outputUTFVI
        
        outputHS=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_HS_'+'.TIF'
        self.HS_578(URl_liste['LST'],outputHS)
        '''
        cheminprovisoir='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_LST_.TIF'
        outputHS='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_HSSSS_.TIF'
        outputUTFV='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_UTFVVVV_.TIF'
        self.UTFVI_578(cheminprovisoir,outputUTFVI)
        #self.HS_578(cheminprovisoir,outputHS)
        '''

    def runProcessing33_77(self):
        
        liste=[1,2,3,4,5,8,9]
        URl_liste={'Band0':'Non'}
     
        for i in liste:
            inputRad=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(i-1,0).text()

            outputRad=inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_RAD_'+str(i)+'.TIF'
            self.calculradiance7(int(i-1),inputRad,outputRad)
        
            outputRef=inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_REF_'+str(i)+'.TIF'
            self.calculTOA7(int(i-1),outputRad,outputRef)
            URl_liste['Band'+str(i)]=outputRef
    
        
        #Calcul Radiance of Band 6_2
        inputRadBand6=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(6,0).text()
        outputRadBand6=inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_RAD_'+str(6)+'.TIF'
        self.calculradiance7(6,inputRadBand6,outputRadBand6)
        URl_liste['RadianceBand6_2']=outputRadBand6
        
        #Calcul Brighteness Index of Band 6_2
        outputBrighteness= inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BRIGHTENESS_'+str(6)+'.TIF'
        URl_liste['BriBand6_2']=outputBrighteness
        self.CalculBrightness7(URl_liste['RadianceBand6_2'],outputBrighteness)

        
        
        outputNDVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDVI_'+str(i)+'.TIF'
        self.NDVI_5(URl_liste['Band4'],URl_liste['Band3'],outputNDVI)
        URl_liste['NDVI']=outputNDVI
        outputMSAVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_MSAVI_'+str(i)+'.TIF'
        self.MSAVI_5(URl_liste['Band4'],URl_liste['Band3'],outputMSAVI)
        outputNDWI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDWI_'+str(i)+'.TIF'
        self.NDWI_5(URl_liste['Band2'],URl_liste['Band4'],outputNDWI)
        outputMNDWI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_MNDWI_'+str(i)+'.TIF'
        self.MNDWI_5(URl_liste['Band2'],URl_liste['Band5'],outputMNDWI)
        outputNBR=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NBR_'+str(i)+'.TIF'
        #we have to do band8 instead of band7 ( because the band7 is in the 8 range (Band6_1,Band6_2)
        self.NBR_5(URl_liste['Band4'],URl_liste['Band8'],outputNBR)
        outputBI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BI_'+str(i)+'.TIF'
        self.BI_5(URl_liste['Band3'],URl_liste['Band4'],outputBI)

        outputPV=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_PV_'+'.TIF'
        self.Proportion_Vegetation578(URl_liste['NDVI'],outputPV)
        URl_liste['PV']=outputPV

        
        outputEmmiss=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_EMMISS_'+'.TIF'
        self.Emmissivity57(URl_liste['Band3'],URl_liste['PV'],URl_liste['NDVI'],outputEmmiss)
        URl_liste['EMMISS']=outputEmmiss


        outputLST=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_LST_'+'.TIF'
        self.LST_7(URl_liste['BriBand6_2'],URl_liste['EMMISS'],outputLST)
        URl_liste['LST']=outputLST
        
        outputUTFVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_UTFVI_'+'.TIF'
        self.UTFVI_578(URl_liste['LST'],outputUTFVI)
        URl_liste['UTFVI']=outputUTFVI
        
        outputHS=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_HS_'+'.TIF'
        self.HS_578(URl_liste['LST'],outputHS)
        #cheminprovisoir='/Users/profotmane/Sat/landsat5/LT05_L1TP_201035_20100130_20161017_01_T1_B72020_06_17_14_47_LST_.TIF'
        #outputHS='/Users/profotmane/Sat/landsat5/LT05_L1TP_201035_20100130_20161017_01_T1_B72020_06_17_14_47_HS1_.TIF'
        #self.HS_578(cheminprovisoir,outputHS)
        '''
        cheminprovisoir='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_LST_.TIF'
        outputHS='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_HSSSS_.TIF'
        outputUTFV='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_UTFVVVV1_.TIF'
        self.UTFVI_578(cheminprovisoir,outputUTFV)
        #self.HS_578(cheminprovisoir,outputHS)
        '''
    def runProcessing33_88(self):
        global V_executedBefore
        liste=[1,2,3,4,5,6,7,8,9]
        URl_liste={'Band0':'Non'}
        inputRad=''
        if V_executedBefore==False : 
            for i in liste:
                inputRad=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(i-1,0).text()
                outputRad = inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_RAD_'+str(i)+'.TIF'
                self.calculradiance8(int(i-1),inputRad,outputRad)
                outputRef=inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_REF_'+str(i)+'.TIF'
                self.calculTOA8(int(i-1),inputRad,outputRef)
                URl_liste['Band'+str(i)]=outputRef
        
            #Calcul Radiance of Band 10
            inputRadBand6=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(9,0).text()
            outputRadBand6=inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_RAD_'+str(10)+'.TIF'
            self.calculradiance8(9,inputRadBand6,outputRadBand6)
            URl_liste['RadianceBand10']=outputRadBand6

            #Calcul Brighteness Index of Band 10
            outputBrighteness= inputRad[:len(inputRad)-4]+'_'+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BRIGHTENESS_'+str(10)+'.TIF'
            URl_liste['BriBand10']=outputBrighteness
            self.CalculBrightness8(URl_liste['RadianceBand10'],outputBrighteness)
            #-----------------------------------------
            if (self.dlg.check_NDVI.isChecked())==True: 
                outputNDVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDVI_'+str(i)+'.TIF'
                self.NDVI_8(URl_liste['Band5'],URl_liste['Band4'],outputNDVI)
                URl_liste['NDVI']=outputNDVI
            if (self.dlg.check_MSAVI.isChecked())==True:
                outputMSAVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_MSAVI_'+str(i)+'.TIF'
                self.MSAVI_8(URl_liste['Band5'],URl_liste['Band4'],outputMSAVI)
            if (self.dlg.check_NDWI.isChecked())==True:
                outputNDWI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDWI_'+str(i)+'.TIF'
                self.NDWI_8(URl_liste['Band3'],URl_liste['Band5'],outputNDWI)
            if (self.dlg.check_MNDWI.isChecked())==True:
                outputMNDWI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_MNDWI_'+str(i)+'.TIF'
                self.MNDWI_8(URl_liste['Band3'],URl_liste['Band6'],outputMNDWI)
            if (self.dlg.check_NBR.isChecked())==True:
                outputNBR=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NBR_'+str(i)+'.TIF'
                self.NBR_8(URl_liste['Band5'],URl_liste['Band7'],outputNBR)
            if (self.dlg.check_BI.isChecked())==True:
                outputBI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BI_'+str(i)+'.TIF'
                self.BI_8(URl_liste['Band3'],URl_liste['Band4'],outputBI)
            if (self.dlg.check_PV.isChecked())==True:
                outputPV=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_PV_'+'.TIF'
                self.Proportion_Vegetation578(URl_liste['NDVI'],outputPV)
                URl_liste['PV']=outputPV
            if (self.dlg.check_EM.isChecked())==True:
                outputEmmiss=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_EMMISS_'+'.TIF'
                self.Emmissivity8(URl_liste['Band4'],URl_liste['PV'],URl_liste['NDVI'],outputEmmiss)
                URl_liste['EMMISS']=outputEmmiss

            if (self.dlg.check_LST.isChecked())==True:
                outputLST=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_LST_'+'.TIF'
                self.LST_8(URl_liste['BriBand10'],URl_liste['EMMISS'],outputLST)
                URl_liste['LST']=outputLST
                
            if (self.dlg.check_UTFVI.isChecked())==True:
                outputUTFVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_UTFVI_'+'.TIF'
                self.UTFVI_578(URl_liste['LST'],outputUTFVI)
                URl_liste['UTFVI']=outputUTFVI
                
            if (self.dlg.check_HS.isChecked())==True:
                outputHS=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_HS_'+'.TIF'
                self.HS_578(URl_liste['LST'],outputHS)
                URl_liste['HS']=outputHS
                
            if (self.dlg.check_EVI.isChecked())==True:
                 outputEVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_EVI_'+'.TIF'
                 self.EVI_8(URl_liste['Band5'],URl_liste['Band4'],URl_liste['Band2'],outputEVI)
                 URl_liste['EVI']=outputEVI
                 
            if (self.dlg.check_SAVI.isChecked())==True:
                 outputSAVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_SAVI_'+'.TIF'
                 self.SAVI_8(URl_liste['Band5'],URl_liste['Band4'],outputSAVI)
                 URl_liste['SAVI']=outputSAVI
            if (self.dlg.check_NDMI.isChecked())==True:
                 outputNDMI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDMI_'+'.TIF'
                 self.NDMI_8(URl_liste['Band5'],URl_liste['Band6'],outputNDMI)
                 URl_liste['NDMI']=outputNDMI
                 
            if (self.dlg.check_AWEInsh.isChecked())==True:
                 outputAWEInsh=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_AWEInsh_'+'.TIF'
                 self.AWEInsh_8(URl_liste['Band3'],URl_liste['Band6'],URl_liste['Band5'],URl_liste['Band7'],outputAWEInsh)
                 URl_liste['AWEInsh']=outputAWEInsh

            if (self.dlg.check_AWEIsh.isChecked())==True:
                 outputAWEIsh=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_AWEIsh_'+'.TIF'
                 self.AWEIsh_8(URl_liste['Band2'],URl_liste['Band3'],URl_liste['Band5'],URl_liste['Band6'],URl_liste['Band7'],outputAWEIsh)
                 URl_liste['AWEIsh']=outputAWEIsh

            if (self.dlg.check_NDBI.isChecked())==True:
                 outputNDBI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDBI_'+'.TIF'
                 self.NDBI_8(URl_liste['Band6'],URl_liste['Band5'],outputNDBI)
                 URl_liste['NDBI']=outputNDBI

            if (self.dlg.check_BU.isChecked())==True:
                 outputBU=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BU_'+'.TIF'
                 self.BU_8_7_5(URl_liste['NDBI'],URl_liste['NDVI'],outputBU)
                 URl_liste['BU']=outputBU

            V_executedBefore=False
            #-----------------------------------------
            '''
            else:
            if (self.dlg.check_NDVI.isChecked())==True: 
                outputNDVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDVI_'+str(i)+'.TIF'
                self.NDVI_8(URl_liste['Band5'],URl_liste['Band4'],outputNDVI)
                URl_liste['NDVI']=outputNDVI
            if (self.dlg.check_MSAVI.isChecked())==True:
                outputMSAVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_MSAVI_'+str(i)+'.TIF'
                self.MSAVI_8(URl_liste['Band5'],URl_liste['Band4'],outputMSAVI)
            if (self.dlg.check_NDWI.isChecked())==True:
                outputNDWI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDWI_'+str(i)+'.TIF'
                self.NDWI_8(URl_liste['Band3'],URl_liste['Band5'],outputNDWI)
            if (self.dlg.check_MNDWI.isChecked())==True:
                outputMNDWI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_MNDWI_'+str(i)+'.TIF'
                self.MNDWI_8(URl_liste['Band3'],URl_liste['Band6'],outputMNDWI)
            if (self.dlg.check_NBR.isChecked())==True:
                outputNBR=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NBR_'+str(i)+'.TIF'
                self.NBR_8(URl_liste['Band5'],URl_liste['Band7'],outputNBR)
            if (self.dlg.check_BI.isChecked())==True:
                outputBI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BI_'+str(i)+'.TIF'
                self.BI_8(URl_liste['Band3'],URl_liste['Band4'],outputBI)
            if (self.dlg.check_PV.isChecked())==True:
                outputPV=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_PV_'+'.TIF'
                self.Proportion_Vegetation578(URl_liste['NDVI'],outputPV)
                URl_liste['PV']=outputPV
            if (self.dlg.check_EM.isChecked())==True:
                outputEmmiss=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_EMMISS_'+'.TIF'
                self.Emmissivity8(URl_liste['Band4'],URl_liste['PV'],URl_liste['NDVI'],outputEmmiss)
                URl_liste['EMMISS']=outputEmmiss

            if (self.dlg.check_LST.isChecked())==True:
                outputLST=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_LST_'+'.TIF'
                self.LST_8(URl_liste['BriBand10'],URl_liste['EMMISS'],outputLST)
                URl_liste['LST']=outputLST
            if (self.dlg.check_UTFVI.isChecked())==True:
                outputUTFVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_UTFVI_'+'.TIF'
                self.UTFVI_578(URl_liste['LST'],outputUTFVI)
                URl_liste['UTFVI']=outputUTFVI
                
            if (self.dlg.check_HS.isChecked())==True:
                outputHS=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_HS_'+'.TIF'
                self.HS_578(URl_liste['LST'],outputHS)
                URl_liste['HS']=outputHS
                
            if (self.dlg.check_EVI.isChecked())==True:
                 outputEVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_EVI_'+'.TIF'
                 self.EVI_8(URl_liste['Band5'],URl_liste['Band4'],URl_liste['Band2'],outputEVI)
                 URl_liste['EVI']=outputEVI
                 
            if (self.dlg.check_SAVI.isChecked())==True:
                 outputSAVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_SAVI_'+'.TIF'
                 self.SAVI_8(URl_liste['Band5'],URl_liste['Band4'],outputSAVI)
                 URl_liste['SAVI']=outputSAVI
            if (self.dlg.check_NDMI.isChecked())==True:
                 outputNDMI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDMI_'+'.TIF'
                 self.NDMI_8(URl_liste['Band5'],URl_liste['Band6'],outputNDMI)
                 URl_liste['NDMI']=outputNDMI
            if (self.dlg.check_AWEInsh.isChecked())==True:
                 outputAWEInsh=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_AWEInsh_'+'.TIF'
                 self.AWEInsh_8(URl_liste['Band3'],URl_liste['Band6'],URl_liste['Band5'],URl_liste['Band7'],outputAWEInsh)
                 URl_liste['AWEInsh']=outputAWEInsh

            if (self.dlg.check_AWEIsh.isChecked())==True:
                 outputAWEIsh=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_AWEIsh_'+'.TIF'
                 self.AWEIsh_8(URl_liste['Band2'],URl_liste['Band3'],URl_liste['Band5'],URl_liste['Band6'],URl_liste['Band7'],outputAWEIsh)
                 URl_liste['AWEIsh']=outputAWEIsh

            if (self.dlg.check_NDBI.isChecked())==True:
                 outputNDBI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDBI_'+'.TIF'
                 self.NDBI_8(URl_liste['Band6'],URl_liste['Band5'],outputNDBI)
                 URl_liste['NDBI']=outputNDBI

            if (self.dlg.check_BU.isChecked())==True:
                 outputBU=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BU_'+'.TIF'
                 self.BU_8_7_5(URl_liste['NDBI'],URl_liste['NDVI'],outputBU)
                 URl_liste['BU']=outputBU
            V_executedBefore=True
            '''
            '''
            cheminprovisoir='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_LST_.TIF'
            outputHS='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_HSSSS_.TIF'
            outputUTFV='/Users/profotmane/Sat/landsat7/LE07_L1TP_201035_20030425_20170125_01_T1_B82020_06_18_18_06_UTFVVVV_.TIF'
            self.UTFVI_578(cheminprovisoir,outputUTFVI)
            #self.HS_578(cheminprovisoir,outputHS)
            '''
        
        
    def LST_8(self,BrightBand10,Emiss,OutputLST):
        input_rasterA = QgsRasterLayer(BrightBand10, 'Band10')
        #QgsProject.instance().addMapLayer(input_rasterA)
        
        input_rasterB = QgsRasterLayer(Emiss, 'Emissivity')
        #QgsProject.instance().addMapLayer(input_rasterB)
        
        output_raster = OutputLST
        parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
        'BAND_A' : 1,
        'BAND_B' : 1,        
        'FORMULA': "(A/(1+(10.895*A/14380)*log(B)))",
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)
        print('FINNNNNN')

    def LST_7(self,BrightnessBand6_2,Emiss,OutputLST):
        input_rasterA = QgsRasterLayer(BrightnessBand6_2, 'Band6_2')
        #QgsProject.instance().addMapLayer(input_rasterA)
        
        input_rasterB = QgsRasterLayer(Emiss, 'Emissivity')
        #QgsProject.instance().addMapLayer(input_rasterB)
        
        output_raster = OutputLST
        parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
        'BAND_A' : 1,
        'BAND_B' : 1,        
        'FORMULA': "(A/(1+(11.45*A/14380)*log(B)))",
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)
        print('FINNNNNN')
        
    def LST_5(self,BrightBand6,Emiss,OutputLST):
        input_rasterA = QgsRasterLayer(BrightBand6, 'BRITGHNESS_Band6')
        #QgsProject.instance().addMapLayer(input_rasterA)
        
        input_rasterB = QgsRasterLayer(Emiss, 'Emissivity')
        #QgsProject.instance().addMapLayer(input_rasterB)
        
        output_raster = OutputLST
        parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
        'BAND_A' : 1,
        'BAND_B' : 1,        
        'FORMULA': "(A/(1+(11.45*A/14380)*log(B)))",
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)
        print('FINNNNNN')
        
    def getLSTMean(self,LSTInput):
        V_LayLST = QgsRasterLayer(LSTInput,'LSTLayer')
        provider = V_LayLST.dataProvider()
        stats = provider.bandStatistics(1, QgsRasterBandStats.All)
        return stats.mean
    
    def getSTDV(self,LSTInput):
        V_LayLST = QgsRasterLayer(LSTInput,'LSTLayer')
        provider = V_LayLST.dataProvider()
        stats = provider.bandStatistics(1, QgsRasterBandStats.All)
        return stats.stdDev
        
    def UTFVI_578(self,LSTInput,UTFVoutput):
        V_mean=self.getLSTMean(LSTInput)
        print(V_mean)
        input_raster = QgsRasterLayer(LSTInput, 'LST')
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = UTFVoutput
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "(A-{0})/{0}".format(V_mean),
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)
        
    def HS_578(self,LSTInput,HSoutput):
         V_mean=self.getLSTMean(LSTInput)
         V_std = self.getSTDV(LSTInput)
         #var='(1*(A>(283.37937957991+2*4.75321))+0*(A <(283.37937957991+2*4.75321)))'
         #print(var)
         #print ("(1*(A>({0}+2*{1}))+0*(A<({0}+2*{1})))".format(V_mean,V_std))
         
         input_rasterA = QgsRasterLayer(LSTInput, 'LST')
         output_raster = HSoutput
         parameters = {'INPUT_A': input_rasterA,
         'BAND_A' : 1,
         'FORMULA':"(1*(A>({0}+2*{1}))+0*(A<({0}+2*{1})))".format(V_mean,V_std),
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         
        
    def RunProcessing33_88_bis(self):
        '''

            #self.calculradiance7()
            #self.calculradiance8()
            #self.calculTOA7()
            #self.CalculBrightness8()
            #self.CalculBrightness7()
            #self.moyenne()
        
        liste=range(1,10,1)
        URl_liste=['Non']
        '''
        '''
        for i in liste:
            inputRad=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(i-1,0).text()
            outputRad=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_RAD_'+str(i)+'.TIF'
            self.calculradiance8(int(i-1),inputRad,outputRad)
            outputRef=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_REF_'+str(i)+'.TIF'
            self.calculTOA8(int(i-1),outputRad,outputRef)
            URl_liste.append(outputRef)
        '''
        '''
        #print(URl_liste[3],URl_liste[4])
        OutputNDVI=inputRad[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_NDVI.TIF'
        self.NDVI_5(URl_liste[4],URl_liste[3],OutputNDVI)
        '''
        '''
        band5="/SatDownloaded/Sat7_1/Landsat8/LC08_L1TP_201035_20190107_20190130_01_T1_B52020_03_26_18_36_REF_5.TIF"
        band4="/SatDownloaded/Sat7_1/Landsat8/LC08_L1TP_201035_20190107_20190130_01_T1_B42020_03_26_18_35_REF_4.TIF"
        band3="/SatDownloaded/Sat7_1/Landsat8/LC08_L1TP_201035_20190107_20190130_01_T1_B32020_03_26_18_35_REF_3.TIF"
        band6="/SatDownloaded/Sat7_1/Landsat8/LC08_L1TP_201035_20190107_20190130_01_T1_B62020_03_26_18_36_REF_6.TIF"
        band7="/SatDownloaded/Sat7_1/Landsat8/LC08_L1TP_201035_20190107_20190130_01_T1_B72020_03_26_18_36_REF_7.TIF"
        output="/SatDownloaded/Sat7_1/Landsat8/LT05_L1TP_201035_20100130_20161017_01_T1_B42020_03_24_14_33_LST.TIF"
        NDVI ="/SatDownloaded/Sat7_1/Landsat8/LT05_L1TP_201035_20100130_20161017_01_T1_B42020_03_24_14_33_NDVI8.TIF"
        PV="/SatDownloaded/Sat7_1/Landsat8/LT05_L1TP_201035_20100130_20161017_01_T1_B42020_03_24_14_33_PV.TIF"
        Bri="/SatDownloaded/Sat7_1/Landsat8/LC08_L1TP_201035_20190107_20190130_01_T1_B102020_04_05_12_48_BRI_8.TIF"
        EMI="/SatDownloaded/Sat7_1/Landsat8/LT05_L1TP_201035_20100130_20161017_01_T1_B42020_03_24_14_33_EMISIVITY.TIF"
        self.LST_8(Bri,EMI,output)
        #---------------------------Brightness temperature for Landsat 5 -----------------------------------------------
        '''
        var=self.dlg.check_NDVI.checkState()
        print(self.dlg.check_NDVI.isChecked())
        
    def CalculBrightness5(self,InputRadiance,OutputBright):
       
        V_K1=float(str(self.dlg.tableWidget_MetaData.item(5,5).text()))
        V_K2=float(str(self.dlg.tableWidget_MetaData.item(5,6).text()))
        #print("V_1,V_2",V_K1,V_K2)
        #var=((1260.56)/(log((607.76/8.492)+1)))
        #print(var)
    
        #var=({0}*A*pow({1},2))/({2}+cos(radians(90-{3}))).format(V_Pi,V_sunDistance,V_Esun,V_sunElevation)
        #var=(V_Pi*193*pow(V_sunDistance,2))/(V_Esun*sin(radians(V_sunElevation)))
        #print(var)
        
        #band6=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(5,0).text()
        input_raster = QgsRasterLayer(InputRadiance, 'RadianceBand6')
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = OutputBright
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "((({0})/(log(({1}/A)+1))))".format(V_K2,V_K1),
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)

        #--------------------------Brightness temperature for Landsat7

    def CalculBrightness7(self,InputRadiance,OutputBright):
        bandnum6_2=6
        V_K1=float(str(self.dlg.tableWidget_MetaData.item(bandnum6_2,5).text()))
        V_K2=float(str(self.dlg.tableWidget_MetaData.item(bandnum6_2,6).text()))
        print("V_1,V_2",V_K1,V_K2)
        var=((1260.56)/(log((607.76/8.492)+1)))
        print(var)
    
        #var=({0}*A*pow({1},2))/({2}+cos(radians(90-{3}))).format(V_Pi,V_sunDistance,V_Esun,V_sunElevation)
        #var=(V_Pi*193*pow(V_sunDistance,2))/(V_Esun*sin(radians(V_sunElevation)))
        #print(var)
        
        #band6=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(5,0).text()
        #outputband6=band6[:len(inputRad)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BRI_'+str(i)+'.TIF'
        
        input_raster = QgsRasterLayer(InputRadiance, 'RadianceBand6')
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = OutputBright
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "((({0})/(log(({1}/A)+1)))-273.15)".format(V_K2,V_K1),
        'OUTPUT' : output_raster}
        processing.run('gdal:rastercalculator', parameters)
        
        #---------------------Calcul of brightness temperature for Landsat 8-------------------------
    def CalculBrightness8(self,InputRadiance,OutputBright):
        bandnum10=9
        V_K1=float(str(self.dlg.tableWidget_MetaData.item(bandnum10,5).text()))
        V_K2=float(str(self.dlg.tableWidget_MetaData.item(bandnum10,6).text()))
        print("V_1,V_2",V_K1,V_K2)
        
        #band10=self.dlg.lineEdit_url.text()+'/'+self.dlg.tableWidget_MetaData.item(9,0).text()
        #print(band10)
        #outputband10=band10[:len(band10)-4]+str(datetime.datetime.now().strftime("%Y_%m_%d_%H_%M"))+'_BRI_'+str(8)+'.TIF'

        
        input_raster = QgsRasterLayer(InputRadiance, 'Band10')
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = OutputBright
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "((({0})/(log(({1}/A)+1)))-273.15)".format(V_K2,V_K1),
        'OUTPUT' : output_raster}
        processing.run('gdal:rastercalculator', parameters)
        


        #---------------------------Reflectance calcul (TOA Reflectance) aprouved for Landsat 5 -----------------------------------------------
    def CalculTOA5(self,BandNumber,inputBand,outputBand):
        
        V_sunDistance=float(self.dlg.lbl_earthsundistance.text())
        V_sunElevation=float(self.dlg.lbl_sunelevangle.text())
        V_Pi = pi
        V_Esun=float(str(self.dlg.tableWidget_MetaData.item(BandNumber,11).text()))
        print("V_sund,V_sunelev,V_pi,V_Esun",V_sunDistance,V_sunElevation,V_Pi,V_Esun)
        A=float(193)
        #var=({0}*A*pow({1},2))/({2}+cos(radians(90-{3}))).format(V_Pi,V_sunDistance,V_Esun,V_sunElevation)
        #var=(V_Pi*193*pow(V_sunDistance,2))/(V_Esun*sin(radians(V_sunElevation)))
        #print(var)

        
        input_raster = QgsRasterLayer(inputBand, 'Raster')
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = outputBand
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "({0}*A*pow({1},2))/({2}*sin(radians({3})))".format(V_Pi,V_sunDistance,V_Esun,V_sunElevation),
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)

        #---------------------------Reflectance calcul (TOA Reflectance) for Landsat 7 -----------------------------------------------

    def calculTOA7(self,BandNumber,inputBand,outputBand):
        
        V_sunDistance=float(self.dlg.lbl_earthsundistance.text())
        V_sunElevation=float(self.dlg.lbl_sunelevangle.text())
        V_Pi = pi
        V_Esun=float(str(self.dlg.tableWidget_MetaData.item(BandNumber,11).text()))
        print("V_sund,V_sunelev,V_pi,V_Esun",V_sunDistance,V_sunElevation,V_Pi,V_Esun)

        #A=float(193)
        #var=({0}*A*pow({1},2))/({2}+cos(radians(90-{3}))).format(V_Pi,V_sunDistance,V_Esun,V_sunElevation)
        #var=(V_Pi*193*pow(V_sunDistance,2))/(V_Esun*sin(radians(V_sunElevation)))
        #print(var)
        
        input_raster = QgsRasterLayer(inputBand, 'Raster'+str(BandNumber))
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = outputBand
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "({0}*A*pow({1},2))/({2}*sin(radians({3})))".format(V_Pi,V_sunDistance,V_Esun,V_sunElevation),
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)
       
        #---------------------------Reflectance calcul (TOA Reflectance) for Landsat 8 -----------------------------------------------
        
    def calculTOA8(self,BandNumber,inputBand,outputBand):
        
        V_sunElevation=float(self.dlg.lbl_sunelevangle.text())
        V_reflectanceMult = float(str(self.dlg.tableWidget_MetaData.item(BandNumber,3).text()))
        V_reflectanceAdd = float(str(self.dlg.tableWidget_MetaData.item(BandNumber,4).text()))
        print("---------TTTTTTT------------")
        print ("SunElevation=",V_sunElevation)
        print("V_reflectanceMult=",V_reflectanceMult)
        print("V_reflectanceAdd=",V_reflectanceAdd)
        print("------------------------------")
        input_raster = QgsRasterLayer(inputBand, 'Raster'+str(BandNumber))
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = outputBand
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "((({0}*A)+{1})/sin(radians({2})))".format(V_reflectanceMult,V_reflectanceAdd,V_sunElevation),
        'OUTPUT' : output_raster}
        #processing.runAndLoadResults('gdal:rastercalculator', parameters)
        processing.run('gdal:rastercalculator', parameters)


        #--------------- radiance calcul (approuved) for Landsat5 -------------------------------------
    def calculradiance5(self,BandNumber,inputBand,outputBand):
        '''
        BandNumber=0
        inputBand='/Users/profotmane/Sat/landsat5/LT05_L1TP_201035_20100130_20161017_01_T1_B1.TIF'
        outputBand='/Users/profotmane/Sat/landsat5/ttttttttttttt.TIF'
        '''
        V_lmax = float(str(self.dlg.tableWidget_MetaData.item(BandNumber,7).text()))
        V_lmin = float(str(self.dlg.tableWidget_MetaData.item(BandNumber,8).text()))
        V_Qcalmax=float(str(self.dlg.tableWidget_MetaData.item(BandNumber,9).text()))
        V_Qcalmin=float(str(self.dlg.tableWidget_MetaData.item(BandNumber,10).text()))
        print('lmax lmin qlmax qlmin',V_lmax,V_lmin,V_Qcalmax,V_Qcalmin,)
        
        #V_lmax=float(193)
        #V_lmin=float(-1.52)
        #V_Qcalmax=float(255)
        #V_Qcalmin=float(1)
        #print("eval((((({0}-{1})*(255-{3}))/({2}-{3}))+{1})".format(V_lmax,V_lmin,V_Qcalmax,V_Qcalmin)))
        #'FORMULA': "((((((193 + 1.52) * A)/ 255 )) - 1.52))"
        #'FORMULA': "(((((({0} - {1}) * A)/ {2} )) + {1}))".format(V_lmax,V_lmin,V_Qcalmax),
        #'FORMULA': "((  (   ({0} - {1}) * (A-{3}) )/ ({2}-{3})) + {1})".format(V_lmax,V_lmin,V_Qcalmax,V_Qcalmin)
        
        input_raster = QgsRasterLayer(inputBand, 'Rester2222')
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = outputBand
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "((((({0}-{1})/({2}-{3})) * (A-{3})))+{1})".format(V_lmax,V_lmin,V_Qcalmax,V_Qcalmin),
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)

        #--------------- radiance calcul (approuved) for Landsat5 -------------------------------------
    def moyenne(self):
        input_rasterA = QgsRasterLayer('/SatDownloaded/image3/imageTraiteeBT77Celcius.TIF', 'Raster1')
        #QgsProject.instance().addMapLayer(input_rasterA)
        
        input_rasterB = QgsRasterLayer('/SatDownloaded/image3/imageTraiteeBT88Celcius.TIF', 'Raster2')
        #QgsProject.instance().addMapLayer(input_rasterB)
        
        output_raster = '/SatDownloaded/image3/imageRadianceMoy.TIF'
        parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
        'BAND_A' : 1,
        'BAND_B' : 1,        
        'FORMULA': "((A+B)/2)",
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)

    def NDVI_8(self,Band5,Band4,OutputNDVI):
         input_rasterA = QgsRasterLayer(Band5, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band4, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputNDVI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "((A-B)/(A+B))",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         
    def MSAVI_8(self,Band5,Band4,OutputMSAVI):
         input_rasterA = QgsRasterLayer(Band5, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band4, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputMSAVI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(2*A+1-sqrt(pow(2*A+1,2)-8*(A-B)))/2",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')
    def NDWI_8(self,Band3,Band5,OutputNDWI):
         input_rasterA = QgsRasterLayer(Band3, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band5, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputNDWI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(A-B)/(A+B)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')

    def MNDWI_8(self,Band3,Band6,OutputMNDWI):
         input_rasterA = QgsRasterLayer(Band3, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band6, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputMNDWI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(A-B)/(A+B)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')

    def BI_8(self,Band4,Band5,OutputBI):
         input_rasterA = QgsRasterLayer(Band4, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band5, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputBI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "sqrt(pow(A,2)+pow(B,2))",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')

    def NBR_8(self,Band5,Band7,OutputNBR):
         input_rasterA = QgsRasterLayer(Band5, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band7, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputNBR
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "((A-B)/(A+B))",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')

         
    def NDVI_5(self,Band4,Band3,OutputNDVI):
         input_rasterA = QgsRasterLayer(Band4, 'Raster1')
          #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band3, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputNDVI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "((A-B)/(A+B))",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)

    def MSAVI_5(self,Band4,Band3,OutputMSAVI):
         input_rasterA = QgsRasterLayer(Band4, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band3, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputMSAVI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(2*A+1-sqrt(pow(2*A+1,2)-8*(A-B)))/2",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')
         
    def NDWI_5(self,Band2,Band4,OutputNDWI):
         input_rasterA = QgsRasterLayer(Band2, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band4, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputNDWI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(A-B)/(A+B)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')
    def MNDWI_5(self,Band2,Band5,OutputMNDWI):
         input_rasterA = QgsRasterLayer(Band2, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band5, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputMNDWI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(A-B)/(A+B)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')

    def BI_5(self,Band3,Band4,OutputBI):
         input_rasterA = QgsRasterLayer(Band3, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band4, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputBI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "sqrt(pow(A,2)+pow(B,2))",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')

    def  NBR_5(self,Band4,Band7,OutputNBR):
         input_rasterA = QgsRasterLayer(Band4, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band7, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputNBR
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "((A-B)/(A+B))",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')
         
    def calculradiance7(self,BandNumber,inputBand,outputBand):
        
        V_lmax = float(str(self.dlg.tableWidget_MetaData.item(BandNumber,7).text()))
        V_lmin = float(str(self.dlg.tableWidget_MetaData.item(BandNumber,8).text()))
        V_Qcalmax=float(str(self.dlg.tableWidget_MetaData.item(BandNumber,9).text()))
        V_Qcalmin=float(str(self.dlg.tableWidget_MetaData.item(BandNumber,10).text()))
        print('qlmax qlmin lmax lmin',V_Qcalmax,V_Qcalmin,V_lmax,V_lmin)
        
        input_raster = QgsRasterLayer(inputBand, 'Band'+str(BandNumber))
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = outputBand
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "((((({0}-{1})/({2}-{3})) * (A-{3})))+{1})".format(V_lmax,V_lmin,V_Qcalmax,V_Qcalmin),
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)

        #--------------- radiance calcul (approuved) for Landsat5 -------------------------------------

    def calculradiance8(self,BandNumber,inputBand,outputBand):
        
        V_radianceMult = float(str(self.dlg.tableWidget_MetaData.item(BandNumber,1).text()))
        V_radianceAdd  = float(str(self.dlg.tableWidget_MetaData.item(BandNumber,2).text()))
        
        print('vradmult,vradadd',V_radianceMult,V_radianceAdd)

        
        #Formula------------------
        input_raster = QgsRasterLayer(inputBand, 'Raster'+str(BandNumber))
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = outputBand
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "(({0} * A)+{1})".format(V_radianceMult,V_radianceAdd),
        'OUTPUT' : output_raster}
        #processing.runAndLoadResults('gdal:rastercalculator', parameters)
        processing.run('gdal:rastercalculator', parameters)

    

        # ------------------ Parameters necessray for Landsat 5 ------------------------------------- 
    def LoadMetaData5(self,mypath):
        print('$$$$$$$$$$$$$$$$$$$$$$$$  Start File $$$$$$$$$$$$$$$$$$$$$$$$')
        with open(mypath, "r") as f:
             fichier_entier = f.read()
             files = fichier_entier.split("\n")
             #for line in files:
               # Traiter la ligne et ainsi de suite ...
        # i pointeur sur le ligne de fichier
        # j pointeur sur tableau d'affichage 
             j=0
             # Band Id 
             for i in range(46,53):
                print(files[i][24:len(files[i])-1])
                item = QtWidgets.QTableWidgetItem(files[i][24:len(files[i])-1])
                self.dlg.tableWidget_MetaData.setItem(j, 0, item)
                j=j+1
             # Radiance _ mult
             j=0
             for i in range(150,157):
                item = QtWidgets.QTableWidgetItem(files[i][27:])
                self.dlg.tableWidget_MetaData.setItem(j, 1, item)
                j=j+1

            # Radiance _ ADD
             j=0
             for i in range(157,164):
                item = QtWidgets.QTableWidgetItem(files[i][26:])
                self.dlg.tableWidget_MetaData.setItem(j, 2, item)
                j=j+1

             # Reflectance Mult
             j=0
             for i in range(164,169):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 3, item)
                j=j+1
             ligne=6
             item = QtWidgets.QTableWidgetItem(files[169][30:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 3, item)

             # Reflectance ADD
             j=0
             for i in range(170,175):
                item = QtWidgets.QTableWidgetItem(files[i][29:])
                self.dlg.tableWidget_MetaData.setItem(j, 4, item)
                j=j+1
             ligne=6
             item = QtWidgets.QTableWidgetItem(files[175][29:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 4, item)

             ligne=5
             item = QtWidgets.QTableWidgetItem(files[178][25:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 5, item)

             ligne=5
             item = QtWidgets.QTableWidgetItem(files[179][25:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 6, item)
             #throw out sun elevation angle
             var_sunelevation=files[66][20:]
             self.dlg.lbl_sunelevangle.setText(var_sunelevation)
             print(var_sunelevation)
             print(sin(radians(float (var_sunelevation))))

             #Max Radiance 
             j=0
             for i in range(88,102,2):
                item = QtWidgets.QTableWidgetItem(files[i][29:])
                self.dlg.tableWidget_MetaData.setItem(j, 7, item)
                j=j+1

            #Min Radiance 
             j=0
             for i in range(89,102,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 8, item)
                j=j+1
            #Men Solar exoAthmospheric irradiance
             ESUN = ['1958','1827','1551','1036','214.9','0','80.65']
             j=0
             for i in ESUN:
                 item = QtWidgets.QTableWidgetItem(i)
                 self.dlg.tableWidget_MetaData.setItem(j, 11, item)
                 j=j+1
             # Qcal Max
             j=0
             for i in range(118,132,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 9, item)
                j=j+1

             # Qcal Max
             j=0
             for i in range(119,132,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 10, item)
                j=j+1
            #Earth Sun Distance
             EarthSunDis=files[67][25:]
             print('yoooooopi :',EarthSunDis)
             self.dlg.lbl_earthsundistance.setText(EarthSunDis)
             
    #----------------data necessary for Landsat 8 -------------------------------

    def Proportion_Vegetation578(self,NDVIBand,outputPV):
        input_raster = QgsRasterLayer(NDVIBand, 'RasterNDVI')
        #QgsProject.instance().addMapLayer(input_raster)
        output_raster = outputPV
        parameters = {'INPUT_A': input_raster,
        'BAND_A' : 1,
        'FORMULA': "pow(((A-0.2)/0.3),2)",
        'OUTPUT' : output_raster}
        processing.runAndLoadResults('gdal:rastercalculator', parameters)
        
    def Emmissivity57(self,Band3,BandPV,BandNDVI,outPutEmmisivity):
         input_rasterA = QgsRasterLayer(Band3, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(BandPV, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)

         input_rasterC = QgsRasterLayer(BandNDVI, 'Raster3')
         #QgsProject.instance().addMapLayer(input_rasterC)
        
         output_raster = outPutEmmisivity
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,'INPUT_C': input_rasterC,
         'BAND_A' : 1,
         'BAND_B' : 1,
         'BAND_C' : 1,
         'FORMULA': "(0.979-(0.035*A))*(C<0.2)+(0.986+(0.004*B))*logical_and(0.2<C,C<0.5)+(0.99)*(C>0.5)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)

    def Emmissivity8(self,Band4,BandPV,BandNDVI,outPutEmmisivity):
         input_rasterA = QgsRasterLayer(Band4, 'Band4')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(BandPV, 'PV')
         #QgsProject.instance().addMapLayer(input_rasterB)

         input_rasterC = QgsRasterLayer(BandNDVI, 'NDVI')
         #QgsProject.instance().addMapLayer(input_rasterC)
        
         output_raster = outPutEmmisivity
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,'INPUT_C': input_rasterC,
         'BAND_A' : 1,
         'BAND_B' : 1,
         'BAND_C' : 1,
         'FORMULA': "(0.79-(0.046*A))*(C<0.2)+(0.99)*(C>=0.5)+0.987*B+0.971*(1-B)*logical_and(C<0.5,C>=0.2)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
    #-------------------------------- new Indexes for Landsat 8 ------------------------
    def EVI_8(self,Band5,Band4,Band2,outPutEVI):
         input_rasterA = QgsRasterLayer(Band5, 'Band5')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band4, 'Band4')
         #QgsProject.instance().addMapLayer(input_rasterB)

         input_rasterC = QgsRasterLayer(Band2, 'Band2')
         #QgsProject.instance().addMapLayer(input_rasterC)
        
         output_raster = outPutEVI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,'INPUT_C': input_rasterC,
         'BAND_A' : 1,
         'BAND_B' : 1,
         'BAND_C' : 1,
         'FORMULA': "2.5*((A-B)/(A+6*B-7.5*C+1))",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)

    def SAVI_8(self,Band5,Band4,OutputSAVI):
         input_rasterA = QgsRasterLayer(Band5, 'Raster1')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band4, 'Raster2')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputSAVI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "((A-B)/(A+B+0.5))*1.5",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')
         
    def NDMI_8(self,Band5,Band6,OutputNDMI):
         input_rasterA = QgsRasterLayer(Band5, 'Band5')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band6, 'Band6')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputNDMI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(A-B)/(A+B)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')

    def AWEInsh_8(self,Band3,Band6,Band5,Band7,outPutAWEInsh):
         input_rasterA = QgsRasterLayer(Band3, 'Band3')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band6, 'Band6')
         #QgsProject.instance().addMapLayer(input_rasterB)

         input_rasterC = QgsRasterLayer(Band5, 'Band5')
         #QgsProject.instance().addMapLayer(input_rasterC)

         input_rasterD = QgsRasterLayer(Band7, 'Band7')
         #QgsProject.instance().addMapLayer(input_rasterD)
        
         output_raster = outPutAWEInsh
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,'INPUT_C': input_rasterC,'INPUT_D': input_rasterD,
         'BAND_A' : 1,
         'BAND_B' : 1,
         'BAND_C' : 1,
         'BAND_D' : 1,
         'FORMULA': "4*(A-B)-(0.25*C+2.75*D)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)

    def AWEIsh_8(self,Band2,Band3,Band5,Band6,Band7,outPutAWEIsh):
         input_rasterA = QgsRasterLayer(Band2, 'Band2')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band3, 'Band3')
         #QgsProject.instance().addMapLayer(input_rasterB)

         input_rasterC = QgsRasterLayer(Band5, 'Band5')
         #QgsProject.instance().addMapLayer(input_rasterC)

         input_rasterD = QgsRasterLayer(Band6, 'Band6')
         #QgsProject.instance().addMapLayer(input_rasterD)

         input_rasterE = QgsRasterLayer(Band7, 'Band7')
         #QgsProject.instance().addMapLayer(input_rasterE)
        
         output_raster = outPutAWEIsh
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,'INPUT_C': input_rasterC,'INPUT_D': input_rasterD,'INPUT_E': input_rasterE,
         'BAND_A' : 1,
         'BAND_B' : 1,
         'BAND_C' : 1,
         'BAND_D' : 1,
         'BAND_E' : 1,           
         'FORMULA': "(A+(2.5*B))-(1.5*(C+D))-(0.25*E)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         
    def NDBI_8(self,Band6,Band5,OutputNDBI):
         input_rasterA = QgsRasterLayer(Band6, 'Band6')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(Band5, 'Band5')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputNDBI
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(A-B)/(A+B)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')

    def BU_8_7_5(self,BandNDBI,BandNDVI,OutputBU):
         input_rasterA = QgsRasterLayer(BandNDBI, 'NDBI')
         #QgsProject.instance().addMapLayer(input_rasterA)
        
         input_rasterB = QgsRasterLayer(BandNDVI, 'NDVI')
         #QgsProject.instance().addMapLayer(input_rasterB)
        
         output_raster = OutputBU
         parameters = {'INPUT_A': input_rasterA,'INPUT_B': input_rasterB,
         'BAND_A' : 1,
         'BAND_B' : 1,        
         'FORMULA': "(A-B)",
         'OUTPUT' : output_raster}
         processing.runAndLoadResults('gdal:rastercalculator', parameters)
         print('FINNNNNN')
    def LoadMetaData8(self,mypath):
        print('$$$$$$$$$$$$$$$$$$$$$$$$  Start File $$$$$$$$$$$$$$$$$$$$$$$$')
        #with open("/SatDownloaded/image2/LC08_L1TP_201035_20190107_20190130_01_T1/LC08_L1TP_201035_20190107_20190130_01_T1_MTL.txt", "r") as f:
        with open(mypath, "r") as f:
             fichier_entier = f.read()
             files = fichier_entier.split("\n")
             #for line in files:
               # Traiter la ligne et ainsi de suite ...
        # i pointeur sur le ligne de fichier
        # j pointeur sur tableau d'affichage 
             j=0
             # Band Id 
             for i in range(47,56):
                print(files[i][24:len(files[i])-1])
                item = QtWidgets.QTableWidgetItem(files[i][24:len(files[i])-1])
                self.dlg.tableWidget_MetaData.setItem(j, 0, item)
                j=j+1

             # Band Id 
             for i in range(56,58):
                item = QtWidgets.QTableWidgetItem(files[i][25:len(files[i])-1])
                self.dlg.tableWidget_MetaData.setItem(j, 0, item)
                j=j+1
            
             # Radiance _ mult
             j=0
             for i in range(165,176):
                item = QtWidgets.QTableWidgetItem(files[i][27:])
                self.dlg.tableWidget_MetaData.setItem(j, 1, item)
                j=j+1

            # Radiance _ ADD
             j=0
             for i in range(176,187):
                item = QtWidgets.QTableWidgetItem(files[i][26:])
                self.dlg.tableWidget_MetaData.setItem(j, 2, item)
                j=j+1

             # Reflectance Mult
             j=0
             for i in range(187,196):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 3, item)
                j=j+1
             
             # Reflectance ADD
             j=0
             for i in range(196,205):
                item = QtWidgets.QTableWidgetItem(files[i][29:])
                self.dlg.tableWidget_MetaData.setItem(j, 4, item)
                j=j+1
            

             ligne=9
             item = QtWidgets.QTableWidgetItem(files[207][25:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 5, item)

             item = QtWidgets.QTableWidgetItem(files[208][25:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 6, item)


             ligne=10
             item = QtWidgets.QTableWidgetItem(files[209][25:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 5, item)
             
             item = QtWidgets.QTableWidgetItem(files[210][25:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 6, item)

             #throw out sun elevation angle
             var_sunelevation=files[76][20:]
             print(var_sunelevation)
             print(sin(radians(float (var_sunelevation))))

             #throw out sun elevation angle
             var_sunelevation=files[76][20:]
             self.dlg.lbl_sunelevangle.setText(var_sunelevation)
             print(var_sunelevation)
             print(sin(radians(float (var_sunelevation))))

        # ------------------ Parameters necessray for Landsat 7------------------------------------- 
    def LoadMetaData7(self,pathMTL):
        print('$$$$$$$$$$$$$$$$$$$$$$$$  Start File $$$$$$$$$$$$$$$$$$$$$$$$')
        #with open("/SatDownloaded/image3/LE07_L1TP_201035_20030103_20170214_01_T1_MTL.txt", "r") as f:
        with open(pathMTL, "r") as f:
             fichier_entier = f.read()
             files = fichier_entier.split("\n")
             #for line in files:
               # Traiter la ligne et ainsi de suite ...
        # i pointeur sur le ligne de fichier
        # j pointeur sur tableau d'affichage 
             j=0
             # Band Id 
             for i in range(47,52):
                print(files[i][24:len(files[i])-1])
                item = QtWidgets.QTableWidgetItem(files[i][24:len(files[i])-1])
                self.dlg.tableWidget_MetaData.setItem(j, 0, item)
                j=j+1

             for i in range(52,54):
                print(files[i][24:len(files[i])-1])
                item = QtWidgets.QTableWidgetItem(files[i][31:len(files[i])-1])
                self.dlg.tableWidget_MetaData.setItem(j, 0, item)
                j=j+1
                
             for i in range(54,56):
                print(files[i][24:len(files[i])-1])
                item = QtWidgets.QTableWidgetItem(files[i][24:len(files[i])-1])
                self.dlg.tableWidget_MetaData.setItem(j, 0, item)
                j=j+1  

             '''ligne=5
             item = QtWidgets.QTableWidgetItem(files[52][31:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 0, item)
             
             ligne=6
             item = QtWidgets.QTableWidgetItem(files[53][31:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 0, item)
             
             ligne=7
             item = QtWidgets.QTableWidgetItem(files[54][24:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 0, item)
             
             ligne=8
             item = QtWidgets.QTableWidgetItem(files[55][24:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 0, item)'''
             
             # Radiance _ mult
             j=0
             for i in range(188,193):
                item = QtWidgets.QTableWidgetItem(files[i][27:])
                self.dlg.tableWidget_MetaData.setItem(j, 1, item)
                j=j+1

             for i in range(193,195):
                item = QtWidgets.QTableWidgetItem(files[i][34:])
                self.dlg.tableWidget_MetaData.setItem(j, 1, item)
                j=j+1
            
             for i in range(195,197):
                item = QtWidgets.QTableWidgetItem(files[i][27:])
                self.dlg.tableWidget_MetaData.setItem(j, 1, item)
                j=j+1
                
             '''ligne=5
             item = QtWidgets.QTableWidgetItem(files[193][34:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 1, item)
             
             ligne=6
             item = QtWidgets.QTableWidgetItem(files[194][34:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 1, item)
             
             ligne=7
             item = QtWidgets.QTableWidgetItem(files[195][27:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 1, item)
             
             ligne=8
             item = QtWidgets.QTableWidgetItem(files[196][27:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 1, item)'''

            # Radiance _ ADD
             j=0
             for i in range(197,202):
                item = QtWidgets.QTableWidgetItem(files[i][26:])
                self.dlg.tableWidget_MetaData.setItem(j, 2, item)
                j=j+1

             for i in range(202,204):
                item = QtWidgets.QTableWidgetItem(files[i][33:])
                self.dlg.tableWidget_MetaData.setItem(j, 2, item)
                j=j+1

             for i in range(204,206):
                item = QtWidgets.QTableWidgetItem(files[i][26:])
                self.dlg.tableWidget_MetaData.setItem(j, 2, item)
                j=j+1

             '''ligne=5
             item = QtWidgets.QTableWidgetItem(files[202][33:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 2, item)
             
             ligne=6
             item = QtWidgets.QTableWidgetItem(files[203][33:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 2, item)
             
             ligne=7
             item = QtWidgets.QTableWidgetItem(files[204][26:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 2, item)
             
             ligne=8
             item = QtWidgets.QTableWidgetItem(files[205][26:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 2, item)'''

             # Reflectance Mult
             j=0
             for i in range(206,211):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 3, item)
                j=j+1
                
             ligne=7
             item = QtWidgets.QTableWidgetItem(files[211][30:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 3, item)
             
             ligne=8
             item = QtWidgets.QTableWidgetItem(files[212][30:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 3, item)

             # Reflectance ADD
             j=0
             for i in range(213,218):
                item = QtWidgets.QTableWidgetItem(files[i][29:])
                self.dlg.tableWidget_MetaData.setItem(j, 4, item)
                j=j+1
                
             ligne=7
             item = QtWidgets.QTableWidgetItem(files[218][29:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 4, item)
             
             ligne=8
             item = QtWidgets.QTableWidgetItem(files[219][29:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 4, item)

             # K1 et K2

             ligne=5
             item = QtWidgets.QTableWidgetItem(files[222][32:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 5, item)

             ligne=5
             item = QtWidgets.QTableWidgetItem(files[223][32:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 6, item)
             
             ligne=6
             item = QtWidgets.QTableWidgetItem(files[224][32:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 5, item)

             ligne=6
             item = QtWidgets.QTableWidgetItem(files[225][32:])
             self.dlg.tableWidget_MetaData.setItem(ligne, 6, item)
             
             #throw out sun elevation angle
             var_sunelevation=files[67][20:]
             self.dlg.lbl_sunelevangle.setText(var_sunelevation)
             print(var_sunelevation)
             print(sin(radians(float (var_sunelevation))))

             #Max Radiance 
             j=0
             for i in range(85,95,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 7, item)
                j=j+1

             for i in range(95,99,2):
                item = QtWidgets.QTableWidgetItem(files[i][37:])
                self.dlg.tableWidget_MetaData.setItem(j, 7, item)
                j=j+1

             for i in range(99,103,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 7, item)
                j=j+1

             #Min Radiance 
             j=0
             for i in range(86,95,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 8, item)
                j=j+1
                
             for i in range(96,99,2):
                item = QtWidgets.QTableWidgetItem(files[i][37:])
                self.dlg.tableWidget_MetaData.setItem(j, 8, item)
                j=j+1
                
             for i in range(100,103,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 8, item)
                j=j+1
            
             # Qcal Max
             j=0
             for i in range(121,131,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 9, item)
                j=j+1

             for i in range(131,135,2):
                item = QtWidgets.QTableWidgetItem(files[i][37:])
                self.dlg.tableWidget_MetaData.setItem(j, 9, item)
                j=j+1
                
             for i in range(135,139,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 9, item)
                j=j+1

             # Qcal Min
             j=0
             for i in range(122,131,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 10, item)
                j=j+1
                
             for i in range(132,135,2):
                item = QtWidgets.QTableWidgetItem(files[i][37:])
                self.dlg.tableWidget_MetaData.setItem(j, 10, item)
                j=j+1

             for i in range(136,139,2):
                item = QtWidgets.QTableWidgetItem(files[i][30:])
                self.dlg.tableWidget_MetaData.setItem(j, 10, item)
                j=j+1

             #Men Solar exoAthmospheric irradiance
             ESUN = ['1970','1842','1547','1044','225.7','0','0','82.06','1369']
             j=0
             for i in ESUN:
                 item = QtWidgets.QTableWidgetItem(i)
                 self.dlg.tableWidget_MetaData.setItem(j, 11, item)
                 j=j+1
                
            #Earth Sun Distance
             EarthSunDis=files[68][25:]
             print('yoooooopi :',EarthSunDis)
             self.dlg.lbl_earthsundistance.setText(EarthSunDis)
    def changerItem(self):
        self.dlg.combo_sat.setCurrentIndex(self.dlg.combo_product.currentIndex())
    def SelectCheckBoxLST(self):
        if (self.dlg.check_LST.isChecked())==True:
             self.dlg.check_PV.setChecked(True)
             self.dlg.check_NDVI.setChecked(True)
        else:
             self.dlg.check_PV.setChecked(False)
             self.dlg.check_NDVI.setChecked(False)
    def SelectCheckBoxPV(self):
        if (self.dlg.check_PV.isChecked())==True:
             self.dlg.check_NDVI.setChecked(True)
        else:
             self.dlg.check_NDVI.setChecked(False)
    def SelectCheckBoxUTFVI(self):
        if (self.dlg.check_UTFVI.isChecked())==True:
             self.dlg.check_LST.setChecked(True)
        else:
             self.dlg.check_LST.setChecked(False)
             
    def SelectCheckBoxHS(self):
        if (self.dlg.check_HS.isChecked())==True:
             self.dlg.check_LST.setChecked(True)
        else:
             self.dlg.check_LST.setChecked(False)

    def SelectCheckBoxBU(self):
        if (self.dlg.check_BU.isChecked())==True:
             self.dlg.check_NDBI.setChecked(True)
             self.dlg.check_NDVI.setChecked(True)
        else:
             self.dlg.check_NDBI.setChecked(False)
             self.dlg.check_NDVI.setChecked(False)

    def getRasterExtent(raster_path):
        src = gdal.Open(raster_path)
        ulx, xres, xskew, uly, yskew, yres  = src.GetGeoTransform()
        lrx = ulx + (src.RasterXSize * xres)
        lry = uly + (src.RasterYSize * yres)
        return [ulx,lrx,lry,uly]
    
    def raster2array(rasterfn):
        raster = gdal.Open(rasterfn)
        band = raster.GetRasterBand(1)
        array = band.ReadAsArray()
        return array
    
    def CalculCorrellationMatrix(self):
        '''
        rasterList=[]
        extent=[50,50,50,50]
        rasterList.append('/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B2.TIF')
        rasterList.append('/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B1.TIF')
        urlraster='/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B1.TIF'
        #extent=self.getRasterExtent(urlraster)
        rasterString =str( ";".join(rasterList))
        #xmin,xmax,ymax,ymin = extent[0],extent[1],extent[2],extent[3]
        xmin,xmax,ymax,ymin = extent[0],extent[1],extent[2],extent[3]
        outputRaster= '/Users/profotmane/Desktop/Sat//Great.html'
        outputRaw = '/Users/profotmane/Desktop/Sat//Great.txt'
        output=processing.run('grass7:r.covar', rasterString,True,"%f,%f,%f,%f" %(xmin, xmax, ymax, ymin),outputRaster,outputRaw)
        '''
        
        #input_rasterA ="/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B2.TIF"
        input_rasterA = QgsRasterLayer('/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B2.TIF', 'NDVI')
        #QgsProject.instance().addMapLayer(input_rasterA)
        input_rasterB = QgsRasterLayer('/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B1.TIF','TEST')
        #QgsProject.instance().addMapLayer(input_rasterB)
        
        output_html = '/Users/profotmane/Desktop/Sat//Great.html'
        output_txt = '/Users/profotmane/Desktop/Sat//Great.html'
        #parameters = {'map': [QgsProject.instance().mapLayers().values()],'html':output_html,'text':output_txt}
        parameters = {'map':[input_rasterA,input_rasterB],'html':output_txt,'-r' : True}
        final_fil=processing.run('grass7:r.covar', parameters)
        print(final_fil)
        '''
        stats = input_rasterA.dataProvider().bandStatistics(1, QgsRasterBandStats.All)
        print(stats.minimumValue)
        print(stats.maximumValue)
        print(stats.mean)
        print(stats.range)
        print(stats.stdDev)
        print(stats.sum)
        print(stats.sumOfSquares)
        '''
        '''
        import pandas as pd
        import numpy as np
        
        input_rasterA =QgsRasterLayer("/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B2.TIF",'test1')
        input_rasterB =QgsRasterLayer("/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B1.TIF",'test2')
        input_rasterC =QgsRasterLayer("/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B3.TIF",'test3')

        ds = gdal.Open(input_rasterA)
        myarray = np.array(ds.GetRasterBand(1).ReadAsArray())
        
        rasterArray1 = myarray
        rasterArray2 = myarray
        rasterArray3 = myarray
        data = {'A': self.raster2array("/Users/profotmane/Desktop/Sat/LC08_L1TP_201035_20190107_20190130_01_T1_B2.TIF"),
                }

        df = pd.DataFrame(data,columns=['A','B','C'])

        covMatrix = pd.DataFrame.cov(df)
        print (covMatrix)

        '''
    
        '''
        #with open("/Users/profotmane/Desktop/Sat/Great.html","r") as f:
        with open(reshtml,"r") as f:
             fch=f.readlines()
        #Ligne1=fch[1][5:].split(' ')
        #ligne2=fch[2][5:].split(' ')
        #print(Ligne1[0],Ligne1[1])
        #print(ligne2[0],ligne2[1])
        '''
        '''
        import pandas as pd
        import matplotlib.pyplot as plt
        import pandas as pd
        import seaborn as sn
        import matplotlib.pyplot as plt

        data = {'A': [float(Ligne1[0]),float(Ligne1[0])],
                'B': [12,14]
                }

        df = pd.DataFrame(data,columns=['A','B'])

        covMatrix = pd.DataFrame.cov(df)
        print (covMatrix)
                
        sn.heatmap(covMatrix, annot=True, fmt='g')
        plt.show()
        '''
        '''
        print('---------------covar -------------------')
        Covariancetab=[]
        Indices=[]
        registry = QgsProject.instance()
        i=0
        for lyr in registry.mapLayers().values():
            Covariancetab.append([])
            Covariancetab[i].append(lyr.name())
            Indices.append(lyr.name())
            i+=1
        
        j=0
        for line in fch[1:-1]:
            lignewithoutBr=line[5:]
            element=lignewithoutBr.split(' ')
            for i in range(len(element)):
                Covariancetab[j].append(element[i])
            j+=1
        
        print('-------')
        print(Covariancetab)
        print('-------')
        
        
        import matplotlib.pyplot as plt
        tab1=[]
        tab1.append(['--'])
        for r in Indices:
           tab1.append(r)
        data = [Covariancetab[0][:3],Covariancetab[1][:3]]
        
        table = plt.table(cellText=data, colLabels=tab1, loc='center', 
                          cellLoc='center', colColours=['#FFFFFF', '#F3CC32','#F3CC32'])
        '''
        '''
        table.auto_set_font_size(False)
        h = table.get_celld()[(0,0)].get_height()
        w = table.get_celld()[(0,0)].get_width()
        '''
        '''
        # Create an additional Header
        header = [table.add_cell(-1,pos, w, h, loc="center", facecolor="none") for pos in [1,2,3,4]]
        header[0].visible_edges = "TBL"
        header[1].visible_edges = "TB"
        header[2].visible_edges = "TB"
        header[3].visible_edges = "TBR"
        header[1].get_text().set_text("             Covariance Matrix")
        '''
        #plt.axis('off')
        #plt.show()
        
    def CalculStatics(self):
        import matplotlib.pyplot as plt
        i=0
        baco=[]
        
       
        for layer in QgsProject.instance().mapLayers().values():
                stats = layer.dataProvider().bandStatistics(1, QgsRasterBandStats.All)
                print(stats.minimumValue)
                print(stats.maximumValue)
                print(stats.mean)
                print(stats.range)
                print(stats.stdDev)
                print(stats.sum)
                print('-----------------')
                baco.append([])
                baco[i].append(stats.minimumValue)
                baco[i].append(stats.maximumValue)
                baco[i].append(stats.mean)
                i+=1
        tab1=['EVA','ZA','ZZ']
        
        data=[baco[0][:],baco[1][:],baco[2][:]]
        table = plt.table(cellText=data, colLabels=tab1, loc='center', 
                          cellLoc='center', colColours=['#FFFFFF', '#F3CC32','#F3CC32'])
        plt.axis('off')
        plt.show()
        
    def run(self):
        """Run method that performs all the real work"""
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Q_LIPDialog()
            self.dlg.cloudslider.valueChanged.connect(self.CloudCouverageDisplay)
            self.dlg.btn_select.clicked.connect(self.getWholeInformations)
            self.dlg.tableResult.itemSelectionChanged.connect(self.Display)
            self.dlg.btn_open_directory.clicked.connect(self.openDirectory)
            self.dlg.listWidget_files.itemDoubleClicked.connect(self.DisplayRaster)
            self.dlg.btn_loadMeta.clicked.connect(self.LoadMetaData7)
            self.dlg.btn_Run.clicked.connect(self.runProcessing33_88)
            self.dlg.combo_product.currentIndexChanged.connect(self.changerItem)
            self.dlg.btn_downloading.clicked.connect(self.downloading)
            self.dlg.check_LST.stateChanged.connect(self.SelectCheckBoxLST)
            self.dlg.check_PV.stateChanged.connect(self.SelectCheckBoxPV)
            self.dlg.check_UTFVI.stateChanged.connect(self.SelectCheckBoxUTFVI)
            self.dlg.check_HS.stateChanged.connect(self.SelectCheckBoxHS)
            self.dlg.check_BU.stateChanged.connect(self.SelectCheckBoxBU)
            self.dlg.combo_product.setVisible(False)
            self.dlg.check_correla_Matrix.clicked.connect(self.CalculCorrellationMatrix)
            self.dlg.check_zon_static.clicked.connect(self.CalculStatics)
            
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

