#!/usr/bin/env python
#!/usr/bin/env python
# -*- coding: utf-8 -*-
# --------------------------------------------------------
#	q5pfes_dialogs - Dialog classes for q5pfes
#
#	begin				: 01/07/2022
#	copyright			: (c) 2022 by IFEE
#	email				: ifee@ifee.edu.vn
# --------------------------------------------------------
import csv
import math
import os.path
import operator
import sys
import time
import asyncio
import shutil
import re
import glob
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QDir
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, Qgis, QgsApplication
from PyQt5.QtSql import *
from osgeo import ogr
import pandas as pd
import numpy as np
import decimal
import xlrd
from collections import OrderedDict
import simplejson as json
import json
from json import *

# Initialize Qt resources from file resources.py
import psycopg2
import socket
import subprocess
from subprocess import Popen
import os

# Import the code for the dialog
import os.path
import processing

from qgis.core import *
import qgis.utils
from qgis.utils import iface
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from .q5pfes_library import *
from PyQt5.QtGui import QIntValidator
#from PyQt6.QtGui import QIntValidator


#from .spilit_layer_dialog import SplitByAttributesDialog

from qgis.gui import QgsMessageBar
import pathlib
from pathlib import Path


sys.path.append(os.path.dirname(os.path.abspath(__file__)) + "/forms")
from Dlg_CauHinh import *
from Dlg_DownloadDBR import *
from Dlg_ChuanHoaDBR import *
from Dlg_ChuanHoaDBR2 import *
from Dlg_CheckError import *
from Dlg_XayDungCTDL import *
from Dlg_CapNhatVCT import *
from Dlg_CapNhatDTCT import *
from Dlg_XayDungCSDL import *
from Dlg_CapNhatDG import *
from Dlg_XuatBieuNhom1 import *
from Dlg_XuatBieuNhom2 import *
from Dlg_XayDungTrangIn import *
from Dlg_LayOut import *

class CauHinh_Dlg(QDialog, Ui_Dialog_CauHinh):

	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.inBtn.clicked.connect(self.select_input_shape)
		self.buttonBox.accepted.connect(self.checkRun)
		conf_fol = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f1 = open(conf_fol, 'r')
		conf_folder = f1.read()
		self.inPath.setText(conf_folder) 
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
		f = open(conf_dir, 'r')
		conf_code = f.read()

		if conf_code == "17":
			self.cbBox_conf.clear() 
			self.cbBox_conf.addItems(['17 - Cấu hình làm việc tỉnh Hòa Bình',' --- Cấu hình làm việc chung --- ','38 - Cấu hình làm việc tỉnh Thanh Hóa','40 - Cấu hình làm việc tỉnh Nghệ An','45 - Cấu hình làm việc tỉnh Quảng Trị','49 - Cấu hình làm việc tỉnh Quảng Nam','14 - Cấu hình làm việc tỉnh Sơn La','10 - Cấu hình làm việc tỉnh Lào Cai','37 - Cấu hình làm việc tỉnh Ninh Bình','20 - Cấu hình làm việc tỉnh Lạng Sơn'])
		elif conf_code == "14":
			self.cbBox_conf.clear() 
			self.cbBox_conf.addItems(['14 - Cấu hình làm việc tỉnh Sơn La',' --- Cấu hình làm việc chung --- ','17 - Cấu hình làm việc tỉnh Hòa Bình','38 - Cấu hình làm việc tỉnh Thanh Hóa','40 - Cấu hình làm việc tỉnh Nghệ An','45 - Cấu hình làm việc tỉnh Quảng Trị','49 - Cấu hình làm việc tỉnh Quảng Nam','10 - Cấu hình làm việc tỉnh Lào Cai','37 - Cấu hình làm việc tỉnh Ninh Bình','20 - Cấu hình làm việc tỉnh Lạng Sơn'])
		elif conf_code == "40":
			self.cbBox_conf.clear() 
			self.cbBox_conf.addItems(['40 - Cấu hình làm việc tỉnh Nghệ An',' --- Cấu hình làm việc chung --- ','17 - Cấu hình làm việc tỉnh Hòa Bình','38 - Cấu hình làm việc tỉnh Thanh Hóa','45 - Cấu hình làm việc tỉnh Quảng Trị','49 - Cấu hình làm việc tỉnh Quảng Nam','14 - Cấu hình làm việc tỉnh Sơn La','10 - Cấu hình làm việc tỉnh Lào Cai','37 - Cấu hình làm việc tỉnh Ninh Bình','20 - Cấu hình làm việc tỉnh Lạng Sơn'])
		elif conf_code == "38":
			self.cbBox_conf.clear()
			self.cbBox_conf.addItems(['38 - Cấu hình làm việc tỉnh Thanh Hóa',' --- Cấu hình làm việc chung --- ','17 - Cấu hình làm việc tỉnh Hòa Bình','40 - Cấu hình làm việc tỉnh Nghệ An','45 - Cấu hình làm việc tỉnh Quảng Trị','49 - Cấu hình làm việc tỉnh Quảng Nam','14 - Cấu hình làm việc tỉnh Sơn La','10 - Cấu hình làm việc tỉnh Lào Cai','37 - Cấu hình làm việc tỉnh Ninh Bình','20 - Cấu hình làm việc tỉnh Lạng Sơn'])
		elif conf_code == "49":
			self.cbBox_conf.clear()
			self.cbBox_conf.addItems(['49 - Cấu hình làm việc tỉnh Quảng Nam',' --- Cấu hình làm việc chung --- ','17 - Cấu hình làm việc tỉnh Hòa Bình','38 - Cấu hình làm việc tỉnh Thanh Hóa','40 - Cấu hình làm việc tỉnh Nghệ An','45 - Cấu hình làm việc tỉnh Quảng Trị','14 - Cấu hình làm việc tỉnh Sơn La','10 - Cấu hình làm việc tỉnh Lào Cai','37 - Cấu hình làm việc tỉnh Ninh Bình','20 - Cấu hình làm việc tỉnh Lạng Sơn'])
		elif conf_code == "45":
			self.cbBox_conf.clear()
			self.cbBox_conf.addItems(['45 - Cấu hình làm việc tỉnh Quảng Trị',' --- Cấu hình làm việc chung --- ','17 - Cấu hình làm việc tỉnh Hòa Bình','38 - Cấu hình làm việc tỉnh Thanh Hóa','40 - Cấu hình làm việc tỉnh Nghệ An','49 - Cấu hình làm việc tỉnh Quảng Nam','14 - Cấu hình làm việc tỉnh Sơn La','10 - Cấu hình làm việc tỉnh Lào Cai','37 - Cấu hình làm việc tỉnh Ninh Bình','20 - Cấu hình làm việc tỉnh Lạng Sơn'])
		elif conf_code == "10":
			self.cbBox_conf.clear()
			self.cbBox_conf.addItems(['10 - Cấu hình làm việc tỉnh Lào Cai',' --- Cấu hình làm việc chung --- ','45 - Cấu hình làm việc tỉnh Quảng Trị','17 - Cấu hình làm việc tỉnh Hòa Bình','38 - Cấu hình làm việc tỉnh Thanh Hóa','40 - Cấu hình làm việc tỉnh Nghệ An','49 - Cấu hình làm việc tỉnh Quảng Nam','14 - Cấu hình làm việc tỉnh Sơn La','37 - Cấu hình làm việc tỉnh Ninh Bình','20 - Cấu hình làm việc tỉnh Lạng Sơn'])
		elif conf_code == "37":
			self.cbBox_conf.clear() 
			self.cbBox_conf.addItems(['37 - Cấu hình làm việc tỉnh Ninh Bình',' --- Cấu hình làm việc chung --- ','17 - Cấu hình làm việc tỉnh Hòa Bình','38 - Cấu hình làm việc tỉnh Thanh Hóa','40 - Cấu hình làm việc tỉnh Nghệ An','45 - Cấu hình làm việc tỉnh Quảng Trị','49 - Cấu hình làm việc tỉnh Quảng Nam','14 - Cấu hình làm việc tỉnh Sơn La','10 - Cấu hình làm việc tỉnh Lào Cai','20 - Cấu hình làm việc tỉnh Lạng Sơn'])	
		elif conf_code == "20":
			self.cbBox_conf.clear() 
			self.cbBox_conf.addItems(['20 - Cấu hình làm việc tỉnh Lạng Sơn','37 - Cấu hình làm việc tỉnh Ninh Bình',' --- Cấu hình làm việc chung --- ','17 - Cấu hình làm việc tỉnh Hòa Bình','38 - Cấu hình làm việc tỉnh Thanh Hóa','40 - Cấu hình làm việc tỉnh Nghệ An','45 - Cấu hình làm việc tỉnh Quảng Trị','49 - Cấu hình làm việc tỉnh Quảng Nam','14 - Cấu hình làm việc tỉnh Sơn La','10 - Cấu hình làm việc tỉnh Lào Cai'])
		else:
			self.cbBox_conf.clear()
			self.cbBox_conf.addItems([' --- Cấu hình làm việc chung --- ','17 - Cấu hình làm việc tỉnh Hòa Bình','38 - Cấu hình làm việc tỉnh Thanh Hóa','40 - Cấu hình làm việc tỉnh Nghệ An','45 - Cấu hình làm việc tỉnh Quảng Trị','49 - Cấu hình làm việc tỉnh Quảng Nam','14 - Cấu hình làm việc tỉnh Sơn La','10 - Cấu hình làm việc tỉnh Lào Cai','37 - Cấu hình làm việc tỉnh Ninh Bình','20 - Cấu hình làm việc tỉnh Lạng Sơn'])

	def checkRun(self):
		if self.inPath.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa cấu hình thư mục làm việc", level=Qgis.Warning, duration=5)

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()  
		self.path_solution = str(QFileDialog.getExistingDirectory(caption="Q5PFES - Chọn thư mục làm việc",directory=conf_folder,options=QFileDialog.ShowDirsOnly))
		self.inPath.setText(self.path_solution)

	def run(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
		conf_fol = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'	
		folder = self.inPath.text()
		matinh = self.cbBox_conf.currentText().split(" - ")[0]
		if matinh != "17" and matinh != "38" and matinh != "40" and matinh != "45" and matinh != "49" and matinh != "14" and matinh != "10" and matinh != "37" and matinh != "20":
			matinh = '0'
			self.iface.messageBar().pushMessage("Đã cấu hình làm việc chung" + " và cấu hình thư mục làm việc người dùng", level=Qgis.Success, duration=5)
		else:
			matinh = matinh
			notif = self.cbBox_conf.currentText().split(" - ")[-1]
			self.iface.messageBar().pushMessage("Đã " + notif + " và cấu hình thư mục làm việc người dùng", level=Qgis.Success, duration=5)

		config(conf_dir,matinh)
		config(conf_fol,folder)							

class DownloadDBR_Dlg(QDialog, Ui_Dialog_DownloadDBR):

	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.btn_checkcon.clicked.connect(self.check_conn)
		self.btn_start.setEnabled(False)
		self.btn_stop.setEnabled(False)
		self.btn_download.setEnabled(False)
		self.btn_start.clicked.connect(self.start_db)
		self.btn_stop.clicked.connect(self.stop_db)
		self.btn_browse.clicked.connect(self.save_as)
		self.btn_download.clicked.connect(self.checkRun)
		self.btn_cancel.clicked.connect(self.close_form)
		self.inHost.clear()
		self.inHost.addItems(['LOCAL', 'VNFOREST'])
		self.inHost.currentIndexChanged.connect(self.set_defauled)
		self.inPort.setText("5433")
		self.inUsername.setText("postgres")
		self.inPassword.setText("vidagis")
		self.outPath.setText('')										 
		self.inProvince.currentIndexChanged.connect(self.laydanhsachhuyen)
		self.inDistrict.currentIndexChanged.connect(self.laydanhsachxa)
		self.laydanhsachtinh()
		self.laydanhsachhuyen()
		self.laydanhsachxa()

		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8')

		conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
		f = open(conf_dir, 'r')
		conf_code = f.read()
		if conf_code =="17":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:9211'))
		elif conf_code =="14":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:9206'))
		elif conf_code =="40":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:9208'))
		elif conf_code =="38":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:5897'))
		elif conf_code =="37":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:5897'))
		elif conf_code =="49":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:5899'))
		elif conf_code =="45":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:9212'))
		elif conf_code =="10":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:9208'))
		elif conf_code =="20":
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:9215'))
		else: 
			self.outProjection.setCrs(QgsCoordinateReferenceSystem('EPSG:3405'))

	def check_conn(self):
	  # Check postgres is running
		inhost = self.set_defauled()["host"]
		inport = self.inPort.text()
		indatabase = "data_forest"
		inuser = self.inUsername.text()
		inpass = self.inPassword.text()
		try:
			conn = psycopg2.connect(database = indatabase, user = inuser, password= inpass, host = inhost, port= inport)
			cursor = conn.cursor()
			self.btn_start.setEnabled(False)
			self.btn_stop.setEnabled(True)
			self.btn_download.setEnabled(True)
			self.iface.messageBar().pushMessage("Đã kết nối đến máy chủ " + inhost, level=Qgis.Success, duration=5)
		except:
			self.btn_start.setEnabled(True)
			self.btn_stop.setEnabled(False)
			self.btn_download.setEnabled(False)
			self.iface.messageBar().pushMessage("Chưa kết nối đến máy chủ " + inhost, level=Qgis.Warning, duration=5)

	def start_db(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 
		inhost = self.set_defauled()["host"]
		stop_dir = str(Path(__file__).parent.absolute()) + '/data/stopDir.txt'
		start_dir = QFileDialog.getExistingDirectory(caption="Q5PFES - Chọn thư mục Postgres",directory=conf_folder,options=QFileDialog.ShowDirsOnly)
		if os.path.exists(start_dir + '/startlocaldb.bat'):
			start_part = f'{start_dir}/startlocaldb.bat'
			subprocess.Popen(start_part, shell=True, stdout=subprocess.DEVNULL, stderr=subprocess.STDOUT)
			config(stop_dir,start_dir)
			self.btn_start.setEnabled(False)
			self.btn_stop.setEnabled(True)
			self.btn_download.setEnabled(True)
			self.iface.messageBar().pushMessage("Đã kết nối đến máy chủ " + inhost, level=Qgis.Success, duration=5)
		else:
			self.btn_start.setEnabled(True)
			self.btn_stop.setEnabled(False)
			self.btn_download.setEnabled(False)
			self.iface.messageBar().pushMessage("Chưa chọn đúng thư mục Postgres, vui lòng chọn lại!" , level=Qgis.Warning, duration=5)

	def stop_db(self):
		inhost = self.set_defauled()["host"]
		stop_dir = str(Path(__file__).parent.absolute()) + '/data/stopDir.txt'
		f = open(stop_dir, 'r')
		stop = f.read()
		if os.path.exists(stop + '/stoplocaldb.bat'):
			stop_part = f'{stop}/stoplocaldb.bat'
			subprocess.Popen(stop_part, shell=True, stdout=subprocess.DEVNULL, stderr=subprocess.STDOUT)
			self.btn_start.setEnabled(True)
			self.btn_stop.setEnabled(False)
			self.btn_download.setEnabled(False)
			self.iface.messageBar().pushMessage("Đã ngắt kết nối đến máy chủ " + inhost, level=Qgis.Info, duration=5)
		else:
			self.btn_start.setEnabled(False)
			self.btn_stop.setEnabled(True)
			self.btn_download.setEnabled(True)
			self.iface.messageBar().pushMessage("Error","Không thể ngắt kết nối do thư mục Postgres bị xóa hoặc di chuyển tới nơi khác!" , level=Qgis.Critical, duration=5)

	def save_as(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()
		dir = QFileDialog.getSaveFileName(caption="Q5PFES-Chọn thư mục lưu kết quả tải về",directory = conf_folder, filter= "Shape file(*.shp)", options = QFileDialog.Options() )[0]
		self.outPath.setText(dir)

	def checkRun(self):
		if self.outPath.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn thư mục lưu bản đồ tải về", level=Qgis.Warning, duration=5)

	def prj_crs(self, _tinh):
		_tinh = _tinh.split(' - ')[-1]
		_dstinh = docdstinh()
		for tinh in _dstinh:
			if tinh['TINH'] == _tinh:
				_crs = tinh['CRS']
				return _crs

	def set_defauled(self):
		ind = self.inHost.currentIndex()
		if ind == 0:
			host = "localhost"
			use = "postgres"
			pas = "vidagis"
			port = "5433"
			self.inPort.setText(port)
			self.inUsername.setText(use)
			self.inPassword.setText(pas)
			defaul = {
			"host": host,
			"use": use,
			"pas": pas,
			"port": port
			}
			return defaul
		
		else:
			self.btn_download.setEnabled(True)
			host = "vnforest.gov.vn"
			use = ""
			pas = ""
			port = "5433"
			self.inPort.setText(port)
			self.inUsername.setText(use)
			self.inPassword.setText(pas)
			defaul = {
			"host": host,
			"use": use,
			"pas": pas,
			"port": port
			}
			return defaul

	def laydanhsachtinh(self):
		self.inProvince.clear()
		selected_tinh = self.inProvince.currentText()
		tinhs = docdstinh()

		conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
		f = open(conf_dir, 'r')
		conf_code = f.read()

		if conf_code == "17":
			self.inProvince.addItems(['17 - Tỉnh Hoà Bình'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		if conf_code == "14":
			self.inProvince.addItems(['14 - Tỉnh Sơn La'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		elif conf_code == "40":
			self.inProvince.addItems(['40 - Tỉnh Nghệ An'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		elif conf_code == "38":
			self.inProvince.addItems(['38 - Tỉnh Thanh Hóa'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		elif conf_code == "49":
			self.inProvince.addItems(['49 - Tỉnh Quảng Nam'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		elif conf_code == "45":
			self.inProvince.addItems(['45 - Tỉnh Quảng Trị'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		elif conf_code == "10":
			self.inProvince.addItems(['10 - Tỉnh Lào Cai'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		elif conf_code == "37":
			self.inProvince.addItems(['37 - Tỉnh Ninh Bình'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		elif conf_code == "20":
			self.inProvince.addItems(['20 - Tỉnh Lạng Sơn'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

		else:
			self.inProvince.addItems(['-- Chọn tỉnh --'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.inProvince.addItems([tname])

	def laydanhsachhuyen(self):
		self.inDistrict.clear()
		tentinh = self.inProvince.currentText()
		matinh = tentinh.split(' - ')[0]
		if self.inProvince.currentIndex() == 0:
			_crs = "EPSG:3405"
		else:
			_crs = self.prj_crs(tentinh.split(' - ')[-1])
		self.outProjection.setCrs(QgsCoordinateReferenceSystem(_crs))
		listhuyen = docdshuyen()

		self.inDistrict.addItems(['-- Chọn huyện --'])
		for chon in listhuyen:
			if chon['MATINH'] == matinh:
				hname = chon['MAHUYEN'] + " - " + chon['HUYEN']
				self.inDistrict.addItems([hname])

	def laydanhsachxa(self):
		self.inCommune.clear()
		tenhuyen = self.inDistrict.currentText()
		mahuyen = tenhuyen.split(' - ')[0]
		listxa = docdsxa()

		self.inCommune.addItems(['-- Chọn xã --'])
		for xachon in listxa:
			if xachon['MAHUYEN'] == mahuyen:
				xname = xachon['MAXA'] + " - " + xachon['XA']
				self.inCommune.addItems([xname])

	def laymacode(self):
		selected_xa = self.inCommune.currentText()
		selected_huyen = self.inDistrict.currentText()
		selected_tinh = self.inProvince.currentText()

		if self.inCommune.currentIndex() > 0:
			code = selected_xa.split(" - ")[0]
			syn = 'commune_code = ' + code
			return syn

		elif self.inDistrict.currentIndex() > 0:
			code = selected_huyen.split(" - ")[0]
			syn = 'district_code = ' + code
			return syn

		else:
			code = selected_tinh.split(" - ")[0]
			syn = 'province_code = ' + code
			return syn

	def run(self):

		qgis.utils.iface.messageBar().clearWidgets()
		progressMessageBar = qgis.utils.iface.messageBar()
		progress = QProgressBar()
		progress.setMaximum(100)
		progressMessageBar.pushWidget(progress)

		inhost = self.set_defauled()["host"]
		inport = self.inPort.text()
		indatabase = "data_forest"
		inuser = self.inUsername.text()
		inpass = self.inPassword.text()
		fix_tempo = str(Path(__file__).parent.absolute()) + '/tempo/fixgeo.shp'
		deldup_tempo = str(Path(__file__).parent.absolute()) + '/tempo/deldup.shp'	 
		outpath = self.outPath.text()
		crs = self.outProjection.crs()
		_tinh = self.inProvince.currentText()
		if _tinh == "-- Chọn tỉnh --":
			self.iface.messageBar().pushMessage("Chưa chọn đơn vị hành chính", level=Qgis.Warning, duration=10)
		else:
			code = self.laymacode()		
			sql = query(code)
			bname = os.path.split(outpath)[1]
			fname = os.path.splitext(bname)[0]

			try:
				i=0
				for n in range (1, 11):
					if n == 1:
						uri = QgsDataSourceUri()
					elif n == 2:
						uri.setConnection(inhost, inport, indatabase, inuser, inpass)
					elif n == 3:
						uri.setDataSource("", u'(%s\n)' % sql, "geom", "", "tt")
					elif n == 4:
						vlayer = QgsVectorLayer(uri.uri(),fname,"postgres")
					elif n == 5:
						QgsVectorFileWriter.writeAsVectorFormat(vlayer, fix_tempo, "UTF-8", crs, "ESRI Shapefile")
					elif n == 6:
						fixgeometry(fix_tempo,deldup_tempo)
					elif n == 7:
						delete_duplicate(deldup_tempo,outpath)						
					elif n == 8:
						update_malr3(outpath)
					elif n == 9:
						update_MALDLR33(outpath)
					else:
						QgsProject.instance().removeAllMapLayers()
						self.outPath.setText('')
					i = i + 1

					percent = (i / float(10)) * 100
					progress.setValue(int(percent))
					time.sleep(1)
				qgis.utils.iface.messageBar().clearWidgets()

				self.iface.messageBar().pushMessage(
					"Quá trình tải bản đồ thành công và được lưu trong thư mục " + outpath, level=Qgis.Success, duration=10)
			except:
				QgsProject.instance().removeAllMapLayers()
				qgis.utils.iface.messageBar().clearWidgets()
				self.iface.messageBar().pushMessage("Quá trình tải bản đồ thất bại", level=Qgis.Critical, duration=10)

	def close_form(self):
		self.close()

class ChuanHoaDBR_Dlg(QDialog, Ui_Dialog_ChuanHoa):
	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.inputShapefile.setText('')
		self.btnInputShp.clicked.connect(self.select_input_shape)
		self.inputChurung.setText('')
		self.btnChurung.clicked.connect(self.select_input_xls)
		self.outputShapefile.setText('')											 
		self.btnOutput.clicked.connect(self.select_output_shape)
		self.buttonBox.accepted.connect(self.checkRun)

		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8
		
	def checkRun(self):
		if self.inputShapefile.text() != '' and self.inputChurung.text() != '' and self.outputShapefile.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn đủ dữ liệu", level=Qgis.Warning, duration=5)	

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ diễn biến rừng", conf_folder, "Shapefile (*.shp)")[0])
		self.inputShapefile.setText(self.path_solution)

		if self.path_solution != '':
			in_shp = self.path_solution
			driver = ogr.GetDriverByName("ESRI Shapefile")
			dataSource = driver.Open(in_shp, 0)
			layer = dataSource.GetLayer()
			file_kq = []
			field_chuan = ['compt_code','plot_code','village','area','forest_org','forest_typ']
			field_names = [field.name for field in layer.schema]
			field_lower = [name.lower() for name in field_names]
			for x in field_chuan:
				if(x not in field_lower):
					file_kq.append(x)
			
			if len(file_kq) > 0:
				self.iface.messageBar().pushMessage("Dữ liệu đầu vào không hợp lệ", level=Qgis.Warning, duration=5)
				self.buttonBox.setEnabled(False)
			else:
				self.buttonBox.setEnabled(True)

	def select_input_xls(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn danh sách chủ rừng", conf_folder, "MS - Excel (*.xlsx);;MS - Excel (*.xls)")[0])
		self.inputChurung.setText(self.path_solution)
		col_name = ['commune_code','actor_id','actor_type_code','actor_name']
		checkExcel(self,col_name)
		
	def select_output_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()
		self.path_solution = str(QFileDialog.getSaveFileName(self, "Q5PFES-Chọn thư mục lưu kết quả chuẩn hóa", conf_folder, "Shapefile (*.shp)")[0])
		self.outputShapefile.setText(self.path_solution)
		
	def run(self):
		try:
			#clear the message bar		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)

			inpath = self.inputShapefile.text()
			ref_tempo = str(Path(__file__).parent.absolute()) + '/tempo/ChuanHoa.shp'
			templatePath = str(Path(__file__).parent.absolute()) + '/data/Form_ChuanHoaDBR.shp'
			outpath = self.outputShapefile.text()
			inputChurung = self.inputChurung.text()
			bname = os.path.split(outpath)[1]
			fname = os.path.splitext(bname)[0]
			bpath = os.path.dirname(inpath)

			i=0
			for n in range(1,6):
				i=i+1
				if n ==1:
				#1
					delete_fields(inpath,ref_tempo)
					shp =  QgsVectorLayer(ref_tempo, fname, 'ogr')
					layer = QgsProject.instance().addMapLayer(shp)
				#2
				elif n==2:
					add_fields(layer)
				#3
				elif n==3:
					rename_fields(layer)
					QgsProject.instance().removeAllMapLayers()
				#4
				elif n==4:
					join_fields(ref_tempo,inputChurung)
					update_loaicay(ref_tempo)
					QgsProject.instance().removeAllMapLayers()
				else:	
					refactor(ref_tempo,templatePath,outpath)
					nshp =  QgsVectorLayer(outpath, fname, 'ogr')
					nlayer = QgsProject.instance().addMapLayer(nshp)

				percent = (i/float(5)) * 100
				progress.setValue(int(percent))				
				time.sleep(1)
			qgis.utils.iface.messageBar().clearWidgets()								
			self.iface.messageBar().pushMessage("Quá trình chuẩn hóa thành công!", level=Qgis.Success, duration=5)
		except:
			QgsProject.instance().removeAllMapLayers()
			qgis.utils.iface.messageBar().clearWidgets()
			self.iface.messageBar().pushMessage("Quá trình chuẩn hóa thất bại", level=Qgis.Critical, duration=5)

class ChuanHoaDBR2_Dlg(QDialog, Ui_Dialog_ChuanHoa2):
	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.inputShapefile.setText('')
		self.btnInputShp.clicked.connect(self.select_input_shape)
		self.outputShapefile.setText('')											 
		self.btnOutput.clicked.connect(self.select_output_shape)
		self.buttonBox.accepted.connect(self.checkRun)

		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8
		
	def checkRun(self):
		if self.inputShapefile.text() != ''  and self.outputShapefile.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn đủ dữ liệu", level=Qgis.Warning, duration=5)	

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ diễn biến rừng", conf_folder, "Shapefile (*.shp)")[0])
		self.inputShapefile.setText(self.path_solution)

		if self.path_solution != '':
			in_shp = self.path_solution
			driver = ogr.GetDriverByName("ESRI Shapefile")
			dataSource = driver.Open(in_shp, 0)
			layer = dataSource.GetLayer()
			file_kq = []
			field_chuan = ['commune_co','compt_code','plot_code','area','forest_org','forest_typ']
			field_names = [field.name for field in layer.schema]
			field_lower = [name.lower() for name in field_names]
			for x in field_chuan:
				if(x not in field_lower):
					file_kq.append(x)
			
			if len(file_kq) > 0:
				self.iface.messageBar().pushMessage("Dữ liệu đầu vào không hợp lệ", level=Qgis.Warning, duration=5)
				self.buttonBox.setEnabled(False)
			else:
				self.buttonBox.setEnabled(True)
		
	def select_output_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()
		self.path_solution = str(QFileDialog.getSaveFileName(self, "Q5PFES-Chọn thư mục lưu kết quả chuẩn hóa", conf_folder, "Shapefile (*.shp)")[0])
		self.outputShapefile.setText(self.path_solution)
		
	def run(self):
		#try:
		#clear the message bar		
		qgis.utils.iface.messageBar().clearWidgets() 
		#set a new message bar
		progressMessageBar = qgis.utils.iface.messageBar()
		######################################
		# Prepare your progress Bar
		######################################
		progress = QProgressBar()
		#Maximum is set to 100, making it easy to work with percentage of completion
		progress.setMaximum(100) 
		#pass the progress bar to the message Bar
		progressMessageBar.pushWidget(progress)

		inpath = self.inputShapefile.text()
		#ref_tempo = str(Path(__file__).parent.absolute()) + '/tempo/ChuanHoa.shp'
		templatePath = str(Path(__file__).parent.absolute()) + '/data/Form_ChuanHoaDBR.shp'
		outpath = self.outputShapefile.text()
		bname = os.path.split(outpath)[1]
		fname = os.path.splitext(bname)[0]
		bpath = os.path.dirname(inpath)

		i=0
		for n in range(1,6):
			i=i+1
			if n ==1:
			#1
				shp =  QgsVectorLayer(inpath, fname, 'ogr')
				layer = QgsProject.instance().addMapLayer(shp)
				add_fields2(layer)
			#2
			elif n==2:
				rename_fields2(layer)
				QgsProject.instance().removeAllMapLayers()
			#3
			elif n==3:
				join_fields2(inpath)
			#4
			elif n==4:
				update_loaicay(inpath)
				QgsProject.instance().removeAllMapLayers()
			else:	
				refactor(inpath,templatePath,outpath)
				nshp =  QgsVectorLayer(outpath, fname, 'ogr')
				nlayer = QgsProject.instance().addMapLayer(nshp)

			percent = (i/float(5)) * 100
			progress.setValue(int(percent))				
			time.sleep(1)
		qgis.utils.iface.messageBar().clearWidgets()								
		self.iface.messageBar().pushMessage("Quá trình chuẩn hóa thành công!", level=Qgis.Success, duration=5)
		#except:
			#QgsProject.instance().removeAllMapLayers()
			#qgis.utils.iface.messageBar().clearWidgets()
			#self.iface.messageBar().pushMessage("Quá trình chuẩn hóa thất bại", level=Qgis.Critical, duration=5)

class CheckError_Dlg (QDialog, Ui_Dialog_CheckError):
	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.inPath.setText('')
		self.inBtn.clicked.connect(self.select_input_shape)
		self.buttonBox.accepted.connect(self.checkRun)	
		
		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8
		
	def checkRun(self):
		if self.inPath.text() != '' :
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn lớp đầu vào", level=Qgis.Warning, duration=5)	

	def select_input_shape(self):	
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()  
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ hiện trạng rừng", conf_folder, "Shapefile (*.shp)")[0])
		self.inPath.setText(self.path_solution)
		attr_name = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','dtich','nggocr','maldlr','ldlr','sldlr','malr3','dtuong','machur','churung','nqh']
		checkInput(self, attr_name)

	def run(self):
		try:
			#clear the message bar		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)
			
			check_tempo = str(Path(__file__).parent.absolute()) + '/tempo/check.shp'
			err_tempo = str(Path(__file__).parent.absolute()) + '/tempo/loi.xlsx'
			inpath = self.inPath.text()
			outpath = str(Path(__file__).parent.absolute()) + '/tempo/loi.xlsx'
			bpath = os.path.dirname(inpath)
			copy = str(Path(__file__).parent.absolute()) + '/data/BieuTongHopLoi.xlsm'
			paste = str(Path(__file__).parent.absolute()) + '/tempo/BieuTongHopLoi.xlsm'
			run = 'start excel.exe '

			i=0
			for n in range(1,5):
				i=i+1
				if n ==1:
					shp =  QgsVectorLayer(inpath, '', 'ogr')
					layer = QgsProject.instance().addMapLayer(shp)
					QgsVectorFileWriter.writeAsVectorFormat(layer, check_tempo, "UTF-8", layer.crs(), "ESRI Shapefile")
					QgsProject.instance().removeAllMapLayers()
				elif n==2:		   					
					nshp =  QgsVectorLayer(check_tempo, '', 'ogr')
					nlayer = QgsProject.instance().addMapLayer(nshp)
					nlayer.isValid()
					nlayer_provider = nlayer.dataProvider()
					nlayer_provider.addAttributes([QgsField("loi", QVariant.String,'',200)])
					nlayer.updateFields()				
				elif n==3:								
					check_maldlr_nggocr_33(nlayer)
					check_maldlr_ldlr_33(nlayer)
					check_nggocr_sldlr(nlayer)
					check_3lr_nqh(nlayer)					
					x = 1
					err = []
					for feature in nlayer.getFeatures():
						if feature['loi'] != NULL :
							err.append(x)
					QgsProject.instance().removeAllMapLayers()
				else:
					mshp =  QgsVectorLayer(check_tempo, '', 'ogr')
					mlayer = QgsProject.instance().addMapLayer(mshp)
					QgsVectorFileWriter.writeAsVectorFormat(mlayer, err_tempo, "UTF-8", mlayer.crs(), "xlsx") 
					QgsProject.instance().removeAllMapLayers()
					Error_Export (err_tempo,outpath)				
					shutil.copy2(copy, paste)						

				percent = (i/float(4)) * 100
				progress.setValue(int(percent))				
				time.sleep(1) 
			qgis.utils.iface.messageBar().clearWidgets()
			if len(err) > 0:
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Đã phát hiện " + str(len(err)) + " lô rừng có lỗi thông tin thuộc tính", level=Qgis.Warning, duration=10)
				time.sleep(5)
				os.system(run + paste)
			else:
				self.iface.messageBar().pushMessage("Không phát hiện lỗi thông tin thuộc tính", level=Qgis.Success, duration=10)
		except:
			qgis.utils.iface.messageBar().clearWidgets()
			QgsProject.instance().removeAllMapLayers()
			self.iface.messageBar().pushMessage("Vui lòng tắt hết các file excel đang mở", level=Qgis.Warning, duration=5)

class XayDungCTDL_Dlg(QDialog, Ui_Dialog_XayDungCTDL):
	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.lineEdit.setText('')
		self.pushButton.clicked.connect(self.select_input_shape)
		self.lineEdit_2.setText('')
		self.pushButton_2.clicked.connect(self.select_input_xls)
		self.lineEdit_3.setText('')											 
		self.pushButton_3.clicked.connect(self.select_output_shape)
		self.checkBox.setChecked(False)
		self.checkBox.stateChanged.connect(self.checkbox)
		self.buttonBox.accepted.connect(self.checkRun)	
		
		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8
		
	def checkRun(self):
		if self.checkBox.isChecked():
			if self.lineEdit_2.text() != '':
				self.run()
			else:
				self.iface.messageBar().pushMessage("Chưa chọn danh sách lưu vực", level=Qgis.Warning, duration=5)
		else:
			if self.lineEdit.text() != '' and self.lineEdit_2.text() != '' and self.lineEdit_3.text() != '':
				self.run()
			else:
				self.iface.messageBar().pushMessage("Chưa chọn đủ dữ liệu", level=Qgis.Warning, duration=5)

	def checkbox(self):
		if self.checkBox.isChecked():
			self.pushButton.setEnabled(False)
			self.lineEdit.setEnabled(False)
			self.pushButton_3.setEnabled(False)
			self.lineEdit_3.setEnabled(False)
		else:
			self.pushButton.setEnabled(True)
			self.lineEdit.setEnabled(True)
			self.pushButton_3.setEnabled(True)
			self.lineEdit_3.setEnabled(True)	

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()  	  
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ hiện trạng rừng", conf_folder, "Shapefile (*.shp)")[0])
		self.lineEdit.setText(self.path_solution)
		attr_name = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','dtich','nggocr','maldlr','ldlr','sldlr','malr3','dtuong','machur','churung']
		checkInput(self, attr_name)

	def select_input_xls(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn danh sách lưu vực", conf_folder, "MS - Excel (*.xlsx);;MS - Excel (*.xls)")[0])
		self.lineEdit_2.setText(self.path_solution)
		col_name = ['id','malv','tenlv']
		checkExcel(self,col_name)
		
	def select_output_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 
		self.path_solution = str(QFileDialog.getSaveFileName(self, "Q5PFES-Chọn thư mục chứa lớp bản đồ đầu ra", conf_folder, "Shapefile (*.shp)")[0])
		self.lineEdit_3.setText(self.path_solution)	

	def run(self):
		try:
			#clear the message bar		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)

			conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
			f = open(conf_dir, 'r')
			conf_code = f.read()
			
			tempo = str(Path(__file__).parent.absolute()) + '/tempo/tempo.shp'
			js_dir = str(Path(__file__).parent.absolute()) + '/data/dsluuvuc.json'  
			inpath = self.lineEdit.text()
			outpath = self.lineEdit_3.text()
			inputLuuvuc = self.lineEdit_2.text()
			bname = os.path.split(outpath)[1]
			fname = os.path.splitext(bname)[0]
			bpath = os.path.dirname(inpath)

			i=0
			for n in range(1,4):
				i=i+1
				if n ==1:
					if self.checkBox.isChecked():
						pass
					else:		   
						shp =  QgsVectorLayer(inpath, '', 'ogr')
						layer = QgsProject.instance().addMapLayer(shp)
						QgsVectorFileWriter.writeAsVectorFormat(layer, tempo, "UTF-8", layer.crs(), "ESRI Shapefile")
						QgsProject.instance().removeAllMapLayers()
				elif n ==2:
					if self.checkBox.isChecked():
						pass
					else:
						nshp =  QgsVectorLayer(tempo, '', 'ogr')
						nlayer = QgsProject.instance().addMapLayer(nshp)
						if conf_code == '38':
							add_newfields_TH(nlayer, outpath)
						elif conf_code == '40':
							add_newfields_NA(nlayer, outpath)
						elif conf_code == '14':
							add_newfields_SL(nlayer, outpath)
						else:
							add_newfields(nlayer, outpath)
				else:
					if self.checkBox.isChecked():
						convert_json(inputLuuvuc,js_dir)
					else:
						convert_json(inputLuuvuc,js_dir)	 
						QgsProject.instance().removeAllMapLayers()
						shp =  QgsVectorLayer(outpath, fname, 'ogr')
						layer = QgsProject.instance().addMapLayer(shp)
				percent = (i/float(3)) * 100
				progress.setValue(int(percent))				
				time.sleep(1) 
			qgis.utils.iface.messageBar().clearWidgets()
			if self.checkBox.isChecked():
				self.iface.messageBar().pushMessage("Quá trình xây dựng danh sách lưu vực thành công", level=Qgis.Success, duration=5)
			else:
				self.iface.messageBar().pushMessage("Quá trình xây dựng cấu trúc dữ liệu thành công", level=Qgis.Success, duration=5)
		except:
			qgis.utils.iface.messageBar().clearWidgets()
			QgsProject.instance().removeAllMapLayers()
			self.iface.messageBar().pushMessage("Error","Quá trình xây dựng cấu trúc dữ liệu thất bại", level=Qgis.Critical, duration=5)

class CapNhatVCT_Dlg(QDialog, Ui_Dialog_CapNhatVCT):

	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.lineEdit.setText('')
		self.pushButton.clicked.connect(self.select_input_shape)
		self.lineEdit_2.setText('')
		self.pushButton_2.clicked.connect(self.select_input_luuvuc)
		self.lineEdit_4.setText('')											 
		self.pushButton_3.clicked.connect(self.select_output_shape)
		self.buttonBox.accepted.connect(self.checkRun)
		self.laydsluuvuc()

		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8
		
	def checkRun(self):
		if self.lineEdit.text() != '' and self.lineEdit_2.text() != '' and self.lineEdit_4.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn đủ dữ liệu", level=Qgis.Warning, duration=5)

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 	  
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ đầu vào", conf_folder, "Shapefile (*.shp)")[0])
		self.lineEdit.setText(self.path_solution)
		attr_name = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','dtich','nggocr','maldlr','ldlr','sldlr','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','khuvuc','dtichct']
		checkInput(self, attr_name)

	def laydsluuvuc(self):
		try:
			self.comboBox.clear()
			watershed = docdsluuvuc()
			for catchment in watershed:
				cname = catchment['tenlv']
				ccode = catchment['malv']
				self.comboBox.addItems([cname])
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng cấu trúc dữ liệu", level=Qgis.Warning, duration=5)		  

	def select_input_luuvuc(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp ranh giới lưu vực", conf_folder, "Shapefile (*.shp)")[0])
		self.lineEdit_2.setText(self.path_solution)

		err =0
		if self.path_solution != '':
			inputLV = self.lineEdit_2.text()
			driver = ogr.GetDriverByName("ESRI Shapefile")
			dataSource = driver.Open(inputLV, 0)
			layer = dataSource.GetLayer()
			count_row = layer.GetFeatureCount()
			if count_row > 10:
				err +=1
			if err > 0:
				self.iface.messageBar().pushMessage("Dữ liệu đầu vào không hợp lệ", level=Qgis.Warning, duration=5)
				self.buttonBox.setEnabled(False)
			else:
				self.buttonBox.setEnabled(True)

	def select_output_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 
		self.path_solution = str(QFileDialog.getSaveFileName(self, "Q5PFES-Chọn thư mục chứa lớp bản đồ đầu ra", conf_folder, "Shapefile (*.shp)")[0])
		self.lineEdit_4.setText(self.path_solution)

	def run(self):
		try:
			threadcount = QThread.idealThreadCount()
			QgsApplication.setMaxThreads(threadcount)
			QSettings().setValue("/qgis/parallel_rendering", True)
			QSettings().setValue("/core/OpenClEnabled", True)

			#clear the message bar		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)
			
			fixInput_tempo = str(Path(__file__).parent.absolute()) + '/tempo/fixInput.shp'
			fixLV_tempo = str(Path(__file__).parent.absolute()) + '/tempo/fixLV.shp'
			disagg_tempo = str(Path(__file__).parent.absolute()) + '/tempo/disagg.shp'
			clip_tempo = str(Path(__file__).parent.absolute()) + '/tempo/clip.shp'
			difference_tempo = str(Path(__file__).parent.absolute()) + '/tempo/differ.shp'
			updatePZ_tempo = str(Path(__file__).parent.absolute()) + '/tempo/updatePZ.shp'
			merge_tempo = str(Path(__file__).parent.absolute()) + '/tempo/merge.shp'

			
			inpath = self.lineEdit.text()
			outpath = self.lineEdit_4.text()
			inMerge = [updatePZ_tempo,difference_tempo]
			inputLuuvuc = self.lineEdit_2.text()
			mlv = laymalv(self.comboBox.currentText())
			bname = os.path.split(outpath)[1]
			fname = os.path.splitext(bname)[0]
			bpath = os.path.dirname(inpath)
				
			k=6
			i=0
			for n in range(1,k):
				i=i+1
				if n == 1:
					fixgeometry(inpath, fixInput_tempo)
					fixgeometry(inputLuuvuc, fixLV_tempo)
					disaggregate(fixInput_tempo,disagg_tempo)					
				elif n == 2:
					clip(disagg_tempo, fixLV_tempo, clip_tempo)					
				elif n == 3:
					difference(disagg_tempo, fixLV_tempo, difference_tempo)
				elif n == 4:
					updatePaymentZone (clip_tempo, mlv, updatePZ_tempo)
				else:
					mergeLayers (inMerge, merge_tempo)
					del_MergeFields (merge_tempo, outpath)
					QgsProject.instance().removeAllMapLayers()
					shp = QgsVectorLayer(outpath, fname, 'ogr')
					layer = QgsProject.instance().addMapLayer(shp)

				percent = (i/float(k-1)) * 100
				progress.setValue(int(percent))				
				time.sleep(1) 
					
			qgis.utils.iface.messageBar().clearWidgets()
			self.iface.messageBar().pushMessage("Quá trình cập nhật vùng chi trả thành công", level=Qgis.Success, duration=5)
		except:
			qgis.utils.iface.messageBar().clearWidgets()
			QgsProject.instance().removeAllMapLayers()
			self.iface.messageBar().pushMessage("Error","Quá trình cập nhật vùng chi trả thất bại", level=Qgis.Critical, duration=5)

class CapNhatDG_Dlg(QDialog, Ui_Dialog_CapNhatDG):
	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.inputShapefile.setText('')
		self.btnInputShp.clicked.connect(self.select_input_shape)
		self.spBx_Price.setSingleStep(1000)
		self.spBx_Price.setMaximum(10000000)
		self.dg_cBx.setChecked(True)
		self.xdmct_cBx.setChecked(True)
		self.dg_cBx.stateChanged.connect(self.checkbox)											 
		self.btnPrice.clicked.connect(self.calculate_price)
		self.btnPrice.setEnabled(False)
		self.btnUpdate.clicked.connect(self.update_price)
		self.buttonBox.accepted.connect(self.checkRun)
		self.comboBox.currentIndexChanged.connect(self.laydongia)
		self.comboBox.currentIndexChanged.connect(self.layTien)
		self.laydsluuvuc()
		self.laydongia()
		self.layTien()

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 	 
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ diễn biến rừng", conf_folder, "Shapefile (*.shp)")[0])
		self.inputShapefile.setText(self.path_solution)
		attr_name = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','dtich','nggocr','maldlr','ldlr','sldlr','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','khuvuc','dtichct','dgia','thanhtien','mucct']
		checkInput(self,attr_name)

		if self.buttonBox.isEnabled ():
			self.btnPrice.setEnabled(True)
		else:		
			self.btnPrice.setEnabled(False)

	def checkbox(self):
		if self.dg_cBx.isChecked():
			self.xdmct_cBx.setEnabled(True)
		else:
			self.xdmct_cBx.setEnabled(False)
			self.xdmct_cBx.setChecked(False)

	def checkRun(self):
		if self.inputShapefile.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn đủ dữ liệu", level=Qgis.Warning, duration=5)

	def laydsluuvuc(self):
		try:
			self.comboBox.clear()
			watershed = docdsluuvuc()
			for catchment in watershed:
				cname = catchment['tenlv']
				self.comboBox.addItems([cname])
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng cấu trúc dữ liệu", level=Qgis.Warning, duration=5)

	def laydongia(self):
		try:
			watershed = docdsluuvuc()
			wsName = self.comboBox.currentText()
			for catchment in watershed:
				if catchment['tenlv'] == wsName:
					dgia = catchment['dgia']
					self.spBx_Price.setValue(dgia)
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng cấu trúc dữ liệu", level=Qgis.Warning, duration=5)

	def layTien(self):
		try:
			watershed = docdsluuvuc()
			wsName = self.comboBox.currentText()
			for catchment in watershed:
				if catchment['tenlv'] == wsName:
					tien = str(catchment['tongsotien']).split('.')[0]
					self.InMoney.setText(tien)
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng cấu trúc dữ liệu", level=Qgis.Warning, duration=5)

	def calculate_price(self):
		try:
			inpath = self.inputShapefile.text()
			money = long(self.InMoney.text())
			mlv = laymalv(self.comboBox.currentText())		
			bpath = os.path.dirname(inpath)

			layer = QgsVectorLayer(inpath, '', 'ogr')
			QgsProject.instance().addMapLayer(layer)
			exp= 'dtichct>0'
			processing.run("qgis:selectbyattribute", {"FIELD":'maluuvuc', "INPUT":layer, "METHOD": 0,"OPERATOR": 7,"VALUE":mlv})
			processing.run("qgis:selectbyexpression", {"EXPRESSION":exp, "INPUT":layer, "METHOD": 3})

			fArea = []
			for feat in layer.getSelectedFeatures():
				fArea.append(float(feat['dtichct']))
			
			total = sum(fArea)
			p = money/total
			self.spBx_Price.setValue(p)
			QgsProject.instance().removeAllMapLayers()
		except:
			qgis.utils.iface.messageBar().clearWidgets()
			QgsProject.instance().removeAllMapLayers()
			self.iface.messageBar().pushMessage("Chưa cập nhật vùng chi trả cho lưu vực này", level=Qgis.Warning, duration=5)

	def update_price(self):
		mlv = laymalv(self.comboBox.currentText())
		price = self.spBx_Price.value()
		edit_price(mlv,price)

	def run(self):
		try:
			#clear the message bar		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)

			inpath = self.inputShapefile.text()
			bpath = os.path.dirname(inpath)
			bname = os.path.split(inpath)[1]
			fname = os.path.splitext(bname)[0]

			i=0
			for n in range(1,3):
				i=i+1
				if n ==1:
					if self.dg_cBx.isChecked():
						price(inpath)				
					else:
						pass
				else:
					if self.xdmct_cBx.isChecked():
						payment_level(inpath)				
					else:
						pass

					QgsProject.instance().removeAllMapLayers()		
					shp =  QgsVectorLayer(inpath, fname, 'ogr')
					layer = QgsProject.instance().addMapLayer(shp)

				percent = (i/float(2)) * 100
				progress.setValue(int(percent))				
				time.sleep(1) 
			qgis.utils.iface.messageBar().clearWidgets()					  
			self.iface.messageBar().pushMessage("Quá trình tính đơn giá chi trả thành công", level=Qgis.Success, duration=5)
		except:
			self.iface.messageBar().pushMessage("Error","Quá trình tính đơn giá chi trả thất bại", level=Qgis.Critical, duration=5)

class CapNhatDTCT_Dlg(QDialog, Ui_Dialog_CapNhatDTCT):

	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.inPath.setText('')
		self.inBtn.clicked.connect(self.select_input_shape)
		self.rtn_checkbox.setChecked(True)
		self.rtg_checkbox.setChecked(True)
		self.rttn_checkbox.setChecked(True)
		self.rtk_checkbox.setChecked(False)
		self.ctr_checkbox.setChecked(False)
		self.lc_checkbox.setEnabled(False)
		self.lc_checkbox.setChecked(False)
		self.lc_checkbox.stateChanged.connect(self.select_treespecies)
		self.xkk_cBx.setEnabled(False)
		self.xkk_cBx.setChecked(False)
		self.xkk_cBx.stateChanged.connect(self.edit_remoteArea)
		self.s1_rBtn.setChecked(True)
		self.outPath.setText('')											 
		self.outBtn.clicked.connect(self.select_output_shape)
		self.buttonBox.accepted.connect(self.checkRun)

		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8
		
	def checkRun(self):
		if self.inPath.text() != '' and self.outPath.text()!= '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn đủ dữ liệu", level=Qgis.Warning, duration=5)

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 	  
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ đầu vào", conf_folder, "Shapefile (*.shp)")[0])
		self.inPath.setText(self.path_solution)
		attr_name = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','dtich','nggocr','maldlr','ldlr','sldlr','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','khuvuc','dtichct','dt2']
		checkInput(self,attr_name)
		
		if self.buttonBox.isEnabled ():
			self.lc_checkbox.setEnabled(True)
			self.xkk_cBx.setEnabled(True)
			self.buttonBox.setEnabled(True)
		else:
			self.iface.messageBar().pushMessage("Dữ liệu đầu vào không hợp lệ", level=Qgis.Warning, duration=5)			
			self.lc_checkbox.setEnabled(False)
			self.xkk_cBx.setEnabled(False)
			self.lc_checkbox.setChecked(False)
			self.xkk_cBx.setChecked(False)
			self.buttonBox.setEnabled(False)
			for i in reversed (range (self.tableWidget.rowCount())):
				self.tableWidget.removeRow(i)
			for i in reversed (range (self.tableWidget_2.rowCount())):
				self.tableWidget_2.removeRow(i)		

	def select_treespecies(self):
		try:
			if self.lc_checkbox.isChecked():
				self.tableWidget.clear()

				in_shp = str(self.inPath.text())
				driver = ogr.GetDriverByName("ESRI Shapefile")
				dataSource = driver.Open(in_shp, 1)
				layer = dataSource.GetLayer()

				listlc = []
				for feature in layer:
					if feature['vungchitra'] == 1:
						listlc.append(feature['sldlr'])
				unique_lc = list(set(listlc))
				lc = list(filter(None,unique_lc))
			
				self.tableWidget.setRowCount(len(lc))
				self.tableWidget.setColumnCount(2)
				self.tableWidget.setHorizontalHeaderLabels(["Tên loài cây", "Chitrả"])
				self.tableWidget.setEditTriggers(QtWidgets.QTableWidget.EditTriggers(2))

				for i in range (self.tableWidget.rowCount()):
					self.tableWidget.setItem(i,0,QTableWidgetItem(lc[i]))
					self.tableWidget.setItem(i,1,QTableWidgetItem("1"))
			else:
				for i in reversed (range (self.tableWidget.rowCount())):
					self.tableWidget.removeRow(i)
		except:
			self.iface.messageBar().pushMessage("Chưa cập nhật vùng chi trả", level=Qgis.Warning, duration=5)

	def edit_remoteArea(self):
		try:
			if self.xkk_cBx.isChecked():
				self.tableWidget_2.clear()
				xakhokhan = docdsxkk()
				in_shp = str(self.inPath.text())
				driver = ogr.GetDriverByName("ESRI Shapefile")
				dataSource = driver.Open(in_shp, 1)
				layer = dataSource.GetLayer()

				vct = []
				for feature in layer:
					if feature['vungchitra'] == 1:
						vct.append(feature['maxa'])
				listvct = list(set(vct))

				listmaxa = []
				listxa = []
				listkhuvuc = []

				for feature in xakhokhan:
					giatri = int(feature['MAXA'])
					if giatri in listvct:
						listmaxa.append(feature['MAXA'])
						listxa.append(feature['XA'])
						listkhuvuc.append(feature['KHUVUC'])

				self.tableWidget_2.setRowCount(len(listmaxa))
				self.tableWidget_2.setColumnCount(3)
				self.tableWidget_2.setHorizontalHeaderLabels(["Mã xã", "Tên xã", "Khu vực"])
				self.tableWidget_2.setEditTriggers(QtWidgets.QTableWidget.EditTriggers(2))

				for i in range (self.tableWidget_2.rowCount()):
					self.tableWidget_2.setItem(i,0,QTableWidgetItem(listmaxa[i]))
					self.tableWidget_2.setItem(i,1,QTableWidgetItem(listxa[i]))
					self.tableWidget_2.setItem(i,2,QTableWidgetItem(listkhuvuc[i]))
			else:
				for i in reversed (range (self.tableWidget_2.rowCount())):
						self.tableWidget_2.removeRow(i)
		except:
			self.iface.messageBar().pushMessage("Chưa cập nhật vùng chi trả", level=Qgis.Warning, duration=5)
  
	def select_output_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 
		self.path_solution = str(QFileDialog.getSaveFileName(self, "Q5PFES-Chọn thư mục chứa lớp bản đồ đầu ra", conf_folder, "Shapefile (*.shp)")[0])
		self.outPath.setText(self.path_solution)

	def run(self):
		try:
			#clear the message bar		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)
			
			recal_tempo = str(Path(__file__).parent.absolute()) + '/tempo/area.shp'
			inpath = self.inPath.text()
			outpath = self.outPath.text()
			bname = os.path.split(outpath)[1]
			fname = os.path.splitext(bname)[0]
			bpath = os.path.dirname(inpath)

			ds_loaicay_kct = ['0']
			for i in range (self.tableWidget.rowCount()):
				chitra = self.tableWidget.item(i,1).text()
				if chitra != "1":
					ds_loaicay_kct.append(self.tableWidget.item(i,0).text())

			ds_khuvuc = []
			ds_maxa = []
			for i in range (self.tableWidget_2.rowCount()):
				xkk= self.tableWidget_2.item(i,2).text()
				lmx = self.tableWidget_2.item(i,0).text()
				ds_khuvuc.append(xkk)
				ds_maxa.append(lmx)	   
			
			i=0
			for n in range(1,11):
				i=i+1
				if n ==1:
					shp =  QgsVectorLayer(inpath, '', 'ogr')
					layer = QgsProject.instance().addMapLayer(shp)
					if self.s1_rBtn.isChecked():
						recalculate_area_1(layer, recal_tempo)
					else:
						recalculate_area_2(layer, recal_tempo)

				elif n==2:
					nshp =  QgsVectorLayer(recal_tempo, '', 'ogr')
					nlayer = QgsProject.instance().addMapLayer(nshp)	
					if self.rtn_checkbox.isChecked():
						rtn_payment(nlayer)					
					else:
						pass
				elif n==3:
					if self.rtg_checkbox.isChecked():
						rtg_payment33(nlayer) 
					else:
						pass						
				elif n==4:
					if self.rttn_checkbox.isChecked():
						rttn_payment33(nlayer) 
					else:
						pass	
				elif n==5:
					if self.rtk_checkbox.isChecked():
						rtk_payment33(nlayer) 
					else:
						pass
				elif n==6:
					if self.ctr_checkbox.isChecked():
						ctr_payment33(nlayer) 
					else:
						pass
				elif n==7:
					if self.lc_checkbox.isChecked():
						lc_payment(nlayer,ds_loaicay_kct,outpath)
					else:
						lc__non_payment(nlayer,outpath)
					QgsProject.instance().removeAllMapLayers()						
				elif n==8:
					if self.xkk_cBx.isChecked():		 
						mshp =  QgsVectorLayer(outpath, '', 'ogr')
						mlayer = QgsProject.instance().addMapLayer(mshp)
						update_xkk(mlayer,ds_maxa,ds_khuvuc)
						edit_dsxkk(ds_maxa,ds_khuvuc)
					else:
						join_xkk(outpath)
					QgsProject.instance().removeAllMapLayers()
				elif n==9:
					if self.k1_cBx.isChecked():
						update_K1_33(outpath)
					else:
						update_K1_uncheck(outpath)

					if self.k2_cBx.isChecked():
						update_K2(outpath)
					else:
						update_K2_uncheck(outpath)

					if self.k3_cBx.isChecked():
						update_K3(outpath)
					else:
						update_K3_uncheck(outpath)

					if self.k4_cBx.isChecked():
						update_K4(outpath)
					else:
						update_K4_uncheck(outpath)						
					update_K0(outpath)				
				else:
					payment_area(outpath)		
									 
					QgsProject.instance().removeAllMapLayers()		
					shp =  QgsVectorLayer(outpath, fname, 'ogr')
					layer = QgsProject.instance().addMapLayer(shp)
				percent = (i/float(10)) * 100
				progress.setValue(int(percent))				
				time.sleep(1) 
			qgis.utils.iface.messageBar().clearWidgets()					  
			self.iface.messageBar().pushMessage("Quá trình cập nhật dữ liệu chi trả thành công", level=Qgis.Success, duration=5)
		except:
			QgsProject.instance().removeAllMapLayers()
			qgis.utils.iface.messageBar().clearWidgets()
			self.iface.messageBar().pushMessage("Error","Quá trình cập nhật dữ liệu chi trả thất bại", level=Qgis.Critical, duration=5)

class XayDungCSDL_Dlg(QDialog, Ui_Dialog_XayDungCSDL):

	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.lineEdit.setText('')
		self.InButton.clicked.connect(self.select_input_shape)
		self.buttonBox.accepted.connect(self.checkRun)
		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8	

	def checkRun(self):
		if self.lineEdit.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn dữ liệu đầu vào", level=Qgis.Warning, duration=5)

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 	  
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ đầu vào", conf_folder, "Shapefile (*.shp)")[0])
		self.lineEdit.setText(self.path_solution)

		config_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
		f1 = open(config_dir, 'r')
		conf_code = f1.read()

		attr_name = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','ddanh','dtich','nggocr','maldlr','ldlr','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','dtichct']
		attr_name_HB = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','ddanh','dtich','nggocr','maldlr','ldlr','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','dtichct','dgia','thanhtien']
		attr_name_TH = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','ddanh','dtich','nggocr','maldlr','ldlr','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','dtichct','dtichgk','dgia','thanhtien','cmt','nguq','ngaycap']
		attr_name_SL = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','ddanh','dtich','nggocr','maldlr','ldlr','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','dtichct','nqh','dgia','thanhtien','cmt','gcn']
		attr_name_NA = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','ddanh','dtich','nggocr','maldlr','ldlr','thanhrung','nqh','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','dtichct','cql','dtuongnk']		
		if conf_code == '17':
			checkInput(self,attr_name_HB)
		elif conf_code == '37':
			checkInput(self,attr_name_HB)
		elif conf_code == '20':
			checkInput(self,attr_name_HB)
		elif conf_code == '14':
			checkInput(self,attr_name_SL)
		elif conf_code == '38':
			checkInput(self,attr_name_TH)
		elif conf_code == '40':
			checkInput(self,attr_name_NA)
		else:
			checkInput(self,attr_name)

	def run(self):
		try:
			#clear the message bar		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)

			conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
			f = open(conf_dir, 'r')
			conf_code = f.read()
	  
			tempo = str(Path(__file__).parent.absolute()) + '/tempo/tempo.xlsx'
			tempo_THX = str(Path(__file__).parent.absolute()) + '/tempo/THX.json'
			tempo_ChuRung = str(Path(__file__).parent.absolute()) + '/tempo/ChuRung.json'
			inpath = self.lineEdit.text()

			i=0
			for n in range(1,4):
				i=i+1
				if n==1:
					export_Attribute(inpath,tempo)
				elif n==2:
					export_THX(tempo,tempo_THX)
				else:
					export_ChuRung(tempo,tempo_ChuRung)								 					

				percent = (i/float(3)) * 100
				progress.setValue(int(percent))				
				time.sleep(1) 
			qgis.utils.iface.messageBar().clearWidgets()
			QgsProject.instance().removeAllMapLayers()					  
			self.iface.messageBar().pushMessage("Quá trình xây dựng cơ sở dữ liệu thành công", level=Qgis.Success, duration=5)
		except:
			QgsProject.instance().removeAllMapLayers()
			qgis.utils.iface.messageBar().clearWidgets()
			self.iface.messageBar().pushMessage("Error","Quá trình xây dựng cơ sở dữ liệu thất bại", level=Qgis.Critical, duration=5)

class XuatBieuNhom1_Dlg(QDialog, Ui_Dialog_XuatBieuNhom1):
	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.output_path.setText('')
		self.toolButton.clicked.connect(self.select_output)
		self.btn_OK.clicked.connect(self.checkRun)
		self.btn_cancel.clicked.connect(self.close_form)
		self.laydstinh()
		self.laydshuyen()
		self.laydsxa()
		self.laydsthonban()		
		self.com_tinh.currentIndexChanged.connect(self.laydshuyen)
		self.com_huyen.currentIndexChanged.connect(self.laydsxa)
		self.combo_xa.currentIndexChanged.connect(self.laydsthonban)
		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8

		conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
		f = open(conf_dir, 'r')
		conf_code = f.read()

		if conf_code == '0' or conf_code == '49' or conf_code == '14' or conf_code == '38' or conf_code == '10'or conf_code == '37' or conf_code == '20':
			self.combo_thonban.setEnabled(False)
			self.combo_thonban.clear()
			self.combo_thonban.setVisible(False)
			self.label_4.setVisible(False)

		if conf_code == '40' or conf_code == '45':
			self.combo_xa.setEnabled(False)
			self.combo_thonban.setEnabled(False)
			self.combo_thonban.clear()
			self.combo_xa.setVisible(False)
			self.combo_thonban.setVisible(False)
			self.label_4.setVisible(False)
			self.label_3.setVisible(False)

	def checkRun(self):
		if self.output_path.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn thư mục lưu file kết quả", level=Qgis.Warning, duration=5)			

	def laydstinh(self):
		try:
			self.com_tinh.clear()
			dstinh = docdshanhchinh()
			for item in dstinh:
				tname = item['tinh']
			self.com_tinh.addItems([tname])
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng CSDL", level=Qgis.Warning, duration=5)

	def laydshuyen(self):
		try:
			self.com_huyen.clear()
			dshuyen = docdshanhchinh()
			tentinh = self.com_tinh.currentText()	
			listhuyen = []	
			for item in dshuyen:
				if item['tinh'] == tentinh:
					hname = item['huyen']
					if hname in listhuyen:
						pass
					else:
						listhuyen.append(hname)
			self.com_huyen.addItems(listhuyen)
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng CSDL", level=Qgis.Warning, duration=5)

	def laydsxa(self):
		try:
			self.combo_xa.clear()
			dsxa = docdshanhchinh()
			tenhuyen = self.com_huyen.currentText()
			listxa = []
			for item in dsxa:
				if item['huyen'] == tenhuyen:
					xname = item['xa']
					if xname in listxa:
						pass
					else:
						listxa.append(xname)
			self.combo_xa.addItems(listxa)
		except:
			pass

	def laydsthonban(self):
		try:
			dsthonban = docdshanhchinh()
			tenxa = self.combo_xa.currentText()
			self.combo_thonban.clear()
			self.combo_thonban.addItems(['UBND xã'])
			for item in dsthonban:
				if item['xa'] == tenxa:
					tbname = item['ddanh']
					self.combo_thonban.addItems([tbname])
		except:
			pass

	def laymaxa(self):
		try:
			tenxa = self.combo_xa.currentText()
			dsxa = docdshanhchinh()
			for xa in dsxa:
				if xa['xa'] == tenxa:
					maxa = xa['maxa']
					value = {'maxa': maxa}
					return value
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng CSDL", level=Qgis.Warning, duration=5)

	def laymahuyen(self):
		tenhuyen = self.com_huyen.currentText()
		dshuyen = docdshanhchinh()
		for huyen in dshuyen:
			if huyen['huyen'] == tenhuyen:
				mahuyen = huyen['mahuyen']
				value = {'mahuyen': mahuyen}
				return value

	def select_output(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()
		self.path_solution = str(QFileDialog.getExistingDirectory(caption= "Q5PFES-Chọn thư mục lưu kết quả",directory= conf_folder,options=QFileDialog.ShowDirsOnly))
		self.output_path.setText(self.path_solution)

	def run(self):
		try:		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)

			conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
			f = open(conf_dir, 'r')
			conf_code = f.read()

			tempo = str(Path(__file__).parent.absolute()) + '/tempo/tempo.xlsx'
			outpath = self.output_path.text()
			tinh = self.com_tinh.currentText()
			huyen = self.com_huyen.currentText()
			xa = self.combo_xa.currentText()
			thonban = self.combo_thonban.currentText()
			maxa = (self.laymaxa())['maxa']
			mahuyen = (self.laymahuyen())['mahuyen']

			export = outpath + '/bieu1.xlsx'
			export_ngr = outpath + '/CR1_NguonGoc.xlsx'
			export_cnr = outpath + '/CR1_3LR.xlsx'
			export_lv = outpath + '/CR1_LuuVuc.xlsx'
			hc_out = outpath + '/TenHanhChinh.xlsx'
			tinh_out = outpath + '/TenTinh.xlsx'
			xa_out = outpath + '/TenXa.xlsx'
			copy = str(Path(__file__).parent.absolute()) + '/data/Mau12_14.xlsm'
			copy_HB = str(Path(__file__).parent.absolute()) + '/data/Mau12_14_HB.xlsm'
			copy_NB = str(Path(__file__).parent.absolute()) + '/data/MauCR1_NinhBinh.xlsm'
			copy_LS = str(Path(__file__).parent.absolute()) + '/data/MauCR1_LangSon.xlsm'
			copy_SL = str(Path(__file__).parent.absolute()) + '/data/MauCR1_SonLa.xlsm'
			copy_TH = str(Path(__file__).parent.absolute()) + '/data/MauCR1_ThanhHoa.xlsm'
			copy_NA = str(Path(__file__).parent.absolute()) + '/data/MauCR1_NgheAn.xlsm'
			copy_js = str(Path(__file__).parent.absolute()) + '/data/dsluuvuc.json'
			paste = outpath + '/' + str(maxa) +'_'+ convert_TVKD(xa)+'.xlsm'
			paste_NA = outpath + '/' + str(mahuyen) +'_'+ convert_TVKD(huyen)+'.xlsm'
			paste_HB = outpath + '/' + str(maxa) +'_'+ convert_TVKD(xa)+'_'+ convert_TVKD(thonban) + '.xlsm'
			paste_js = outpath + '/dsluuvuc.json'
			run = 'start excel.exe '

			if conf_code == '17':
				i=0
				for n in range(1,4):
					i=i+1
					if n==1:
						if thonban == 'UBND xã':
							form_UBND_HB(tempo,xa,export)
						else:
							form_HGD_HB (tempo,thonban,export)
					elif n==2:
						if thonban == 'UBND xã':
							hanhchinh_UBND_HB_export(tempo,xa,hc_out)
						else:
							hanhchinh_HGD_HB_export(tempo,thonban,hc_out)
					else:
						shutil.copy2(copy_HB, paste_HB)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste_HB)
					QgsProject.instance().removeAllMapLayers()	
				
					percent = (i/float(3)) * 100
					progress.setValue(int(percent))				
					time.sleep(1) 
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '37':
				i=0
				for n in range(1,4):
					i=i+1
					if n==1:
						form_CR1_NB (tempo,maxa,export)
					elif n==2:
						hanhchinh_export(tempo,maxa,hc_out)
					else:
						shutil.copy2(copy_NB, paste)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()	
				
					percent = (i/float(3)) * 100
					progress.setValue(int(percent))				
					time.sleep(1) 
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '20':
				i=0
				for n in range(1,4):
					i=i+1
					if n==1:
						form_CR1_NB (tempo,maxa,export)
					elif n==2:
						hanhchinh_export(tempo,maxa,hc_out)
					else:
						shutil.copy2(copy_LS, paste)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()	
				
					percent = (i/float(3)) * 100
					progress.setValue(int(percent))				
					time.sleep(1) 
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '14':
				i=0
				for n in range(1,4):
					i=i+1
					if n==1:
						formCR1_SL(tempo,maxa,export)
					elif n==2:
						hanhchinh_export(tempo,maxa,hc_out)
					else:
						shutil.copy2(copy_SL, paste)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()	
				
					percent = (i/float(3)) * 100
					progress.setValue(int(percent))				
					time.sleep(1) 
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '38':
				i=0
				for n in range(1,4):
					i=i+1			
					if n==1:
						formCR1_TH(tempo,maxa,export)
					elif n==2:
						hanhchinh_export(tempo,maxa,hc_out)
					else:
						shutil.copy2(copy_TH, paste)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()	
				
					percent = (i/float(3)) * 100
					progress.setValue(int(percent))				
					time.sleep(1) 
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '40':
				i=0
				for n in range(1,6):
					i=i+1
					if n==1:
						formCR1_nggocr_NA(tempo,mahuyen,export_ngr)	
					elif n==2:
						formCR1_3lr_NA(tempo,mahuyen,export_cnr)
					elif n==3:
						formCR1_lv_NA(tempo,mahuyen,export_lv)
					elif n==4:
						hanhchinh_NA_export(tempo,huyen,hc_out)								
					else:
						shutil.copy2(copy_NA, paste_NA)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste_NA)
					QgsProject.instance().removeAllMapLayers()					
					percent = (i/float(5)) * 100
					progress.setValue(int(percent))				
					time.sleep(1) 
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '45':
				i=0
				for n in range(1,6):
					i=i+1
					if n==1:
						formCR1_nggocr_QTI(tempo,mahuyen,export_ngr)	
					elif n==2:
						formCR1_3lr_QTI(tempo,mahuyen,export_cnr)
					elif n==3:
						formCR1_lv_QTI(tempo,mahuyen,export_lv)
					elif n==4:
						hanhchinh_NA_export(tempo,huyen,hc_out)								
					else:
						shutil.copy2(copy_NA, paste_NA)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste_NA)
					QgsProject.instance().removeAllMapLayers()					
					percent = (i/float(5)) * 100
					progress.setValue(int(percent))				
					time.sleep(1) 
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			else:
				i=0
				for n in range(1,6):
					i=i+1
					if n==1:
						report_comumune(tempo,maxa,export)
					elif n==2:
						hanhchinh_export(tempo,maxa,hc_out)
					elif n==3:
						tinh_export(tempo,maxa,tinh_out)
					elif n==4:
						xa_export(tempo,maxa,xa_out)
					else:
						shutil.copy2(copy, paste)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()	

					percent = (i/float(5)) * 100
					progress.setValue(int(percent))				
					time.sleep(1) 
				qgis.utils.iface.messageBar().clearWidgets()					  
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

		except:
			qgis.utils.iface.messageBar().clearWidgets()
			self.iface.messageBar().pushMessage("Error","Quá trình xuất biểu thất bại", level=Qgis.Critical, duration=5)

	def close_form(self):
		try:
			pathout = self.output_path.text()
			databases = filter(os.path.isfile, glob.glob(pathout + '/*.xlsm'))
			if databases:
				for file in databases:
					os.remove(file)
			if os.path.exists(pathout + '/TenHanhChinh.xlsx'):
				os.remove(pathout + '/TenHanhChinh.xlsx')
			if os.path.exists(pathout + '/TenXa.xlsx'):
				os.remove(pathout + '/TenXa.xlsx')
			if os.path.exists(pathout + '/TenTinh.xlsx'):
				os.remove(pathout + '/TenTinh.xlsx')
			if os.path.exists(pathout + '/bieu1.xlsx'):
				os.remove(pathout + '/bieu1.xlsx')
			if os.path.exists(pathout + '/bieu2.xlsx'):
				os.remove(pathout + '/bieu2.xlsx')
			if os.path.exists(pathout + '/dsluuvuc.json'):
				os.remove(pathout + '/dsluuvuc.json')
			if os.path.exists(pathout + '/CR1_NguonGoc.xlsx'):
				os.remove(pathout + '/CR1_NguonGoc.xlsx')
			if os.path.exists(pathout + '/CR1_3LR.xlsx'):
				os.remove(pathout + '/CR1_3LR.xlsx')
			if os.path.exists(pathout + '/CR1_LuuVuc.xlsx'):
				os.remove(pathout + '/CR1_LuuVuc.xlsx')
			self.close()
		except:
			self.iface.messageBar().pushMessage("Vui lòng hoàn tất quá trình xuất biểu", level=Qgis.Warning, duration=5)

class XuatBieuNhom2_Dlg(QDialog, Ui_Dialog_XuatBieuNhom2):
	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.out_path.setText('')											 
		self.btn_path.clicked.connect(self.select_output)
		self.btn_ok.clicked.connect(self.checkRun)
		self.btn_cancel.clicked.connect(self.close_form)
		self.laydscr()
		self.laydstinh()
		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8

	def checkRun(self):
		if self.out_path.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn thư mục lưu file kết quả", level=Qgis.Warning, duration=5)

	def laydstinh(self):
		try:
			dstinh = docdschurung()
			values = set()
			for item in dstinh:
				values.add(item['tinh'])
			self.com_tinh.addItems(values)
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng CSDL", level=Qgis.Warning, duration=2)

	def laydscr(self):
		try:
			dscr = docdschurung()
			self.com_churung.clear()
			for cr in dscr:
				tencr = cr['churung']
				self.com_churung.addItems([tencr])
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng CSDL", level=Qgis.Warning, duration=2)

	def layma(self):
		try:
			tencr = self.com_churung.currentText()
			dscr = docdschurung()
			for cr in dscr:
				if cr['churung'] == tencr:
					macr = cr['machur']
					tentinh = cr['tinh']
					value = {'macr': macr, 'tinh': tentinh}
					return value
		except:
			self.iface.messageBar().pushMessage("Chưa xây dựng CSDL", level=Qgis.Warning, duration=1)

	def select_output(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read()
		self.path_solution = str(QFileDialog.getExistingDirectory(caption= "Q5PFES-Chọn thư mục lưu kết quả",directory= conf_folder,options=QFileDialog.ShowDirsOnly))
		self.out_path.setText(self.path_solution)

	def run(self):
		try:
			#clear the message bar
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)

			conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
			f = open(conf_dir, 'r')
			conf_code = f.read()

			tempo = str(Path(__file__).parent.absolute()) + '/tempo/tempo.xlsx'
			outpath = self.out_path.text()
			cr = self.com_churung.currentText()
			machur = (self.layma())['macr']
			export = outpath + '/bieu2.xlsx'
			export_ngr = outpath + '/CR2_NguonGoc.xlsx'
			export_cnr = outpath + '/CR2_3LR.xlsx'
			export_lv = outpath + '/CR2_LuuVuc.xlsx'
			chur_out = outpath + '/TenHanhChinh.xlsx'
			tinh_out = outpath + '/TenTinh.xlsx'
			copy = str(Path(__file__).parent.absolute()) + '/data/Mau13_14.xlsm'
			copy_HB = str(Path(__file__).parent.absolute()) + '/data/Mau13_14_HB.xlsm'
			copy_NB = str(Path(__file__).parent.absolute()) + '/data/MauCR2_NinhBinh.xlsm'
			copy_LS = str(Path(__file__).parent.absolute()) + '/data/MauCR2_LangSon.xlsm'
			copy_SL = str(Path(__file__).parent.absolute()) + '/data/MauCR2_SonLa.xlsm'
			copy_NA = str(Path(__file__).parent.absolute()) + '/data/MauCR2_NgheAn.xlsm'
			copy_js = str(Path(__file__).parent.absolute()) + '/data/dsluuvuc.json'
			paste = outpath + '/' + str(machur) +'_'+ convert_TVKD(cr)+'.xlsm'
			paste_js = outpath + '/dsluuvuc.json'
			run = 'start excel.exe '

			if conf_code == '17':
				i=0
				for n in range(1,5):
					i=i+1
					if n==1:
						report_forestActor_HB(tempo,machur,export)
					elif n==2:
						churung_export(tempo,machur,chur_out)
					elif n==3:
						province_export(tempo,machur,tinh_out)
					else:
						shutil.copy2(copy_HB, paste)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()

					percent = (i/float(4)) * 100
					progress.setValue(int(percent))
					time.sleep(1)
				qgis.utils.iface.messageBar().clearWidgets()
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			if conf_code == '37':
				i=0
				for n in range(1,5):
					i=i+1
					if n==1:
						report_forestActor_HB(tempo,machur,export)
					elif n==2:
						churung_export(tempo,machur,chur_out)
					elif n==3:
						province_export(tempo,machur,tinh_out)
					else:
						shutil.copy2(copy_NB, paste)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()

					percent = (i/float(4)) * 100
					progress.setValue(int(percent))
					time.sleep(1)
				qgis.utils.iface.messageBar().clearWidgets()
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			if conf_code == '20':
				i=0
				for n in range(1,5):
					i=i+1
					if n==1:
						report_forestActor_HB(tempo,machur,export)
					elif n==2:
						churung_export(tempo,machur,chur_out)
					elif n==3:
						province_export(tempo,machur,tinh_out)
					else:
						shutil.copy2(copy_LS, paste)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()

					percent = (i/float(4)) * 100
					progress.setValue(int(percent))
					time.sleep(1)
				qgis.utils.iface.messageBar().clearWidgets()
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '14':
				i=0
				for n in range(1,4):
					i=i+1
					if n==1:
						formCR2_SL(tempo,machur,export)
					elif n==2:
						churung_export(tempo,machur,chur_out)
					else:
						shutil.copy2(copy_SL, paste)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()

					percent = (i/float(3)) * 100
					progress.setValue(int(percent))
					time.sleep(1)
				qgis.utils.iface.messageBar().clearWidgets()
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '40':
				i=0
				for n in range(1,6):
					i=i+1
					if n==1:
						formCR2_nggocr_NA(tempo,machur,export_ngr)					
					elif n==2:
						formCR2_3lr_NA(tempo,machur,export_cnr)
					elif n==3:
						formCR2_lv_NA(tempo,machur,export_lv)
					elif n==4:
						churung_export(tempo,machur,chur_out)
					else:
						shutil.copy2(copy_NA, paste)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()

					percent = (i/float(5)) * 100
					progress.setValue(int(percent))
					time.sleep(1)
				qgis.utils.iface.messageBar().clearWidgets()
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			elif conf_code == '45':
				i=0
				for n in range(1,6):
					i=i+1
					if n==1:
						formCR2_nggocr_QTI(tempo,machur,export_ngr)					
					elif n==2:
						formCR2_3lr_QTI(tempo,machur,export_cnr)
					elif n==3:
						formCR2_lv_QTI(tempo,machur,export_lv)
					elif n==4:
						churung_export(tempo,machur,chur_out)
					else:
						shutil.copy2(copy_NA, paste)
						shutil.copy2(copy_js, paste_js)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()

					percent = (i/float(5)) * 100
					progress.setValue(int(percent))
					time.sleep(1)
				qgis.utils.iface.messageBar().clearWidgets()
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)

			else:
				i=0
				for n in range(1,5):
					i=i+1
					if n==1:
						report_forestActor(tempo,machur,export)
					elif n==2:
						churung_export(tempo,machur,chur_out)
					elif n==3:
						province_export(tempo,machur,tinh_out)
					else:
						shutil.copy2(copy, paste)
						os.system(run + paste)
					QgsProject.instance().removeAllMapLayers()

					percent = (i/float(4)) * 100
					progress.setValue(int(percent))
					time.sleep(1)
				qgis.utils.iface.messageBar().clearWidgets()
				self.iface.messageBar().pushMessage("Quá trình xuất biểu thành công", level=Qgis.Success, duration=5)
		except:
			qgis.utils.iface.messageBar().clearWidgets()
			self.iface.messageBar().pushMessage("Error","Quá trình xuất biểu thất bại", level=Qgis.Critical, duration=5)

	
	def close_form(self):
		try:
			pathout = self.out_path.text()
			databases = filter(os.path.isfile, glob.glob(pathout + '/*.xlsm'))
			if databases:
				for file in databases:
					os.remove(file)
			if os.path.exists(pathout + '/TenHanhChinh.xlsx'):
				os.remove(pathout + '/TenHanhChinh.xlsx')
			if os.path.exists(pathout + '/TenXa.xlsx'):
				os.remove(pathout + '/TenXa.xlsx')
			if os.path.exists(pathout + '/TenTinh.xlsx'):
				os.remove(pathout + '/TenTinh.xlsx')
			if os.path.exists(pathout + '/bieu1.xlsx'):
				os.remove(pathout + '/bieu1.xlsx')
			if os.path.exists(pathout + '/bieu2.xlsx'):
				os.remove(pathout + '/bieu2.xlsx')
			if os.path.exists(pathout + '/dsluuvuc.json'):
				os.remove(pathout + '/dsluuvuc.json')
			if os.path.exists(pathout + '/CR2_NguonGoc.xlsx'):
				os.remove(pathout + '/CR2_NguonGoc.xlsx')
			if os.path.exists(pathout + '/CR2_3LR.xlsx'):
				os.remove(pathout + '/CR2_3LR.xlsx')
			if os.path.exists(pathout + '/CR2_LuuVuc.xlsx'):
				os.remove(pathout + '/CR2_LuuVuc.xlsx')
			self.close()
		except:
			self.iface.messageBar().pushMessage("Vui lòng hoàn tất quá trình xuất biểu", level=Qgis.Warning, duration=5)

class XayDungTrangIn_Dlg(QDialog, Ui_Dialog_XayDungTrangIn):

	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)
		self.inPath.setText('')
		self.inBtn.clicked.connect(self.select_input_shape)
		self.buttonBox.accepted.connect(self.checkRun)
		orgEncoding=QgsSettings().value('/Processing/encoding') # save setting
		QgsSettings().setValue('/Processing/encoding', 'utf-8') # set uft8	

	def checkRun(self):
		if self.inPath.text() != '':
			self.run()
		else:
			self.iface.messageBar().pushMessage("Chưa chọn dữ liệu đầu vào", level=Qgis.Warning, duration=5)

	def select_input_shape(self):
		conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
		f = open(conf_dir, 'r')
		conf_folder = f.read() 	  
		self.path_solution = str(QFileDialog.getOpenFileName(self, "Q5PFES-Chọn lớp bản đồ đầu vào", conf_folder, "Shapefile (*.shp)")[0])
		self.inPath.setText(self.path_solution)

		config_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
		f1 = open(config_dir, 'r')
		conf_code = f1.read()

		attr_name = ['maxa','mahuyen','matinh','xa','huyen','tinh','tk','khoanh','lo','ddanh','dtich','nggocr','maldlr','ldlr','malr3','dtuong','machur','churung','vungchitra','chitra','maluuvuc','k0','k1','k2','k3','k4','dtichct']
		checkInput(self,attr_name)

	def run(self):
		try:
			#clear the message bar		
			qgis.utils.iface.messageBar().clearWidgets() 
			#set a new message bar
			progressMessageBar = qgis.utils.iface.messageBar()
			######################################
			# Prepare your progress Bar
			######################################
			progress = QProgressBar()
			#Maximum is set to 100, making it easy to work with percentage of completion
			progress.setMaximum(100) 
			#pass the progress bar to the message Bar
			progressMessageBar.pushWidget(progress)

			inpath = self.inPath.text()

			i=0
			for n in range(1,4):
				i=i+1
				if n==1:
					province_replace(inpath)
				elif n==2:
					district_replace(inpath)
				else:
					commune_replace(inpath)								 					

				percent = (i/float(3)) * 100
				progress.setValue(int(percent))				
				time.sleep(1) 
			qgis.utils.iface.messageBar().clearWidgets()
			QgsProject.instance().removeAllMapLayers()					  
			self.iface.messageBar().pushMessage("Quá trình xây dựng trang in bản đồ thành công", level=Qgis.Success, duration=5)
		except:
			QgsProject.instance().removeAllMapLayers()
			qgis.utils.iface.messageBar().clearWidgets()
			self.iface.messageBar().pushMessage("Warning","Chưa xây dựng layout", level=Qgis.Critical, duration=5)

class XemTrangIn_Dlg(QDialog, Ui_Dialog_Layout):

	def __init__(self, iface):
		QDialog.__init__(self)
		self.iface = iface
		self.setupUi(self)		
		self.buttonBox.accepted.connect(self.run)										 
		self.com_tinh.currentIndexChanged.connect(self.laydanhsachhuyen)
		self.com_huyen.currentIndexChanged.connect(self.laydanhsachxa)
		self.laydanhsachtinh()
		self.laydanhsachhuyen()
		self.laydanhsachxa()

	def laydanhsachtinh(self):
		self.com_tinh.clear()
		selected_tinh = self.com_tinh.currentText()
		tinhs = docdstinh()

		conf_dir = str(Path(__file__).parent.absolute()) + '/data/config.txt'
		f = open(conf_dir, 'r')
		conf_code = f.read()

		if conf_code == "17":
			self.com_tinh.addItems(['17 - Tỉnh Hoà Bình'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

		if conf_code == "14":
			self.com_tinh.addItems(['14 - Tỉnh Sơn La'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

		elif conf_code == "40":
			self.com_tinh.addItems(['40 - Tỉnh Nghệ An'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

		elif conf_code == "38":
			self.com_tinh.addItems(['38 - Tỉnh Thanh Hóa'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

		elif conf_code == "49":
			self.com_tinh.addItems(['49 - Tỉnh Quảng Nam'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

		elif conf_code == "45":
			self.com_tinh.addItems(['45 - Tỉnh Quảng Trị'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

		elif conf_code == "10":
			self.com_tinh.addItems(['10 - Tỉnh Lào Cai'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

		elif conf_code == "20":
			self.com_tinh.addItems(['10 - Tỉnh Lạng Sơn'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

		else:
			self.com_tinh.addItems(['-- Chọn tỉnh --'])
			for tinh in tinhs:
				tname = tinh['MATINH'] + " - " + tinh['TINH']
				self.com_tinh.addItems([tname])

	def laydanhsachhuyen(self):
		self.com_huyen.clear()
		tentinh = self.com_tinh.currentText()
		matinh = tentinh.split(' - ')[0]	
		listhuyen = docdshuyen()
		self.com_huyen.addItems(['-- Chọn huyện --'])
		for chon in listhuyen:
			if chon['MATINH'] == matinh:
				hname = chon['MAHUYEN'] + " - " + chon['HUYEN']
				self.com_huyen.addItems([hname])

	def laydanhsachxa(self):
		self.combo_xa.clear()
		tenhuyen = self.com_huyen.currentText()
		mahuyen = tenhuyen.split(' - ')[0]
		listxa = docdsxa()
		self.combo_xa.addItems(['-- Chọn xã --'])
		for xachon in listxa:
			if xachon['MAHUYEN'] == mahuyen:
				xname = xachon['MAXA'] + " - " + xachon['XA']
				self.combo_xa.addItems([xname])

	def laymacode(self):
		selected_xa = self.combo_xa.currentText()
		selected_huyen = self.com_huyen.currentText()
		selected_tinh = self.com_tinh.currentText()

		if self.combo_xa.currentIndex() > 0:
			code = selected_xa.split(" - ")[0]
			syn = 'Xa_' + code
			return syn

		elif self.com_huyen.currentIndex() > 0:
			code = selected_huyen.split(" - ")[0]
			syn = 'Huyen_' + code
			return syn

		else:
			code = selected_tinh.split(" - ")[0]
			syn = 'Tinh_' + code
			return syn

	def run(self):

		qgis.utils.iface.messageBar().clearWidgets()
		progressMessageBar = qgis.utils.iface.messageBar()
		progress = QProgressBar()
		progress.setMaximum(100)
		progressMessageBar.pushWidget(progress)

		_tinh = self.com_tinh.currentText()
		if _tinh == "-- Chọn tỉnh --":
			qgis.utils.iface.messageBar().clearWidgets()
			self.iface.messageBar().pushMessage("Chưa chọn đơn vị hành chính", level=Qgis.Warning, duration=5)
		else:
			code = self.laymacode()
			conf_dir = str(Path(__file__).parent.absolute()) + '/data/configFolder.txt'
			f = open(conf_dir, 'r')
			conf_folder = f.read()

			i=0
			for n in range (1, 3):
				if n == 1:
					openLayout(code,conf_folder)
				else:
					if os.path.exists(conf_folder+ "/Layout/CapTinh/"+ code + "/" + code + ".qgz"):
						qgis.utils.iface.messageBar().clearWidgets()
						self.iface.messageBar().pushMessage("Mở trang in bản đồ thành công", level=Qgis.Success, duration=5)
					elif os.path.exists(conf_folder+ "/Layout/CapHuyen/"+ code + "/" + code + ".qgz"):
						qgis.utils.iface.messageBar().clearWidgets()
						self.iface.messageBar().pushMessage("Mở trang in bản đồ thành công", level=Qgis.Success, duration=5)
					elif os.path.exists(conf_folder+ "/Layout/CapXa/"+ code + "/" + code + ".qgz"):
						qgis.utils.iface.messageBar().clearWidgets()
						self.iface.messageBar().pushMessage("Mở trang in bản đồ thành công", level=Qgis.Success, duration=5)
					else:
						qgis.utils.iface.messageBar().clearWidgets()
						self.iface.messageBar().pushMessage("Chưa xây dựng layout", level=Qgis.Warning, duration=5)			
				i = i + 1
				percent = (i / float(2)) * 100
				progress.setValue(int(percent))
				time.sleep(1)

	def close_form(self):
		self.close()	
	