# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PythonModuleManager
                                 A QGIS plugin
 Manage Python modules
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-11-29
        git sha              : $Format:%H$
        copyright            : (C) 2023 by BABA Yoshihiko
        email                : babayoshihiko@mac.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .python_module_manager_dialog import PythonModuleManagerDialog
import os.path


class PythonModuleManager:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PythonModuleManager_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Python Module Manager')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PythonModuleManager', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/python_module_manager/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Python Module Manager'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Python Module Manager'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = PythonModuleManagerDialog()
            self.set_label_init()
            self.show_all_packages()
            
            self.dlg.myPushButton1.setText("Install Package")
            self.dlg.myPushButton1.setToolTip("Install a package/packages in the text box above. You may have two or more packages in each line.")
            self.dlg.myPushButton1.clicked.connect(self.install_package)
            
            self.dlg.myPushButton2.setText("Show Modules")
            self.dlg.myPushButton2.setToolTip("Show all the modules in the selected package in the text box above.")
            self.dlg.myPushButton2.clicked.connect(self.show_all_modules)
            
            self.dlg.myPushButton3.setText("Upgrade")
            self.dlg.myPushButton3.setToolTip("Upgrade the selected package. This requires the Internet access.")
            self.dlg.myPushButton3.clicked.connect(self.upgrade_package)
            
            self.dlg.myPushButton4.setText("Check Latest")
            self.dlg.myPushButton4.setToolTip("Check the latest version of the selected package. This requires the Internet access. The result will be shown in the text box above.")
            self.dlg.myPushButton4.clicked.connect(self.check_latest_version)
            
            self.dlg.myPushButton5.setText("Refresh")
            self.dlg.myPushButton5.setToolTip("Refresh the list of installed paackages.")
            self.dlg.myPushButton5.clicked.connect(self.show_all_packages)
            
            self.dlg.myPushButton6.setText("Test Module")
            self.dlg.myPushButton6.setToolTip("Type a module name in the above field. Pu the button to import it.")
            self.dlg.myPushButton6.clicked.connect(self.test_load_module)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def show_all_packages(self):
        bol_Failed = False
        try:
            self.show_all_distributions_importlib()
        except Exception as e:
            bol_Failed = True
        
        if bol_Failed:
            self.show_installed_packages_pkgresources()

    def show_all_modules(self):
        bol_Failed = False
        try:
            self.show_all_modules_importlib()
        except Exception as e:
            bol_Failed = True
        
        if bol_Failed:
            self.show_all_modules_pkgutil()
    
    # https://discuss.python.org/t/will-setuptools-remove-pkg-resource-module-in-the-future/27182
    # https://github.com/matrix-org/synapse/issues/12508
    def show_installed_packages_pkgresources(self):
        import pkg_resources
        installed_packages = [pkg.key for pkg in pkg_resources.working_set]
        installed_packages.sort()
        self.dlg.myListWidget.clear()
        for package in installed_packages:
            self.dlg.myListWidget.addItem(package + " " + pkg_resources.get_distribution(package).version)

    def show_installed_packages_old(self):
        from pip._internal.utils.misc import get_installed_distributions
        installed_distributions = get_installed_distributions()
        installed_packages = []
        for dist in installed_distributions:
            package = {
                'name': dist.key,
                'version': dist.version,
                'location': dist.location
            }
            installed_packages.append(package)
        installed_packages.sort(key=lambda x: x['name'])
        self.dlg.myListWidget.clear()
        for package in installed_packages:
            self.dlg.myListWidget.addItem(package['name'] + ' ' + package['version'] + ' ' + package['location'])

    def set_label_init(self):
        import sys
        self.print_log("<html><b>Python version</b></html>")
        self.print_log(sys.version)
        self.print_log("<html><b>sys.executable</b>:</html>")
        self.print_log(sys.executable)
        self.print_log("<html><b>sys.path</b>:</html>")
        paths = sys.path
        possible_python = ""
        for path in paths:
            self.dlg.myTextEditLog.append(path)

    def print_log(self, message):
        self.dlg.myTextEditLog.append(message)

    def install_package(self):
        import sys
        from io import StringIO
        from pip._internal.cli.main import main as pip_main
        original_stdout = sys.stdout
        original_stderr = sys.stderr
        sys.stdout = StringIO()
        sys.stderr = StringIO()
        
        package_names = self.dlg.myTextEdit.toPlainText()
        package_names = package_names.replace(',', ' ')
        package_names = package_names.split()

        for package_name in package_names:
            try:
                pip_main(['install', package_name])
                result_stdout = sys.stdout.getvalue()
                result_stderr = sys.stderr.getvalue()
                if (result_stdout != ''):
                    self.print_log(result_stdout)
                if (result_stderr != ''):
                    self.print_log(result_stderr)
                self.show_all_distributions_importlib()
            except Exception as e:
                self.print_log(f"Failed to install {package_name}. Error: {e}")
            finally:
                # Restore the original stdout and stderr
                sys.stdout = original_stdout
                sys.stderr = original_stderr

    def upgrade_package(self):
        import sys
        from io import StringIO
        from pip._internal.cli.main import main as pip_main
        original_stdout = sys.stdout
        original_stderr = sys.stderr
        sys.stdout = StringIO()
        sys.stderr = StringIO()
        
        package = self.dlg.myListWidget.currentItem().text()
        package_name = package.split(" ")[0]
        
        try:
            pip_main(['install', package_name])
            result_stdout = sys.stdout.getvalue()
            result_stderr = sys.stderr.getvalue()
            if (result_stdout != ''):
                self.print_log(result_stdout)
            if (result_stderr != ''):
                self.print_log(result_stderr)
        except Exception as e:
            self.print_log(f"Failed to install {package_name}. Error: {e}")
        finally:
            # Restore the original stdout and stderr
            sys.stdout = original_stdout
            sys.stderr = original_stderr

    def show_package_path(self):
        import importlib.util
        import os
        
        package = self.dlg.myListWidget.currentItem().text()
        package_name = package.split(" ")[0]
        
        try:
            # Find the module specification
            spec = importlib.util.find_spec(package_name)
            
            if spec is not None:
                # Get the file path of the module
                package_path = os.path.abspath(spec.origin)
                self.print_log(f"Pacakge '{package_name}' is at {package_path}.")
            else:
                self.print_log(f"Package '{package_name}' not found.")
                return None
        except ImportError as e:
            self.print_log(f"Error: {e}")
            return None

    def show_package_path_2(self):
        import pkg_resources
        package = self.dlg.myListWidget.currentItem().text()
        package_name = package.split(" ")[0]
        self.print_log(pkg_resources.get_distribution(package_name).location)

    def show_all_modules_pkgutil(self):
        import importlib
        import pkgutil
        
        package = self.dlg.myListWidget.currentItem().text()
        package_name = package.split(" ")[0]
        package = importlib.import_module(package_name)
        module_iterator = pkgutil.iter_modules(package.__path__)
        
        for _, module_name, _ in module_iterator:
            full_module_name = f"{package_name}.{module_name}"
            self.print_log(full_module_name)

    def show_all_modules_2(self):
        import pkg_resources
        package = self.dlg.myListWidget.currentItem().text()
        package_name = package.split(" ")[0]
        distribution = pkg_resources.get_distribution(package_name)
        
        for entry_point in distribution.get_entry_map().values():
            for entry_point in entry_point.values():
                if entry_point.module_name:
                    self.print_log(entry_point.module_name)

    def show_all_distributions_importlib(self):
        from importlib.metadata import distributions
        distributions = distributions()
        installed_packages = []
        for distribution in distributions:            
            package = {
                'name': distribution.metadata['Name'],
                'version': distribution.metadata['Version'],
            }
            installed_packages.append(package)
        installed_packages.sort(key=lambda x: x['name'])
        for package in installed_packages:
            self.dlg.myListWidget.addItem(package['name'] + ' ' + package['version'])

    def show_all_modules_importlib(self):
        from importlib.metadata import files
        
        package = self.dlg.myListWidget.currentItem().text()
        package_name = package.split(" ")[0]
                
        modules = files(package_name)
        for module in modules:
            if str(module)[-3:] == ".py":
                self.print_log(str(module.locate()))
        # files("gdal")[0].locate()

    def check_latest_version(self):
        import requests
        package = self.dlg.myListWidget.currentItem().text()
        package_name = package.split(" ")[0]
        installed_version = package.split(" ")[1]
        
        try:
            response = requests.get(f'https://pypi.org/pypi/{package_name}/json')
            data = response.json()
            latest_version = data['info']['version']
            requires_python = data['info']['requires_python']
            self.print_log(f"The latest version of {package_name} is {latest_version} and reuires python {requires_python}.")
        except Exception as e:
            self.print_log(f"Error fetching latest version for {package_name}: {e}")

    def test_load_module(self):
        import importlib
        module_name = self.dlg.myLineEdit2.text().split()[0]
        
        try:
            # Try to import the module dynamically
            module = importlib.import_module(module_name)        
            if hasattr(module, '__version__'):
                version = module.__version__
                self.print_log(f"Module '{module_name}' loaded successfully. Version: {version}")
            else:
                self.print_log(f"Module '{module_name}' loaded successfully. Version information not available.")
        except ImportError as e:
            self.print_log(f"Error loading module '{module_name}': {e}")
