SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;


CREATE TABLE pyunitastratigrafiche (
    gid integer NOT NULL,
    area_s integer,
    scavo_s character varying(80),
    us_s integer,
    tipo_us_s character varying(80),
    the_geom geometry,
    CONSTRAINT enforce_dims_the_geom CHECK ((ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((srid(the_geom) = (-1)))
);


ALTER TABLE public.pyunitastratigrafiche OWNER TO postgres;


INSERT INTO pyunitastratigrafiche (gid, area_s, scavo_s, us_s, tipo_us_s, the_geom) VALUES (0, 1, 'Ex-Supercinema, Rimini', 73, 'p', '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');



ALTER TABLE ONLY pyunitastratigrafiche
    ADD CONSTRAINT pyunitastratigrafiche_pkey PRIMARY KEY (gid);


SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;


CREATE TABLE pyuscaratterizzazioni (
    gid integer NOT NULL,
    area_c integer,
    scavo_c character varying(80),
    tipo_us_c character varying(80),
    us_c integer,
    the_geom geometry,
    CONSTRAINT enforce_dims_the_geom CHECK ((ndims(the_geom) = 2)),
    CONSTRAINT enforce_srid_the_geom CHECK ((srid(the_geom) = (-1)))
);


ALTER TABLE public.pyuscaratterizzazioni OWNER TO postgres;


INSERT INTO pyuscaratterizzazioni (gid, area_c, scavo_c, tipo_us_c, us_c, the_geom) VALUES (0, 3, 'Ex-Supercinema, Rimini', 'c2', 0, '01030000000100000017000000CF7B3F7C34BD4141D3F6FE50329F5241D631AB7D34BD4141D3F6FE50329F52415ED5717F34BD4141FF451D51329F524145CDE08234BD4141FF451D51329F524148A8968334BD4141E730B350329F524148A8968334BD4141B906DF4F329F524148A8968334BD4141B52B294F329F524145CDE08234BD41410514FA4D329F524116A30C8234BD4141EA23DA4C329F52416966938134BD4141FE5D8E4C329F5241BC291A8134BD41413DE7604C329F524151699A7C34BD4141CF33BA4B329F5241F0393C7A34BD41417C70334C329F5241999BFF7934BD4141A7BF514C329F5241999BFF7934BD4141EA23DA4C329F52411B895A7A34BD41418601554E329F52419D76B57A34BD4141F4B4FB4E329F52419D76B57A34BD41414E2EEE4F329F5241C8C5D37A34BD41413AF43950329F52411E64107B34BD414126BA8550329F5241A0516B7B34BD41415209A450329F5241A0516B7B34BD4141E730B350329F5241CF7B3F7C34BD4141D3F6FE50329F5241');


ALTER TABLE ONLY pyuscaratterizzazioni
    ADD CONSTRAINT pyuscaratterizzazioni_pkey PRIMARY KEY (gid);



SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;


CREATE TABLE pyarchinit_quote (
    gid integer NOT NULL,
    sito_q character varying(80),
    area_q integer,
    us_q integer,
    unita_misu_q character varying(80),
    quota_q double precision,
    the_geom geometry,
    CONSTRAINT enforce_dims_the_geom CHECK ((ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((srid(the_geom) = (-1)))
);


ALTER TABLE public.pyarchinit_quote OWNER TO postgres;


INSERT INTO pyarchinit_quote (gid, sito_q, area_q, us_q, unita_misu_q, quota_q, the_geom) VALUES (541, 'Palazzo Ghetti, Rimini', 1, 200, 'm', -2.7999999999999998, '010100000082DF0B1BF1BD414100B026997F9E5241');


ALTER TABLE ONLY pyarchinit_quote
    ADD CONSTRAINT pyarchinit_quote_pkey PRIMARY KEY (gid);

--
INSERT INTO geometry_columns (f_table_catalog, f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type) VALUES ('', 'public', 'pyunitastratigrafiche', 'the_geom', 2, -1, 'POLYGON');
INSERT INTO geometry_columns (f_table_catalog, f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type) VALUES ('', 'public', 'pyuscaratterizzazioni', 'the_geom', 2, -1, 'MULTIPOLYGON');
INSERT INTO geometry_columns (f_table_catalog, f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type) VALUES ('', 'public', 'pyarchinit_quote', 'the_geom', 2, -1, 'POINT');


CREATE VIEW pyarchinit_quote_view AS
 SELECT pyarchinit_quote.gid, pyarchinit_quote.sito_q, pyarchinit_quote.area_q, pyarchinit_quote.us_q, pyarchinit_quote.unita_misu_q, pyarchinit_quote.quota_q, pyarchinit_quote.the_geom, us_table.id_us, us_table.sito, us_table.area, us_table.us, us_table.struttura, us_table.definizione_stratigrafica, us_table.definizione_interpretativa, us_table.descrizione, us_table.interpretazione, us_table.rapporti, us_table.periodo_iniziale, us_table.fase_iniziale, us_table.periodo_finale, us_table.fase_finale, us_table.anno_scavo
   FROM pyarchinit_quote
   JOIN us_table ON pyarchinit_quote.sito_q::text = us_table.sito AND pyarchinit_quote.area_q::text = us_table.area::text AND pyarchinit_quote.us_q::text = us_table.us::text;

ALTER TABLE pyarchinit_quote_view OWNER TO postgres;

CREATE VIEW pyarchinit_us_view AS
 SELECT pyunitastratigrafiche.gid, pyunitastratigrafiche.the_geom, pyunitastratigrafiche.tipo_us_s, pyunitastratigrafiche.scavo_s, pyunitastratigrafiche.area_s, pyunitastratigrafiche.us_s, us_table.id_us, us_table.sito, us_table.area, us_table.us, us_table.struttura, us_table.definizione_stratigrafica, us_table.definizione_interpretativa, us_table.descrizione, us_table.interpretazione, us_table.rapporti, us_table.periodo_iniziale, us_table.fase_iniziale, us_table.periodo_finale, us_table.fase_finale, us_table.anno_scavo
   FROM pyunitastratigrafiche
   JOIN us_table ON pyunitastratigrafiche.scavo_s::text = us_table.sito AND pyunitastratigrafiche.area_s::text = us_table.area::text AND pyunitastratigrafiche.us_s = us_table.us;

ALTER TABLE pyarchinit_us_view OWNER TO postgres;


CREATE VIEW pyarchinit_uscaratterizzazioni_view AS
 SELECT pyuscaratterizzazioni.gid, pyuscaratterizzazioni.the_geom, pyuscaratterizzazioni.tipo_us_c, pyuscaratterizzazioni.scavo_c, pyuscaratterizzazioni.area_c, pyuscaratterizzazioni.us_c, us_table.sito, us_table.id_us, us_table.area, us_table.us, us_table.struttura, us_table.definizione_stratigrafica, us_table.definizione_interpretativa, us_table.descrizione, us_table.interpretazione, us_table.rapporti, us_table.periodo_iniziale, us_table.fase_iniziale, us_table.periodo_finale, us_table.fase_finale, us_table.anno_scavo
   FROM pyuscaratterizzazioni
   JOIN us_table ON pyuscaratterizzazioni.scavo_c::text = us_table.sito AND pyuscaratterizzazioni.area_c::text = us_table.area::text AND pyuscaratterizzazioni.us_c = us_table.us;

ALTER TABLE pyarchinit_uscaratterizzazioni_view OWNER TO postgres;



