# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PvProspectorDialog
                                 A QGIS plugin
 Displays the PV installation potential for residential properties across MK Borough
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-10-18
        git sha              : $Format:%H$
        copyright            : (C) 2023 by GeoMapTric
        email                : peter@geomaptric.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import webbrowser

from qgis.PyQt import QtWidgets, QtCore
from qgis.PyQt import uic
from qgis.core import QgsProject  # Added QgsRectangle to create zoomable extent
from qgis.core import QgsVectorLayer  # Import QgsVectorLayer

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'pv_prospector_dialog_base.ui'))


class PvProspectorDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None, canvas=None):
        """Constructor."""
        super(PvProspectorDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.setWindowTitle("PV Prospector")

        # Connect the Help Button
        self.pb_help.clicked.connect(self.open_help)

        # Populate the ComboBox with layer names
        self.populate_layer_list()
        self.cb_selectdata.currentIndexChanged.connect(self.layer_changed)

        # Pass in the QgsMapCanvas instance when initializing this dialog
        self.canvas = canvas

        # Connect 'Enter' key press on le_postcode to a function
        self.le_postcode.returnPressed.connect(self.select_by_postcode)

        # Connect double-click event on the list widget to a function
        self.listWidget_address.itemDoubleClicked.connect(self.zoom_to_address)

        self.buttonBox.rejected.connect(self.reject)
        # self.buttonBox.accepted.disconnect()
        self.buttonBox.accepted.connect(self.on_ok_clicked)

    def reset_fields(self):
        self.le_postcode.clear()
        self.listWidget_address.clear()
        self.cb_selectdata.setCurrentIndex(0)
        self.le_showpvarea.clear()

    def on_ok_clicked(self):
        self.close()
        self.reset_fields()

    # Add this function to your PvProspectorDialogDialog class
    def keyPressEvent(self, e):
        if e.key() != QtCore.Qt.Key_Return and e.key() != QtCore.Qt.Key_Enter:
            super(PvProspectorDialog, self).keyPressEvent(e)

    def select_by_postcode(self):
        entered_postcode = self.le_postcode.text()
        selected_layer = self.cb_selectdata.currentText()  # Get selected layer name
        layer = QgsProject.instance().mapLayersByName(selected_layer)[0]

        # Build the query string
        query = f"postcode = '{entered_postcode}'"

        # Select features based on the query
        # layer.selectByExpression(query)
        layer.selectByExpression(query, QgsVectorLayer.SetSelection)  # Use SetSelection

        # Update list widget with selected UPRNs
        self.listWidget_address.clear()
        for feature in layer.selectedFeatures():
            self.listWidget_address.addItem(str(feature['address']))

        # Move the zooming logic here, after the selection
        if layer.selectedFeatureCount() > 0:
            if self.canvas is not None:
                self.canvas.zoomToSelected(layer)
            else:
                print("Canvas is None. Unable to zoom.")

    def zoom_to_address(self, item):
        selected_address = item.text()
        selected_layer = self.cb_selectdata.currentText()  # Get selected layer name
        layer = QgsProject.instance().mapLayersByName(selected_layer)[0]

        query = f"address = '{selected_address}'"
        # .selectByExpression(query)
        layer.selectByExpression(query, QgsVectorLayer.SetSelection)  # Use SetSelection

        # Inside zoom_to_address
        if layer.selectedFeatureCount() == 1:
            if self.canvas is not None:
                self.canvas.zoomToSelected(layer)
            else:
                print("Canvas is None. Unable to zoom.")

            # Fetch the pv_area value from the selected feature
            feature = layer.selectedFeatures()[0]
            pv_area = feature['pv_area']

            # Update le_showpvarea QLineEdit with the pv_area value
            self.le_showpvarea.setText(f"{pv_area} M2")  # Add " M2" suffix for square meters

        # Zoom to selected feature
        if layer.selectedFeatureCount() == 1:
            self.canvas.zoomToSelected(layer)

    def populate_layer_list(self):
        layers = [layer.name() for layer in QgsProject.instance().mapLayers().values()]
        self.cb_selectdata.addItems(layers)

    def open_help(self):
        help_path = os.path.abspath(os.path.join(os.path.dirname(__file__), 'help', 'index.html'))
        webbrowser.open('file://' + help_path)

    def layer_changed(self):
        selected_layer = self.cb_selectdata.currentText()
        # Here, you can use 'selected_layer' for later queries
