# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PhotovoltaicsLPDialog
                                 A QGIS plugin
 Wyznaczanie lokalizacji pod farmy fotowoltaiczne LP
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-09-04
        git sha              : $Format:%H$
        copyright            : (C) 2025 by EnviroSolutions Sp. z o. o.
        email                : office@envirosolutions.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from pathlib import Path

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *
from qgis.utils import iface
from qgis.PyQt.QtGui import QColor, QFont


import tempfile
import zipfile

from .daneBdotkTask import PobierzBdotTask
from .analizaTask import AnalizaTask

from .zapisz_xlsx import ZapiszXLSX
from .generuj_raport import GenerujRaport
from . import utils


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'photovoltaics_LP_dialog_base.ui'))


class PhotovoltaicsLPDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(PhotovoltaicsLPDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.label_60.setMargin(4)

        self.wydzielenia = None
        self.wydzielenia_opisy = None
        self.drogi_lesne = None
        self.powiaty = None
        self.obszary = None
        self.drogi = None
        self.linie= None
        self.linie_bdot10k = None
        self.oddzialy = None
        self.nadlesnictwo = None
        self.mapa_bazowa = None
        self.drogi_bdot10k = None
        self.drogi_list = []
        self.linie_list = []
        self.save_layer_path = ""

    

        self.pobierzWarstwyPochodneBtn.clicked.connect(self.pobierz_warstwy_pochodne)
        self.wczytajBdot10kBtn.clicked.connect(self.wczytaj_dane_bdot10k)
        self.analizaBtn.clicked.connect(self.analiza_data)
        self.raportBtn.clicked.connect(self.generuj_raport)
        self.wydrukBtn.clicked.connect(self.generuj_wydruk)
        self.resetujBtn.clicked.connect(self.resetuj)
        self.zamknijBtn.clicked.connect(self.zamknij)
        self.zapisBtn.clicked.connect(self.zapisz_warstwy)
        self.helpBtn.clicked.connect(self.help)


    def dodaj_mape_bazowa(self):
        """dodaje mapę bazową
        """
   
        wmts_url = (
            "contextualWMSLegend=0&crs={}&dpiMode=0&"
            "featureCount=10&format={}&layers={}&"
            "styles=default&tileMatrixSet={}&url={}".format(
                'EPSG:2180',
                "image/jpeg",
                "MAPA TOPOGRAFICZNA",
                'EPSG:2180',
                'https://mapy.geoportal.gov.pl/wss/service/WMTS/guest/wmts/TOPO?service%3DWMTS%26request%3DgetCapabilities'
            )
        )
        
        self.mapa_bazowa = QgsRasterLayer(wmts_url, "Rastrowa Mapa Topograficzna Polski", 'wms')
        if self.mapa_bazowa.isValid():
            root = QgsProject.instance().layerTreeRoot()
            QgsProject.instance().addMapLayer(self.mapa_bazowa, False)
            root.insertLayer(len(root.children()), self.mapa_bazowa)
            self.mapa_bazowa.renderer().setOpacity(0.2)
            self.mapa_bazowa.triggerRepaint()

        else:
         
            msg = QMessageBox.critical(
                    None, "Nie udało się wczytać mapy bazowej", "Sprawdź połączenie z internetem!")

    def pobierz_warstwy_pochodne(self):
        """Ładuje warstwy pochodne z folderu .zip do projektu).
        """
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.DirectoryOnly)
        self.selected_data = dialog.getOpenFileName(
            None, "Wybierz archiwum", "", "Archiwum ZIP (*.zip)")

        if self.selected_data[0]:
            self.pobierzWarstwyPochodneBtn.setEnabled(False)
            zf = zipfile.ZipFile(self.selected_data[0])
            tempdir= tempfile.TemporaryDirectory()
            zf.extractall(tempdir.name)
            powiaty_path = tempdir.name + '\\'+ 'pow_pol.shp'
            wydzielenia_path = tempdir.name + '\\'+ 'wydz_pol.shp'
            drogi_lesne_path = tempdir.name + '\\'+ 'kom_lin.shp'
            oddzialy_path = tempdir.name + '\\'+ 'oddz_pol.shp'
            wydzielenia_opisy_path = tempdir.name + '\\'+ 'ow_pkt.shp'
            nadlesnictwo_path = tempdir.name + '\\'+ 'nadl_pol.shp'

            self.oddzialy= QgsVectorLayer(oddzialy_path, "oddz_pol", "ogr")
            self.powiaty = QgsVectorLayer(powiaty_path, "pow_pol", "ogr")
            self.wydzielenia = QgsVectorLayer(wydzielenia_path, "wydz_pol", "ogr")
            self.drogi_lesne = QgsVectorLayer(drogi_lesne_path, "kom_lin", "ogr")
            self.wydzielenia_opisy = QgsVectorLayer( wydzielenia_opisy_path, "ow_pkt", "ogr")
            self.nadlesnictwo = QgsVectorLayer( nadlesnictwo_path, "nadl", "ogr")
            self.nadlesnictwo.dataProvider().setEncoding(u'windows-1250')
           
            
            if self.drogi_lesne.isValid() and self.wydzielenia.isValid():
                    # dodanie stylu do warstwy z drogami leśnymi
                    symbol =  QgsLineSymbol.createSimple(
                    {'color': 'gray', 'outline_color' : 'gray',  'outline_style': 'solid',
                    'outline_width': '0.26'})
                    renderer = QgsSingleSymbolRenderer(symbol)
                    self.drogi_lesne.setRenderer(renderer)

                    # dodanie stylu do warstwy z wydzieleniami leśnymi
                    symbol =  QgsFillSymbol.createSimple(
                    {'color': '#005023', 'outline_color' : 'black',  'outline_style':'solid',
                    'outline_width': '0.26'})
                    renderer = QgsSingleSymbolRenderer(symbol)
                    self.wydzielenia.setRenderer(renderer)


                    QgsProject.instance().addMapLayers( [self.drogi_lesne, self.wydzielenia])
                    self.dodaj_mape_bazowa() #dodawanie warstwy bazowej
                    ms = QgsMapSettings()
                    ms.setLayers([self.drogi_lesne, self.wydzielenia])  
                    rect = QgsRectangle(ms.fullExtent()) 
                    iface.mapCanvas().setExtent(rect) # ustawaianie do zakresu warstwy wydzielenni warstwy dróg leśnych
                    iface.mapCanvas().refresh()
                    QMessageBox.information(
                            None, "Sukces", "Ładowanie warstw pochodnych zakonczone sukcesem!")
                    self.pobierzWarstwyPochodneBtn.setEnabled(False)
                    self.wczytajBdot10kBtn.setEnabled(True)
                    self.resetujBtn.setEnabled(True)

                   
            else:
                msg = QMessageBox.critical(None, "Nie udało się wczytać warstw pochodnych", "Sprawdź poprawność danych!")
                self.resetuj()    
                    
        else:
               
            msg = QMessageBox.critical(
            None, "Nie wybrano danych", "Wybierz dane!")
            
            
    def wczytaj_dane_bdot10k(self):
        """ściąga dane_bdot10k z internetu do projektu.
        """
       
        features = [obiect for obiect in self.powiaty.getFeatures()]
        iface.messageBar().pushMessage("Informacja",
                                            f'Pobieranie danych BDOT10k',
                                            level=Qgis.Info)
        task = PobierzBdotTask(
            description='Pobieranie danych',
            drogi_layer = self.drogi_bdot10k,
            linie_layer =self.linie_bdot10k,
            features = features, 
            drogi_list =self.drogi_list,
            linie_list = self.linie_list,
            iface= iface,
            wczytajBdot10kBtn = self.wczytajBdot10kBtn,
            analizaBtn = self.analizaBtn,
            resetujBtn = self.resetujBtn

        )
        QgsApplication.taskManager().addTask(task)
        QgsMessageLog.logMessage('runtask')
        
        
    def analiza_data(self):
        """Wykonuje analizę na potrzeby farm fotowoltalicznych.
        """
        iface.messageBar().pushMessage("Informacja",
                                            f'Trwa analiza',
                                            level=Qgis.Info)
        task = AnalizaTask(
            description='Trwa analiza',
            wydzielenia_opisy = self.wydzielenia_opisy,
            wydzielenia =self.wydzielenia,
            oddzialy = self.oddzialy, 
            drogi_lesne =self.drogi_lesne,
            mapa_bazowa = self.mapa_bazowa,
            iface= iface,
            analizaBtn = self.analizaBtn,
            zapisBtn = self.zapisBtn,
            raportBtn=self.raportBtn,
            wydrukBtn=self.wydrukBtn,
            resetujBtn = self.resetujBtn

        )
        QgsApplication.taskManager().addTask(task)
        QgsMessageLog.logMessage('runtask')     

    def zapisz_warstwy(self):
        """Zapisuje warstwy wyznaczonych obszarów, najbliższych dróg i najbiższych linii energetycznych do wybranej lokalizacji
        """
    
        self.save_layer_path = QFileDialog.getSaveFileName(
                None, "Wybierz lokalizację", 'wyznaczone_obszary', '*.shp')
        if len(self.save_layer_path[0]) > 0:
               
            try:
                wyznaczone_obszary = QgsProject.instance().mapLayersByName('Wyznaczone obszary')[0]
                features_obszary = [feature for feature in wyznaczone_obszary.getFeatures()]
                fields_obszary = wyznaczone_obszary.fields()
                path=self.save_layer_path[0]
                self.tworz_warstwy(path, QgsWkbTypes.Polygon, fields_obszary, 'Wyznaczone_obszary', features_obszary)

                linie = QgsProject.instance().mapLayersByName('Najbliższe linie energetyczne')[0]
                features_linie = [feature for feature in linie.getFeatures()]
                fields_linie = linie.fields()
                path_linie = ('/').join(path.split('/')[:-1]) + '//'+ 'najblizsze_linie_energetyczne.shp'
                self.tworz_warstwy(path_linie, QgsWkbTypes.LineString, fields_linie, 'Najbliższe_linie_energetyczne', features_linie)

                drogi = QgsProject.instance().mapLayersByName('Najbliższe drogi')[0]
                features_drogi = [feature for feature in drogi.getFeatures()]
                fields_drogi = drogi.fields()
                path_drogi = ('/').join(path.split('/')[:-1]) + '//'+ 'najblizsze_drogi.shp'
                self.tworz_warstwy(path_drogi, QgsWkbTypes.LineString, fields_drogi, 'Najbliższe_drogi', features_drogi)      

                QMessageBox.information(
                        None, "Sukces", "Zapisywanie warstw zakonczone sukcesem!")
                folder_name = ('/').join(path.split('/')[:-1])
                utils.openFile(folder_name)
            except:
                msg = QMessageBox.critical(
                    None, "Spróbuj jeszcze raz", "Problem z zapisem warstw!")


    def tworz_warstwy(self,path, typ_geom, fields, name, features):
        """Tworzy warstwy wyznaczonych obszarów, najbliższych dróg i najbiższych linii energetycznych.
        """

        crs = QgsCoordinateReferenceSystem('EPSG:2180')
        transform_context = QgsProject.instance().transformContext()
        save_options = QgsVectorFileWriter.SaveVectorOptions()
        save_options.driverName = "ESRI Shapefile"
        save_options.fileEncoding = "UTF-8"
        if Qgis.QGIS_VERSION_INT >= 31030:
            writer = QgsVectorFileWriter.create(
                path, fields, typ_geom, crs, transform_context, save_options)
        else:
            writer = QgsVectorFileWriter(
                self.save_layer_path[0], 'UTF-8', fields,  typ_geom, crs, "ESRI Shapefile")
        if writer.hasError() != QgsVectorFileWriter.NoError:
            msg = QMessageBox.critical(
                None, "Spróbuj jeszcze raz", "Problem z zapisem warstwy!")
        else:
            del writer
            layer = QgsVectorLayer(
                path, name, 'ogr')

            prov = layer.dataProvider()
            prov.addFeatures(features)        

    def generuj_raport(self):
        """Generuje raport i zapisuje go jako plik excela w wybranej lokalizacji. W razie problemu pojawia się wiadomość.
        """
        try:
            nazwa_nadlesnictwa = [feature[3] for feature in self.nadlesnictwo.getFeatures()]

            self.linie = QgsProject.instance().mapLayersByName('Najbliższe linie energetyczne')[0]

            self.drogi = QgsProject.instance().mapLayersByName('Najbliższe drogi')[0]

            self.obszary = QgsProject.instance().mapLayersByName('Wyznaczone obszary')[0]


            nazwa_pliku = ZapiszXLSX().zapisz_xlsx()
          
            if nazwa_pliku:
                generuj_raport = GenerujRaport()
                generuj_raport.tworz_tabele(nazwa_pliku, self.obszary, self.drogi, self.linie, nazwa_nadlesnictwa[0])
                QMessageBox.information(
                    None, "Sukces", "Generowanie raportu zakonczone sukcesem!")
                folder_name = ('/').join(nazwa_pliku.split('/')[:-1])
                utils.openFile(folder_name)
        except:
            msg = QMessageBox.critical(
                None, "Spróbuj jeszcze raz", "Problem z wygenerowaniem raportu!")

    def generuj_wydruk(self):
        
        try:
            nazwa_nadlesnictwa = [feature[3] for feature in self.nadlesnictwo.getFeatures()]
            self.linie = QgsProject.instance().mapLayersByName('Najbliższe linie energetyczne')[0]
            self.drogi = QgsProject.instance().mapLayersByName('Najbliższe drogi')[0]
            self.obszary = QgsProject.instance().mapLayersByName('Wyznaczone obszary')[0]
            warstwy=[self.obszary, self.drogi, self.linie]
            typy_obrazu = "jpg (*.jpg);;bitmap (*.bmp);;tiff (*.tiff);; pdf (*.pdf)"
            opcje = QFileDialog.Options()
            nazwa_pliku = QFileDialog.getSaveFileName(
                    None, "Zapisz jako ...", "", filter=typy_obrazu, options=opcje)
            
            project = QgsProject.instance()
            layout = QgsPrintLayout(project)
            layout.initializeDefaults()
            map = QgsLayoutItemMap(layout)
            map.setRect(20, 20, 20, 20)
            extent = QgsRectangle()
            nadlesnictwo_geom = next(self.nadlesnictwo.getFeatures(), None)
            if nadlesnictwo_geom:
                extent = nadlesnictwo_geom.geometry().boundingBox()
            extent.scale(1.6) 
            ms = QgsMapSettings()
            ms.setLayers(warstwy)  
            ms.setExtent(extent)
            map.setExtent(extent)
            map.setBackgroundColor(QColor(255,255,255))
            layout.addLayoutItem(map)
            map.attemptMove(QgsLayoutPoint(20, 45, QgsUnitTypes.LayoutMillimeters))
            map.attemptResize(QgsLayoutSize(
                190, 126, QgsUnitTypes.LayoutMillimeters))
            logoLP = QgsLayoutItemPicture(layout)
            logoLP.setResizeMode(QgsLayoutItemPicture.Zoom)
            logoLP.setMode(QgsLayoutItemPicture.FormatRaster)
            logoLP.setPicturePath(':/plugins/photovoltaics_LP/icons/logoLP.png')

            dim_image_original = [300, 300]
            new_dim = [i * 0.6 for i in dim_image_original]
            logoLP.attemptMove(QgsLayoutPoint(20, 10, QgsUnitTypes.LayoutMillimeters))
            logoLP.attemptResize(QgsLayoutSize(*new_dim, QgsUnitTypes.LayoutPixels))
            layout.addLayoutItem(logoLP)

            logoEnv = QgsLayoutItemPicture(layout)
            logoEnv.setResizeMode(QgsLayoutItemPicture.Zoom)
            logoEnv.setMode(QgsLayoutItemPicture.FormatRaster)
            logoEnv.setPicturePath(':/plugins/photovoltaics_LP/icons/logoPL.png')

            dim_image_original = [1588, 401]
            new_dim = [i * 0.4 for i in dim_image_original]
            logoEnv.attemptMove(QgsLayoutPoint(215, 10, QgsUnitTypes.LayoutMillimeters))
            logoEnv.attemptResize(QgsLayoutSize(*new_dim, QgsUnitTypes.LayoutPixels))
            layout.addLayoutItem(logoEnv)

            arrow = QgsLayoutItemPicture(layout)
            arrow.setResizeMode(QgsLayoutItemPicture.Zoom)
            arrow.setMode(QgsLayoutItemPicture.FormatRaster)
            arrow.setPicturePath(':/plugins/photovoltaics_LP/icons/arrow.png')

            dim_image_original = [949, 893]
            new_dim = [i * 0.6 for i in dim_image_original]
            arrow.attemptMove(QgsLayoutPoint(225, 45, QgsUnitTypes.LayoutMillimeters))
            arrow.attemptResize(QgsLayoutSize(*new_dim, QgsUnitTypes.LayoutPixels))
            layout.addLayoutItem(arrow)
            
            title = QgsLayoutItemLabel(layout)
            title.setText("Obszary wyznaczone na potrzeby farm fotowoltaicznych - Nadleśnictwo {}".format(nazwa_nadlesnictwa))
            title.setFont(QFont('Arial', 13))
            title.adjustSizeToText()
            layout.addLayoutItem(title)
            title.attemptMove(QgsLayoutPoint(
                40, 15, QgsUnitTypes.LayoutMillimeters))
            title.attemptResize(QgsLayoutSize(190, 10))
            title.setFrameEnabled(False)

            footer = QgsLayoutItemLabel(layout)
            footer.setText("Wygenerowano przy użyciu wtyczki Fotowoltaika LP")
            footer.setFont(QFont('Arial', 11))
            layout.addLayoutItem(footer)
            footer.attemptMove(QgsLayoutPoint(
                100, 190, QgsUnitTypes.LayoutMillimeters))
            footer.setFrameEnabled(False)

            legend = QgsLayoutItemLegend(layout)
            legend.setLinkedMap(map)
            layerTree = QgsLayerTree()

            for warstwa in warstwy:
                layerTree.addLayer(warstwa)

            legend.model().setRootGroup(layerTree)
            layout.addLayoutItem(legend)
            legend.attemptMove(QgsLayoutPoint(
                215, 107, QgsUnitTypes.LayoutMillimeters))
            scaleBar = QgsLayoutItemScaleBar(layout)
            scaleBar.setStyle('Single Box')
            scaleBar.setFont(QFont("Arial", 9))
            scaleBar.applyDefaultSize(QgsUnitTypes.DistanceMeters)
            scaleBar.setMapUnitsPerScaleBarUnit(1000.0)
            scaleBar.setSegmentSizeMode(QgsScaleBarSettings.SegmentSizeFitWidth)
            scaleBar.setMaximumBarWidth(70)
            scaleBar.setNumberOfSegments(5)
            scaleBar.setUnitsPerSegment(1*1000.0)
            scaleBar.setUnitLabel("km")
            scaleBar.setLinkedMap(map)
            layout.addLayoutItem(scaleBar)
            scaleBar.attemptMove(QgsLayoutPoint(
                215, 161, QgsUnitTypes.LayoutMillimeters))
          
            if nazwa_pliku[0]:
                if  nazwa_pliku[0].endswith('.pdf'):

                    exporter = QgsLayoutExporter(layout)
                    exporter.exportToPdf(
                          nazwa_pliku[0],QgsLayoutExporter.PdfExportSettings())
                    
                    QMessageBox.information(
                            None, "Sukces", "Zapisywanie dokumentu zakończone sukcesem!")
                else:
                    exporter = QgsLayoutExporter(layout)
                    exporter.exportToImage(
                            nazwa_pliku[0], QgsLayoutExporter.ImageExportSettings())
                    QMessageBox.information(
                            None, "Sukces", "Zapisywanie obrazu zakończone sukcesem!")
                    
                
                folder_name = ('/').join(nazwa_pliku[0].split('/')[:-1])
                utils.openFile(folder_name)
        except:
            msg = QMessageBox.critical(
                None, "Spróbuj jeszcze raz", "Problem z zapisem dokumetu")

    def resetuj(self):
        """resetuje dane
        """
        self.wydzielenia = None
        self.wydzielenia_opisy = None
        self.drogi_esne = None
        self.powiaty = None
        self.obszary = None
        self.drogi = None
        self.linie= None
        self.linie_bdot10k = None
        self.oddzialy = None
        self.nadlesnictwo = None
        self.mapa_bazowa = None

        self.pobierzWarstwyPochodneBtn.setEnabled(True)
        self.wczytajBdot10kBtn.setEnabled(False)
        self.analizaBtn.setEnabled(False)
        self.zapisBtn.setEnabled(False)
        self.raportBtn.setEnabled(False)
        self.wydrukBtn.setEnabled(False)
        
    def zamknij(self):
        """zamyka okno wtyczki
        """
        self.close()
    
    def help(self):
        """Otwiera instrukcję obsługi wtyczki w pdf
        """
        try:
            filepath = Path(__file__).parent / "Instrukcja.pdf"
            os.startfile(filepath)

        except:
            msg = QMessageBox.critical(
                None, "Spróbuj jeszcze raz", "Problem z otwarciem pliku pdf")



