from __future__ import annotations

from qgis.core import (
    QgsLineString,
    QgsMultiLineString,
    QgsMultiPoint,
    QgsMultiPolygon,
    QgsPoint,
    QgsPolygon,
    QgsPolyhedralSurface,
    QgsTriangle,
    QgsTriangulatedSurface,
)

Point = tuple[float, ...]
Cell = list[Point, ...]
Triangle = tuple[Point, Point, Point]


def coords2Points(points: list[Point]) -> list[QgsPoint]:
    return [QgsPoint(*coords) for coords in points]


def coords2MultiPoint(points: list[Point]) -> QgsMultiPoint:
    return QgsMultiPoint([QgsPoint(*coords) for coords in points])


def coords2LineString(points: list[Point]) -> QgsLineString:
    return QgsLineString(coords2Points(points))


def coords2MultiLineString(lines: list[Cell]) -> QgsMultiLineString:
    return QgsMultiLineString([coords2LineString(p) for p in lines])


def coords2Polygon(boundary: Cell) -> QgsPolygon:
    return QgsPolygon(QgsLineString(coords2Points(boundary)))


def coords2MultiPolygon(polygons: list[Cell]) -> QgsMultiPolygon:
    return QgsMultiPolygon([coords2Polygon(p) for p in polygons])


def coords2PolyhedralSurface(polygons: list[Cell]) -> QgsPolyhedralSurface:
    return QgsPolyhedralSurface(coords2MultiPolygon(polygons))


def coords2Triangle(points: Triangle) -> QgsTriangle:
    return QgsTriangle(*coords2Points(points))


def coords2Triangles(triangles: list[Triangle]) -> list[QgsTriangle]:
    return [coords2Triangle(tri) for tri in triangles]


def coords2TriangulatedSurface(triangles: list[Triangle]) -> QgsTriangulatedSurface:
    geom = QgsTriangulatedSurface()
    geom.setTriangles(coords2Triangles(triangles))
    return geom
