from __future__ import annotations

from pathlib import Path

from qgis.utils import plugins

from .. import qvSettings


def load_3d_file(file: Path, **kwargs):
    viewer = plugins.get(qvSettings().get("name")).viewer
    if Path(file).suffix.lower() == ".vtm":
        viewer.loader.load_multiblock(file, **kwargs)
    else:
        viewer.loader.load_mesh(file, **kwargs)
    viewer.show()
