from pathlib import Path

from qtpy.QtGui import QIcon


def pvIcon(icon: str = "icon"):
    if isinstance(icon, QIcon):
        return icon
    root = Path(__file__).parent / "icons"
    if root.is_dir():
        asset = next(root.glob(str(Path(icon).with_suffix(".*"))), "")
        return QIcon(str(asset))
    return QIcon()
