from __future__ import annotations

from functools import cached_property

"""QGIS toolbox generation.

    On has to implement QgsProcessingAlgorithm and MUST register them into the ALGORITHMS variable.
    Such algorithms could be inserted/grouped into sub-groups using group/groupId attributes (defaults to root).


    WARNING: Qgis register provider by name,
        if duplicated names exists only the last register loaded will be accessible.
        There is (might be) a need to extend an existing toolbox ... (FIXME)
"""

from qgis.core import QgsProcessingProvider

from .. import pvIcon, pvLayer
from ..settings import qvSettings
from .meshify_raster import MeshifyRaster
from .meshify_vector import MeshifyVector
from .rasterize_top_view import RasterizeTopView
from .vectorify_mesh import VectorifyMesh

ALGORITHMS = [MeshifyRaster, MeshifyVector, RasterizeTopView, VectorifyMesh]


class qvToolbox(QgsProcessingProvider):
    settings: qvSettings = qvSettings()

    def loadAlgorithms(self):
        # add algorithms here
        for Algorithm in ALGORITHMS:
            self.addAlgorithm(Algorithm())

    @classmethod
    def id(cls):
        """The ID of your plugin, used for identifying the provider.

        This string should be a unique, short, character only string,
        eg "qgis" or "gdal". This string should not be localised.
        """
        return (
            str(cls.settings.value("toolbox") or cls.settings.value("name"))
            .lower()
            .replace(" ", "-")
            .replace("-", "_")
        )

    def name(self):
        """The human friendly name of your plugin in Processing.

        This string should be as short as possible (e.g. "Lastools", not
        "Lastools version 1.0.1 64-bit") and localised.
        """
        return self.tr(self.settings.value("toolbox") or self.settings.value("name"))

    def icon(self):
        """Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        icon = pvIcon("toolbox")
        return icon if not icon.isNull() else pvIcon()
