from qtpy.QtGui import QKeySequence
from qtpy.QtWidgets import QMenu, QWidget

from ..core import pvProject
from .action import pvAction
from .project_dlg import pvProjectSettings


class pvProjectMenu(QMenu):
    def __init__(self, project: pvProject, parent: QWidget = None):
        if not isinstance(project, pvProject):
            raise TypeError(project)

        super().__init__("Project", parent)

        self.project = project

        self.addAction(self.new)
        self.addAction(self.load)
        self.addAction(self.save)
        self.addSeparator()
        self.addAction(self.save_as)
        self.addAction(self.package)
        self.addSeparator()
        self.addAction(self.properties)

    @property
    def new(self) -> pvAction:
        return pvAction(
            "New project",
            shortcut=QKeySequence("Ctrl+N"),
            callback=lambda: self.project.clear()
            and pvProjectSettings(self.project).open(),
            parent=self,
        )

    @property
    def load(self) -> pvAction:
        return pvAction(
            "Load project...",
            shortcut=QKeySequence.Open,
            callback=lambda: self.project.load(),
            parent=self,
        )

    @property
    def save(self) -> pvAction:
        return pvAction(
            "Save project",
            shortcut=QKeySequence.Save,
            callback=lambda: self.project.save(),
            parent=self,
        )

    @property
    def save_as(self) -> pvAction:
        return pvAction(
            "Save project as...",
            shortcut=QKeySequence.SaveAs,
            callback=lambda: self.project.saveAs(),
            parent=self,
        )

    @property
    def package(self) -> pvAction:
        return pvAction(
            "Package project...",
            shortcut=QKeySequence("Ctrl+Shift+E"),
            callback=lambda: self.project.package(None),
            parent=self,
        )

    @property
    def properties(self) -> pvAction:
        return pvAction(
            "Properties...",
            shortcut=QKeySequence.Preferences,
            callback=lambda: pvProjectSettings(self.project).open(),
            parent=self,
        )
