from __future__ import annotations

from typing import Any

from qtpy.QtWidgets import QDialog, QFormLayout, QLineEdit, QTextEdit

from . import pvIcon  # , pvProject


class pvProjectSettings(QDialog):
	def __init__(self, project: pvProject):  # noqa: F821
		super().__init__()

		self.setModal(False)  # ignored by self.exec() method !
		self.setWindowIcon(pvIcon("mActionOptions"))
		self.setWindowTitle("Project properties")
		self.setLayout(QFormLayout())

		self.project = project
		# assert isinstance(self.project, pvProject)

		self._init_ui()

	def get(self, name: str):
		return getattr(self.project, name)

	def set(self, name: str, value: Any):
		setattr(self.project, name, value)
		self.project.invalidate()

	def _init_ui(self) -> None:
		_title = QLineEdit(self.get("title"))
		_title.textChanged.connect(lambda s: self.set("title", s))
		self.layout().addRow("title:", _title)
		_description = QTextEdit(self.get("description"))
		_description.textChanged.connect(lambda s: self.set("description", s))
		self.layout().addRow("description:", _description)
		_author = QLineEdit(self.get("author"))
		_author.textChanged.connect(lambda s: self.set("author", s))
		self.layout().addRow("author:", _author)
