from functools import cached_property

from qtpy.QtWidgets import QMenu, QWidget

from ..core import pvLoader
from .action import pvAction


class pvLoaderMenu(QMenu):
	def __init__(self, loader: pvLoader, parent: QWidget = None):
		if not isinstance(loader, pvLoader):
			raise TypeError(loader)

		super().__init__("Layers", parent)

		self.loader = loader

		self.addAction(self.add_mesh)
		self.addAction(self.add_multiblock)
		self.addSeparator()
		self.addAction(self.import_gocad)
		# self.addAction(self.add_vector)

	@cached_property
	def add_mesh(self) -> pvAction:
		return pvAction(
			"Add mesh layer...",
			icon="mActionAdd3DMap",
			callback=self.loader.load_mesh,
			parent=self,
		)

	@cached_property
	def add_multiblock(self) -> pvAction:
		return pvAction(
			"Add multiblock...",
			icon="mActionAddGroup",
			callback=self.loader.load_multiblock,
			parent=self,
		)

	@cached_property
	def import_gocad(self) -> pvAction:
		try:
			active = True
		except ImportError:
			active = False

		return pvAction(
			"Import GOCAD project...",
			callback=self.loader.load_gocad,
			parent=self,
			enable=active,
		)

	# @cached_property
	# def add_raster(self) -> pvAction:
	#     return pvAction(
	#         "Add raster layer...",
	#         icon="grid",
	#         callback=self.loader.load_raster,
	#         parent=self,
	#     )

	# @cached_property
	# def add_vector(self) -> pvAction:
	#     return pvAction(
	#         "Add vector layer...",
	#         icon="mActionAddMeshLayer",
	#         callback=self.loader.load_vector,
	#         parent=self,
	#     )
