from __future__ import annotations

from collections.abc import Callable

from qtpy.QtCore import QObject
from qtpy.QtGui import QKeySequence
from qtpy.QtWidgets import QAction, QApplication

from .icons import pvIcon


class pvAction(QAction):
	def __init__(
		self,
		text: str,
		icon: str | None = None,
		shortcut: QKeySequence = None,
		callback: Callable | None = None,
		enable: bool = True,
		parent: QObject = None,
	) -> QAction:
		super().__init__(QApplication.instance().tr(text), parent=parent)

		if icon:
			self.setIcon(pvIcon(icon))
		if shortcut:
			self.setShortcut(QKeySequence(shortcut))
		if callback:
			self.triggered.connect(callback)
		self.setEnabled(enable)
