from __future__ import annotations

from dataclasses import dataclass
from pathlib import Path
from xml.etree.ElementTree import Element


@dataclass
class pvLayerContext:
	source: str = None
	crs: str = None

	@property
	def is_valid(self):
		return Path(self.source).is_file()

	def to_xml(self):
		return Element("Context", source=str(self.source), crs=str(self.crs))

	@staticmethod
	def from_xml(el: Element):
		if el is None:
			return pvLayerContext()
		return pvLayerContext(**el.attrib)
