from __future__ import annotations

import argparse
import sys

from qtpy.QtWidgets import QApplication

try:
	from . import pvInterface
except ImportError:
	from pvgis import pvInterface

context = QApplication.instance() or QApplication(sys.argv)

parser = argparse.ArgumentParser()
parser.add_argument(
	"project", type=str, nargs="?", help="pvGIS project to open at launch"
)
parser.add_argument(
	"--dummy", help="display dummy geometries menu", action="store_true"
)
args = parser.parse_args()

iface = pvInterface(**args.__dict__)
iface.show()

sys.exit(context.exec())
