from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.core import *
from qgis.gui import *

from PyQt4 import uic

import os
import math

from promaides_raster import Raster


class PluginDialog(QDialog):

   rasterAdded   = pyqtSignal(int, QgsGeometry)
   rasterUpdated = pyqtSignal(int, QgsGeometry)
   rasterRemoved = pyqtSignal(int)

   xllRole      = 111
   yllRole      = 112
   nrRole       = 113
   ncRole       = 114
   drRole       = 115
   dcRole       = 116
   angleRole    = 117
   nodataRole   = 118 
   interpolRole = 119
   fileRole     = 120
   

   def __init__(self, iface, parent=None):
      QDialog.__init__(self, parent)
      
      uiDir = os.path.dirname(os.path.abspath(__file__))
      uic.loadUi(os.path.join(uiDir, 'ui_promaides_dem_export.ui'), self)
      
      self.iface = iface
      
      self.interpolationBox.addItem('nearest neighbor')
      self.interpolationBox.addItem('bi-linear')
      self.interpolationBox.addItem('bi-cubic')
      
      self.picker = QgsMapToolEmitPoint(self.iface.mapCanvas())
      
      self.addButton.clicked.connect(self.addNewRasterItem)
      self.removeButton.clicked.connect(self.removeCurrentRasterItem)
      self.listWidget.currentRowChanged.connect(self.updateRasterPropertiesGroup)
      self.saveButton.clicked.connect(self.saveRasterProperties)
      self.demLayerBox.currentIndexChanged.connect(self.updateBandBox)
      self.browseButton.clicked.connect(self.onBrowseButtonClicked)
      self.pickButton.clicked.connect(self.enableMapPicker)
      self.zoomButton.clicked.connect(self.zoomToRaster)
      self.autoSaveBox.stateChanged.connect(self.enableAutoSave)
      
      self.autoSaveBox.setChecked(True)
      
      self.addButton.setEnabled(False)
      self.zoomButton.setEnabled(False)
      self.removeButton.setEnabled(False)
      self.groupBox.setEnabled(False)
      self.bandBox.setEnabled(False)
      self.ilmBox.setEnabled(False)
      
      self.setupLayerComboBox()
      
   def enableAutoSave(self, state):
      if state == Qt.Checked:
         self.xllBox.editingFinished.connect(self.saveRasterProperties)
         self.yllBox.editingFinished.connect(self.saveRasterProperties)
         self.drBox.editingFinished.connect(self.saveRasterProperties)
         self.dcBox.editingFinished.connect(self.saveRasterProperties)
         self.nrBox.editingFinished.connect(self.saveRasterProperties)
         self.ncBox.editingFinished.connect(self.saveRasterProperties)
         self.angleBox.editingFinished.connect(self.saveRasterProperties)
         self.nodataBox.editingFinished.connect(self.saveRasterPropertiesNoRedraw)
         self.interpolationBox.activated.connect(self.saveRasterPropertiesNoRedraw)
         self.filenameEdit.editingFinished.connect(self.saveRasterPropertiesNoRedraw)
         self.saveButton.setEnabled(False)
      else:
         self.xllBox.editingFinished.disconnect(self.saveRasterProperties)
         self.yllBox.editingFinished.disconnect(self.saveRasterProperties)
         self.drBox.editingFinished.disconnect(self.saveRasterProperties)
         self.dcBox.editingFinished.disconnect(self.saveRasterProperties)
         self.nrBox.editingFinished.disconnect(self.saveRasterProperties)
         self.ncBox.editingFinished.disconnect(self.saveRasterProperties)
         self.angleBox.editingFinished.disconnect(self.saveRasterProperties)
         self.nodataBox.editingFinished.disconnect(self.saveRasterPropertiesNoRedraw)
         self.interpolationBox.activated.disconnect(self.saveRasterPropertiesNoRedraw)
         self.filenameEdit.editingFinished.disconnect(self.saveRasterPropertiesNoRedraw)
         self.saveButton.setEnabled(True)
         
      
   def createIlmFile(self):
      if self.ilmBox.checkState() == Qt.Checked:
         return True
      else:
         return False
      
   def zoomToRaster(self):
   
      item = self.listWidget.selectedItems()[0]
      
      xll = item.data(PluginDialog.xllRole)
      yll = item.data(PluginDialog.yllRole)
      nr = item.data(PluginDialog.nrRole)
      nc = item.data(PluginDialog.ncRole)
      dr = item.data(PluginDialog.drRole)
      dc = item.data(PluginDialog.dcRole)
      angle = item.data(PluginDialog.angleRole)
      
      bb = self.polygon(xll, yll, nc*dc, nr*dr, angle/180.0*math.pi).boundingBox()
      self.iface.mapCanvas().setExtent(bb)
      self.iface.mapCanvas().refresh()
      
   def enableMapPicker(self, clicked):
      if clicked:
         self.picker.canvasClicked.connect(self.onMapClicked)
         self.iface.mapCanvas().setMapTool(self.picker)
      else:
         self.picker.canvasClicked.disconnect(self.onMapClicked)
         self.iface.mapCanvas().unsetMapTool(self.picker)
         
   def onMapClicked(self, point, button):
      if button == Qt.LeftButton:
         self.xllBox.setValue(point.x())
         self.yllBox.setValue(point.y())
         self.xllBox.editingFinished.emit()
      
   def baseLayer(self):
      return self.demLayerBox.itemData(self.demLayerBox.currentIndex())
      
   def band(self):
      return self.bandBox.value()
      
   def rasters(self):
   
      result = []
      for row in range(self.listWidget.count()):
      
         item = self.listWidget.item(row)
         
         xll = item.data(PluginDialog.xllRole)
         yll = item.data(PluginDialog.yllRole)
         nr = item.data(PluginDialog.nrRole)
         nc = item.data(PluginDialog.ncRole)
         dr = item.data(PluginDialog.drRole)
         dc = item.data(PluginDialog.dcRole)
         angle = item.data(PluginDialog.angleRole)
         nodata = item.data(PluginDialog.nodataRole)
         
         raster = Raster(xll, yll, dc, dr, nc, nr, angle/180.0*math.pi, nodata)       
         interpolMode = item.data(PluginDialog.interpolRole)
         filename = item.data(PluginDialog.fileRole)
         
         data = (raster, interpolMode, filename)
         result.append(data)
         
      return result
      
   def setupLayerComboBox(self):
   
      layers = QgsMapLayerRegistry.instance().mapLayers()
      for name, layer in layers.iteritems():
         if layer.type() == QgsMapLayer.RasterLayer:
            self.demLayerBox.addItem(layer.name(), layer)
            
   def onBrowseButtonClicked(self):
      
      currentFilename = self.filenameEdit.text()
      
      filename = QFileDialog.getSaveFileName(self.iface.mainWindow(), 'ProMaIDes DEM Export', currentFilename)
      if filename != '':
         self.filenameEdit.setText(filename)
         self.filenameEdit.editingFinished.emit()
            
   def updateBandBox(self, int):
   
      layer = self.demLayerBox.itemData(self.demLayerBox.currentIndex())
      
      if not layer:
         self.bandBox.setEnabled(False)
         self.addButton.setEnabled(False)
         return
         
      self.bandBox.setEnabled(True)
      self.addButton.setEnabled(True)
      
      self.bandBox.setMaximum(layer.bandCount())
      self.bandBox.setValue(1)
            
   def addNewRasterItem(self):
      
      item = QListWidgetItem('new_raster')
      item.setData(PluginDialog.xllRole,      0.0)
      item.setData(PluginDialog.yllRole,      0.0)
      item.setData(PluginDialog.nrRole,       100)
      item.setData(PluginDialog.ncRole,       100)
      item.setData(PluginDialog.drRole,       1.0)
      item.setData(PluginDialog.dcRole,       1.0)
      item.setData(PluginDialog.angleRole,    0.0)
      item.setData(PluginDialog.nodataRole,   -9999.0)
      item.setData(PluginDialog.interpolRole, 0)
      item.setData(PluginDialog.fileRole,     os.path.join(QDesktopServices.storageLocation(QDesktopServices.DocumentsLocation), 'new_raster.txt'))
      
      item.setFlags(Qt.ItemIsSelectable | Qt.ItemIsEditable | Qt.ItemIsEnabled)
      
      self.removeButton.setEnabled(True)
      self.zoomButton.setEnabled(True)
      self.groupBox.setEnabled(True)
      self.ilmBox.setEnabled(True)
      
      polygon = self.polygon(0.0, 0.0, 100.0, 100.0, 0.0)
      self.rasterAdded.emit(int(self.listWidget.count()+1), polygon)
      
      self.listWidget.addItem(item)
      self.listWidget.setCurrentItem(item)
      
   def polygon(self, xll, yll, dx, dy, angle):
      
      poly = []
      poly.append(QgsPoint(xll, yll))
      poly.append(QgsPoint(xll + dx * math.cos(angle), yll + dx * math.sin(angle)))
      poly.append(QgsPoint(xll + (dx * math.cos(angle) - dy * math.sin(angle)), yll + (dy * math.cos(angle) + dx * math.sin(angle)))) 
      poly.append(QgsPoint(xll -dy * math.sin(angle), yll + dy * math.cos(angle)))
   
      return QgsGeometry.fromPolygon([poly])
      
   def removeCurrentRasterItem(self):
      for item in self.listWidget.selectedItems():
         row = self.listWidget.row(item)
         self.listWidget.takeItem(row)  
         self.rasterRemoved.emit(int(row+1))
         
      if self.listWidget.count() == 0:
         self.zoomButton.setEnabled(False)
         self.removeButton.setEnabled(False)
         self.groupBox.setEnabled(False)
         self.ilmBox.setEnabled(False)
         
   def updateRasterPropertiesGroup(self, row):
   
      item = self.listWidget.item(row)
      if not item:
         return
      
      self.xllBox.setValue(item.data(PluginDialog.xllRole))
      self.yllBox.setValue(item.data(PluginDialog.yllRole))
      self.nrBox.setValue(item.data(PluginDialog.nrRole))
      self.ncBox.setValue(item.data(PluginDialog.ncRole))
      self.drBox.setValue(item.data(PluginDialog.drRole))
      self.dcBox.setValue(item.data(PluginDialog.dcRole))
      self.angleBox.setValue(item.data(PluginDialog.angleRole))
      self.nodataBox.setValue(item.data(PluginDialog.nodataRole))
      self.interpolationBox.setCurrentIndex(item.data(PluginDialog.interpolRole))
      self.filenameEdit.setText(item.data(PluginDialog.fileRole))
      
      
   def saveRasterPropertiesNoRedraw(self):
      self.saveRasterProperties(False)
    
    
   def saveRasterProperties(self, redraw=True):
      
      item = self.listWidget.selectedItems()[0]
      
      xll   = self.xllBox.value()
      yll   = self.yllBox.value()
      dx    = self.ncBox.value() * self.dcBox.value()
      dy    = self.nrBox.value() * self.drBox.value()
      angle = self.angleBox.value()
      
      item.setData(PluginDialog.xllRole,      xll)
      item.setData(PluginDialog.yllRole,      yll)
      item.setData(PluginDialog.nrRole,       self.nrBox.value())
      item.setData(PluginDialog.ncRole,       self.ncBox.value())
      item.setData(PluginDialog.drRole,       self.drBox.value())
      item.setData(PluginDialog.dcRole,       self.dcBox.value())
      item.setData(PluginDialog.angleRole,    angle)
      item.setData(PluginDialog.nodataRole,   self.nodataBox.value())
      item.setData(PluginDialog.interpolRole, self.interpolationBox.currentIndex())
      item.setData(PluginDialog.fileRole,     self.filenameEdit.text())
      
      if redraw:
         self.rasterUpdated.emit(int(self.listWidget.row(item)+1), self.polygon(xll, yll, dx, dy, angle/180.0*math.pi))
      