# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ProjectReportDockWidget
                                 A QGIS plugin
 Generate reports (CSV and HMTMIL) about project, layers, fields and layout
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-01-05
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Patricio Soriano. SIGdeletras.com
        email                : pasoriano@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import shutil

from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
from qgis._core import Qgis

from qgis.core import QgsProject, QgsVectorLayer, QgsWkbTypes, QgsRasterLayer

from .QProjectReport import QProjectReport

from PyQt5.QtWidgets import QMessageBox, QLabel

from qgis.gui import (
    QgsMessageBar,
)

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'project_report_dockwidget_base.ui'))


class ProjectReportDockWidget(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, iface, parent=None):
        """Constructor."""
        super(ProjectReportDockWidget, self).__init__(parent)
        self.setupUi(self)

        self.iface = iface

        self.btnCreateReport.setEnabled(False)
        self.btnCreateReport.clicked.connect(self.check_folder)
        self.directoryWidget.fileChanged.connect(self.set_folder)
        self.folder_path = ''

        self.qgs_project = QgsProject.instance()

        self.check_csv.setChecked(False)
        self.check_html.setChecked(False)

        self.check_project.setChecked(False)
        self.check_vector_layers.setChecked(False)
        self.check_raster_layers.setChecked(False)
        self.check_layouts.setChecked(False)
        self.check_fields.setChecked(False)
        self.check_joins.setChecked(False)
        self.check_relations.setChecked(False)

        self.check_csv.toggled.connect(self.check_options)
        self.check_html.toggled.connect(self.check_options)

        self.check_project.clicked.connect(self.check_options)
        self.check_vector_layers.toggled.connect(self.check_options)
        self.check_raster_layers.toggled.connect(self.check_options)
        self.check_layouts.toggled.connect(self.check_options)
        self.check_fields.toggled.connect(self.check_options)
        self.check_joins.clicked.connect(self.check_options)
        self.check_relations.clicked.connect(self.check_options)

        self.options_outputs = [
            self.check_csv.isChecked(),
            self.check_html.isChecked(),
        ]

        self.options_objets = [
            self.check_project.isChecked(),
            self.check_vector_layers.isChecked(),
            self.check_raster_layers.isChecked(),
            self.check_layouts.isChecked(),
            self.check_fields.isChecked(),
            self.check_relations.isChecked(),
            self.check_joins.isChecked(),
        ]
        self.lb_info.setText('The output directory and at least one object and one type of output must be indicated')

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def check_folder(self):
        """Check if the report folder for the project exists, and delete it if necessary."""

        if os.path.exists(self.project.report_directory):
            reply = QMessageBox.question(self.iface.mainWindow(), 'Folder already exists',
                                         'The report folder <b>%s</b> already exists for this project.<br> '
                                         'If you continue, '
                                         '<b>all the contents in CSV and HTML folders will be deleted</b>.<br> '
                                         'Do you want to continue?' % self.project.report_directory,
                                         QMessageBox.Yes, QMessageBox.No)
            if reply == QMessageBox.Yes:
                reply2 = QMessageBox.question(self.iface.mainWindow(), 'Folder already exists',
                                             'Are you absolutely sure you want '
                                             'to delete <b>ALL</b> the content in the CSV and HTML folders'
                                             'in <b>%s</b>?' % self.project.report_directory,
                                             QMessageBox.Yes, QMessageBox.No)
                if reply2 == QMessageBox.Yes:
                    # shutil.rmtree(self.project.report_directory)
                    self.create_reports()
            else:
                pass
        else:
            self.create_reports()

    def create_reports(self):
        """Generate various reports for the QGIS project depending on the state of various `check_*` attributes."""

        self.project.scaffolding()

        if self.check_project.isChecked() and self.check_csv.isChecked():
            csv_file_name = '01_project'
            csv_column_names = self.project.project_column_names
            csv_rows = self.project.project_data
            self.project.create_csv_file(csv_file_name, csv_column_names, csv_rows, True)

        if self.check_vector_layers.isChecked() and self.check_csv.isChecked():
            csv_file_name = '02_layers_vectorial'
            csv_column_names = self.project.vector_layers_column_names
            csv_rows = self.project.vector_layers_data

            self.project.create_csv_file(csv_file_name, csv_column_names, csv_rows)

        if self.check_raster_layers.isChecked() and self.check_csv.isChecked():
            csv_file_name = '02_layers_raster'
            csv_column_names = self.project.raster_layers_column_names
            csv_rows = self.project.raster_layers_data

            self.project.create_csv_file(csv_file_name, csv_column_names, csv_rows)

        if self.check_fields.isChecked() and self.check_csv.isChecked():
            csv_file_name = '03_fields'
            csv_column_names = self.project.layer_fields_column_names
            csv_rows = self.project.layer_fields_data
            self.project.create_csv_file(csv_file_name, csv_column_names, csv_rows)

        if self.check_relations.isChecked() and self.check_csv.isChecked():
            csv_file_name = '04_relations'
            csv_column_names = self.project.project_relations_column_names
            csv_rows = self.project.project_relations_data
            self.project.create_csv_file(csv_file_name, csv_column_names, csv_rows)

        if self.check_joins.isChecked() and self.check_csv.isChecked():
            csv_file_name = '05_joins'
            csv_column_names = self.project.layer_joins_column_names
            csv_rows = self.project.layer_joins_data
            self.project.create_csv_file(csv_file_name, csv_column_names, csv_rows)

        if self.check_layouts.isChecked() and self.check_csv.isChecked():
            csv_file_name = '06_layouts'
            csv_column_names = self.project.layouts_column_names
            csv_rows = self.project.layouts_data
            self.project.create_csv_file(csv_file_name, csv_column_names, csv_rows)

        if self.check_html.isChecked():
            self.project.create_html(self.options_objets)
        output_dir = f'<a href="file:///{self.project.report_directory}">{self.project.report_directory}</a>'
        success_message = '😎 Project reports have been created in <b>%s</b>' % (
            output_dir)

        self.iface.messageBar().pushMessage("Success", success_message, level=Qgis.Success, duration=10)

    def set_folder(self):
        """Set the output folder for the reports"""
        self.folder_path = self.directoryWidget.filePath()
        self.project = QProjectReport(self.qgs_project, self.folder_path)
        self.check_options()

    def check_options(self):
        """Check the options selected in the GUI and update the state of the "Create Report"
        button and a message label accordingly"""

        self.options_outputs = [
            self.check_csv.isChecked(),
            self.check_html.isChecked(),
        ]

        self.options_objets = [
            self.check_project.isChecked(),
            self.check_vector_layers.isChecked(),
            self.check_raster_layers.isChecked(),
            self.check_fields.isChecked(),
            self.check_layouts.isChecked(),
            self.check_joins.isChecked(),
            self.check_relations.isChecked(),
        ]

        any_check_objets = [False, False, False, False, False, False, False, False]
        any_check_outputs = [False, False]

        if self.options_objets == any_check_objets or self.options_outputs == any_check_outputs \
                or self.folder_path == '':
            self.btnCreateReport.setEnabled(False)
            self.lb_info.setText(
                'The output directory and at least one object and one type of output must be indicated')
        else:
            self.lb_info.setText('')
            self.btnCreateReport.setEnabled(True)
