"""
/***************************************************************************
Name			 	 : Profile from Line
Description          : samples rasters along vector lines
Date                 : 05/Aug/10 
copyright            : (C) 2010 by Ricardo Garcia Silva
email                : ricardo.garcia.silva@gmail.com 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4 import QtCore, QtGui 
from Ui_ProfileFromLine import Ui_ProfileFromLine
import qgis.utils

class ProfileFromLineDialog(QtGui.QDialog):
    def __init__(self, vectorLineLayers, rasterLayers, callbackFunction): 
        QtGui.QDialog.__init__(self) 
        # Set up the user interface from Designer. 
        self.ui = Ui_ProfileFromLine ()
        self.ui.setupUi(self)
        self.vectorLineLayers = vectorLineLayers
        self.rasterLayers = rasterLayers
        self.callbackFunction = callbackFunction
        self.ui.progressBar.setVisible(False)
        self.ui.progressBar.setValue(0)
        activeLayer = qgis.utils.iface.activeLayer()
        self.ui.rastersListWidget.insertItems(0, [ll.name() for ll in self.rasterLayers])
        self.ui.rastersListWidget.setSelectionMode(2) # multiple selection
        self.ui.pointIntervalDoubleSpinBox.setValue(4.0)
        QtCore.QObject.connect(self.ui.buttonBox, QtCore.SIGNAL("helpRequested()"), self._call_help)
        QtCore.QObject.connect(self.ui.linesComboBox,
                QtCore.SIGNAL("currentIndexChanged(int)"),
                self._toggle_selected_feats_cb)
        self.ui.linesComboBox.insertItems(0, [ll.name() for ll in self.vectorLineLayers])
        if activeLayer and activeLayer.type() == 0 and activeLayer.geometryType() == 1:
            indexToSet = self.ui.linesComboBox.findText(activeLayer.name())
            self.ui.linesComboBox.setCurrentIndex(indexToSet)

    def accept(self):
        print(self.ui.selectedFeaturesCheckBox.isChecked())
        params = self._return_parameters()
        self.callbackFunction(params["profiles"], params["rasters"], 
                params["interval"],
                self.ui.selectedFeaturesCheckBox.isChecked(), 
                self.ui.progressBar)
        QtGui.QDialog.accept(self)

    def _toggle_selected_feats_cb(self, index):
        layerName = self.ui.linesComboBox.currentText()
        layer = self.get_layer_by_name(layerName)
        if layer.selectedFeatureCount() > 0:
            self.ui.selectedFeaturesCheckBox.setEnabled(True)
        else:
            self.ui.selectedFeaturesCheckBox.setEnabled(False)
            self.ui.selectedFeaturesCheckBox.setChecked(False)
        
    def get_layer_by_name(self, name):
        vLayer = None
        for layer in self.vectorLineLayers:
            if name == layer.name():
                vLayer = layer
        return vLayer

    def _return_parameters(self):
        lineVectorName = self.ui.linesComboBox.currentText()
        vLayer = self.get_layer_by_name(lineVectorName)
        rasterItemsSelected = self.ui.rastersListWidget.selectedItems()
        rLayers = []
        for item in rasterItemsSelected:
            rasterName = item.text()
            for layer in self.rasterLayers:
                if layer.name() == rasterName:
                    rLayers.append(layer)
        parameters = {"profiles" : vLayer,
                      "rasters" : rLayers, 
                      "interval" : self.ui.pointIntervalDoubleSpinBox.value()}
        return parameters

    def _call_help(self):
        qgis.utils.showPluginHelp()
