params_dict = {
    'Kdown': {'description': 'Incoming shortwave radiation', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'Kup': {'description': 'Outgoing shortwave radiation', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'Ldown': {'description': 'Incoming longwave radiation', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'Lup': {'description': 'Outgoing longwave radiation', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'Tsurf': {'description': 'Bulk surface temperature', 'unit': 'degC', 'format': 'f10.4', 'type': 'A'}, 
    'QN': {'description': 'Net all-wave radiation', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'QF': {'description': 'Anthropogenic heat flux', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'QS': {'description': 'Net storage heat flux', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'QH': {'description': 'Sensible heat flux', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'QE': {'description': 'Latent heat flux', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'QHlumps': {'description': 'Sensible heat flux (using LUMPS)', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'QElumps': {'description': 'Latent heat flux (using LUMPS)', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'QHresis': {'description': 'Sensible heat flux (resistance method)', 'unit': 'W m-2', 'format': 'f10.4', 'type': 'A'}, 
    'Rain': {'description': 'Rain', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'Irr': {'description': 'Irrigation', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'Evap': {'description': 'Evaporation', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'RO': {'description': 'Runoff', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'TotCh': {'description': 'Surface and soil moisture change', 'unit': 'mm', 'format': 'f14.6', 'type': 'S'}, 
    'SurfCh': {'description': 'Surface moisture change', 'unit': 'mm', 'format': 'f14.6', 'type': 'S'}, 
    'State': {'description': 'Surface Wetness State', 'unit': 'mm', 'format': 'f10.4', 'type': 'L'}, 
    'NWtrState': {'description': 'Surface wetness state (non-water surfaces)', 'unit': 'mm', 'format': 'f10.4', 'type': 'L'}, 
    'Drainage': {'description': 'Drainage', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'SMD': {'description': 'Soil Moisture Deficit', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'FlowCh': {'description': 'Additional flow into water body', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'AddWater': {'description': 'Addtional water from other grids', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'ROSoil': {'description': 'Runoff to soil', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'ROPipe': {'description': 'Runoff to pipes', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'ROImp': {'description': 'Runoff over impervious surfaces', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'ROVeg': {'description': 'Runoff over vegetated surfaces', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'ROWater': {'description': 'Runoff for water surface', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'WUInt': {'description': 'InternalWaterUse', 'unit': 'mm', 'format': 'f09.4', 'type': 'S'}, 
    'WUEveTr': {'description': 'Water use for evergreen trees', 'unit': 'mm', 'format': 'f09.4', 'type': 'S'}, 
    'WUDecTr': {'description': 'Water use for deciduous trees', 'unit': 'mm', 'format': 'f09.4', 'type': 'S'}, 
    'WUGrass': {'description': 'Water use for grass', 'unit': 'mm', 'format': 'f09.4', 'type': 'S'}, 
    'SMDPaved': {'description': 'Soil moisture deficit for paved surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'SMDBldgs': {'description': 'Soil moisture deficit for building surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'SMDEveTr': {'description': 'Soil moisture deficit for evergreen tree surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'SMDDecTr': {'description': 'Soil moisture deficit for deciduous tree surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'SMDGrass': {'description': 'Soil moisture deficit for grass surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'SMDBSoil': {'description': 'Soil moisture deficit for bare soil surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'StPaved': {'description': 'Surface wetness state for paved surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'StBldgs': {'description': 'Surface wetness state for building surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'StEveTr': {'description': 'Surface wetness state for evergreen tree surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'StDecTr': {'description': 'Surface wetness state for deciduous tree surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'StGrass': {'description': 'Surface wetness state for grass surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'StBSoil': {'description': 'Surface wetness state for bare soil surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'L'}, 
    'StWater': {'description': 'Surface wetness state for water surface', 'unit': 'mm', 'format': 'f10.4', 'type': 'L'}, 
    'Zenith': {'description': 'Solar zenith angle', 'unit': 'degree', 'format': 'f10.4', 'type': 'L'}, 
    'Azimuth': {'description': 'Solar azimuth angle', 'unit': 'degree', 'format': 'f09.4', 'type': 'L'}, 
    'AlbBulk': {'description': 'Bulk albedo', 'unit': '1', 'format': 'f09.4', 'type': 'A'}, 
    'Fcld': {'description': 'Cloud fraction', 'unit': '1', 'format': 'f09.4', 'type': 'A'}, 
    'LAI': {'description': 'Leaf area index', 'unit': 'm2 m-2', 'format': 'f09.4', 'type': 'A'}, 
    'z0m': {'description': 'Roughness length for momentum', 'unit': 'm', 'format': 'f09.4', 'type': 'A'}, 
    'zdm': {'description': 'Zero-plane displacement height', 'unit': 'm', 'format': 'f09.4', 'type': 'A'},
    'UStar': {'description': 'Friction velocity', 'unit': 'm s-1', 'format': 'f09.4', 'type': 'A'}, 
    'Lob': {'description': 'Obukhov length', 'unit': 'm', 'format': 'f14.6', 'type': 'A'}, 
    'RA': {'description': 'Aerodynamic resistance', 'unit': 's m-1', 'format': 'f10.4', 'type': 'A'}, 
    'RS': {'description': 'Surface resistance', 'unit': 's m-1', 'format': 'f10.4', 'type': 'A'}, 
    'Fc': {'description': 'CO2 flux', 'unit': 'umol m-2 s-1', 'format': 'f09.4', 'type': 'A'}, 
    'FcPhoto': {'description': 'CO2 flux from photosynthesis', 'unit': 'umol m-2 s-1', 'format': 'f09.4', 'type': 'A'}, 
    'FcRespi': {'description': 'CO2 flux from respiration', 'unit': 'umol m-2 s-1', 'format': 'f09.4', 'type': 'A'}, 
    'FcMetab': {'description': 'CO2 flux from metabolism', 'unit': 'umol m-2 s-1', 'format': 'f09.4', 'type': 'A'}, 
    'FcTraff': {'description': 'CO2 flux from traffic', 'unit': 'umol m-2 s-1', 'format': 'f09.4', 'type': 'A'}, 
    'FcBuild': {'description': 'CO2 flux from buildings', 'unit': 'umol m-2 s-1', 'format': 'f09.4', 'type': 'A'},
    'FcPoint': {'description': 'CO2 flux from point source', 'unit': 'umol m-2 s-1', 'format': 'f09.4', 'type': 'A'}, 
    'QNSnowFr': {'description': 'Net all-wave radiation for non-snow area', 'unit': 'W m-2', 'format': 'f09.4', 'type': 'A'}, 
    'QNSnow': {'description': 'Net all-wave radiation for snow area', 'unit': 'W m-2', 'format': 'f09.4', 'type': 'A'}, 
    'AlbSnow': {'description': 'Snow albedo', 'unit': '-', 'format': 'f09.4', 'type': 'A'}, 
    'QM': {'description': 'Snow-related heat exchange', 'unit': 'W m-2', 'format': 'f10.6', 'type': 'A'}, 
    'QMFreeze': {'description': 'Internal energy change', 'unit': 'W m-2', 'format': 'f14.6', 'type': 'A'}, 
    'QMRain': {'description': 'Heat released by rain on snow', 'unit': 'W m-2', 'format': 'f10.6', 'type': 'A'}, 
    'SWE': {'description': 'Snow water equivalent', 'unit': 'mm', 'format': 'f10.4', 'type': 'A'}, 
    'MeltWater': {'description': 'Meltwater', 'unit': 'mm', 'format': 'f10.4', 'type': 'A'}, 
    'MeltWStore': {'description': 'Meltwater store', 'unit': 'mm', 'format': 'f10.4', 'type': 'A'}, 
    'SnowCh': {'description': 'Change in snow pack', 'unit': 'mm', 'format': 'f10.4', 'type': 'S'}, 
    'SnowRPaved': {'description': 'Snow removed from paved surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'S'}, 
    'SnowRBldgs': {'description': 'Snow removed from building surface', 'unit': 'mm', 'format': 'f09.4', 'type': 'S'},
    'Ts': {'description': 'Skin temperature', 'unit': 'degC', 'format': 'f09.4', 'type': 'A'}, 
    'T2': {'description': 'Air temperature at 2 m', 'unit': 'degC', 'format': 'f09.4', 'type': 'A'},
    'Q2': {'description': 'Specific humidity at 2 m', 'unit': 'g kg-1', 'format': 'f09.4', 'type': 'A'},
    'U10': {'description': 'Wind speed at 10 m', 'unit': 'm s-1', 'format': 'f09.4', 'type': 'A'}, 
    'RH2': {'description': 'Relative humidity at 2 m', 'unit': '%', 'format': 'f09.4', 'type': 'A'}
}

unit_dict = {
    'W m-2': r'$W$ $m^{-2}$',
    'mm': r'$mm$',
    'degC': r'$^{o}C$',
    'deg': r'$Degrees(^{o})$',
    '-': r'$-$',
    'm2 m-2': r'$m^{2}$ $m^{-2}$',
    'm': r'$m$',
    'm s-1': r'$m$ $s^{-1}$',
    'umol m-2 s-1': r'$umol^{2}$ $m^{-2}$ $s^{-1}$',
    'YYYY': r'$Year$',
    'DOY': r'$Day\ of\ Year$',
    'HH': r'$Hour$',
    'day': r'$Decimal\ Time$',
    '%': r'$\,\%$',
    '1': r'$1$',
    'degree': r'$^\circ$',
    'g kg-1': r'$g$ $kg^{-1}$',
    's m-1': r'$s$ $m^{-1}$',
}