/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.h2gis.utilities.wrapper.DataSourceWrapper;

public class JDBCUtilities {
    public static final String H2_DRIVER_PACKAGE_NAME = "org.h2.jdbc";
    public static final int POSTGRES_MAX_VARCHAR = 0xA00000;
    public static final String H2_DRIVER_NAME = "H2 JDBC Driver";

    private JDBCUtilities() {
    }

    private static ResultSet getTablesView(Connection connection, String catalog, String schema, String table) throws SQLException {
        Integer n;
        Integer n2;
        Integer catalogIndex = null;
        Integer schemaIndex = null;
        Integer tableIndex = 1;
        StringBuilder sb = new StringBuilder("SELECT * from INFORMATION_SCHEMA.TABLES where ");
        if (!catalog.isEmpty()) {
            sb.append("UPPER(table_catalog) = ? AND ");
            catalogIndex = 1;
            n2 = tableIndex;
            n = tableIndex = Integer.valueOf(tableIndex + 1);
        }
        if (!schema.isEmpty()) {
            sb.append("UPPER(table_schema) = ? AND ");
            schemaIndex = tableIndex;
            n2 = tableIndex;
            n = tableIndex = Integer.valueOf(tableIndex + 1);
        }
        sb.append("UPPER(table_name) = ? ");
        PreparedStatement geomStatement = connection.prepareStatement(sb.toString());
        if (catalogIndex != null) {
            geomStatement.setString(catalogIndex, catalog.toUpperCase());
        }
        if (schemaIndex != null) {
            geomStatement.setString(schemaIndex, schema.toUpperCase());
        }
        geomStatement.setString(tableIndex, table.toUpperCase());
        return geomStatement.executeQuery();
    }

    public static boolean hasField(Connection connection, TableLocation table, String fieldName) throws SQLException {
        return JDBCUtilities.hasField(connection, table.toString(), fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasField(Connection connection, String tableName, String fieldName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            boolean bl;
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableName + " LIMIT 0;");
            try {
                bl = JDBCUtilities.hasField(resultSet.getMetaData(), fieldName);
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            resultSet.close();
            return bl;
        }
    }

    private static boolean hasField(ResultSetMetaData resultSetMetaData, String fieldName) throws SQLException {
        return JDBCUtilities.getFieldIndex(resultSetMetaData, fieldName) != -1;
    }

    public static int getFieldIndex(ResultSetMetaData resultSetMetaData, String fieldName) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        for (int columnId = 1; columnId <= columnCount; ++columnId) {
            if (!fieldName.equalsIgnoreCase(resultSetMetaData.getColumnName(columnId))) continue;
            return columnId;
        }
        return -1;
    }

    public static String getColumnName(ResultSetMetaData resultSetMetaData, Integer columnIndex) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        for (int columnId = 1; columnId <= columnCount; ++columnId) {
            if (columnId != columnIndex) continue;
            return resultSetMetaData.getColumnName(columnId);
        }
        return null;
    }

    public static String getColumnName(Connection connection, TableLocation table, int columnIndex) throws SQLException {
        return JDBCUtilities.getColumnName(connection, table.toString(), columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getColumnName(Connection connection, String tableName, int columnIndex) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String string;
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableName + " LIMIT 0;");
            try {
                string = JDBCUtilities.getColumnName(resultSet.getMetaData(), columnIndex);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return string;
        }
    }

    public static List<String> getColumnNames(Connection connection, TableLocation table) throws SQLException {
        return JDBCUtilities.getColumnNames(connection, table.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getColumnNames(Connection connection, String tableName) throws SQLException {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableName + " LIMIT 0;");){
            ResultSetMetaData metadata = resultSet.getMetaData();
            int columnCount = metadata.getColumnCount();
            for (int columnId = 1; columnId <= columnCount; ++columnId) {
                fieldNameList.add(metadata.getColumnName(columnId));
            }
        }
        return fieldNameList;
    }

    public static List<Tuple<String, Integer>> getColumnNamesAndIndexes(Connection connection, TableLocation table) throws SQLException {
        return JDBCUtilities.getColumnNamesAndIndexes(connection, table.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Tuple<String, Integer>> getColumnNamesAndIndexes(Connection connection, String tableName) throws SQLException {
        ArrayList<Tuple<String, Integer>> fieldNameList = new ArrayList<Tuple<String, Integer>>();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableName + " LIMIT 0;");){
            ResultSetMetaData metadata = resultSet.getMetaData();
            int columnCount = metadata.getColumnCount();
            for (int columnId = 1; columnId <= columnCount; ++columnId) {
                fieldNameList.add(new Tuple<String, Integer>(metadata.getColumnName(columnId), columnId));
            }
        }
        return fieldNameList;
    }

    public static int getRowCount(Connection connection, TableLocation table) throws SQLException {
        return JDBCUtilities.getRowCount(connection, table.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCount(Connection connection, String tableName) throws SQLException {
        int rowCount = 0;
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(String.format("select count(*) rowcount from %s", tableName));){
            if (rs.next()) {
                rowCount = rs.getInt(1);
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTemporaryTable(Connection connection, TableLocation tableLocation) throws SQLException {
        boolean isTemporary;
        block4: {
            isTemporary = false;
            try (ResultSet rs = JDBCUtilities.getTablesView(connection, tableLocation.getCatalog(), tableLocation.getSchema(), tableLocation.getTable());){
                if (rs.next()) {
                    String tableType = JDBCUtilities.hasField(rs.getMetaData(), "STORAGE_TYPE") ? rs.getString("STORAGE_TYPE") : rs.getString("TABLE_TYPE");
                    isTemporary = tableType.contains("TEMPORARY");
                    break block4;
                }
                throw new SQLException("The table " + tableLocation.toString() + " does not exists");
            }
        }
        return isTemporary;
    }

    public static boolean isLinkedTable(Connection connection, TableLocation table) throws SQLException {
        return JDBCUtilities.isLinkedTable(connection, table.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLinkedTable(Connection connection, String tableReference) throws SQLException {
        boolean isLinked;
        block4: {
            String[] location = TableLocation.split(tableReference);
            try (ResultSet rs = JDBCUtilities.getTablesView(connection, location[0], location[1], location[2]);){
                if (rs.next()) {
                    String tableType = rs.getString("STORAGE_TYPE");
                    isLinked = tableType.contains("TABLE LINK");
                    break block4;
                }
                throw new SQLException("The table " + tableReference + " does not exists");
            }
        }
        return isLinked;
    }

    public static boolean isH2DataBase(Connection connection) throws SQLException {
        if (connection.getClass().getName().startsWith(H2_DRIVER_PACKAGE_NAME) || connection.getClass().equals(ConnectionWrapper.class)) {
            return true;
        }
        return connection.getMetaData().getDriverName().equals(H2_DRIVER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIntegerPrimaryKey(Connection connection, TableLocation tableLocation) throws SQLException {
        if (!JDBCUtilities.tableExists(connection, tableLocation)) {
            throw new SQLException("Table " + tableLocation + " not found.");
        }
        DatabaseMetaData meta = connection.getMetaData();
        String columnNamePK = null;
        try (ResultSet rs = meta.getPrimaryKeys(tableLocation.getCatalog(null), tableLocation.getSchema(null), tableLocation.getTable());){
            while (rs.next()) {
                if (tableLocation.getSchema().isEmpty() && !"public".equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
                if (columnNamePK == null) {
                    columnNamePK = rs.getString("COLUMN_NAME");
                    continue;
                }
                columnNamePK = null;
                break;
            }
        }
        if (columnNamePK != null) {
            rs = meta.getColumns(tableLocation.getCatalog(null), tableLocation.getSchema(null), tableLocation.getTable(), columnNamePK);
            try {
                while (rs.next()) {
                    if (tableLocation.getSchema().isEmpty() && !"public".equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
                    int dataType = rs.getInt("DATA_TYPE");
                    if (dataType != -5 && dataType != 4 && dataType != -8) continue;
                    int n = rs.getInt("ORDINAL_POSITION");
                    return n;
                }
            }
            finally {
                rs.close();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple<String, Integer> getIntegerPrimaryKeyNameAndIndex(Connection connection, TableLocation tableLocation) throws SQLException {
        if (!JDBCUtilities.tableExists(connection, tableLocation)) {
            throw new SQLException("Table " + tableLocation + " not found.");
        }
        DatabaseMetaData meta = connection.getMetaData();
        String columnNamePK = null;
        try (ResultSet rs = meta.getPrimaryKeys(tableLocation.getCatalog(null), tableLocation.getSchema(null), tableLocation.getTable());){
            while (rs.next()) {
                if (tableLocation.getSchema().isEmpty() && !"public".equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
                if (columnNamePK == null) {
                    columnNamePK = rs.getString("COLUMN_NAME");
                    continue;
                }
                columnNamePK = null;
                break;
            }
        }
        if (columnNamePK != null) {
            rs = meta.getColumns(tableLocation.getCatalog(null), tableLocation.getSchema(null), tableLocation.getTable(), columnNamePK);
            try {
                while (rs.next()) {
                    if (tableLocation.getSchema().isEmpty() && !"public".equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
                    int dataType = rs.getInt("DATA_TYPE");
                    if (dataType != -5 && dataType != 4 && dataType != -8) continue;
                    Tuple<String, Integer> tuple = new Tuple<String, Integer>(columnNamePK, rs.getInt("ORDINAL_POSITION"));
                    return tuple;
                }
            }
            finally {
                rs.close();
            }
        }
        return null;
    }

    public static boolean tableExists(Connection connection, TableLocation tableLocation) throws SQLException {
        List<String> tableNames = JDBCUtilities.getTableNames(connection, tableLocation.getCatalog().isEmpty() ? null : tableLocation.getCatalog(), tableLocation.getSchema().isEmpty() ? null : tableLocation.getSchema(), null, new String[]{"TABLE", "VIEW", "SYSTEM TABLE"});
        for (String matchTableName : tableNames) {
            TableLocation matchTableNameLocation = TableLocation.parse(matchTableName, tableLocation.getDbTypes());
            if (!tableLocation.getTable().equals(matchTableNameLocation.getTable()) || (!tableLocation.getSchema().isEmpty() || !matchTableNameLocation.getSchema().equalsIgnoreCase("public")) && !tableLocation.getSchema().equals(matchTableNameLocation.getSchema())) continue;
            return true;
        }
        return false;
    }

    public static boolean tableExists(Connection connection, String tableName) throws SQLException {
        DBTypes dbTypes = DBUtils.getDBType(connection);
        return JDBCUtilities.tableExists(connection, TableLocation.parse(tableName, dbTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTableNames(Connection connection, TableLocation tableLocation, String[] types) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        try (ResultSet rs = connection.getMetaData().getTables(tableLocation.getCatalog(), tableLocation.getSchema("PUBLIC"), tableLocation.getTable().replace("\"", ""), types);){
            while (rs.next()) {
                tableList.add(new TableLocation(rs).toString(tableLocation.getDbTypes()));
            }
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTableNames(Connection connection, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        ResultSet rs = connection.getMetaData().getTables(catalog, schemaPattern, tableNamePattern, types);
        DBTypes dbType = DBUtils.getDBType(connection);
        try {
            while (rs.next()) {
                tableList.add(new TableLocation(rs).toString(dbType));
            }
        }
        finally {
            rs.close();
        }
        return tableList;
    }

    public static List<String> getUniqueFieldValues(Connection connection, TableLocation table, String fieldName) throws SQLException {
        return JDBCUtilities.getUniqueFieldValues(connection, table.toString(), fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getUniqueFieldValues(Connection connection, String tableName, String fieldName) throws SQLException {
        DBTypes dbType = DBUtils.getDBType(connection);
        ArrayList<String> fieldValues = new ArrayList<String>();
        try (Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery("SELECT DISTINCT " + TableLocation.quoteIdentifier(fieldName) + " FROM " + TableLocation.parse(tableName).toString(dbType));){
            while (result.next()) {
                fieldValues.add(result.getString(1));
            }
        }
        return fieldValues;
    }

    public static void createEmptyTable(Connection connection, TableLocation table) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE " + table.toString() + " ()");
        }
    }

    public static void createEmptyTable(Connection connection, String tableReference) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE " + tableReference + " ()");
        }
    }

    public static List<String> getColumnNames(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        int cols = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(resultSetMetaData.getColumnName(i));
        }
        return columnNames;
    }

    public static DataSource wrapSpatialDataSource(DataSource dataSource) {
        try {
            if (dataSource.isWrapperFor(DataSourceWrapper.class)) {
                return dataSource;
            }
            return new DataSourceWrapper(dataSource);
        }
        catch (SQLException ex) {
            return new DataSourceWrapper(dataSource);
        }
    }

    public static Connection wrapConnection(Connection connection) {
        try {
            if (connection.isWrapperFor(ConnectionWrapper.class)) {
                return connection;
            }
            return new ConnectionWrapper(connection);
        }
        catch (SQLException ex) {
            return new ConnectionWrapper(connection);
        }
    }

    public static PropertyChangeListener attachCancelResultSet(Statement st, ProgressVisitor progressVisitor) {
        CancelResultSet propertyChangeListener = new CancelResultSet(st);
        progressVisitor.addPropertyChangeListener("CANCELED", (PropertyChangeListener)propertyChangeListener);
        return propertyChangeListener;
    }

    public static TABLE_TYPE getTableType(Connection connection, TableLocation location) throws SQLException {
        DBTypes dbType = location.getDbTypes();
        try (ResultSet rs = JDBCUtilities.getTablesView(connection, location.getCatalog(), location.getSchema(), location.getTable());){
            if (rs.next()) {
                if (dbType == DBTypes.H2) {
                    String storage = rs.getString("STORAGE_TYPE");
                    if (storage.contains("TEMPORARY")) {
                        TABLE_TYPE tABLE_TYPE = TABLE_TYPE.TEMPORARY;
                        return tABLE_TYPE;
                    }
                    if (storage.equals("TABLE LINK")) {
                        TABLE_TYPE tABLE_TYPE = TABLE_TYPE.TABLE_LINK;
                        return tABLE_TYPE;
                    }
                    TABLE_TYPE tABLE_TYPE = TABLE_TYPE.fromString(rs.getString("TABLE_TYPE"));
                    return tABLE_TYPE;
                }
                TABLE_TYPE tABLE_TYPE = TABLE_TYPE.fromString(rs.getString("TABLE_TYPE"));
                return tABLE_TYPE;
            }
            throw new SQLException("The table " + location + " does not exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createTableDDL(Connection connection, TableLocation sourceTable, TableLocation targetTable) throws SQLException {
        if (sourceTable == null) {
            throw new SQLException("The source table name cannot be null or empty");
        }
        if (targetTable == null) {
            throw new SQLException("The target table name cannot be null or empty");
        }
        if (JDBCUtilities.tableExists(connection, sourceTable)) {
            StringBuilder builder = new StringBuilder(256);
            LinkedHashMap<String, GeometryMetaData> geomMetadatas = GeometryTableUtilities.getMetaData(connection, sourceTable);
            builder.append("CREATE TABLE ").append(targetTable);
            try (Statement statement = connection.createStatement();){
                String string;
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + sourceTable.toString() + " LIMIT 0;");
                try {
                    ResultSetMetaData metadata = resultSet.getMetaData();
                    int columnCount = metadata.getColumnCount();
                    if (columnCount > 0) {
                        builder.append(" (");
                    }
                    for (int i = 1; i <= columnCount; ++i) {
                        if (i > 1) {
                            builder.append(",");
                        }
                        String columnName = metadata.getColumnName(i);
                        String columnTypeName = metadata.getColumnTypeName(i);
                        int columnType = metadata.getColumnType(i);
                        if (columnType == 12 || columnType == -1 || columnType == -9 || columnType == -16) {
                            int precision = metadata.getPrecision(i);
                            if (precision > 0xA00000) {
                                builder.append(columnName).append(" ").append(columnTypeName);
                                continue;
                            }
                            builder.append(columnName).append(" ").append(columnTypeName);
                            builder.append("(").append(precision).append(")");
                            continue;
                        }
                        if (columnType == 1) {
                            builder.append(columnName).append(" ").append(columnTypeName);
                            builder.append("(").append(metadata.getColumnDisplaySize(i)).append(")");
                            continue;
                        }
                        if (columnType == 8) {
                            builder.append(columnName).append(" ").append("DOUBLE PRECISION");
                            continue;
                        }
                        if (columnTypeName.toLowerCase().startsWith("geometry")) {
                            if (geomMetadatas.isEmpty()) {
                                builder.append(columnName).append(" ").append(columnTypeName);
                                continue;
                            }
                            GeometryMetaData geomMetadata = geomMetadatas.get(columnName);
                            if (geomMetadata.getGeometryTypeCode() == 0 && geomMetadata.getSRID() == 0) {
                                builder.append(columnName).append(" ").append(columnTypeName);
                                continue;
                            }
                            builder.append(columnName).append(" ").append("GEOMETRY").append("(").append(geomMetadata.getGeometryType()).append(",").append(geomMetadata.getSRID()).append(")");
                            continue;
                        }
                        if (columnTypeName.equalsIgnoreCase("decfloat")) {
                            builder.append(columnName).append(" FLOAT");
                            continue;
                        }
                        builder.append(columnName).append(" ").append(columnTypeName);
                    }
                    if (columnCount > 0) {
                        builder.append(")");
                    }
                    string = builder.toString();
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return string;
            }
        }
        throw new SQLException("The table " + sourceTable + " doesn't exist");
    }

    public static String createTableDDL(Connection connection, TableLocation location) throws SQLException {
        return JDBCUtilities.createTableDDL(connection, location, location);
    }

    public static String createTableDDL(ResultSet resultSet, String outputTableName) throws SQLException {
        return JDBCUtilities.createTableDDL(resultSet.getMetaData(), outputTableName);
    }

    public static String createTableDDL(ResultSetMetaData metadata, String outputTableName) throws SQLException {
        if (outputTableName == null || outputTableName.isEmpty()) {
            throw new SQLException("The target table name cannot be null or empty");
        }
        StringBuilder builder = new StringBuilder(256);
        builder.append("CREATE TABLE ").append(outputTableName);
        int columnCount = metadata.getColumnCount();
        if (columnCount > 0) {
            builder.append(" (");
        }
        for (int i = 1; i <= columnCount; ++i) {
            if (i > 1) {
                builder.append(",");
            }
            String columnName = metadata.getColumnName(i);
            String columnTypeName = metadata.getColumnTypeName(i);
            int columnType = metadata.getColumnType(i);
            if (columnType == 12 || columnType == -1 || columnType == -9 || columnType == -16) {
                int precision = metadata.getPrecision(i);
                if (precision > 0xA00000) {
                    builder.append(columnName).append(" ").append(columnTypeName);
                    continue;
                }
                builder.append(columnName).append(" ").append(columnTypeName);
                builder.append("(").append(precision).append(")");
                continue;
            }
            if (columnType == 1) {
                builder.append(columnName).append(" ").append(columnTypeName);
                builder.append("(").append(metadata.getColumnDisplaySize(i)).append(")");
                continue;
            }
            if (columnType == 8) {
                builder.append(columnName).append(" ").append("DOUBLE PRECISION");
                continue;
            }
            if (columnTypeName.toLowerCase().startsWith("geometry")) {
                builder.append(columnName).append(" ").append(columnTypeName);
                continue;
            }
            if (columnTypeName.equalsIgnoreCase("decfloat")) {
                builder.append(columnName).append(" FLOAT");
                continue;
            }
            builder.append(columnName).append(" ").append(columnTypeName);
        }
        if (columnCount > 0) {
            builder.append(")");
        }
        return builder.toString();
    }

    public static boolean isIndexed(Connection connection, String tableName, String columnName) throws SQLException {
        return JDBCUtilities.isIndexed(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)), columnName);
    }

    public static boolean isIndexed(Connection connection, TableLocation table, String columnName) throws SQLException {
        if (connection == null || table == null) {
            throw new SQLException("Unable to get the index names");
        }
        DBTypes dbTypes = table.getDbTypes();
        columnName = TableLocation.capsIdentifier(columnName, dbTypes);
        DatabaseMetaData md = connection.getMetaData();
        ResultSet indexInfo = md.getIndexInfo(connection.getCatalog(), table.getSchema(), table.getTable(), false, true);
        while (indexInfo.next()) {
            if (!columnName.equals(indexInfo.getString("COLUMN_NAME"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpatialIndexed(Connection connection, String tableName, String columnName) throws SQLException {
        return JDBCUtilities.isSpatialIndexed(connection, TableLocation.parse(tableName, DBUtils.getDBType(connection)), columnName);
    }

    public static boolean isSpatialIndexed(Connection connection, TableLocation table, String columnName) throws SQLException {
        if (connection == null || columnName == null || table == null) {
            throw new SQLException("Unable to find an index");
        }
        DBTypes dbType = table.getDbTypes();
        if (dbType == DBTypes.H2 || dbType == DBTypes.H2GIS) {
            PreparedStatement ps = connection.prepareStatement("SELECT INDEX_NAME FROM INFORMATION_SCHEMA.INDEX_COLUMNS WHERE INFORMATION_SCHEMA.INDEX_COLUMNS.TABLE_NAME=? AND INFORMATION_SCHEMA.INDEX_COLUMNS.TABLE_SCHEMA=? AND INFORMATION_SCHEMA.INDEX_COLUMNS.COLUMN_NAME=?AND INFORMATION_SCHEMA.INDEX_COLUMNS.INDEX_NAME IN (SELECT INDEX_NAME FROM INFORMATION_SCHEMA.INDEXES  WHERE INFORMATION_SCHEMA.INDEXES.TABLE_SCHEMA=? AND  INFORMATION_SCHEMA.INDEXES.TABLE_NAME= ?   AND INFORMATION_SCHEMA.INDEXES.INDEX_TYPE_NAME='SPATIAL INDEX')");
            String tableName = table.getTable();
            String schemaName = table.getSchema("PUBLIC");
            ps.setObject(1, tableName);
            ps.setObject(2, schemaName);
            ps.setObject(3, TableLocation.capsIdentifier(columnName, dbType));
            ps.setObject(4, schemaName);
            ps.setObject(5, tableName);
            ResultSet rs = ps.executeQuery();
            return rs.next();
        }
        if (dbType == DBTypes.POSTGIS || dbType == DBTypes.POSTGRESQL) {
            String query = "SELECT  cls.relname, am.amname FROM  pg_class cls JOIN pg_am am ON am.oid=cls.relam where cls.oid  in(select attrelid as pg_class_oid from pg_catalog.pg_attribute  where attname = ? and attrelid in (select b.oid from pg_catalog.pg_indexes a, pg_catalog.pg_class b  where a.schemaname =? and a.tablename =? and a.indexname = b.relname)) and am.amname = 'gist' ;";
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setObject(1, columnName);
            ps.setObject(2, table.getSchema("public"));
            ps.setObject(3, table.getTable());
            ResultSet rs = ps.executeQuery();
            return rs.next();
        }
        throw new SQLException("Database not supported");
    }

    public static boolean createIndex(Connection connection, TableLocation table, String columnName) throws SQLException {
        if (connection == null || table == null || columnName == null) {
            throw new SQLException("Unable to create an index");
        }
        DBTypes dbType = table.getDbTypes();
        String tableName = table.toString();
        connection.createStatement().execute("CREATE INDEX IF NOT EXISTS " + tableName + "_" + columnName + " ON " + tableName + " (" + TableLocation.capsIdentifier(columnName, dbType) + ")");
        return true;
    }

    public static boolean createIndex(Connection connection, String table, String columnName) throws SQLException {
        return JDBCUtilities.createIndex(connection, TableLocation.parse(table, DBUtils.getDBType(connection)), columnName);
    }

    public static boolean createSpatialIndex(Connection connection, TableLocation table, String columnName) throws SQLException {
        if (connection == null || table == null || columnName == null) {
            throw new SQLException("Unable to create a spatial index");
        }
        DBTypes dbTypes = table.getDbTypes();
        if (dbTypes == DBTypes.H2GIS || dbTypes == DBTypes.POSTGIS || dbTypes == DBTypes.H2 || dbTypes == DBTypes.POSTGRESQL) {
            if (dbTypes == DBTypes.H2 || dbTypes == DBTypes.H2GIS) {
                connection.createStatement().execute("CREATE SPATIAL INDEX IF NOT EXISTS " + table.toString() + "_" + columnName + " ON " + table.toString() + " (" + TableLocation.capsIdentifier(columnName, dbTypes) + ")");
            } else {
                connection.createStatement().execute("CREATE INDEX IF NOT EXISTS " + table.toString() + "_" + columnName + " ON " + table.toString() + " USING GIST (" + TableLocation.capsIdentifier(columnName, dbTypes) + ")");
            }
            return true;
        }
        throw new SQLException("DataBase not supported");
    }

    public static boolean createSpatialIndex(Connection connection, String table, String columnName) throws SQLException {
        return JDBCUtilities.createSpatialIndex(connection, TableLocation.parse(table, DBUtils.getDBType(connection)), columnName);
    }

    public static void dropIndex(Connection connection, TableLocation table, String columnName) throws SQLException {
        List<String> indexes = JDBCUtilities.getIndexNames(connection, table, columnName);
        String query = indexes.stream().map(key -> "DROP INDEX " + key).collect(Collectors.joining(";"));
        connection.createStatement().execute(query);
    }

    public static Map<String, String> getIndexNames(Connection connection, String table) throws SQLException {
        return JDBCUtilities.getIndexNames(connection, TableLocation.parse(table, DBUtils.getDBType(connection)));
    }

    public static Map<String, String> getIndexNames(Connection connection, TableLocation table) throws SQLException {
        if (connection == null || table == null) {
            throw new SQLException("Unable to get the index names");
        }
        DatabaseMetaData md = connection.getMetaData();
        HashMap<String, String> indexes = new HashMap<String, String>();
        ResultSet indexInfo = md.getIndexInfo(connection.getCatalog(), table.getSchema(), table.getTable(), false, true);
        while (indexInfo.next()) {
            String indexName = indexInfo.getString("INDEX_NAME");
            String columnName = indexInfo.getString("COLUMN_NAME");
            indexes.put(indexName, columnName);
        }
        return indexes;
    }

    public static List<String> getIndexNames(Connection connection, String table, String columnName) throws SQLException {
        return JDBCUtilities.getIndexNames(connection, TableLocation.parse(table, DBUtils.getDBType(connection)), columnName);
    }

    public static List<String> getIndexNames(Connection connection, TableLocation table, String columnName) throws SQLException {
        if (connection == null || table == null) {
            throw new SQLException("Unable to get the index names");
        }
        DBTypes dbTypes = table.getDbTypes();
        columnName = TableLocation.capsIdentifier(columnName, dbTypes);
        DatabaseMetaData md = connection.getMetaData();
        ArrayList<String> indexes = new ArrayList<String>();
        ResultSet indexInfo = md.getIndexInfo(connection.getCatalog(), table.getSchema(), table.getTable(), false, true);
        while (indexInfo.next()) {
            if (!columnName.equals(indexInfo.getString("COLUMN_NAME"))) continue;
            indexes.add(indexInfo.getString("INDEX_NAME"));
        }
        return indexes;
    }

    public static void dropIndex(Connection connection, String table, String columnName) throws SQLException {
        JDBCUtilities.dropIndex(connection, TableLocation.parse(table, DBUtils.getDBType(connection)), columnName);
    }

    public static void dropIndex(Connection connection, TableLocation table) throws SQLException {
        if (connection == null || table == null) {
            throw new SQLException("Unable to drop index");
        }
        Map<String, String> indexes = JDBCUtilities.getIndexNames(connection, table);
        String query = indexes.keySet().stream().map(key -> "DROP INDEX " + key).collect(Collectors.joining(";"));
        connection.createStatement().execute(query);
    }

    public static void dropIndex(Connection connection, String table) throws SQLException {
        JDBCUtilities.dropIndex(connection, TableLocation.parse(table, DBUtils.getDBType(connection)));
    }

    public static List<String> getNumericColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int columnId = 1; columnId <= columnCount; ++columnId) {
            if (!JDBCUtilities.isNumeric(resultSetMetaData.getColumnType(columnId))) continue;
            fieldNameList.add(resultSetMetaData.getColumnName(columnId));
        }
        return fieldNameList;
    }

    public static List<String> getNumericColumns(Connection connection, TableLocation table) throws SQLException {
        return JDBCUtilities.getNumericColumns(connection, table.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getNumericColumns(Connection connection, String tableName) throws SQLException {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableName + " LIMIT 0;");){
            ResultSetMetaData metadata = resultSet.getMetaData();
            int columnCount = metadata.getColumnCount();
            for (int columnId = 1; columnId <= columnCount; ++columnId) {
                if (!JDBCUtilities.isNumeric(metadata.getColumnType(columnId))) continue;
                fieldNameList.add(metadata.getColumnName(columnId));
            }
        }
        return fieldNameList;
    }

    public static String getFirstNumericColumn(ResultSetMetaData resultSetMetaData) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        for (int columnId = 1; columnId <= columnCount; ++columnId) {
            if (!JDBCUtilities.isNumeric(resultSetMetaData.getColumnType(columnId))) continue;
            return resultSetMetaData.getColumnName(columnId);
        }
        return null;
    }

    public static String getFirstNumericColumn(Connection connection, TableLocation table) throws SQLException {
        return JDBCUtilities.getFirstNumericColumn(connection, table.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstNumericColumn(Connection connection, String tableName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String string;
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableName + " LIMIT 0;");
            try {
                string = JDBCUtilities.getFirstNumericColumn(resultSet.getMetaData());
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return string;
        }
    }

    public static boolean isNumeric(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static String getFirstAutoIncrementColumn(Connection connection, TableLocation tableLocation) throws SQLException {
        if (!JDBCUtilities.tableExists(connection, tableLocation)) {
            throw new SQLException("Table " + tableLocation + " not found.");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        try (ResultSet columns = databaseMetaData.getColumns(null, null, tableLocation.getTable(), null);){
            while (columns.next()) {
                if (!columns.getBoolean("IS_AUTOINCREMENT")) continue;
                String string = columns.getString("COLUMN_NAME");
                return string;
            }
        }
        return null;
    }

    public static String getFirstAutoIncrementColumn(Connection connection, String tableName) throws SQLException {
        if (!JDBCUtilities.tableExists(connection, tableName)) {
            throw new SQLException("Table " + tableName + " not found.");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        try (ResultSet columns = databaseMetaData.getColumns(null, null, tableName, null);){
            while (columns.next()) {
                if (!columns.getBoolean("IS_AUTOINCREMENT")) continue;
                String string = columns.getString("COLUMN_NAME");
                return string;
            }
        }
        return null;
    }

    private static final class CancelResultSet
    implements PropertyChangeListener {
        private final Statement st;

        private CancelResultSet(Statement st) {
            this.st = st;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this.st.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static enum FUNCTION_TYPE {
        ALL,
        BUILT_IN,
        ALIAS;

    }

    public static enum TABLE_TYPE {
        TABLE,
        VIEW,
        FOREIGN_TABLE,
        TEMPORARY,
        TABLE_LINK,
        UNKOWN;


        public static TABLE_TYPE fromString(String table_type_name) {
            String token;
            String string = token = table_type_name == null ? "" : table_type_name;
            if (token.contains("BASE TABLE")) {
                return TABLE;
            }
            if (token.equals("TABLE")) {
                return TABLE;
            }
            if (token.contains("SYSTEM TABLE")) {
                return TABLE;
            }
            if (token.contains("VIEW")) {
                return VIEW;
            }
            if (token.contains("FOREIGN TABLE")) {
                return FOREIGN_TABLE;
            }
            if (token.contains("TEMPORARY")) {
                return TEMPORARY;
            }
            if (token.contains("TABLE LINK")) {
                return TABLE_LINK;
            }
            return UNKOWN;
        }
    }
}

