/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.util.Map;
import org.cts.CRSHelper;
import org.cts.Identifier;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.parser.proj.ProjParser;
import org.cts.registry.Registry;
import org.cts.registry.RegistryException;

public abstract class AbstractProjRegistry
implements Registry {
    protected final ProjParser projParser = new ProjParser(this);

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem(Identifier identifier) throws RegistryException, CRSException {
        String title;
        Map<String, String> params = this.getParameters(identifier.getAuthorityKey());
        if (!identifier.getAuthorityName().equalsIgnoreCase(this.getRegistryName())) {
            throw new RegistryException("CRS code '" + identifier.getCode() + "' does not match this registry name : " + this.getRegistryName());
        }
        if (params == null) {
            throw new CRSException("Registry '" + this.getRegistryName() + "' contains no parameter for " + String.valueOf(identifier));
        }
        if ((identifier.getName() == null || identifier.getName().isEmpty()) && (title = params.get("title")) != null && !title.isEmpty()) {
            identifier = new Identifier(identifier.getAuthorityName(), identifier.getAuthorityKey(), title);
        }
        return CRSHelper.createCoordinateReferenceSystem(identifier, params);
    }

    public abstract Map<String, String> getParameters(String var1) throws RegistryException;
}

